<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Artvar extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdvari;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dsvari;

  /**
   *
   * @var string
   * @Column(type="string", nullable=false)
   */
  public $preagg;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('artvar');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdarti' => isset($rec->cdarti) && (string)$rec->cdarti !== '' ? (string)$rec->cdarti : new RawValue('""'),
      'cdvari' => isset($rec->cdvari) && (string)$rec->cdvari !== '' ? (string)$rec->cdvari : new RawValue('""'),
      'dsvari' => isset($rec->dsvari) && (string)$rec->dsvari !== '' ? (string)$rec->dsvari : new RawValue('""'),
      'preagg' => isset($rec->preagg) && (string)$rec->preagg !== '' ? (string)$rec->preagg : 0
    );

    $query  = 'cdarti = :cdarti: AND cdvari = :cdvari:';
    $params = array(
      'cdarti' => $values['cdarti'],
      'cdvari' => $values['cdvari']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Artvar objects
   */
  public static function getAllVariationsForArticle($cdarti) {
    $query = "SELECT a.cdvari, a.dsvari, a.preagg
      FROM Go2B\Models\Artvar a
      WHERE a.cdarti = :cdarti:
      ORDER BY a.cdarti";
    return DI::getDefault()->get('modelsManager')->executeQuery($query, array('cdarti' => $cdarti));
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE artvar";
    DI::getDefault()->get('db')->query($query);
  }
  //endregion
}
