<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Artcrt extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpinpu;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $codice;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $tpcrar;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $valore;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('artcrt');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'tpinpu' => isset($rec->tpinpu) && (string)$rec->tpinpu !== '' ? (string)$rec->tpinpu : new RawValue('""'),
      'codice' => isset($rec->codice) && (string)$rec->codice !== '' ? (string)$rec->codice : new RawValue('""'),
      'tpcrar' => isset($rec->tpcrar) && (string)$rec->tpcrar !== '' ? (string)$rec->tpcrar : new RawValue('""'),
      'valore' => isset($rec->valore) && (string)$rec->valore !== '' ? (string)$rec->valore : new RawValue('""')
    );

    $query  = 'tpinpu = :tpinpu: AND codice = :codice: AND tpcrar = :tpcrar:';
    $params = array(
      'tpinpu' => $values['tpinpu'],
      'codice' => $values['codice'],
      'tpcrar' => $values['tpcrar']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Artcrt objects
   */
  public static function getAllAdditionalTypeFromCatalog($cdcata, $items, $tpinpu, $tpcrar) {
    $params = array('cdcata' => $cdcata, 'tpcrar' => $tpcrar);

    $andWhere = '';
    if ($tpinpu == 'AN') {
      $innerJoinAnaart = 'INNER JOIN Go2B\Models\Tipolo tp ON ac.codice = tp.cdartn
                          INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn';
    } else {
      $innerJoinAnaart = 'INNER JOIN Go2B\Models\Anaart aa ON ac.codice = aa.cdarti
                          INNER JOIN Go2B\Models\Tipolo tp ON aa.cdartn = tp.cdartn';
    }

    $innerJoinAnaper = '';
    if (isset($items['cdpers'])) {
      $params['cdpers'] = $items['cdpers'];
      $andWhere .= ' AND ap.cdpers = :cdpers: ';
      $innerJoinAnaper = 'INNER JOIN Go2B\Models\Anaper ap ON ap.cdpers = aa.cdpers ';
    }

    $join = '';
    if ($items['from'] != 'all') {
      switch ($items['from']) {
        case 'sermod':
          $params['code1'] = $items['code1'];
          $params['code2'] = $items['code2'];
          $andWhere .= ' AND tp.cdlinm = :code1: AND tp.cdserm = :code2: ';
          break;
        case 'linmod':
          $params['code'] = $items['code'];
          $andWhere .= ' AND tp.cdlinm = :code: ';
          break;
        case 'titlin':
          $params['code'] = $items['code'];
          $join = 'INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
                   INNER JOIN Go2B\Models\Titlin tl ON tl.cdtitl = lm.cdtitl';
          $andWhere .= ' AND tl.cdtitl = :code: ';
          break;
      }
    }

    $query = "SELECT DISTINCT ac.valore AS codice, ac.valore AS descri
      FROM Go2B\Models\Artcrt ac
      $innerJoinAnaart
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      $innerJoinAnaper
      $join
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      WHERE ca.cdcata = :cdcata: AND ac.tpcrar = :tpcrar:
      $andWhere
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY ac.valore ";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Artcrt objects
   */
  public static function getGroupingForCurrentModel($cdcata, $cdartn) {
    $params = array('cdcata' => $cdcata, 'cdartn' => $cdartn);

    $query = "SELECT DISTINCT ac.tpcrar, ac.valore
      FROM Go2B\Models\Artcrt ac
      INNER JOIN Go2B\Models\Anaart aa ON ac.codice = aa.cdarti
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      WHERE ca.cdcata = :cdcata: AND tp.cdartn = :cdartn:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      GROUP BY ac.valore ";

    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function emptyTable() {
    $query = 'DELETE ac.*
      FROM artcrt ac';
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
