<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Artcol extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdarti;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdcolo;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dscolo;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $flbloc;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $flimag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('artcol');
  }

  /**
   * Allows to query the first customer by key 'tpanag,cdanag'
   *
   * @param mixed $parameters
   * @return Artcol
   */
  public static function findFirstByKey($cdarti, $cdcolo) {
    return parent::findFirst(array('cdarti = :cdarti: AND cdcolo = :cdcolo:', 'bind' => array('cdarti' => $cdarti, 'cdcolo' => $cdcolo)));
  }
  //endregion

  //region Sync functions
  /**
   * Save flawlessly record
   */
  public static function safelySave($artcol) {
    $artcol->save(array(
      'cdarti' => (string)$artcol->cdarti !== '' ? (string)$artcol->cdarti : new RawValue('""'),
      'cdcolo' => (string)$artcol->cdcolo !== '' ? (string)$artcol->cdcolo : new RawValue('""'),
      'dscolo' => (string)$artcol->dscolo !== '' ? (string)$artcol->dscolo : new RawValue('""'),
      'flbloc' => (string)$artcol->flbloc !== '' ? (string)$artcol->flbloc : 0,
      'flimag' => (string)$artcol->flimag !== '' ? (string)$artcol->flimag : new RawValue('""')
    ));
  }

  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdarti' => isset($rec->cdarti) && (string)$rec->cdarti !== '' ? (string)$rec->cdarti : new RawValue('""'),
      'cdcolo' => isset($rec->cdcolo) && (string)$rec->cdcolo !== '' ? (string)$rec->cdcolo : new RawValue('""'),
      'dscolo' => isset($rec->dscolo) && (string)$rec->dscolo !== '' ? (string)$rec->dscolo : new RawValue('""'),
      'flbloc' => isset($rec->flbloc) && (string)$rec->flbloc !== '' ? (string)$rec->flbloc : 0,
      'flimag' => isset($rec->flimag) && (string)$rec->flimag !== '' ? (string)$rec->flimag : new RawValue('""')
    );

    $query  = 'cdarti = :cdarti: AND cdcolo = :cdcolo:';
    $params = array(
      'cdarti' => $values['cdarti'],
      'cdcolo' => $values['cdcolo']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Artcol objects
   */
  public static function getAllColors() {
    $query = "SELECT DISTINCT ac.cdcolo AS codice,
      COALESCE(bc.rgbcd1,'') AS rgbcd1, COALESCE(bc.rgbcd2,'') AS rgbcd2,
      COALESCE(bc.rgbcd3,'') AS rgbcd3, COALESCE(bc.flimag,'') AS flimag,
      COALESCE(bc.flmult, 0) AS flmult
      FROM Go2B\Models\Artcol ac
      LEFT JOIN Go2B\Models\B2bColors bc ON ac.cdcolo = bc.codice
      ORDER BY ac.cdcolo";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Artcol objects
   */
  public static function getColorsForLookFromModel($cdartn, $cdpers, $cdcata) {
    $query = 'SELECT ac.cdcolo
      FROM Go2B\Models\Artcol ac
      INNER JOIN Go2B\Models\Ctarti ca ON ac.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Anaart aa ON ac.cdarti = aa.cdarti
      WHERE aa.cdartn = :cdartn: AND aa.cdpers = :cdpers: AND ca.cdcata = :cdcata:
      GROUP BY ac.cdcolo
      ORDER BY ac.cdcolo';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdartn' => $cdartn, 'cdpers' => $cdpers, 'cdcata' => $cdcata));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Artcol objects
   */
  public static function getAllFabricColors() {
    $query = 'SELECT DISTINCT aa.cdpers, ac.cdcolo, ac.dscolo,
      COUNT(IF(ac.flbloc = 0, 1, NULL)) AS not_blocked,
      COUNT(IF(ac.flbloc = 1, 1, NULL)) AS blocked
      FROM Go2B\Models\Artcol ac
      INNER JOIN Go2B\Models\Anaart aa ON ac.cdarti = aa.cdarti
      GROUP BY aa.cdpers, ac.cdcolo';
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Artcol arrays
   */
  public static function getColorsFromArticle($cdarti) {
    $query = 'SELECT ac.cdcolo, ac.dscolo, ac.flimag
      FROM artcol ac
      WHERE ac.cdarti = :cdarti AND ac.flbloc = 0';
    return Di::getDefault()->get('db')->query($query, array('cdarti' => (string)$cdarti))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Artcol arrays
   */
  public static function getAllColorsFromModel($cdartn, $cdcata) {
    $query = 'SELECT ac.cdarti, ac.cdcolo, ac.dscolo, ac.flimag, aa.cdpers
      FROM artcol ac
      INNER JOIN ctarti ca ON ac.cdarti = ca.cdarti
      INNER JOIN anaart aa ON ac.cdarti = aa.cdarti
      INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn
      WHERE aa.cdartn = :cdartn AND ca.cdcata = :cdcata
      AND ac.flbloc = 0 AND aa.flbloc = 0 AND tp.flbloc = 0
      ORDER BY aa.cdpers, aa.cdcolo';
    return Di::getDefault()->get('db')->query($query, array('cdartn' => (string)$cdartn, 'cdcata' => (string)$cdcata))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Artcol arrays
   */
  public static function getAllColorsFromFabric($cdpers, $cdcata) {
    $query = 'SELECT DISTINCT ac.cdcolo, ac.dscolo, ac.flimag
      FROM artcol ac
      INNER JOIN ctarti ca ON ac.cdarti = ca.cdarti
      INNER JOIN anaart aa ON ac.cdarti = aa.cdarti
      INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn
      WHERE aa.cdpers = :cdpers AND ca.cdcata = :cdcata
      AND ac.flbloc = 0 AND aa.flbloc = 0 AND tp.flbloc = 0
      ORDER BY aa.cdpers, aa.cdcolo';
    return Di::getDefault()->get('db')->query($query, array('cdpers' => (string)$cdpers, 'cdcata' => (string)$cdcata))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Artcol arrays
   */
  public static function getAllColorsFromModelAndFabric($cdartn, $cdpers, $cdcata) {
    $query = 'SELECT ac.cdarti, ac.cdcolo, ac.dscolo, ac.flimag, aa.cdpers
      FROM artcol ac
      INNER JOIN ctarti ca ON ac.cdarti = ca.cdarti
      INNER JOIN anaart aa ON ac.cdarti = aa.cdarti
      INNER JOIN tipolo tp ON aa.cdartn = tp.cdartn
      WHERE aa.cdartn = :cdartn AND aa.cdpers = :cdpers AND ca.cdcata = :cdcata
      AND ac.flbloc = 0 AND aa.flbloc = 0 AND tp.flbloc = 0
      ORDER BY aa.cdpers, aa.cdcolo';
    return Di::getDefault()->get('db')->query($query, array('cdartn' => (string)$cdartn, 'cdpers' => (string)$cdpers, 'cdcata' => (string)$cdcata))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Artcol arrays
   */
  public static function getColorsForOrderArticleDetail($items) {
    $params = array('cdarti' => (string)$items['cdarti'], 'nuordc' => (string)$items['nuordc']);

    if (in_array($items['modelDetailStyle'], [1, 6, 7, 8, 9])) {
      switch ($items['colorAssignmentSource']) {
        case 0:
          $codice = 'dscolo';
          break;
        case 1:
        case 2:
        default:
          $codice = 'cdcolo';
          break;
      }
      $leftJoinColors = "LEFT JOIN b2b_colors bc ON tt.$codice = bc.codice";
      $colors = "tt.$codice AS col_codice, COALESCE(bc.rgbcd1,'') AS col_rgbcd1,
        COALESCE(bc.rgbcd2,'') AS col_rgbcd2, COALESCE(bc.rgbcd3,'') AS col_rgbcd3,
        COALESCE(bc.flimag,tt.flimag) AS col_flimag, COALESCE(bc.flmult, 0) AS col_flmult,";
    } else {
      $colors = '';
      $leftJoinColors = '';
    }

    $query = "SELECT tt.cdcolo, tt.dscolo, tt.flimag, $colors
      SUM(tt.qtares) AS is_available,
      IF(COALESCE(MAX(oa.nurorc),0) > 0, 1, -1) AS presence
      FROM (
        SELECT ad.cdarti, ad.cdcolo, ad.dscolo, ad.flimag, ad.cdvari, ad.taglia,
        IF((ad.qtadis - COALESCE(SUM(oc.quanti), 0)) > 0, (ad.qtadis - COALESCE(SUM(oc.quanti), 0)), 0) AS qtares
        FROM (
          SELECT ar.cdarti, ar.cdcolo, ar.dscolo, ar.flimag, COALESCE(d.cdvari,'') AS cdvari,
          COALESCE(d.taglia,'') AS taglia, COALESCE(d.quanti,0) AS qtadis
          FROM (SELECT ac.cdarti, ac.cdcolo, ac.dscolo, ac.flimag
            FROM artcol ac
            WHERE ac.cdarti = :cdarti AND ac.flbloc = 0) AS ar
          LEFT JOIN dscorp d ON d.cdarti = ar.cdarti AND d.cdcolo = ar.cdcolo AND d.cdasso = '') AS ad
        LEFT JOIN (
          SELECT op.cdarti, op.cdcolo, op.cdvari, og.dstagl, og.quanti
          FROM occorp op
          INNER JOIN octest ot ON ot.nuordc = op.nuordc
          INNER JOIN octagl og ON og.nurorc = op.nurorc
          WHERE ot.flstat = 2) oc ON oc.cdarti = ad.cdarti AND oc.cdcolo = ad.cdcolo
          AND oc.cdvari = ad.cdvari AND oc.dstagl = ad.taglia
        GROUP BY ad.cdarti, ad.cdcolo, ad.cdvari, ad.taglia) AS tt
      LEFT JOIN occorp oa ON oa.cdarti = tt.cdarti AND oa.cdcolo = tt.cdcolo AND oa.nuordc = :nuordc
      $leftJoinColors
      GROUP BY tt.cdarti, tt.cdcolo";
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Artcol arrays
   */
  public static function getColorsForArticleDetail($items) {
    $params = array('cdarti' => (string)$items['cdarti']);

    if (in_array($items['modelDetailStyle'], [1, 6, 7, 8, 9])) {
      switch ($items['colorAssignmentSource']) {
        case 0:
          $codice = 'dscolo';
          break;
        case 1:
        case 2:
          $codice = 'cdcolo';
          break;
      }
      $leftJoinColors = "LEFT JOIN b2b_colors bc ON ac.$codice = bc.codice";
      $colors = "ac.$codice AS col_codice, COALESCE(bc.rgbcd1,'') AS col_rgbcd1,
        COALESCE(bc.rgbcd2,'') AS col_rgbcd2, COALESCE(bc.rgbcd3,'') AS col_rgbcd3,
        COALESCE(bc.flimag,ac.flimag) AS col_flimag, COALESCE(bc.flmult, 0) AS col_flmult ";
    } else {
      $colors = "'' AS col_codice, '' AS col_rgbcd1, '' AS col_rgbcd2, '' AS col_rgbcd3,
        ac.flimag AS col_flimag, 0 AS col_flmult ";
      $leftJoinColors = '';
    }

    $query = "SELECT ac.cdcolo, ac.dscolo, ac.flimag, $colors
      FROM artcol ac
      $leftJoinColors
      WHERE ac.cdarti = :cdarti AND ac.flbloc = 0
      GROUP BY ac.cdcolo";
    return Di::getDefault()->get('db')->query($query, $params)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Artcol arrays
   */
  public static function getColorsFromArticleAndOrder($cdarti, $nuordc) {
    $query = "SELECT ac.cdcolo, ac.dscolo, ac.flimag,
      IF(COALESCE(MAX(oc.nurorc),0) > 0, 1, -1) AS presence
      FROM artcol ac
      LEFT JOIN occorp oc ON oc.cdarti = ac.cdarti AND oc.cdcolo = ac.cdcolo AND oc.nuordc = :nuordc
      WHERE ac.cdarti = :cdarti
      GROUP BY ac.cdarti, ac.cdcolo";
    return Di::getDefault()->get('db')->query($query, array('cdarti' => (string)$cdarti, 'nuordc' => (string)$nuordc))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Artcol arrays
   */
  public static function getAvailableColorsFromArticleAndOrder($cdarti, $nuordc) {
    $query = "SELECT ac.cdcolo, ac.dscolo, ac.flimag,
      IF(COALESCE(MAX(oc.nurorc),0) > 0, 1, -1) AS presence,
      MAX(
        COALESCE(
          (SELECT MAX(dc2.quanti -
            COALESCE(
              (SELECT SUM(og2.quanti)
              FROM octagl og2
              INNER JOIN occorp oc2 ON oc2.nurorc = og2.nurorc
              INNER JOIN octest ot2 ON ot2.nuordc = oc2.nuordc
              WHERE oc2.cdarti = dc2.cdarti AND oc2.cdcolo = dc2.cdcolo AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
            ) AS quanti
          FROM dscorp dc2
          WHERE dc2.cdarti = ac.cdarti AND dc2.cdcolo = ac.cdcolo),
        0)
      ) AS is_available
      FROM artcol ac
      LEFT JOIN occorp oc ON oc.cdarti = ac.cdarti AND oc.cdcolo = ac.cdcolo AND oc.nuordc = :nuordc
      WHERE ac.cdarti = :cdarti
      GROUP BY ac.cdarti, ac.cdcolo
      HAVING is_available > 0";
    /*
    $query = "SELECT tt.cdcolo, tt.dscolo, tt.flimag,
      SUM(tt.qtares) AS is_available,
      IF(COALESCE(MAX(oa.nurorc),0) > 0, 1, -1) AS presence
      FROM (
        SELECT ad.cdarti, ad.cdcolo, ad.dscolo, ad.flimag, ad.cdvari, ad.taglia,
        IF((ad.qtadis - COALESCE(SUM(oc.quanti), 0)) > 0, (ad.qtadis - COALESCE(SUM(oc.quanti), 0)), 0) AS qtares
        FROM (
          SELECT ar.cdarti, ar.cdcolo, ar.dscolo, ar.flimag, COALESCE(d.cdvari,'') AS cdvari,
          COALESCE(d.taglia,'') AS taglia, COALESCE(d.quanti,0) AS qtadis
          FROM (SELECT ac.cdarti, ac.cdcolo, ac.dscolo, ac.flimag
            FROM artcol ac
            WHERE ac.cdarti = :cdarti AND ac.flbloc = 0) AS ar
          LEFT JOIN dscorp d ON d.cdarti = ar.cdarti AND d.cdcolo = ar.cdcolo AND d.cdvari = '' AND d.cdasso = '') AS ad
        LEFT JOIN (
          SELECT op.cdarti, op.cdcolo, op.cdvari, og.dstagl, og.quanti
          FROM occorp op
          INNER JOIN octest ot ON ot.nuordc = op.nuordc
          INNER JOIN octagl og ON og.nurorc = op.nurorc
          WHERE ot.flstat = 2) oc ON oc.cdarti = ad.cdarti AND oc.cdcolo = ad.cdcolo
          AND oc.cdvari = ad.cdvari AND oc.dstagl = ad.taglia
        GROUP BY ad.cdarti, ad.cdcolo, ad.cdvari, ad.taglia) AS tt
      LEFT JOIN occorp oa ON oa.cdarti = tt.cdarti AND oa.cdcolo = tt.cdcolo AND oa.nuordc = :nuordc
      HAVING is_available > 0
      GROUP BY tt.cdarti, tt.cdcolo";
    */
    return Di::getDefault()->get('db')->query($query, array('cdarti' => (string)$cdarti, 'nuordc' => (string)$nuordc))->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Artcol array
   */
  public static function getColor($cdcolo, $cdarti) {
    $query = 'SELECT ac.cdcolo, ac.dscolo, ac.flimag
      FROM artcol ac
      WHERE ac.cdarti = :cdarti AND ac.cdcolo = :cdcolo';
    $result = Di::getDefault()->get('db')->query($query, array('cdcolo' => (string)$cdcolo, 'cdarti' => (string)$cdarti))->fetchAll();
    return count($result) > 0 ? $result[0] : array();
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateBlockFlagForFabricAndColor($cdpers, $cdcolo, $flbloc) {
    $params = array('cdpers' => $cdpers, 'cdcolo' => $cdcolo, 'flbloc' => $flbloc);
    $query = 'UPDATE artcol ac
      INNER JOIN anaart aa ON aa.cdarti = ac.cdarti
      SET ac.flbloc = :flbloc
      WHERE aa.cdpers = :cdpers AND ac.cdcolo = :cdcolo';
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateColorImage($cdarti, $cdcolo, $flimag) {
    $params = array(
      'cdarti' => $cdarti,
      'cdcolo' => $cdcolo,
      'flimag' => $flimag != '' ? $flimag : ''
    );

    $query = "UPDATE artcol ac
      SET ac.flimag = :flimag
      WHERE ac.cdarti = :cdarti AND ac.cdcolo = :cdcolo";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updateImage($cdarti, $cdcolo, $flimag) {
    $params = array('cdarti' => $cdarti, 'cdcolo' => $cdcolo, 'flimag' => $flimag);
    $query = "UPDATE artcol a
      SET a.flimag = :flimag
      WHERE a.cdarti = :cdarti AND a.cdcolo = :cdcolo";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function blockAllColors() {
    $query = "UPDATE artcol a SET a.flbloc = 1";
    Di::getDefault()->get('db')->query($query);
  }

  /**
   * Query:   TRUNCATE
   * Return:  void
   */
  public static function emptyTable() {
    $query = "TRUNCATE artcol";
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
