<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Artcla extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=2, nullable=false)
   */
  public $tpinpu;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $codice;

  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $tpclas;

  /**
   *
   * @var string
   * @Column(type="string", length=80, nullable=false)
   */
  public $valore;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('artcla');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'tpinpu' => isset($rec->tpinpu) && (string)$rec->tpinpu !== '' ? (string)$rec->tpinpu : new RawValue('""'),
      'codice' => isset($rec->codice) && (string)$rec->codice !== '' ? (string)$rec->codice : new RawValue('""'),
      'tpclas' => isset($rec->tpclas) && (string)$rec->tpclas !== '' ? (string)$rec->tpclas : new RawValue('""'),
      'valore' => isset($rec->valore) && (string)$rec->valore !== '' ? (string)$rec->valore : new RawValue('""'),
    );

    $query  = 'tpinpu = :tpinpu: AND codice = :codice: AND tpclas = :tpclas:';
    $params = array(
      'valore' => $values['valore']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Artcla objects
   */
  public static function getTags($cdcata) {
    $query = 'SELECT DISTINCT ac.valore, ac.tpclas AS codic1,
      ac.valore AS codic2, ac.valore AS descri
      FROM Go2B\Models\Artcla ac
      INNER JOIN Go2B\Models\Anaart aa ON ac.codice = aa.cdartn
      INNER JOIN Go2B\Models\Ctarti ca ON aa.cdarti = ca.cdarti
      WHERE ac.tpinpu = "AN" AND ca.cdcata = :cdcata:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Artcla objects
   */
  public static function getTagsForArticles($cdcata) {
    $query = 'SELECT DISTINCT ac.valore, ac.tpclas AS codic1,
      ac.valore AS codic2, ac.valore AS descri
      FROM Go2B\Models\Artcla ac
      INNER JOIN Go2B\Models\Ctarti ca ON ca.cdarti = ac.codice
      WHERE ac.tpinpu = "AR" AND ac.tpclas LIKE "TB2%" AND ca.cdcata = :cdcata:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdcata' => $cdcata));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Artcla objects
   */
  public static function getTagsForModel($cdartn) {
    $query = 'SELECT DISTINCT ac.tpclas, ac.valore
      FROM Go2B\Models\Artcla ac
      WHERE ac.tpinpu = "AN" AND ac.codice = :cdartn:';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdartn' => $cdartn));
  }

  /**
   * Query:   SELECT
   * Return:  bool
   */
  public static function isTagAvailable() {
    $query = 'SELECT COUNT(DISTINCT ac.valore) > 0 AS isAvailable
      FROM artcla ac
      WHERE (ac.tpinpu = "AN" OR ac.tpinpu = "AR") AND ac.tpclas LIKE "TB2%"';
    return Di::getDefault()->get('db')->query($query)->fetchAll()[0]['isAvailable'];
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAllAvailabilities() {
    $query = 'DELETE ac.*
      FROM artcla ac
      WHERE ac.tpinpu = "AR" AND ac.tpclas = "DISP"';
    Di::getDefault()->get('db')->query($query);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function emptyTags() {
    $query = 'DELETE ac.*
      FROM artcla ac
      WHERE ac.tpinpu = "AR" AND ac.tpclas LIKE "TB2%"';
    Di::getDefault()->get('db')->query($query);
  }
  //endregion
}
