<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Anatgl extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdtagl;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dstagl;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('anatgl');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdtagl' => isset($rec->cdtagl) && (string)$rec->cdtagl !== '' ? (string)$rec->cdtagl : new RawValue('""'),
      'dstagl' => isset($rec->dstagl) && (string)$rec->dstagl !== '' ? (string)$rec->dstagl : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0
    );

    $query  = 'cdtagl = :cdtagl:';
    $params = array(
      'cdtagl' => $values['cdtagl']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Anatgl arrays
   */
  public static function getAllScales() {
    $query = "SELECT a.cdtagl, a.dstagl, a.seqrap
      FROM anatgl a";
    return Di::getDefault()->get('db')->query($query)->fetchAll();
  }
  //endregion
}
