<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Anamat extends Model
{
  //region Fields
  /**
   *
   * @var string
   * @Primary
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdmate;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dsmate;

  /**
   *
   * @var string
   * @Column(type="string", length=30, nullable=false)
   */
  public $cdmatn;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdcolo;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $flbloc;

  /**
   *
   * @var string
   * @Column(type="string", length=255, nullable=false)
   */
  public $flimag;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('anamat');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdmate' => isset($rec->cdmate) && $rec->cdmate !== '' ? (string)$rec->cdmate : new RawValue('""'),
      'dsmate' => isset($rec->dsmate) && $rec->dsmate !== '' ? (string)$rec->dsmate : new RawValue('""'),
      'cdmatn' => isset($rec->cdmatn) && $rec->cdmatn !== '' ? (string)$rec->cdmatn : new RawValue('""'),
      'cdcolo' => isset($rec->cdcolo) && $rec->cdcolo !== '' ? (string)$rec->cdcolo : new RawValue('""'),
      'flbloc' => isset($rec->flbloc) && $rec->flbloc !== '' ? (string)$rec->flbloc : 0,
      'flimag' => isset($rec->flimag) && $rec->flimag !== '' ? (string)$rec->flimag : new RawValue('""')
    );

    $query  = 'cdmate = :cdmate:';
    $params = array(
      'cdmate' => $values['cdmate']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Anamat objects
   */
  public static function getMaterialFromMaterialType($cdmatn, $cdartn) {
    $query = 'SELECT DISTINCT am.cdmate, am.dsmate, am.cdcolo, am.flimag,
      0 AS isDefault
      FROM Go2B\Models\Anamat am
      INNER JOIN Go2B\Models\Spmate sm ON sm.cdmate = am.cdmate
      WHERE sm.cdartn = :cdartn: AND am.cdmatn = :cdmatn: AND am.flbloc = 0
      ORDER BY am.cdmate';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdmatn' => $cdmatn, 'cdartn' => $cdartn));
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anamat objects
   */
  public static function getAllMaterialsFromMaterialType($cdmatn) {
    $query = 'SELECT DISTINCT am.cdmate, am.dsmate, am.cdcolo, am.flimag,
      0 AS isDefault
      FROM Go2B\Models\Anamat am
      WHERE am.cdmatn = :cdmatn: AND am.flbloc = 0
      ORDER BY am.cdmate';
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdmatn' => $cdmatn));
  }

  /**
   * Query:   SELECT
   * Return:  Anamat object
   */
  public static function getMaterialForComponent($tpcomp, $cdartn, $cdmate) {
    $params = array('tpcomp' => $tpcomp, 'cdartn' => $cdartn, 'cdmate' => $cdmate);
    /*
    $query = 'SELECT DISTINCT :tpcomp: AS tpcomp,
      COALESCE(tc1.dscomp, (SELECT tc2.dscomp FROM Go2B\Models\Tpcomp tc2 WHERE tc2.tpcomp = :tpcomp:)) AS dscomp,
      am.cdmatn, am.cdmate, am.dsmate, am.flimag,
      COALESCE(sm1.riflis, sm2.riflis) AS riflis,
      COALESCE(sm1.varpre, sm2.varpre) AS varpre,
      COALESCE(sm1.inplib, sm2.inplib) AS inplib,
      COALESCE(sm1.flcamp, sm2.flcamp) AS flcamp
      FROM Go2B\Models\Spmate sm2, Go2B\Models\Anamat am
      LEFT JOIN Go2B\Models\Spmate sm1 ON sm1.cdmate = am.cdmate AND sm1.cdartn = :cdartn:
      LEFT JOIN Go2B\Models\Tpcomp tc1 ON sm1.tpcomp = tc1.tpcomp AND tc1.tpcomp = :tpcomp:
      WHERE am.cdmate = :cdmate: AND sm2.cdartn = :cdartn: AND sm2.tpcomp = :tpcomp:
      GROUP BY am.cdmate ';
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
    return $result != null && count($result) == 1 ? $result[0] : null;*/
    $query = 'SELECT DISTINCT :tpcomp AS tpcomp,
      COALESCE(tc1.dscomp, (SELECT tc2.dscomp FROM tpcomp tc2 WHERE tc2.tpcomp = :tpcomp)) AS dscomp,
      am.cdmatn, am.cdmate, am.dsmate, am.flimag,
      COALESCE(sm1.riflis, sm2.riflis) AS riflis,
      COALESCE(sm1.varpre, sm2.varpre) AS varpre,
      COALESCE(sm1.inplib, sm2.inplib) AS inplib,
      COALESCE(sm1.flcamp, sm2.flcamp) AS flcamp
      FROM spmate sm2, anamat am
      LEFT JOIN spmate sm1 ON sm1.cdmate = am.cdmate AND sm1.cdartn = :cdartn
      LEFT JOIN tpcomp tc1 ON sm1.tpcomp = tc1.tpcomp AND tc1.tpcomp = :tpcomp
      WHERE am.cdmate = :cdmate AND sm2.cdartn = :cdartn AND sm2.tpcomp = :tpcomp
      GROUP BY am.cdmate ';
    $result = Di::getDefault()->get('db')->query($query, $params)->fetchAll();
    return $result != null && count($result) == 1 ? $result[0] : null;
  }
  //endregion
}
