<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Db;
use Phalcon\Db\RawValue;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Anaage extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=11, nullable=false)
   */
  public $cdagen;

  /**
   *
   * @var string
   * @Column(type="string", length=60, nullable=false)
   */
  public $dsagen;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $seqrap;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $fltota;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $nulist;

  /**
   *
   * @var string
   * @Column(type="string", length=10, nullable=false)
   */
  public $cdzona;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('anaage');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdagen' => isset($rec->cdagen) && (string)$rec->cdagen !== '' ? (string)$rec->cdagen : 0,
      'dsagen' => isset($rec->dsagen) && (string)$rec->dsagen !== '' ? (string)$rec->dsagen : new RawValue('""'),
      'seqrap' => isset($rec->seqrap) && (string)$rec->seqrap !== '' ? (string)$rec->seqrap : 0,
      'fltota' => isset($rec->fltota) && (string)$rec->fltota !== '' ? (string)$rec->fltota : 0,
      'nulist' => isset($rec->nulist) && (string)$rec->nulist !== '' ? (string)$rec->nulist : new RawValue('""')
    );

    $query  = 'cdagen = :cdagen:';
    $params = array(
      'cdagen' => $values['cdagen']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    // If price list of the record is empty, use old value
    $values['nulist'] = !empty($row->nulist) ? $row->nulist : $values['nulist'];
    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   SELECT
   * Return:  Array of Anaage objects
   */
  public static function getAllAgents($withUser = true) {
    $innerJoin = $withUser ? 'INNER JOIN Go2B\Models\B2bUsrage u ON u.cdagen = a.cdagen ' : '';
    $query = "SELECT a.cdagen, a.dsagen
      FROM Go2B\Models\Anaage a
      $innerJoin
      ORDER BY a.dsagen";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaage objects
   */
  public static function getAllEnabledAgents() {
    $query = "SELECT a.cdagen AS cdagen, a.dsagen AS dsagen, a.seqrap AS seqrap,
      a.fltota AS fltota, b.id AS id_usr, b.username AS usrnam, b.enabled AS enable,
      COALESCE(i.valore,'') AS indema, COALESCE(ba.valore,'') AS fldfbh
      FROM Go2B\Models\Anaage a
      INNER JOIN Go2B\Models\B2bUsrage u ON u.cdagen = a.cdagen
      INNER JOIN Go2B\Models\B2bSysusr b ON b.id = u.id_usr
      LEFT JOIN Go2B\Models\B2bAddinf i ON i.tabell = 'anaage' AND i.codic1 = a.cdagen AND i.codic2 = '' AND i.tpdato = 'indema'
      LEFT JOIN Go2B\Models\B2bAddinf ba ON ba.tabell = 'anaage' AND ba.codic1 = a.cdagen AND ba.codic2 = '' AND ba.tpdato = 'fldfbh'
      WHERE b.enabled = 1
      ORDER BY a.cdagen";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaage objects
   */
  public static function getAllStandardAgents() {
    $query = "SELECT a.cdagen, a.dsagen, a.nulist, COALESCE((SELECT COUNT(u.id_usr) FROM b2b_usrage u WHERE u.cdagen = a.cdagen),0) AS users,
      COALESCE(i.valore,'') AS indema, COALESCE(b.valore,'') AS fldfbh,
      GROUP_CONCAT(DISTINCT n.valore ORDER BY n.valore ASC SEPARATOR ',') AS nulist_s
      FROM anaage a
      LEFT JOIN b2b_addinf i ON i.tabell = 'anaage' AND i.codic1 = a.cdagen AND i.codic2 = '' AND i.tpdato = 'indema'
      LEFT JOIN b2b_addinf b ON b.tabell = 'anaage' AND b.codic1 = a.cdagen AND b.codic2 = '' AND b.tpdato = 'fldfbh'
      LEFT JOIN b2b_addinf n ON n.tabell = 'anaage' AND n.codic1 = a.cdagen AND n.codic2 > 0 AND n.tpdato = 'nulist'
      WHERE a.fltota = 0
      GROUP BY a.cdagen
      ORDER BY a.cdagen";
    return Di::getDefault()->get('db')->query($query)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaage objects
   */
  public static function getAllAvailableStandardAgents() {
    $query = "SELECT a.cdagen AS cdagen, a.dsagen AS dsagen, a.seqrap AS seqrap,
      a.fltota AS fltota, b.id AS id_usr, b.username AS usrnam, b.enabled AS enable,
      COALESCE(i.valore,'') AS indema, COALESCE(ba.valore,'') AS fldfbh
      FROM Go2B\Models\Anaage a
      INNER JOIN Go2B\Models\B2bUsrage u ON u.cdagen = a.cdagen
      INNER JOIN Go2B\Models\B2bSysusr b ON b.id = u.id_usr
      LEFT JOIN Go2B\Models\B2bAddinf i ON i.tabell = 'anaage' AND i.codic1 = a.cdagen AND i.codic2 = '' AND i.tpdato = 'indema'
      LEFT JOIN Go2B\Models\B2bAddinf ba ON ba.tabell = 'anaage' AND ba.codic1 = a.cdagen AND ba.codic2 = '' AND ba.tpdato = 'fldfbh'
      WHERE a.fltota = 0
      ORDER BY a.cdagen";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaage objects
   */
  public static function getAllHeadOfficeAgents() {
    $query = "SELECT a.cdagen, a.dsagen, a.nulist, COALESCE((SELECT COUNT(u.id_usr) FROM b2b_usrage u WHERE u.cdagen = a.cdagen),0) AS users,
      COALESCE(i.valore,'') AS indema, COALESCE(b.valore,'') AS fldfbh,
      GROUP_CONCAT(DISTINCT n.valore ORDER BY n.valore ASC SEPARATOR ',') AS nulist_s
      FROM anaage a
      LEFT JOIN b2b_addinf i ON i.tabell = 'anaage' AND i.codic1 = a.cdagen AND i.codic2 = '' AND i.tpdato = 'indema'
      LEFT JOIN b2b_addinf b ON b.tabell = 'anaage' AND b.codic1 = a.cdagen AND b.codic2 = '' AND b.tpdato = 'fldfbh'
      LEFT JOIN b2b_addinf n ON n.tabell = 'anaage' AND n.codic1 = a.cdagen AND n.codic2 > 0 AND n.tpdato = 'nulist'
      WHERE a.fltota = 1
      GROUP BY a.cdagen
      ORDER BY a.cdagen";
    return Di::getDefault()->get('db')->query($query)->fetchAll();
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaage objects
   */
  public static function getAllAvailableHeadOfficeAgents() {
    $query = "SELECT a.cdagen AS cdagen, a.dsagen AS dsagen, a.seqrap AS seqrap,
      a.fltota AS fltota, b.id AS id_usr, b.username AS usrnam, b.enabled AS enable,
      COALESCE(i.valore,'') AS indema, COALESCE(ba.valore,'') AS fldfbh
      FROM Go2B\Models\Anaage a
      INNER JOIN Go2B\Models\B2bUsrage u ON u.cdagen = a.cdagen
      INNER JOIN Go2B\Models\B2bSysusr b ON b.id = u.id_usr
      LEFT JOIN Go2B\Models\B2bAddinf i ON i.tabell = 'anaage' AND i.codic1 = a.cdagen AND i.codic2 = '' AND i.tpdato = 'indema'
      LEFT JOIN Go2B\Models\B2bAddinf ba ON ba.tabell = 'anaage' AND ba.codic1 = a.cdagen AND ba.codic2 = '' AND ba.tpdato = 'fldfbh'
      WHERE a.fltota = 1
      ORDER BY a.cdagen";
    return Di::getDefault()->get('modelsManager')->executeQuery($query);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaage objects
   */
  public static function getTop20QuantityAgents($whereCatalogs, $whereAgents, $params) {
    $query = "SELECT aa.cdagen, aa.dsagen, SUM(og.quanti) AS qty
      FROM Go2B\Models\Anaage aa
      INNER JOIN Go2B\Models\B2bUsrage ua ON aa.cdagen = ua.cdagen
      INNER JOIN Go2B\Models\Octest ot ON ua.id_usr = ot.id_usr
      INNER JOIN Go2B\Models\Occorp oc ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Octagl og ON oc.nurorc = og.nurorc
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereAgents
      GROUP BY aa.cdagen
      ORDER BY qty DESC
      LIMIT 20";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Array of Anaage objects
   */
  public static function getTop20ValueAgents($whereCatalogs, $whereAgents, $params) {
    $query = "SELECT aa.cdagen, aa.dsagen, SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS val
      FROM Go2B\Models\Anaage aa
      INNER JOIN Go2B\Models\B2bUsrage ua ON aa.cdagen = ua.cdagen
      INNER JOIN Go2B\Models\Octest ot ON ua.id_usr = ot.id_usr
      INNER JOIN Go2B\Models\Occorp oc ON ot.nuordc = oc.nuordc
      INNER JOIN Go2B\Models\Octagl og ON oc.nurorc = og.nurorc
      WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea >= :dtiniz: AND ot.dtcrea <= :dtfine:
      $whereCatalogs
      $whereAgents
      GROUP BY aa.cdagen
      ORDER BY val DESC
      LIMIT 20";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  Anaage object
   */
  public static function getAgentFromUser($id_usr) {
    $query = "SELECT a.cdagen, a.dsagen
      FROM Go2B\Models\Anaage a
      INNER JOIN Go2B\Models\B2bUsrage u ON u.cdagen = a.cdagen
      WHERE u.id_usr = :id_usr:";
    return Di::getDefault()->get('modelsManager')->executeQuery($query, array('id_usr' => $id_usr))[0];
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getCountActiveAgents() {
    $query = "SELECT COUNT(aa.cdagen) AS total
      FROM Go2B\Models\Anaage aa
      INNER JOIN Go2B\Models\B2bUsrage ua ON ua.cdagen = aa.cdagen
      INNER JOIN Go2B\Models\B2bSysusr bu ON bu.id = ua.id_usr
      WHERE bu.enabled = 1";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query);
    return $result[0]->total;
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getAgentPriceListCodeFromUser($id_usr) {
    $query = "SELECT a.nulist
      FROM Go2B\Models\Anaage a
      INNER JOIN Go2B\Models\B2bUsrage u ON u.cdagen = a.cdagen
      WHERE u.id_usr = :id_usr:";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('id_usr' => $id_usr));
    return count($result) > 0 ? $result[0]->nulist : -1;
  }

  /**
   * Query:   SELECT
   * Return:  bool
   */
  public static function isHeadquarterAgent($id_usr) {
    $query = "SELECT a.fltota
      FROM Go2B\Models\Anaage a
      INNER JOIN Go2B\Models\B2bUsrage u ON u.cdagen = a.cdagen
      WHERE u.id_usr = :id_usr:";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('id_usr' => $id_usr));
    return count($result) > 0 ? $result[0]->fltota == 1 : false;
  }

  /**
   * Query:   UPDATE
   * Return:  void
   */
  public static function updatePriceListForAgent($cdagen, $nulist) {
    $params = array('cdagen' => $cdagen, 'nulist' => $nulist);
    $query = "UPDATE anaage ag
      SET ag.nulist = :nulist
      WHERE ag.cdagen = :cdagen";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   SELECT
   * Return:  boolean
   */
  public static function existsAgent($cdagen) {
    $query = "SELECT ag.cdagen
        FROM Go2B\Models\Anaage ag
        WHERE ag.cdagen = :cdagen:
        LIMIT 1";
    $result = Di::getDefault()->get('modelsManager')->executeQuery($query, array('cdagen' => $cdagen));
    return (count($result) > 0);
  }

  /**
   * Query:   SELECT
   * Return:  int
   */
  public static function getCdagenFromCodice($codice,$getnew=false) {
    $query = "SELECT ag.cdagen
        FROM anaage ag
        WHERE ag.codice = :codice
        LIMIT 1";
    $result = Di::getDefault()->get('db')->query($query,array('codice'=>$codice))->fetch();
    if ( $result ) return $result['cdagen'];

    if ( !$getnew ) return false;

    $query = "SELECT IFNULL(( 
      SELECT MAX( cdagen ) + 1 
      FROM anaage ),
      1) AS cdagen";
    return ($result = Di::getDefault()->get('db')->query($query)->fetch()) ? $result['cdagen'] : false;

  }

    /**
     * @param $cdagen
     * @param $type
     * @return array{C: array, D: array}
     */
    public static function getAvailableCustomerAndDestinationCodeListForCdagen($cdagen, $type = null)
    {
        $query = 'SELECT ag.tipdat, ag.tpanag, ag.codice FROM ageana ag WHERE ag.cdagen = :cdagen';
        $params = ['cdagen' => $cdagen];

        if (!empty($type)) {
            $params['tipdat'] = $type;
            $query .= ' AND ag.tipdat = :tipdat';
        }
        $rows = Di::getDefault()->get('db')->query($query, $params)->fetchAll(Db::FETCH_ASSOC);

        $data = [];
        foreach ($rows as $row) {
//            $data[$row['tipdat']][] = [
//                'code' => $row['tpanag'] . '-' . $row['code'],
//                'tpanag' => $row['tpanag'],
//                (($row['tipdat'] = 'D') ? 'cddesm' : 'cdanag') => $row['code'],
//            ];
            $data[$row['tipdat']][] = $row['tpanag'] . '-' . $row['codice'];
        }

        return $data;
    }
  //endregion
}
