<?php

namespace Go2B\Models;

use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Di;
use Phalcon\Mvc\Model;

class Abagen extends Model
{
  //region Fields
  /**
   *
   * @var integer
   * @Primary
   * @Column(type="integer", length=6, nullable=false)
   */
  public $cdagen;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $tpcond;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $fltota;

  /**
   *
   * @var integer
   * @Column(type="integer", length=6, nullable=false)
   */
  public $fllist;
  //endregion

  //region Default functions
  /**
   * Initialize method for model.
   */
  public function initialize() {
    // $path = realpath('..') . '/app/config/config.ini';
    // $config = new ConfigIni($path);
        $config = $this->getDI()->get('config');
    $this->setSchema($config->database->dbname);
    $this->setSource('abagen');
  }
  //endregion

  //region Sync functions
  /**
   * Sync from xml
   */
  public static function saveRecord($rec, $tipoagg) {
    $values = array(
      'cdagen' => isset($rec->cdagen) && (string)$rec->cdagen !== '' ? (string)$rec->cdagen : 0,
      'tpcond' => isset($rec->tpcond) && (string)$rec->tpcond !== '' ? (string)$rec->tpcond : 0,
      'fltota' => isset($rec->fltota) && (string)$rec->fltota !== '' ? (string)$rec->fltota : 0,
      'fllist' => isset($rec->fllist) && (string)$rec->fllist !== '' ? (string)$rec->fllist : 0
    );

    $query  = 'cdagen = :cdagen:';
    $params = array(
      'cdagen' => $values['cdagen']
    );

    if (trim($tipoagg) == 'del' || !($row = self::findFirst(array($query, 'bind' => $params)))) {
      $row = new self();
    }

    $row->save($values);
  }
  //endregion

  //region Custom queries
  /**
   * Query:   INSERT
   * Return:  void
   */
  public static function insertNewAgent($cdagen, $tpcond, $fltota, $fllist) {
    $params = array('cdagen' => $cdagen, 'tpcond' => $tpcond, 'fltota' => $fltota, 'fllist' => $fllist);
    $query = "INSERT INTO abagen (cdagen, tpcond, fltota, fllist)
      VALUES (:cdagen, :tpcond, :fltota, :fllist)";
    Di::getDefault()->get('db')->query($query, $params);
  }

  /**
   * Query:   DELETE
   * Return:  void
   */
  public static function deleteAgent($cdagen) {
    $query = "DELETE a.*
      FROM abagen a
      WHERE a.cdagen = :cdagen";
    Di::getDefault()->get('db')->query($query, array('cdagen' => $cdagen));
  }
  //endregion
}
