<?php

namespace Go2B\Library;

use Phalcon\Mvc\User\Component;

class Translator extends Component
{
    const STANDARD_FILENAME = 'messages.json';
    const CUSTOM_FILENAME = 'custom.json';

    private $translationAccess = ['i18n', 'mt', 'it', 'en', 'es', 'fr', 'de'];
    private $translationMethods = ['_'];

    public function getTranslatedStrings($language = null)
    {
        if ( empty($language) ) {
            $language = $this->getDI()->get('session')->get('language');
        }
        $language = strtolower($language);

        $baseTranslationsPath = APP_PATH . $this->getDI()->get('config')->application->translationsDir;
        $filePath = $baseTranslationsPath . $language . '/' . self::STANDARD_FILENAME;
        $filePath2 = $baseTranslationsPath . $language . '/' . self::CUSTOM_FILENAME;;
        if (is_readable($filePath)) {
            $messages = json_decode(file_get_contents($filePath) ?: '{}', true);
            if (is_readable($filePath2)) {
                $messages = array_replace_recursive($messages, json_decode(file_get_contents($filePath2) ?: '{}', true));
            }
            return $messages;
        } else if (file_exists($baseTranslationsPath . $language . '/main.php')) {
            /** @global $messages */
            include $baseTranslationsPath . $language . '/main.php';
            return $messages ?: [];
        }

        return [];
    }

    public function updateTranslatedString($language, $key, $value)
    {
        $config = $this->getDI()->get('config');
        $baseTranslationsPath = APP_PATH . $config->application->translationsDir;
        $filePath = $baseTranslationsPath . $language . '/' . ($config->environment->isDev ? self::STANDARD_FILENAME : self::CUSTOM_FILENAME);

        if (is_writable($filePath) || (is_writable($baseTranslationsPath . $language) && !file_exists($filePath))) {
            $currentValues = [];
            if (is_readable($filePath)) {
                $currentValues = json_decode(file_get_contents($filePath) ?: '{}', true);
            }
            if (!empty($value)) {
                $currentValues = array_replace_recursive($currentValues, [$key => $value]);
            } else {
                unset($currentValues[$key]);
            }
            return file_put_contents($filePath, json_encode($currentValues, JSON_PRETTY_PRINT));
        }

        return false;
    }

    public function searchTranslationStrings($mode = 'both')
    {
        // .volt file
        // i18n._('string');

        // .php file
        // i18n->_('string');
        // ('i18n')->_('string');

        $success = true;
        $results = [];
        $config = $this->getDI()->get('config');

        $matchingPattern = '(' . implode('|', $this->translationAccess) . ')(?:[\'"]\))?(?:\.|->)(' . implode('|', $this->translationMethods) . ')\(\s*[\'"]([\w\-\d\. ]+)[\'"]\s*[\),]';

        /** @var DiskManager $fm */
        $fm = $this->getDI()->get('diskManager');

        if ($mode == 'both' || $mode == 'volt') {
            $basePath = APP_PATH . $config->application->viewsDir;
            $files = $fm->searchFilesInPath($basePath, '*.volt');
            foreach ($files as $file) {
                if (preg_match_all("/$matchingPattern/siU", file_get_contents($file), $matches, PREG_SET_ORDER)) {
                    foreach ($matches as $match) {
                        // $match[0] - full match
                        // $match[1] - access
                        // $match[2] - function
                        // $match[3] - key
                        $results[$match[3]] = '';
                    }
                }
            }
        }

        if ($mode == 'both' || $mode == 'php') {
            $files =
                array_merge(
                    $fm->searchFilesInPath(APP_PATH . $config->application->modelsDir, '*.php'),
                    $fm->searchFilesInPath(APP_PATH . $config->application->controllersDir, '*.php'),
//                    $fm->searchFilesInPathAPP_PATH . $config->application->helpersDir, '*.php'),
                    $fm->searchFilesInPath(APP_PATH . $config->application->libraryDir, '*.php'),
                    $fm->searchFilesInPath(APP_PATH . $config->application->formsDir, '*.php')
                );
            foreach ($files as $file) {
                if (preg_match_all("/$matchingPattern/siU", file_get_contents($file), $matches, PREG_SET_ORDER)) {
                    foreach ($matches as $match) {
                        // $match[0] - full match
                        // $match[1] - access
                        // $match[2] - function
                        // $match[3] - key
                        $results[$match[3]] = '';
                    }
                }
            }
        }

        $baseTranslationsPath = APP_PATH . $config->application->translationsDir;
        $translationDirs = $fm->searchFilesInPath($baseTranslationsPath, '*/', false);

        foreach ($translationDirs as $translationDir) {
            $lang = basename($translationDir);
            $translationPresenti = $this->getTranslatedStrings($lang);
            $translationToStore = array_replace($results, $translationPresenti);
            ksort($translationToStore, SORT_NATURAL);


            $success = $success && file_put_contents($translationDir . self::STANDARD_FILENAME, json_encode($translationToStore, JSON_PRETTY_PRINT)) !== false;
//            \yaml_emit_file(str_replace('.json', '.yml', $translationFile), $translationToStore);
//            if (file_put_contents($translationFile, json_encode($translationToStore, JSON_PRETTY_PRINT)) === false) {
//                echo 'Errore salvataggio ' . $translationFile . PHP_EOL;
//            } else {
//                echo 'Salvato ' . $translationFile . PHP_EOL;
//            }
        }

        return $success;
    }
}
