<?php

namespace Go2B\Library;

use Go2B\Models\B2bAppset;
use Go2B\Models\B2bApputi;

/**
 * REGEX PER SOSTITUIRE TUTTI GLI UTILIZZI PRECEDENTI
 *
 * (->getAppUtils\('(?:\w+)'(?:\s*\.\s*\$\w+)?\))->value
 * (->getAppUtils\("(?:\w+)"(?:\s*\.\s*\$\w+)?\))->value
 * $1
 *
 * (->getAppSettings\('(?:\w+)'(?:\s*\.\s*\$\w+)?\))->value
 * (->getAppSettings\("(?:\w+)"(?:\s*\.\s*\$\w+)?\))->value
 * $1
 *
 */

class Environment
{

    private static $systemParams;
    private static $customParams;

    /**
     * @return array
     */
    public static function getCustomParams()
    {
        if (!isset(self::$customParams)) {
            self::$customParams = [];
            // Prima recuperiamo i parametri hardcoded
            foreach (B2bAppset::getCurrentAppSettings() as $key => $hcParam) {
                self::$customParams[$hcParam['name']] = $hcParam['value'];
            }
            // Poi li sovrascriviamo con quelli presenti nel db
            foreach (B2bAppset::find() as $dbParam) {
                self::$customParams[$dbParam->name] = $dbParam->value;
            }

        }
        return self::$customParams;
    }

    public static function getCustomParam($name)
    {
        return self::hasCustomParam($name) ? self::getCustomParams()[$name] : null;
    }

    public static function hasCustomParam($name)
    {
        return array_key_exists($name, self::getCustomParams());
    }

    /**
     * @return array
     */
    public static function getSystemParams()
    {
        if (!isset(self::$systemParams)) {
            self::$systemParams = [];
            // Prima recuperiamo i parametri hardcoded
            foreach (B2bApputi::getCurrentAppUtils() as $key => $hcParam) {
                self::$systemParams[$hcParam['param']] = $hcParam['value'];
            }
            // Poi li sovrascriviamo con quelli presenti nel db
            foreach (B2bApputi::find() as $dbParam) {
                self::$systemParams[$dbParam->param] = $dbParam->value;
            }
        }
        return self::$systemParams;
    }

    public static function getSystemParam($name)
    {
        return self::hasSystemParam($name) ? self::getSystemParams()[$name] : null;
    }

    public static function hasSystemParam($name)
    {
        return array_key_exists($name, self::getSystemParams());
    }
}
