<?php

namespace Go2B\Library;

use Phalcon\Di;
use Phalcon\Mvc\User\Component;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class DiskManager extends Component
{
    const FILE_TEST_MODE_NONE = '';
    const FILE_TEST_MODE_READ = 'R';
    const FILE_TEST_MODE_WRITE = 'W';
    const FILE_TEST_MODE_READ_WRITE = 'RW';

    public function createPreviewImageForVideoOnWindows($movie)
    {
        $ffmpeg = 'c:\ffmpeg\bin\ffmpeg';
        $thumbnail = $movie . '.jpg';
        $interval = 5;
        //$cmd = "$ffmpeg -i $movie -deinterlace -an -ss $interval -t 00:00:01 -r 1 -y -vcodec mjpeg -f mjpeg $thumbnail 2>" . $movie . ".txt";
        $cmd = "$ffmpeg -i $movie -deinterlace -an -ss $interval -t 00:00:01 -r 1 -y -vcodec mjpeg -f mjpeg $thumbnail 2>&1";
        shell_exec($cmd);
    }

    public function createPreviewImageForVideoOnLinux($movie)
    {
        $ffmpeg = 'ffmpeg';
        $thumbnail = $movie . '.jpg';
        $interval = 5;
        //$cmd = "$ffmpeg -i $movie -deinterlace -an -ss $interval -t 00:00:01 -r 1 -y -vcodec mjpeg -f mjpeg $thumbnail 2>" . $movie . ".txt";
        $cmd = "$ffmpeg -i $movie -deinterlace -an -ss $interval -t 00:00:01 -r 1 -y -vcodec mjpeg -f mjpeg $thumbnail 2>&1";
        shell_exec($cmd);
    }

    public function saveGenericExcel($spreadsheet, $filename, $where)
    {
        $objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xlsx');
        $objWriter->save(str_replace('DiskManager', $filename, str_replace('.php', '.xlsx', __FILE__)));
        chmod("../app/library/" . $filename . ".xlsx", 0777);
        if (!file_exists('../public/io/' . $where)) {
            mkdir('../public/io/' . $where, 0777, true);
        }
        rename('../app/library/' . $filename . '.xlsx', '../public/io/' . $where . '/' . $filename . '.xlsx');
    }

    public function saveOrderExcel($spreadsheet, $filename)
    {
        try {
            $objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xlsx');
            $objWriter->save(str_replace('DiskManager', $filename, str_replace('.php', '.xlsx', __FILE__)));
            chmod("../app/library/" . $filename . ".xlsx", 0777);
            if (!file_exists('../public/io/template')) {
                mkdir('../public/io/template', 0777, true);
            }
            rename("../app/library/" . $filename . ".xlsx", "../public/io/template/" . $filename . ".xlsx");
        } catch (Exception $e) {
            $this->logger->info("Errore: " . $e->getMessage());
        }
    }

    public function saveSalesAnalysisExcel($spreadsheet, $filename)
    {
        $objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xlsx');
        $objWriter->save(str_replace('DiskManager', $filename, str_replace('.php', '.xlsx', __FILE__)));
        chmod("../app/library/" . $filename . ".xlsx", 0777);
        if (!file_exists('../public/io/analysis')) {
            mkdir('../public/io/analysis', 0777, true);
        }
        rename("../app/library/" . $filename . ".xlsx", "../public/io/analysis/" . $filename . ".xlsx");
    }

    public function saveBudgetExcel($spreadsheet, $filename)
    {
        $objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xlsx');
        $objWriter->save(str_replace('DiskManager', $filename, str_replace('.php', '.xlsx', __FILE__)));
        chmod("../app/library/" . $filename . ".xlsx", 0777);
        if (!file_exists('../public/io/budget')) {
            mkdir('../public/io/budget', 0777, true);
        }
        rename("../app/library/" . $filename . ".xlsx", "../public/io/budget/" . $filename . ".xlsx");
    }

    public function writeCsvExportOrders($filename, $orderTxt, $isSpecial = false)
    {
        try {
            // Double copy on io/csv/orders and io/export
            if (!file_exists('./io/csv/orders')) {
                if (!file_exists('./io/csv')) {
                    mkdir('./io/csv', 0777, true);
                }
                mkdir('./io/csv/orders', 0777, true);
            }
            $filePath = './io/csv/orders/' . $filename;
            file_put_contents($filePath, $orderTxt);
            chmod($filePath, 0777);

            $dir = !$isSpecial ? './io/export' : './io/exportusa';
            if (!file_exists($dir)) {
                mkdir($dir, 0777, true);
            }
            $filePath = $dir . '/' . $filename;
            file_put_contents($filePath, $orderTxt);
            chmod($filePath, 0777);
        } catch (\Exception $exception) {
            $logger = $this->getDI()->get('logger');
            $logger->error($exception->getTraceAsString());
        }
    }

    /** @deprecated  */
    public function execWindowsShellCommandPdfGeneration($htmlFilename, $pdfFilename, $isHorizontal = false)
    {
        if ($isHorizontal) {
            shell_exec('c:\wkhtmltopdf\bin\wkhtmltopdf -O landscape ' . $htmlFilename . ' ' . $pdfFilename);
        } else {
            shell_exec('c:\wkhtmltopdf\bin\wkhtmltopdf ' . $htmlFilename . ' ' . $pdfFilename);
        }
        chmod($pdfFilename, 0777);
    }

    /** @deprecated  */
    public function execLinuxShellCommandPdfGeneration($htmlFilename, $pdfFilename, $isHorizontal = false)
    {
//        $marginStr = ' -T 0 -R 0 -B 0 -L 0';
        $marginStr = '';
        if ($isHorizontal) {
            shell_exec('wkhtmltopdf' . $marginStr . ' -O landscape ' . $htmlFilename . ' ' . $pdfFilename);
        } else {
            shell_exec('wkhtmltopdf' . $marginStr . ' ' . $htmlFilename . ' ' . $pdfFilename);
        }
        chmod($pdfFilename, 0777);
    }

    public function execWindowsShellCommandPdfConditionsMerge($pdfFilenameOut, $pdfFilenameIn, $pdfConditionsFilename)
    {
        shell_exec('gswin64 -dBATCH -dNOPAUSE -q -sDEVICE=pdfwrite -sOutputFile="' . $pdfFilenameOut . '" "' . $pdfFilenameIn . '" "' . $pdfConditionsFilename . '" ');
        chmod($pdfFilenameOut, 0777);
    }

    public function execShellCommandPdfsMerge($pdfFilenameOut, $pdfFilenamesIn)
    {
        $basePath = dirname($pdfFilenameOut);
        if (!empty($pdfFilenamesIn) && !empty($pdfFilenameOut) && ((!file_exists($pdfFilenameOut) && is_writable($basePath)) || is_writable($pdfFilenameOut))) {
            $fileListArgument = '"' . implode('" "', $pdfFilenamesIn) . '"';
            if (PHP_OS == 'WINNT') {
                shell_exec('gswin64 -dBATCH -dNOPAUSE -q -sDEVICE=pdfwrite -sOutputFile="' . $pdfFilenameOut . '" ' . $fileListArgument);
            } else {
                shell_exec('/usr/bin/gs -dBATCH -dNOPAUSE -q -sDEVICE=pdfwrite -sOutputFile="' . $pdfFilenameOut . '" ' . $fileListArgument);
            }

            chmod($pdfFilenameOut, 0777);
        }
    }

    public function execLinuxShellCommandPdfConditionsMerge($pdfFilenameOut, $pdfFilenameIn, $pdfConditionsFilename)
    {
        shell_exec('/usr/bin/gs -dBATCH -dNOPAUSE -q -sDEVICE=pdfwrite -sOutputFile="' . $pdfFilenameOut . '" "' . $pdfFilenameIn . '" "' . $pdfConditionsFilename . '" ');
        chmod($pdfFilenameOut, 0777);
    }

    public function manualSync($user, $tipoSync = null)
    {
        $command = "" ;
        if(! is_null($tipoSync)){
            $command = " main ".$tipoSync;
        }
        if ($user != 'zan' || file_exists('/var/www/html/sinergiattiva/public_html/zan/app')) {
            if(Di::getDefault()->get('config')->environment->isDev == 1){
                shell_exec('php /var/www/html/app/console.php main' . $command);
            }else{
                shell_exec('php /var/www/html/sinergiattiva/public_html/' . $user . '/app/console.php main' . $command);
            }

        } else {
            shell_exec('php /var/www/html/zanb2b/app/console.php main' . $command);
        }
    }

    public function execShellCommandPdfGeneration($htmlFilename, $pdfFilename, $isHorizontal)
    {
        // $marginStr = ' -T 0 -R 0 -B 0 -L 0';
        $marginStr = '';
        $wkhtmltopdfBin = $this->getDI()->get('config')->environment->pdfConvExecutable;
        if (empty($wkhtmltopdfBin)) {
            $wkhtmltopdfBin = 'wkhtmltopdf';
        }
        shell_exec($wkhtmltopdfBin . $marginStr . ($isHorizontal ? ' -O landscape' : '') . ' ' . $htmlFilename . ' ' . $pdfFilename);
        chmod($pdfFilename, 0777);
    }

    public function searchFilesInPath($path, $pattern, $recursive = true)
    {
        $files = [];
        if (!empty($path) && ($path = DIRECTORY_SEPARATOR . trim($path, '/\\ ') . DIRECTORY_SEPARATOR) && is_dir($path)) {
            $files = glob($path . $pattern);

            if ($recursive) {
                foreach (glob($path . '*' . DIRECTORY_SEPARATOR, GLOB_ONLYDIR | GLOB_NOSORT) as $dir) {
                    $files = array_merge(
                        $files,
                        $this->searchFilesInPath($dir, $pattern)
                    );
                }
            }
        }

        return $files;
    }

    public function normalizePath($filepath)
    {
        $filepath = trim(DIRECTORY_SEPARATOR . $filepath, str_replace(DIRECTORY_SEPARATOR, '', '/\\ '));
        return str_replace(DIRECTORY_SEPARATOR . DIRECTORY_SEPARATOR, DIRECTORY_SEPARATOR, $filepath);
    }

    public function normalizePathInApp($filepath)
    {
        $filepath = trim(preg_replace('/^\/?' . preg_quote(ltrim(APP_PATH, DIRECTORY_SEPARATOR), '/') . '/', '', $filepath), str_replace(DIRECTORY_SEPARATOR, '', '/\\ '));
        return $this->normalizePath(APP_PATH . $filepath);
    }

    public function retriveFileContentInApp($filepath)
    {
        $absolutePath = $this->normalizePathInApp($filepath);
        if (!empty($filepath) && $this->fileExists($absolutePath, self::FILE_TEST_MODE_READ)) {
            return file_get_contents($absolutePath);
        }
        return false;
    }

    public function retriveFileContent($absoluteFilePath)
    {
        $absolutePath = $this->normalizePath($absoluteFilePath);
        if (!empty($filepath) && $this->fileExists($absolutePath, self::FILE_TEST_MODE_READ)) {
            return file_get_contents($absolutePath);
        }
        return false;
    }

    public function storeFileContentInApp($filepath, $contents = "", $append = false, $touch = false)
    {
        $absolutePath = $this->normalizePathInApp($filepath);
        $absoluteDir = dirname($absolutePath);
        if (!empty($filepath) &&
            (!empty($contents) || $touch) &&
            (!$this->fileExists($absolutePath) || $this->fileExists($absolutePath, self::FILE_TEST_MODE_WRITE)) &&
            (is_dir($absoluteDir) || mkdir($absoluteDir, 0775, true))
        ) {
            if ($append) {
                return file_put_contents($absolutePath, $contents, FILE_APPEND);
            } else {
                return file_put_contents($absolutePath, $contents);
            }
        }
        return false;
    }

    public function storeFileContent($absoluteFilePath, $contents = "", $append = false, $touch = false)
    {
        $absolutePath = $this->normalizePath($absoluteFilePath);
        $absoluteDir = dirname($absolutePath);
        if (!empty($absolutePath) &&
            (!empty($contents) || $touch) &&
            (!$this->fileExists($absolutePath) || $this->fileExists($absolutePath, self::FILE_TEST_MODE_WRITE)) &&
            (is_dir($absoluteDir) || mkdir($absoluteDir, 0775, true))
        ) {
            if ($append) {
                return file_put_contents($absolutePath, $contents, FILE_APPEND);
            } else {
                return file_put_contents($absolutePath, $contents);
            }
        }
        return false;
    }

    public function fileExistsInPublic($filepath, $testMode = self::FILE_TEST_MODE_NONE)
    {
        if (empty($filepath)) {
            return false;
        }

        $filepath = trim(preg_replace('/^\/?' . preg_quote(ltrim(APP_PATH, DIRECTORY_SEPARATOR), '/') . '/', '', $filepath), '/\\ ');
        $filepath = trim(preg_replace('/^\/?public\//', '', $filepath), '/\\ ');
        $absoluteFilepath = APP_PATH . 'public' . DIRECTORY_SEPARATOR . $filepath;

        return $this->fileExists($absoluteFilepath, $testMode);
    }

    public function fileExistsInApp($filepath, $testMode = self::FILE_TEST_MODE_NONE)
    {
        if (empty($filepath)) {
            return false;
        }

        $filepath = trim(preg_replace('/^\/?' . preg_quote(ltrim(APP_PATH, DIRECTORY_SEPARATOR), '/') . '/', '', $filepath), '/\\ ');
        $absoluteFilepath = APP_PATH . $filepath;

        return $this->fileExists($absoluteFilepath, $testMode);
    }

    public function fileExists($absoluteFilepath, $testMode = self::FILE_TEST_MODE_NONE)
    {
        if (empty($absoluteFilepath)) {
            return false;
        }

        $absoluteFilepath = $this->normalizePath($absoluteFilepath);

        return is_file($absoluteFilepath) && (empty($testMode) || (strpos($testMode, self::FILE_TEST_MODE_READ) === false || is_readable($absoluteFilepath)) || (strpos($testMode, self::FILE_TEST_MODE_WRITE) === false || is_writable($absoluteFilepath)));
    }


    /**
     * Metodo per recuperare la data di ultima modifica di un file all'interno nella Document Root
     *
     * @param $filepath
     * @return false|int
     */
    public function getModFileTime($filepath)
    {
        $absolutePath = $this->normalizePathInApp($filepath);

        if ($this->fileExistsInApp($absolutePath)) {
            return filemtime($absolutePath);
        }

        return false;
    }

}
