<?php

namespace Go2B\Library;

class Debugger
{
    static $stack = [];

    public static function trace(...$data)
    {
        var_dump(self::addToStack($data));
    }

    public static function traceDie(...$data)
    {
        dd(self::addToStack($data));
    }

    /**
     * @param array $data
     * @return array
     */
    protected static function addToStack(array $data): array
    {
        $time = microtime(true);
        $timeDiff = '-';
        $currentKey = count(self::$stack);
        if ($currentKey > 0 && ($prevEl = self::$stack[$currentKey - 1])) {
            $timeDiff = round($time - $prevEl['time'], 4);
        }

        $stackEl = [
            'time' => $time,
            'time_diff' => $timeDiff,
            'data' => $data,
        ];
        self::$stack[$currentKey] = $stackEl;

        return end(self::$stack);
//        return self::$stack[count(self::$stack) - 1];
    }
}
