<?php

use Phalcon\Http\Response;
use Phalcon\Mvc\Model\Resultset;
use Phalcon\DI;
use Phalcon\Mvc\Dispatcher;
use Phalcon\Mvc\Controller;
use \Firebase\JWT\JWT;
use \Firebase\JWT\ExpiredException;

class RestController extends ControllerBase
{
  /**
   * Model's name is registered from controller via parameter
   */
  private $modelName;

  /**
   * Model's name of relationship model
   */
  private $relationship = null;

  /**
   * Name of controller is passed in parameter
   */
  private $controllerName;

  /**
   * Value of primary key field of model (passed in parameter)
   */
  private $id;

  /**
   * Parameters
   */
  private $params;

  /**
   * Response object
   * @var Phalcon\Http\Response
   */
  private $response;

  /**
   * Language's messages
   * @var array
   */
  private $language;

  public function initialize() {
    $this->view->disable();

    // Set the language
    $this->setLanguage();

    $this->controllerName = $this->dispatcher->getControllerName();

    $modelName = $this->dispatcher->getParam('model');

    if (!empty($modelName)) {
      $this->modelName = $modelName;
    }
/*
    if ($this->controllerName == 'db') {
      // Access db resources
      $this->modelName = $this->controllerName;
    } else {
      // Other API TODO
    }*/

    $this->id = $this->dispatcher->getParam("id"); // id
    $this->relationship = $this->dispatcher->getParam("relationship"); // relationship
    $this->response = new Response();
  }

  //region API
  public function loginAction() {
    $this->view->disable();

    if ($this->request->isAjax()) {
      if ($this->request->isPost()) {
        $username = $this->request->getPost('username');
        $password = $this->request->getPost('password');

        $user = ApiAppusr::findFirstByUsername($this->request->getPost('username'));

        if (password_verify($this->request->getPost('password'), $user->password)) {
          $getConfig = $this->getConfigToken();

          $user = array(
            'id'        => $user->id,
            'username'  => $user->username,
            'password'  => $user->password
          );

          $this->response->setJsonContent(array(
            "code"  => 0,
            "res"   => "success",
            "token" => JWT::encode($getConfig + $user, $this->config->api->secret)
          ));

          $this->response->setStatusCode(200);
        } else {
          $this->response->setJsonContent('Wrong username and/or password');
          $this->response->setStatusCode(404, "NOT FOUND" . $this->request->getPost("username"));
        }
        $this->response->send();
      } else {
        $this->response->setStatusCode(405);
        $this->response->send();
      }
    } else {
      $this->response->setStatusCode(405);
      $this->response->send();
    }
  }

  public function renewTokenAction() {
    $this->view->disable();

    if ($this->request->isAjax()) {
      if ($this->request->isPost()) {
        $data = $this->request->getRawBody();
        $data = json_decode($data);
        $token= $data->{"refresh_token"};

        // Check if token exists and it's not empty
        if (empty($token) && $data->{"grant_type"} == "refresh_token") {
          $this->response->setStatusCode(403, "Forbidden");
          $this->response->send();
          die();
        }

        try {
          JWT::$leeway = 60; // 60 seconds
          $user = JWT::decode($token, $this->config->api->secret, array('HS256'));
        } catch (\Firebase\JWT\ExpiredException $e) {
          $this->response->setStatusCode(405, $e->getMessage());
          $this->response->send();
          die();
        }

        $username = $user->username;
        $password = $user->password;

        $user = ApiAppusr::findFirstByUsername($username);

        /*
        //comprobamos si existe el usuario
        $logged = Usuarios::findFirst(
          array(
            "conditions"=> "email = :email: AND password = :password:",
            "bind"      => array(
              "email" => $user->username,
              "password" => $user->password
            )
          )
        );

        //si no existe
        if ($logged == false) {
          //no es un token correcto
          //devolvemos un 401, Unauthorized
          $this->response->setStatusCode(401, "Unauthorized");
          $this->response->send();
          die();
        }

        $user = array(
          "id_usuario"=> $logged->id_usuario,
          "username"  => $logged->email,
          "password"  => $logged->password
        );

        $getConfig = $this->getConfigToken();

        $this->response->setJsonContent(array(
          "code"  => 0,
          "res"   => "success",
          "token" => JWT::encode($getConfig + $user, $this->getConfigApp()->key)
        ));*/

        $this->response->setStatusCode(200, "OK");
        $this->response->send();
      } else {
        $this->response->setStatusCode(405, "Method Not Allowed");
        $this->response->send();
      }
    } else {
      $this->response->setStatusCode(405, "Method Not Allowed");
      $this->response->send();
    }
  }
  //endregion

  /**
   * Set language of errors responses
   */
  public function setLanguage(){
    // Get the best language and all languages
    $bestLanguage = $this->request->getBestLanguage();
    $languages = $this->request->getLanguages();

    // Verify if exists the best language
    if (file_exists("../app/messages/" . $bestLanguage . "/main.php")) {
      require "../app/messages/" . $bestLanguage . "/main.php";
    } else if (!empty($languages)) {
      // Sort the languages for quality desc
      foreach ($languages as $key => $row) {
        $language[$key] = $row['language'];
        $quality[$key]  = $row['quality'];
      }
      array_multisort($quality, SORT_DESC, $language, SORT_ASC, $languages);

      // If not exist best language find the first language existing
      $cont = 0;
      foreach ($languages as $value) {
        if (file_exists("../app/messages/" . $value['language'] . "/main.php")) {
          require "../app/messages/" . $value['language'] . "/main.php";
        } else {
          $cont++;
        }
      }
    }

    // If not find any language set the desfault
    if (empty($messages)) {
      require "../app/messages/it/main.php";
    }

    // Set the messages language
    $this->language = $messages;
  }

  private function getStatusCode($error) {
    switch ($error) {
      case 'invalid_request':
        return 400;
      case 'unauthorized_client':
        return 400;
      case 'access_denied':
        return 401;
      case 'unsupported_response_type':
        return 400;
      case 'invalid_scope':
        return 400;
      case 'server_error':
        return 500;
      case 'temporarily_unavailable':
        return 400;
      case 'unsupported_grant_type':
        return 501;
      case 'invalid_client':
        return 401;
      case 'invalid_grant':
        return 400;
      case 'invalid_credentials':
        return 400;
      case 'invalid_refresh':
        return 400;
    }
  }

  public function accessAction() {
    try {
      $params = $this->oauth2->getParam(array('client_id', 'client_secret'));
      //echo json_encode($this->oauth2->getGrantType('client_credentials')->completeFlow($params));

      $result = $this->oauth2->getGrantType('client_credentials')->completeFlow($params);
      $this->sendJsonResponse($result);
    } catch (League\OAuth2\Server\Exception\ClientException $e) {
      //var_export($e);
      $code = OAuth2::getExceptionType($e->getCode());

      $this->response->setStatusCode($this->getStatusCode($code));
      $this->response->setJsonContent($e->getMessage());
      $this->response->send();

      //$this->response->setStatusCode($e->getCode(), $e->getMessage());
      //$this->response->setJsonContent($e->getMessage());
      //$this->response->send();

      $this->sendJsonResponse($e->getMessage(), $this->getStatusCode($code));
      //echo $e->getMessage();
    } catch (\Exception $e) {
      $code = OAuth2::getExceptionType($e->getCode());
      $this->sendJsonResponse($e->getMessage(), $this->getStatusCode($code));
      //$this->sendJsonResponse($e->getMessage(), 401);
      //echo $e->getTraceAsString();
    }
  }

  /**
   * Method Http accept: GET
   * @return JSON Retrive data by id
   */
  public function getAction() {
    $modelName = ucfirst($this->modelName);
    $data = $modelName::find($this->id);
    return $this->extractData($data);
  }

  /**
   * Method Http accept: GET
   * @return JSON Retrive all data, with and without relationship
   */
  public function listAction() {
    $modelName = $this->modelName;

    // Data of more models (relationship)
    if ($this->relationship != null) {
      $data = $modelName::findFirst($this->id);
      $relationship = $this->relationship;
      $data = $data->$relationship;
    } else {
      // Data of one model
      $data = $modelName::find();
    }
    return $this->extractData($data);
  }

  /**
   * Extract collection data to json
   * @param  Object     data object collecion with data
   * @return JSON       data in JSON
   */
  public function extractData($data) {
    // Extracting data to array
    $data->setHydrateMode(Resultset::HYDRATE_ARRAYS);
    $result = array();
    foreach ($data as $value) {
      $result[] = $value;
    }

    if ($this->id && !$this->relationship) {
      $result = $result[0];
    }

    $this->response->setJsonContent($result);

    return $this->response;
  }

  /**
   * Set and return json response from generic data
   * @param  mixed     generic data
   * @return JSON      data in JSON
   */
  public function sendJsonResponse($data, $status = 200) {
    $this->response->setStatusCode($status);
    $this->response->setRawHeader("HTTP/1.1 $status");
    $this->response->setJsonContent($data);
    return $this->response;
  }

  /**
   * Method Http accept: GET
   * Search data with field/value passed in parameter
   *
   * Ex : url: /user/search/name/edvaldo/email/edvaldo2107@gmail.com/order/name
   *      sql generated: select * from user where name='edvaldo' and email='edvaldo2107@gmail.com' order by name
   * Ex2 : url: /user/search/id_department/(IN)1,2/order/name
   *      sql generated: select * from user where id_department in (1,2) order by name
   */
  public function searchAction() {
    // Get model name
    $modelName = ucfirst($this->modelName);

    // Extracting parameterrs
    $params = array();
    for ($i = 3; $i < count($this->params); $i++) {
      $params[$this->params[$i]] = $this->params[++$i];
    }

    // Building the query
    $query = '$model = \\' . $modelName . "::query()";
    $query .= "->where(\"1=1\")"; //where default
    foreach ($params as $key => $value) {
      // If order by
      if ($key == "order") {
        $query .= "->orderBy(\"" . $value . "\")";
        break;
      } else if (strpos($value, "(IN)") !== false) {
        // If condition is IN
        $value = substr($value, strpos($value, "(IN)") + 4);
        $query .= "->andWhere(\"$key IN ($value)\")";
      } else {
        $query .= "->andWhere(\"$key = '$value'\")";
      }
    }
    $query .= "->execute();";
    eval($query);

    // Extracting data from resultset after query executed
    $model->setHydrateMode(Resultset::HYDRATE_ARRAYS);
    $result = array();
    foreach ($model as $key => $value) {
      $result[] = $value;
    }

    $this->response->setJsonContent($result);

    return $this->response;
  }

  /**
   * Method Http accept: POST (insert) and PUT (update)
   * Save/update data
   */
  public function saveAction() {
    $modelName = ucfirst($this->modelName);
    $model = new $modelName();
    $util = new Util();
    $data = array();

    // Get data
    $temp = $util->objectToArray($this->request->getJsonRawBody());

    // Verify if exist more than one element
    if ($util->existSubArray($temp)) {
      $data = $temp;
    } else {
      $data[0] = $temp;
    }

    // Scroll through the arraay data and make the action save/update
    foreach ($data as $key => $value) {
      // Verify if any value is date (CURRENT_DATE, CURRENT_DATETIME), if it was replace for current date
      foreach ($value as $k => $v) {
        if ($v == "CURRENT_DATE") {
          $now = new \DateTime();
          $value[$k] = $now->format('Y-m-d');
        } else if ($v == "CURRENT_DATETIME") {
          $now = new \DateTime();
          $value[$k] = $now->format('Y-m-d H:i:s');
        }
      }

      // If have param then update
      if (isset($this->id)) {
        // If passed by url
        $model = $modelName::findFirst($this->id);
      }

      if ($model->save($value)) {
        $dataResponse = get_object_vars($model);

        // Update
        if (isset($this->id)) {
          $this->response->setJsonContent(array('status' => 'OK'));
        } else {
          // Insert
          $this->response->setStatusCode(201, "Created");
          $this->response->setJsonContent(array(
            'status' => 'OK',
            'data' => array_merge($value, $dataResponse) //merge form data with return db
          ));
        }
      } else {
        $errors = array();
        foreach ($model->getMessages() as $message) {
          $errors[] = $this->language[$message->getMessage()]
            ? $this->language[$message->getMessage()]
            : $message->getMessage();
        }

        $this->response->setJsonContent(array(
          'status' => 'ERROR',
          'messages' => $errors
        ));
      }
    } // End foreach

    return $this->response;
  }

  /**
   * Method Http accept: DELETE
   */
  public function deleteAction() {
    $modelName = ucfirst($this->modelName);

    $model = $modelName::findFirst($this->id);

    // Delete if exists the object
    if ($model != false) {
      if ($model->delete() == true) {
        $this->response->setJsonContent(array('status' => "OK"));
      } else {
        $this->response->setStatusCode(409, "Conflict");

        $errors = array();
        foreach ($model->getMessages() as $message) {
          $errors[] = $this->language[$message->getMessage()]
            ? $this->language[$message->getMessage()]
            : $message->getMessage();
        }

        $this->response->setJsonContent(array('status' => "ERROR", 'messages' => $errors));
      }
    } else {
      $this->response->setStatusCode(409, "Conflict");
      $this->response->setJsonContent(array('status' => "ERROR", 'messages' => array("O elemento não existe")));
    }

    return $this->response;
  }
}
