<?php

namespace Go2B\Controllers;

use Go2B\Library\Environment;
use Go2B\Models\Anaart;
use Go2B\Models\Anagra;
use Go2B\Models\Anamat;
use Go2B\Models\Anaper;
use Go2B\Models\Artcla;
use Go2B\Models\Artcol;
use Go2B\Models\Artcrt;
use Go2B\Models\Artvar;
use Go2B\Models\Ascorp;
use Go2B\Models\Astest;
use Go2B\Models\B2bAddinf;
use Go2B\Models\B2bDisbdy;
use Go2B\Models\B2bModinf;
use Go2B\Models\B2bNdanag;
use Go2B\Models\B2bNdarti;
use Go2B\Models\B2bNdtagl;
use Go2B\Models\B2bSysusr;
use Go2B\Models\B2bUsrana;
use Go2B\Models\Ctarti;
use Go2B\Models\Cttest;
use Go2B\Models\Imgart;
use Go2B\Models\Lscorp;
use Go2B\Models\Ocasso;
use Go2B\Models\Occorp;
use Go2B\Models\Ocperc;
use Go2B\Models\Ocpert;
use Go2B\Models\Octagl;
use Go2B\Models\Octest;
use Go2B\Models\Postgl;
use Go2B\Models\Regqtm;
use Go2B\Models\Scacon;
use Go2B\Models\Scmcon;
use Go2B\Models\Smcorp;
use Go2B\Models\Sparti;
use Go2B\Models\Spmate;
use Go2B\Models\Tabvar;
use Go2B\Models\Tipmat;
use Go2B\Models\Tipolo;
use Go2B\Models\Tpcomp;
use Phalcon\Db\RawValue;
use Phalcon\Http\Request;
use Phalcon\Mvc\Model\Resultset\Simple as Resultset;

/**
 * @property-read Utility $utility
 */
class ModelController extends ControllerBase
{
    //region Initialize
    public function initialize()
    {
        parent::initialize();
    }
    //endregion

    //region Views functions
    public function indexAction()
    {
        $cdartn = $this->dispatcher->getParam('cdartn');
        $cdpers = $this->dispatcher->getParam('cdpers');
        $cdcolo = $this->dispatcher->getParam('cdcolo');
        $cdcolo = !empty($_GET['COL']) ? $_GET['COL'] : $cdcolo;

        $auth = $this->session->get('auth');
        $common = $this->utility->getCommonData('model', $auth['id']);
        $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($auth['id']);
        $idlang = $this->utility->getLanguage();
        $cdcata = $common['selected_catalog']->cdcata;

        $title = $common['catalogProductType'] == 0 ? $this->translate('_common.title.model') : $this->translate('_common.article');
        $this->tag->setTitle($title . ' ' . $cdartn);
        $this->session->set('goto', $cdartn);

        // Wizard needed!
        if ($this->utility->hasWizard($common['modelDetailStyle']) && (!$common['isOrder'] || $common['order_info']->tpordc == 1)) {
            return $this->response->redirect('model/wizard/' . $cdartn);
        }

        $this->addToRecentsCookie($cdartn);

        // if we have availability order, check parameter (0 or 1) else don't care (-1)
        if ($common['isOrder'] && $common['order_info']->tpordc == 0) {
            $notavailable = $common['shownotavailable'];
        } else {
            $notavailable = -1;
        }

        $model = $this->getFullProduct($cdcata, $cdartn, $nulist, $common['catalogProductType'] == 0, $idlang, !in_array($common['modelDetailStyle'], [0, 2, 3, 4, 5]));
        $tipolo = Tipolo::findFirstByCdartn($model->cdartn);
        $sameFabricArticles = [];

        // Paoloni
        if (($common['modelDetailStyle'] == 1) && ($common['catalogProductType'] == 1 || $common['catalogProductType'] == 2) && $model->tppers == 'PT') {
            $order = $common['isOrder'] ? Octest::getCurrentOrder($auth['id']) : null;
            $sameFabricArticles = $this->getAllArticlesForCurrentFabric($cdartn, $cdcata, $idlang, $nulist, $order);
        }

        $this->view->sameFabricArticles = $sameFabricArticles;
        $this->view->common = $common;
        $this->view->model = $model;
        $this->view->tipolo = $tipolo;
        $this->view->cdpers = $cdpers;
        $this->view->cdcolo = $cdcolo;
        $this->view->modinf = B2bModinf::findFirstByCdartn($cdartn);
        $this->view->ctg_vt = $this->session->has('ctg_view_type') ? $this->session->get('ctg_view_type') : '';
        $this->view->ctg_br = $this->session->get('ctg_brnd') ? $this->session->get('ctg_brnd')->cdtitl : '';
        $this->view->ctg_ln = $this->session->get('ctg_line') ? $this->session->get('ctg_line')->cdlinm : '';
        $this->view->ctg_sm = $this->session->get('ctg_seri') ? $this->session->get('ctg_seri')->cdserm : '';
        $this->view->showDownloadSection = $this->utility->getAppSettings('ShowDownloadModelDetail') == 1;
    }

    public function fullscreenAction()
    {
        $code = $this->dispatcher->getParam('code');

        $idlang = $this->utility->getLanguage();
        if ($this->utility->getAppSettings('ProductTypeOnCatalog') == 0) {
            $this->tag->setTitle($this->translate('_common.title.model') . ' ' . $code);
            $model = $this->getTipoloImages($code, $idlang);
        } else {
            $this->tag->setTitle($this->translate('_common.article') . ' ' . $code);
            $model = $this->getAnaartImages($code, $idlang);
        }

        $auth = $this->session->get('auth');
        $common = $this->utility->getCommonData('model', $auth['id']);

        $this->view->model = $model;
        $this->view->common = $common;
    }

    public function fullscreenvarAction()
    {
        $type = $_POST['type'];
        $code = $_POST['code'];
        $src = $_POST['src'];
        $descr = $_POST['descr'];

        if ($this->utility->getAppSettings('ModelDetailStyle') == 0) {
            $index = $_POST['index'];
        } else {
            $index = 0;
        }

        if ($type == 'artn') {
            $this->tag->setTitle($this->translate('_common.model') . ' ' . $code);
        } else {
            $this->tag->setTitle($this->translate('_common.article') . ' ' . $code);
        }

        $auth = $this->session->get('auth');
        $common = $this->utility->getCommonData('model', $auth['id']);
        $idlang = $this->utility->getLanguage();

        $cdcata = $common['selected_catalog']->cdcata;

        if ($type == 'artn') {
            $cdartn = $code;
        } else {
            $anaart = Anaart::findFirstByCdarti($code);
            $cdartn = $anaart != null ? $anaart->cdartn : '';
        }

        $images = [];
        for ($i = 0; $i < count($src); $i++) {
            $images[] = array('flimag' => $src[$i], 'descr' => $descr[$i]);
        }

        $this->view->type = $type;
        $this->view->code = $code;
        $this->view->cdartn = $cdartn;
        $this->view->images = $images;
        $this->view->index = $index;
        $this->view->common = $common;
    }

    public function img360Action()
    {
        $cdartn = $this->dispatcher->getParam('cdartn');

        $auth = $this->session->get('auth');
        $common = $this->utility->getCommonData('model', $auth['id']);

        $this->view->cdartn = $cdartn;
        $this->view->fl360d = B2bAddinf::getThreeDimensionalImageForModel($cdartn);
        $this->view->common = $common;
    }

    public function wizardAction()
    {
        $cdartn = $this->dispatcher->getParam('cdartn');
        $cdpers = $this->dispatcher->getParam('cdpers');

        $this->tag->setTitle($this->translate('_common.title.model') . ' ' . $cdartn);
        $this->session->set('goto', $cdartn);

        $lookbook = isset($_GET['lb']) ? $_GET['lb'] : -1;
        $look = isset($_GET['lk']) ? $_GET['lk'] : -1;
        $cdcolo = isset($_GET['cl']) ? $_GET['cl'] : -1;

        $auth = $this->session->get('auth');
        $common = $this->utility->getCommonData('model', $auth['id']);
        $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($auth['id']);
        $idlang = $this->utility->getLanguage();
        $cdcata = $common['selected_catalog']->cdcata;

        if (!$this->utility->hasWizard($common['modelDetailStyle']) || ($common['isOrder'] && $common['order_info']->tpordc == 0)) {
            return $this->response->redirect('model/' . $cdartn);
        }

        $this->addToRecentsCookie($cdartn);

        switch ($common['modelDetailStyle']) {
            case 2:
            case 4:
                $tagFilter = '';
                $request = new Request();
                if ($request->getQuery() != null && array_key_exists('flt', $request->getQuery())) {
                    $tagFilter = $request->getQuery()['flt'];
                }

                $model = $this->getFullTipoloForFabricWizard($cdcata, $cdartn, $nulist, $tagFilter, $idlang, $cdpers);
                $this->view->fl360d = B2bAddinf::getThreeDimensionalImageForModel($cdartn);
                break;
            case 3:
                $shouldFilter = false;
                $request = new Request();
                if ($request->getQuery() != null && array_key_exists('flt', $request->getQuery())) {
                    $shouldFilter = $request->getQuery()['flt'] == 'ava';
                }

                $model = $this->getFullTipoloForArticleWizard($cdcata, $cdartn, $nulist, $shouldFilter, $idlang);
                $this->view->features = Tpcomp::getAllFeatures();

                $customs = Anaart::getAllCustomArticlesFromModel($cdartn, $auth['id']);
                $full_customs = array();
                for ($i = 0; $i < count($customs); $i++) {
                    $currCustom = $customs[$i];
                    $currCustom->features = Sparti::getAllFeatures($currCustom->cdarti);
                    $full_customs[] = $currCustom;
                }
                $this->view->grouping = Artcrt::getGroupingForCurrentModel($cdcata, $cdartn);
                $this->view->customs = $full_customs;
                break;
            case 5:
                $model = $this->getFullTipoloForConfiguratorWizard($cdcata, $cdartn, $nulist, $idlang, $common['isOrder'] ? $common['order_info']->nuordc : null);
                //$this->view->customComponents = $this->getCustomComponentsForModel($cdartn);
                $this->view->hasComponents = Spmate::hasComponents($cdartn);
                break;
        }

        $this->view->model = $model;
        $this->view->common = $common;
        $this->view->currency = $common['isOrder'] ? $this->utility->getCurrencySymbol($common['order_info']->cdvalu) : '&euro;';
        $this->view->modinf = B2bModinf::findFirstByCdartn($cdartn);
        $this->view->regqtm = Regqtm::getModelRules($cdartn);
        $this->view->fromLook = $lookbook != -1 && $look != -1 ? $lookbook . '/' . $look : -1;
        $this->view->ctg_vt = $this->session->has('ctg_view_type') ? $this->session->get('ctg_view_type') : '';
        $this->view->ctg_ln = $this->session->get('ctg_line') ? $this->session->get('ctg_line')->cdlinm : '';
        $this->view->ctg_br = $this->session->get('ctg_brnd') ? $this->session->get('ctg_brnd')->cdtitl : '';
        $this->view->ctg_sm = $this->session->get('ctg_seri') ? $this->session->get('ctg_seri')->cdserm : '';
        $this->view->currentFabric = isset($cdpers) ? Anaper::findFirstByCdpers($cdpers) : '';
        $this->view->currentColor = $cdcolo;
        $this->view->showDownloadSection = $this->utility->getAppSettings('ShowDownloadModelDetail') == 1;
    }
    //endregion

    //region Ajax functions
    public function getCurrentArticleAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $modal = isset($_POST['modal']) ? true : false;

            $auth = $this->session->get('auth');
            $id_usr = $auth['id'];
            $order = Octest::getCurrentOrder($id_usr);

            $cdarti = $_POST['cdarti'];
            $cdcolo = $_POST['cdcolo'];
            $cdtagl = $_POST['cdtagl'];
            $tppers = $_POST['tppers'];

            // No duplicate row here! You are on cart.
            $order_rows = isset($_POST['nurorc'])
                ? $this->utility->getOrderRows($cdarti, $cdcolo, $order->nuordc, $_POST['nurorc'])
                : $this->utility->getOrderRows($cdarti, $cdcolo, $order->nuordc);

            // General info
            $idlang = $this->utility->getLanguage();
            $numdis = $this->utility->getCustomDiscount();

            // Sizes and assortments for current article/tissue + order rows
            $sizes = Postgl::getSizesWithPrices($cdtagl, $cdarti, $order->nulist);
            $anaart = Anaart::findFirstByCdarti($cdarti);
            $cdartn = $anaart != null ? $anaart->cdartn : '';
            $sizes = $this->utility->getRules($sizes, $cdartn, $cdarti, $cdcolo);
            $tipolo = Tipolo::findFirstByCdartn($cdartn);

            $hasConfigurator = $this->utility->getAppSettings('ModelDetailStyle') == 5;

            $discount = array();
            if ($numdis > 0) {
                $discount = B2bDisbdy::getCustomDiscountForCdarti($numdis, $cdarti);
            }

            $assortments = $this->getAssortmentsFromCdarti($cdarti);
            if ($tppers == 'PT') {
                $variants = $this->utility->getAppSettings('ParamVariation') == 1 ? Artvar::getAllVariationsForArticle($cdarti) : array();
            }

            // Availability, if needed
            if ($order->tpordc == 0) {
                if ($tppers != 'PT') {
                    $ava_sizes = $this->utility->getArticleAvailability($cdarti);
                } else {
                    $ava_sizes = $this->utility->getColorVariantArticleAvailability($cdarti, $cdcolo, $cdtagl);
                }
            }

            if ($hasConfigurator) {
                if ($cdcolo != 'CUSTOM') {
                    if ($cdarti == $cdartn) {
                        $components = Spmate::getDefaultMaterialTypes($cdartn);
                        $prezzo = $this->calculatePriceFromComponents($components, $cdartn, $order->nulist);
                    } else {
                        $components = Smcorp::getAllComponents($cdarti);
                        $prezzo = Lscorp::getPriceForArticle($order->nulist, $cdarti);
                    }
                } else {
                    $cdartn = Ocpert::findFirstByNupers($cdarti)->cdartn;
                    $components = Ocperc::getAllComponents($cdarti);
                    $prezzo = $this->calculatePriceFromComponents($components, $cdartn, $order->nulist);
                }
            }

            /*
      A) availability order AT / reservation order AF
      B) tissue BT / article BF
      C) backstitch CT / no backstitch CF - by param, don't care if BF
      D) multiple dates DT / no multiple dates DF - by param, don't care if AT or BT
      E) multiple availability date ET / no multiple availability dates EF - don't care if AF
      */
            $html = "";
            if ($modal) {
                $html .= !$hasConfigurator
                    ? $this->getHtmlCodeForModal($cdarti, $cdcolo, $cdtagl, $tppers, $idlang)
                    : $this->getHtmlCodeForConfiguratorModal($cdarti, $cdartn, $cdcolo, $cdtagl, $components, $idlang);
            }

            $dateTypeAvaOrder = $this->utility->getAppSettings('ParamDateManagementAvailability');
            $dateTypeResOrder = $this->utility->getAppSettings('ParamDateManagement');
            $dateOffset = $this->utility->getAppSettings('ParamAvailabilityDateManagement');
            $visible_delivery = $this->utility->getAppSettings('ParamQuantityDeliveryView');
            $visible_indicative = $this->utility->getAppSettings('ParamQuantityIndicativeView');
            $visible_notes = $this->utility->getAppSettings('ParamQuantityNotesView');
            $visible_reference = $this->utility->getAppSettings('ParamQuantityReferenceView');

            $canGoToCart = $order->dtmcli != null ||
                ($order->tpordc == 0 && ($dateTypeAvaOrder == 1 || $dateTypeAvaOrder == 3)) ||
                ($order->tpordc == 1 && ($dateTypeResOrder == 1 || $dateTypeResOrder == 3)) ||
                ($order->tpordc == 1 && $dateTypeResOrder == 4 && $order->dtmcoi != null && $order->dtmcof != null);

            $dateOffset = $order->tpordc == 0 && $dateTypeAvaOrder != 4 ? 0 : $dateOffset;

            $showInfo = array(
                'showDelivery' => $visible_delivery,
                'showIndicative' => $visible_indicative == 1,
                'showNotes' => $visible_notes == 1,
                'showReference' => $visible_reference == 1
            );

            if (!$hasConfigurator) {
                if ($order->tpordc == 0) {
                    if ($tppers == 'PT') {
                        $html .= $this->getHtmlCodeForAvaTissue($sizes, $tipolo, $order_rows, $ava_sizes, $variants, $dateOffset,
                            $showInfo, $modal, $canGoToCart, $discount);
                    } else {
                        $html .= $this->getHtmlCodeForAvaColor($sizes, $tipolo, $order_rows, $ava_sizes, $assortments, $dateOffset,
                            $showInfo, $modal, $canGoToCart, $discount);
                    }
                } else {
                    if ($tppers == 'PT') {
                        $html .= $this->getHtmlCodeForResTissue($sizes, $assortments, $tipolo, $order_rows, $variants,
                            $order->dtmcli, $showInfo, $modal, $canGoToCart, $discount);
                    } else {
                        $catalogs = $this->utility->getAvailableCatalogs($id_usr);
                        $selected_catalog = $this->utility->getSelectedCatalog(true, $order, $catalogs);
                        $exist = isset($selected_catalog->cdcata) && Cttest::findFirstByCdcata($selected_catalog->cdcata) != null;
                        $periods = ($dateTypeAvaOrder < 3 || $dateTypeResOrder < 3)
                            ? (!empty(Scmcon::getPeriodsForCatArti($exist ? $selected_catalog->cdcata : $order->cdcata, $cdarti))
                                ? Scmcon::getPeriodsForCatArti($exist ? $selected_catalog->cdcata : $order->cdcata, $cdarti)
                                : Scacon::getPeriodsForCatalog($exist ? $selected_catalog->cdcata : $order->cdcata))
                            : '';

                        $html .= $this->getHtmlCodeForResColor($sizes, $assortments, $tipolo, $order_rows, $dateTypeResOrder,
                            $periods, $this->utility->getAppSettings('ParamQuantityMultipleDeliveryView') == 1,
                            $showInfo, $modal, $canGoToCart, $discount);
                    }
                }
            } else {
                $html .= $this->getHtmlCodeForConfigurator($sizes, $order_rows, $prezzo, $modal, $canGoToCart);
            }

            /*
      if ($modal && $common['isOrder'] && $common['order_info']->tpordc == 0 && $auth['type'] == 4 && $common['order_info']->indema != '') {
        $anaart = Anaart::findFirstByCdarti($cdarti);
        $html .= $this-> getFooterModalNotifyAvailability($anaart->cdartn, $tppers);
      }
*/
            echo json_encode($html);
        }
    }

    public function getCurrentArticleJsonAction()
    {
        $this->view->disable();
        $this->response
            ->setHeader(
                'Content-Type',
                'application/json; charset=UTF-8'
            );

        try {
            if ($this->request->isPost() && $this->request->isAjax()) {
                $postData = $this->request->getPost();
                $isModal = isset($postData['modal']) ? true : false;

                // General info
                $auth = $this->session->get('auth');
                $id_usr = $auth['id'];
                $order = Octest::getCurrentOrder($id_usr);
                $idlang = $this->utility->getLanguage();
                $numdis = $this->utility->getCustomDiscount();
                $customer = Anagra::findCustomerByKey($order->tpanag, $order->cdanag);

                $cdartn = $postData['cdartn'];
                $tipolo = Tipolo::findFirstByCdartn($cdartn);
                if (!$tipolo instanceof Tipolo) {
                    throw new \Exception($this->i18n->_('_common.model.notfound'));
                }

                $tppers = $tipolo->tppers;
                $cdtagl = $tipolo->cdtagl;
                $items = Anaart::find(['cdartn = :cdartn: AND flbloc = 0', 'bind' => ['cdartn' => $cdartn]]);
                $visualizationType = Environment::getCustomParam('ModalTypeOnCatalog');

                $articles = [];
                /** @var Anaart $item */
                foreach ($items as $item) {
                    $cdarti = $item->cdarti;
                    $cdcolo = $item->cdcolo;
                    // No duplicate row here! You are on cart.
                    $order_rows = $this->utility->getOrderRows($cdarti, $cdcolo, $order->nuordc);

                    $discount = array();
                    if ($numdis > 0) {
                        $discount = B2bDisbdy::getCustomDiscountForCdarti($numdis, $cdarti);
                    } else if ($customer instanceof Anagra && $this->utility->getAppSettings('ShowBaseCustomerDiscount') == 1) {
                        $discount = ['sconto' => $customer->scont1, 'priority' => 1];
                    }

                    // Sizes and assortments for current article/tissue + order rows
                    $sizes = $this->utility->getRules(
                        Postgl::getSizesWithPrices($cdtagl, $cdarti, $order->nulist),
                        $cdartn, $cdarti, $cdcolo, $order_rows, !empty($discount['sconto']) ? $discount['sconto'] : 0);

                    $additionalInfo = [
                        'flimag' => $this->utility->getImageModelLink($item->flimag),
                        'sizes' => $sizes,
                    ];

                    if (!empty($order_rows)) {
                        $additionalInfo['orderWithoutQuantity'] = $order_rows[0]->quanti == 0;
                        $additionalInfo['notes'] = $order_rows[0]->dsnoco;
                        $additionalInfo['date'] = $order_rows[0]->dtmcli;
                    }

                    $articles[] = array_merge($item->toArray(), $additionalInfo);
                }

                $res = [
                    'type' => $tipolo->tppers,
                    'visualizationType' => $visualizationType,
                    'model' => array_merge(
                        /* anagrafica modello */
                        $tipolo->toArray(), [
                        'flimag' => $this->utility->getImageModelLink($tipolo->flimag),
                        /* anagrafica articoli */
                        'articles' => $articles
                    ]),
                ];

//                $hasConfigurator = $this->utility->getAppSettings('ModelDetailStyle') == 5;
//
//                $discount = array();
//                if ($numdis > 0) {
//                    $discount = B2bDisbdy::getCustomDiscountForCdarti($numdis, $cdarti);
//                }
//
//                $assortments = $this->getAssortmentsFromCdarti($cdarti);
//                if ($tppers == 'PT') {
//                    $variants = $this->utility->getAppSettings('ParamVariation') == 1 ? Artvar::getAllVariationsForArticle($cdarti) : array();
//                }
//
//                // Availability, if needed
//                if ($order->tpordc == 0) {
//                    if ($tppers != 'PT') {
//                        $ava_sizes = $this->utility->getArticleAvailability($cdarti);
//                    } else {
//                        $ava_sizes = $this->utility->getColorVariantArticleAvailability($cdarti, $cdcolo, $cdtagl);
//                    }
//                }
//
//                if ($hasConfigurator) {
//                    if ($cdcolo != 'CUSTOM') {
//                        if ($cdarti == $cdartn) {
//                            $components = Spmate::getDefaultMaterialTypes($cdartn);
//                            $prezzo = $this->calculatePriceFromComponents($components, $cdartn, $order->nulist);
//                        } else {
//                            $components = Smcorp::getAllComponents($cdarti);
//                            $prezzo = Lscorp::getPriceForArticle($order->nulist, $cdarti);
//                        }
//                    } else {
//                        $cdartn = Ocpert::findFirstByNupers($cdarti)->cdartn;
//                        $components = Ocperc::getAllComponents($cdarti);
//                        $prezzo = $this->calculatePriceFromComponents($components, $cdartn, $order->nulist);
//                    }
//                }
//
//                /*
//                A) availability order AT / reservation order AF
//                B) tissue BT / article BF
//                C) backstitch CT / no backstitch CF - by param, don't care if BF
//                D) multiple dates DT / no multiple dates DF - by param, don't care if AT or BT
//                E) multiple availability date ET / no multiple availability dates EF - don't care if AF
//                */
//
//
//                $html = "";
//                if ($isModal) {
//                    $html .= !$hasConfigurator
//                        ? $this->getHtmlCodeForModal($cdarti, $cdcolo, $cdtagl, $tppers, $idlang)
//                        : $this->getHtmlCodeForConfiguratorModal($cdarti, $cdartn, $cdcolo, $cdtagl, $components, $idlang);
//                }
//
//                $dateTypeAvaOrder = $this->utility->getAppSettings('ParamDateManagementAvailability');
//                $dateTypeResOrder = $this->utility->getAppSettings('ParamDateManagement');
//                $dateOffset = $this->utility->getAppSettings('ParamAvailabilityDateManagement');
//                $visible_delivery = $this->utility->getAppSettings('ParamQuantityDeliveryView');
//                $visible_indicative = $this->utility->getAppSettings('ParamQuantityIndicativeView');
//                $visible_notes = $this->utility->getAppSettings('ParamQuantityNotesView');
//                $visible_reference = $this->utility->getAppSettings('ParamQuantityReferenceView');
//
//                $canGoToCart = $order->dtmcli != null ||
//                    ($order->tpordc == 0 && ($dateTypeAvaOrder == 1 || $dateTypeAvaOrder == 3)) ||
//                    ($order->tpordc == 1 && ($dateTypeResOrder == 1 || $dateTypeResOrder == 3)) ||
//                    ($order->tpordc == 1 && $dateTypeResOrder == 4 && $order->dtmcoi != null && $order->dtmcof != null);
//
//                $dateOffset = $order->tpordc == 0 && $dateTypeAvaOrder != 4 ? 0 : $dateOffset;
//
//                $showInfo = array(
//                    'showDelivery' => $visible_delivery,
//                    'showIndicative' => $visible_indicative == 1,
//                    'showNotes' => $visible_notes == 1,
//                    'showReference' => $visible_reference == 1
//                );
//
//                if (!$hasConfigurator) {
//                    if ($order->tpordc == 0) {
//                        if ($tppers == 'PT') {
//                            $html .= $this->getHtmlCodeForAvaTissue($sizes, $tipolo, $order_rows, $ava_sizes, $variants, $dateOffset,
//                                $showInfo, $isModal, $canGoToCart, $discount);
//                        } else {
//                            $html .= $this->getHtmlCodeForAvaColor($sizes, $tipolo, $order_rows, $ava_sizes, $assortments, $dateOffset,
//                                $showInfo, $isModal, $canGoToCart, $discount);
//                        }
//                    } else {
//                        if ($tppers == 'PT') {
//                            $html .= $this->getHtmlCodeForResTissue($sizes, $assortments, $tipolo, $order_rows, $variants,
//                                $order->dtmcli, $showInfo, $isModal, $canGoToCart, $discount);
//                        } else {
//                            $catalogs = $this->utility->getAvailableCatalogs($id_usr);
//                            $selected_catalog = $this->utility->getSelectedCatalog(true, $order, $catalogs);
//                            $exist = isset($selected_catalog->cdcata) && Cttest::findFirstByCdcata($selected_catalog->cdcata) != null;
//                            $periods = ($dateTypeAvaOrder < 3 || $dateTypeResOrder < 3)
//                                ? (!empty(Scmcon::getPeriodsForCatArti($exist ? $selected_catalog->cdcata : $order->cdcata, $cdarti))
//                                    ? Scmcon::getPeriodsForCatArti($exist ? $selected_catalog->cdcata : $order->cdcata, $cdarti)
//                                    : Scacon::getPeriodsForCatalog($exist ? $selected_catalog->cdcata : $order->cdcata))
//                                : '';
//
//                            $html .= $this->getHtmlCodeForResColor($sizes, $assortments, $tipolo, $order_rows, $dateTypeResOrder,
//                                $periods, $this->utility->getAppSettings('ParamQuantityMultipleDeliveryView') == 1,
//                                $showInfo, $isModal, $canGoToCart, $discount);
//                        }
//                    }
//                } else {
//                    $html .= $this->getHtmlCodeForConfigurator($sizes, $order_rows, $prezzo, $isModal, $canGoToCart);
//                }
//
//                /*
//                      if ($modal && $common['isOrder'] && $common['order_info']->tpordc == 0 && $auth['type'] == 4 && $common['order_info']->indema != '') {
//                        $anaart = Anaart::findFirstByCdarti($cdarti);
//                        $html .= $this-> getFooterModalNotifyAvailability($anaart->cdartn, $tppers);
//                      }
//                */
//                echo json_encode($html);
            }
        } catch (\Exception $ex) {
            $res = [
                'error' => $ex->getCode(),
                'message' => $ex->getMessage(),
            ];
        }

        //Set the content of the response
        $this->response->setContent(json_encode($res));

        //Return the response
        return $this->response;
    }

    public function saveOrderRowsFromCurrentArticleJsonAction()
    {
        $this->view->disable();
        $this->response
            ->setHeader(
                'Content-Type',
                'application/json; charset=UTF-8'
            );

        try {
            if ($this->request->isPost() && $this->request->isAjax()) {
                $postData = $this->request->getPost();
                $isModal = isset($postData['modal']) ? true : false;

                // General info
                $auth = $this->session->get('auth');
                $id_usr = $auth['id'];
                $order = Octest::getCurrentOrder($id_usr);
                $idlang = $this->utility->getLanguage();
                $numdis = $this->utility->getCustomDiscount();
                $customer = Anagra::findCustomerByKey($order->tpanag, $order->cdanag);

                $cdartn = $postData['cdartn'];
                $tipolo = Tipolo::findFirstByCdartn($cdartn);
                if (!$tipolo instanceof Tipolo) {
                    throw new \Exception($this->i18n->_('_common.model.notfound'));
                }

                $tppers = $tipolo->tppers;
                $cdtagl = $tipolo->cdtagl;
                $items = Anaart::find(['cdartn = :cdartn: AND flbloc = 0', 'bind' => ['cdartn' => $cdartn]]);
                $visualizationType = Environment::getCustomParam('ModalTypeOnCatalog');

                // Onde evitare errori recuperiamo di nuovo i dati e i prezzi dal db
                $articles = [];
                /** @var Anaart $item */
                foreach ($items as $item) {
                    $cdarti = $item->cdarti;
                    $cdcolo = $item->cdcolo;
                    // No duplicate row here! You are on cart.
                    $order_rows = $this->utility->getOrderRows($cdarti, $cdcolo, $order->nuordc);

                    $discount = array();
                    if ($numdis > 0) {
                        $discount = B2bDisbdy::getCustomDiscountForCdarti($numdis, $cdarti);
                    } else if ($customer instanceof Anagra && $this->utility->getAppSettings('ShowBaseCustomerDiscount') == 1) {
                        $discount = ['sconto' => $customer->scont1, 'priority' => 1];
                    }

                    // Sizes and assortments for current article/tissue + order rows
                    $sizes = $this->utility->getRules(
                        Postgl::getSizesWithPrices($cdtagl, $cdarti, $order->nulist),
                        $cdartn, $cdarti, $cdcolo, $order_rows, !empty($discount['sconto']) ? $discount['sconto'] : 0);

                    $additionalInfo = [
                        'flimag' => $this->utility->getImageModelLink($item->flimag),
                        'sizes' => $sizes,
                    ];

                    if (!empty($order_rows)) {
                        $additionalInfo['orderWithoutQuantity'] = $order_rows[0]->quanti == 0;
                        $additionalInfo['notes'] = $order_rows[0]->dsnoco;
                        $additionalInfo['date'] = $order_rows[0]->dtmcli;
                    }

                    $articles[] = array_merge($item->toArray(), $additionalInfo);
                }

                $articlesQty = array_column($postData['articles'], 'sizes', 'cdarti');
                $articlesWithoutQuantity = array_column($postData['articles'], 'orderWithoutQuantity', 'cdarti');
                $articlesNotes = array_column($postData['articles'], 'notes', 'cdarti');
                $articlesDates = array_column($postData['articles'], 'date', 'cdarti');

                // TODO Inserire/Aggiornare le righe d'ordine
                foreach ($articles as $article) {
                    // Rimuoviamo l'articolo dall'ordine
                    Octagl::removeOrderRowForArticle($order->nuordc, $article['cdarti']);
                    Occorp::removeOrderRowForArticle($order->nuordc, $article['cdarti']);

                    if (!empty($articlesQty[$article['cdarti']])) {
                        $qtaTot = array_sum(array_column($articlesQty[$article['cdarti']], 'quantity'));
                        if ($qtaTot <= 0 && empty($articlesWithoutQuantity[$article['cdarti']])) {
                            continue;
                        }
                        $seqrap = Occorp::getMaxIndexForOrder($order->nuordc);

                        // Riga Ordine
                        $occorp = new Occorp ();
                        $occorp->nuordc = $order->nuordc;
                        $occorp->seqrap = $seqrap + 1;
                        $occorp->quanti = $qtaTot;

                        $occorp->cdcata = $order->cdcata;
                        $occorp->cdarti = $article['cdarti'];
                        $occorp->seqdet = 1;
                        $occorp->cdcolo = $article['cdcolo'] != '' ? $article['cdcolo'] : new RawValue('""');
                        // TODO Questo dovrebbe servire solo per PT - cmq dobbiamo fixarlo
                        $occorp->cdvari = new RawValue('""');
//                        $occorp->cdvari = $cdvari != '' ? $cdvari : new RawValue('""');

                        $dsnoco = $article['notes'];
                        if (array_key_exists($article['cdarti'], $articlesNotes)) {
                            $dsnoco = $articlesNotes[$article['cdarti']];
                        }
                        $occorp->dsnoco = $dsnoco != '' ? $dsnoco : new RawValue('""');
                        $dtmcli = $article['date'];
                        if (array_key_exists($article['cdarti'], $articlesDates)) {
                            $dtmcli = $articlesDates[$article['cdarti']];
                        }
                        $occorp->dtmcli = $dtmcli != '' ? $dtmcli : "0000-00-00";

                        // TODO Questi non capisco proprio che cazzo significano - cmq dobbiamo fixarli
                        $occorp->indorc = new RawValue('""');
//                        $occorp->indorc = $indorc != '' ? $indorc : new RawValue('""');
                        $occorp->sgrifc = new RawValue('""');
//                        $occorp->sgrifc = $sgrifc != '' ? $sgrifc : new RawValue('""');

                        $everythingOk = $occorp->save();
                        // Se siamo riusciti a salvare la riga d'ordine allora salviamo anche le quantità per taglia
                        $errorCode = 0;

                        foreach ($articlesQty[$article['cdarti']] as $index => $sizeQty) {
                            $size = $article['sizes'][$index];
                            if ($size->taglia != $sizeQty['taglia']) {
                                $everythingOk = false;
                                $errorCode = 2;
                            }

                            if (!$everythingOk) {
                                break;
                            }

                            $new_octagl = new Octagl();
                            $new_octagl->nurorc = $occorp->nurorc;
                            $new_octagl->dstagl = $size->taglia;
                            $new_octagl->prezzo = $size->prezzo;
                            $new_octagl->quanti = (!empty($sizeQty['quantity']) ? $sizeQty['quantity'] : 0);
                            $new_octagl->scont1 = $size->sconto;
                            if ($new_octagl->scont1 == 0 && empty($numdis)) {
                                // Se non sono presenti altri sconti personalizzati applichiamo quello su anagrafica cliente
                                if ($order->tpanag == 'CL' && !empty($order->cdanag) && ($anagra = Anagra::findCustomerByKey($order, $order->cdanag))) {
                                    $new_octagl->scont1 = $anagra->scont1;
                                }
                            }
                            $new_octagl->scont2 = 0;
                            $new_octagl->scont3 = 0;
                            $everythingOk &= $new_octagl->save();
                            if(empty($errorCode)) {
                                $errorCode = 100 + $index;
                            }
                        }

                        if (!$everythingOk) {
                            throw new \Exception($this->i18n->_('quantity.insert.unsuccess'), $errorCode);
                        }
                    }

                    // TODO ?? Assortimenti ??
                }

                if ($this->utility->getAppSettings('ParamCouponPromo') == 2) {
                    $this->utility->verifyPromos($order->nuordc);
                }

                $res = [
                    'success' => true,
                    'message' => $this->i18n->_('quantity.insert.success.nocart'),
                    'tot' => Occorp::getOrderTotals($order->nuordc),
                ];
            }
        } catch (\Exception $ex) {
            $res = [
                'error' => $ex->getCode(),
                'message' => $ex->getMessage(),
            ];
            $this->logger->debug($ex->getTraceAsString());
        }

        //Set the content of the response
        $this->response->setContent(json_encode($res));

        //Return the response
        return $this->response;
    }

    public function saveOrderRowAction()
    {
        $this->view->disable();

        $request = $this->request;
        if ($request->isPost() && $request->isAjax()) {
            $nuordc = $_POST['nuordc'];
            $nurorc = isset($_POST['nurorc']) ? $_POST['nurorc'] : "-1";
            $cdarti = $_POST['cdarti'];
            $cdcolo = isset($_POST['cdcolo']) ? $_POST['cdcolo'] : "";
            $cdvari = isset($_POST['cdvari']) ? $_POST['cdvari'] : "";
            $cdcata = $_POST['cdcata'];
            $quanti = $_POST['quanti'];
            $seqdet = $_POST['seqdet'];
            $dtmcli = isset($_POST['dtmcli']) && $_POST['dtmcli'] != '1970-01-01' ? $_POST['dtmcli'] : "0000-00-00";
            $sgrifc = isset($_POST['sgrifc']) ? $_POST['sgrifc'] : "";
            $indorc = isset($_POST['indorc']) ? $_POST['indorc'] : "";
            $dsnoco = isset($_POST['dsnoco']) ? $_POST['dsnoco'] : "";
            $octagl = isset($_POST['octagl']) ? $_POST['octagl'] : array();
            $ocasso = isset($_POST['ocasso']) ? $_POST['ocasso'] : array();

            if ($this->utility->getAppSettings('ParamCouponPromo') == 2) {
                $this->utility->verifyPromos($nuordc);
            }

            $order_info = Octest::getCurrentOrder($this->session->get('auth')['id']);
            $numdis = $this->utility->getCustomDiscount($order_info);

            $cdartn = Anaart::findFirstByCdarti($cdarti)->cdartn;
            $regqtm = Regqtm::getRules($cdartn, $cdarti, $cdcolo);
            if (count($regqtm) > 0 && ($quanti < $regqtm[0]['qtamin'] || ($regqtm[0]['qtamul'] != 0 && (($quanti - $regqtm[0]['qtamin']) % $regqtm[0]['qtamul']) != 0))) {
                echo json_encode(array('response' => 'RM', 'min' => $regqtm[0]['qtamin'], 'mul' => $regqtm[0]['qtamul']));
            } else {
                // If you have already this line, take it
                if ($nurorc != -1) {
                    $occorp = Occorp::findFirst(array('nuordc = :nuordc: AND nurorc = :nurorc:', 'bind' => array('nuordc' => $nuordc, 'nurorc' => $nurorc)));
                } else {
                    $occorp = false;
                }

                // If you don't have already this line, create a new one with a seqrap (nurorc is AUTO_INCREMENT)
                if (!$occorp) {
                    $occorp = new Occorp ();
                    $occorp->nuordc = $_POST['nuordc'];
                    $seqrap = Occorp::getMaxIndexForOrder($nuordc);
                    $occorp->seqrap = $seqrap + 1;
                }

                $occorp->cdarti = $cdarti;
                $occorp->seqdet = $seqdet;
                $occorp->cdcolo = $cdcolo != '' ? $cdcolo : new RawValue('""');
                $occorp->cdvari = $cdvari != '' ? $cdvari : new RawValue('""');
                $occorp->cdcata = $cdcata;
                $occorp->quanti = $quanti;
                $occorp->dsnoco = $dsnoco != '' ? $dsnoco : new RawValue('""');
                $occorp->indorc = $indorc != '' ? $indorc : new RawValue('""');
                $occorp->sgrifc = $sgrifc != '' ? $sgrifc : new RawValue('""');
                $occorp->dtmcli = $dtmcli;

                if ($occorp->save() == false) {
                    echo json_encode(array('response' => 'OC'));
                } else {
                    $old_octagl = Octagl::findByNurorc($nurorc);
                    if (count($old_octagl) > 0 && $old_octagl->delete() === false) {
                        echo json_encode(array('response' => 'DT'));
                    } else {
                        $everythingOk = true;
                        foreach ($octagl as $size) {
                            $new_octagl = new Octagl();
                            $new_octagl->nurorc = $occorp->nurorc;
                            $new_octagl->dstagl = $size[0];
                            $new_octagl->prezzo = $size[1];
                            $new_octagl->quanti = $size[2];
                            $new_octagl->scont1 = $size[3];
                            if ($new_octagl->scont1 == 0 && empty($numdis)) {
                                // Se non sono presenti altri sconti personalizzati applichiamo quello su anagrafica cliente
                                if ($order_info->tpanag == 'CL' && !empty($order_info->cdanag) && ($anagra = Anagra::findCustomerByKey($order_info, $order_info->cdanag))) {
                                    $new_octagl->scont1 = $anagra->scont1;
                                }
                            }
                            $new_octagl->scont2 = 0;
                            $new_octagl->scont3 = 0;
                            if ($new_octagl->save() == false) {
                                $everythingOk &= false;
                            }
                        }

                        if ($everythingOk) {
                            if (count($ocasso) > 0) {
                                $old_ocasso = Ocasso::findByNurorc($nurorc);
                                if (count($old_ocasso) > 0 && $old_ocasso->delete() === false) {
                                    echo json_encode(array('response' => 'DA'));
                                } else {
                                    foreach ($ocasso as $assortment) {
                                        $new_ocasso = new Ocasso();
                                        $new_ocasso->nurorc = $occorp->nurorc;
                                        $new_ocasso->cdasso = $assortment[0];
                                        $new_ocasso->quanti = $assortment[1];
                                        if ($new_ocasso->save() == false) {
                                            $everythingOk &= false;
                                        }
                                    }

                                    if ($everythingOk) {
                                        $auth = $this->session->get('auth');
                                        echo json_encode(array(
                                            'nurorc' => $occorp->nurorc,
                                            'tot' => Occorp::getOrderTotals($occorp->nuordc),
                                            'tot_artn' => Occorp::getCurrentCartTotalForModel($auth['id'], $cdarti)
                                        ));
                                    } else {
                                        echo json_encode(array('response' => 'OA'));
                                    }
                                }
                            } else {
                                $auth = $this->session->get('auth');
                                echo json_encode(array(
                                    'nurorc' => $occorp->nurorc,
                                    'tot' => Occorp::getOrderTotals($occorp->nuordc),
                                    'tot_artn' => Occorp::getCurrentCartTotalForModel($auth['id'], $cdarti)
                                ));
                            }
                        } else {
                            echo json_encode(array('response' => 'NT'));
                        }
                    }
                }
            }
        }
    }

    public function saveOrderRowsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nuordc = $_POST['nuordc'];
            $cdcata = $_POST['cdcata'];
            $articles = $_POST['articles'];

            $response = array(
                'cdarti' => array()
            );

            // If you have already this line, take it
            $occorp = Occorp::removeAllRowsForModel($nuordc, $articles[0][1]);

            foreach ($articles as $article) {
                $nurorc = $article[0];
                $cdarti = $article[1];
                $cdcolo = isset($article[2]) ? $article[2] : "";
                $cdvari = "";
                $cdcata = $cdcata;
                $quanti = $article[3];
                $seqdet = 1;
                $dtmcli = "0000-00-00";
                $sgrifc = "";
                $dsnoco = "";
                $indorc = "";
                $octagl = isset($article[4]) ? $article[4] : array();

                if ($this->utility->getAppSettings('ParamCouponPromo') == 2) {
                    $this->utility->verifyPromos($nuordc);
                }

                if ($nurorc != -1) {
                    $occorp = Occorp::findFirst(array('nuordc = :nuordc: AND nurorc = :nurorc:', 'bind' => array('nuordc' => $nuordc, 'nurorc' => $nurorc)));
                } else {
                    $occorp = false;
                }

                // If you don't have already this line, create a new one with a seqrap (nurorc is AUTO_INCREMENT)
                if (!$occorp) {
                    $occorp = new Occorp ();
                    $occorp->nuordc = $nuordc;
                    $seqrap = Occorp::getMaxIndexForOrder($nuordc);
                    $occorp->seqrap = $seqrap + 1;
                }

                $occorp->cdarti = $cdarti;
                $occorp->seqdet = $seqdet;
                $occorp->cdcolo = $cdcolo != '' ? $cdcolo : new RawValue('""');
                $occorp->cdvari = $cdvari != '' ? $cdvari : new RawValue('""');
                $occorp->cdcata = $cdcata;
                $occorp->quanti = $quanti;
                $occorp->dsnoco = $dsnoco != '' ? $dsnoco : new RawValue('""');
                $occorp->indorc = $indorc != '' ? $indorc : new RawValue('""');
                $occorp->sgrifc = $sgrifc != '' ? $sgrifc : new RawValue('""');
                $occorp->dtmcli = $dtmcli;

                if ($occorp->save() == false) {
                    echo json_encode('OC');
                } else {
                    $response['cdarti'][$occorp->cdarti] = $occorp->nurorc;

                    $old_octagl = Octagl::findByNurorc($nurorc);
                    if (count($old_octagl) > 0 && $old_octagl->delete() === false) {
                        echo json_encode('DT');
                    } else {
                        $everythingOk = true;
                        foreach ($octagl as $size) {
                            $new_octagl = new Octagl();
                            $new_octagl->nurorc = $occorp->nurorc;
                            $new_octagl->dstagl = $size[0];
                            $new_octagl->prezzo = $size[1];
                            $new_octagl->quanti = $size[2];
                            $new_octagl->scont1 = $size[3];
                            $new_octagl->scont2 = 0;
                            $new_octagl->scont3 = 0;
                            if ($new_octagl->save() == false) {
                                $everythingOk &= false;
                            }
                        }

                        if (!$everythingOk) {
                            echo json_encode('NT');
                        }
                    }
                }
            }

            $auth = $this->session->get('auth');
            $response['tot'] = Occorp::getCurrentCartTotal($auth['id']);

            echo json_encode($response);
        }
    }

    public function saveOrderRowsFromArticleWizardAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nuordc = $_POST['nuordc'];
            $cdcata = $_POST['cdcata'];
            $cdartn = $_POST['cdartn'];
            $occorp = isset($_POST['occorp']) ? $_POST['occorp'] : array();
            $fldbrw = isset($_POST['fldbrw']) ? $_POST['fldbrw'] : 0;

            foreach ($occorp as $row) {
                $dtmcli = "0000-00-00";

                $occorp = $fldbrw == 1
                    ? null
                    : Occorp::findFirst(array('nuordc = :nuordc: AND cdarti = :cdarti:', 'bind' => array('nuordc' => $nuordc, 'cdarti' => $row['cdarti'])));

                if (!$occorp) {
                    $occorp = new Occorp ();
                    $occorp->nuordc = $nuordc;
                    $seqrap = Occorp::getMaxIndexForOrder($nuordc);
                    $occorp->seqrap = $seqrap + 1;
                    $occorp->cdvari = new RawValue('""');
                    $occorp->cdcata = $cdcata;
                    $occorp->seqdet = 1;
                    $occorp->dtmcli = '0000-00-00';
                    $occorp->sgrifc = new RawValue('""');
                    if ($this->utility->getAppSettings('ParamIndicativeManagement') > 0) {
                        $order = Octest::findFirstByNuordc($nuordc);
                        $occorp->tpindo = $order->tpindo != '' ? $order->tpindo : new RawValue('""');
                    } else {
                        $occorp->tpindo = new RawValue('""');
                    }
                    $occorp->indorc = new RawValue('""');
                    $occorp->tpnoco = new RawValue('""');
                    $occorp->dsnoco = new RawValue('""');
                }

                $occorp->cdarti = $row['cdarti'];
                $occorp->cdcolo = !empty($row['cdcolo']) ? $row['cdcolo'] : new RawValue('""');
                $occorp->quanti = $row['quanti'];

                if ($occorp->save() == false) {
                    echo json_encode('OC');
                } else {
                    $everythingOk = true;

                    Octagl::emptyQuantitiesForRow($occorp->nurorc);

                    foreach ($row['octagl'] as $size) {
                        $new_octagl = new Octagl();
                        $new_octagl->nurorc = $occorp->nurorc;
                        $new_octagl->dstagl = $size['taglia'];
                        $new_octagl->prezzo = $size['prezzo'];
                        $new_octagl->quanti = $size['quanti'];
                        $new_octagl->scont1 = $size['sconto'];
                        $new_octagl->scont2 = 0;
                        $new_octagl->scont3 = 0;
                        if ($new_octagl->save() == false) {
                            $everythingOk &= false;
                        }
                    }

                    if (!$everythingOk) {
                        echo json_encode('NT');
                    }
                }
            }

            if ($this->utility->getAppSettings('ParamCouponPromo') == 2) {
                $this->utility->verifyPromos($nuordc);
            }

            $auth = $this->session->get('auth');
            $response['tot'] = Occorp::getCurrentCartTotal($auth['id']);

            echo json_encode($response);
        }
    }

    public function saveOrderRowsFromFabricWizardAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nuordc = $_POST['nuordc'];
            $cdcata = $_POST['cdcata'];
            $cdartn = $_POST['cdartn'];
            $occorp = $_POST['occorp'];
            $cdpers = $_POST['cdpers'];
            $cdvari = $_POST['cdvari'];

            $cdarti = Anaart::getCdartiFromCdartnAndCdpers($cdartn, $cdpers);


            foreach ($occorp as $row) {
                $dtmcli = "0000-00-00";

                $occorp = new Occorp ();
                $occorp->nuordc = $nuordc;
                $seqrap = Occorp::getMaxIndexForOrder($nuordc);
                $occorp->seqrap = $seqrap + 1;
                $occorp->cdarti = $cdarti;
                $occorp->cdcolo = $row['cdcolo'];
                $occorp->cdvari = $cdvari != '' ? $cdvari : new RawValue('""');
                $occorp->cdcata = $cdcata;
                $occorp->quanti = $row['quanti'];
                $occorp->seqdet = 1;
                $occorp->dtmcli = '0000-00-00';
                $occorp->sgrifc = new RawValue('""');
                $occorp->tpindo = new RawValue('""');
                $occorp->indorc = new RawValue('""');
                $occorp->tpnoco = new RawValue('""');
                $occorp->dsnoco = new RawValue('""');

                if ($occorp->save() == false) {
                    echo json_encode('OC');
                } else {
                    $everythingOk = true;
                    if (isset($row['octagl']) && count($row['octagl']) > 0) {
                        foreach ($row['octagl'] as $size) {
                            $new_octagl = new Octagl();
                            $new_octagl->nurorc = $occorp->nurorc;
                            $new_octagl->dstagl = $size['taglia'];
                            $new_octagl->prezzo = $size['prezzo'];
                            $new_octagl->quanti = $size['quanti'];
                            $new_octagl->scont1 = $size['sconto'];
                            $new_octagl->scont2 = 0;
                            $new_octagl->scont3 = 0;
                            if ($new_octagl->save() == false) {
                                $everythingOk &= false;
                            }
                        }
                    }

                    if (isset($row['ocasso']) && count($row['ocasso']) > 0) {
                        foreach ($row['ocasso'] as $asso) {
                            $new_ocasso = new Ocasso();
                            $new_ocasso->nurorc = $occorp->nurorc;
                            $new_ocasso->cdasso = $asso['cdasso'];
                            $new_ocasso->quanti = $asso['quanti'];
                            if ($new_ocasso->save() == false) {
                                $everythingOk &= false;
                            }
                        }
                    }

                    if (!$everythingOk) {
                        echo json_encode('NT');
                    }
                }
            }

            if ($this->utility->getAppSettings('ParamCouponPromo') == 2) {
                $this->utility->verifyPromos($nuordc);
            }

            $auth = $this->session->get('auth');
            $response['tot'] = Occorp::getCurrentCartTotal($auth['id']);

            echo json_encode($response);
        }
    }

    public function getCurrentDesiderataAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdartn = $_POST['cdartn'];
            $tppers = $_POST['tppers'];

            $anaart = Anaart::findByCdartn($cdartn);
            $artcol = array();
            $artvar = array();

            if ($tppers == 'PT') {
                $where = '';
                foreach ($anaart as $article) {
                    $where .= '"' . $article->cdarti . '",';
                }
                $where = substr($where, 0, -1);

                $artcol = Artcol::find(array('cdarti IN (' . $where . ')'));

                if ($this->utility->getAppSettings('ParamVariation') == 1) {
                    $artvar = Artvar::find(array('cdarti IN (' . $where . ')'));
                }
            }

            echo json_encode($this->getHtmlModalNotifyAvailability($anaart, $artcol, $artvar));
        }
    }

    public function getCurrentDesiderataSizesAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdarti = $_POST['cdarti'];
            $cdtagl = $_POST['cdtagl'];
            $preagg = $_POST['preagg'];

            $auth = $this->session->get('auth');
            $nulist = Octest::getCurrentOrder($auth['id'])->nulist;

            $postgl = Postgl::getSizesWithPricesFromArticleAndSizeCode($cdarti, $nulist, $cdtagl);

            echo json_encode($this->getHtmlModalNotifyAvailabilityQuantity($postgl, $preagg));
        }
    }

    public function getSizesFromColorAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdarti = $_POST['cdarti'];
            $cdcolo = $_POST['cdcolo'];
            $cdtagl = $_POST['cdtagl'];
            $tppers = $_POST['tppers'];

            $html_sizes = '';
            $html_modal = '';
            $this->getSizesFromColorHtml($cdarti, $cdcolo, $cdtagl, $tppers, $html_sizes, $html_modal);

            echo json_encode(array(
                'response' => 'OK',
                'html_sizes' => $html_sizes,
                'html_modal' => $html_modal
            ));
        }
    }

    public function getSizesForArticleWizardAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdartn = $_POST['cdartn'];
            $articles = $_POST['articles'];

            $auth = $this->session->get('auth');
            $id_usr = $auth['id'];
            $order = Octest::getCurrentOrder($id_usr);
            $nulist = $order->nulist;
            $idlang = $this->utility->getLanguage();
            $cdcata = $order->cdcata;

            $numdis = $this->utility->getCustomDiscount();
            $tipolo = Tipolo::getCompleteModel($cdartn, $cdcata, $numdis, $idlang)[0];
            $showCatalogPrice = $this->utility->getAppSettings('ParamShowPriceCatalog');

            $sizes = 0;
            $fullArticles = array();
            for ($i = 0; $i < count($articles); $i++) {
                $currArticle = array(
                    'article' => Anaart::getFullArticleFromCdarti(array('cdarti' => $articles[$i], 'nulist' => $nulist, 'rulist' => $order->rulist, 'numdis' => $numdis, 'id_usr' => $id_usr)),
                    'qttagl' => Postgl::getSizesWithQuantityForArticleWizard($order->nuordc, $cdartn, $articles[$i], $nulist, $order->fldbrw == 0)
                );
                $fullArticles[] = $currArticle;
            }

            $sizes = count($fullArticles[0]['qttagl']);

            $html = $this->getHtmlSizeContentForArticleWizard($fullArticles, $tipolo, $nulist, $showCatalogPrice);

            echo json_encode(array('response' => 'OK', 'html' => $html, 'sizes' => $sizes));
        }
    }

    public function getSizesForConfiguratorWizardAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdartn = $_POST['cdartn'];
            $articles = $_POST['articles'];

            $auth = $this->session->get('auth');
            $id_usr = $auth['id'];
            $order = Octest::getCurrentOrder($id_usr);
            $nulist = $order->nulist;
            $idlang = $this->utility->getLanguage();
            $cdcata = $order->cdcata;
            $tipolo = Tipolo::findFirstByCdartn($cdartn);

            $showCatalogPrice = $this->utility->getAppSettings('ParamShowPriceCatalog');

            $sizes = 0;
            $fullArticles = array();
            for ($i = 0; $i < count($articles); $i++) {
                $items = explode('-', $articles[$i]);
                if (count($items) > 1 && substr($items[1], 0, 1) == 'C') {
                    $seqrap = substr($items[1], 1);
                    $nupers = Ocpert::getCustomArticle($order->nuordc, $cdartn, $seqrap)->nupers;
                    $cdarti = $nupers;
                    $dsarti = $articles[$i];
                    $components = Ocperc::getAllComponents($nupers);
                    $prezzo = $this->calculatePriceFromComponents($components, $cdartn, $nulist);
                    $flimag = $tipolo->flimag;
                    $isCustom = true;
                    $isDefault = false;
                } else {
                    $cdarti = $articles[$i];
                    $dsarti = $articles[$i];
                    $components = Smcorp::getAllComponents($cdarti);
                    if ($cdarti == $tipolo->cdartn) {
                        $components = Spmate::getDefaultMaterialTypes($tipolo->cdartn);
                        $prezzo = $this->calculatePriceFromComponents($components, $tipolo->cdartn, $nulist);
                    } else {
                        $components = Smcorp::getAllComponents($cdarti);
                        $prezzo = Lscorp::getPriceForArticle($nulist, $cdarti);
                    }
                    $flimag = Anaart::findFirstByCdarti($cdarti)->flimag;
                    $isCustom = $cdarti == $tipolo->cdartn;
                    $isDefault = $cdarti == $tipolo->cdartn;
                }

                $qttagl = Postgl::getSizesWithQuantityForConfiguratorWizard($order->nuordc, $cdartn, $cdarti);
                $currArticle = array(
                    'cdarti' => $cdarti,
                    'dsarti' => $dsarti,
                    'prezzo' => $prezzo,
                    'flimag' => $flimag,
                    'components' => $components,
                    'isCustom' => $isCustom,
                    'isDefault' => $isDefault,
                    'qttagl' => $qttagl
                );
                $fullArticles[] = $currArticle;
            }

            $sizes = count($fullArticles[0]['qttagl']);

            $html = $this->getHtmlSizeContentForConfiguratorWizard($fullArticles, $tipolo, $nulist, $showCatalogPrice);

            echo json_encode(array('response' => 'OK', 'html' => $html, 'sizes' => $sizes));
        }
    }

    public function getSizesForFabricWizardAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdpers = $_POST['cdpers'];
            $cdcolo = $_POST['cdcolo'];
            $cdartn = $_POST['cdartn'];
            $cdvari = $_POST['cdvari'];

            $colors = explode(',', str_replace(' ', '', $cdcolo));

            $cdarti = Anaart::getCdartiFromCdartnAndCdpers($cdartn, $cdpers);

            $auth = $this->session->get('auth');
            $id_usr = $auth['id'];
            $order = Octest::getCurrentOrder($id_usr);
            $nulist = $order->nulist;
            $idlang = $this->utility->getLanguage();
            $cdcata = $order->cdcata;

            $priceVariation = 0;
            if ($cdvari != '') {
                $variants = str_split($cdvari);
                foreach ($variants as $code) {
                    $priceVariation += Tabvar::getCustomFromCdvariAndCdcata($code, $cdcata)->prezzo;
                }
            }

            $qttagl = Postgl::getSizesWithQuantityForFabricWizard($cdartn, $cdarti, $nulist);
            $tipolo = $this->getFullTipoloForFabricWizard($cdcata, $cdartn, $nulist, '', $idlang);
            $showCatalogPrice = $this->utility->getAppSettings('ParamShowPriceCatalog');
            $articleDiscount = Anaart::getArticleDiscountForWizard($cdarti, $this->utility->getCustomDiscount());
            $ocasso = $tipolo->flasso > 0
                ? $this->getAssortmentsFromCdarti($cdarti)
                : null;
            $html = $this->getHtmlSizeContentForFabricWizard($colors, $cdarti, $qttagl, $tipolo, $ocasso, $nulist, $priceVariation, $articleDiscount, $showCatalogPrice);

            echo json_encode(array('response' => 'OK', 'html' => $html));
        }
    }

    public function savedesiderataqtyAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdarti = $_POST['cdarti'];
            $cdcolo = $_POST['cdcolo'];
            $cdvari = $_POST['cdvari'];
            $sizes = $_POST['sizes'];

            $auth = $this->session->get('auth');
            $anagra = $this->utility->getCustomersFromCustomerUserId($auth['id']);

            // Save this customer in ndanag if not present
            $ndanag = B2bNdanag::findFirst(array('tpanag = :tpanag: AND cdanag = :cdanag:',
                'bind' => array('tpanag' => $anagra[0]->tpanag, 'cdanag' => $anagra[0]->cdanag)));
            if (!$ndanag) {
                $ndanag = new B2bNdanag();
                $ndanag->tpanag = $anagra[0]->tpanag;
                $ndanag->cdanag = $anagra[0]->cdanag;
                $ndanag->descri = $anagra[0]->descri;
                $ndanag->ccitta = $anagra[0]->ccitta;
                $ndanag->dsnazi = $anagra[0]->dsnazi;
                $ndanag->indema = $anagra[0]->indema;
                $ndanag->save();
            }

            // Save this article in ndarti if not present
            $ndarti = B2bNdarti::findFirst(array('cdarti = :cdarti: AND cdcolo = :cdcolo: AND cdvari = :cdvari:',
                'bind' => array('cdarti' => $cdarti, 'cdcolo' => $cdcolo, 'cdvari' => $cdvari)));

            if (!$ndarti) {
                $article = Anaart::getArticleForNotification($cdarti, $cdcolo, $cdvari);

                $ndarti = new B2bNdarti();
                $ndarti->cdartn = $article[0]->cdartn != '' ? $article[0]->cdartn : new RawValue('""');
                $ndarti->dsartn = $article[0]->dsartn != '' ? $article[0]->dsartn : new RawValue('""');
                $ndarti->cdarti = $article[0]->cdarti != '' ? $article[0]->cdarti : new RawValue('""');
                $ndarti->dsarti = $article[0]->dsarti != '' ? $article[0]->dsarti : new RawValue('""');
                $ndarti->cdcolo = $article[0]->cdcolo != '' ? $article[0]->cdcolo : new RawValue('""');
                $ndarti->dscolo = $article[0]->dscolo != '' ? $article[0]->dscolo : new RawValue('""');
                $ndarti->cdvari = $article[0]->cdvari != '' ? $article[0]->cdvari : new RawValue('""');
                $ndarti->dsvari = $article[0]->dsvari != '' ? $article[0]->dsvari : new RawValue('""');
                $ndarti->cdstag = $article[0]->cdstag != '' ? $article[0]->cdstag : new RawValue('""');
                $ndarti->dsstag = $article[0]->dsstag != '' ? $article[0]->dsstag : new RawValue('""');
                $ndarti->cdtitl = $article[0]->cdtitl != '' ? $article[0]->cdtitl : new RawValue('""');
                $ndarti->dstitl = $article[0]->dstitl != '' ? $article[0]->dstitl : new RawValue('""');
                $ndarti->cdlinm = $article[0]->cdlinm != '' ? $article[0]->cdlinm : new RawValue('""');
                $ndarti->dslinm = $article[0]->dslinm != '' ? $article[0]->dslinm : new RawValue('""');
                $ndarti->cdserm = $article[0]->cdserm != '' ? $article[0]->cdserm : new RawValue('""');
                $ndarti->dsserm = $article[0]->dsserm != '' ? $article[0]->dsserm : new RawValue('""');
                $ndarti->tpgene = $article[0]->tpgene != '' ? $article[0]->tpgene : new RawValue('""');
                $ndarti->dsgene = $article[0]->dsgene != '' ? $article[0]->dsgene : new RawValue('""');
                $ndarti->tpmode = $article[0]->tpmode != '' ? $article[0]->tpmode : new RawValue('""');
                $ndarti->dstmod = $article[0]->dstmod != '' ? $article[0]->dstmod : new RawValue('""');

                $ndarti->save();
            }

            foreach ($sizes as $size) {
                // Save or update each quantity for current customer and article
                $ndtagl = B2bNdtagl::findFirst(array('numana = :numana: AND numart = :numart: AND taglia = :taglia: AND dtnoti = "0000-00-00"',
                    'bind' => array('numana' => $ndanag->numana, 'numart' => $ndarti->numart, 'taglia' => $size['taglia'])));
                if (!$ndtagl) {
                    $ndtagl = new B2bNdtagl();
                    $ndtagl->numana = $ndanag->numana;
                    $ndtagl->numart = $ndarti->numart;
                    $ndtagl->taglia = $size['taglia'];
                }
                $ndtagl->dtcrea = date('Y-m-d');
                $ndtagl->quanti = $size['quanti'];
                $ndtagl->prezzo = $size['prezzo'];
                $ndtagl->dtnoti = new RawValue('""');
                $ndtagl->save();
            }

            echo json_encode('OK');
        }
    }

    public function loadRelatedAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $code = $_POST['code'];

            $auth = $this->session->get('auth');
            $common = $this->utility->getCommonData('model', $auth['id']);
            $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($auth['id']);
            $idlang = $this->utility->getLanguage();
            $cdcata = $common['selected_catalog']->cdcata;

            $related = [];
            if ($common['catalogProductType'] == 0) {
                $tipolo = Tipolo::findFirstByCdartn($code);
                $related = $this->getRelatedFromProduct($cdcata, $code, $tipolo->tpmode,
                    $tipolo->cdlinm, $tipolo->cdserm, $nulist, $tipolo->tppers, $common, true, $idlang);
            } else if ($common['catalogProductType'] == 1) {
                $anaart = Anaart::getSimpleArticle($code);
                $related = $this->getRelatedFromProduct($cdcata, $code, $anaart->tpmode,
                    $anaart->cdlinm, $anaart->cdserm, $nulist, $anaart->tppers, $common, false, $idlang);
            } else if ($common['catalogProductType'] == 2) {
//        $anaart = Anaart::getSimpleArticle($code);
            }

            $is_availability_order = $common['isOrder'] && $common['order_info']->tpordc == 0;
            $title = $this->translate('_common.completelook');

            $html = $this->getFooterModelsHtml($related, $title, $common['isOrder'], $common['currency'], $common['cdvalu'], $is_availability_order, $common['catalogProductType'] == 0);

            echo json_encode(array(
                'response' => 'OK',
                'isPresent' => count($related) > 0,
                'html' => $html
            ));
        }
    }

    public function loadRecentsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $border = $_POST['border'];
            $code = $_POST['code'];

            $auth = $this->session->get('auth');
            $common = $this->utility->getCommonData('model', $auth['id']);
            $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($auth['id']);
            $idlang = $this->utility->getLanguage();

            $product = $common['catalogProductType'] == 0
                ? Tipolo::findFirstByCdartn($code)
                : Anaart::getSimpleArticle($code);

            $recents = array();
            $recentsSorted = array();
            if ($this->cookies->has('recent-products')) {
                // Get the cookie
                $recentProducts = $this->cookies->get('recent-products');

                // Get the cookie's value
                $recents = explode(';', $recentProducts->getValue());

                $recents = array_unique($recents);

                // Remove current code from recent models
                if (($key = array_search($code, $recents)) !== false) {
                    unset($recents[$key]);
                }

                // Get only last four cdartn different from current one
                for (end($recents); key($recents) !== null && count($recentsSorted) < 4; prev($recents)) {
                    if (current($recents) != $code) {
                        $recentsSorted[] = current($recents);
                    }
                }
            }

            $recents = $this->getRecents($recentsSorted, $nulist, $product->tppers, $common, $idlang, $border);

            $is_availability_order = $common['isOrder'] && $common['order_info']->tpordc == 0;
            $title = $this->translate('_common.recentlyviewed');

            $html = $this->getFooterModelsHtml($recents, $title, $common['isOrder'], $common['currency'], $common['cdvalu'], $is_availability_order, $common['catalogProductType'] == 0, $border);

            echo json_encode(array(
                'response' => 'OK',
                'isPresent' => count($recents) > 0,
                'html' => $html
            ));
        }
    }

    public function loadLinkedBuyAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdartn = $_POST['cdartn'];
            $border = $_POST['border'];
            $model = Tipolo::findFirstByCdartn($cdartn);

            $auth = $this->session->get('auth');
            $common = $this->utility->getCommonData('model', $auth['id']);
            $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($auth['id']);
            $idlang = $this->utility->getLanguage();
            $linkedbuy = $common['isOrder'] ? $this->getLinkedBuyProducts($cdartn, $nulist, $model->tppers, $common, $idlang) : array();
            $linkedbuy = empty($linkedbuy[0]['cdartn']) ? array() : $linkedbuy;

            $is_availability_order = $common['isOrder'] && $common['order_info']->tpordc == 0;
            $title = $this->translate('_common.linkedbuy');

            $html = $this->getFooterModelsHtml($linkedbuy, $title, $common['isOrder'], $common['currency'], $common['cdvalu'], $is_availability_order, $common['catalogProductType'] == 0, $border);

            echo json_encode(array(
                'response' => 'OK',
                'html' => $html
            ));
        }
    }

    public function loadQuickShopAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdartn = $_POST['cdartn'];

            $insertQuantityHtml = '';

            $auth = $this->session->get('auth');
            $common = $this->utility->getCommonData('model', $auth['id']);
            $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($auth['id']);
            $idlang = $this->utility->getLanguage();
            $cdcata = $common['selected_catalog']->cdcata;

            $model = $this->getFullProduct($cdcata, $cdartn, $nulist, $common['catalogProductType'] == 0, $idlang);

            $imageAndColorsHtml = $this->getImageAndColorsHtml($model, $common);

            echo json_encode(array(
                'response' => 'OK',
                'imageAndColorsHtml' => $imageAndColorsHtml,
                'insertQuantityHtml' => $insertQuantityHtml
            ));
        }
    }

    public function saveCustomArticleAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdartn = $_POST['cdartn'];
            $cdcolo = $_POST['cdcolo'];
            $features = $_POST['features'];

            $dsarti = Anaart::getMaxCustomArticleIndex();
            Anaart::createCustomArticle($cdartn, $dsarti, $cdcolo);

            $cdarti = $cdartn . '-C' . $cdcolo . '-' . $dsarti;

            foreach ($features as $feature) {
                Sparti::createNewFeature($cdarti, $feature[0], $feature[1]);
            }

            echo json_encode(array(
                'response' => 'OK',
                'cdarti' => $cdarti,
                'dsarti' => $dsarti,
            ));
        }
    }

    public function deleteOrderRowFromArticleWizardAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nuordc = $_POST['nuordc'];
            $cdarti = $_POST['cdarti'];

            Occorp::removeOrderRowForArticle($nuordc, $cdarti);

            echo json_encode('OK');
        }
    }

    public function getArticleImagesPreviewAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdarti = $_POST['cdarti'];

            $anaart = Anaart::findFirstByCdarti($cdarti);
            $images = Imgart::getAllImagesFromArticle($cdarti);

            echo json_encode(array('response' => 'OK', 'html' => $this->getHtmlArticleImagesPreview($anaart, $images)));
        }
    }

    public function getColorImagesPreviewAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdarti = $_POST['cdarti'];
            $cdcolo = $_POST['cdcolo'];

            $artcol = Artcol::findFirstByKey($cdarti, $cdcolo);
            $images = Imgart::getAllImagesFromColor($cdarti, $cdcolo);

            echo json_encode(array('response' => 'OK', 'html' => $this->getHtmlColorImagesPreview($artcol, $images)));
        }
    }

    public function saveNewCustomFromConfiguratorAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nuordc = $_POST['nuordc'];
            $cdartn = $_POST['cdartn'];
            $ocperc = $_POST['ocperc'];

            $isDuplicated = true;
            $isDefault = true;

            foreach ($ocperc as $element) {
                $isDuplicated &= Ocperc::isCurrentFeatureDuplicated($nuordc, $cdartn, $element['tpcomp'], $element['cdmate']);
                $spmate = Spmate::findFirstByKey($cdartn, $element['tpcomp'], $element['cdmate']);
                $isDefault &= $spmate != null && $spmate->flcamp == 1;
            }

            if (!$isDuplicated && !$isDefault) {
                $ocpert = Ocpert::saveNewCustom($nuordc, $cdartn);
                $components = array();
                $listPrice = 0;
                $addPrice = 0;
                $nulist = Octest::findFirstByNuordc($nuordc)->nulist;
                foreach ($ocperc as $element) {
                    Ocperc::saveNewCustomFeature($ocpert->nupers, $element['tpcomp'], $element['cdmate']);
                    $component = Anamat::getMaterialForComponent($element['tpcomp'], $cdartn, $element['cdmate']);
                    $component['flimagHtml'] = $this->elements->getModelImgOrDefaultHtml($component['flimag'], $component['dsmate'],
                        array('class' => 'configurator-preview', 'data-toggle' => 'tooltip', 'data-placement' => 'top', 'title' => $component['dsmate']));
                    $components[] = $component;

                    if ($component['riflis'] == 1 && $listPrice == 0) {
                        $listPrice = Spmate::getListPriceForComponent($nulist, $cdartn, $component['tpcomp'], $component['inplib'] == 0 ? $component['cdmate'] : '');
                    } else if ($component['varpre'] == 1) {
                        $addPrice += Spmate::getAddPriceForComponent($nulist, $component['cdmate'], $component['tpcomp'], $cdartn, $component['inplib'] == 1);
                    }
                }
                $addPrice -= Spmate::getPriceToSubtractForModel($nulist, $cdartn);

                $prezzo = $listPrice > 0 ? $listPrice + $addPrice : 0;

                echo json_encode(array('response' => 'OK', 'seqrap' => $ocpert->seqrap, 'prezzo' => $prezzo, 'components' => $components));
            } else {
                echo json_encode(array('response' => 'DP'));
            }
        }
    }

    public function getCustomConfigurationWizardAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdartn = $_POST['cdartn'];

            $customComponents = $this->getCustomComponentsForModel($cdartn);
            $html = '';
            foreach ($customComponents as $component) {
                $html .= $this->elements->getCustomComponentTool($component);
            }

            echo json_encode(array('response' => 'OK', 'html' => $html));
        }
    }

    public function getComponentImagesAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdartn = $_POST['cdartn'];
            $cdmatn = $_POST['cdmatn'];
            $tpcomp = $_POST['tpcomp'];

            $mustGetAllMaterials = Spmate::hasGetAllMaterialsFlag($cdartn, $tpcomp);

            if (!$mustGetAllMaterials) {
                $materials = Anamat::getMaterialFromMaterialType($cdmatn, $cdartn);
            } else {
                $materials = Anamat::getAllMaterialsFromMaterialType($cdmatn);
            }

            $html = '';
            if (count($materials) > 0) {
                $html = $this->getHtmlComponentImagesModal($materials);
            }

            echo json_encode(array('response' => 'OK', 'html' => $html, 'numMaterials' => count($materials)));
        }
    }

    public function getComponentMaterialAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdartn = $_POST['cdartn'];
            $cdmatn = $_POST['cdmatn'];
            $tpcomp = $_POST['tpcomp'];

            $mustGetAllMaterials = Spmate::hasGetAllMaterialsFlag($cdartn, $tpcomp);

            if (!$mustGetAllMaterials) {
                $materials = Anamat::getMaterialFromMaterialType($cdmatn, $cdartn);
            } else {
                $materials = Anamat::getAllMaterialsFromMaterialType($cdmatn);
            }

            $html = '';
            if (count($materials) > 0) {
                foreach ($materials as $material) {
                    $html .= $this->elements->getMultilevelMaterialTypeDiv($material);
                }
            }

            echo json_encode(array('response' => 'OK', 'html' => $html, 'numMaterials' => count($materials)));
        }
    }
    //endregion

    //region Utility functions
    private function addToRecentsCookie($cdartn)
    {
        $recents = array();
        $recentsSorted = array();
        if ($this->cookies->has('recent-products')) {
            // Get the cookie
            $recentProducts = $this->cookies->get('recent-products');

            // Get the cookie's value
            $recents = explode(';', $recentProducts->getValue());

            $recents = array_unique($recents);
        }

        // Save new recent
        $recents[] = $cdartn;
        $recentsString = implode(';', $recents);
        $this->cookies->set(
            'recent-products',
            $recentsString,
            time() + 15 * 86400
        );
    }

    private function getFullProduct($cdcata, $code, $nulist, $isModel, $idlang = 'IT', $isCompact = false)
    {
        $numdis = $this->utility->getCustomDiscount();

        if ($isModel) {
            $product = Tipolo::getCompleteModel($code, $cdcata, $numdis, $idlang);

            if (count($product) == 1) {
                $fullProduct = $product[0];

                $auth = $this->session->get('auth');
                $isOrder = Octest::findOrderInProgress($auth['id']) != null;
                $order = $isOrder ? Octest::getCurrentOrder($auth['id']) : null;
                $articles = $this->getAllAnaartFromTipolo($fullProduct->cdartn, $cdcata, $idlang, $nulist, $numdis, $fullProduct->tppers, $order);

                $fullArticles = array();
                if (count($articles) > 0) {
                    foreach ($articles as $article) {
                        $currentArticle = $article;
                        $currentArticle->imgart = Imgart::getAllImagesFromArticle($article->cdarti);
                        $fullArticles[] = $currentArticle;
                    }
                }
                $fullProduct->tags = Artcla::getTagsForModel($fullProduct->cdartn);
                $fullProduct->anaart = $fullArticles;
                $fullProduct->imgart = Imgart::getAllImagesFromModel($fullProduct->cdartn);

                return $fullProduct;
            }
        } else {
            $product = Anaart::getCompleteArticle($code, $cdcata, $nulist, $numdis, $idlang, $isCompact);
            if (count($product) >= 1) {
                $auth = $this->session->get('auth');
                $isOrder = Octest::findOrderInProgress($auth['id']) != null;
                if ($isOrder) {
                    $order = Octest::getCurrentOrder($auth['id']);
                }

                $fullProduct = $product[0];
                $fullColors = array();
                $items = array(
                    'modelDetailStyle' => $this->utility->getAppSettings('ModelDetailStyle'),
                    'colorAssignmentSource' => $this->utility->getAppSettings('ColorAssignmentSource'),
                    'nuordc' => $isOrder ? $order->nuordc : -1,
                    'cdarti' => $fullProduct->cdarti,
                );
                if ($isOrder) {
                    $colors = Artcol::getColorsForOrderArticleDetail($items);
                } else {
                    $colors = Artcol::getColorsForArticleDetail($items);
                }
                if (count($colors) > 0) {
                    foreach ($colors as $color) {
                        $currentColor = $color;
                        $currentColor['imgart'] = Imgart::getAllImagesFromColor($code, $color['cdcolo']);
                        $fabricColorImage = Imgart::getFabricColorImage($fullProduct->cdpers, $color['cdcolo']);
                        $fabricColorImage = count($fabricColorImage) > 0 ? $fabricColorImage[0]->flimag : '';
                        $currentColor['fabricColorImage'] = $fabricColorImage;
                        $fullColors[] = $currentColor;
                    }
                }
                $fullProduct->colors = $fullColors;
                $fullProduct->imgart = Imgart::getAllImagesFromArticle($fullProduct->cdarti);
                return $fullProduct;
            }
        }

        return '';
    }

    private function getFullTipoloForFabricWizard($cdcata, $cdartn, $nulist, $tagFilter = '', $idlang = 'IT', $cdpers = '')
    {
        $numdis = $this->utility->getCustomDiscount();
        $tipolo = Tipolo::getCompleteModel($cdartn, $cdcata, $numdis, $idlang);

        if (count($tipolo) == 1) {
            $fullTipolo = $tipolo[0];
            $fabrics = Ctarti::getAllFabricsForModel($cdartn, $cdcata, $idlang, $nulist, $numdis, $tagFilter);
            $fullFabrics = array();
            foreach ($fabrics as $fabric) {
                $currFabric = $fabric;
                $currFabric->currency = $this->utility->getCurrencySymbol($currFabric->cdvalu);
                $fullFabrics[] = $currFabric;
            }
            $fullTipolo->fabrics = $fullFabrics;
            $fullTipolo->variants = Tabvar::getAllCustomsForModel($cdartn, $fullTipolo->tpmode, $cdcata);
            $fullTipolo->imgart = Imgart::getAllImagesFromModel($cdartn);
            $fullTipolo->colors = $cdpers == ''
                ? Artcol::getAllColorsFromModel($cdartn, $cdcata)
                : Artcol::getAllColorsFromModelAndFabric($cdartn, $cdpers, $cdcata);

            return $fullTipolo;
        }

        return '';
    }

    private function getFullTipoloForArticleWizard($cdcata, $cdartn, $nulist, $shouldFilterAvailability, $idlang = 'IT')
    {
        $numdis = $this->utility->getCustomDiscount();
        $tipolo = Tipolo::getCompleteModel($cdartn, $cdcata, $numdis, $idlang);

        if (count($tipolo) == 1) {
            $full_tipolo = $tipolo[0];
            $items = array(
                'cdartn' => $cdartn,
                'cdcata' => $cdcata,
                'nulist' => $nulist,
                'id_usr' => $this->session->get('auth')['id'],
                'numdis' => $this->utility->getCustomDiscount(),
                'idlang' => $idlang,
                'isQuickOrder' => false,
                'filterNotAvailable' => $shouldFilterAvailability,
                'showAvailabilityFlag' => $this->utility->getAppSettings('ShowAvailabilityFlag') == 1
            );

            $colors = Anaart::getAllArticlesFromModel($items, true);
            $full_tipolo->colors = array();
            for ($i = 0; $i < count($colors); $i++) {
                $currColor = $colors[$i];
                $currColor->features = Sparti::getAllFeatures($currColor->cdarti);
                $full_tipolo->colors[] = $currColor;
            }

            $full_tipolo->imgart = Imgart::getAllImagesFromModel($cdartn);

            return $full_tipolo;
        }

        return '';
    }

    private function calculatePriceFromComponents($components, $cdartn, $nulist)
    {
        $listPrice = 0;
        $addPrice = 0;
        foreach ($components as $component) {
            if ($component->riflis == 1 && $listPrice == 0) {
                $listPrice = Spmate::getListPriceForComponent($nulist, $cdartn, $component->tpcomp, $component->inplib == 0 ? $component->cdmate : '');
            } else if ($component->varpre == 1) {
                $addPrice += Spmate::getAddPriceForComponent($nulist, $component->cdmate, $component->tpcomp, $cdartn, $component->inplib == 1);
            }
        }
        $addPrice -= Spmate::getPriceToSubtractForModel($nulist, $cdartn);

        return $listPrice > 0 ? $listPrice + $addPrice : 0;
    }

    private function getFullTipoloForConfiguratorWizard($cdcata, $cdartn, $nulist, $idlang = 'IT', $nuordc = null)
    {
        $numdis = $this->utility->getCustomDiscount();
        $tipolo = Tipolo::getCompleteModel($cdartn, $cdcata, $numdis, $idlang);

        if (count($tipolo) == 1) {
            $full_tipolo = $tipolo[0];
            $items = array(
                'cdartn' => $cdartn,
                'cdcata' => $cdcata,
                'nulist' => $nulist,
                'id_usr' => $this->session->get('auth')['id'],
                'numdis' => $this->utility->getCustomDiscount(),
                'idlang' => $idlang,
                'isQuickOrder' => false,
                'filterNotAvailable' => false,
                'showAvailabilityFlag' => $this->utility->getAppSettings('ShowAvailabilityFlag') == 1
            );
            $colors = Anaart::getAllArticlesFromModel($items, true);
            $full_tipolo->colors = array();
            for ($i = 0; $i < count($colors); $i++) {
                $currColor = $colors[$i];
                if ($currColor->cdarti == $currColor->cdartn) {
                    $currColor->cdcolo = 'DEFCUSTOM';
                    $currColor->components = Spmate::getDefaultMaterialTypes($currColor->cdartn);
                    $currColor->prezzo = $this->calculatePriceFromComponents($currColor->components, $currColor->cdartn, $nulist);
                } else {
                    $currColor->components = Smcorp::getAllComponents($currColor->cdarti);
                }
                $full_tipolo->colors[] = $currColor;
            }

            if ($nuordc != null) {
                $customColors = Ocpert::getAllCustomsForOrderAndModel($nuordc, $cdartn);
                $full_tipolo->customColors = array();
                for ($i = 0; $i < count($customColors); $i++) {
                    $currColor = $customColors[$i];
                    $currColor->cdcolo = 'CUSTOM';
                    $currColor->components = Ocperc::getAllComponents($currColor->nupers);
                    $currColor->prezzo = $this->calculatePriceFromComponents($currColor->components, $currColor->cdartn, $nulist);
                    $full_tipolo->customColors[] = $currColor;
                }
            } else {
                $full_tipolo->customColors = array();
            }

            $full_tipolo->imgart = Imgart::getAllImagesFromModel($cdartn);

            return $full_tipolo;
        }

        return '';
    }

    private function getCustomComponentsForModel($cdartn)
    {
        $elements = Spmate::getMaterialTypes($cdartn);

        $customComponents = [];
        foreach ($elements as $element) {
            // If not present current TPCOMP element, create default
            if (!isset($customComponents[$element->tpcomp])) {
                $customComponents[$element->tpcomp] = array(
                    'tpcomp' => $element->tpcomp,
                    'dscomp' => $element->dscomp,
                    'inplib' => $element->inplib,
                    'types' => array(),
                    'multilevel' => false,
                    'defaultTypeCode' => '',
                    'defaultTypeDescription' => '',
                    'defaultMaterialCode' => '',
                    'defaultMaterialDescription' => '',
                    'defaultMaterialImage' => ''
                );

                // If current element has INPLIB = 1, it should be manually filled with types and materials
                if ($element->inplib == 1) {
                    $types = Tipmat::getMaterialTypes($element->cdmacr);

                    for ($i = 0; $i < count($types); $i++) {
                        if (!isset($customComponents[$element->tpcomp]['types'][$types[$i]->cdmatn])) {
                            $customComponents[$element->tpcomp]['multilevel'] = $element->cdmatn != $element->cdmate;
                            $customComponents[$element->tpcomp]['types'][$types[$i]->cdmatn] = array(
                                'cdmatn' => $types[$i]->cdmatn,
                                'dsmatn' => $types[$i]->dsmatn,
                                'image' => $element->flimag,
                                'isDefault' => false,
                                'materials' => array()
                            );
                        }

                        $materials = Anamat::getMaterialFromMaterialType($types[$i]->cdmatn, $cdartn);
                        for ($j = 0; $j < count($materials); $j++) {
                            $customComponents[$element->tpcomp]['types'][$types[$i]->cdmatn]['materials'][$materials[$j]->cdmate] = array(
                                'cdmate' => $materials[$j]->cdmate,
                                'dsmate' => $materials[$j]->dsmate,
                                'cdcolo' => $materials[$j]->cdcolo,
                                'flimag' => $materials[$j]->flimag,
                                'isDefault' => false
                            );
                        }
                    }
                }
            }

            // If current element has not INPLIB = 1, set type and material
            if ($element->inplib == 0) {
                if (!isset($customComponents[$element->tpcomp]['types'][$element->cdmatn])) {
                    $customComponents[$element->tpcomp]['types'][$element->cdmatn] = array(
                        'cdmatn' => $element->cdmatn,
                        'dsmatn' => $element->dsmatn,
                        'isDefault' => false,
                        'materials' => array()
                    );
                } else {
                    $customComponents[$element->tpcomp]['multilevel'] = true;
                }

                if (!isset($customComponents[$element->tpcomp]['types'][$element->cdmatn]['materials'][$element->cdmate])) {
                    $customComponents[$element->tpcomp]['types'][$element->cdmatn]['materials'][$element->cdmate] = array(
                        'cdmate' => $element->cdmate,
                        'dsmate' => $element->dsmate,
                        'cdcolo' => $element->cdcolo,
                        'flimag' => $element->flimag,
                        'isDefault' => false
                    );
                }
            }

            // If current element is default (FLCAMP = 1), set default info
            if ($element->flcamp == 1) {
                $customComponents[$element->tpcomp]['defaultTypeCode'] = $element->cdmatn;
                $customComponents[$element->tpcomp]['defaultTypeDescription'] = $element->dsmatn;
                $customComponents[$element->tpcomp]['defaultMaterialCode'] = $element->cdmate;
                $customComponents[$element->tpcomp]['defaultMaterialDescription'] = $element->dsmate;
                $customComponents[$element->tpcomp]['defaultMaterialImage'] = $element->flimag;
                $customComponents[$element->tpcomp]['types'][$element->cdmatn]['isDefault'] = true;
                $customComponents[$element->tpcomp]['types'][$element->cdmatn]['materials'][$element->cdmate]['isDefault'] = true;
            }
        }

        // Check default materials

        return $customComponents;
    }

    private function getTipoloImages($cdartn, $idlang = 'IT')
    {
        $tipolo = Tipolo::getMinimalModelWithImage($cdartn, $idlang);

        if (count($tipolo) == 1) {
            $fullTipolo = $tipolo[0];
            $fullTipolo->imgart = Imgart::getAllImagesFromModel($fullTipolo->cdartn);
            return $fullTipolo;
        }
        return '';
    }

    private function getAnaartImages($cdarti, $idlang = 'IT')
    {
        $anaart = Anaart::getMinimalArticle($cdarti, $idlang);
        if (!empty($anaart)) {
            $fullAnaart = $anaart;
            $fullAnaart->imgart = Imgart::getAllImagesFromArticle($fullAnaart->cdarti);
            return $fullAnaart;
        }
        return '';
    }

    private function getAllArticlesForCurrentFabric($cdarti, $cdcata, $idlang, $nulist, $order = null)
    {
        $items = array(
            'cdcata' => $cdcata,
            'cdarti' => $cdarti,
            'nulist' => $nulist,
            'idlang' => $idlang,
            'id_usr' => $this->session->get('auth')['id'],
        );

        $anaart = Anaart::getAllArticlesForCurrentFabric($items);
        $showNotAvailable = $this->utility->getAppSettings('ParamShowNotAvailableItems') == 1;

        $full_anaart = array();
        for ($i = 0; $i < count($anaart); $i++) {
            $curr_anaart = $anaart[$i];

            // It's always fabric!
            $colors = '';
            if ($order != null > 0) {
                if ($order->tpordc == 0) {
                    $colors = Artcol::getAvailableColorsFromArticleAndOrder($curr_anaart->cdarti, $order->nuordc);
                } else {
                    $colors = Artcol::getColorsFromArticleAndOrder($curr_anaart->cdarti, $order->nuordc);
                }
            } else {
                $colors = Artcol::getColorsFromArticle($curr_anaart->cdarti);
            }

            $curr_anaart->writeAttribute('colors', $colors);

            // If order, check for availability
            if ($order != null && $order->tpordc == 0) {
                $curr_anaart->is_available = '';
                $curr_anaart->writeAttribute('is_available', 'false');
                for ($j = 0; $j < count($curr_anaart->colors); $j++) {
                    if ($curr_anaart->colors[$j]['is_available'] > 0) {
                        $curr_anaart->writeAttribute('is_available', 'true');
                    } else if ($showNotAvailable) {
                        $curr_anaart->writeAttribute('is_available', $curr_anaart->colors[$j]['is_available'] > 0 ? 'true' : 'false');
                    } else {
                        unset($curr_anaart->colors[$j]);
                    }
                }
                $curr_anaart->colors = array_values($curr_anaart->colors);

                if ($curr_anaart->is_available == 'true' || $showNotAvailable) {
                    $full_anaart[] = $curr_anaart;
                }
            } else {
                $full_anaart[] = $curr_anaart;
            }
        }

        return $full_anaart;
    }

    private function getAllAnaartFromTipolo($cdartn, $cdcata, $idlang, $nulist, $numdis, $tppers = '', $order = null)
    {
        $items = array(
            'cdcata' => $cdcata,
            'cdartn' => $cdartn,
            'nulist' => $nulist,
            'idlang' => $idlang,
            'id_usr' => $this->session->get('auth')['id'],
            'numdis' => $numdis,
            'modelDetailStyle' => $this->utility->getAppSettings('ModelDetailStyle'),
            'colorAssignmentSource' => $this->utility->getAppSettings('ColorAssignmentSource'),
        );

        if ($items['modelDetailStyle'] != 2 || $order == null || $order->tpordc == 1) {
            $anaart = Anaart::getAllArticlesForModelDetail($items);
        } else {
            $anaart = Anaart::getAllAvailabileArticlesForModelDetailStyle2($items);
        }

        $showNotAvailable = $this->utility->getAppSettings('ParamShowNotAvailableItems') == 1;

        $full_anaart = array();
        for ($i = 0; $i < count($anaart); $i++) {
            $curr_anaart = $anaart[$i];

            // If tissue, check variants (backstitches)
            if ($tppers == 'PT') {
                $curr_anaart->colors = '';

                if ($order != null > 0) {
                    if ($order->tpordc == 0) {
                        $colors = Artcol::getAvailableColorsFromArticleAndOrder($curr_anaart->cdarti, $order->nuordc);
                    } else {
                        $colors = Artcol::getColorsFromArticleAndOrder($curr_anaart->cdarti, $order->nuordc);
                    }
                } else {
                    $colors = Artcol::getColorsFromArticle($curr_anaart->cdarti);
                }

                $curr_anaart->writeAttribute('colors', $colors);
            }

            // If order, check for availability
            if ($order != null && $order->tpordc == 0) {
                $curr_anaart->is_available = '';
                if ($tppers == 'PT') {
                    $curr_anaart->writeAttribute('is_available', 'false');
                    for ($j = 0; $j < count($curr_anaart->colors); $j++) {
                        if ($curr_anaart->colors[$j]['is_available'] > 0) {
                            $curr_anaart->writeAttribute('is_available', 'true');
                        } else if ($showNotAvailable) {
                            $curr_anaart->writeAttribute('is_available', $curr_anaart->colors[$j]['is_available'] > 0 ? 'true' : 'false');
                        } else {
                            unset($curr_anaart->colors[$j]);
                        }
                    }
                    $curr_anaart->colors = array_values($curr_anaart->colors);
                } else {
                    $curr_anaart->writeAttribute('is_available', $this->utility->isArticleAvailable($curr_anaart->cdarti));
                }

                if ($curr_anaart->is_available == 'true' || $showNotAvailable) {
                    $full_anaart[] = $curr_anaart;
                }
            } else {
                $full_anaart[] = $curr_anaart;
            }
        }

        return $full_anaart;
    }

    private function getRelatedFromProduct($cdcata, $code, $tpmode, $cdlinm, $cdserm, $nulist, $tppers, $common, $isModel = true, $idlang = 'IT')
    {
        $isPT = $tppers == 'PT';
        $params = array('cdcata' => $cdcata, 'code' => $code, 'nulist' => $nulist, 'tpmode' => $tpmode, 'cdlinm' => $cdlinm);

        if ($isModel) {
            $code = 'tp.cdartn';
            $image = 'tp.flimag';
            $leftJoinImgart = "LEFT JOIN Go2B\Models\Imgart im ON im.codic1 = tp.cdartn AND im.tpimag = 'MOD2'";
        } else {
            $code = 'aa.cdarti';
            $image = 'aa.flimag';
            $leftJoinImgart = "LEFT JOIN Go2B\Models\Imgart im ON im.codic1 = aa.cdarti AND im.tpimag = 'AR02'";
        }

        // Description translation
        $description = $isModel ? 'tp.dsartn AS dsartn' : 'aa.dsarti AS dsarti';
        $leftJoinDescription = '';
        if ($idlang != 'IT') {
            if ($isModel) {
                $description = 'COALESCE(d2.descri,d1.descri,tp.dsartn) AS dsartn';
                $leftJoinDescription = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang: ";
                $leftJoinDescription .= " LEFT JOIN Go2B\Models\Deslin d2 ON d2.tpdato = 'dsarti' AND d2.codic1 = tp.cdartn AND d2.idlang = :idlang: ";
            } else {
                $description = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
                $leftJoinDescription = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang: ";
            }
            $params['idlang'] = $idlang;
        }

        // Custom discount
        $custDisc = '0 AS cust_disc ';
        $leftJoinDisbdy = '';
        $numdis = $this->utility->getCustomDiscount();
        if ($numdis > 0) {
            if ($isModel) {
                $custDisc = 'COALESCE(c5.sconto,c4.sconto,c3.sconto,c2.sconto,c1.sconto,0) AS cust_disc ';
                $leftJoinDisbdy =
                    "LEFT JOIN Go2B\Models\B2bDisbdy c1 ON c1.cdtitl = lm.cdtitl AND c1.numdis = :numdis:
          LEFT JOIN Go2B\Models\B2bDisbdy c2 ON c2.cdlinm = tp.cdlinm AND c2.cdserm = '' AND c2.numdis = :numdis:
          LEFT JOIN Go2B\Models\B2bDisbdy c3 ON c3.cdlinm = tp.cdlinm AND c3.cdserm = tp.cdserm AND c3.numdis = :numdis:
          LEFT JOIN Go2B\Models\B2bDisbdy c4 ON c4.tpmode = tp.tpmode AND c4.numdis = :numdis:
          LEFT JOIN Go2B\Models\B2bDisbdy c5 ON c5.cdartn = tp.cdartn AND c5.numdis = :numdis: ";
            } else {
                $custDisc = 'COALESCE(c6.sconto,c5.sconto,c4.sconto,c3.sconto,c2.sconto,c1.sconto,0) AS cust_disc ';
                $leftJoinDisbdy =
                    "LEFT JOIN Go2B\Models\B2bDisbdy c1 ON c1.cdtitl = lm.cdtitl AND c1.numdis = :numdis:
          LEFT JOIN Go2B\Models\B2bDisbdy c2 ON c2.cdlinm = tp.cdlinm AND c2.cdserm = '' AND c2.numdis = :numdis:
          LEFT JOIN Go2B\Models\B2bDisbdy c3 ON c3.cdlinm = tp.cdlinm AND c3.cdserm = tp.cdserm AND c3.numdis = :numdis:
          LEFT JOIN Go2B\Models\B2bDisbdy c4 ON c4.tpmode = tp.tpmode AND c4.numdis = :numdis:
          LEFT JOIN Go2B\Models\B2bDisbdy c5 ON c5.cdartn = tp.cdartn AND c5.numdis = :numdis:
          LEFT JOIN Go2B\Models\B2bDisbdy c6 ON c6.cdarti = aa.cdarti AND c6.numdis = :numdis: ";
            }
            $params['numdis'] = $numdis;
        }

        // Presence and availability
        $presence = '';
        $isAvailable = '';
        $leftJoinArtcol = '';
        $havingNotAvailable = '';
        if ($common['isOrder']) {
            // Presence
            $whr1_pr = '';
            if ($isPT) {
                $leftJoinArtcol = ' LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti ';
                $whr1_pr = ' AND oc1.cdcolo = ac.cdcolo ';
            }

            $params['id_usr'] = $this->session->get('auth')['id'];
            $presence = ",
        COALESCE(
          (SELECT oc1.nurorc
          FROM Go2B\Models\Occorp oc1
          INNER JOIN Go2B\Models\Octest ot1 ON ot1.nuordc = oc1.nuordc
          WHERE aa.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr: AND ot1.flstat = 0
          LIMIT 1),
          -1) AS presence ";

            // If availability order, add is_available field
            if ($common['order_info']->tpordc == 0) {
                $whr1_av = '';
                $whr2_av = '';
                if ($isPT) {
                    $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
                    $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
                }

                $isAvailable = ",
          IF(MAX(
            COALESCE(
              (SELECT MAX(dc2.quanti -
                COALESCE(
                  (SELECT SUM(og2.quanti)
                  FROM Go2B\Models\Octagl og2
                  INNER JOIN Go2B\Models\Occorp oc2 ON oc2.nurorc = og2.nurorc
                  INNER JOIN Go2B\Models\Octest ot2 ON ot2.nuordc = oc2.nuordc
                  WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
                ) AS quanti
              FROM Go2B\Models\Dscorp dc2
              WHERE dc2.cdarti = aa.cdarti $whr2_av),
            0)
          ) > 0, true, false) AS is_available ";

                // If parameter "show not available" is false, filter not available items
                if ($common['shownotavailable'] == 0) {
                    $havingNotAvailable = ' HAVING is_available = 1 ';
                }
            }
        }

        // 1) Take 4 tipolo with same tpmode and cdlinm
        $phql = "SELECT $code, $description, tp.tppers, $image, COALESCE(im.flimag,'') AS flimg2,
      COALESCE(IF(lc.taglia > '', -1, MAX(lc.prezzo)), 0) as catalogPrice, $custDisc
      $presence $isAvailable
      FROM Go2B\Models\Ctarti ca
      INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
      INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
      INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
      LEFT JOIN Go2B\Models\Lscorp lc ON lc.nulist = :nulist: AND lc.cdarti = aa.cdarti
      $leftJoinImgart
      LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
      $leftJoinDisbdy
      $leftJoinDescription
      $leftJoinArtcol
      WHERE ca.cdcata = :cdcata: AND $code != :code:
      AND tp.tpmode = :tpmode: AND lm.cdlinm = :cdlinm:
      AND tp.flbloc = 0 AND aa.flbloc = 0
      AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
      GROUP BY $code
      $havingNotAvailable
      LIMIT 4 ";
        $related = $this->modelsManager->executeQuery($phql, $params);

        if (count($related) < 4) {
            // New params
            $params = array('cdcata' => $cdcata, 'code' => $code, 'nulist' => $nulist, 'tpmode' => $tpmode);
            if ($idlang != 'IT') {
                $params['idlang'] = $idlang;
            }
            if ($numdis > 0) {
                $params['numdis'] = $numdis;
            }
            if ($common['isOrder']) {
                $params['id_usr'] = $this->session->get('auth')['id'];
            }

            // Avoid all found codes
            $excludeCodes = '';
            $codes = '';
            foreach ($related as $product) {
                if ($isModel) {
                    $codes .= '"' . $product->cdartn . '",';
                } else {
                    $codes .= '"' . $product->cdarti . '",';
                }
            }
            $codes = substr($codes, 0, -1);
            if (count($related) > 0) {
                $excludeCodes .= "AND $code NOT IN (" . $codes . ") ";
            }

            // New limit
            $limit = 4 - count($related);

            // 2) Take other tipolo's with same tpmode but different cdlinm
            $phql = "SELECT $code, $description, tp.tppers, $image, COALESCE(im.flimag,'') AS flimg2,
        COALESCE(IF(lc.taglia > '', -1, MAX(lc.prezzo)), 0) as catalogPrice, $custDisc
        $presence $isAvailable
        FROM Go2B\Models\Ctarti ca
        INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
        INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
        INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
        LEFT JOIN Go2B\Models\Lscorp lc ON lc.nulist = :nulist: AND lc.cdarti = aa.cdarti
        $leftJoinImgart
        LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
        $leftJoinDisbdy
        $leftJoinDescription
        $leftJoinArtcol
        WHERE ca.cdcata = :cdcata: AND $code != :code:
        $excludeCodes
        AND tp.tpmode = :tpmode: AND tp.flbloc = 0 AND aa.flbloc = 0
        AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
        GROUP BY $code
        $havingNotAvailable
        LIMIT $limit ";
            $related2 = $this->modelsManager->executeQuery($phql, $params);

            $full_related = array();
            foreach ($related as $el) {
                $full_related[] = $el;
            }
            foreach ($related2 as $el) {
                $full_related[] = $el;
            }
            $related = $full_related;

            if (count($related) < 4) {
                // New params
                $params = array('cdcata' => $cdcata, 'code' => $code, 'nulist' => $nulist, 'cdlinm' => $cdlinm, 'cdserm' => $cdserm);
                if ($idlang != 'IT') {
                    $params['idlang'] = $idlang;
                }
                if ($numdis > 0) {
                    $params['numdis'] = $numdis;
                }
                if ($common['isOrder']) {
                    $params['id_usr'] = $this->session->get('auth')['id'];
                }

                // Avoid all found codes
                $excludeCodes = '';
                $codes = '';
                foreach ($related as $product) {
                    if ($isModel) {
                        $codes .= '"' . $product->cdartn . '",';
                    } else {
                        $codes .= '"' . $product->cdarti . '",';
                    }
                }
                $codes = substr($codes, 0, -1);
                if (count($related) > 0) {
                    $excludeCodes .= "AND $code NOT IN (" . $codes . ") ";
                }

                // New limit
                $limit = 4 - count($related);

                // 3) Take other tipolo's with the same cdlinm & cdserm
                $phql = "SELECT $code, $description, tp.tppers, $image, COALESCE(im.flimag,'') AS flimg2,
          COALESCE(IF(lc.taglia > '', -1, MAX(lc.prezzo)), 0) as catalogPrice, $custDisc
          $presence $isAvailable
          FROM Go2B\Models\Ctarti ca
          INNER JOIN Go2B\Models\Anaart aa ON aa.cdarti = ca.cdarti
          INNER JOIN Go2B\Models\Tipolo tp ON tp.cdartn = aa.cdartn
          INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
          LEFT JOIN Go2B\Models\Lscorp lc ON lc.nulist = :nulist: AND lc.cdarti = aa.cdarti
          $leftJoinImgart
          LEFT JOIN Go2B\Models\B2bTipval ba ON ba.cdartn = tp.cdartn
          $leftJoinDisbdy
          $leftJoinDescription
          $leftJoinArtcol
          WHERE ca.cdcata = :cdcata: AND $code != :code:
          $excludeCodes
          AND tp.cdlinm = :cdlinm: AND tp.cdserm = :cdserm:
          AND tp.flbloc = 0 AND aa.flbloc = 0
          AND IFNULL(ba.dtiniz,'2000-01-01') <= CURRENT_DATE() AND IFNULL(ba.dtfine,'2200-01-01') >= CURRENT_DATE()
          GROUP BY $code
          $havingNotAvailable
          LIMIT $limit ";
                $related3 = $this->modelsManager->executeQuery($phql, $params);

                $full_related = array();
                foreach ($related as $el) {
                    $full_related[] = $el;
                }
                foreach ($related3 as $el) {
                    $full_related[] = $el;
                }
                $related = $full_related;
            }
        }

        return $related;
    }

    private function getRecents($recentsSorted, $nulist, $tppers, $common, $idlang = 'IT')
    {
        $full_recents = array();
        if (count($recentsSorted) > 0) {
            $isPT = $tppers == 'PT';
            $params = array('nulist' => $nulist);

            $andWhereCol = '';
            if ($common['catalogProductType'] == 0) {
                $code = 'tp.cdartn';
                $image = 'tp.flimag';
                $leftJoinImgart = "LEFT JOIN Go2B\Models\Imgart im ON im.codic1 = tp.cdartn AND im.tpimag = 'MOD2'";
            } else if ($common['catalogProductType'] == 1) {
                $code = 'aa.cdarti';
                $image = 'aa.flimag';
                $leftJoinImgart = "LEFT JOIN Go2B\Models\Imgart im ON im.codic1 = aa.cdarti AND im.tpimag = 'AR02'";
            } else if ($common['catalogProductType'] == 2) {
                $code = 'aa.cdarti';
                $image = 'ac.flimag';
                $leftJoinImgart = "LEFT JOIN Go2B\Models\Imgart im ON im.codic1 = aa.cdarti AND im.tpimag = 'AR02'";
                $andWhereCol = "AND ac.flimag != ''";
            }

            // Description translation
            $description = $common['catalogProductType'] == 0 ? 'tp.dsartn AS dsartn' : 'aa.dsarti AS dsarti';
            $leftJoinDescription = '';
            if ($idlang != 'IT') {
                if ($common['catalogProductType'] == 0) {
                    $description = 'COALESCE(d1.descri,tp.dsartn) AS dsartn';
                    $leftJoinDescription = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsartn' AND d1.codic1 = tp.cdartn AND d1.idlang = :idlang: ";
                } else {
                    $description = 'COALESCE(d1.descri,aa.dsarti) AS dsarti';
                    $leftJoinDescription = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = aa.cdarti AND d1.idlang = :idlang: ";
                }
                $params['idlang'] = $idlang;
            }

            // Custom discount
            $custDisc = '0 AS cust_disc ';
            $leftJoinDisbdy = '';
            $numdis = $this->utility->getCustomDiscount();
            if ($numdis > 0) {
                if ($common['catalogProductType'] == 0) {
                    $custDisc = 'COALESCE(c5.sconto,c4.sconto,c3.sconto,c2.sconto,c1.sconto,0) AS cust_disc ';
                    $leftJoinDisbdy =
                        "INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
            LEFT JOIN Go2B\Models\B2bDisbdy c1 ON c1.cdtitl = lm.cdtitl AND c1.numdis = :numdis:
            LEFT JOIN Go2B\Models\B2bDisbdy c2 ON c2.cdlinm = tp.cdlinm AND c2.cdserm = '' AND c2.numdis = :numdis:
            LEFT JOIN Go2B\Models\B2bDisbdy c3 ON c3.cdlinm = tp.cdlinm AND c3.cdserm = tp.cdserm AND c3.numdis = :numdis:
            LEFT JOIN Go2B\Models\B2bDisbdy c4 ON c4.tpmode = tp.tpmode AND c4.numdis = :numdis:
            LEFT JOIN Go2B\Models\B2bDisbdy c5 ON c5.cdartn = tp.cdartn AND c5.numdis = :numdis: ";
                } else {
                    $custDisc = 'COALESCE(c6.sconto,c5.sconto,c4.sconto,c3.sconto,c2.sconto,c1.sconto,0) AS cust_disc ';
                    $leftJoinDisbdy =
                        "INNER JOIN Go2B\Models\Linmod lm ON lm.cdlinm = tp.cdlinm
             LEFT JOIN Go2B\Models\B2bDisbdy c1 ON c1.cdtitl = lm.cdtitl AND c1.numdis = :numdis:
             LEFT JOIN Go2B\Models\B2bDisbdy c2 ON c2.cdlinm = tp.cdlinm AND c2.cdserm = '' AND c2.numdis = :numdis:
             LEFT JOIN Go2B\Models\B2bDisbdy c3 ON c3.cdlinm = tp.cdlinm AND c3.cdserm = tp.cdserm AND c3.numdis = :numdis:
             LEFT JOIN Go2B\Models\B2bDisbdy c4 ON c4.tpmode = tp.tpmode AND c4.numdis = :numdis:
             LEFT JOIN Go2B\Models\B2bDisbdy c5 ON c5.cdartn = tp.cdartn AND c5.numdis = :numdis:
             LEFT JOIN Go2B\Models\B2bDisbdy c6 ON c6.cdarti = aa.cdarti AND c6.numdis = :numdis: ";
                }
                $params['numdis'] = $numdis;
            }

            // Presence and availability
            $presence = '';
            $isAvailable = '';
            $leftJoinArtcol = '';
            $havingNotAvailable = '';
            $whr1_pr = '';
            if ($isPT) {
                $leftJoinArtcol = ' LEFT JOIN Go2B\Models\Artcol ac ON ac.cdarti = aa.cdarti ';
                $whr1_pr = ' AND oc1.cdcolo = ac.cdcolo ';
            }
            if ($common['isOrder']) {
                // Presence

                $params['id_usr'] = $this->session->get('auth')['id'];
                $presence = ",
          COALESCE(
            (SELECT oc1.nurorc
            FROM Go2B\Models\Occorp oc1
            INNER JOIN Go2B\Models\Octest ot1 ON ot1.nuordc = oc1.nuordc
            WHERE aa.cdarti = oc1.cdarti $whr1_pr AND ot1.id_usr = :id_usr: AND ot1.flstat = 0
            LIMIT 1),
            -1) AS presence ";

                // If availability order, add is_available field
                if ($common['order_info']->tpordc == 0) {
                    $whr1_av = '';
                    $whr2_av = '';
                    if ($isPT) {
                        $whr1_av = ' AND oc2.cdcolo = dc2.cdcolo AND oc2.cdvari = dc2.cdvari ';
                        $whr2_av = ' AND dc2.cdcolo = ac.cdcolo ';
                    }

                    $isAvailable = ",
            IF(MAX(
              COALESCE(
                (SELECT MAX(dc2.quanti -
                  COALESCE(
                    (SELECT SUM(og2.quanti)
                    FROM Go2B\Models\Octagl og2
                    INNER JOIN Go2B\Models\Occorp oc2 ON oc2.nurorc = og2.nurorc
                    INNER JOIN Go2B\Models\Octest ot2 ON ot2.nuordc = oc2.nuordc
                    WHERE oc2.cdarti = dc2.cdarti $whr1_av AND ot2.flstat = 2 AND og2.dstagl = dc2.taglia), 0)
                  ) AS quanti
                FROM Go2B\Models\Dscorp dc2
                WHERE dc2.cdarti = aa.cdarti $whr2_av),
              0)
            ) > 0, true, false) AS is_available ";

                    // If parameter "show not available" is false, filter not available items
                    if ($common['shownotavailable'] == 0) {
                        $havingNotAvailable = ' HAVING is_available = 1 ';
                    }
                }
            }

            // Set string of recent cdartn's
            $recentsString = '';
            for ($i = 0; $i < count($recentsSorted); $i++) {
                if ($i != 0) {
                    $recentsString .= ',';
                }
                $recentsString .= "'" . $recentsSorted[$i] . "'";
            }

            $phql = "SELECT $code, $description, tp.tppers, $image, COALESCE(im.flimag,'') AS flimg2,
        COALESCE(IF(lc.taglia > '', -1, MAX(lc.prezzo)), 0) as catalogPrice, $custDisc
        $presence $isAvailable
        FROM Go2B\Models\Tipolo tp
        INNER JOIN Go2B\Models\Anaart aa ON tp.cdartn = aa.cdartn
        LEFT JOIN Go2B\Models\Lscorp lc ON lc.nulist = :nulist: AND lc.cdarti = aa.cdarti
        $leftJoinImgart
        $leftJoinDisbdy
        $leftJoinDescription
        $leftJoinArtcol
        WHERE $code IN ($recentsString) $andWhereCol
        GROUP BY $code
        $havingNotAvailable
        ORDER BY FIELD ($code, $recentsString)";
            $recents = $this->modelsManager->executeQuery($phql, $params);

            return $recents;
        }

        return array();
    }

    private function getLinkedBuyProducts($code, $nulist, $tppers, $common, $idlang = 'IT')
    {
        $items = array(
            'cdartn' => $code,
            'cdarti' => $code,
            'nulist' => $nulist,
            'idlang' => $idlang,
            'numdis' => $this->utility->getCustomDiscount(),
            'isOrder' => $common['isOrder'],
            'idUsr' => $this->session->get('auth')['id'],
            'isPT' => $tppers == 'PT',
            'isAvailability' => $common['isOrder'] && $common['order_info']->tpordc == 0,
            'showAvailables' => $common['shownotavailable'] == 1,
        );
        if ($common['catalogProductType'] == 0) {
            $products = Tipolo::getLinkedBuyProducts($items);
        } else {
            $products = Anaart::getLinkedBuyProducts($items);
        }

        return $products;
    }

    private function getHtmlModalNotifyAvailability($anaart, $artcol, $artvar)
    {
        // Get column widths for header selector
        $col_anaart = 'col-12 ';
        if (count($artcol) > 0) {
            $col_anaart .= count($artvar) > 0 ? ' col-lg-4' : ' col-lg-6';
        }
        $col_artcol = count($artvar) > 0 ? 'col-12 col-lg-4' : 'col-12 col-lg-6';

        // Prepare html for anaart, artcol, artvar select
        $anaart_options = '';
        foreach ($anaart as $article) {
            $anaart_options .= '<option value="' . $article->cdarti . '">' . $article->cdarti . ' - ' .
                htmlentities($article->dsarti, ENT_COMPAT, 'UTF-8') . '</option>';
        }

        $artcol_options = '';
        $artvar_options = '';
        if (count($artcol) > 0) {
            foreach ($artcol as $color) {
                $artcol_options .= '<option value="' . $color->cdcolo . '" data-cdarti="' . $color->cdarti . '">' . $color->cdcolo . ' - ' . htmlentities($color->dscolo, ENT_COMPAT, 'UTF-8') . '</option>';
            }

            if (count($artvar) > 0) {
                $artvar_options .= '<option value="no_cdvari" data-preagg="0" data-all="true">' . $this->translate('_common.variant.no') . '</option>';
                foreach ($artvar as $variant) {
                    $artvar_options .= '<option value="' . $variant->cdvari . '"
            data-preagg="' . $variant->preagg . '" data-all="false" data-cdarti="' . $variant->cdarti . '">' . htmlentities($variant->dsvari, ENT_COMPAT, 'UTF-8') . '</option>';
                }
            }
        }

        // Write html
        $html =
            '<div class="row">
      <div class="' . $col_anaart . '">
        <div class="font-weight-bold">' . $this->translate('_common.article') . '</div>
        <select class="form-control" name="notify_anaart" id="notify_anaart">' . $anaart_options . '</select>
      </div>' .
            (count($artcol) > 0
                ? '<div class="' . $col_artcol . '">
        <div class="font-weight-bold">' . $this->translate('_common.color') . '</div>
        <select class="form-control" name="notify_artcol" id="notify_artcol">' . $artcol_options . '</select>
      </div>' : '') .
            (count($artvar) > 0
                ? '<div class="col-12 col-lg-4">
        <div class="font-weight-bold">' . $this->translate('_common.variant') . '</div>
        <select class="form-control" name="notify_artvar" id="notify_artvar">' . $artvar_options . '</select>
      </div>' : '') .
            '</div>';

        return $html;
    }

    private function getHtmlModalNotifyAvailabilityQuantity($postgl, $preagg)
    {
        $html =
            '<div class="row header-insert-table mx-0">
        <div class="col">' . $this->translate('_common.sizes.qty') . '</div>
        <div class="col">' . $this->translate('_common.price') . '</div>
        <div class="col-4">' . $this->translate('_common.quantity') . '</div>
      </div>';

        foreach ($postgl as $taglia) {
            $price = $taglia->prezzo + $preagg;
            $num_price = $price;
            if (is_numeric($taglia->prezzo) && $taglia->prezzo > 0) {
                $currency = $this->utility->getCurrencySymbol($taglia->cdvalu);
                $price = $this->utility->getFormattedPriceCurrencyPresent($taglia->prezzo, $currency, $taglia->cdvalu)['value'];
            } else {
                $price = $taglia->prezzo > 0 ? $taglia->prezzo : '&nbsp;';
            }

            $html .=
                '<div class="row insert-quantity-row mx-0">
        <div class="col taglia">' . $taglia->taglia . '</div>
        <div class="col price" data-price="' . $num_price . '">' . $price . '</div>
        <div class="col-4">
          <div class="btn-notify-number minus-qty disabled" data-type="minus">
            <i class="fa fa-minus" aria-hidden="true"></i>
          </div>
          <div class="float-left w-40">
            <input type="text" class="input-notify-number">
          </div>
          <div class="btn-notify-number plus-qty" data-type="plus">
            <i class="fa fa-plus" aria-hidden="true"></i>
          </div>
        </div>
      </div>';
        }

        return $html;
    }
    //endregion

    //region Insert quantity functions
    private function getAssortmentsFromCdarti($cdarti)
    {
        $astest = Astest::getAllAssortmentsForArticle($cdarti);

        $fullAstest = array();
        if (count($astest) > 0) {
            for ($i = 0; $i < count($astest); $i++) {
                $currAstest = $astest[$i];
                $currAstest->detail = '';
                $currAstest->writeAttribute('detail', $this->getAssortmentDetail($currAstest->cdtagl, $currAstest->cdasso));
                $fullAstest[] = $currAstest;
            }
        }

        return $fullAstest;
    }

    private function getAssortmentDetail($cdtagl, $cdasso)
    {
        $ascorp = Ascorp::getAssortmentDetail($cdasso, $cdtagl);

        $full_ascorp = array();
        if (count($ascorp) > 0) {
            for ($i = 0; $i < count($ascorp); $i++) {
                $full_ascorp[$ascorp[$i]->taglia] = $ascorp[$i]->qtatgl;
            }
        }

        return $full_ascorp;
    }
    //endregion

    //region Html for insert quantity (PT and Availability Order)
    private function getHtmlCodeForAvaTissue($sizes, $tipolo, $order_rows, $ava,
                                             $variants, $dateOffset, $showInfo, $modal, $canGoToCart, $discount)
    {
        $html = "";

        /*
     * NO_CDVARI: add row for cdvari == '' for every delivery date
     */
        $index = 1;

        // Get availability array for no_cdvari article
        $curr_ava = null;
        for ($i = 0; $i < count($ava); $i++) {
            if ($ava[$i]["cdvari"] == "no_cdvari") {
                $curr_ava = $ava[$i];
                break;
            }
        }

        // Get number of availability dates
        $num_dates = 0;
        if (count($curr_ava) > 0) {
            $num_dates = count($curr_ava["alldsp"]);
        }

        // For each date get html row
        if ($num_dates > 0) {
            for ($i = 0; $i < $num_dates; $i++) {
                $this_ava = $curr_ava["alldsp"][$i];

                // Get order row for current
                $curr_row = null;
                for ($j = 0; $j < count($order_rows); $j++) {
                    $date_row = date("Y-m-d", strtotime(str_replace("/", "-", $order_rows[$j]->dtmcli) . " -" . $dateOffset . " days"));
                    $date_ava = date("Y-m-d", strtotime(str_replace("/", "-", $this_ava["dtdisp"])));
                    if ($date_row <= $date_ava && $order_rows[$j]->cdvari == '') {
                        $curr_row = $order_rows[$j];
                        break;
                    }
                }

                // Get html row
                $html .= $this->getHtmlCodeForAvaTissue_Row($sizes, $tipolo, $this_ava,
                    $index, $curr_row, "", $dateOffset, $showInfo, $modal, $canGoToCart, $discount);
                $index++;
            }
        }

        /*
     * CDVARI: add row for cdvari != '' for every delivery date
     */
        if (count($variants) > 0) {
            for ($i = 0; $i < count($variants); $i++) {
                // Get availability array for no_cdvari article
                $curr_ava = array();
                for ($j = 0; $j < count($ava); $j++) {
                    if ($ava[$j]["cdvari"] == $variants[$i]["cdvari"]) {
                        $curr_ava = $ava[$j];
                        break;
                    }
                }

                // Get number of availability dates
                $num_dates = 0;
                if (count($curr_ava) > 0) {
                    $num_dates = count($curr_ava["alldsp"]);
                }

                // For each date get html row
                if ($num_dates > 0) {
                    for ($j = 0; $j < $num_dates; $j++) {
                        $this_ava = $curr_ava["alldsp"][$j];

                        // Get order row for current
                        $curr_row = null;
                        for ($k = 0; $k < count($order_rows); $k++) {
                            $dtmcli = date("d/m/Y", strtotime(str_replace("/", "-", $order_rows[$j]->dtmcli) . " -" . $dateOffset . " days"));
                            if ($dtmcli && $order_rows[$k]->cdvari == $variants[$i]["cdvari"]) {
                                $curr_row = $order_rows[$k];
                                break;
                            }
                        }

                        // Get html row
                        $html .= $this->getHtmlCodeForAvaTissue_Row($sizes, $tipolo, $this_ava,
                            $index, $curr_row, $variants[$i], $dateOffset, $showInfo, $modal, $canGoToCart, $discount);
                        $index++;
                    }
                }
            }
        }

        return $html;
    }

    private function getHtmlCodeForAvaTissue_Row($sizes, $tipolo, $ava, $index,
                                                 $order_row, $variant, $dateOffset, $showInfo, $modal, $canGoToCart, $discount)
    {
        $html = "<div class='insert-quantity-block'>";

        $html .= $this->getHeaderAvaTissueBlock($ava, $index, $order_row, $variant, $dateOffset, $showInfo, $sizes, $modal);

        $html .= $this->getHeaderTable(true, $modal);

        for ($i = 0; $i < count($sizes); $i++) {
            $quanti = 0;
            if (isset($order_row) && $order_row->detail[$sizes[$i]->taglia]) {
                $quanti = $order_row->detail[$sizes[$i]->taglia];
            }
            $blocked = (($i + 1) < $tipolo->tglini && $tipolo->tglini != 0) || (($i + 1) > $tipolo->tglfin && $tipolo->tglfin != 0);
            $html .= $this->getInsertQuantityRow($sizes[$i],
                isset($ava["qtysiz"][$sizes[$i]->taglia]) && $ava["qtysiz"][$sizes[$i]->taglia] > 0 ? $ava["qtysiz"][$sizes[$i]->taglia] : 0, $variant,
                $index . "_" . $i, $quanti, $modal, $discount, true, $blocked);
        }

        $html .= $this->getFooterBlock($modal, $canGoToCart);

        $html .= "</div>";

        return $html;
    }

    private function getHeaderAvaTissueBlock($ava, $index, $order_row, $variant, $dateOffset, $showInfo, $sizes, $modal)
    {
        // Open row
        $html = "<div id='row-" . $index . "' class='row header-insert-block' ";
        $html .= "data-nurorc='" . (isset($order_row) ? $order_row->nurorc : '-1') . "' ";
        $html .= "data-cdvari='" . ($variant != "" ? $variant["cdvari"] : '') . "' ";
        $html .= "data-dtmcli='" . date("Y-m-d", strtotime(str_replace("/", "-", $ava["dtdisp"]) . " +" . $dateOffset . " days")) . "' ";
        $html .= "data-indorc='" . ($showInfo['showIndicative'] && isset($order_row) ? htmlentities($order_row->indorc) : '') . "' ";
        $html .= "data-dsnoco='" . ($showInfo['showNotes'] && isset($order_row) ? htmlentities($order_row->dsnoco) : '') . "' ";
        $html .= "data-sgrifc='" . ($showInfo['showReference'] && isset($order_row) ? htmlentities($order_row->sgrifc) : '') . "'>";

        // Index
        $html .= "<div class='col-1'>" . $index . ".</div>";

        // Delivery Date
        $text1 = $this->translate('cart.deliverydate') . ": ";
        $text2 = date("d/m/Y", strtotime(str_replace("/", "-", $ava["dtdisp"]) . " +" . $dateOffset . " days"));

        $html .= "<div class='truncate " . ($modal ? "col-11 col-md-7" : "col-6 col-md-5") . "'
      title='" . date("d/m/Y", strtotime(str_replace("/", "-", $ava["dtdisp"]) . " +" . $dateOffset . " days")) . "'>";
        $html .= $modal ? "<div class='float-left'>" . $text1 . "</div>" : "<span>" . $text1 . "</span>";
        $html .= $modal ? "<div class='float-left ml-5x' style='color:black'>" . $text2 . "</div>" : "<span style='color:black'>" . $text2 . "</span>";
        $html .= "</div>";

        // Variant
        if ($variant != "") {
            $html .= "<div class='truncate " . ($modal ? "col-12 col-md-5" : "col-3 col-md-4") . "' title='" . htmlentities($variant['dsvari'], ENT_COMPAT, 'UTF-8') . "'>";
            $html .= "<span>" . $this->translate('_common.variant') . ": </span>";
            $html .= "<span style='color:black'>" . htmlentities($variant['dsvari'], ENT_COMPAT, 'UTF-8') . "</span>";
            $html .= "</div>";
        } else {
            $html .= "<div class='" . ($modal ? "col-12 col-md-5" : "col-3 col-md-4") . "'>";
            $html .= $this->translate('_common.variant.no');
            $html .= "</div>";
        }

        // Info - you can see it if you can select date (tppers != PT and reservation order) or indicative or rif or note
        if (!$modal) {
            if ($showInfo['showIndicative'] || $showInfo['showNotes'] || $showInfo['showReference']) {
                $html .= "<div class='col-2 info-order-row' data-toggle='modal' data-target='.modal-info-row'>";
                $html .= $this->translate('_common.info');
                $html .= "</div>";
            }
        } else {
            $html .= $this->getInfoHeaderRow($showInfo['showNotes'], $order_row);
        }

        // Close row
        $html .= "</div>";

        // Public price, if needed
        if ($this->utility->getAppSettings('ParamPriceSellPublicVisible')) {
            $html .= $this->addPublicPrice($sizes);
        }

        return $html;
    }
    //endregion

    //region Html for insert quantity (PT and Reservation Order)
    private function getHtmlCodeForResTissue($sizes, $assortments, $tipolo, $order_rows,
                                             $variants, $dtmcli, $showInfo, $modal, $canGoToCart, $discount)
    {
        $html = "";

        // NO_CDVARI: add row for cdvari == '' for every delivery date
        $index = 1;

        // Get order row for current
        $curr_row = null;
        for ($j = 0; $j < count($order_rows); $j++) {
            if ($order_rows[$j]->cdvari == '') {
                $curr_row = $order_rows[$j];
                break;
            }
        }

        // Get html row
        $html .= $this->getHtmlCodeForResTissue_Row($sizes, $assortments, $tipolo, $index,
            $curr_row, "", $dtmcli, $showInfo, $modal, $canGoToCart, $discount);
        $index++;

        // CDVARI: add row for cdvari != '' for every delivery date
        if (count($variants) > 0) {
            for ($i = 0; $i < count($variants); $i++) {
                // Get order row for current
                $curr_row = null;
                for ($k = 0; $k < count($order_rows); $k++) {
                    if ($order_rows[$k]->cdvari == $variants[$i]["cdvari"]) {
                        $curr_row = $order_rows[$k];
                        break;
                    }
                }

                // Get html row
                $html .= $this->getHtmlCodeForResTissue_Row($sizes, $assortments, $tipolo, $index,
                    $curr_row, $variants[$i], $dtmcli, $showInfo, $modal, $canGoToCart, $discount);
                $index++;
            }
        }

        return $html;
    }

    private function getHtmlCodeForResTissue_Row($sizes, $assortments, $tipolo, $index, $order_row, $variant, $dtmcli,
                                                 $showInfo, $modal, $canGoToCart, $discount)
    {
        $html = "<div class='insert-quantity-block'>";

        $html .= $this->getHeaderResTissueBlock($index, $order_row, $variant, $dtmcli, $showInfo, $sizes, $modal);

        $html .= $this->getHeaderTable(false, $modal);

        if (count($sizes) > 0) {
            for ($i = 0; $i < count($sizes); $i++) {
                $quanti = 0;
                if (isset($order_row) && $order_row->detail[$sizes[$i]->taglia]) {
                    $quanti = $order_row->detail[$sizes[$i]->taglia];
                }
                $blocked = (($i + 1) < $tipolo->tglini && $tipolo->tglini != 0) || (($i + 1) > $tipolo->tglfin && $tipolo->tglfin != 0);
                $html .= $this->getInsertQuantityRow($sizes[$i], -1, $variant, $index . "_" . $i, $quanti, $modal, $discount, true, $blocked);
            }
        }


        $showAssortements = $this->utility->getAppSettings('showAssortments');

        if ($showAssortements == '1') {
            if (count($assortments) > 0) {
                for ($i = 0; $i < count($assortments); $i++) {
                    $quanti = 0;
                    if (isset($order_row) && $order_row->assortments[$assortments[$i]->cdasso]) {
                        $quanti = $order_row->assortments[$assortments[$i]->cdasso];
                    }
                    $html .= $this->getInsertQuantityRow($assortments[$i], -1, '', $index . '_' . $i, $quanti, $modal, $discount, false);
                }
            }
        }


        $html .= $this->getFooterBlock($modal, $canGoToCart);

        $html .= "</div>";

        return $html;
    }

    private function getHeaderResTissueBlock($index, $order_row, $variant, $dtmcli, $showInfo, $sizes, $modal)
    {
        $showHeaderVariants = ($this->utility->getAppSettings('ModelDetailStyle') != 1 && $this->utility->getAppSettings('ModelDetailStyle') != 9);
        // Open row
        $html = "<div id='row-" . $index . "' class='row header-insert-block' ";
        $html .= "data-nurorc='" . (isset($order_row) ? $order_row->nurorc : '-1') . "' ";
        $html .= "data-cdvari='" . ($variant != "" ? $variant["cdvari"] : '') . "' ";
        $html .= "data-dtmcli='" . $dtmcli . "' ";
        $html .= "data-indorc='" . ($showInfo['showIndicative'] && isset($order_row) ? htmlentities($order_row->indorc) : '') . "' ";
        $html .= "data-dsnoco='" . ($showInfo['showNotes'] && isset($order_row) ? htmlentities($order_row->dsnoco) : '') . "' ";
        $html .= "data-sgrifc='" . ($showInfo['showReference'] && isset($order_row) ? htmlentities($order_row->sgrifc) : '') . "'>";

        if ($showHeaderVariants) {
            // Index
            $html .= "<div class='col-1'>" . $index . ".</div>";

            // Variant
            if ($variant != "") {
                $html .= "<div class='truncate " . ($modal ? "col-11" : "col-7") . "' title='" . htmlentities($variant['dsvari'], ENT_COMPAT, 'UTF-8') . "'>";
                $html .= "<span>" . $this->translate('_common.variant') . ": " . "</span>";
                $html .= "<span style='color:black'>" . htmlentities($variant['dsvari'], ENT_COMPAT, 'UTF-8') . "</span>";
                $html .= "</div>";
            } else {
                $html .= "<div class='" . ($modal ? "col-11" : "col-7") . "'>" . $this->translate('_common.variant.no') . "</div>";
            }
        } else {
            $html .= "<div class='" . ($modal ? "col-12" : "col-8") . "'>&nbsp;</div>";
        }

        // Info - you can see it if you can select date (tppers != PT and reservation order) or indicative or rif or note
        if (!$modal) {
            if ($showInfo['showIndicative'] || $showInfo['showNotes'] || $showInfo['showReference']) {
                $html .= "<div class='col-4 info-order-row' data-toggle='modal' data-target='.modal-info-row'>";
                $html .= $this->translate('_common.info');
                $html .= "</div>";
            }
        } else {
            $html .= $this->getInfoHeaderRow($showInfo['showNotes'], $order_row);
        }

        // Close row
        $html .= "</div>";

        // Public price, if needed
        if ($this->utility->getAppSettings('ParamPriceSellPublicVisible')) {
            $html .= $this->addPublicPrice($sizes);
        }

        return $html;
    }
    //endregion

    //region Html for insert quantity (no PT and Availability Order)
    private function getHtmlCodeForAvaColor($sizes, $tipolo, $order_rows,
                                            $ava_sizes, $assortments, $dateOffset, $showInfo, $modal, $canGoToCart, $discount)
    {
        $html = "";

        $index = 1;
        $processed = array();

        // Get number of availability dates
        $num_dates = count($ava_sizes);

        // For each date get html row
        if ($num_dates > 0) {
            for ($i = 0; $i < $num_dates; $i++) {
                $this_ava = $ava_sizes[$i];

                // Get order row for current
                $curr_row = null;
                for ($j = 0; $j < count($order_rows); $j++) {
                    if (!in_array($order_rows[$j]->nurorc, $processed)) {
                        $date_row = date("Y-m-d", strtotime(str_replace("/", "-", $order_rows[$j]->dtmcli) . " -" . $dateOffset . " days"));
                        $date_ava = date("Y-m-d", strtotime(str_replace("/", "-", $this_ava["dtdisp"])));
                        if ($date_row <= $date_ava) {
                            $curr_row = $order_rows[$j];
                            $processed[] = $curr_row->nurorc;
                            break;
                        }
                    }
                }

                // Get html row
                $html .= $this->getHtmlCodeForAvaColor_Row($sizes, $assortments, $tipolo,
                    $this_ava, $index, $curr_row, $dateOffset, $showInfo, $modal, $canGoToCart, $discount);
                $index++;
            }
        }

        return $html;
    }

    private function getHtmlCodeForAvaColor_Row($sizes, $assortments, $tipolo,
                                                $ava, $index, $order_row, $dateOffset, $showInfo, $modal, $canGoToCart, $discount)
    {
        $html = "<div class='insert-quantity-block'>";

        $html .= $this->getHeaderAvaColorBlock($ava, $index, $order_row, $dateOffset, $showInfo, $sizes, $modal);
        $html .= $this->getHeaderTable(true, $modal);
        $html .= $this->getAvaColorContent($sizes, $assortments, $tipolo, $ava, $index, $order_row, $modal, $discount);
        $html .= $this->getFooterBlock($modal, $canGoToCart);

        $html .= '</div>';

        return $html;
    }

    private function getHeaderAvaColorBlock($ava, $index, $order_row, $dateOffset, $showInfo, $sizes, $modal)
    {
        // Open row
        $html = "<div id='row-" . $index . "' class='row header-insert-block " . ($modal ? 'mb-0' : '') . "' ";
        $html .= "data-nurorc='" . (isset($order_row) ? $order_row->nurorc : '-1') . "' ";
        $html .= "data-cdvari='' ";
        $html .= "data-dtmcli='" . date("Y-m-d", strtotime(str_replace("/", "-", $ava["dtdisp"]) . " +" . $dateOffset . " days")) . "' ";
        $html .= "data-indorc='" . ($showInfo['showIndicative'] && isset($order_row) ? htmlentities($order_row->indorc) : '') . "' ";
        $html .= "data-dsnoco='" . ($showInfo['showNotes'] && isset($order_row) ? htmlentities($order_row->dsnoco) : '') . "' ";
        $html .= "data-sgrifc='" . ($showInfo['showReference'] && isset($order_row) ? htmlentities($order_row->sgrifc) : '') . "'>";

        // Index
        $html .= "<div class='col-1'>" . $index . ".</div>";

        // Delivery Date
        $text1 = $this->translate('cart.deliverydate') . ": ";
        $text2 = date("d/m/Y", strtotime(str_replace("/", "-", $ava["dtdisp"]) . " +" . $dateOffset . " days"));

        $html .= "<div class='truncate " . ($modal ? "col-11" : "col-7") . "' ";
        $html .= "title='" . date("d/m/Y", strtotime(str_replace("/", "-", $ava["dtdisp"]) . " +" . $dateOffset . " days")) . "'>";
        $html .= $modal ? "<div class='float-left'>" . $text1 . "</div>" : "<span>" . $text1 . "</span>";
        $html .= $modal ? "<div class='float-left ml-5x' style='color:black'>" . $text2 . "</div>" : "<span style='color:black'>" . $text2 . "</span>";
        $html .= "</div>";

        // Info - you can see it if you can select date (tppers != PT and reservation order) or indicative or rif or note
        if (!$modal) {
            if ($showInfo['showIndicative'] || $showInfo['showNotes'] || $showInfo['showReference']) {
                $html .= "<div class='col-4 info-order-row' data-toggle='modal' data-target='.modal-info-row'>";
                $html .= $this->translate('_common.info');
                $html .= "</div>";
            }
        } else {
            $html .= $this->getInfoHeaderRow($showInfo['showNotes'], $order_row);
        }

        // Close row
        $html .= "</div>";

        // Public price, if needed
        if ($this->utility->getAppSettings('ParamPriceSellPublicVisible')) {
            $html .= $this->addPublicPrice($sizes);
        }

        return $html;
    }
    //endregion

    //region Html for insert quantity (no PT and Reservation Order)
    private function getHtmlCodeForResColor($sizes, $assortments, $tipolo, $order_rows, $dateType, $periods,
                                            $multipledelivery, $showInfo, $modal, $canGoToCart, $discount)
    {
        $html = "";
        $index = 1;

        // Get number of delivery dates
        $num_dates = $multipledelivery ? 3 : 1;

        // For each date get html row
        if ($num_dates > 0) {
            for ($i = 0; $i < $num_dates; $i++) {
                $order_row = count($order_rows) > $i ? $order_rows[$i] : null;

                // Get html row
                $html .= $this->getHtmlCodeForResColor_Row($sizes, $assortments, $tipolo,
                    $order_row, $index, $dateType, $periods, $showInfo, $modal, $canGoToCart, $discount);
                $index++;
            }
        }

        return $html;
    }

    private function getHtmlCodeForResColor_Row($sizes, $assortments, $tipolo,
                                                $order_row, $index, $dateType, $periods, $showInfo, $modal, $canGoToCart, $discount)
    {
        $html = "<div class='insert-quantity-block'" . ($index > 1 && !isset($order_row) ? " style='display:none'" : '') . '>';

        $html .= $this->getHeaderResColorBlock($index, $order_row, $dateType, $periods, $showInfo, $sizes, $modal);
        $html .= $this->getHeaderTable(false, $modal);
        $html .= $this->getResColorContent($sizes, $assortments, $tipolo, $index, $order_row, $modal, $discount);
        $html .= $this->getFooterBlock($modal, $canGoToCart);
        if (!empty($periods) && count($periods) > 1) {
            $html .= $this->getAddRemoveButtons($index);
        }

        $html .= '</div>';

        return $html;
    }

    private function getHeaderResColorBlock($index, $order_row, $dateType, $periods, $showInfo, $sizes, $modal)
    {
        // Open row
        $html = "<div id='row-" . $index . "' class='row header-insert-block' ";
        $html .= "data-nurorc='" . (isset($order_row) ? $order_row->nurorc : '-1') . "' ";
        $html .= "data-cdvari='' ";
        $html .= "data-dtmcli='" . ($showInfo['showDelivery'] && isset($order_row) ? date("Y-m-d", strtotime(str_replace("/", "-", $order_row->dtmcli))) : '') . "' ";
        $html .= "data-indorc='" . ($showInfo['showIndicative'] && isset($order_row) ? htmlentities($order_row->indorc) : '') . "' ";
        $html .= "data-dsnoco='" . ($showInfo['showNotes'] && isset($order_row) ? htmlentities($order_row->dsnoco) : '') . "' ";
        $html .= "data-sgrifc='" . ($showInfo['showReference'] && isset($order_row) ? htmlentities($order_row->sgrifc) : '') . "'>";


        if ($showInfo['showDelivery']) {
            // Index
            $html .= "<div class='col-1'>" . $index . ".</div>";

            // Delivery Date
            $html .= "<div class='truncate " . ($modal ? "col-2" : "col-7") . "' ";
            $html .= $modal ? "style='text-align:right'>" : "><div class='float-left'>";
            $html .= $this->translate('cart.deliverydate') . ": ";
            $html .= "</div>";
            if ($modal) {
                $html .= "<div class='col-8'>";
            }
            if ($showInfo['showDelivery'] == 1) {
                $html .= "<div class='float-left ml-5x' style='color:black'>";
                $html .= "<input type='text' data-index='" . $index . "' class='dtmcli' ";
                $html .= " value='" . (isset($order_row) && $order_row->dtmcli != '0000-00-00' ? $order_row->dtmcli : '') . "'>";
                $html .= "</div>";
            } else if ($showInfo['showDelivery'] == 4) {
                $html .= "<div style='color:black'>";
                $html .= "<select class='form-control dtmcli mb-0' data-index='" . $index . "'>";
                $first = true;
                foreach ($periods as $scmcon) {
                    $html .= "<option value='" . $scmcon->dtmcli . "'";
                    if ($first) {
                        $html .= " selected";
                    }
                    $html .= ">" . htmlentities($scmcon->dsscad) . "</option>";
                }
                $html .= "</select>";
                $html .= "</div>";

            } else {

                $html .= "<div style='color:black'>";
                $html .= "<select class='form-control dtmcli mb-0' data-index='" . $index . "'>";
                $first = true;
                foreach ($periods as $scmcon) {
                    if ($first && ($showInfo['showDelivery'] == '2')) {
                        $html .= "<option value='0000-00-00'></option>";
                        $first = false;
                    }
                    $html .= "<option value='" . $scmcon->dtmcli . "'";
                    if ((isset($order_row) && $order_row->dtmcli == $scmcon->dtmcli) || $first) {
                        $html .= " selected";
                    }
                    $html .= ">" . htmlentities($scmcon->dsscad) . "</option>";
                }
                $html .= "</select>";
                $html .= "</div>";
            }

            $html .= "</div>";
        }

        // Info - you can see it if you can select date (tppers != PT and reservation order) or indicative or rif or note
        if (!$modal) {
            if ($showInfo['showIndicative'] || $showInfo['showNotes'] || $showInfo['showReference']) {
                $html .= "<div class='col-" . ($showInfo['showDelivery'] ? '4' : '12 text-left') . " info-order-row' data-toggle='modal' data-target='.modal-info-row'>";
                $html .= $this->translate('_common.info');
                $html .= "</div>";
            }
        } else {
            $html .= $this->getInfoHeaderRow($showInfo['showNotes'], $order_row);
        }

        // Close row
        $html .= "</div>";

        // Public price, if needed
        if ($this->utility->getAppSettings('ParamPriceSellPublicVisible')) {
            $html .= $this->addPublicPrice($sizes);
        }

        return $html;
    }

    private function getAddRemoveButtons($index)
    {
        $html = '';

        $html .= "<div class='row'>";

        if ($index < 3) {
            $html .= "<div class='col btn-add-delete' id='btn-add-" . $index . "'>";
            $html .= $this->translate('quantity.adddeliverydate');
            $html .= "</div>";
        } else {
            $html .= "<div class='col'>&nbsp;</div>";
        }

        if ($index > 1) {
            $html .= "<div class='col btn-add-delete text-right' id='btn-delete-" . $index . "'>";
            $html .= $this->translate('quantity.deletedeliverydate');
            $html .= "</div>";
        } else {
            $html .= "<div class='col'>&nbsp;</div>";
        }

        $html .= "</div>";

        return $html;
    }
    //endregion

    //region Html for insert quantity (common functions)
    private function getHtmlCodeForModal($cdarti, $cdcolo, $cdtagl, $tppers, $idlang = 'IT')
    {
        $html = "";

        $imageType = $this->utility->getAppSettings('ImageOnCatalogModal');

        if ($tppers != 'PT') {
            $anaart = Anaart::getArticleFromCdarti($cdarti, $idlang);
        } else {
            $anaart = Anaart::getArticleFromCdartiAndCdcolo($cdarti, $cdcolo, $idlang);
            $imgurl_artv = $this->utility->getImageModelLink($anaart->flimag_artv);
            $exist = $anaart->flimag_artv != '' && file_exists("img/model/" . $anaart->flimag_artv);
            if (!$exist) {
                $imgurl_artv = $this->config->application->baseUri . 'assets/img/default_model.jpg';
            }
        }


        $imgurl_artn = $this->utility->getImageModelLink($anaart->flimag_artn);
        $exist = $anaart->flimag_artn != '' && file_exists("img/model/" . $anaart->flimag_artn);
        if (!$exist) {
            $imgurl_artn = $this->config->application->baseUri . 'assets/img/default_model.jpg';
        }

        $imgurl_arti = $this->utility->getImageModelLink($anaart->flimag_arti);
        $exist = $anaart->flimag_arti != '' && file_exists("img/model/" . $anaart->flimag_arti);
        if (!$exist) {
            $imgurl_arti = $this->config->application->baseUri . 'assets/img/default_model.jpg';
        }

        // Open row
        $html .=
            "<div class='row header-modal-list' data-cdarti='$cdarti' data-cdcolo='$cdcolo'>";

        // Image
        if ($imageType == 0) {
            $html .=
                "<div class='col-4 col-md-3 modal-big-img'>
          <img src='" . $imgurl_artn . "' title='" . htmlentities($anaart->dsartn, ENT_COMPAT, 'UTF-8') . "'/>
        </div>
        <div class='d-block d-md-none col-2 little-space-img modal-small-img'>
          <img src='" . $imgurl_arti . "' title='" . htmlentities($anaart->dsarti, ENT_COMPAT, 'UTF-8') . "'/>
        </div>";
        } else {
            $html .=
                "<div class='col-4 col-md-3 modal-big-img'>
          <img src='" . $imgurl_arti . "' title='" . htmlentities($anaart->dsarti, ENT_COMPAT, 'UTF-8') . "'/>
        </div>";
        }

        if ($tppers == 'PT') {
            $html .=
                "<div class='d-block d-md-none col-2 little-space-img modal-small-img'>
          <img src='" . $imgurl_artv . "' title='" . $cdcolo . "'/>
        </div>";
        }

        // Description
        $html .=
            "<div class='col-12 col-md-9 mobile-top-space'>
          <div class='row'>";

        // Model / Article
        $html .= "<div class='col-4 col-md-2 text-right mb-10x'>";
        $html .= $tppers == 'PT' ? $this->translate('_common.article') : $this->translate('_common.model');
        $html .= ":</div>";
        $html .= "<div class='col-8 col-md-10 mb-10x' style='color:black'>";
        $html .= $tppers == 'PT'
            ? $cdarti . " - " . htmlentities($anaart->dsarti, ENT_COMPAT, 'UTF-8')
            : $anaart->cdartn . " - " . htmlentities($anaart->dsartn, ENT_COMPAT, 'UTF-8');
        $html .= "</div>";

        // Tissue / Article
        $html .= "<div class='col-4 col-md-2 text-right mb-10x'>";
        $html .= $tppers == 'PT' ? $this->translate('_common.tissue') : $this->translate('_common.article');
        $html .= ":</div>";
        $html .= "<div class='col-8 col-md-10 mb-10x' style='color:black'>";
        $html .= $tppers == 'PT' ? $anaart->cdpers : $cdarti . " - " . htmlentities($anaart->dsarti, ENT_COMPAT, 'UTF-8');
        $html .= "</div>";

        // Color
        if ($tppers == 'PT') {
            $html .= "<div class='col-4 col-md-2 text-right mb-10x'>" . $this->translate('_common.color') . ":</div>";
            $html .= "<div class='col-8 col-md-10 mb-10x' style='color:black'>" . $cdcolo . "</div>";
        }

        if ($imageType == 0) {
            $html .=
                "<div class='d-none d-md-block col-2'>
          <img src='" . $imgurl_arti . "' title='" . htmlentities($anaart->dsarti, ENT_COMPAT, 'UTF-8') . "'/>
        </div>";
        }

        if ($tppers == 'PT') {
            $html .=
                "<div class='d-none d-md-block col-2'>
          <img src='" . $imgurl_artv . "' title='" . $cdcolo . "'/>
        </div>";
        }

        $html .= "</div>";
        $html .= "</div>";

        // Close row
        $html .= "</div>";

        return $html;
    }

    private function getHtmlCodeForConfiguratorModal($cdarti, $cdartn, $cdcolo, $cdtagl, $components, $idlang = 'IT')
    {
        $html = "";

        if ($cdcolo != 'CUSTOM') {
            $anaart = Anaart::getArticleFromCdarti($cdarti, $idlang);

            $imgurl_artn = $this->utility->getImageModelLink($anaart->flimag_artn);
            $exist = $anaart->flimag_artn != '' && file_exists("img/model/" . $anaart->flimag_artn);
            if (!$exist) {
                $imgurl_artn = $this->config->application->baseUri . 'assets/img/default_model.jpg';
            }

            $imgurl_arti = $this->utility->getImageModelLink($anaart->flimag_arti);
            $exist = $anaart->flimag_arti != '' && file_exists("img/model/" . $anaart->flimag_arti);
            if (!$exist) {
                $imgurl_arti = $this->config->application->baseUri . 'assets/img/default_model.jpg';
            }
            $dsartn = $anaart->dsartn;
        } else {
            $ocpert = Ocpert::findFirstByNupers($cdarti);
            $cdartn = $ocpert->cdartn;
            $tipolo = Tipolo::findFirstByCdartn($ocpert->cdartn);
            $dsartn = $tipolo->dsartn;

            $imgurl_artn = $this->utility->getImageModelLink($tipolo->flimag);
            $exist = $tipolo->flimag != '' && file_exists("img/model/" . $tipolo->flimag);
            if (!$exist) {
                $imgurl_artn = $this->config->application->baseUri . 'assets/img/default_model.jpg';
            }
        }

        // Open row
        $html .=
            "<div class='row header-modal-list' data-cdarti='$cdarti' data-cdcolo='$cdcolo'>";

        // Image
        $html .=
            "<div class='col-4 col-md-3 modal-big-img'>
          <img src='" . $imgurl_artn . "' title='" . htmlentities($dsartn, ENT_COMPAT, 'UTF-8') . "'/>
        </div>";

        if ($cdcolo != 'CUSTOM') {
            $html .=
                "<div class='d-block d-md-none col-2 little-space-img modal-small-img'>
          <img src='" . $imgurl_arti . "' title='" . htmlentities($anaart->dsarti, ENT_COMPAT, 'UTF-8') . "'/>
        </div>";
        }

        // Description
        $html .=
            "<div class='col-12 col-md-9 mobile-top-space'>
          <div class='row'>";

        // Article
        $dsarti = $cdcolo == 'CUSTOM' ? $cdartn . '-C' . $cdarti : $cdarti;
        $html .= "<div class='col-12 mb-10x' style='color:black'>" . $dsarti . "</div>";

        // Components
        $description = '';
        foreach ($components as $component) {
            $description .= $component->cdmate . (substr($component->tpcomp, 0, 2) == '10' ? ' - ' . $component->dsmate : '') . ' / ';
        }
        $description = substr($description, 0, -3);
        $html .= "<div class='col-12 mb-10x'>" . $description . "</div>";

        if ($cdcolo != 'CUSTOM') {
            $html .=
                "<div class='d-none d-md-block col-2'>
          <img src='" . $this->config->application->baseUri . $imgurl_arti . "' title='" . htmlentities($anaart->dsarti, ENT_COMPAT, 'UTF-8') . "'/>
        </div>";
        }

        $html .= "</div>";
        $html .= "</div>";

        // Close row
        $html .= "</div>";

        return $html;
    }

    private function getInfoHeaderRow($showNotes, $order_row)
    {
        $html = '';

        if ($showNotes) {
            $html .= "<div class='col-12'>" . $this->translate('_common.notes') . "</div>";
            $html .= "<div class='col-12 form-element mb-0'>";
            $html .= "<textarea rows='2' class='form-control dsnoco-info'>";
            if (isset($order_row)) {
                $html .= htmlentities($order_row->dsnoco);
            }
            $html .= "</textarea>";
            $html .= "</div>";
        }

        return $html;
    }

    private function getHeaderTable($isAvailability, $modal)
    {
        $hideAvailability = $this->utility->getAppSettings('HideAvailabilityOnAvailabilityOrder') == 1;

        // Open row
        $class = $modal ? 'mx-0' : '';
        $html = "<div class='row header-insert-table $class'>";

        // Size
        $html .= "<div class='col'>" . $this->translate('_common.sizes.qty') . "</div>";

        // Availability, if needed
        if ($isAvailability && !$hideAvailability) {
            $html .= "<div class='col'>" . $this->translate('_common.availability.short') . "</div>";
        }

        // Price
        if ($this->utility->getAppSettings('ModelDetailStyle') != 3) {
            $html .= "<div class='col'>" . $this->translate('_common.price') . "</div>";
        }

        // Quantity
        $html .= "<div class='col-4'>" . $this->translate('_common.quantity') . "</div>";

        // Close row
        $html .= "</div>";

        return $html;
    }

    private function getInsertQuantityRow($size_info, $availability, $variant, $index, $quanti, $modal, $discount, $is_size = true, $blocked = false)
    {
        // Open Row
        $class = '';
        $title = '';
        $inp_cls = '';
        $isAvailability = $availability >= 0;
        if ($is_size && $size_info->flprom == 1) {
            $class = " row-flprom";
            $title = " title='" . $this->translate('quantity.promo') . "'";
        }
        if ($isAvailability && $quanti > $availability) {
            $inp_cls .= $class . " over-max";
        }

        $hideBlockedItems = $this->utility->getAppSettings('HideBlockedItems') == 1;
        $infoPackMode = intval($this->utility->getAppSettings('InfoPackMode') ?: 0);
        if ($hideBlockedItems && (($isAvailability && $availability == 0) || ($is_size && ($size_info->flbloc > 0 || $blocked)))) {
            return '';
        }

        // Get price
        $withDiscount = false;
        if ($is_size) {
            $size_info->sconto = 0;
            $locale = (isset($_COOKIE['locale'])) ? $_COOKIE['locale'] : $_SERVER['HTTP_ACCEPT_LANGUAGE'];
            setlocale(LC_ALL, $locale);
            if ($variant != '' && is_numeric($size_info->prezzo)) {
                $size_info->prezzo = $size_info->prezzo + $variant['preagg'];
            }

            if (is_numeric($size_info->prezzo)) {
                $cdvalu_esc = substr($size_info->cdvalu, 0, 3);
                $currency = $this->utility->getCurrencySymbol($cdvalu_esc);

                if ($size_info->prezzo == 0) {
                    $price = '-';
                } else {
                    $cust_disc = $discount != null && isset($discount['sconto']) && $discount['sconto'] > 0 ? $discount['sconto'] : 0;
                    $disc_price = $size_info->prezzo * (1 - $cust_disc / 100);
                    $withDiscount = $disc_price != $size_info->prezzo;
                    $real_price = $this->utility->getFormattedPriceCurrencyPresent($size_info->prezzo, $currency, $cdvalu_esc)['value'];
                    $price = $this->utility->getFormattedPriceCurrencyPresent($disc_price, $currency, $cdvalu_esc)['value'];
                    $size_info->sconto = $cust_disc;
                }
            } else {
                $price = $size_info->prezzo;
            }
        }

        $html = "<div class='row insert-quantity-row ";

//    var_dump($size_info, (new \Exception())->getTraceAsString());
//    exit();

    if ($is_size) {
        $html .= "is-size' ";
        $html .= "data-qtamin='" . $size_info->qtamin . "' ";
        $html .= "data-qtamul='" . $size_info->qtamul . "' ";
        $html .= "data-qtamax='" . (isset($size_info->qtamax) && $size_info->qtamax > 0 ? $size_info->qtamax : 0) . "' ";
        $html .= "data-flbloc='" . $size_info->flbloc . "' ";
        $html .= "data-flprom='" . $size_info->flprom . "' ";
        $html .= "data-taglia='" . $size_info->taglia . "' ";
        $html .= "data-prezzo='" . $size_info->prezzo . "' ";
        $html .= "data-sconto='" . $size_info->sconto . "' ";
    } else {
        $html .= "is-asso' ";
        $html .= "data-qtamin='1' ";
        $html .= "data-qtamul='1' ";
        $html .= "data-qtamax='0' ";
        $html .= "data-flbloc='0' ";
        $html .= "data-flprom='0' ";
        $html .= "data-cdasso='" . $size_info->cdasso . "' ";
        $html .= "data-qtasso='" . $size_info->quanti . "' ";
        $html .= "data-prezzo='0' ";
        $html .= "data-sconto='0' ";
    }

        $html .= "data-disp='" . ($isAvailability ? $availability : "-1") . "' ";
        $html .= $modal ? "style='margin-left:0;margin-right:0'" : "";
        $html .= ">";

        // Size
        $html .= "<div class='col" . $class . "'" . $title . ">" . ($is_size ? $size_info->taglia : $size_info->cdasso);

        if ($is_size && $this->utility->getAppSettings('ShowMinMulOnModelDetail') == 1) {
            $html .= '<span style="font-size:10px;padding-left:10px">(';
            $html .= $this->translate('_common.qty.min.short') . ': ' . $size_info->qtamin . ', ';
            $html .= $this->translate('_common.qty.mul.short') . ': ' . $size_info->qtamul;
            if (isset($size_info->qtamax) && $size_info->qtamax > 0) {
                $html .= ', ' . $this->translate('_common.qty.max.short') . ': ' . $size_info->qtamax;
            }
            $html .= ')</span>';
        }

        if (!$is_size && $infoPackMode >= 0) {
            $tooltip = "";
            foreach ($size_info->detail as $key => $value) {
                if ($value > 0) {
                    $tooltip .= " " . $value . " x " . $key . " /";
                }
            }
            $tooltip = substr($tooltip, 0, -1);
            if ($infoPackMode == 1 || !empty($tooltip)) {
                $html .= " <i class='fa fa-info-circle' aria-hidden='true' data-toggle='tooltip' data-placement='top' title='"
                    . $tooltip . "' data-test></i>";
            }
        }

        $html .= "</div>";

        // Availability
        $hideAvailability = $this->utility->getAppSettings('HideAvailabilityOnAvailabilityOrder') == 1;
        if ($isAvailability && !$hideAvailability) {
            $availability_flag_html = $availability > 0 ? $availability : "&nbsp;";
            if ($this->utility->getAppSettings('ShowAvailabilityFlag') == 2 &&
                !is_null($this->utility->getAppUtils('availabilityYellowLimit')) &&
                !is_null($this->utility->getAppUtils('availabilityGreenLimit'))) {
                $avaColor = '';
                if (!is_null($availability)) {
                    if ($availability < $this->utility->getAppUtils('availabilityYellowLimit')) {
                        $avaTooltip = $this->translate('_common.notavailable');
                        $avaColor = '#ff3c1a';  // rosso
                    } else if ($availability < $this->utility->getAppUtils('availabilityGreenLimit')) {
                        $avaTooltip = $this->translate('_common.fewavailable');
                        $avaColor = 'gold';     // giallo
                    } else {
                        $avaTooltip = $this->translate('_common.available');
                        $avaColor = '#32cd32';  // verde
                    }
                }
                $availability_flag_html = "<i class='fa fa-circle' style='color:$avaColor' title='$avaTooltip' data-toggle='tooltip' aria-hidden='true'></i>";
            }
            $html .= "<div class='col'>" . $availability_flag_html . "</div>";
        }

        // Price
        if ($this->utility->getAppSettings('ModelDetailStyle') != 3) {
            if ($is_size) {
                $html .= "<div class='col'>" . ($withDiscount
                        ? "<div class='price-model-box-discounted'><span class='discounted'>" . $real_price . "</span> " . $price . "</div>"
                        : "<div class='price-model-box'>" . $price . "</div>") .
                    "</div>";
            } else {
                $html .= "<div class='col'>&nbsp;</div>";
            }
        }

        // Quantity
        $html .= "<div class='col-4'>";

        if ($isAvailability && $availability == 0) {
            $html .= "<span class='blocked'>" . $this->translate('_common.notavailable') . "</span>";
        } else if ($is_size && ($size_info->flbloc > 0 || $blocked)) {
            $html .= "<span class='blocked'>" . $this->translate('quantity.blocked') . "</span>";
        } else {
            if ($quanti > 0) {
                $minus_cls = 'enabled';
            } else {
                $minus_cls = 'disabled';
            }

            if (!$isAvailability ||
                ($quanti < $availability &&
                    (!$is_size || ($size_info->qtamin <= $availability && $quanti + $size_info->qtamul <= $availability))
                )
            ) {
                $plus_cls = 'enabled';
            } else {
                $plus_cls = 'disabled';
            }

            $html .= "<div class='btn-number minus-qty $minus_cls ' data-type='minus'>";
            $html .= "<i class='fa fa-minus' aria-hidden='true'></i>";
            $html .= "</div>";
            $html .= "<div class='float-left w-40'>";
            $html .= "<input type='text' class='input-number $inp_cls ' ";
            if ($minus_cls == 'disabled' && $plus_cls == 'disabled') {
                $html .= 'disabled ';
            }
            $html .= "data-old_value='" . ($quanti > 0 ? $quanti : "") . "' data-issize='true'";
            $html .= "value='" . ($quanti > 0 ? $quanti : '') . "' min='0' " . ($isAvailability ? "max='" . $availability . "'" : '') . ">";
            $html .= "</div>";
            $html .= "<div class='btn-number plus-qty $plus_cls ' data-type='plus'>";
            $html .= "<i class='fa fa-plus' aria-hidden='true'></i>";
            $html .= "</div>";

            if ($this->utility->getAppSettings('EnableMinMulLabel') > 0) {
                $html .= "<div class='regqta-info'>";
                $html .= $this->translate('_common.qty.min.short') . ': ' . $size_info->qtamin . ', ';
                $html .= $this->translate('_common.qty.mul.short') . ': ' . $size_info->qtamul;
                if (isset($size_info->qtamax) && $size_info->qtamax > 0) {
                    $html .= ', ' . $this->translate('_common.qty.max.short') . ': ' . $size_info->qtamax;
                }
                $html .= "</div>";
            }
        }

        $html .= "</div>";

        // Close row
        $html .= "</div>";

        return $html;
    }

    private function getFooterBlock($modal, $canGoToCart)
    {
        $html =
            "<div class='row footer-insert-block " . ($modal ? 'mx-0' : '') . "'>
      <div class='col-12 p-0'>
        <a class='btn btn-main add-to-cart w-100' " . ($modal ? 'id="add-to-cart-modal"' : '') . ">" . $this->translate('_common.addtocart') . "</a>
      </div>
    </div>
    <div class='row success-box' style='display:none'>
      <div class='col-12'>";
        if ($canGoToCart) {
            $param = "<a href='" . $this->url->get("cart/index") . "' style='color:#606060'>" . $this->translate('_common.cart') . "</a>";
            $html .= "<span>" . $this->translate('quantity.insert.success', ["cart" => $param]) . "</span>";
        } else {
            $html .= "<span>" . $this->translate('quantity.insert.success.nocart') . "</span>";
        }
        $html .=
            "</div>
    </div>";

        $html .=
            "<div class='row unsuccess-box' style='display:none'>
      <div class='col-12'><span>" . $this->translate('quantity.insert.unsuccess') . "</span></div>
    </div>";

        return $html;
    }

    private function getFooterModalNotifyAvailability($cdartn, $tppers)
    {
        $anaart = Anaart::findByCdartn($cdartn);
        $artcol = array();
        $artvar = array();

        if ($tppers == 'PT') {
            $where = '';
            foreach ($anaart as $article) {
                $where .= '"' . $article->cdarti . '",';
            }
            $where = substr($where, 0, -1);

            $artcol = Artcol::find(array('cdarti IN (' . $where . ')'));

            if ($this->utility->getAppSettings('ParamVariation') == 1) {
                $artvar = Artvar::find(array('cdarti IN (' . $where . ')'));
            }
        }

        $html = '<div id="notify_products">' .
            $this->translate('model.notifyproducts',
                array('tag' => '<a href="#" style="color:#606060" id="open-modal-notify-product"
                                          data-cdartn="' . $cdartn . '" data-tppers="' . $tppers . '">')) .
            '</div>';

        $header = $this->getHtmlModalNotifyAvailability($anaart, $artcol, $artvar);

        $html .=
            '<div id="currentdesiderata" style="display:none">
        <div class="modal-body">
          <div class="modal-section" id="modal-notify-header">' . $header . '</div>
          <div class="modal-section" id="modal-notify-body">
          </div>
        </div>
        <div class="modal-footer">
          <div class="container">
            <div class="row">
              <div class="col-6 col-lg-4 text-left">
                <a href="#" style="color:#606060" class="font-weight-bold text-capitalize" id="back-notify-me">' . $this->translate('_common.back') . '</a>
              </div>
              <div class="col-6 col-lg-4 offset-lg-4 text-right">
                <a href="#" style="color:#606060" class="font-weight-bold" id="notify-me">' . $this->translate('model.notifyme') . '</a>
              </div>
              <div class="col-12 msg-success text-right" id="notify-success">' . $this->translate('model.notify.success') . '</div>
              <div class="col-12 msg-error text-right" id="notify-error">' . $this->translate('model.notify.error') . '</div>
            </div>
          </div>
        </div>
      </div>';

        return $html;
    }

    private function addPublicPrice($sizes)
    {
        $html = '';
        $isPublicPricePresent = false;
        $isPublicPricePerSize = false;
        $currPublicPrice = count($sizes) > 0 ? $sizes[0]->preven : 0;
        $tooltip = '';
        $currency = $this->utility->getCurrencySymbol($sizes[0]->cdvalu);
        foreach ($sizes as $size) {
            $preven = $this->utility->getFormattedPriceCurrencyPresent($size->preven, $currency, $sizes[0]->cdvalu)['value'];
            $tooltip .= '<li>' . $size->taglia . ': ' . $preven . '</li>';
            if ($size->preven > 0 || $size->preven != $currPublicPrice) {
                $isPublicPricePresent = true;
            }
        }

        if ($isPublicPricePresent) {
            $html .= "<div class='row pt-10x'><div class='col-6 public-price' ";

            if (!$isPublicPricePerSize) {
                $html .= ">";
                $html .= '<i class="fa fa-info-circle" style="cursor:pointer" data-toggle="tooltip" ';
                $html .= 'title="' . $this->translate('_common.price.public') . ': ';
                $html .= $this->utility->getFormattedPriceCurrencyPresent($currPublicPrice, $currency, $sizes[0]->cdvalu)['value'];
                $html .= '">';
                $html .= '</i>';
            } else {
                $html .= 'data-toggle="tooltip" data-placement="left" data-html="true" title="<ul>' . $tooltip . '</ul>">';
                $html .= $this->translate('_common.price.public') . ': ';
                $html .= $this->translate('quantity.priceforsize.short');
            }

            $html .= "</div></div>";
        }

        return $html;
    }
    //endregion

    //region Html for insert quantity (no PT, common functions)
    private function getAvaColorContent($sizes, $assortments, $tipolo, $ava, $index, $order_row, $modal, $discount, $fromCompactModel = false)
    {
        $html = '';
        for ($i = 0; $i < count($sizes); $i++) {
            $quanti = 0;
            if (isset($sizes[$i], $order_row->detail[$sizes[$i]->taglia]) && $order_row->detail[$sizes[$i]->taglia]) {
                $quanti = $order_row->detail[$sizes[$i]->taglia];
            }

            if ($fromCompactModel) {
                $html .= '<div class="col-12 px-40x">';
            }

            $blocked = (($i + 1) < $tipolo->tglini && $tipolo->tglini != 0) || (($i + 1) > $tipolo->tglfin && $tipolo->tglfin != 0);
            $html .= $this->getInsertQuantityRow($sizes[$i],
                isset($ava['alldsp']['size'][$sizes[$i]->taglia]) && $ava['alldsp']['size'][$sizes[$i]->taglia] > 0 ? $ava['alldsp']['size'][$sizes[$i]->taglia] : 0, "",
                $index . '_' . $i, $quanti, $modal, $discount, true, $blocked);
            if ($fromCompactModel) {
                $html .= '</div>';
            }
        }

        $showAssortements = $this->utility->getAppSettings('showAssortments');

        if ($showAssortements == '1') {
            for ($i = 0; $i < count($assortments); $i++) {
                $quanti = 0;
                if (isset($order_row) && $order_row->assortments[$assortments[$i]->cdasso]) {
                    $quanti = $order_row->assortments[$assortments[$i]->cdasso];
                }

                if ($fromCompactModel) {
                    $html .= '<div class="col-12 px-40x">';
                }
                $html .= $this->getInsertQuantityRow($assortments[$i],
                    isset($ava['alldsp']['asso'][$assortments[$i]->cdasso]) ? $ava['alldsp']['asso'][$assortments[$i]->cdasso] : 0, "",
                    $index . '_' . $i, $quanti, $modal, $discount, false);
                if ($fromCompactModel) {
                    $html .= '</div>';
                }
            }
        }

        return $html;
    }

    private function getResColorContent($sizes, $assortments, $tipolo, $index, $order_row, $modal, $discount, $fromCompactModel = false)
    {
        $html = '';

        for ($i = 0; $i < count($sizes); $i++) {
            $quanti = 0;
            if (isset($order_row->detail[$sizes[$i]->taglia])) {
                $quanti = $order_row->detail[$sizes[$i]->taglia];
            }

            if ($fromCompactModel) {
                $html .= '<div class="col-12 px-40x">';
            }

            $blocked = (($i + 1) < $tipolo->tglini && $tipolo->tglini != 0) || (($i + 1) > $tipolo->tglfin && $tipolo->tglfin != 0);
            $html .= $this->getInsertQuantityRow($sizes[$i], -1, '', $index . '_' . $i, $quanti, $modal, $discount, true, $blocked);
            if ($fromCompactModel) {
                $html .= '</div>';
            }
        }

        $showAssortements = $this->utility->getAppSettings('showAssortments');

        if ($showAssortements == '1') {
            for ($i = 0; $i < count($assortments); $i++) {
                $quanti = 0;
                if (isset($order_row->assortments[$assortments[$i]->cdasso])) {
                    $quanti = $order_row->assortments[$assortments[$i]->cdasso];
                }

                if ($fromCompactModel) {
                    $html .= '<div class="col-12 px-40x">';
                }
                $html .= $this->getInsertQuantityRow($assortments[$i], -1, '', $index . '_' . $i, $quanti, $modal, $discount, false);
                if ($fromCompactModel) {
                    $html .= '</div>';
                }
            }
        }
        return $html;
    }

    private function getColorSizeContent($sizes, $assortments, $order_row, $tipolo, $canGoToCart,
                                         $discount, $ava, $showInfo, $dateOffset, $isAvailability, $cdarti, $cdcolo)
    {
        $html = "<div class='row model-color-sizes'
      data-cdarti='$cdarti' data-cdcolo='$cdcolo' data-action='$canGoToCart'
      data-nurorc='" . (isset($order_row) ? $order_row->nurorc : '-1') . "' " .
            ($isAvailability
                ? "data-dtmcli='" . date("Y-m-d", strtotime(str_replace("/", "-", $ava["dtdisp"]) . " +" . $dateOffset . " days")) . "' "
                : "data-dtmcli='" . ($showInfo['showDelivery'] && isset($order_row) ? date("Y-m-d", strtotime(str_replace("/", "-", $order_row->dtmcli))) : '') . "' ") .
            "data-indorc='" . ($showInfo['showIndicative'] && isset($order_row) ? htmlentities($order_row->indorc) : '') . "'
      data-dsnoco='" . ($showInfo['showNotes'] && isset($order_row) ? htmlentities($order_row->dsnoco) : '') . "'
      data-sgrifc='" . ($showInfo['showReference'] && isset($order_row) ? htmlentities($order_row->sgrifc) : '') . "'>";

        $selected = false;
        for ($i = 0; $i < count($sizes); $i++) {
            $quanti = 0;
            if (isset($order_row) && $order_row->detail[$sizes[$i]->taglia]) {
                $quanti = $order_row->detail[$sizes[$i]->taglia];
            }

            // Get price
            $sizes[$i]->sconto = 0;
            $locale = (isset($_COOKIE['locale'])) ? $_COOKIE['locale'] : $_SERVER['HTTP_ACCEPT_LANGUAGE'];
            setlocale(LC_ALL, $locale);

            $realprice = $sizes[$i]->prezzo;
            $discprice = $sizes[$i]->prezzo;
            if (is_numeric($sizes[$i]->prezzo)) {
                $currency = $this->utility->getCurrencySymbol($sizes[$i]->cdvalu);

                if ($sizes[$i]->prezzo == 0) {
                    $price = '-';
                } else {
                    $cust_disc = $discount != null && isset($discount['sconto']) && $discount['sconto'] > 0 ? $discount['sconto'] : 0;
                    $disc_price = $sizes[$i]->prezzo * (1 - $cust_disc / 100);
                    $realprice = $this->utility->getFormattedPriceCurrencyPresent($sizes[$i]->prezzo, $currency, $sizes[$i]->cdvalu)['value'];
                    $discprice = $this->utility->getFormattedPriceCurrencyPresent($disc_price, $currency, $sizes[$i]->cdvalu)['value'];
                    $sizes[$i]->sconto = $cust_disc;
                }
            } else {
                $realprice = $sizes[$i]->prezzo;
                $discprice = $sizes[$i]->prezzo;
            }

            // Check if size is blocked
            $blockedClass = '';
            $selectedClass = '';
            $tooltip = '';
            if ($isAvailability) {
                // For now, assume only one date
                $availability = isset($ava['alldsp']['size'][$sizes[$i]->taglia]) && $ava['alldsp']['size'][$sizes[$i]->taglia]
                    ? $ava['alldsp']['size'][$sizes[$i]->taglia]
                    : 0;
                if ($availability == 0) {
                    $blockedClass = "blocked-size";
                    $tooltip = $this->translate('_common.notavailable');
                } else if ($sizes[$i]->flbloc > 0) {
                    $blockedClass = "blocked-size";
                    $tooltip = $this->translate('quantity.blocked');
                }
            } else if ((($i + 1) < $tipolo->tglini && $tipolo->tglini != 0) || (($i + 1) > $tipolo->tglfin && $tipolo->tglfin != 0)) {
                $blockedClass = "blocked-size";
                $tooltip = $this->translate('quantity.blocked');
            }
            if (empty($blockedClass) && !$selected) {
                $selectedClass = 'selected';
                $selected = true;
            }

            $html .=
                "<div class='color-size $blockedClass $selectedClass  " .
                ($isAvailability && $quanti > $availability ? 'over-max' : '') . " " .
                ($sizes[$i]->flprom == 1 ? 'flprom-size' : '') . "'
          data-qtamin='" . $sizes[$i]->qtamin . "' data-qtamul='" . $sizes[$i]->qtamul . "'
          data-qtamax='" . (isset($sizes[$i]->qtamax) && $sizes[$i]->qtamax > 0 ? $sizes[$i]->qtamax : 0) . "'
          data-flbloc='" . $sizes[$i]->flbloc . "' data-flprom='" . $sizes[$i]->flprom . "'
          data-taglia='" . $sizes[$i]->taglia . "' data-prezzo='" . $sizes[$i]->prezzo . "'
          data-sconto='" . $sizes[$i]->sconto . "' data-issize='true'
          data-realprice='" . $realprice . "' data-discprice='" . $discprice . "'
          data-quanti='" . $quanti . "' data-availability='" . ($isAvailability ? $availability : '-1') . "' " .
                (!empty($tooltip) ? "data-toggle='tooltip' title='" . $tooltip . "'" : '') .
                (empty($tooltip) && $sizes[$i]->flprom == 1 ? "data-toggle='tooltip' title='" . $this->translate('quantity.promo') . "'" : '') . ">" .
                $sizes[$i]->taglia .
                "</div>";
        }
        for ($i = 0; $i < count($assortments); $i++) {
            $quanti = 0;
            if (isset($order_row) && $order_row->assortments[$assortments[$i]->cdasso]) {
                $quanti = $order_row->assortments[$assortments[$i]->cdasso];
            }

            // Tooltip for assortment detail
            $tooltip = "";
            foreach ($assortments[$i]->detail as $key => $value) {
                if ($value > 0) {
                    $tooltip .= " " . $value . " x " . $key . " /";
                }
            }
            $tooltip = substr($tooltip, 0, -1);

            // Check if size is blocked
            $avaClass = '';
            $avaTooltip = '';
            if ($isAvailability) {
                // For now, assume only one date
                $availability = isset($ava[0]['alldsp']['asso'][$assortments[$i]->cdasso])
                    ? $ava[0]['alldsp']['asso'][$assortments[$i]->cdasso]
                    : 0;
                if ($availability == 0) {
                    $avaClass = "blocked-size";
                    $avaTooltip = $this->translate('_common.notavailable');
                }
            }

            $html .=
                "<div class='color-size $avaClass " . ($i == 0 && count($sizes) == 0 ? 'selected' : '') . " " .
                ($isAvailability && $quanti > $availability ? 'over-max' : '') . "'
          data-qtamin='1'  data-qtamul='1' data-qtamax='0' data-flbloc='0'  data-flprom='0'
          data-cdasso='" . $assortments[$i]->cdasso . "' data-qtasso='" . $assortments[$i]->quanti . "'
          data-prezzo='0' data-sconto='0' data-realprice='-' data-discprice='-' data-issize='false'
          data-quanti='" . $quanti . "' data-availability='" . ($isAvailability ? $availability : '-1') . "'
          data-toggle='tooltip' title='" . ($avaTooltip != '' ? $avaTooltip : $tooltip) . "'>" .
                $assortments[$i]->cdasso .
                "</div>";
        }
        $html .= "</div>";

        return $html;
    }

    private function getColorModalContent($sizes, $assortments, $order_row, $tipolo, $canGoToCart,
                                          $discount, $ava, $showInfo, $dateOffset, $isAvailability)
    {

        $hideAvailability = $this->utility->getAppSettings('HideAvailabilityOnAvailabilityOrder') == 1;

        $html = ($showInfo['showNotes']
                ? '<div class="col-12 px-40x">
          <div class="form-element">
            <textarea rows="2" id="dsnoco-info" class="form-control" placeholder="' . $this->translate('model.fastbuy.notes') . '">' .
                (isset($order_row) ? htmlentities($order_row->indorc) : '') .
                '</textarea>
          </div>
        </div>'
                : '') .
            (count($sizes) > 0 || count($assortments) > 0
                ? '<div class="col-12 px-40x">
          <div class="row header-insert-table"
            data-nurorc="' . (isset($order_row) ? $order_row->nurorc : '-1') . '" ' .
                ($isAvailability
                    ? 'data-dtmcli="' . date("Y-m-d", strtotime(str_replace("/", "-", $ava["dtdisp"]) . " +" . $dateOffset . " days")) . '" '
                    : 'data-dtmcli="' . ($showInfo['showDelivery'] && isset($order_row) ? date("Y-m-d", strtotime(str_replace("/", "-", $order_row->dtmcli))) : '') . '" ') .
                'data-indorc="' . ($showInfo['showIndicative'] && isset($order_row) ? htmlentities($order_row->indorc) : '') . '"
          data-dsnoco="' . ($showInfo['showNotes'] && isset($order_row) ? htmlentities($order_row->dsnoco) : '') . '"
          data-sgrifc="' . ($showInfo['showReference'] && isset($order_row) ? htmlentities($order_row->sgrifc) : '') . '">
            <div class="col">' . $this->translate('_common.sizes.qty') . '</div>' .
                ($isAvailability && !$hideAvailability
                    ? '<div class="col">' . $this->translate('_common.availability.short') . '</div>'
                    : '') .
                '<div class="col">' . $this->translate('_common.price') . '</div>
            <div class="col-4">' . $this->translate('_common.quantity') . '</div>
          </div>
        </div>' .
                ($isAvailability
                    ? $this->getAvaColorContent($sizes, $assortments, $tipolo, $ava, 0, $order_row, false, $discount, true)
                    : $this->getResColorContent($sizes, $assortments, $tipolo, 0, $order_row, false, $discount, true))
                : '') .
            '<div class="col-12 px-40x footer-insert-block mt-0" style="background-color:white;border:0">
        <a href="#" class="btn btn-main add-to-cart w-100 m-0" id="add-to-cart-modal">' . $this->translate('_common.addtocart') . '</a>
      </div>
      <div class="col-12 success-box px-40x" style="display:none">
        <div class="col-12">' .
            ($canGoToCart
                ? '<span>' .
                $this->translate('quantity.insert.success',
                    ["cart" => "<a href='" . $this->url->get("cart/index") . "' style='color:#606060'>" . $this->translate('_common.cart') . "</a>"]) .
                '</span>'
                : '<span>' . $this->translate('quantity.insert.success.nocart') . '</span>') .
            '</div>
      </div>
      <div class="col-12 unsuccess-box px-40x" style="display:none">
        <div class="col-12"><span>' . $this->translate('quantity.insert.unsuccess') . '</span></div>
      </div>';

        return $html;
    }
    //endregion

    //region Html for insert quantity (no PT) from color
    private function getSizesFromColorHtml($cdarti, $cdcolo, $cdtagl, $tppers, &$html_sizes, &$html_modal)
    {
        // General info
        $auth = $this->session->get('auth');
        $order = Octest::getCurrentOrder($auth['id']);
        $idlang = $this->utility->getLanguage();
        $numdis = $this->utility->getCustomDiscount();

        // Sizes and assortments for current article/tissue + order rows
        $sizes = Postgl::getSizesWithPrices($cdtagl, $cdarti, $order->nulist);

        $anaart = Anaart::findFirstByCdarti($cdarti);
        $cdartn = $anaart != null ? $anaart->cdartn : '';
        $sizes = $this->utility->getRules($sizes, $cdartn, $cdarti, $cdcolo);
        $tipolo = Tipolo::findFirstByCdartn($cdartn);

        $discount = array();
        if ($numdis > 0) {
            $discount = B2bDisbdy::getCustomDiscountForCdarti($numdis, $cdarti);
        } else if ($order && $this->utility->getAppSettings('ShowBaseCustomerDiscount') == 1) {
            $customer = Anagra::findCustomerByKey($order->tpanag, $order->cdanag);
            if ($customer instanceof Anagra) {
                $discount = ['sconto' => $customer->scont1, 'priority' => 1];
            }
        }

        if ($this->utility->getAppSettings('CanDuplicateRows') == 0) {
            $order_rows = $this->utility->getOrderRows($cdarti, $cdcolo, $order->nuordc);
            // Only 1 row/date for cdarti, so take the first and only row
            $order_row = count($order_rows) > 0 ? $order_rows[0] : null;
        } else {
            $order_rows = array();
            $order_row = null;
        }

        $assortments = $this->getAssortmentsFromCdarti($cdarti);
        if ($tppers == 'PT') {
            $variants = $this->utility->getAppSettings('ParamVariation') == 1 ? Artvar::getAllVariationsForArticle($cdarti) : array();
        }

        // Availability, if needed
        if ($order->tpordc == 0) {
            if ($tppers != 'PT') {
                $ava_sizes = $this->utility->getArticleAvailability($cdarti);
            } else {
                $ava_sizes = $this->utility->getColorVariantArticleAvailability($cdarti, $cdcolo, $cdtagl);
            }
        }

        $dateTypeAvaOrder = $this->utility->getAppSettings('ParamDateManagementAvailability');
        $dateTypeResOrder = $this->utility->getAppSettings('ParamDateManagement');
        $dateOffset = $this->utility->getAppSettings('ParamAvailabilityDateManagement');
        $visible_delivery = $this->utility->getAppSettings('ParamQuantityDeliveryView');
        $visible_indicative = $this->utility->getAppSettings('ParamQuantityIndicativeView');
        $visible_notes = $this->utility->getAppSettings('ParamQuantityNotesView');
        $visible_reference = $this->utility->getAppSettings('ParamQuantityReferenceView');

        $canGoToCart = $order->dtmcli != null ||
            ($order->tpordc == 0 && ($dateTypeAvaOrder == 1 || $dateTypeAvaOrder == 3)) ||
            ($order->tpordc == 1 && ($dateTypeResOrder == 1 || $dateTypeResOrder == 3)) ||
            ($order->tpordc == 1 && $dateTypeResOrder == 4 && $order->dtmcoi != null && $order->dtmcof != null);

        $dateOffset = $order->tpordc == 0 && $dateTypeAvaOrder != 4 ? 0 : $dateOffset;

        $showInfo = array(
            'showDelivery' => $visible_delivery,
            'showIndicative' => $visible_indicative == 1,
            'showNotes' => $visible_notes == 1,
            'showReference' => $visible_reference == 1
        );

        $html_sizes = '';
        $html_modal = '';

        if ($tppers == 'PT') {
            // Not developed
            //$html_sizes = $this->getColorSizeContentForFabric($sizes, $order_row, $canGoToCart, $discount,
            //  isset($ava_sizes) ? $ava_sizes[0] : null, $showInfo, $dateOffset, $order->tpordc == 0, $cdarti, $cdcolo);
            if ($order->tpordc == 0) {
                $html_sizes .= $this->getHtmlCodeForAvaTissue($sizes, $tipolo, $order_rows,
                    isset($ava_sizes) ? $ava_sizes : null, $variants, $dateOffset, $showInfo, false, $canGoToCart, $discount);
            } else {
                $html_sizes .= $this->getHtmlCodeForResTissue($sizes, $assortments, $tipolo, $order_rows,
                    $variants, $order->dtmcli, $showInfo, false, $canGoToCart, $discount);
            }
        } else {
            $modelDetailStyle = $this->utility->getAppSettings('ModelDetailStyle');

            if ($modelDetailStyle == 1 || $modelDetailStyle == 8 || $modelDetailStyle == 9) {
                $html_sizes = $this->getColorSizeContent($sizes, $assortments, $order_row, $tipolo, $canGoToCart, $discount,
                    isset($ava_sizes) ? $ava_sizes[0] : null, $showInfo, $dateOffset, $order->tpordc == 0, $cdarti, $cdcolo);
                $html_modal = $this->getColorModalContent($sizes, $assortments, $order_row, $tipolo, $canGoToCart, $discount,
                    isset($ava_sizes) ? $ava_sizes[0] : null, $showInfo, $dateOffset, $order->tpordc == 0);
            } else {
                if ($order->tpordc == 0) {
//            var_dump($discount);
//            exit();
                    $html_sizes .= $this->getHtmlCodeForAvaColor($sizes, $tipolo, $order_rows, $ava_sizes, $assortments,
                        $dateOffset, $showInfo, false, $canGoToCart, $discount);
                    $html_modal .= $this->getHtmlCodeForAvaColor($sizes, $tipolo, $order_rows, $ava_sizes, $assortments,
                        $dateOffset, $showInfo, true, $canGoToCart, $discount);
                } else {
                    $catalogs = $this->utility->getAvailableCatalogs($auth['id']);
                    $selected_catalog = $this->utility->getSelectedCatalog(true, $order, $catalogs);
                    $exist = isset($selected_catalog->cdcata) && Cttest::findFirstByCdcata($selected_catalog->cdcata) != null;
                    $periods = $dateTypeAvaOrder < 3 || $dateTypeResOrder < 3 ? Scacon::getPeriodsForCatalog($exist ? $selected_catalog->cdcata : $order->cdcata) : '';

                    $html_sizes .= $this->getHtmlCodeForResColor($sizes, $assortments, $tipolo, $order_rows, $dateTypeResOrder,
                        $periods, $this->utility->getAppSettings('ParamQuantityMultipleDeliveryView') == 1,
                        $showInfo, false, $canGoToCart, $discount);
                    $html_modal .= $this->getHtmlCodeForResColor($sizes, $assortments, $tipolo, $order_rows, $dateTypeResOrder,
                        $periods, $this->utility->getAppSettings('ParamQuantityMultipleDeliveryView') == 1,
                        $showInfo, true, $canGoToCart, $discount);
                }
            }
        }
    }
    //endregion

    //region Html for insert quantity from color on catalog section
    private function getImageAndColorsHtml($model, $common)
    {
        $html = '<div class="col-6 product-gallery px-50x">';
        $modelDetailStyle = $this->utility->getAppSettings('ModelDetailStyle');

        if ($common['defaultImage'] == 0) {
            $html .=
                '<!-- Preview -->
      <ul class="product-gallery-preview model-gallery">
        <li class="current">' . $this->elements->getModelImgOrDefaultHtml($model->flimag, $model->dsartn) . '</li>';

            if (count($model->imgart) > 0) {
                foreach ($model->imgart as $imgart) {
                    $html .= '<li>' . $this->elements->getModelImgOrDefaultHtml($imgart->flimag, $model->dsartn) . '</li>';
                }
            }

            $html .= '</ul>';

            if (count($model->anaart) > 0) {
                $html .=
                    '<!-- Preview -->
          <ul class="product-gallery-preview article-gallery" style="display:none">
            <li class="current"><img src="" class="big_article_image m-0" alt=""/></li>
          </ul>';
            }
        } else {
            if (count($model->anaart) > 0) {
                $html .=
                    '<!-- Preview -->
          <ul class="product-gallery-preview article-gallery">
            <li class="current"><img src="" class="big_article_image m-0" alt=""/></li>
          </ul>';
            }
        }

        $html .= '</div>';

        if (count($model->anaart) > 0) {
            $isVisible = $modelDetailStyle == 8 ? 'style="display:none"' : '';
            $html .=
                "<div class='col-6' $isVisible id='fast-buy-articles-container'>
        <div class='row pt-20x px-15x'>";

            foreach ($model->anaart as $anaart) {
                if ($common['order_info']->tpordc == 1 || $anaart->is_available == 'true') {
                    $html .= '<div class="px-2 pb-20x model-color-picker-container">';

                    $background = "background-size: contain;background-image: url('../assets/img/nocolor.png')";

                    if ($anaart->col_rgbcd1 != '' || $anaart->col_rgbcd2 != '' || $anaart->col_rgbcd3 != '') {
                        $color1 = $anaart->col_rgbcd1 != '' ? $anaart->col_rgbcd1 : ($anaart->col_rgbcd2 != '' ? $anaart->col_rgbcd2 : $anaart->col_rgbcd3);
                        $color2 = $anaart->col_rgbcd2 != '' ? $anaart->col_rgbcd2 : $anaart->col_rgbcd3;
                        $color3 = $anaart->col_rgbcd3;

                        if ($color3 != '') {
                            $background = "background: linear-gradient(to right, #" . $color1 . ", #" . $color1 . " 33.33%, #" . $color2 . " 33.33%, #" . $color2 . " 66.66%, #" . $color3 . " 66.66%)";
                        } else if ($color2 != '') {
                            $background = "background: linear-gradient(to right, #" . $color1 . ", #" . $color1 . " 50%, #" . $color2 . " 50%)";
                        } else if ($color1 != '') {
                            $background = "background-color: #" . $color1;
                        }
                    } else if ($anaart->col_flimag != '') {
                        $background = "background-size: contain;background-image: url('../upload/colors/" . $anaart->col_flimag . "')";
                    } else if ($anaart->col_flmult == 1) {
                        $background = "background-size: contain;background-image: url('../assets/img/multicolor.png')";
                    }

                    $cust_disc = $model->cust_disc > 0 ? $model->cust_disc : 0;
                    $cust_disc = $anaart->cust_disc > 0 ? $anaart->cust_disc : $cust_disc;
                    $catalogPriceText = '';
                    $real_price = '';

                    $this->elements->getPrices($anaart->prezzo, $cust_disc, $common['currency'], $common['cdvalu'], $catalogPriceText, $real_price);

                    $html .=
                        '<div class="small-model-color-picker" style="' . $background . '"
              data-toggle="tooltip" title="' . $anaart->col_codice . '" data-id="' . $anaart->col_codice . '"
              data-cdarti="' . $anaart->cdarti . '" data-dsarti="' . $anaart->dsarti . '"
              data-cdcolo="' . $anaart->cdcolo . '" data-dscolo="' . $anaart->dscolo . '"
              data-cdtagl="' . $model->cdtagl . '" data-tppers="' . $model->tppers . '"
              data-realprice="' . $real_price . '" data-discprice="' . $catalogPriceText . '"
              data-flimag="' . $this->elements->getModelImageUrl($anaart->flimag) . '">&nbsp;</div>
            </div>';
                }
            }

            $html .= '
        </div>
        <div class="row">
          <div class="col-12 font-weight-bold color-selected"></div>
        </div>
      </div>';
        }

        return $html;
    }
    //endregion

    //region Html for footer models
    private function getFooterModelsHtml($products, $title, $isOrder, $currency, $cdvalu, $is_availability_order, $isModel, $border = false)
    {
        $html = '';

        $modelDetailStyle = $this->utility->getAppSettings('ModelDetailStyle');

        if (count($products) > 0) {
            if ($modelDetailStyle == 0) {
                $class = $this->elements->getHighlightClass();
            } else {
                $class = '';
                $border = false;
            }
            $html =
                '<div class="row model-look" ' . ($border ? 'style="border-top:10px solid #eee;padding-top:20px"' : '') . '>
          <span class="' . $class . ' p-0-15x">' . $title . '</span>
        </div>
        <div class="row mx-0 my-20x">';

            $showHoverFooter = $modelDetailStyle != 3;

            $prefix = $this->config->application->baseUri;

            for ($i = 0; $i < count($products); $i++) {
                $product = (object)$products[$i];
                $imgurl1 = $this->utility->getImageModelLink($product->flimag);
                $imgurl2 = $this->utility->getImageModelLink($product->flimg2);
                $exist1 = $product->flimag != '' && file_exists('img/model/' . $product->flimag);
                $exist2 = $product->flimg2 != '' && file_exists('img/model/' . $product->flimg2);
                $imgurl = !$exist1 ? $this->config->application->baseUri . 'assets/img/default_model.jpg' : $imgurl1;

                $isAvailable = isset($product->is_available) ? $product->is_available : true;

                if ($isModel) {
                    $code = $product->cdartn;
                    $description = $product->dsartn;
                } else {
                    $code = $product->cdarti;
                    $description = $product->dsarti;
                }

                if (!$this->utility->hasWizard($modelDetailStyle) || ($isOrder && $is_availability_order)) {
                    $detailUrl = $this->url->get('model/' . $code);
                } else {
                    $detailUrl = $this->url->get('model/wizard/' . $code);
                }

                $html .=
                    '<div class="col-6 col-md-4 col-lg-2 ' . ($i == 0 ? 'offset-lg-2' : '') .
                    ($i == count($products) - 1 ? ' d-block d-md-none d-lg-block' : '') . ' model-box mb-0" id="' . $code . '">
          <div class="shop-item">
            <div class="image-model-box shop-thumbnail">
              <a href="' . $detailUrl . '" class="shop-thumbnail">
                <img src="' . $imgurl . '" alt="' . htmlentities($description, ENT_COMPAT, 'UTF-8') . '" ' .
                    ($exist2 ? 'onmouseover="this.src=\'' . $imgurl2 . '\';" onmouseout="this.src=\'' . $imgurl . '\';" ' : '') . '/>
              </a>' .
                    ($showHoverFooter
                        ? '<div class="shop-item-tools">
                <div class="w-50 float-left text-right">
                  <a href="' . $detailUrl . '" class="d-none d-lg-block btn-product-sheet">
                    <span>' . $this->translate('_common.productsheet') . '</span>
                    <img src="' . $this->config->application->baseUri . 'assets/img/product-sheet.jpg" />
                  </a>
                </div>
              </div>'
                        : '') .
                    '</div>' .
                    ($isOrder ? '<div class="highlight-pt-rl ' . ($product->presence < 0 ? 'd-none' : '') . '">&nbsp;</div>' : '') .
                    '<div class="descr-model-box">' . $description . '</div>
            <div class="code-model-box ' . ($isOrder && $product->presence >= 0 ? 'highlight-txt' : '') . '">' . $code . '</div>' .
                    $this->elements->getPriceDivHtml($product->catalogPrice, $product->cust_disc, $currency, $cdvalu, 'center', $detailUrl, (isset($product->cdartn) ? $product->cdartn : null)) .
                    ($is_availability_order && !$isAvailable
                        ? '<div class="availability-model-box text-center">' . $this->translate('_common.notavailable') . '</div>'
                        : '') .
                    '</div>
        </div>';
            }

            $html .= '</div>';
        }

        return $html;
    }
    //endregion

    //region Html for insert quantity (configurator)
    private function getHtmlCodeForConfigurator($sizes, $order_rows, $price, $modal, $canGoToCart)
    {
        $html = "";

        $curr_row = $order_rows[0];

        // Get html row
        $html .= $this->getHtmlCodeForConfigurator_Row($sizes, $curr_row, $price, $modal, $canGoToCart);

        return $html;
    }

    private function getHtmlCodeForConfigurator_Row($sizes, $order_row, $price, $modal, $canGoToCart)
    {
        $html = "<div class='insert-quantity-block'>";

        $html .= $this->getHeaderTable(false, $modal);
        $html .= '<input type="hidden" id="modify-modal-nurorc" value="' . $order_row->nurorc . '"/>';

        for ($i = 0; $i < count($sizes); $i++) {
            $quanti = 0;
            if (isset($order_row) && $order_row->detail[$sizes[$i]->taglia]) {
                $quanti = $order_row->detail[$sizes[$i]->taglia];
            }
            $html .= $this->getConfiguratorInsertQuantityRow($sizes[$i], $price, $quanti, $modal);
        }

        $html .= $this->getFooterBlock($modal, $canGoToCart);

        $html .= "</div>";

        return $html;
    }

    private function getConfiguratorInsertQuantityRow($size_info, $price, $quanti, $modal)
    {
        // Open Row
        $class = '';
        $title = '';
        $inp_cls = '';

        // Get price
        $withDiscount = false;
        $size_info->sconto = 0;
        $locale = (isset($_COOKIE['locale'])) ? $_COOKIE['locale'] : $_SERVER['HTTP_ACCEPT_LANGUAGE'];
        setlocale(LC_ALL, $locale);

        $currency = $this->utility->getCurrencySymbol($size_info->cdvalu);
        $price = $this->utility->getFormattedPriceCurrencyPresent($price, $currency, $size_info->cdvalu);

        $html = "<div class='row insert-quantity-row ";
        $html .= "is-size' ";
        $html .= "data-qtamin='" . $size_info->qtamin . "' ";
        $html .= "data-qtamul='" . $size_info->qtamul . "' ";
        $html .= "data-qtamax='" . (isset($size_info->qtamax) && $size_info->qtamax > 0 ? $size_info->qtamax : 0) . "' ";
        $html .= "data-flbloc='" . $size_info->flbloc . "' ";
        $html .= "data-flprom='" . $size_info->flprom . "' ";
        $html .= "data-taglia='" . $size_info->taglia . "' ";
        $html .= "data-prezzo='" . $price['value_raw'] . "' ";
        $html .= "data-sconto='" . $size_info->sconto . "' ";
        $html .= "data-disp='-1' ";
        $html .= $modal ? "style='margin-left:0;margin-right:0'" : "";
        $html .= ">";

        // Size
        $html .= "<div class='col" . $class . "'" . $title . ">" . $size_info->taglia;

        if ($this->utility->getAppSettings('ShowMinMulOnModelDetail') == 1) {
            $html .= '<span style="font-size:10px;padding-left:10px">(Min: ' . $size_info->qtamin . ', Mul: ' . $size_info->qtamul . ')</span>';
        }

        $html .= "</div>";

        // Price
        $html .= "<div class='col'><div class='price-model-box'>" . $price['value'] . "</div></div>";

        // Quantity
        $html .= "<div class='col-4'>";

        if ($quanti > 0) {
            $minus_cls = 'enabled';
        } else {
            $minus_cls = 'disabled';
        }
        $plus_cls = 'enabled';

        $html .= "<div class='btn-number minus-qty $minus_cls ' data-type='minus'>";
        $html .= "<i class='fa fa-minus' aria-hidden='true'></i>";
        $html .= "</div>";
        $html .= "<div class='float-left w-40'>";
        $html .= "<input type='text' class='input-number $inp_cls ' ";
        if ($minus_cls == 'disabled' && $plus_cls == 'disabled') {
            $html .= 'disabled ';
        }
        $html .= "data-old_value='" . ($quanti > 0 ? $quanti : "") . "' data-issize='true' ";
        $html .= "value='" . ($quanti > 0 ? $quanti : '') . "' min='0'>";
        $html .= "</div>";
        $html .= "<div class='btn-number plus-qty $plus_cls ' data-type='plus'>";
        $html .= "<i class='fa fa-plus' aria-hidden='true'></i>";
        $html .= "</div>";

        if ($this->utility->getAppSettings('EnableMinMulLabel') > 0) {
            $html .= "<div class='regqta-info'>";
            $html .= $this->translate('_common.qty.min.short') . ': ' . $size_info->qtamin . ', ';
            $html .= $this->translate('_common.qty.mul.short') . ': ' . $size_info->qtamul;
            if (isset($size_info->qtamax) && $size_info->qtamax > 0) {
                $html .= ', ' . $this->translate('_common.qty.max.short') . ': ' . $size_info->qtamax;
            }
            $html .= "</div>";
        }

        $html .= "</div>";

        // Close row
        $html .= "</div>";

        return $html;
    }
    //endregion

    //region Html for model wizard
    private function getHtmlSizeContentForArticleWizard($articles, $tipolo, $nulist, $showCatalogPrice)
    {
        if (count($articles) == 0) {
            return '';
        }

        $qttagl = $articles[0]['qttagl'];

        $html =
            "<div class='col-12'>
        <div class='row wizard-header-row'>
          <div class='col-1'>&nbsp;</div>";

        $gridClass = count($qttagl) <= 8 ? 'col-1' : 'col';
        for ($i = 0; $i < count($qttagl); $i++) {
            $size = $qttagl[$i];
            $html .= "<div class='col grid-cell'>" . $size['taglia'] . "</div>";
        }

        $html .=
            "<div class='col-1 grid-cell'>" . $this->translate('_common.qty.tot') . "</div>
          <div class='col-2'>" . $this->translate('_common.amount') . "</div>
        </div>
      </div>";

        $withDiscount = $hasDiscount = false;
        $currentPrice = '';
        $bg = '#fafafa';
        $totalAllQty = 0;
        $totalAllAmt = 0;

        $unitPrice = 0;
        $realPrice = 0;
        $retailPrice = '';
        $differentPrices = false;
        $differentRetailPrices = false;
        if (count($articles) > 0) {
            $size = $articles[0]['qttagl'][0];

            if ($articles[0]['article']->prezzo_r != 0 && $articles[0]['article']->cdvalu_r != '') {
                $retailPrice = $this->utility->getFormattedPriceWithCdvalu($articles[0]['article']->cdvalu_r, $articles[0]['article']->prezzo_r);
            }

            $customDiscount = $tipolo->cust_disc > 0 ? $tipolo->cust_disc : 0;
            if ($showCatalogPrice != 0) {
                $unitPrice = $size['prezzo'];
                if ($unitPrice < 0) {
                    $unitPrice = $this->translate('quantity.priceforsize.short');
                } else if ($unitPrice == 0) {
                    $unitPrice = '-';
                } else {
                    $realPrice = $unitPrice;
                    $customDiscount = $articles[0]['article']->cust_disc > 0 ? $articles[0]['article']->cust_disc : $customDiscount;
                    $disc_price = $realPrice * (1 - $customDiscount / 100);
                    $hasDiscount = $disc_price != $realPrice;

                    $catalogPrice = $this->utility->getFormattedPrice($nulist, $disc_price);
                    $unitPrice = $catalogPrice['value'];
                }
            }
        }

        foreach ($articles as $articleContainer) {
            $article = $articleContainer['article'];
            $bg = $bg == '#fafafa' ? '#fff' : '#fafafa';

            if ($article->prezzo_r != 0 && $article->cdvalu_r != '') {
                $currRetailPrice = $this->utility->getFormattedPriceWithCdvalu($article->cdvalu_r, $article->prezzo_r);
                if ($currRetailPrice != $retailPrice) {
                    $differentRetailPrices = true;
                }
            }

            $features = Sparti::getAllFeatures($article->cdarti);
            $featuresTitle = '';
            foreach ($features as $feature) {
                $featuresTitle .= ' - ' . $feature->dscomp . ': ' . $feature->valore;
            }

            if ($article->tpvend != 'CUSTOM') {
                $imgurl = $this->utility->getImageModelLink($article->flimag);
                $exist = $article->flimag != '' && file_exists("img/model/" . $article->flimag);
                if (!$exist) {
                    $imgurl = $this->config->application->baseUri . 'assets/img/default_model.jpg';
                }
                $firstCol = "<img src='" . $imgurl . "' title='" . htmlentities($article->cdcolo, ENT_COMPAT, 'UTF-8') . $featuresTitle . "'/>&nbsp;" . $article->cdcolo;
            } else {
                $title = $this->translate('_common.variant') . " " . $article->dsarti;
                $firstCol = "<div title='" . $title . "'>$article->dsarti</div>";
            }

            $html .=
                "<div class='col-12'>
          <div class='row wizard-list-row' style='background-color:$bg' data-cdarti='$article->cdarti' data-cdcolo='$article->cdcolo'>
            <div class='col-1'>$firstCol</div>";

            $totalQty = 0;
            $totalAmt = 0;
            for ($i = 0; $i < count($articleContainer['qttagl']); $i++) {
                $size = $articleContainer['qttagl'][$i];

                $disabled = (($i + 1) < $tipolo->tglini && $tipolo->tglini != 0) || (($i + 1) > $tipolo->tglfin && $tipolo->tglfin != 0);
                $disc_price = 0;
                $cust_disc = $tipolo->cust_disc > 0 ? $tipolo->cust_disc : 0;
                if ($showCatalogPrice != 0) {
                    $currentPrice = $size['prezzo'];
                    if ($currentPrice < 0) {
                        $currentPrice = $this->translate('quantity.priceforsize.short');
                    } else if ($currentPrice == 0) {
                        $currentPrice = '-';
                    } else {
                        $real_price = $currentPrice;
                        $cust_disc = $article->cust_disc > 0 ? $article->cust_disc : $cust_disc;
                        $disc_price = $real_price * (1 - $cust_disc / 100);
                        $withDiscount = $disc_price != $real_price;

                        $catalogPrice = $this->utility->getFormattedPrice($nulist, $disc_price);
                        $currentPrice = $catalogPrice['value'];
                    }
                }

                if ($currentPrice != $unitPrice) {
                    $differentPrices = true;
                }

                $thisPrice = $disc_price > 0 ? $disc_price : $size['prezzo'];
                $totalQty += $size['quanti'];
                $totalAmt += ($size['quanti'] * $thisPrice);

                $html .=
                    "<div class='col grid-cell stepper'>
            <div class='input' style='float:left;width:70%'>
              <input type='text' class='input-number  " . ($disabled ? 'disabled' : '') . "'
                data-old_value='' data-issize='true'
                data-qtamin='" . $size['qtamin'] . "' data-qtamul='" . $size['qtamul'] . "'
                data-qtamax='" . (isset($size['qtamax']) && $size['qtamax'] > 0 ? $size['qtamax'] : 0) . "'
                data-taglia='" . $size['taglia'] . "' data-prezzo='" . $thisPrice . "'
                data-sconto='" . $cust_disc . "' name='quantity'
                value='" . ($size['quanti'] > 0 ? $size['quanti'] : '') . "' " . ($disabled ? 'disabled' : '') . "
              />
            </div>" .
                    ($disabled
                        ? ''
                        : "<div class='steps' style='float:left;width:30%'>
                <div class='step up'><i class='fa fa-caret-up'></i></div>
                <div class='step down'><i class='fa fa-caret-down'></i></div>
              </div>") .
                    ($this->utility->getAppSettings('EnableMinMulLabel') > 0
                        ? "<div class='regqta-info'>" .
                        $this->translate('_common.qty.min.short') . ': ' . $size['qtamin'] . ', ' .
                        $this->translate('_common.qty.mul.short') . ': ' . $size['qtamul'] .
                        (isset($size['qtamax']) && $size['qtamax'] > 0 ? ', ' . $this->translate('_common.qty.max.short') . ': ' . $size['qtamax'] : '') .
                        "</div>"
                        : '') .
                    "</div>";
            }

            $html .=
                "<div class='col-1 grid-cell total-sizes'>" . ($totalQty > 0 ? $totalQty : '&nbsp;') . "</div>
            <div class='col-2 amount-sizes'>" . ($totalAmt > 0 ? $this->utility->getFormattedPrice($nulist, $totalAmt)['value'] : '&nbsp;') . "</div>
          </div>
        </div>";

            $totalAllQty += $totalQty;
            $totalAllAmt += $totalAmt;
        }

        $showPublicPrice = $this->utility->getAppSettings('ParamPriceSellPublicVisible') == 1;

        $html .=
            "<div class='col-12'>
        <div class='row wizard-footer-row' style='font-size:11px'>
          <div class='col-1'></div>" .
            ($showCatalogPrice != 0 && !$differentPrices
                ? "<div class='col'>" . $this->translate('_common.price.unit') . ": " .
                ($hasDiscount
                    ? "<span class='discounted'>" . $realPrice . "</span> " . $unitPrice
                    : $unitPrice) .
                "</div>"
                : '') .
            ($showPublicPrice && $retailPrice != '' && !$differentRetailPrices ? "<div class='col'>Retail Price: " . $retailPrice['value'] . "</div>" : '') .
            "<div class='col text-right'>" . $this->translate('_common.total') . ":</div>
          <div class='col-1' id='tot-qty'>" . ($totalAllQty > 0 ? $totalAllQty : '&nbsp;') . "</div>
          <div class='col-2' id='tot-amt'>" . ($totalAllAmt > 0 ? $this->utility->getFormattedPrice($nulist, $totalAllAmt)['value'] : '&nbsp;') . "</div>
        </div>
      </div>";

        return $html;
    }

    private function getHtmlSizeContentForConfiguratorWizard($articles, $tipolo, $nulist, $showCatalogPrice)
    {
        if (count($articles) == 0) {
            return '';
        }

        $qttagl = $articles[0]['qttagl'];

        $html =
            "<div class='col-12'>
        <div class='row wizard-header-row'>
          <div class='col-1'>&nbsp;</div>";

        if ($showCatalogPrice != 0) {
            $html .= '<div class="col-1">&nbsp;</div>';
        }

        $gridClass = count($qttagl) <= 8 ? 'col-1' : 'col';
        for ($i = 0; $i < count($qttagl); $i++) {
            $size = $qttagl[$i];
            $html .= "<div class='col grid-cell'>" . $size['taglia'] . "</div>";
        }

        $html .=
            "<div class='col-1 grid-cell'>" . $this->translate('_common.qty.tot') . "</div>
          <div class='col-2'>" . $this->translate('_common.amount') . "</div>
        </div>
      </div>";

        $bg = '#fafafa';
        $totalAllQty = 0;
        $totalAllAmt = 0;

        foreach ($articles as $article) {
            $bg = $bg == '#fafafa' ? '#fff' : '#fafafa';

            $title = '';
            if (count($article['components']) > 0) {
                foreach ($article['components'] as $component) {
                    $title .= '<b>' . urlencode($component->dscomp) . ':</b> ' . urlencode($component->cdmate) . ' - ' . urlencode($component->dsmate) . '<br/>';
                }
                $title = substr($title, 0, -5);
            }
            $title = $title != '' ? "data-toggle='tooltip' data-placement='right' title=' " . $title . "'" : '';

            /*
      $title = '';
      if (count($article['components']) > 0) {
        foreach ($article['components'] as $component) {
          $title .= $component->dscomp . ': ' . $component->cdmate . ' - ' . $component->dsmate . ', ';
        }
        $title = substr($title, 0, -2);
      }

      $imgurl = "img/model/" . $article['flimag'];
      $exist = $article['flimag'] != '' && file_exists($imgurl);
      if (!$exist) {
        $imgurl = 'assets/img/default_model.jpg';
      }
      $firstCol = "<img src='" . $this->config->application->baseUri . $imgurl . "' title='" . htmlentities($title, ENT_COMPAT, 'UTF-8') . "'/>&nbsp;" . $article['dsarti'];*/
            $firstCol = $article['dsarti'];

            if ($article['isCustom']) {
                if ($article['isDefault']) {
                    $cdcolo = 'DEFCUSTOM';
                } else {
                    $cdcolo = 'CUSTOM';
                }
            } else {
                $cdcolo = '';
            }

            $html .=
                "<div class='col-12'>
          <div class='row wizard-list-row' style='background-color:$bg' data-cdarti='" . $article['cdarti'] . "' data-cdcolo='$cdcolo'>
            <div class='col-1 text-left pl-5x' $title>$firstCol</div>";

            if ($showCatalogPrice != 0) {
                $price = $this->utility->getFormattedPrice($nulist, $article['prezzo']);
                $html .= "<div class='col-1 text-right pr-5x'>" . $price['value'] . "</div>";
            }

            $totalQty = 0;
            $totalAmt = 0;
            for ($i = 0; $i < count($article['qttagl']); $i++) {
                $size = $article['qttagl'][$i];

                $disabled = (($i + 1) < $tipolo->tglini && $tipolo->tglini != 0) || (($i + 1) > $tipolo->tglfin && $tipolo->tglfin != 0);
                if ($showCatalogPrice != 0) {
                    $price = $this->utility->getFormattedPrice($nulist, $article['prezzo']);
                    $currentPrice = $price['value'];
                }

                $totalQty += $size['quanti'];
                $totalAmt += ($size['quanti'] * $article['prezzo']);

                $html .=
                    "<div class='col grid-cell stepper'>
            <div class='input' style='float:left;width:70%'>
              <input type='text' class='input-number " . ($disabled ? 'disabled' : '') . "'
                data-old_value='' data-issize='true'
                data-qtamin='" . $size['qtamin'] . "' data-qtamul='" . $size['qtamul'] . "'
                data-qtamax='" . (isset($size['qtamax']) && $size['qtamax'] > 0 ? $size['qtamax'] : 0) . "'
                data-taglia='" . $size['taglia'] . "' data-prezzo='" . $article['prezzo'] . "'
                data-sconto='0' name='quantity'
                value='" . ($size['quanti'] > 0 ? $size['quanti'] : '') . "' " . ($disabled ? 'disabled' : '') . "
              />
            </div>" .
                    ($disabled
                        ? ''
                        : "<div class='steps' style='float:left;width:30%'>
                <div class='step up'><i class='fa fa-caret-up'></i></div>
                <div class='step down'><i class='fa fa-caret-down'></i></div>
              </div>") .
                    ($this->utility->getAppSettings('EnableMinMulLabel') > 0
                        ? "<div class='regqta-info'>" .
                        $this->translate('_common.qty.min.short') . ': ' . $size['qtamin'] . ', ' .
                        $this->translate('_common.qty.mul.short') . ': ' . $size['qtamul'] .
                        (isset($size['qtamax']) && $size['qtamax'] > 0 ? ', ' . $this->translate('_common.qty.max.short') . ': ' . $size['qtamax'] : '') .
                        "</div>"
                        : '') .
                    "</div>";
            }

            $html .=
                "<div class='col-1 grid-cell total-sizes'>" . ($totalQty > 0 ? $totalQty : '&nbsp;') . "</div>
            <div class='col-2 amount-sizes'>" . ($totalAmt > 0 ? $this->utility->getFormattedPrice($nulist, $totalAmt)['value'] : '&nbsp;') . "</div>
          </div>
        </div>";

            $totalAllQty += $totalQty;
            $totalAllAmt += $totalAmt;
        }

        $html .=
            "<div class='col-12'>
        <div class='row wizard-footer-row' style='font-size:11px'>
          <div class='col text-right'>" . $this->translate('_common.total') . ":</div>
          <div class='col-1' id='tot-qty'>" . ($totalAllQty > 0 ? $totalAllQty : '&nbsp;') . "</div>
          <div class='col-2' id='tot-amt'>" . ($totalAllAmt > 0 ? $this->utility->getFormattedPrice($nulist, $totalAllAmt)['value'] : '&nbsp;') . "</div>
        </div>
      </div>";

        return $html;
    }

    private function getHtmlSizeContentAssortmentBodyForFabricWizard($colors, $cdarti, $ocasso, $price, $custDisc, $nulist, $priceVariation, $articleDiscount)
    {
        $html = '';

        $bg = '#fafafa';
        foreach ($colors as $cdcolo) {
            $bg = $bg == '#fafafa' ? '#fff' : '#fafafa';

            $color = Artcol::getColor($cdcolo, $cdarti);

            if (count($color) > 0) {
                $imgurl = $this->utility->getImageModelLink($color['flimag']);
                $exist = $color['flimag'] != '' && file_exists("img/model/" . $color['flimag']);
                if (!$exist) {
                    $imgurl = $this->config->application->baseUri . 'assets/img/default_model.jpg';
                }

                $html .=
                    "<div class='col-12'>
            <div class='row wizard-list-row' style='background-color:" . $bg . "' data-cdcolo='" . $cdcolo . "'>
              <div class='col'>
                <img src='" . $imgurl . "' title='" . htmlentities($color['dscolo'], ENT_COMPAT, 'UTF-8') . "'/>
              </div>";

                for ($i = 0; $i < count($ocasso); $i++) {
                    $disc_price = 0;
                    $cust_disc = $custDisc > 0 ? $custDisc : 0;

                    $withDiscount = false;
                    $currentPrice = $price + $priceVariation;
                    if ($currentPrice < 0) {
                        $currentPrice = $this->translate('quantity.priceforsize.short');
                    } else if ($currentPrice == 0) {
                        $currentPrice = '-';
                    } else {
                        $real_price = $currentPrice;
                        $cust_disc = $articleDiscount > 0 ? $articleDiscount : $cust_disc;
                        $disc_price = $real_price * (1 - $cust_disc / 100);
                        $withDiscount = $disc_price != $real_price;

                        $catalogPrice = $this->utility->getFormattedPrice($nulist, $disc_price);
                        $currentPrice = $catalogPrice['value'];
                    }

                    $html .=
                        "<div class='col grid-cell stepper'>
              <div class='input' style='float:left;width:70%'>
                <input type='text' class='input-number '
                  data-old_value='' data-qtamin='1' data-qtamul='1' data-qtamax='0' data-issize='false'
                  data-cdasso='" . $ocasso[$i]->cdasso . "' data-quanti='" . $ocasso[$i]->quanti . "'
                  data-prezzo='" . ($disc_price > 0 ? $disc_price : $price) . "'
                  data-sconto='" . $cust_disc . "' name='quantity'
                  value=''/>
              </div>
              <div class='steps' style='float:left;width:30%'>
                <div class='step up'><i class='fa fa-caret-up'></i></div>
                <div class='step down'><i class='fa fa-caret-down'></i></div>
              </div>
            </div>";
                }

                $html .= "<div class='col-1 grid-cell total-sizes'></div>
            <div class='col-2 amount-sizes'></div>
          </div>
        </div>";
            }
        }

        return $html;
    }

    private function getHtmlSizeContentForFabricWizard($colors, $cdarti, $qttagl, $tipolo, $ocasso, $nulist, $priceVariation, $articleDiscount, $showCatalogPrice)
    {
        $html =
            "<div class='col-12'>
        <div class='row wizard-header-row'>
          <div class='col'>&nbsp;</div>";

        if ($tipolo->flasso < 2) {
            for ($i = 0; $i < count($qttagl); $i++) {
                $size = $qttagl[$i];
                $html .= "<div class='col grid-cell'>" . $size['taglia'] . "</div>";
            }
        }

        if ($tipolo->flasso > 0) {
            for ($i = 0; $i < count($ocasso); $i++) {
                $assortment = $ocasso[$i];
                $tooltip = '';
                foreach ($assortment->detail as $key => $value) {
                    $tooltip .= $value . 'x' . $key . ', ';
                }
                $html .= "<div class='col grid-cell' data-toggle='tooltip' title='" . substr($tooltip, 0, -2) . "'>" . $assortment->cdasso . "</div>";
            }
        }

        $html .=
            "<div class='col-1 grid-cell'>" . $this->translate('_common.qty.tot') . "</div>
          <div class='col-2'>" . $this->translate('_common.amount') . "</div>
        </div>
      </div>";

        $withDiscount = false;
        $real_price = $currentPrice = count($qttagl) > 0 ? $qttagl[0]['prezzo'] : 0;
        $bg = '#fafafa';
        foreach ($colors as $cdcolo) {
            $bg = $bg == '#fafafa' ? '#fff' : '#fafafa';

            $color = Artcol::getColor($cdcolo, $cdarti);

            if (count($color) > 0) {
                $imgurl = $this->utility->getImageModelLink($color['flimag']);
                $exist = $color['flimag'] != '' && file_exists("img/model/" . $color['flimag']);
                if (!$exist) {
                    $imgurl = $this->config->application->baseUri . 'assets/img/default_model.jpg';
                }

                $html .=
                    "<div class='col-12'>
            <div class='row wizard-list-row' style='background-color:" . $bg . "' data-cdcolo='" . $cdcolo . "'>
              <div class='col'>
                <img src='" . $imgurl . "' title='" . htmlentities($color['dscolo'], ENT_COMPAT, 'UTF-8') . "'/>
              </div>";

                if ($tipolo->flasso < 2) {
                    for ($i = 0; $i < count($qttagl); $i++) {
                        $size = $qttagl[$i];

                        $disabled = (($i + 1) < $tipolo->tglini && $tipolo->tglini != 0) || (($i + 1) > $tipolo->tglfin && $tipolo->tglfin != 0);
                        $disc_price = 0;
                        $cust_disc = $tipolo->cust_disc > 0 ? $tipolo->cust_disc : 0;

                        $withDiscount = false;
                        $currentPrice = $size['prezzo'] + $priceVariation;
                        if ($currentPrice < 0) {
                            $currentPrice = $this->translate('quantity.priceforsize.short');
                        } else if ($currentPrice == 0) {
                            $currentPrice = '-';
                        } else {
                            $real_price = $currentPrice;
                            $cust_disc = $articleDiscount > 0 ? $articleDiscount : $cust_disc;
                            $disc_price = $real_price * (1 - $cust_disc / 100);
                            $withDiscount = $disc_price != $real_price;

                            $catalogPrice = $this->utility->getFormattedPrice($nulist, $disc_price);
                            $currentPrice = $catalogPrice['value'];
                        }

                        $html .=
                            "<div class='col grid-cell stepper'>
                <div class='input' style='float:left;width:70%'>
                  <input type='text' class='input-number " . ($disabled ? 'disabled' : '') . "'
                    data-old_value='' data-issize='true'
                    data-qtamin='" . $size['qtamin'] . "' data-qtamul='" . $size['qtamul'] . "'
                    data-qtamax='" . (isset($size['qtamax']) && $size['qtamax'] > 0 ? $size['qtamax'] : 0) . "'
                    data-taglia='" . $size['taglia'] . "' data-prezzo='" . ($disc_price > 0 ? $disc_price : $size['prezzo']) . "'
                    data-sconto='" . $cust_disc . "' name='quantity'
                    value='' " . ($disabled ? 'disabled' : '') . "/>
                </div>" .
                            ($disabled
                                ? ''
                                : "<div class='steps' style='float:left;width:30%'>
                    <div class='step up'><i class='fa fa-caret-up'></i></div>
                    <div class='step down'><i class='fa fa-caret-down'></i></div>
                  </div>") .
                            ($this->utility->getAppSettings('EnableMinMulLabel') > 0
                                ? "<div class='regqta-info'>" .
                                $this->translate('_common.qty.min.short') . ': ' . $size['qtamin'] . ', ' .
                                $this->translate('_common.qty.mul.short') . ': ' . $size['qtamul'] .
                                (isset($size['qtamax']) && $size['qtamax'] > 0 ? ', ' . $this->translate('_common.qty.max.short') . ': ' . $size['qtamax'] : '') .
                                "</div>"
                                : '') .
                            "</div>";
                    }
                }

                if ($tipolo->flasso > 0) {
                    for ($i = 0; $i < count($ocasso); $i++) {
                        $disc_price = 0;
                        $cust_disc = $tipolo->cust_disc > 0 ? $tipolo->cust_disc : 0;

                        $withDiscount = false;
                        $currentPrice = $qttagl[0]['prezzo'] + $priceVariation;
                        if ($currentPrice < 0) {
                            $currentPrice = $this->translate('quantity.priceforsize.short');
                        } else if ($currentPrice == 0) {
                            $currentPrice = '-';
                        } else {
                            $real_price = $currentPrice;
                            $cust_disc = $articleDiscount > 0 ? $articleDiscount : $cust_disc;
                            $disc_price = $real_price * (1 - $cust_disc / 100);
                            $withDiscount = $disc_price != $real_price;

                            $catalogPrice = $this->utility->getFormattedPrice($nulist, $disc_price);
                            $currentPrice = $catalogPrice['value'];
                        }

                        $html .=
                            "<div class='col grid-cell stepper'>
                <div class='input' style='float:left;width:70%'>
                  <input type='text' class='input-number'
                    data-old_value='' data-qtamin='1' data-qtamul='1' data-qtamax='0' data-issize='false'
                    data-cdasso='" . $ocasso[$i]->cdasso . "' data-quanti='" . $ocasso[$i]->quanti . "'
                    data-prezzo='" . ($disc_price > 0 ? $disc_price : $qttagl[0]['prezzo']) . "'
                    data-sconto='" . $cust_disc . "' name='quantity'
                    value=''/>
                </div>
                <div class='steps' style='float:left;width:30%'>
                  <div class='step up'><i class='fa fa-caret-up'></i></div>
                  <div class='step down'><i class='fa fa-caret-down'></i></div>
                </div>
              </div>";
                    }
                }

                $html .= "<div class='col-1 grid-cell total-sizes'></div>
            <div class='col-2 amount-sizes'></div>
          </div>
        </div>";
            }
        }

        $disc_price = 0;
        $cust_disc = $tipolo->cust_disc > 0 ? $tipolo->cust_disc : 0;

        $withDiscount = false;
        $currentPrice = $qttagl[0]['prezzo'] + $priceVariation;
        if ($currentPrice < 0) {
            $currentPrice = $this->translate('quantity.priceforsize.short');
        } else if ($currentPrice == 0) {
            $currentPrice = '-';
        } else {
            $real_price = $currentPrice;
            $cust_disc = $articleDiscount > 0 ? $articleDiscount : $cust_disc;
            $disc_price = $real_price * (1 - $cust_disc / 100);
            $withDiscount = $disc_price != $real_price;

            $catalogPrice = $this->utility->getFormattedPrice($nulist, $disc_price);
            $currentPrice = $catalogPrice['value'];
        }

        $html .=
            "<div class='col-12'>
        <div class='row wizard-footer-row' style='font-size:11px'>
          <div class='col-1'></div>" .
            ($showCatalogPrice != 0
                ? "<div class='col'>" . $this->translate('_common.price.unit') . ": " .
                ($withDiscount
                    ? "<span class='discounted'>" . $real_price . "</span> " . $currentPrice
                    : $currentPrice) .
                "</div>"
                : '') .
            "<div class='col text-right'>" . $this->translate('_common.total') . ":</div>
          <div class='col-1' id='tot-qty'>&nbsp;</div>
          <div class='col-2' id='tot-amt'>&nbsp;</div>
        </div>
      </div>";

        return $html;
    }

    private function getHtmlArticleImagesPreview($anaart, $images)
    {
        $html =
            '<div class="col-12 col-lg-2">
        <div class="row">
          <div class="col-4 col-lg-12 text-center">' .
            $this->elements->getModelImgOrDefaultHtml($anaart->flimag, $this->translate('_common.see'), array("data-index" => 0, "class" => "preview-thumbnail preview-selected")) .
            '</div>';

        if (count($images) > 0) {
            $i = 1;
            foreach ($images as $image) {
                $html .=
                    '<div class="col-4 col-lg-12 text-center">' .
                    $this->elements->getModelImgOrDefaultHtml($image->flimag, $this->translate('_common.see'), array("data-index" => $i, "class" => "preview-thumbnail")) .
                    '</div>';
                $i++;
            }
        }

        $html .=
            '</div>
      </div>
      <div class="col-12 col-lg-10 text-center" id="article-main-image" unselectable="on">';

        if (count($images) > 0) {
            $html .= '<div class="fa fa-chevron-left"></div>';
        }

        $html .= $this->elements->getModelImgOrDefaultHtml($anaart->flimag, $anaart->dsarti, array("style" => "width:90%;max-width:550px;max-height:550px;cursor:zoom-in;", "data-enlargable" => ""));

        if (count($images) > 0) {
            $html .= '<div class="fa fa-chevron-right"></div>';
        }

        $html .= '</div>';

        return $html;
    }

    private function getHtmlColorImagesPreview($artcol, $images)
    {
        $html =
            '<div class="col-12 col-lg-2">
        <div class="row">';

        if (count($images) > 0) {
            $i = 1;
            foreach ($images as $image) {
                $class = $i == 1 ? 'preview-thumbnail preview-selected' : 'preview-thumbnail';
                $html .=
                    '<div class="col-4 col-lg-12 text-center">' .
                    $this->elements->getModelImgOrDefaultHtml($image->flimag, $this->translate('_common.see'), array("data-index" => $i, "class" => $class)) .
                    '</div>';
                $i++;
            }
        }
        $class = count($images) == 0 ? 'preview-thumbnail preview-selected' : 'preview-thumbnail';
        $html .= '<div class="col-4 col-lg-12 text-center">' .
            $this->elements->getModelImgOrDefaultHtml($artcol->flimag, $this->translate('_common.see'), array("data-index" => 0, "class" => $class)) .
            '</div>';

        $html .=
            '</div>
      </div>
      <div class="col-12 col-lg-10 text-center" id="color-main-image" unselectable="on">';

        if (count($images) > 0) {
            $html .= '<div class="fa fa-chevron-left"></div>';
        }

        $html .= $this->elements->getModelImgOrDefaultHtml(
            count($images) == 0 ? $artcol->flimag : $images[0]->flimag,
            $artcol->dscolo,
            array("style" => "width:90%;max-width:550px;max-height:550px;cursor:zoom-in;", "data-enlargable" => "")
        );

        if (count($images) > 0) {
            $html .= '<div class="fa fa-chevron-right"></div>';
        }

        $html .= '</div>';

        return $html;
    }

    private function getHtmlComponentImagesModal($materials)
    {
        $html = '<div class="row">';

        foreach ($materials as $material) {
            $html .= '<div class="col-3 modal-component text-center">';
            $html .= '<div>';
            $html .= $this->elements->getModelImgOrDefaultHtml(
                $material['flimag'],
                $material['dsmate'],
                array('class' => 'configurator-preview', 'data-toggle' => 'tooltip', 'width' => '150px', 'data-placement' => 'top', 'title' => $material['dsmate']),
                false
            );
            $html .= '</div>';
            $html .= '<div class="description">' . $material['cdcolo'] . '</div>';
            $html .= '</div>';
        }

        $html .= '</div>';
        return $html;
    }
    //endregion

    //region Explanation for insert quantity strategy
    /* BRIEF FOR INSERT QUANTITY:

  A) availability order AT / reservation order AF
  B) tissue BT / article BF
  C) backstitch CT / no backstitch CF - by param, don't care if BF
  D) multiple dates DT / no multiple dates DF - by param, don't care if AT or BT
  E) multiple availability date ET / no multiple availability dates EF - don't care if AF

  IF (AT) { // don't care about D
    IF (BT) {
      IF (CT) {
        IF (ET) {
          MULTIPLE ROWS (C * E = (one for every backstich + one without backstitch) for every delivery date)
        } ELSE (EF) {
          MULTIPLE ROWS (one for every backstich + one without backstitch - single delivery date)
        }
      } ELSE (CF) {
        IF (ET) {
          MULTIPLE ROWS (one for every delivery date)
        } ELSE (EF) {
          ONE ROW (no backstich - single delivery date)
        }
      }
    } ELSE (BF) { // don't care about C
      IF (ET) {
        MULTIPLE ROWS (one for every delivery date)
      } ELSE (EF) {
        ONE ROW (single delivery date)
      }
    }
  } ELSE (AF) { // don't care about E
    IF (BT) { // don't care about D
      IF (CT) {
        MULTIPLE ROWS (one for every backstich + one without backstitch)
      } ELSE (CF) {
        ONE ROW
      }
    } ELSE (BF) { // don't care about C
      IF (DT) {
        MAX 3 ROWS (different delivery dates)
      } ELSE (DF) {
        ONE ROW
      }
    }
  }
  */
    //endregion
}
