<?php

namespace Go2B\Controllers;

use Go2B\Models\Anaart;
use Go2B\Models\Anaeti;
use Go2B\Models\Anagra;
use Go2B\Models\B2bAddinf;
use Go2B\Models\B2bBgtest;
use Go2B\Models\B2bSscorp;
use Go2B\Models\B2bSstest;
use Go2B\Models\Ctarti;
use Go2B\Models\Cttest;
use Go2B\Models\Desmer;
use Go2B\Models\Imgart;
use Go2B\Models\Lstest;
use Go2B\Models\Occorp;
use Go2B\Models\Ocperc;
use Go2B\Models\Octagl;
use Go2B\Models\Octest;
use Go2B\Models\Postgl;
use Go2B\Models\Regqtm;
use Go2B\Models\Smcorp;
use Go2B\Models\Spmate;
use Go2B\Models\Tabvar;
use Go2B\Models\Tipolo;
use Phalcon\Db\RawValue;
use Phalcon\Http\Request;
use Phalcon\Mvc\Model\Resultset\Simple as Resultset;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class ExcelController extends ControllerBase
{
  //region Ajax functions
  public function execDownloadAllOrdersXlsAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      set_time_limit(0);

      $filename = 'error';

      try {
        $type     = $_POST['type'];
        $dtiniz   = $_POST['dtiniz'];
        $dtfine   = $_POST['dtfine'];
        $whose    = $_POST['whose'];
        $whoseSet = isset($_POST['whoseSet']) ? rtrim($_POST['whoseSet'], ',') : -1;
        $whichSeason = isset($_POST['whichSeason']) ? rtrim($_POST['whichSeason'], ',') : -1;
        $status   = isset($_POST['status']) ? $_POST['status'] : array();
        $types    = isset($_POST['types']) ? $_POST['types'] : array();

        $withBlocks = $this->utility->getAppSettings('ModelDetailStyle') == 3;
        $orders = Octest::getFilteredOrders($type == 'periodagent', $dtiniz, $dtfine, $whose == 'agents', $whoseSet, $whichSeason, $status, $types, $withBlocks);

        $spreadsheet = new Spreadsheet();
        $spreadsheet->getProperties()->setCreator('Sinergiattiva')->setTitle($this->translate('_common.orders'));
        $spreadsheet->getActiveSheet()->getProtection()->setSheet(true);

        $spreadsheet->setActiveSheetIndex(0);
        $activeSheet = $spreadsheet->getActiveSheet();

        $activeSheet->setTitle($this->translate('_common.orders'));

        $headerStyle = array(
          'fill' => array(
            'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
            'color' => array('rgb' => 'EEEEEE')
          ),
          'borders' => array(
            'allBorders' => array(
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
              'color' => array('argb' => 'FF606060'),
            ),
          ),
          'font' => array(
            'bold' => true
          ),
          'alignment' => array(
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT
          ),
        );
        $activeSheet->getStyle('A1:J1')->applyFromArray($headerStyle);
        $allCellsStyle = array(
          'borders' => array(
            'allBorders' => array(
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
              'color' => array('argb' => 'FF606060'),
            ),
          ),
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
          )
        );
        $activeSheet->getStyle('A2:J' . (1 + count($orders)) . '')->applyFromArray($allCellsStyle);

        $activeSheet->calculateColumnWidths();
        foreach (['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J'] as $column) {
          $activeSheet->getColumnDimension($column)->setAutoSize(true);
        }

        $activeSheet->getCell('A1')->setValue(ucwords($this->translate('_common.ordernumber')));
        $activeSheet->getCell('B1')->setValue(ucwords($this->translate('_common.customer')));
        $activeSheet->getCell('C1')->setValue(ucwords($this->translate('admin.username')));
        $activeSheet->getCell('D1')->setValue(ucwords($this->translate('_common.agent')));
        $activeSheet->getCell('E1')->setValue(ucwords($this->translate('_common.orderdate')));
        $activeSheet->getCell('F1')->setValue(ucwords($this->translate('_common.delivery')));
        $activeSheet->getCell('G1')->setValue(ucwords($this->translate('_common.catalog')));
        $activeSheet->getCell('H1')->setValue(ucwords($this->translate('_common.quantity')));
        $activeSheet->getCell('I1')->setValue(ucwords($this->translate('_common.amount.gross')));
        $activeSheet->getCell('J1')->setValue(ucwords($this->translate('_common.status')));

        $orderStateMgmt = $this->utility->getAppSettings('OrderStateManagement');

        for ($i = 0; $i < count($orders); $i++) {
          $currency = !empty($orders[$i]->cdvalu) ? $orders[$i]->cdvalu : 'EUR';
          $date = $orders[$i]->dtmcoi != '00/00/000' && $orders[$i]->dtmcoi != null && $orders[$i]->dtmcof != '00/00/0000' && $orders[$i]->dtmcof != null
            ? $orders[$i]->dtmcoi . " - " . $orders[$i]->dtmcof
            : $orders[$i]->dtmcli;
          switch ($orders[$i]->flstat) {
            case 1:
              $flstat = $this->translate('account.order.provisional');
              break;
            case 2:
              $flstat = $this->translate($orderStateMgmt ? 'account.order.processed' : 'account.order.sent');
              break;
            case 3:
              $flstat = $this->translate('account.order.accepted');
              break;
            case 4:
              $flstat = $this->translate('account.order.rejected');
              break;
            case 5:
              $flstat = $this->translate('account.order.waitingquantity');
              break;
            case 6:
              $flstat = $this->translate('account.order.customerconfirmed');
              break;
          }

          $activeSheet->getCell('A' . (2 + $i))->setValue(ucwords($orders[$i]->nuordc));
          $activeSheet->getCell('B' . (2 + $i))->setValue(ucwords($orders[$i]->descri));
          $activeSheet->getCell('C' . (2 + $i))->setValue(ucwords($orders[$i]->username));
          $activeSheet->getCell('D' . (2 + $i))->setValue(ucwords($orders[$i]->dsagen));
          $activeSheet->getCell('E' . (2 + $i))->setValue(ucwords($orders[$i]->dtcrea));
          $activeSheet->getCell('F' . (2 + $i))->setValue(ucwords($date));
          $activeSheet->getCell('G' . (2 + $i))->setValue(ucwords($orders[$i]->cdcata));
          $activeSheet->getCell('H' . (2 + $i))->setValue(ucwords($orders[$i]->quanti));
          $activeSheet->getCell('I' . (2 + $i))->setValue(ucwords($orders[$i]->valore));
          $activeSheet->getCell('J' . (2 + $i))->setValue(ucwords($flstat));
        }

        $spreadsheet->getActiveSheet()->setAutoFilter('A1:J' . (1 + count($orders)));

        // Reset active sheet to 0
        $spreadsheet->setActiveSheetIndex(0);

        $filename = 'exportorders_' . date('YmdHis');

        $this->diskManager->saveOrderExcel($spreadsheet, $filename);
      } catch (\Exception $e) {
        $this->logger->info(print_r($e->getMessage(), true));
      }

      set_time_limit(30);

      echo json_encode($filename . ".xlsx");
    }
  }

  public function execDownloadAnalysisXlsAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      set_time_limit(0);

      $filename = 'error';

      try {
        $data = json_decode($_POST['data']);
        $isArticle = $_POST['isArticle'] == 1;

        $spreadsheet = new Spreadsheet();
        $spreadsheet->getProperties()->setCreator('Sinergiattiva')->setTitle($this->translate('_common.orders'));
        $spreadsheet->getActiveSheet()->getProtection()->setSheet(true);

        $spreadsheet->setActiveSheetIndex(0);
        $activeSheet = $spreadsheet->getActiveSheet();

        $activeSheet->setTitle($this->translate('admin.analysis.selectparams'));

        $hdrStyle = array(
          'fill' => array(
            'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
            'color' => array('rgb' => 'EEEEEE')
          ),
          'borders' => array(
            'allBorders' => array(
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
              'color' => array('argb' => 'FF606060'),
            ),
          ),
          'font' => array(
            'bold' => true
          ),
          'alignment' => array(
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER
          ),
        );
        $imgStyle = array(
          'borders' => array(
            'allBorders' => array(
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
              'color' => array('argb' => 'FF606060'),
            ),
          ),
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER
          ),
        );
        $codStyle = array(
          'borders' => array(
            'allBorders' => array(
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
              'color' => array('argb' => 'FF606060'),
            ),
          ),
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER
          ),
        );
        $txtStyle = array(
          'borders' => array(
            'allBorders' => array(
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
              'color' => array('argb' => 'FF606060'),
            ),
          ),
          'alignment' => array(
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT
          ),
        );
        $chnStyle = array(
          'borders' => array(
            'allBorders' => array(
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
              'color' => array('argb' => 'FF606060'),
            ),
          )
        );
        $totStyle = array(
          'fill' => array(
            'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
            'color' => array('rgb' => 'EEEEEE')
          ),
          'borders' => array(
            'allBorders' => array(
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
              'color' => array('argb' => 'FF606060'),
            ),
          ),
          'font' => array(
            'bold' => true
          )
        );
        $allCells = array(
          'borders' => array(
            'allBorders' => array(
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
              'color' => array('argb' => 'FF606060'),
            ),
          ),
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER
          ),
        );

        $maxX = 0;
        $maxY = 0;

        foreach ($data as $cell) {
          if ($cell->x > $maxX) {
            $maxX = $cell->x;
          }
          if ($cell->y > $maxY) {
            $maxY = $cell->y;
          }
        }
        $activeSheet->getStyle('A1:' . $this->utility->getNameFromNumber($maxX - 1) . $maxY)->applyFromArray($allCells);

        //$spreadsheet->getActiveSheet()->setAutoFilter('A1:' . $this->utility->getNameFromNumber($maxX - 1) . $maxY);

        foreach ($data as $cell) {
          $x = $this->utility->getNameFromNumber($cell->x - 1);
          $y = $cell->y;
          $style = $cell->type . 'Style';

          switch ($cell->type) {
            case 'hdr':
              $activeSheet->getCell($x . $y)->setValue($cell->content);
              break;
            case 'img':
              $fullPath = $cell->content;
              $tokens = explode('/', $cell->content);
              $img = $tokens[count($tokens) - 1];

              $objDrawing_n = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
              if ($img != 'default_model.jpg') {
                if ($this->utility->resizeImageForExcel('img/model/' . $img, "img/temp/resize/model/" . $img)) {
                  $fullPath = "img/temp/resize/model/" . $img;
                } else {
                  $fullPath = "assets/img/default_model.jpg";
                }
                $objDrawing_n->setPath($fullPath);
              } else {
                $objDrawing_n->setPath("assets/img/default_model.jpg");
              }

              $objDrawing_n->setResizeProportional(true);
              $objDrawing_n->setCoordinates('A' . $y);
              $objDrawing_n->setHeight(63);
              $objDrawing_n->setOffsetY(2);
              $objDrawing_n->setOffsetX(10);
              $objDrawing_n->setWorksheet($activeSheet);
              $activeSheet->getColumnDimension($x)->setWidth(12);

              if (!$isArticle) {
                $maxCurrentY = $this->getMaxYForCurrentModel($data, $y) + 1;
                $activeSheet->mergeCells('A' . $y . ':A' . $maxCurrentY);
              }
              break;
            case 'cod':
              $activeSheet->getColumnDimension($x)->setAutoSize(true);
              $activeSheet->getCell($x . $y)->setValue($cell->content);

              if (!$isArticle) {
                $activeSheet->mergeCells('B' . $y . ':B' . $this->getMaxYForCurrentModel($data, $y));
              }
              break;
            case 'txt':
              $activeSheet->getColumnDimension($x)->setAutoSize(true);
              $activeSheet->getCell($x . $y)->setValue($cell->content);
              break;
            case 'chn':
              $activeSheet->getColumnDimension($x)->setWidth(20);
              $activeSheet->getCell($x . $y)->setValue($cell->content);
              break;
            case 'tot':
              if ($x == 'A' || $x == 'B') {
                $activeSheet->mergeCells($x . $y . ':E' . $y);
                $activeSheet->getCell($x . $y)->setValue($cell->content);
              } else if (!in_array($x, ['C', 'D', 'E'])) {
                $activeSheet->getCell($x . $y)->setValue($cell->content);
              }
              break;
          }

          $activeSheet->getStyle($x . $y)->applyFromArray($$style);
          $activeSheet->getRowDimension($y)->setRowHeight($isArticle ? 50 : 25);
        }

        // Reset active sheet to 0
        $spreadsheet->setActiveSheetIndex(0);

        $filename = 'salesanalysis_' . date('YmdHis');

        $this->diskManager->saveSalesAnalysisExcel($spreadsheet, $filename);
      } catch (\Exception $e) {
        $this->logger->info(print_r($e->getMessage(), true));
      }

      set_time_limit(30);

      echo json_encode($filename . ".xlsx");
    }
  }

  public function execDownloadBudgetXlsAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      set_time_limit(0);

      $filename = 'error';

      $data = json_decode($_POST['data']);
      $type = $_POST['type'];

      try {
        $spreadsheet = new Spreadsheet();
        $spreadsheet->getProperties()->setCreator('Sinergiattiva')->setTitle($this->translate('_common.budget'));
        $spreadsheet->getActiveSheet()->getProtection()->setSheet(true);

        $spreadsheet->setActiveSheetIndex(0);
        $activeSheet = $spreadsheet->getActiveSheet();

        for ($i = 0; $i <= 20; $i++) {
          $activeSheet->getColumnDimension($this->utility->getNameFromNumber($i))->setAutoSize(true);
        }

        if ($type == 0) {
          $filename = $this->translate('_common.budget') . '_' . $this->translate('admin.budget.type.total') . '_' . date('YmdHis');

          $activeSheet->setTitle($this->translate('admin.budget.type.total'));

          $budget = B2bBgtest::getGlobalBudgetInfoFromSeason($data->cdstag, $data->cmpSeasons, $data->columns, $data->line, $data->drop);

          $fullBudgets = array();
          for ($i = 0; $i < count($budget); $i++) {
            $currentBudget = $budget[$i];
            $currentBudget->currentSituation = Octagl::getCurrentGlobalSituationForBudget(
              $currentBudget->tpanag,
              $currentBudget->cdanag,
              $data->cdstag,
              $data->line,
              $data->drop
            );
            $fullBudgets[] = $currentBudget;
          }

          if (count($fullBudgets) > 0) {
            // Get number of seasons
            $numOfSeasons = 0;
            if (isset($fullBudgets[0]->cdstg4)) {
              $numOfSeasons = $numOfSeasons < 4 ? 4 : $numOfSeasons;
            }
            if (isset($fullBudgets[0]->cdstg3)) {
              $numOfSeasons = $numOfSeasons < 3 ? 3 : $numOfSeasons;
            }
            if (isset($fullBudgets[0]->cdstg2)) {
              $numOfSeasons = $numOfSeasons < 2 ? 2 : $numOfSeasons;
            }
            if (isset($fullBudgets[0]->cdstg1)) {
              $numOfSeasons = $numOfSeasons < 1 ? 1 : $numOfSeasons;
            }
            // Get number of season 0 columns
            $hideBudget = !isset($fullBudgets[0]->valbdg) || !isset($fullBudgets[0]->qtabdg);
            $hideTarget = !isset($fullBudgets[0]->valtrg) || !isset($fullBudgets[0]->qtatrg);

            $title = $this->translate('_common.customer');

            $this->setBudgetHeader($activeSheet, $fullBudgets[0], $numOfSeasons, $title, $hideBudget, $hideTarget);
            $this->getGlobalBudgetBody($activeSheet, $fullBudgets, $numOfSeasons, $hideBudget, $hideTarget);
          } else {
            $activeSheet->getStyle('A1')->applyFromArray(array('font' => array('bold' => true)));
            $activeSheet->getCell('A1')->setValue('account.budget.no2');
          }
        } else {
          $filename = $this->translate('_common.budget') . '_' . $this->translate('_common.customer') . '_' . $data->cdanag . '_' . date('YmdHis');

          $activeSheet->setTitle($this->translate('_common.customer') . ' ' . $data->cdanag);

          $budget = B2bBgtest::getBudgetInfoFromCustomerAndSeason($data->tpanag, $data->cdanag, $data->cdstag, $data->cmpSeasons, $data->columns, $data->type == 0);

          $fullBudgets = array();
          for ($i = 0; $i < count($budget); $i++) {
            $currentBudget = $budget[$i];
            $currentBudget->currentSituation = Octagl::getCurrentSituationForBudget(
              $data->tpanag,
              $data->cdanag,
              $currentBudget->cdstag,
              $currentBudget->cduscc,
              $currentBudget->cdtitl,
              $currentBudget->cdlinm,
              $currentBudget->cdserm
            );
            $fullBudgets[] = $currentBudget;
          }

          if (count($fullBudgets) > 0) {
            // Check if brand is to add;
            $addBrand = false;
            $currentBrandCode = $budget[0]->cdtitl;
            foreach ($fullBudgets as $item) {
              if ($item->cdtitl != $currentBrandCode) {
                $addBrand = true;
                break;
              }
            }
            // Get number of seasons
            $numOfSeasons = 0;
            if (isset($fullBudgets[0]->cdstg4)) {
              $numOfSeasons = $numOfSeasons < 4 ? 4 : $numOfSeasons;
            }
            if (isset($fullBudgets[0]->cdstg3)) {
              $numOfSeasons = $numOfSeasons < 3 ? 3 : $numOfSeasons;
            }
            if (isset($fullBudgets[0]->cdstg2)) {
              $numOfSeasons = $numOfSeasons < 2 ? 2 : $numOfSeasons;
            }
            if (isset($fullBudgets[0]->cdstg1)) {
              $numOfSeasons = $numOfSeasons < 1 ? 1 : $numOfSeasons;
            }
            // Get number of season 0 columns
            $hideBudget = !isset($fullBudgets[0]->valbdg) || !isset($fullBudgets[0]->qtabdg);
            $hideTarget = !isset($fullBudgets[0]->valtrg) || !isset($fullBudgets[0]->qtatrg);

            $nulist   = $this->utility->getDefaultNulistFromCustomer($data->tpanag, $data->cdanag);
            $lstest   = Lstest::findFirstByNulist($nulist);
            $currency = $this->utility->getCurrencySymbol($lstest->cdvalu);

            if ($type == 0) {
              $isLineSorting = true;
              $title = $this->translate('_common.line') . ' - ' . $this->translate('_common.drop');
            } else {
              $isLineSorting = false;
              $title = $this->translate('_common.drop') . ' - ' . $this->translate('_common.line');
            }

            $this->setBudgetHeader($activeSheet, $fullBudgets[0], $numOfSeasons, $title, $hideBudget, $hideTarget);
            $this->getBudgetForCustomerBody($activeSheet, $budget, $numOfSeasons, $addBrand, $currency, $isLineSorting, $hideBudget, $hideTarget);
          } else {
            $activeSheet->getStyle('A1')->applyFromArray(array('font' => array('bold' => true)));
            $activeSheet->getCell('A1')->setValue('account.budget.no');
          }
        }
      } catch (\Exception $e) {
        $this->logger->info(print_r($e->getMessage(), true));
      }

      set_time_limit(30);

      $spreadsheet->setActiveSheetIndex(0);
      $this->diskManager->saveBudgetExcel($spreadsheet, $filename);

      echo json_encode($filename . ".xlsx");
    }
  }

  public function execDownloadImageXlsTemplateAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      set_time_limit(0);
      ini_set('memory_limit', '2048M');

      $cdcata = $_POST['cdcata'];

      $articles = Ctarti::getAllArticlesWithImagesFromCatalog($cdcata);

      $spreadsheet = new Spreadsheet();
      $spreadsheet->getProperties()->setCreator('Sinergiattiva')->setTitle($this->translate('_common.images'));
      $spreadsheet->getActiveSheet()->getProtection()->setSheet(true);
      $spreadsheet->getActiveSheet()->setTitle($this->translate('_common.images'));

      $spreadsheet->setActiveSheetIndex(0);
      $activeSheet = $spreadsheet->getActiveSheet();

      $activeSheet->calculateColumnWidths();
      $activeSheet->getColumnDimension('A')->setAutoSize(true);
      $activeSheet->getCell('A1')->setValue(ucwords($this->translate('_common.type')));
      $activeSheet->getColumnDimension('B')->setAutoSize(true);
      $activeSheet->getCell('B1')->setValue(ucwords($this->translate('_common.code')));
      $activeSheet->getColumnDimension('C')->setAutoSize(true);
      $activeSheet->getCell('C1')->setValue(ucwords($this->translate('_common.description')));
      $activeSheet->getColumnDimension('D')->setAutoSize(true);
      $activeSheet->getCell('D1')->setValue(ucwords($this->translate('_common.image')) . ' 1');
      $activeSheet->getColumnDimension('E')->setAutoSize(true);
      $activeSheet->getCell('E1')->setValue(ucwords($this->translate('_common.image')) . ' 2');
      $activeSheet->getColumnDimension('F')->setAutoSize(true);
      $activeSheet->getCell('F1')->setValue(ucwords($this->translate('_common.image')) . ' 3');
      $activeSheet->getColumnDimension('G')->setAutoSize(true);
      $activeSheet->getCell('G1')->setValue(ucwords($this->translate('_common.image')) . ' 4');
      $activeSheet->getColumnDimension('H')->setAutoSize(true);
      $activeSheet->getCell('H1')->setValue(ucwords($this->translate('_common.image')) . ' 5');

      // Set all cells style
      $activeSheet->getStyle('A1:H1')->applyFromArray(
        array(
          'fill' => array(
            'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
            'color' => array('argb' => 'FFEEEEEE')
          ),
          'borders' => array(
            'allBorders' => array(
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
              'color' => array('argb' => 'FF606060'),
            ),
          ),
          'font' => array(
            'bold' => true
          ),
        )
      );

      $index = 2;
      if (count($articles) > 0) {
        $currentCdartn = $articles[0]->cdartn;
        $activeSheet->getCell('A2')->setValue($this->translate('_common.model'));
        $activeSheet->getCell('B2')->setValue($articles[0]->cdartn);
        $activeSheet->getCell('C2')->setValue($articles[0]->dsartn);
        $activeSheet->getCell('D2')->setValue($articles[0]->flimag_n1);
        $activeSheet->getCell('E2')->setValue($articles[0]->flimag_n2);
        $activeSheet->getCell('F2')->setValue($articles[0]->flimag_n3);
        $activeSheet->getCell('G2')->setValue($articles[0]->flimag_n4);
        $activeSheet->getCell('H2')->setValue($articles[0]->flimag_n5);
        $activeSheet->getCell('I2')->setValue('cdartn');
        $index = 3;

        foreach ($articles as $article) {
          if ($article->cdartn != $currentCdartn) {
            $currentCdartn = $article->cdartn;
            $activeSheet->getCell('A' . $index)->setValue($this->translate('_common.model'));
            $activeSheet->getCell('B' . $index)->setValue($article->cdartn);
            $activeSheet->getCell('C' . $index)->setValue($article->dsartn);
            $activeSheet->getCell('D' . $index)->setValue($article->flimag_n1);
            $activeSheet->getCell('E' . $index)->setValue($article->flimag_n2);
            $activeSheet->getCell('F' . $index)->setValue($article->flimag_n3);
            $activeSheet->getCell('G' . $index)->setValue($article->flimag_n4);
            $activeSheet->getCell('H' . $index)->setValue($article->flimag_n5);
            $activeSheet->getCell('I' . $index)->setValue('cdartn');
            $index++;
          }

          $activeSheet->getCell('A' . $index)->setValue($this->translate('_common.article'));
          $activeSheet->getCell('B' . $index)->setValue($article->cdarti);
          $activeSheet->getCell('C' . $index)->setValue($article->dsarti);
          $activeSheet->getCell('D' . $index)->setValue($article->flimag_i1);
          $activeSheet->getCell('E' . $index)->setValue($article->flimag_i2);
          $activeSheet->getCell('F' . $index)->setValue($article->flimag_i3);
          $activeSheet->getCell('G' . $index)->setValue($article->flimag_i4);
          $activeSheet->getCell('I' . $index)->setValue('cdarti');
          $index++;
        }
      }
      $activeSheet->getCell('I1')->setValue($cdcata);

      $activeSheet->getStyle('A2:C' . ($index - 1))->applyFromArray(
        array(
          'borders' => array(
            'allBorders' => array(
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
              'color' => array('argb' => 'FF606060'),
            ),
          )
        )
      );
      $activeSheet->getStyle('D2:H' . ($index - 1))->applyFromArray(
        array(
          'fill' => array(
            'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
            'color' => array('argb' => 'FFFFFF00')
          ),
          'borders' => array(
            'allBorders' => array(
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
              'color' => array('argb' => 'FF606060'),
            ),
          ),
          'font' => array(
            'bold' => true
          ),
        )
      );
      $activeSheet->getStyle('D2:H' . ($index - 1))->getProtection()->setLocked(\PhpOffice\PhpSpreadsheet\Style\Protection::PROTECTION_UNPROTECTED);
      $activeSheet->getStyle('I1:I' . ($index - 1))->applyFromArray(
        array(
          'font'  => array(
            'color' => array('rgb' => 'FFFFFF'),
          )
        )
      );
      // Reset active sheet to 0
      $spreadsheet->setActiveSheetIndex(0);
      $spreadsheet->getActiveSheet()->setSelectedCell('A1');

      $filename = 'imgxls_' . date('Ymd') . '_' . date('His');

      $this->diskManager->saveGenericExcel($spreadsheet, $filename, 'imgxls');

      set_time_limit(30);

      echo json_encode($filename . ".xlsx");
    }
  }

  public function execDownloadJoorXlsOrderAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      set_time_limit(0);

      $filename = 'error';

      try {
        $nuordc       = $_POST['nuordc'];
        $idlang       = $this->utility->getLanguage();

        // Get order
        $octest = Octest::getOrderForPdf($nuordc, $idlang);
        $discount = (1 - ($octest->anagra_scont1 / 100)) * (1 - ($octest->anagra_scont2 / 100)) * (1 - ($octest->anagra_scont3 / 100));

        // Get currency
        $currency = !empty(Lstest::findFirstByNulist($octest->nulist))
          ? Lstest::findFirstByNulist($octest->nulist)->cdvalu
          : 'EUR';

        $rows = Occorp::getOrderRowsForJoor($nuordc);
        $numRows  = count($rows);

        $spreadsheet = new Spreadsheet();
        $spreadsheet->getProperties()->setCreator('Sinergiattiva')->setTitle($this->translate('order.xls'));

        $spreadsheet->setActiveSheetIndex(0);
        $activeSheet = $spreadsheet->getActiveSheet();

        $headerFontStyle = array('name' => 'Helvetica Neue', 'size' => 12, 'color' => array('rgb' => 'FFFFFF'));
        $bodyFontStyle = array('name' => 'Helvetica Neue', 'size' => 12, 'color' => array('rgb' => '000000'));
        $headerFillBlackStyle = array('fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID, 'color' => array('rgb' => '000000'));
        $headerFillBrownStyle = array('fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID, 'color' => array('rgb' => 'BCA55B'));

        $activeSheet->getCell('A1')->setValue('Linesheet Name');
        $activeSheet->getStyle('A1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBrownStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_BOTTOM
          ),
        ));
        $activeSheet->getCell('B1')->setValue('Linesheet Code');
        $activeSheet->getStyle('B1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBlackStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER
          ),
        ));
        $activeSheet->getCell('C1')->setValue('Start Ship Date');
        $activeSheet->getStyle('C1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBlackStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_BOTTOM,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER
          ),
        ));
        $activeSheet->getCell('D1')->setValue('End Ship Date');
        $activeSheet->getStyle('D1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBlackStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_BOTTOM,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER
          ),
        ));
        $activeSheet->getCell('E1')->setValue('Season Name');
        $activeSheet->getStyle('E1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBrownStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER
          ),
        ));
        $activeSheet->getCell('F1')->setValue('Season Year');
        $activeSheet->getStyle('F1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBrownStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER
          ),
        ));
        $activeSheet->getCell('G1')->setValue('Season Code');
        $activeSheet->getStyle('G1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBlackStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_BOTTOM
          ),
        ));
        $activeSheet->getCell('H1')->setValue('Style Name');
        $activeSheet->getStyle('H1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBrownStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER
          ),
        ));
        $activeSheet->getCell('I1')->setValue('Style Number');
        $activeSheet->mergeCells('I1:J1');
        $activeSheet->getStyle('I1:J1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBrownStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER
          ),
        ));
        $activeSheet->getCell('K1')->setValue('Color Name');
        $activeSheet->getStyle('K1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBrownStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER
          ),
        ));
        $activeSheet->getCell('L1')->setValue('Color Code');
        $activeSheet->getStyle('L1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBlackStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER
          ),
        ));
        $activeSheet->getCell('M1')->setValue('Size Name');
        $activeSheet->getStyle('M1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBrownStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_BOTTOM
          ),
        ));
        $activeSheet->getCell('N1')->setValue('');
        $activeSheet->getStyle('N1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBrownStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_BOTTOM
          ),
        ));
        $activeSheet->getCell('O1')->setValue('Category1');
        $activeSheet->getStyle('O1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBrownStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_BOTTOM
          ),
        ));
        $activeSheet->getCell('P1')->setValue('Category2');
        $activeSheet->getStyle('P1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBrownStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER
          ),
        ));
        $activeSheet->getCell('Q1')->setValue('Description');
        $activeSheet->getCell('R1')->setValue('Fabrication');
        $activeSheet->getCell('S1')->setValue('Fabrication Code');
        $activeSheet->getCell('T1')->setValue('Materials');
        $activeSheet->getCell('U1')->setValue('Silhouette');
        $activeSheet->getCell('V1')->setValue('Silhouette Code');
        $activeSheet->getCell('W1')->setValue('Measurements');
        $activeSheet->getCell('X1')->setValue('Model Height');
        $activeSheet->getCell('Y1')->setValue('Heel Height');
        $activeSheet->getCell('Z1')->setValue('Source of Materials');
        $activeSheet->getCell('AA1')->setValue('Contains Fur?');
        $activeSheet->getCell('AB1')->setValue('Country Of Origin');
        $activeSheet->getStyle('Q1:AB1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBlackStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_BOTTOM
          ),
        ));
        $activeSheet->getCell('AC1')->setValue('Currency 1');
        $activeSheet->getStyle('AC1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBrownStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_BOTTOM,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER
          ),
        ));
        $activeSheet->getCell('AD1')->setValue('Price Type ID 1');
        $activeSheet->getStyle('AD1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBrownStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_BOTTOM
          ),
        ));
        $activeSheet->getCell('AE1')->setValue('Wholesale Price 1');
        $activeSheet->getStyle('AE1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBrownStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_BOTTOM
          ),
        ));
        $activeSheet->getCell('AF1')->setValue('Suggested Retail Price 1');
        $activeSheet->getStyle('AF1')->applyFromArray(array(
          'font' => $headerFontStyle,
          'fill' => $headerFillBlackStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER
          ),
        ));
        $activeSheet->getStyle('A2:AF' . (1 + $numRows))->applyFromArray(array(
          'font' => $bodyFontStyle,
          'alignment' => array(
            'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER
          ),
        ));

        for ($i = 0; $i < $numRows; $i++) {
          foreach ($rows[$i] as $key => $value) {
            if (!is_numeric($key)) {
              $activeSheet->getCell($key . ($i + 2))->setValue($value);
            }
          }
        }

        $activeSheet->calculateColumnWidths();
        $cellIterator = $activeSheet->getRowIterator()->current()->getCellIterator();
        $cellIterator->setIterateOnlyExistingCells(true);
        foreach ($cellIterator as $cell) {
          $activeSheet->getColumnDimension($cell->getColumn())->setAutoSize(true);
        }

        $activeSheet->setSelectedCell('A1');

        $filename = date('Ymd') . '_' . $nuordc . '_joor';

        $this->diskManager->saveOrderExcel($spreadsheet, $filename);
      } catch (\Exception $e) {
        $this->logger->info(print_r($e->getMessage(), true));
      }

      set_time_limit(30);

      echo json_encode($filename . ".xlsx");
    }
  }

  public function execDownloadXlsTemplateFromOrderListAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      set_time_limit(0);

      $filename = 'error';

      try {
        $nuordc       = $_POST['nuordc'];
        $permissions  = $_POST['permissions'];
        $idlang       = $this->utility->getLanguage();
        $xlsType      = $this->utility->getAppSettings('OrderExcelTypeFromOrderList');

        // Get order
        $octest = Octest::getOrderForPdf($nuordc, $idlang);
        if ($octest->flnosc == 0) {
          $discount = (1 - ($octest->anagra_scont1 / 100)) * (1 - ($octest->anagra_scont2 / 100)) * (1 - ($octest->anagra_scont3 / 100));
        } else {
          $discount = 1;
        }

        // Get currency
        $currency = !empty(Lstest::findFirstByNulist($octest->nulist))
          ? Lstest::findFirstByNulist($octest->nulist)->cdvalu
          : 'EUR';

        // Get customer
        $anagra = Anagra::getCustomerForPdf($octest->tpanag, $octest->cdanag, $idlang);

        // We need only indiri, ccitta, etc. so if there isn't a selected desmer, take anagra
        $desmer = $octest->cddesm > 0
          ? Desmer::getShippingForPdf($octest->tpanag, $octest->cdanag, $octest->cddesm)
          : $anagra;

        switch ($xlsType) {
          case 0:
          case 1:
            $sizes  = Postgl::getAllSizesFromOrder($nuordc);
            $occorp = Occorp::getOrderRowsForXls($nuordc);
            $categories = Occorp::getXlsCategoriesRows($nuordc, $idlang);
            break;
          case 2:
            $sizes  = Postgl::getAllSizesFromOrder($nuordc);
            $occorp = Occorp::getZanottiOrderRowsForXls($nuordc);
            $categories = Occorp::getXlsCategoriesRows($nuordc, $idlang);
            break;
          case 3:
            $sizes  = Postgl::getAllSizesFromConfiguratorOrder($nuordc);
            $occorp = Occorp::getOrderRowsForXlsConfigurator($nuordc);
            $categories = Occorp::getXlsCategoriesRowsForConfigurator($nuordc, $idlang);
            break;
        }

        $rows = array();
        if (count($occorp) > 0) {
          foreach ($occorp as $row) {
            $row = (object)$row;
            $row->octagl = $xlsType != 3 || $row->cdcolo != 'CUSTOM'
              ? Octagl::getSizeQuantitiesForOrderDetail($row->nurorc)
              : Octagl::getSizeQuantitiesForOrderDetailConfigurator($row->nurorc);
            $row->prezzo = count($row->octagl) > 0 ? $row->octagl[0]->prezzo : 0;
            $row->totale = $row->prezzo * $row->quanti;
            $row->variants = '';
            if ($row->cdvari != '') {
              $variants = str_split($row->cdvari);
              foreach ($variants as $cdvari) {
                $variant = Tabvar::getCustomFromCdvariAndCdcata($cdvari, $octest->cdcata);
                $row->variants .= $variant->cdvari . ' - ' . $variant->dsvari . ', ';
              }
              $row->variants = substr($row->variants, 0, -2);
            }
            if ($xlsType == 3) {
              $row->components = array();
              if ($row->cdcolo != 'CUSTOM') {
                if ($row->cdarti == $row->cdartn) {
                  $row->components = Spmate::getDefaultMaterialTypes($row->cdartn);
                } else {
                  $row->components = Smcorp::getAllComponents($row->cdarti);
                }
              } else {
                $row->components = Ocperc::getAllComponents($row->cdarti);
              }
            }
            $rows[] = $row;
          }
        }

        $numSizes = count($sizes);
        $numRows  = count($rows);

        $spreadsheet = new Spreadsheet();
        $spreadsheet->getProperties()->setCreator('Sinergiattiva')->setTitle($this->translate('order.xls'));
        $spreadsheet->getActiveSheet()->getProtection()->setSheet(true);

        switch ($xlsType) {
          case 0:
            // Calculate max number of sizes
            $numSizes = 0;
            foreach ($rows as $row) {
              $countSizes = count($row->octagl);
              $numSizes = $countSizes > $numSizes ? $countSizes : $numSizes;
            }
            $offset = 9;
            $numAdditionalColumns = 3;
            break;
          case 1:
            $offset = 10;
            $numAdditionalColumns = 4;
            break;
          case 2:
            $offset = 10;
            $numAdditionalColumns = 2;
            break;
          case 3:
            $offset = 7;
            $numAdditionalColumns = 4;
            break;
        }
        $columns = $offset + $numSizes + $numAdditionalColumns;
        $totColumnName      = $this->utility->getNameFromNumber($columns);
        $lastSizeColumnName = $this->utility->getNameFromNumber($columns - ($xlsType == 0 ? 4 : 5));

        $spreadsheet->setActiveSheetIndex(0);
        $activeSheet = $spreadsheet->getActiveSheet();

        $activeSheet->setTitle($this->translate('_common.ordernumber.short') . ' ' . $nuordc);

        // Set styles
        $this->setStylesForOrderListXls($activeSheet, $totColumnName, $lastSizeColumnName, $offset, $numRows, $numSizes, $xlsType);

        // Set column widths
        $this->setColumnWidthsForOrderListXls($activeSheet, $offset, $columns, $xlsType);

        // Order header info
        $this->fillOrderHeaderInfoForOrderListXls($activeSheet, $octest, $desmer, $xlsType);

        // Rows header
        $this->fillRowsHeaderForOrderListXls($activeSheet, $offset, $numSizes, $sizes, $currency, $permissions, $xlsType);

        // Set rows
        $this->fillOrderRowsForOrderListXls($activeSheet, $offset, $numRows, $numSizes, $rows, $sizes, $discount, $permissions, $xlsType);

        // Drawing second worksheet
        $spreadsheet->createSheet();
        $activeSheet = $spreadsheet->setActiveSheetIndex(1);
        $activeSheet->getProtection()->setSheet(true);
        $titleSh2 = ucwords($this->translate('cart.footer.summary'));
        $activeSheet->setTitle($titleSh2);

        $headerStyle = array(
          'fill' => array(
            'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
            'color' => array('rgb' => 'EEEEEE')
          ),
          'borders' => array(
            'allBorders' => array(
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
              'color' => array('argb' => 'FF606060'),
            ),
          ),
          'font' => array(
            'bold' => true
          ),
          'alignment' => array(
            'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT
          ),
        );
        $activeSheet->getStyle('A1:E1')->applyFromArray($headerStyle);
        $activeSheet->getStyle('C' . (count($categories) + 2) . ':E' . (count($categories) + 2))->applyFromArray($headerStyle);

        $h_align = array('alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT));
        $activeSheet->getStyle('D2:E' . (count($categories) + 2))->applyFromArray($h_align);

        // Set all cells style
        $activeSheet->getStyle('A2:E' . (count($categories) + 1))->applyFromArray(
          array(
            'borders' => array(
              'allBorders' => array(
                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                'color' => array('argb' => 'FF606060'),
              ),
            )
          )
        );

        // Set column widths
        $activeSheet->calculateColumnWidths();
        $activeSheet->getColumnDimension('A')->setAutoSize(true);
        $activeSheet->getColumnDimension('B')->setAutoSize(true);
        $activeSheet->getColumnDimension('C')->setAutoSize(true);
        $activeSheet->getColumnDimension('D')->setAutoSize(true);
        $activeSheet->getColumnDimension('E')->setAutoSize(true);

        $activeSheet->getCell('A1')->setValue(ucwords($this->translate('_common.brand')));
        $activeSheet->getCell('B1')->setValue(ucwords($this->translate('_common.line')));
        $activeSheet->getCell('C1')->setValue(ucwords($this->translate('_common.series')));
        $activeSheet->getCell('D1')->setValue(ucwords($this->translate('cart.footer.total')));
        $activeSheet->getCell('E1')->setValue(ucwords($this->translate('pdf.total.taxable') . ' (' . $currency . ')'));
        $activeSheet->getCell('C' . (count($categories) + 2))->setValue(ucwords($this->translate('_common.total')));

        $fixedTab = "'" . $this->translate('_common.ordernumber.short') . ' ' . $nuordc . "'!";
        $qtyCol = $fixedTab;
        $prcCol = $fixedTab;
        $realNumRows = ($xlsType == 0 ? 3 : 1) * $numRows;
        if ($xlsType == 2) {
          $qtyCol .= $this->utility->getNameFromNumber($offset + $numSizes + 1) . '7:';
          $qtyCol .= $this->utility->getNameFromNumber($offset + $numSizes + 1) . ($realNumRows + 6);
          $prcCol .= $this->utility->getNameFromNumber($offset + $numSizes + 2) . '7:';
          $prcCol .= $this->utility->getNameFromNumber($offset + $numSizes + 2) . ($realNumRows + 6);
          $ct1Sh1 = $fixedTab . "I7:I" . ($realNumRows + 6);
          $ct2Sh1 = $fixedTab . "J7:J" . ($realNumRows + 6);
        } else if ($xlsType == 3) {
          $qtyCol .= $this->utility->getNameFromNumber($offset + $numSizes + ($xlsType == 0 ? 0 : 1)) . '8:';
          $qtyCol .= $this->utility->getNameFromNumber($offset + $numSizes + ($xlsType == 0 ? 0 : 1)) . ($realNumRows + 7);
          $prcCol .= $this->utility->getNameFromNumber($offset + $numSizes + ($xlsType == 0 ? 1 : 2)) . '8:';
          $prcCol .= $this->utility->getNameFromNumber($offset + $numSizes + ($xlsType == 0 ? 1 : 2)) . ($realNumRows + 7);
          $ct1Sh1 = $fixedTab . "E8:E" . ($realNumRows + 7);
          $ct2Sh1 = $fixedTab . "F8:F" . ($realNumRows + 7);
        } else {
          $qtyCol .= $this->utility->getNameFromNumber($offset + $numSizes + ($xlsType == 0 ? 0 : 1)) . '8:';
          $qtyCol .= $this->utility->getNameFromNumber($offset + $numSizes + ($xlsType == 0 ? 0 : 1)) . ($realNumRows + 7);
          $prcCol .= $this->utility->getNameFromNumber($offset + $numSizes + ($xlsType == 0 ? 1 : 2)) . '8:';
          $prcCol .= $this->utility->getNameFromNumber($offset + $numSizes + ($xlsType == 0 ? 1 : 2)) . ($realNumRows + 7);
          $ct1Sh1 = $fixedTab . ($xlsType == 0 ? "F8:F" : "G8:G") . ($realNumRows + 7);
          $ct2Sh1 = $fixedTab . ($xlsType == 0 ? "G8:G" : "H8:H") . ($realNumRows + 7);
          $ct3Sh1 = $fixedTab . ($xlsType == 0 ? "H8:H" : "I8:I") . ($realNumRows + 7);
        }

        for ($i = 0; $i < count($categories); $i++) {
          $category = is_array($categories[$i]) ? json_decode(json_encode($categories[$i]), FALSE) : $categories[$i];
          $secondFixedTab = "'" . ucwords($this->translate('cart.footer.summary')) . "'!";
          if ($xlsType != 2 && $xlsType != 3) {
            $ct1Sh2 = $secondFixedTab . "A" . ($i + 2);
            $ct2Sh2 = $secondFixedTab . "B" . ($i + 2);
            $ct3Sh2 = $secondFixedTab . "C" . ($i + 2);
            $cond1  = $ct1Sh1 . ',' . $ct1Sh2;
            $cond2  = $ct2Sh1 . ',' . $ct2Sh2;
            $cond3  = $ct3Sh1 . ',' . $ct3Sh2;
          } else {
            $ct1Sh2 = $secondFixedTab . "B" . ($i + 2);
            $ct2Sh2 = $secondFixedTab . "C" . ($i + 2);
            $ct3Sh2 = '';
            $cond1  = $ct1Sh1 . ',' . $ct1Sh2;
            $cond2  = $ct2Sh1 . ',' . $ct2Sh2;
            $cond3  = '';
          }
          $qtyFormula = '=SUMIFS(' . $qtyCol . ',' . $cond1 . ',' . $cond2 . ($xlsType != 2 && $xlsType != 3 && $category->dsserm != '' ?  ',' . $cond3 : '') . ')';
          $prcFormula = '=SUMIFS(' . $prcCol . ',' . $cond1 . ',' . $cond2 . ($xlsType != 2 && $xlsType != 3 && $category->dsserm != '' ?  ',' . $cond3 : '') . ')';
          $activeSheet->getCell('A' . ($i + 2))->setValue($category->dstitl);
          $activeSheet->getCell('B' . ($i + 2))->setValue($category->dslinm);
          $activeSheet->getCell('C' . ($i + 2))->setValue($category->dsserm);
          $activeSheet->getCell('D' . ($i + 2))->setValue($qtyFormula);
          $activeSheet->getCell('E' . ($i + 2))->setValue($prcFormula);
        }

        $sumQtyCells = '=SUM(D2:D' . (count($categories) + 1) . ')';
        $sumPrcCells = '=SUM(E2:E' . (count($categories) + 1) . ')';
        $activeSheet->getCell('D' . (count($categories) + 2))->setValue($sumQtyCells);
        $activeSheet->getCell('E' . (count($categories) + 2))->setValue($sumPrcCells);
        $activeSheet->getStyle('E2:E' . (count($categories) + 2))->getNumberFormat()->setFormatCode('#,##0.00');

        //$activeSheet->setAutoFilter('A1:E1');

        // Reset active sheet to 0
        $spreadsheet->setActiveSheetIndex(0);

        $filename = date('Ymd') . '_' . $nuordc . '_' . $octest->cdanag;

        $this->diskManager->saveOrderExcel($spreadsheet, $filename);
      } catch (\Exception $e) {
        $this->logger->info(print_r($e->getMessage(), true));
      }

      set_time_limit(30);

      echo json_encode($filename . ".xlsx");
    }
  }

  public function execDownloadXlsTemplateForNewOrderAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      set_time_limit(0);
      ini_set('memory_limit', '2048M');

      $cdcata = $_POST['cdcata'];
      $cdetic = $_POST['cdetic'];
      $tpanag = $_POST['tpanag'];
      $cdanag = $_POST['cdanag'];
      $cddesm = $_POST['cddesm'];
      $dtmcli = $_POST['dtmcli'];
      $filename = $_POST['filename'];

      $this->logger->info("Parametri acquisiti: $cdcata, $cdetic, $tpanag, $cdanag, $cddesm, $dtmcli");

      $imgOnXls = $this->utility->getAppSettings('ImageOnXls');
      $isDefault = $this->utility->getAppSettings('OrderExcelType') == 0;
      $isPT   = !empty(Tipolo::findFirstByTppers('PT'));
      $idlang = $this->utility->getLanguage();

      $nulist = $this->utility->getDefaultNulistFromCustomer($tpanag, $cdanag);
      $categories = Ctarti::getXlsCategoriesRows($cdcata, $idlang);

      // Get currency
      $currency = !empty(Lstest::findFirstByNulist($nulist)) ? Lstest::findFirstByNulist($nulist)->cdvalu : 'EUR';

      $cttest = Cttest::findFirstByCdcata($cdcata);
      $anagra = Anagra::findCustomerByKey($tpanag, $cdanag);
      $anaeti = $cdetic != -1
        ? Anaeti::findFirstByCdetic($cdetic)
        : null;

      // We need only indiri, ccitta, etc. so if there isn't a selected desmer, take anagra
      $desmer = $cddesm != -1
        ? Desmer::findFirst(array(
          'tpanag = :tpanag: AND cddesm = :cddesm: AND cdanag = :cdanag:',
          'bind' => array('tpanag' => $tpanag, 'cddesm' => $cddesm, 'cdanag' => $cdanag)
        ))
        : $anagra;

      $pieces = explode('-', $dtmcli);
      $rev_dtmcli = $pieces[2] . '/' . $pieces[1] . '/' . $pieces[0];

      $spreadsheet = new Spreadsheet();
      $spreadsheet->getProperties()->setCreator('Sinergiattiva')->setTitle($this->translate('order.xls'));
      $spreadsheet->getActiveSheet()->getProtection()->setSheet(true);

      $spreadsheet->setActiveSheetIndex(0);
      $activeSheet = $spreadsheet->getActiveSheet();

      if ($isDefault) {
        $sizes    = Postgl::getAllSizesFromCatalog($cdcata);
        $rows     = $this->getDefaultXlsTemplateRows($cdcata, $nulist, $sizes, $isPT);

        $offset   = !$isPT ? 10 : 12;
        $numRows  = count($rows);
        $numSizes = count($sizes);
        $columns  = $offset + $numSizes + 2;
        $activeSheet->freezePane('E7');
      } else {
        $rows     = $this->getSpecialXlsTemplateRows($cdcata, $nulist, $isPT);

        // Calculate max number of sizes
        $numSizes = 0;
        foreach ($rows as $row) {
          $countSizes = count($row->sizes);
          $numSizes = $countSizes > $numSizes ? $countSizes : $numSizes;
        }

        $offset   = !$isPT ? 8 : 10;
        $columns  = $offset + $numSizes + 1;
        $numRows  = 3 * count($rows);
        $activeSheet->freezePane('D7');
      }

      $col_tot = $this->utility->getNameFromNumber($columns);

      $sanitized_dscata = $this->utility->sanitizeStringForXls($cttest->dscata);
      $activeSheet->setTitle(substr($sanitized_dscata, 0, 30));

      // Set styles
      $this->setStylesForNewOrderXls($activeSheet, $col_tot, $offset, $columns, $numRows, $numSizes, $cdetic, $isDefault);

      // Set column widths
      $this->setColumnWidthsForNewOrderXls($activeSheet, $offset, $columns, $numSizes, $imgOnXls, $isDefault);

      // Order header info
      $this->fillOrderHeaderInfoForNewOrderXls($activeSheet, $cttest, $anagra, $desmer, $anaeti, $dtmcli, $rev_dtmcli);

      // Fill header text
      if ($isDefault) {
        $this->fillRowsHeaderForDefaultNewOrderXls($activeSheet, $offset, $sizes, $currency, $isPT);
      } else {
        $this->fillRowsHeaderForSpecialNewOrderXls($activeSheet, $offset, $numSizes, $currency, $isPT);
      }

      $cellStyle = array(
        'fill' => array(
          'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
          'color' => array('rgb' => 'FFFF00')
        ),
        'font' => array(
          'bold' => true
        ),
      );

      $blanckCellStyle = array(
        'borders' => array(
          'inside' => array(
            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_NONE,
            'color' => array('rgb' => 'FFFFFF'),
          ),
        )
      );

      $qtyColPos = $isDefault ? $offset + $numSizes + 1 : $offset + $numSizes;
      $prcColPos = $isDefault ? $offset + $numSizes + 2 : $offset + $numSizes + 1;

      //$this->logger->info("Riga 1341: $qtyColPos, $prcColPos");

      for ($i = 0; $i < count($rows); $i++) {
        if ($isDefault) {
          $currRowIndex = $i + 7;

          $imgurl_arti = "img/model/" . $rows[$i]->flimag_i;
          $imgurl_artn = "img/model/" . $rows[$i]->flimag_n;
          $exist_i = !empty($rows[$i]->flimag_i) && file_exists($imgurl_arti);
          $exist_n = !empty($rows[$i]->flimag_n) && file_exists($imgurl_artn);
          if ($isPT) {
            $imgurl_artv = "img/model/" . $rows[$i]->flimag_v;
            $exist_v = !empty($rows[$i]->flimag_v) && file_exists($imgurl_artv);
          }

          if ($exist_i || $exist_n || ($isPT && $exist_v)) {
            // Create temporary folder for resized images
            if (!file_exists('img/temp/resize/model')) {
              if (!file_exists('img/temp/resize')) {
                if (!file_exists('img/temp')) {
                  mkdir('./img/temp', 0777, true);
                }
                mkdir('./img/temp/resize', 0777, true);
              }
              mkdir('./img/temp/resize/model', 0777, true);
            }

            // Copy image to temporary folder
            if ($exist_i) {
              $fullPath_i = $this->utility->resizeImageForExcel($imgurl_arti, "img/temp/resize/model/" . $rows[$i]->flimag_i)
                ? $imgurl_arti
                : "img/temp/resize/model/" . $rows[$i]->flimag_i;
            } else {
              $fullPath_i = "assets/img/default_model.jpg";
            }
            if ($exist_n) {
              $fullPath_n = $this->utility->resizeImageForExcel($imgurl_artn, "img/temp/resize/model/" . $rows[$i]->flimag_n)
                ? $imgurl_artn
                : "img/temp/resize/model/" . $rows[$i]->flimag_n;
            } else {
              $fullPath_n = "assets/img/default_model.jpg";
            }

            if ($isPT) {
              if ($exist_v) {
                $fullPath_v = $this->utility->resizeImageForExcel($imgurl_artv, "img/temp/resize/model/" . $rows[$i]->flimag_v)
                  ? $imgurl_artv
                  : "img/temp/resize/model/" . $rows[$i]->flimag_v;
              } else {
                $fullPath_v = "assets/img/default_model.jpg";
              }
            }

            $activeSheet->getRowDimension($currRowIndex)->setRowHeight(95);

            // flimag_n
            if ($exist_n && $imgOnXls == 0) {
              $objDrawing_n = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
              $objDrawing_n->setPath($fullPath_n);
              $objDrawing_n->setResizeProportional(true);
              $objDrawing_n->setCoordinates('A' . $currRowIndex);
              $objDrawing_n->setHeight(120);
              $objDrawing_n->setOffsetY(2);
              $objDrawing_n->setOffsetX(2);
              $objDrawing_n->setWorksheet($activeSheet);
            }

            // flimag_i
            if ($exist_i) {
              $objDrawing_i = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
              $objDrawing_i->setPath($fullPath_i);
              $objDrawing_i->setResizeProportional(true);
              $objDrawing_i->setCoordinates('A' . $currRowIndex);
              if ($imgOnXls == 0) {
                $objDrawing_i->setHeight(50);
                $objDrawing_i->setOffsetY(4);
                $objDrawing_i->setOffsetX(122);
              } else {
                $objDrawing_i->setHeight(120);
                $objDrawing_i->setOffsetY(2);
                $objDrawing_i->setOffsetX(2);
              }
              $objDrawing_i->setWorksheet($activeSheet);
            }

            if ($isPT && $exist_v) {
              // flimag_v
              $objDrawing_v = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
              $objDrawing_v->setPath($fullPath_v);
              $objDrawing_v->setResizeProportional(true);
              $objDrawing_v->setCoordinates('A' . $currRowIndex);
              $objDrawing_v->setHeight(50);
              $objDrawing_v->setOffsetY(70);
              $objDrawing_v->setOffsetX(122);
              $objDrawing_v->setWorksheet($activeSheet);
            }
          }

          $activeSheet->getCell('B' . $currRowIndex)->setValue($rows[$i]->dsarti);
          $activeSheet->getCell('C' . $currRowIndex)->setValue($rows[$i]->cdarti);
          $activeSheet->getCell('D' . $currRowIndex)->setValue(!$isPT ? $rows[$i]->dscolo_i : $rows[$i]->dscolo_v);
          $activeSheet->getCell('E' . $currRowIndex)->setValue(!$isPT ? $rows[$i]->cdcolo_i : $rows[$i]->cdcolo_v);
          $activeSheet->getCell('F' . $currRowIndex)->setValue(!$isPT ? $rows[$i]->dscomm_i . " " . $rows[$i]->dscomm_n : $rows[$i]->cdvari);
          $activeSheet->getCell('G' . $currRowIndex)->setValue(!$isPT ? $rows[$i]->dstitl : $rows[$i]->dsvari);
          $activeSheet->getCell('H' . $currRowIndex)->setValue(!$isPT ? $rows[$i]->dslinm : $rows[$i]->dscomm_i . " " . $rows[$i]->dscomm_n);
          $activeSheet->getCell('I' . $currRowIndex)->setValue(!$isPT ? $rows[$i]->dsserm : $rows[$i]->dstitl);
          $activeSheet->getCell('J' . $currRowIndex)->setValue(!$isPT ? $rows[$i]->cdtagl : $rows[$i]->dslinm);

          if ($isPT) {
            $activeSheet->getCell('K' . $currRowIndex)->setValue($rows[$i]->dsserm);
            $activeSheet->getCell('L' . $currRowIndex)->setValue($rows[$i]->cdtagl);
          }
        } else {
          $currRowIndex = 3 * $i + 7;
          $priceRowIndex = $currRowIndex + 1;
          $sizeRowIndex = $priceRowIndex + 1;

          $activeSheet->getCell('A' . $currRowIndex)->setValue($rows[$i]->cdarti);
          $activeSheet->getCell('B' . $currRowIndex)->setValue($rows[$i]->dsarti);
          $activeSheet->getCell('C' . $currRowIndex)->setValue(!$isPT ? $rows[$i]->dscolo_i : $rows[$i]->dscolo_v);

          $activeSheet->getCell('D' . $currRowIndex)->setValue(!$isPT ? $rows[$i]->cdcolo_i : $rows[$i]->cdcolo_v);
          //$activeSheet->getCell('E' . $currRowIndex)->setValue(!$isPT ? $rows[$i]->dscomm_i . " " . $rows[$i]->dscomm_n : $rows[$i]->cdvari);
          $activeSheet->getCell('E' . $currRowIndex)->setValue(!$isPT ? $rows[$i]->dstitl : $rows[$i]->dsvari);
          $activeSheet->getCell('F' . $currRowIndex)->setValue(!$isPT ? $rows[$i]->dslinm : $rows[$i]->dscomm_i . " " . $rows[$i]->dscomm_n);
          $activeSheet->getCell('G' . $currRowIndex)->setValue(!$isPT ? $rows[$i]->dsserm : $rows[$i]->dstitl);
          $activeSheet->getCell('H' . $currRowIndex)->setValue(!$isPT ? $rows[$i]->cdtagl : $rows[$i]->dslinm);

          if ($isPT) {
            $activeSheet->getCell('I' . $currRowIndex)->setValue($rows[$i]->dsserm);
            $activeSheet->getCell('L' . $currRowIndex)->setValue($rows[$i]->cdtagl);
          }
        }

        if ($rows[$i]->catalogPrice > 0 || !$isDefault) {
          $size_index = 0;
          foreach ($rows[$i]->sizes as $size) {
            if ($isDefault) {
              $cell = $this->utility->getNameFromNumber($offset + $size['sizePos']) . $currRowIndex;
            } else {
              $activeSheet->getCell($this->utility->getNameFromNumber($offset + $size_index) . $currRowIndex)->setValue($size->taglia);
              $activeSheet->getCell($this->utility->getNameFromNumber($offset + $size_index) . $priceRowIndex)->setValue($size->prezzo);
              $cell = $this->utility->getNameFromNumber($offset + $size_index) . $sizeRowIndex;
              $size_index++;
            }

            $activeSheet->getStyle($cell)->getProtection()->setLocked(\PhpOffice\PhpSpreadsheet\Style\Protection::PROTECTION_UNPROTECTED);
            $activeSheet->getStyle($cell)->applyFromArray($cellStyle);

            $objValidation = $activeSheet->getCell($cell)->getDataValidation();
            $objValidation->setType(\PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_WHOLE);
            //This Line
            $objValidation->setOperator(\PhpOffice\PhpSpreadsheet\Cell\DataValidation::OPERATOR_BETWEEN);

            $objValidation->setAllowBlank(true);
            $objValidation->setShowInputMessage(true);
            $objValidation->setShowErrorMessage(true);
            $objValidation->setErrorStyle(\PhpOffice\PhpSpreadsheet\Cell\DataValidation::STYLE_STOP);
            $objValidation->setErrorTitle($this->translate('_common.error'));
            $objValidation->setError($this->translate('excel.warning1'));
            $objValidation->setFormula1(0);
            $objValidation->setFormula2(999999);
            $objValidation->setAllowBlank(true);
            $activeSheet->getStyle($cell)->getNumberFormat()->setFormatCode('#');
          }

          /*
          $prdCells   = $this->utility->getNameFromNumber($offset + count($sizes)) . ($i + 7) . '*IF(ISBLANK(' . $totQty . '),0,' . $totQty . ')';
          $sumFormula = '=IF(' . $sumCells . '=0,"",' . $sumCells . ')';
          $prdFormula = '=IF(' . $prdCells . '=0,"",' . $prdCells . ')';
          */

          $totQty = $this->utility->getNameFromNumber($qtyColPos) . $currRowIndex;
          $totPrc = $this->utility->getNameFromNumber($prcColPos) . $currRowIndex;

          if ($isDefault) {
            $activeSheet->getCell($this->utility->getNameFromNumber($offset + $numSizes) . $currRowIndex)->setValue($rows[$i]->catalogPrice);
            $sumCells   = 'SUM(K' . $currRowIndex . ':' . $this->utility->getNameFromNumber($offset + $numSizes - 1) . $currRowIndex . ')';
            $prdFormula = '=' . $this->utility->getNameFromNumber($offset + $numSizes) . $currRowIndex . '*' . $totQty;
          } else {
            $sumCells   = 'SUM(' . $this->utility->getNameFromNumber($offset) . $sizeRowIndex . ':' . $this->utility->getNameFromNumber($offset + $numSizes - 1) . $sizeRowIndex . ')';
            $prdFormula   = '=SUMPRODUCT(' . $this->utility->getNameFromNumber($offset) . $sizeRowIndex . ':' . $this->utility->getNameFromNumber($offset + $numSizes - 1) . $sizeRowIndex . ',' .
              $this->utility->getNameFromNumber($offset) . $priceRowIndex . ':' . $this->utility->getNameFromNumber($offset + $numSizes - 1) . $priceRowIndex . ')';

            $fromCell = 'A' . $priceRowIndex;
            $toCell   = $this->utility->getNameFromNumber($offset - 1) . ($sizeRowIndex);
            $activeSheet->getStyle($fromCell . ':' . $toCell)->applyFromArray($blanckCellStyle);
            $activeSheet->getStyle($this->utility->getNameFromNumber($qtyColPos) . $priceRowIndex . ':' . $this->utility->getNameFromNumber($prcColPos) . $sizeRowIndex)->applyFromArray($blanckCellStyle);
          }

          $sumFormula = '=' . $sumCells;
          $activeSheet->getCell($totQty)->setValue($sumFormula);
          $activeSheet->getCell($totPrc)->setValue($prdFormula);
        }
      }

      if ($isDefault) {
        $uniPrcCol = $this->utility->getNameFromNumber($offset + $numSizes);
        $activeSheet->getStyle($uniPrcCol . '7:' . $uniPrcCol . ($numRows + 6))->getNumberFormat()->setFormatCode('#,##0.00');
      }

      $totPrcCol = $this->utility->getNameFromNumber($prcColPos);
      $activeSheet->getStyle($totPrcCol . '7:' . $totPrcCol . ($numRows + 6))->getNumberFormat()->setFormatCode('#,##0.00');

      $this->logger->info("Riga 1545: $totPrcCol");
      //$activeSheet->setAutoFilter('A6:' . $totPrcCol . '6');

      // Drawing second worksheet
      $spreadsheet->createSheet();
      $activeSheet = $spreadsheet->setActiveSheetIndex(1);
      $activeSheet->getProtection()->setSheet(true);
      $titleSh2 = ucwords($this->translate('cart.footer.summary'));
      $activeSheet->setTitle($titleSh2);

      $headerStyle = array(
        'fill' => array(
          'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
          'color' => array('rgb' => 'EEEEEE')
        ),
        'borders' => array(
          'allBorders' => array(
            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
            'color' => array('argb' => 'FF606060'),
          ),
        ),
        'font' => array(
          'bold' => true
        ),
      );
      $activeSheet->getStyle('A1:E1')->applyFromArray($headerStyle);
      $activeSheet->getStyle('C' . (count($categories) + 2) . ':E' . (count($categories) + 2))->applyFromArray($headerStyle);

      $h_align = array('alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT));
      $activeSheet->getStyle('D2:E' . (count($categories) + 3))->applyFromArray($h_align);

      // Set all cells style
      $activeSheet->getStyle('A2:E' . (count($categories) + 1))->applyFromArray(
        array(
          'borders' => array(
            'allBorders' => array(
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
              'color' => array('argb' => 'FF606060'),
            ),
          )
        )
      );

      // Set column widths
      $activeSheet->calculateColumnWidths();
      $activeSheet->getColumnDimension('A')->setAutoSize(true);
      $activeSheet->getColumnDimension('B')->setAutoSize(true);
      $activeSheet->getColumnDimension('C')->setAutoSize(true);
      $activeSheet->getColumnDimension('D')->setAutoSize(true);
      $activeSheet->getColumnDimension('E')->setAutoSize(true);

      $activeSheet->getCell('A1')->setValue(ucwords($this->translate('_common.brand')));
      $activeSheet->getCell('B1')->setValue(ucwords($this->translate('_common.line')));
      $activeSheet->getCell('C1')->setValue(ucwords($this->translate('_common.series')));
      $activeSheet->getCell('D1')->setValue(ucwords($this->translate('cart.footer.total')));
      $activeSheet->getCell('E1')->setValue(ucwords($this->translate('pdf.total.taxable') . ' (' . $currency . ')'));
      $activeSheet->getCell('C' . (count($categories) + 2))->setValue(ucwords($this->translate('_common.total')));

      $qtyCol = "'" . $sanitized_dscata . "'!";
      $qtyCol .= $this->utility->getNameFromNumber($qtyColPos) . '7:';
      $qtyCol .= $this->utility->getNameFromNumber($qtyColPos) . ($numRows + 6);
      $prcCol = "'" . $sanitized_dscata . "'!";
      $prcCol .= $this->utility->getNameFromNumber($prcColPos) . '7:';
      $prcCol .= $this->utility->getNameFromNumber($prcColPos) . ($numRows + 6);
      if ($isDefault) {
        $ct1Sh1 = "'" . $sanitized_dscata . "'!" . (!$isPT ? 'G7:G' : 'I7:I') . ($numRows + 6);
        $ct2Sh1 = "'" . $sanitized_dscata . "'!" . (!$isPT ? 'H7:H' : 'J7:J') . ($numRows + 6);
        $ct3Sh1 = "'" . $sanitized_dscata . "'!" . (!$isPT ? 'I7:I' : 'K7:K') . ($numRows + 6);
      } else {
        $ct1Sh1 = "'" . $sanitized_dscata . "'!" . (!$isPT ? 'E7:E' : 'G7:G') . ($numRows + 6);
        $ct2Sh1 = "'" . $sanitized_dscata . "'!" . (!$isPT ? 'F7:F' : 'H7:H') . ($numRows + 6);
        $ct3Sh1 = "'" . $sanitized_dscata . "'!" . (!$isPT ? 'G7:G' : 'I7:I') . ($numRows + 6);
      }

      for ($i = 0; $i < count($categories); $i++) {
        $ct1Sh2 = "'" . $titleSh2 . "'!A" . ($i + 2);
        $ct2Sh2 = "'" . $titleSh2 . "'!B" . ($i + 2);
        $ct3Sh2 = "'" . $titleSh2 . "'!C" . ($i + 2);
        $cond1  = $ct1Sh1 . ',' . $ct1Sh2;
        $cond2  = $ct2Sh1 . ',' . $ct2Sh2;
        $cond3  = $ct3Sh1 . ',' . $ct3Sh2;
        $activeSheet->getCell('A' . ($i + 2))->setValue($categories[$i]->dstitl);
        $activeSheet->getCell('B' . ($i + 2))->setValue($categories[$i]->dslinm);
        $activeSheet->getCell('C' . ($i + 2))->setValue($categories[$i]->dsserm);
        $activeSheet->getCell('D' . ($i + 2))->setValue('=SUMIFS(' . $qtyCol . ',' . $cond1 . ',' . $cond2 . ($categories[$i]->dsserm != '' ?  ',' . $cond3 : '') . ')');
        $activeSheet->getCell('E' . ($i + 2))->setValue('=SUMIFS(' . $prcCol . ',' . $cond1 . ',' . $cond2 . ($categories[$i]->dsserm != '' ?  ',' . $cond3 : '') . ')');
      }

      $sumQtyCells = '=SUM(D2:D' . (count($categories) + 1) . ')';
      $sumPrcCells = '=SUM(E2:E' . (count($categories) + 1) . ')';
      $activeSheet->getCell('D' . (count($categories) + 2))->setValue($sumQtyCells);
      $activeSheet->getCell('E' . (count($categories) + 2))->setValue($sumPrcCells);
      $activeSheet->getStyle('E2:E' . (count($categories) + 2))->getNumberFormat()->setFormatCode('#,##0.00');

      //$activeSheet->setAutoFilter('A1:E1');

      // Reset active sheet to 0
      $spreadsheet->setActiveSheetIndex(0);

      //$filename = 'template_' . date('Ymd') . '_' . date('His');

      $this->logger->info("Riga 1646: $filename");

      $this->diskManager->saveOrderExcel($spreadsheet, $filename);

      set_time_limit(30);

      echo json_encode($filename . ".xlsx");
    }
  }

  public function execDownloadSortingCatalogXlsAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      set_time_limit(0);
      ini_set('memory_limit', '2048M');

      $cdcata = $_POST['cdcata'];
      $models = json_decode($_POST['models']);

      $spreadsheet = new Spreadsheet();
      $spreadsheet->getProperties()->setCreator('Sinergiattiva')->setTitle($this->translate('_common.sorting'));
      $spreadsheet->getActiveSheet()->getProtection()->setSheet(true);

      $spreadsheet->setActiveSheetIndex(0);
      $activeSheet = $spreadsheet->getActiveSheet();

      $totRows = count($models) + 1;

      $activeSheet->calculateColumnWidths();
      $activeSheet->getColumnDimension('A')->setAutoSize(true);
      $activeSheet->getCell('A1')->setValue(ucwords($this->translate('_common.code.model')));
      $activeSheet->getColumnDimension('B')->setAutoSize(true);
      $activeSheet->getCell('B1')->setValue(ucwords($this->translate('_common.category')));
      $activeSheet->getColumnDimension('C')->setAutoSize(true);
      $activeSheet->getCell('C1')->setValue(ucwords($this->translate('_common.modeltype')));
      $activeSheet->getColumnDimension('D')->setAutoSize(true);
      $activeSheet->getCell('D1')->setValue(ucwords($this->translate('_common.sorting')) . ' (' . $this->translate('_common.default') . ')');
      if ($this->utility->getAppSettings('EnableCatalogSorting') == 2) {
        $activeSheet->getColumnDimension('E')->setAutoSize(true);
        $activeSheet->getCell('E1')->setValue(ucwords($this->translate('_common.sorting')) . ' (U.S.A.)');
      }

      // Set all cells style
      $lastColumn = $this->utility->getAppSettings('EnableCatalogSorting') == 2 ? 'E' : 'D';
      $activeSheet->getStyle('A1:' . $lastColumn . '1')->applyFromArray(
        array(
          'fill' => array(
            'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
            'color' => array('argb' => 'FFEEEEEE')
          ),
          'borders' => array(
            'allBorders' => array(
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
              'color' => array('argb' => 'FF606060'),
            ),
          ),
          'font' => array(
            'bold' => true
          ),
        )
      );
      $activeSheet->getStyle('A2:C' . $totRows)->applyFromArray(
        array(
          'borders' => array(
            'allBorders' => array(
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
              'color' => array('argb' => 'FF606060'),
            ),
          )
        )
      );
      $activeSheet->getStyle('D2:' . $lastColumn . $totRows)->applyFromArray(
        array(
          'fill' => array(
            'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
            'color' => array('argb' => 'FFFFFF00')
          ),
          'borders' => array(
            'allBorders' => array(
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
              'color' => array('argb' => 'FF606060'),
            ),
          ),
          'font' => array(
            'bold' => true
          ),
        )
      );
      $activeSheet->getStyle('F1')->applyFromArray(
        array(
          'font'  => array(
            'color' => array('rgb' => 'FFFFFF'),
          )
        )
      );
      $activeSheet->getCell('F1')->setValue($cdcata);

      for ($i = 0; $i < count($models); $i++) {
        $activeSheet->getCell('A' . ($i + 2))->setValue($models[$i][0]);
        $activeSheet->getCell('B' . ($i + 2))->setValue($models[$i][1]);
        $activeSheet->getCell('C' . ($i + 2))->setValue($models[$i][2]);

        $activeSheet->getCell('D' . ($i + 2))->setValue($models[$i][3]);
        $activeSheet->getStyle('D' . ($i + 2))->getProtection()->setLocked(\PhpOffice\PhpSpreadsheet\Style\Protection::PROTECTION_UNPROTECTED);

        $objValidation = $activeSheet->getCell('D' . ($i + 3))->getDataValidation();
        $objValidation->setType(\PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_WHOLE);
        //This Line
        $objValidation->setOperator(\PhpOffice\PhpSpreadsheet\Cell\DataValidation::OPERATOR_BETWEEN);

        $objValidation->setAllowBlank(true);
        $objValidation->setShowInputMessage(true);
        $objValidation->setShowErrorMessage(true);
        $objValidation->setErrorStyle(\PhpOffice\PhpSpreadsheet\Cell\DataValidation::STYLE_STOP);
        $objValidation->setErrorTitle($this->translate('_common.error'));
        $objValidation->setError($this->translate('excel.warning1'));
        $objValidation->setFormula1(0);
        $objValidation->setFormula2(999999);
        $objValidation->setAllowBlank(true);
        $activeSheet->getStyle('D' . ($i + 3))->getNumberFormat()->setFormatCode('#');
        if ($this->utility->getAppSettings('EnableCatalogSorting') == 2) {
          $activeSheet->getCell('E' . ($i + 3))->setValue($models[$i][4]);
          $activeSheet->getStyle('E' . ($i + 3))->getProtection()->setLocked(\PhpOffice\PhpSpreadsheet\Style\Protection::PROTECTION_UNPROTECTED);

          $objValidation = $activeSheet->getCell('E' . ($i + 3))->getDataValidation();
          $objValidation->setType(\PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_WHOLE);
          //This Line
          $objValidation->setOperator(\PhpOffice\PhpSpreadsheet\Cell\DataValidation::OPERATOR_BETWEEN);

          $objValidation->setAllowBlank(true);
          $objValidation->setShowInputMessage(true);
          $objValidation->setShowErrorMessage(true);
          $objValidation->setErrorStyle(\PhpOffice\PhpSpreadsheet\Cell\DataValidation::STYLE_STOP);
          $objValidation->setErrorTitle($this->translate('_common.error'));
          $objValidation->setError($this->translate('excel.warning1'));
          $objValidation->setFormula1(0);
          $objValidation->setFormula2(999999);
          $objValidation->setAllowBlank(true);
          $activeSheet->getStyle('E' . ($i + 3))->getNumberFormat()->setFormatCode('#');
        }
      }

      // Reset active sheet to 0
      $spreadsheet->setActiveSheetIndex(0);

      $filename = 'sorting_' . date('Ymd') . '_' . date('His');

      $this->diskManager->saveGenericExcel($spreadsheet, $filename, 'sorting');

      set_time_limit(30);

      echo json_encode($filename . ".xlsx");
    }
  }

  public function uploadCompiledXlsForCartAction() {
    $this->view->disable();

    $id_usr = $this->session->get('auth')['id'];
    $common = $this->utility->getCommonData('catalog', $id_usr);

    if (!empty($_FILES) && isset($_FILES['file']) && $common['isOrder']) {

      $tempFile = $_FILES['file']['tmp_name'];          //3
      $targetPath = "./io/template/cart/";  //4

      if (!is_dir("./io/template") && !mkdir("./io/template", 0777, true)) {
        die("Error creating folder $targetPath");
        if (!is_dir("./io/template/cart") && !mkdir("./io/template/cart", 0777, true)) {
          die("Error creating folder $targetPath");
        }
      }
      $targetFile =  $targetPath . $_FILES['file']['name'];  //5
      move_uploaded_file($tempFile, $targetFile); //6
      chmod($targetFile, 0777);

      // Read Excel workbook
      try {
        $inputFileType  = \PhpOffice\PhpSpreadsheet\IOFactory::identify($targetFile);
        $objReader      = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);

        $sheetnames = $objReader->listWorksheetNames($targetFile);
        $objReader->setLoadSheetsOnly($sheetnames[0]);
        $spreadsheet = $objReader->load($targetFile);
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

        $areThereRows = count($sheetData) > 1;
        $startData    = $sheetData[1];
        $startIndex   = 2;

        if ($areThereRows) {
          $order  = $common['order_info'];
          $nuordc = $order->nuordc;
          $errors = array();

          foreach ($sheetData as $rowIndex => $rowValue) {
            // salto la prima riga visto che è quella dei titoli e anche le righe vuote
            if ($rowIndex >= $startIndex && !empty(array_filter($rowValue))) {
              $nurorc   = -1;
              $cdarti   = $rowValue['A'];
              $cdartn   = "";
              $cdcolo   = "";
              $cdcata   = $order->cdcata;
              $dstagl   = $rowValue['C'];
              $quanti   = is_numeric($rowValue['D']) ? $rowValue['D'] : 0;
              $prezzo   = (!empty($rowValue['E']) && is_numeric(str_replace(',', '.', $rowValue['E']))) ? $rowValue['E'] : 0;
              $scont_raw = str_replace('%', '', $rowValue['F']);
              $scont1   = (!empty($scont_raw) && is_numeric(str_replace(',', '.', $scont_raw))) ? $scont_raw : 0;
              $dtmcli   = !empty($order->dtmcli) && $order->dtmcli != '1970-01-01' ? $order->dtmcli : "0000-00-00";
              $tot_quanti = $quanti;
              $flag_new_line = false;

              $cdvari   = "";
              $seqdet   = 1;
              $sgrifc   = "";
              $indorc   = "";
              $dsnoco   = "";

              if (Anaart::findFirstByCdarti($cdarti) === false){
                $errors[$rowIndex] = $this->translate('cart.xls.error.notfound');
                continue;
              } else {
                $cdartn = Anaart::findFirstByCdarti($cdarti)->cdartn;
              }

              $taglie   = Postgl::getAllSizes(Tipolo::findFirstByCdartn($cdartn)->cdtagl);
              $size_found = false;
              foreach($taglie as $tgl){
                if ($tgl['taglia'] == $dstagl){
                  $size_found = true;
                  break;
                }
              }
              if (!$size_found){
                $errors[$rowIndex] = $this->translate('cart.xls.error.diffsize');
                continue;
              }

              $ord_row  = Occorp::getOrderRow($nuordc, $cdcata, $cdarti);
              // Possibili casi per cui può tornare false: articolo non esistente o non presente
              // in questo catalogo
              if ($ord_row){
                $nurorc   = $ord_row->nurorc;
                $cdcolo   = $ord_row->cdcolo;
                $tot_quanti = $ord_row->quanti + $quanti;
              } else {
                $errors[$rowIndex] = $this->translate('cart.xls.error.notincata');
                continue;
              }

              // If you have already this line, take it
              if ($nurorc != -1) {
                $occorp = Occorp::findFirst(array('nuordc = :nuordc: AND nurorc = :nurorc:', 'bind' => array('nuordc' => $nuordc, 'nurorc' => $nurorc)));
              } else {
                $occorp = false;
              }

              // If you don't have already this line, create a new one with a seqrap (nurorc is AUTO_INCREMENT)
              if (!$occorp) {
                $occorp = new Occorp ();
                $occorp->nuordc = $nuordc;
                $seqrap = Occorp::getMaxIndexForOrder($nuordc);
                $occorp->seqrap = $seqrap + 1;

                $flag_new_line = true;
              }

              $occorp->cdarti   = $cdarti;
              $occorp->seqdet   = $seqdet;
              $occorp->cdcolo   = $cdcolo != '' ? $cdcolo : new RawValue('""');
              $occorp->cdvari   = $cdvari != '' ? $cdvari : new RawValue('""');
              $occorp->cdcata   = $cdcata;
              $occorp->quanti   = $tot_quanti;
              $occorp->dsnoco   = $dsnoco != '' ? $dsnoco : new RawValue('""');
              $occorp->indorc   = $indorc != '' ? $indorc : new RawValue('""');
              $occorp->sgrifc   = $sgrifc != '' ? $sgrifc : new RawValue('""');
              $occorp->dtmcli   = $dtmcli;

              if ($occorp->save() === false) {
                $errors[$rowIndex] = $this->translate('cart.xls.error.saverow');
                continue;
              }
              // Aggiorno nurorc nel caso prima fosse a 0
              $nurorc = $occorp->nurorc;

              if($flag_new_line){
                $sizes = Postgl::getSizesWithPricesFromNurorc($nurorc);
                Octagl::initializeSizesStructure($nurorc, $sizes);
              }

              Octagl::updateSizeQuantity($nurorc, $dstagl, $quanti, false);
              if ($prezzo != 0){Octagl::updateSizePrice($nurorc, $dstagl, $prezzo);}
              if ($scont1 != 0){Octagl::updateSizeQuantityDiscountForNurorc($nurorc, 'scont1', $scont1);}
            }
          }
        }
        if (count($errors) > 0){
          $msg = $this->translate('cart.xls.error', array('count' => count($errors)));
          foreach ($errors as $key => $err) {
            $msg .= "\n [".$this->translate('cart.xls.rowerror', array('row' => $key, 'msg' => $err))."]";
          }
          $this->logger->info($msg);
          $this->flashSession->error($msg);
        } else {
          $msg = $this->translate('cart.xls.success');
          $this->flashSession->success($msg);
        }

        return $this->response->redirect('cart/index');
      } catch (\Exception $e) {
        $this->logger->info('Error loading file: '.$e->getMessage());
        die('Error loading file "' . pathinfo($targetFile, PATHINFO_BASENAME) . '": ' . $e->getMessage());
      }
    }
  }

  public function uploadCompiledXlsTemplateFromOrderListAction() {
    $this->view->disable();

    if (!empty($_FILES)) {
      $this->handleUploadedXlsTemplate(false);
    }
  }

  public function uploadCompiledXlsTemplateFromAdminAction() {
    $this->view->disable();

    if (!empty($_FILES)) {
      $this->handleUploadedXlsTemplate(true);
    }
  }

  public function uploadCompiledXlsTemplateForNewOrderAction() {
    $this->view->disable();

    if (!empty($_FILES)) {
      $tempFile = $_FILES['file']['tmp_name'];
      $isDefault = $this->utility->getAppSettings('OrderExcelType') == 0;

      if (!file_exists('./io/template/compiled')) {
        mkdir('./io/template/compiled', 0777, true);
      }

      $targetPath = "./io/template/compiled/";
      if (!is_dir($targetPath) && !mkdir($targetPath)) {
        die("Error creating folder $targetPath");
      }
      $targetFile = $targetPath . $_FILES['file']['name'];

      move_uploaded_file($tempFile, $targetFile);

      //  Read Excel workbook
      try {
        $inputFileType  = \PhpOffice\PhpSpreadsheet\IOFactory::identify($targetFile);
        $objReader      = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);

        $sheetnames = $objReader->listWorksheetNames($targetFile);
        $objReader->setLoadSheetsOnly($sheetnames[0]);
        $spreadsheet = $objReader->load($targetFile);
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

        $isPT = !empty(Tipolo::findFirstByTppers('PT'));

        if (count($sheetData) > 7) {
          $auth  = $this->session->get('auth');

          $items = array(
            'id_usr' => $auth['id'],
            'tpanag' => $sheetData[2]['C'],
            'cdanag' => $sheetData[2]['D'],
            'cddesm' => $sheetData[4]['C'] != -1 ? $sheetData[4]['C'] : NULL,
            'cdcata' => $sheetData[1]['C'],
            'flstat' => 0,
            'nulist' => $auth['type'] == 3 ? $this->utility->getDefaultNulistFromCustomer($sheetData[2]['C'], $sheetData[2]['D']) : $this->utility->getDefaultNulist($auth['id']),
            'tpordc' => $this->utility->getAppSettings('OrderTypeForExcel'),
            'tpindo' => NULL,
            'cdetic' => $sheetData[5]['C'] != -1 && $sheetData[5]['C'] != '' ? $sheetData[5]['C'] : NULL,
            'dtcrea' => date('Y-m-d'),
            'dtmcli' => $sheetData[3]['C'],
            'dtmcoi' => NULL,
            'dtmcof' => NULL
          );

          if (Octest::findOrderInProgress($auth['id']) == null) {
            $octest = new Octest();
            $this->utility->destroyCookie('recent-products');
            $octest->save($items);

            // Get name of columns for price, quantity, total
            $prcCol = '';
            $qtyCol = '';
            $totCol = '';

            if ($isDefault) {
              foreach ($sheetData[6] as $key => $value) {
                if ($value != '') {
                  $prcCol = $qtyCol;
                  $qtyCol = $totCol;
                  $totCol = $key;
                } else {
                  break;
                }
              }
            } else {
              $flag = 1;
              foreach ($sheetData[6] as $key => $value) {
                switch ($flag) {
                  case 1:
                    if ($value == '') $flag++;
                    break 1;
                  case 2:
                    if ($value != '') {
                      $flag++;
                      $qtyCol = $key;
                    }
                    break 1;
                  case 3:
                    if ($value != '') {
                      $totCol = $key;
                    } else {
                      break 2;
                    }
                    break 1;
                }
              }
            }

            // Get name and value of columns for sizes (we need to skip first 10 cols)
            $sizes = array();
            $startKey = !$isPT ? 'K' : 'M';
            foreach ($sheetData[6] as $key => $value) {
              if ($value != '' && $key != $prcCol) {
                if (
                  \PhpOffice\PhpSpreadsheet\Cell\Coordinate::columnIndexFromString($key) >=
                  \PhpOffice\PhpSpreadsheet\Cell\Coordinate::columnIndexFromString($startKey)
                ) {
                  $sizes[$value] = $key;
                }
              } else {
                break;
              }
            }

            $seqrap = 1;
            for ($i = 7; $i < count($sheetData) + 1; $i++) {
              $currRow = $sheetData[$i];

              if ($currRow[$qtyCol] != 0) {
                $occorp = new Occorp();
                $occorp->nuordc = $octest->nuordc;
                $occorp->seqrap = $seqrap;
                if ($isDefault) {
                  $occorp->cdarti = $currRow['C'];
                  $occorp->cdcolo = $currRow['E'] != '' ? $currRow['E'] : new \Phalcon\Db\RawValue('""');
                  $occorp->cdvari = !$isPT ? new \Phalcon\Db\RawValue('""') : $currRow['F'];
                } else {
                  $occorp->cdarti = $currRow['A'];
                  $occorp->cdcolo = $currRow['D'] != '' ? $currRow['D'] : new \Phalcon\Db\RawValue('""');
                  $occorp->cdvari = new \Phalcon\Db\RawValue('""');
                }
                $occorp->dtmcli = $octest->dtmcli;
                $occorp->cdcata = $octest->cdcata;
                $occorp->quanti = $currRow[$qtyCol];
                $occorp->seqdet = 1;
                $seqrap++;

                $occorp->save();

                if ($isDefault) {
                  $artSizes = Postgl::getSizesFromCdarti($occorp->cdarti);

                  foreach ($artSizes as $size) {
                    $indexCurrSize = $sizes[$size->taglia];
                    $currQuanti = $currRow[$indexCurrSize] != '' && $currRow[$indexCurrSize] > 0 ? $currRow[$indexCurrSize] : 0;
                    $octagl = new Octagl();
                    $octagl->nurorc = $occorp->nurorc;
                    $octagl->dstagl = $size->taglia;
                    $octagl->quanti = $currQuanti;
                    $octagl->prezzo = $currRow[$prcCol];
                    $octagl->scont1 = 0;
                    $octagl->scont2 = 0;
                    $octagl->scont3 = 0;

                    $octagl->save();
                  };
                } else {
                  $pricesRow = $sheetData[++$i];
                  $sizesRow = $sheetData[++$i];
                  $start = !$isPT ? 'I' : 'K';

                  foreach ($sizesRow as $k => $value) {
                    if ($k < $start) {
                      continue;
                    } else if ($currRow[$k] == '' || $k == $qtyCol) {
                      break;
                    }

                    $currQuanti = $value != '' && $value > 0 ? $value : 0;
                    $octagl = new Octagl();
                    $octagl->nurorc = $occorp->nurorc;
                    $octagl->dstagl = $currRow[$k];
                    $octagl->quanti = $currQuanti;
                    $octagl->prezzo = $pricesRow[$k];
                    $octagl->scont1 = 0;
                    $octagl->scont2 = 0;
                    $octagl->scont3 = 0;

                    $octagl->save();
                  };
                }
              }
            }
          }
        }
      } catch (\Exception $e) {
        die('Error loading file "' . pathinfo($targetFile, PATHINFO_BASENAME) . '": ' . $e->getMessage());
      }
    }

    if ($this->utility->getAppSettings('StartingHomePage') == 0) {
      return $this->response->redirect('catalog/index');
    } else {
      return $this->response->redirect('catalog/collection');
    }
  }

  public function uploadImageXlsTemplateAction() {
    $this->view->disable();

    if (!empty($_FILES)) {
      $tempFile = $_FILES['file']['tmp_name'];

      if (!file_exists('./io/imgxls/compiled')) {
        mkdir('./io/imgxls/compiled', 0777, true);
      }

      $targetPath = "./io/imgxls/compiled/";
      if (!is_dir($targetPath) && !mkdir($targetPath)) {
        die("Error creating folder $targetPath");
      }
      $targetFile = $targetPath . $_FILES['file']['name'];

      move_uploaded_file($tempFile, $targetFile);

      $cdcata = '';

      //  Read Excel workbook
      try {
        $inputFileType  = \PhpOffice\PhpSpreadsheet\IOFactory::identify($targetFile);
        $objReader      = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);

        $sheetnames = $objReader->listWorksheetNames($targetFile);
        $objReader->setLoadSheetsOnly($sheetnames[0]);
        $spreadsheet = $objReader->load($targetFile);
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

        $cdcata = $sheetData[1]['I'];

        if (count($sheetData) > 1) {
          foreach ($sheetData as $row) {
            $type = $row['I'];
            $code = $row['B'];
            $img1 = $row['D'];
            $img2 = $row['E'];
            $img3 = $row['F'];
            $img4 = $row['G'];
            $img5 = $row['H'];

            if ($type == 'cdarti') {
              Imgart::deleteAllImagesForArticle($code);
              Anaart::updateArticleImage($code, $img1);
              if (!empty($img2)) {
                Imgart::saveArticleImage(2, $code, $img2);
              }
              if (!empty($img3)) {
                Imgart::saveArticleImage(3, $code, $img2);
              }
              if (!empty($img4)) {
                Imgart::saveArticleImage(4, $code, $img2);
              }
              if (!empty($img5)) {
                Imgart::saveArticleImage(5, $code, $img2);
              }
            } else if ($type == 'cdartn') {
              Imgart::deleteAllImagesForModel($code);
              Tipolo::updateModelImage($code, $img1);
              if (!empty($img2)) {
                Imgart::saveModelImage(2, $code, $img2);
              }
              if (!empty($img3)) {
                Imgart::saveModelImage(3, $code, $img2);
              }
              if (!empty($img4)) {
                Imgart::saveModelImage(4, $code, $img2);
              }
              if (!empty($img5)) {
                Imgart::saveModelImage(5, $code, $img2);
              }
            }
          }
        }
      } catch (\Exception $e) {
        die('Error loading file "' . pathinfo($targetFile, PATHINFO_BASENAME) . '": ' . $e->getMessage());
      }
    }

    return $this->response->redirect('gomanagement/catalogDetail/' . $cdcata);
  }

  public function uploadSortingCatalogXlsAction() {
    $this->view->disable();

    if (!empty($_FILES)) {
      $tempFile = $_FILES['file']['tmp_name'];
      $sortingType = $this->utility->getAppSettings('EnableCatalogSorting');

      if (!file_exists('./io/sorting/compiled')) {
        mkdir('./io/sorting/compiled', 0777, true);
      }

      $targetPath = "./io/sorting/compiled/";
      if (!is_dir($targetPath) && !mkdir($targetPath)) {
        die("Error creating folder $targetPath");
      }
      $targetFile = $targetPath . $_FILES['file']['name'];

      move_uploaded_file($tempFile, $targetFile);

      $cdcata = '';

      //  Read Excel workbook
      try {
        $inputFileType  = \PhpOffice\PhpSpreadsheet\IOFactory::identify($targetFile);
        $objReader      = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);

        $sheetnames = $objReader->listWorksheetNames($targetFile);
        $objReader->setLoadSheetsOnly($sheetnames[0]);
        $spreadsheet = $objReader->load($targetFile);
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

        $cdcata = $sheetData[1]['F'];

        if (count($sheetData) > 1) {
          B2bAddinf::insertCustomSortingFlagForCatalog($cdcata);

          $saveSeqra2 = $this->utility->getAppSettings('EnableCatalogSorting') == 2;
          foreach ($sheetData as $row) {
            $cdartn = $row['A'];
            $seqrap = intval($row['D']);

            B2bAddinf::insertCustomSeqrap($cdartn, 'seqrap', $seqrap);
            if ($saveSeqra2) {
              $seqra2 = intval($row['E']);
              B2bAddinf::insertCustomSeqrap($cdartn, 'seqra2', $seqra2);
            }
          }
        }
      } catch (\Exception $e) {
        die('Error loading file "' . pathinfo($targetFile, PATHINFO_BASENAME) . '": ' . $e->getMessage());
      }
    }

    return $this->response->redirect('gomanagement/catalogSorting/' . $cdcata);
  }

  public function uploadSpecialSelectionXlsAction() {
    $this->view->disable();

    if (!empty($_FILES)) {
      $cdspsl = $_POST['cdspsl'];
      $tempFile = $_FILES['file']['tmp_name'];

      if (!file_exists('./io/selections')) {
        mkdir('./io/selections', 0777, true);
      }

      $targetPath = "./io/selections/";
      if (!is_dir($targetPath) && !mkdir($targetPath)) {
        die("Error creating folder $targetPath");
      }
      $targetFile = $targetPath . $_FILES['file']['name'];

      move_uploaded_file($tempFile, $targetFile);

      B2bSscorp::deleteAllProductsForSpecialSelection($cdspsl);

      // Read Excel workbook
      try {
        $inputFileType  = \PhpOffice\PhpSpreadsheet\IOFactory::identify($targetFile);
        $objReader      = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);

        $sheetnames = $objReader->listWorksheetNames($targetFile);
        $objReader->setLoadSheetsOnly($sheetnames[0]);
        $spreadsheet = $objReader->load($targetFile);
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

        for ($i = 1; $i < count($sheetData) + 1; $i++) {
          $codice = $sheetData[$i]['A'];
          if (B2bSstest::canBeInserted($cdspsl, $codice)) {
            B2bSscorp::insertNewProductForSpecialSelection($cdspsl, $codice, $i, '');
          }
        }
      } catch (\Exception $e) {
        die('Error loading file "' . pathinfo($targetFile, PATHINFO_BASENAME) . '": ' . $e->getMessage());
      }
    }

    return $this->response->redirect('admin/specialSelectionDetail/' . $cdspsl);
  }
  //endregion

  //region Upload management
  private function handleUploadedXlsTemplate($isAdmin) {
    if (!empty($_FILES) && isset($_FILES['file'])) {
      $tempFile = $_FILES['file']['tmp_name'];          //3
      $targetPath = "./io/template/compiled/";  //4

      if (!is_dir("./io/template") && !mkdir("./io/template", 0777, true)) {
        die("Error creating folder $targetPath");
        if (!is_dir("./io/template/compiled") && !mkdir("./io/template/compiled", 0777, true)) {
          die("Error creating folder $targetPath");
        }
      }
      $targetFile =  $targetPath . $_FILES['file']['name'];  //5
      move_uploaded_file($tempFile, $targetFile); //6
      chmod($targetFile, 0777);

      // Read Excel workbook
      try {
        $inputFileType  = \PhpOffice\PhpSpreadsheet\IOFactory::identify($targetFile);
        $objReader      = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);

        $xlsType      = $this->utility->getAppSettings('OrderExcelTypeFromOrderList');

        $sheetnames = $objReader->listWorksheetNames($targetFile);
        $objReader->setLoadSheetsOnly($sheetnames[0]);
        $spreadsheet = $objReader->load($targetFile);
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

        $isDefault = $this->utility->getAppSettings('OrderExcelTypeFromOrderList') != 2;
        $isConfigurator = $this->utility->getAppSettings('OrderExcelTypeFromOrderList') == 3;

        if ($isDefault) {
          $areThereRows = count($sheetData) > 7;
          $nuordc       = $sheetData[2]['B'];
          $startData    = $sheetData[7];
          $startIndex   = 8;
        } else {
          $areThereRows = count($sheetData) > 6;
          $nuordc       = $sheetData[1]['C'];
          $startData    = $sheetData[6];
          $startIndex   = 7;
        }

        if ($areThereRows) {
          // Get name of columns for price, quantity, total
          $prcCol = '';
          $qtyCol = '';
          $totCol = '';
          $rowCol = '';

          if ($xlsType == 0) {
            $flag = 1;
            foreach ($sheetData[7] as $key => $value) {
              switch ($flag) {
                case 1:
                  if ($value == '') $flag++;
                  break;
                case 2:
                  if ($value != '') {
                    $flag++;
                    $qtyCol = $key;
                  }
                  break;
                case 3:
                  if ($value != '') {
                    $flag++;
                    $totCol = $key;
                    break 2;
                  }
                  break;
              }
            }
          } else if ($isDefault) {
            $dummy1 = $dummy2 = '';
            foreach ($startData as $key => $value) {
              if ($value != '') {
                $prcCol = $qtyCol;
                $qtyCol = $totCol;
                $totCol = $dummy1;
                $dummy1 = $dummy2;
                $dummy2 = $key;
              } else {
                break;
              }
            }
          } else {
            foreach ($startData as $key => $value) {
              if ($value != '') {
                $prcCol = $qtyCol;
                $qtyCol = $totCol;
                $totCol = $key;
              } else {
                $rowCol = $key;
                break;
              }
            }
          }

          // Get name and value of columns for sizes (we need to skip first 10 cols)
          $i = 0;
          $sizes = array();
          if ($xlsType > 0) {
            $startKey = !$isConfigurator ? 'K' : 'H';
            foreach ($startData as $key => $value) {
              if ($value != '' && $key != $prcCol) {
                if (
                \PhpOffice\PhpSpreadsheet\Cell\Coordinate::columnIndexFromString($key) >=
                \PhpOffice\PhpSpreadsheet\Cell\Coordinate::columnIndexFromString($startKey)
                ) {
                  $sizes[(string)$value] = $key;
                }
              } else {
                break;
              }
            }
          }

          $error = false;

          // Check regqtm
          if ($isDefault) {
            $seqrap = 1;
            for ($i = $startIndex; $i < count($sheetData); $i++) {
              $currRow = $sheetData[$i];

              if ($xlsType != 0 || (($i - 8) % 3 == 0)) {
                if ($isAdmin) {
                  Occorp::updateOrderRowFromNuordcAndSeqrap($nuordc, $seqrap, $currRow[$qtyCol]);
                  $occorp = Occorp::getOrderRowFromNuordcAndSeqrap($nuordc, $seqrap);
                  $artSizes = Postgl::getSizesFromCdarti($occorp->cdarti);

                  foreach ($artSizes as $size) {
                    $indexCurrSize = $sizes[$size->taglia];
                    $currQuanti = $currRow[$indexCurrSize] != '' && $currRow[$indexCurrSize] > 0 ? $currRow[$indexCurrSize] : 0;
                    Octagl::updateSizeQuantity($occorp->nurorc, $size->taglia, $currQuanti);
                  }
                } else {
                  $quanti = $currRow[$qtyCol];
                  $occorp = Occorp::getOrderRowFromNuordcAndSeqrap($nuordc, $seqrap);
                  $regqtm = Regqtm::getModelRules($occorp->cdartn);

                  if ($quanti == 0 || ($quanti >= $regqtm['qtamin'] && (($quanti - $regqtm['qtamin']) % $regqtm['qtamul'] == 0))) {
                    $error |= false;
                  } else {
                    $error |= true;
                    break;
                  }
                }
                $seqrap++;
              }
            }
          }

          if (!$error) {
            $id_usr = $this->session->get('auth')['id'];

            if ($isDefault) {
              // TODO excel sorting can differ from the one we expect (seqrap sorting)
              // To avoid missing seqrap's
              Occorp::sortOrderRows($nuordc);
            } else {
              // If Zanotti, delete ALL, then they will be added again (order rows not sorted)
              //Octagl::deleteQuantitiesForOrder($nuordc);
              //Occorp::deleteOrderRowsForOrder($nuordc);
            }

            $seqrap = 1;
            for ($i = $startIndex; $i < count($sheetData); $i++) {
              $currRow = $sheetData[$i];

              if ($xlsType != 0 || (($i - 8) % 3 == 0)) {
                // You can update row only if you are an admin or if there is not an order in progess.
                if ($xlsType != 1) {
                  $cdarti = $currRow['B'];
                } else {
                  $cdartn = $currRow['B'];
                  $cdpers = $currRow['C'];
                  $cdarti = explode("\n", str_replace(' ', '', $cdartn))[0] . ' ' . explode("\n", str_replace(' ', '', $cdpers))[0];
                }

                if ($isAdmin || Octest::findOrderInProgress($id_usr) == null) {
                  if ($isDefault) {
                    Occorp::updateOrderRowFromNuordcAndSeqrap($nuordc, $seqrap, $currRow[$qtyCol]);
                    $nurorc = Occorp::getOrderRowFromNuordcAndSeqrap($nuordc, $seqrap)->nurorc;
                  } else {
                    $cdcata = Octest::findFirstByNuordc($nuordc)->cdcata;
                    $nurorc = $currRow[$rowCol];
                    Occorp::updateOrderRowFromNuordcAndNurorc($nuordc, $nurorc, $currRow[$qtyCol]);
                    //$nurorc = Occorp::insertOrderRow($nuordc, $seqrap, $currRow['B'], $currRow['C'], $cdcata, $currRow[$qtyCol]);
                    //Occorp::updateOrderRowFromNuordcAndSeqrapAndCdarti($nuordc, $seqrap, $currRow[$qtyCol], $currRow['B']);
                    //$occorp = Occorp::getOrderRowFromNuordcAndSeqrapAndCdarti($nuordc, $seqrap, $currRow['B']);
                  }

                  if ($xlsType == 0) {
                    $pricesRow = $sheetData[++$i];
                    $sizesRow = $sheetData[++$i];
                    $start = 'I';
                    foreach ($sizesRow as $k => $value) {
                      if ($k < $start) {
                        continue;
                      } else if ($currRow[$k] == '' || $k == $qtyCol) {
                        break;
                      }

                      $currQuanti = $value != '' && $value > 0 ? $value : 0;
                      Octagl::updateSizeQuantity($nurorc, $currRow[$k], $currQuanti);
                    };
                  } else {
                    $artSizes = !$isConfigurator || $occorp->cdcolo != 'CUSTOM'
                      ? Postgl::getSizesFromCdarti($cdarti)
                      : Postgl::getSizesFromCdartiConfigurator($cdarti);

                    foreach ($artSizes as $size) {
                      $indexCurrSize = $sizes[(string)$size->taglia];
                      $currQuanti = $currRow[(string)$indexCurrSize] != '' && $currRow[(string)$indexCurrSize] > 0 ? $currRow[(string)$indexCurrSize] : 0;
                      Octagl::updateSizeQuantity($nurorc, $size->taglia, $currQuanti);
                      /*if ($isDefault) {
                        Octagl::updateSizeQuantity($nurorc, $size->taglia, $currQuanti);
                      } else {
                        Octagl::insertSizeQuantity($nurorc, $size->taglia, $currQuanti);
                      }*/
                    }
                  }
                }

                $seqrap++;
              }
            }

            $octest = Octest::findFirstByNuordc($nuordc);
            if ($isAdmin) {
              $octest->flstat = Occorp::isWaitingForQuantity($nuordc) ? 5 : 1;
              $octest->save();
              return $this->response->redirect('admin/orders');
            } else {
              if (Octest::findOrderInProgress($id_usr) == null) {
                // You can update save this order as cart only if you are an admin or if there is not an order in progess.
                $octest->flstat = 0;
                $octest->save();
                $this->utility->destroyCookie('recent-products');
                return $this->response->redirect('cart/index');
              } else {
                return $this->response->redirect('account/info/ord/e=1');
              }
            }
          } else {
            if ($isAdmin) {
              return $this->response->redirect('admin/orders');
            } else {
              return $this->response->redirect('account/info/ord' . ($error ? '/e=1' : ''));
            }
          }
        }
      } catch (\Exception $e) {
        die('Error loading file "' . pathinfo($targetFile, PATHINFO_BASENAME) . '": ' . $e->getMessage());
      }
    }
  }
  //endregion

  //region Utility functions for order list Excel file
  private function setStylesForOrderListXls($activeSheet, $totColumnName, $lastSizeColumnName, $offset, $numRows, $numSizes, $xlsType) {
    // We need gray background on A1:E5 and A7:<n>7
    $headerStyle = array(
      'fill' => array(
        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
        'color' => array('rgb' => 'EEEEEE')
      ),
      'borders' => array(
        'allBorders' => array(
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
          'color' => array('argb' => 'FF606060'),
        ),
      ),
      'font' => array(
        'bold' => true
      ),
      'alignment' => array(
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT
      ),
    );
    if ($xlsType == 0) {
      // Default cell style
      $bottomCellsStyle = array(
        'borders' => array(
          'bottom' => array(
            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
            'color' => array('argb' => 'FF606060'),
          ),
        ),
        'alignment' => array(
          'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
        )
      );
    }
    // All cells style
    $allCellsStyle = array(
        'borders' => array(
          'allBorders' => array(
            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
            'color' => array('argb' => 'FF606060'),
          ),
        ),
        'alignment' => array(
          'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
        )
      );
    // Title header cells style (from sizes on)
    $titleHeaderCellsStyle = array('alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER));
    // Info cells style
    $infoCellsStyle = array('alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT));
    // Price and total cells style
    $totalsStyle    = array('alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT));
    // Quantity cells style
    $quantityStyle  = array('alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER));
    // White text
    $whiteTextStyle = array(
      'font'  => array(
        'color' => array('rgb' => 'FFFFFF'),
      )
    );

    if ($xlsType != 2) {
      $realNumRows = ($xlsType == 0 ? 3 : 1) * $numRows;
      $activeSheet->freezePane('F8');
      $info     = 'A1:E5';
      $header   = 'A7:' . $totColumnName . '7';
      $allCells = 'A8:' . $totColumnName . ($realNumRows + 7);
      $sizeQty  = $this->utility->getNameFromNumber($offset) . '7:' . $totColumnName . '7';
      $images   = 'A8:A' . ($numRows + 8);
      $rowInfo  = 'B8:' . $this->utility->getNameFromNumber($offset - 1) . ($realNumRows + 8);
      $totals   = $this->utility->getNameFromNumber($offset + $numSizes) . '7:' . $this->utility->getNameFromNumber($offset + $numSizes + 3) . ($realNumRows + 8);
      $quantity = $this->utility->getNameFromNumber($offset) . '7:' . $lastSizeColumnName . ($realNumRows + 8);
    } else {
      $activeSheet->freezePane('D7');
      $info     = 'A1:B4';
      $header   = 'A6:' . $totColumnName . '6';
      $allCells = 'A7:' . $totColumnName . ($numRows + 6);
      $sizeQty  = $this->utility->getNameFromNumber($offset) . '6:' . $totColumnName . '6';
      $images   = 'A7:A' . ($numRows + 7);
      $rowInfo  = 'B7:' . $this->utility->getNameFromNumber($offset - 1) . ($numRows + 7);
      $totals   = $this->utility->getNameFromNumber($offset + $numSizes) . '6:' . $this->utility->getNameFromNumber($offset + $numSizes + 1) . ($numRows + 7);
      $quantity = $this->utility->getNameFromNumber($offset) . '6:' . $lastSizeColumnName . ($numRows + 7);
    }

    $activeSheet->getStyle($info)->applyFromArray($headerStyle);
    $activeSheet->getStyle($header)->applyFromArray($headerStyle);
    if ($xlsType == 0) {
      for ($i = 0; $i < $numRows; $i++) {
        $index = 8 + ($i * 3);
        $activeSheet->getStyle('A' . $index . ':' . $totColumnName . ($index + 2))->applyFromArray($bottomCellsStyle);
      }
      $activeSheet->getStyle('J8:' . $lastSizeColumnName . (($numRows * 3) + 7))->applyFromArray($allCellsStyle);
    } else {
      $activeSheet->getStyle($allCells)->applyFromArray($allCellsStyle);
    }
    $activeSheet->getStyle($sizeQty)->applyFromArray($titleHeaderCellsStyle);
    $activeSheet->getStyle($images)->applyFromArray($titleHeaderCellsStyle);
    $activeSheet->getStyle($rowInfo)->applyFromArray($infoCellsStyle);
    $activeSheet->getStyle($totals)->applyFromArray($totalsStyle);
    $activeSheet->getStyle($quantity)->applyFromArray($quantityStyle);

    if ($xlsType == 2) {
      $activeSheet->getStyle('C1')->applyFromArray($whiteTextStyle);
      $activeSheet->getStyle('H7:H' . ($numRows + 7))->applyFromArray($totalsStyle);
    }
  }

  private function setColumnWidthsForOrderListXls($activeSheet, $offset, $columns, $xlsType) {
    $activeSheet->calculateColumnWidths();
    $activeSheet->getColumnDimension('A')->setWidth(30);
    $maxColumn = $columns - ($xlsType != 2 ? 4 : 2);
    if ($xlsType == 0) {
      for ($i = 1; $i <= $columns; $i++) {
        $activeSheet->getColumnDimension($this->utility->getNameFromNumber($i))->setAutoSize(true);
      }
    } else {
      for ($i = 1; $i <= $columns; $i++) {
        if ($i >= $offset && $i < $maxColumn) {
          $activeSheet->getColumnDimension($this->utility->getNameFromNumber($i))->setWidth(5);
        } else {
          if ($xlsType == 3 && $this->utility->getNameFromNumber($i) == 'C') {
            $activeSheet->getColumnDimension($this->utility->getNameFromNumber($i))->setWidth(20);
          } else {
            $activeSheet->getColumnDimension($this->utility->getNameFromNumber($i))->setAutoSize(true);
          }
        }
      }
    }
  }

  private function fillOrderHeaderInfoForOrderListXls($activeSheet, $octest, $desmer, $xlsType) {
    if ($xlsType != 2) {
      $activeSheet->getCell('A1')->setValue(ucwords($this->translate('_common.catalog')));
      $activeSheet->getCell('B1')->setValue($octest->dscata);
      $activeSheet->mergeCells('B1:C1');
      $activeSheet->getCell('D1')->setValue(ucwords($this->translate('cart.deliverydate')));
      if ($octest->dtmcoi != '' && $octest->dtmcoi != '00/00/0000' && $octest->dtmcof != '' && $octest->dtmcof != '00/00/0000') {
        $activeSheet->getCell('E1')->setValue($octest->dtmcoi . ' - ' . $octest->dtmcof);
      } else {
        $activeSheet->getCell('E1')->setValue($octest->dsscad != '' ? $octest->dsscad : $octest->dtmcli);
      }
      $activeSheet->getCell('A2')->setValue(ucwords($this->translate('_common.order')));
      $activeSheet->getCell('B2')->setValue($octest->nuordc);
      $activeSheet->mergeCells('B2:C2');
      $activeSheet->getCell('D2')->setValue(ucwords($this->translate('cart.payment')));
      $activeSheet->getCell('E2')->setValue($octest->dspaga);
      $activeSheet->getCell('A3')->setValue(ucwords($this->translate('_common.orderdate')));
      $activeSheet->getCell('B3')->setValue($octest->dtcrea);
      $activeSheet->mergeCells('B3:C3');
      $activeSheet->getCell('D3')->setValue(ucwords($this->translate('cart.shipping')));
      $activeSheet->getCell('E3')->setValue($octest->dstpor);
      $activeSheet->getCell('A4')->setValue(ucwords($this->translate('_common.customer')));
      $activeSheet->getCell('B4')->setValue($octest->tpanag . ' - ' . $octest->cdanag);
      $activeSheet->mergeCells('B4:E4');
      $activeSheet->getCell('A5')->setValue(ucwords($this->translate('_common.shippings')));
      $activeSheet->getCell('B5')->setValue($desmer->indiri . ' ' . $desmer->ccitta . ' ' . $desmer->provin);
      $activeSheet->mergeCells('B5:E5');
    } else {
      $activeSheet->getCell('A1')->setValue(ucwords($this->translate('_common.catalog')));
      $activeSheet->getCell('B1')->setValue($octest->dscata);
      $activeSheet->getCell('A2')->setValue(ucwords($this->translate('_common.customer')));
      $activeSheet->getCell('B2')->setValue($octest->cdanag . ' - ' . $octest->dsanag);
      $activeSheet->getCell('C1')->setValue($octest->nuordc);
      $activeSheet->getCell('A3')->setValue(ucwords($this->translate('cart.deliverydate')));
      if ($octest->dtmcoi != '' && $octest->dtmcoi != '00/00/0000' && $octest->dtmcof != '' && $octest->dtmcof != '00/00/0000') {
        $activeSheet->getCell('B3')->setValue($octest->dtmcoi . ' - ' . $octest->dtmcof);
      } else {
        $activeSheet->getCell('B3')->setValue($octest->dsscad != '' ? $octest->dsscad : $octest->dtmcli);
      }
      $activeSheet->getCell('A4')->setValue(ucwords($this->translate('cart.shipping')));
      $activeSheet->getCell('B4')->setValue($octest->dstpor);
    }
  }

  private function fillRowsHeaderForOrderListXls($activeSheet, $offset, $numSizes, $sizes, $currency, $permissions, $xlsType) {
    switch ($xlsType) {
      case 0:
        if ($permissions == 'write') {
          $activeSheet->getCell('I6')->setValue($this->translate('excel.warning1'));
          $activeSheet->mergeCells('I6:AN6');
        }
        $activeSheet->getCell('A7')->setValue(ucwords($this->translate('_common.image')));
        $activeSheet->getCell('B7')->setValue(ucwords($this->translate('_common.article.code')));
        $activeSheet->getCell('C7')->setValue(ucwords($this->translate('_common.article.description')));
        $activeSheet->getCell('D7')->setValue(ucwords($this->translate('_common.description.color')));
        $activeSheet->getCell('E7')->setValue(ucwords($this->translate('_common.code.color')));
        $activeSheet->getCell('F7')->setValue(ucwords($this->translate('_common.brand')));
        $activeSheet->getCell('G7')->setValue(ucwords($this->translate('_common.line')));
        $activeSheet->getCell('H7')->setValue(ucwords($this->translate('_common.series')));
        $activeSheet->getCell('I7')->setValue(ucwords($this->translate('_common.sizes.scale')));

        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $numSizes) . '7')->setValue(ucwords($this->translate('_common.quantity')));
        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $numSizes + 1) . '7')->setValue(ucwords($this->translate('_common.total')) . ' (' . $currency . ')');
        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $numSizes + 2) . '7')->setValue(ucwords($this->translate('admin.quantityrules.row.min.short')));
        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $numSizes + 3) . '7')->setValue(ucwords($this->translate('admin.quantityrules.row.mul.short')));
        break;
      case 1:
        if ($permissions == 'write') {
          $activeSheet->getCell('K6')->setValue($this->translate('excel.warning1'));
          $activeSheet->mergeCells('K6:AN6');
        }
        $activeSheet->getCell('A7')->setValue(ucwords($this->translate('_common.image')));
        $activeSheet->getCell('B7')->setValue(ucwords($this->translate('_common.model')));
        $activeSheet->getCell('C7')->setValue(ucwords($this->translate('_common.tissue')));
        $activeSheet->getCell('D7')->setValue(ucwords($this->translate('_common.color')));
        $activeSheet->getCell('E7')->setValue(ucwords($this->translate('_common.variations')));
        $activeSheet->getCell('F7')->setValue(ucwords($this->translate('cart.deliverydate')));
        $activeSheet->getCell('G7')->setValue(ucwords($this->translate('_common.brand')));
        $activeSheet->getCell('H7')->setValue(ucwords($this->translate('_common.line')));
        $activeSheet->getCell('I7')->setValue(ucwords($this->translate('_common.series')));
        $activeSheet->getCell('J7')->setValue(ucwords($this->translate('_common.sizes.scale')));

        for ($i = 0; $i < $numSizes; $i++) {
          $sizeColumn = $this->utility->getNameFromNumber($offset + $i);
          $activeSheet->getCell($sizeColumn . '7')->setValue($sizes[$i]['taglia']);
        }

        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i) . '7')->setValue(ucwords($this->translate('_common.price')) . ' (' . $currency . ')');
        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i + 1) . '7')->setValue(ucwords($this->translate('_common.quantity')));
        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i + 2) . '7')->setValue(ucwords($this->translate('_common.total')) . ' (' . $currency . ')');
        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i + 3) . '7')->setValue(ucwords($this->translate('admin.quantityrules.row.min.short')));
        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i + 4) . '7')->setValue(ucwords($this->translate('admin.quantityrules.row.mul.short')));
        break;
      case 2:
        if ($permissions == 'write') {
          $activeSheet->getCell('K5')->setValue($this->translate('excel.warning1'));
          $activeSheet->mergeCells('K5:AN5');
        }

        $activeSheet->getCell('A6')->setValue(ucwords($this->translate('_common.image')));
        $activeSheet->getCell('B6')->setValue(ucwords($this->translate('_common.code.article')));
        $activeSheet->getCell('C6')->setValue(ucwords($this->translate('_common.code.color')));
        $activeSheet->getCell('D6')->setValue(ucwords($this->translate('_common.modeltype')));
        $activeSheet->getCell('E6')->setValue('Bolla / Tag no.');
        $activeSheet->getCell('F6')->setValue('Tomaia / Upper');
        $activeSheet->getCell('G6')->setValue('Tacco / Heel');
        $activeSheet->getCell('H6')->setValue('Retail Price un.');
        $activeSheet->getCell('I6')->setValue(ucwords($this->translate('_common.line')));
        $activeSheet->getCell('J6')->setValue(ucwords($this->translate('_common.series')));

        for ($i = 0; $i < $numSizes; $i++) {
          $sizeColumn = $this->utility->getNameFromNumber($offset + $i);
          $activeSheet->getCell($sizeColumn . '6')->setValue($sizes[$i]['taglia']);
        }

        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i) . '6')->setValue(ucwords($this->translate('_common.price')) . ' (' . $currency . ')');
        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i + 1) . '6')->setValue(ucwords($this->translate('_common.quantity')));
        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i + 2) . '6')->setValue(ucwords($this->translate('_common.total')) . ' (' . $currency . ')');
        break;
      case 3:
        if ($permissions == 'write') {
          $activeSheet->getCell('H6')->setValue($this->translate('excel.warning1'));
          $activeSheet->mergeCells('H6:AN6');
        }
        $activeSheet->getCell('A7')->setValue(ucwords($this->translate('_common.image')));
        $activeSheet->getCell('B7')->setValue(ucwords($this->translate('_common.model')));
        $activeSheet->getCell('C7')->setValue(ucwords($this->translate('_common.features')));
        $activeSheet->getCell('D7')->setValue(ucwords($this->translate('_common.genre')));
        $activeSheet->getCell('E7')->setValue(ucwords($this->translate('_common.line')));
        $activeSheet->getCell('F7')->setValue(ucwords($this->translate('_common.series')));
        $activeSheet->getCell('G7')->setValue(ucwords($this->translate('_common.modeltype')));

        for ($i = 0; $i < $numSizes; $i++) {
          $sizeColumn = $this->utility->getNameFromNumber($offset + $i);
          $activeSheet->getCell($sizeColumn . '7')->setValue($sizes[$i]['taglia']);
        }

        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i) . '7')->setValue(ucwords($this->translate('_common.price')) . ' (' . $currency . ')');
        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i + 1) . '7')->setValue(ucwords($this->translate('_common.quantity')));
        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i + 2) . '7')->setValue(ucwords($this->translate('_common.total')) . ' (' . $currency . ')');
        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i + 3) . '7')->setValue(ucwords($this->translate('admin.quantityrules.row.min.short')));
        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i + 4) . '7')->setValue(ucwords($this->translate('admin.quantityrules.row.mul.short')));
        break;
    }
  }

  private function fillOrderRowsForOrderListXls($activeSheet, $offset, $numRows, $numSizes, $rows, $sizes, $discount, $permissions, $xlsType) {
    $cellStyle = array(
      'fill' => array(
        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
        'color' => array('rgb' => 'FFFF00')
      ),
      'font' => array(
        'bold' => true
      ),
    );
    $sideBordersStyle = array(
      'borders' => array(
        'left' => array(
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
          'color' => array('argb' => 'FF606060'),
        ),
        'right' => array(
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
          'color' => array('argb' => 'FF606060'),
        ),
      ),
      'alignment' => array(
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
      )
    );
    $fullBordersStyle = array(
      'borders' => array(
        'allBorders' => array(
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
          'color' => array('argb' => 'FF606060'),
        )
      ),
      'alignment' => array(
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER
      )
    );

    $sizeColumns = array();
    for ($i = 0; $i < $numSizes; $i++) {
      $sizeColumn = $this->utility->getNameFromNumber($offset + $i);
      $sizeColumns[$sizes[$i]['taglia']] = $sizeColumn;
    }

    for ($i = 0; $i < $numRows; $i++) {
      if ($xlsType == 0) {
        $currRowIndex = ($i * 3) + 8;
      } else {
        $currRowIndex = $i + ($xlsType != 2 ? 8 : 7);
      }

      $flimag = $this->utility->getAppSettings('ProductTypeOnCatalog') == 1 || $xlsType == 2
        ? $rows[$i]->flimag_i
        : $rows[$i]->flimag_n;

      $imgurl = "img/model/" . $flimag;
      $exist = !empty($flimag) && file_exists($imgurl);

      $fixed_height = 100;
      if ($exist) {
        // Create temporary folder for resized images
        $this->utility->checkOrCreateResizeFolder();

        // Copy image to temporary folder
        $this->utility->resizeImageForExcel($imgurl, "img/temp/resize/model/" . $flimag);

        if ($xlsType == 0) {
          $activeSheet->getRowDimension($currRowIndex)->setRowHeight(52);
          $activeSheet->getRowDimension($currRowIndex + 1)->setRowHeight(52);
          $activeSheet->getRowDimension($currRowIndex + 2)->setRowHeight(52);
        } else {
          $activeSheet->getRowDimension($currRowIndex)->setRowHeight(155);
        }

        $objDrawing_n = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
        $objDrawing_n->setPath("img/temp/resize/model/" . $flimag);
        $objDrawing_n->setResizeProportional(true);
        $objDrawing_n->setCoordinates('A' . $currRowIndex);
        $objDrawing_n->setHeight($xlsType != 1 ? 200 : 150);
        $objDrawing_n->setOffsetY(2);
        $objDrawing_n->setOffsetX(2);
        $objDrawing_n->setWorksheet($activeSheet);
      }

      if ($xlsType == 0) {
        $activeSheet->mergeCells('A' . $currRowIndex . ':A' . ($currRowIndex + 2));
        $activeSheet->getStyle('A' . $currRowIndex . ':A' . ($currRowIndex + 2))->applyFromArray($sideBordersStyle);
      } else if ($xlsType == 1 || $xlsType == 3) {
        $flimag = $xlsType == 1 ? $rows[$i]->flimag_c : $rows[$i]->flimag_i;

        $imgurl = "img/model/" . $flimag;
        $exist = !empty($flimag) && file_exists($imgurl);

        $fixed_height = 50;
        if ($exist) {
          // Create temporary folder for resized images
          $this->utility->checkOrCreateResizeFolder();

          // Copy image to temporary folder
          $this->utility->resizeImageForExcel($imgurl, "img/temp/resize/model/" . $flimag);

          $activeSheet->getRowDimension($currRowIndex)->setRowHeight(155);

          $objDrawing_n = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
          $objDrawing_n->setPath("img/temp/resize/model/" . $flimag);
          $objDrawing_n->setResizeProportional(true);
          $objDrawing_n->setCoordinates('A' . $currRowIndex);
          $objDrawing_n->setHeight(50);
          $objDrawing_n->setOffsetY(2);
          $objDrawing_n->setOffsetX($xlsType == 1 ? 160 : 202);
          $objDrawing_n->setWorksheet($activeSheet);
        }
      }

      switch ($xlsType) {
        case 0:
          $activeSheet->getCell('B' . $currRowIndex)->setValue($rows[$i]->cdarti);
          $activeSheet->getCell('C' . $currRowIndex)->setValue($rows[$i]->dsarti);
          $activeSheet->getCell('D' . $currRowIndex)->setValue($rows[$i]->dscolo);
          $activeSheet->getCell('E' . $currRowIndex)->setValue($rows[$i]->cdcolo);
          $activeSheet->getCell('F' . $currRowIndex)->setValue($rows[$i]->dstitl);
          $activeSheet->getCell('G' . $currRowIndex)->setValue($rows[$i]->dslinm);
          $activeSheet->getCell('H' . $currRowIndex)->setValue($rows[$i]->dsserm);
          $activeSheet->getCell('I' . $currRowIndex)->setValue($rows[$i]->dstagl);
          $activeSheet->getStyle('B' . $currRowIndex . ':B' . ($currRowIndex + 2))->applyFromArray($sideBordersStyle);
          $activeSheet->getStyle('C' . $currRowIndex . ':C' . ($currRowIndex + 2))->applyFromArray($sideBordersStyle);
          $activeSheet->getStyle('D' . $currRowIndex . ':D' . ($currRowIndex + 2))->applyFromArray($sideBordersStyle);
          $activeSheet->getStyle('E' . $currRowIndex . ':E' . ($currRowIndex + 2))->applyFromArray($sideBordersStyle);
          $activeSheet->getStyle('F' . $currRowIndex . ':F' . ($currRowIndex + 2))->applyFromArray($sideBordersStyle);
          $activeSheet->getStyle('G' . $currRowIndex . ':G' . ($currRowIndex + 2))->applyFromArray($sideBordersStyle);
          $activeSheet->getStyle('H' . $currRowIndex . ':H' . ($currRowIndex + 2))->applyFromArray($sideBordersStyle);
          $activeSheet->getStyle('I' . $currRowIndex . ':I' . ($currRowIndex + 2))->applyFromArray($sideBordersStyle);
          break;
        case 1:
          $activeSheet->getCell('B' . $currRowIndex)->setValue($rows[$i]->cdartn . "\n" . $rows[$i]->dsartn);
          $activeSheet->getCell('C' . $currRowIndex)->setValue($rows[$i]->cdpers . "\n" . $rows[$i]->dspers);
          $activeSheet->getCell('D' . $currRowIndex)->setValue($rows[$i]->cdcolo . "\n" . $rows[$i]->dscolo);
          $activeSheet->getCell('E' . $currRowIndex)->setValue($rows[$i]->variants);
          $activeSheet->getCell('F' . $currRowIndex)->setValue($rows[$i]->dtmcli);
          $activeSheet->getCell('G' . $currRowIndex)->setValue($rows[$i]->dstitl);
          $activeSheet->getCell('H' . $currRowIndex)->setValue($rows[$i]->dslinm);
          $activeSheet->getCell('I' . $currRowIndex)->setValue($rows[$i]->dsserm);
          $activeSheet->getCell('J' . $currRowIndex)->setValue($rows[$i]->dstagl);
          break;
        case 2:
          $activeSheet->getCell('B' . $currRowIndex)->setValue($rows[$i]->cdarti);
          $activeSheet->getCell('C' . $currRowIndex)->setValue($rows[$i]->cdcolo);
          $activeSheet->getCell('D' . $currRowIndex)->setValue($rows[$i]->dstmod);
          $activeSheet->getCell('E' . $currRowIndex)->setValue($rows[$i]->bolla);
          $activeSheet->getCell('F' . $currRowIndex)->setValue($rows[$i]->tomaia);
          $activeSheet->getCell('G' . $currRowIndex)->setValue($rows[$i]->tacco);
          if ($rows[$i]->prezzo_r > 0 && $rows[$i]->cdvalu_r != '') {
            $retailPrice = $this->utility->getFormattedPriceWithCdvalu($rows[$i]->cdvalu_r, $rows[$i]->prezzo_r)['value'];
            $activeSheet->getCell('H' . $currRowIndex)->setValue($retailPrice);
          }
          $activeSheet->getCell('I' . $currRowIndex)->setValue($rows[$i]->dslinm);
          $activeSheet->getCell('J' . $currRowIndex)->setValue($rows[$i]->dsserm);
          break;
        case 3:
          $activeSheet->getCell('B' . $currRowIndex)->setValue($rows[$i]->cdartn . " \n" . $rows[$i]->dsartn);
          $components = '';
          foreach ($rows[$i]->components as $component) {
            $components .= $component->cdmate . ' - ' . $component->dsmate . ' / ';
          }
          $activeSheet->getCell('C' . $currRowIndex)->setValue(substr($components, 0, -3));
          $activeSheet->getCell('D' . $currRowIndex)->setValue($rows[$i]->dsgene);
          $activeSheet->getCell('E' . $currRowIndex)->setValue($rows[$i]->dslinm);
          $activeSheet->getCell('F' . $currRowIndex)->setValue($rows[$i]->dsserm);
          $activeSheet->getCell('G' . $currRowIndex)->setValue($rows[$i]->dstmod);
          break;
      }

      for ($j = 0; $j < count($rows[$i]->octagl); $j++) {
        if ($xlsType == 0) {
          $column = $this->utility->getNameFromNumber($offset + $j);
          $cell = $column . ($currRowIndex + 2);
          $activeSheet->getStyle($column . $currRowIndex)->applyFromArray($fullBordersStyle);
          $activeSheet->getStyle($column . ($currRowIndex + 1))->applyFromArray($fullBordersStyle);
          $activeSheet->getStyle($column . ($currRowIndex + 2))->applyFromArray($fullBordersStyle);
        } else {
          $column = $sizeColumns[$rows[$i]->octagl[$j]->dstagl];
          $cell = $column . ($xlsType == 0 ? $currRowIndex + 2 : $currRowIndex);
        }

        if ($permissions == 'write') {
          $activeSheet->getStyle($cell)->getProtection()->setLocked(\PhpOffice\PhpSpreadsheet\Style\Protection::PROTECTION_UNPROTECTED);
          $activeSheet->getStyle($cell)->applyFromArray($cellStyle);
        }

        $objValidation = $activeSheet->getCell($cell)->getDataValidation();
        $objValidation->setAllowBlank(true);
        $objValidation->setErrorTitle($this->translate('_common.error'));
        $objValidation->setShowInputMessage(true);
        $objValidation->setShowErrorMessage(true);

        if ($xlsType != 2) {
          $qtamin = $rows[$i]->ra_qtamin;
          $qtamul = $rows[$i]->ra_qtamul;
          $objValidation->setType( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_CUSTOM );
          $objValidation->setErrorStyle( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::STYLE_STOP );
          $objValidation->setError($this->translate('_common.regqta.warning', ['qtamin' => $qtamin, 'qtamul' => $qtamul]));
          $frmIsNumber = 'ISNUMBER(' . $cell . ')';
          $frmMod      = 'MOD(' . $cell . '-' . $qtamin . ',' . $qtamul . ')=0';
          $frmOr       = 'OR(' . $cell . '=0,' . $frmMod . ')';
          $objValidation->setFormula1('=AND(' . $frmIsNumber . ',' . $frmOr . ')');
        } else {
          $objValidation->setType( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_WHOLE );
          $objValidation->setOperator(\PhpOffice\PhpSpreadsheet\Cell\DataValidation::OPERATOR_BETWEEN);
          $objValidation->setErrorStyle( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::STYLE_STOP );
          $objValidation->setError($this->translate('excel.warning1'));
          $objValidation->setFormula1(0);
          $objValidation->setFormula2(999999);
        }

        $activeSheet->getStyle($cell)->getNumberFormat()->setFormatCode('#');
        $activeSheet->getCell($cell)->setValue($rows[$i]->octagl[$j]->quanti);

        $discount = $rows[$i]->octagl[$j]->scont1 != 0 || $rows[$i]->octagl[$j]->scont2 != 0 || $rows[$i]->octagl[$j]->scont3 != 0
          ? (1 - ($rows[$i]->octagl[$j]->scont1 / 100)) * (1 - ($rows[$i]->octagl[$j]->scont2 / 100)) * (1 - ($rows[$i]->octagl[$j]->scont3 / 100))
          : $discount;

        if ($xlsType == 0) {
          $activeSheet->getCell($column . $currRowIndex)->setValue($rows[$i]->octagl[$j]->dstagl);
          $activeSheet->getCell($column . ($currRowIndex + 1))->setValue($rows[$i]->octagl[$j]->prezzo * $discount);
          $activeSheet->getStyle($column . ($currRowIndex + 1))->getNumberFormat()->setFormatCode('#,##0.00');
        } else {
          $activeSheet->getCell($this->utility->getNameFromNumber($offset + $numSizes) . $currRowIndex)->setValue($rows[$i]->prezzo * $discount);
        }
      }

      if ($xlsType != 0) {
        $discount = $rows[$i]->octagl[0]->scont1 != 0 || $rows[$i]->octagl[0]->scont2 != 0 || $rows[$i]->octagl[0]->scont3 != 0
          ? (1 - ($rows[$i]->octagl[0]->scont1 / 100)) * (1 - ($rows[$i]->octagl[0]->scont2 / 100)) * (1 - ($rows[$i]->octagl[0]->scont3 / 100))
          : $discount;
        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $numSizes) . $currRowIndex)->setValue($rows[$i]->prezzo * $discount);
        $sumCells   = (!$xlsType != 3 ? 'SUM(K' : 'SUM(H') . $currRowIndex . ':' . $this->utility->getNameFromNumber($offset + $numSizes - 1) . $currRowIndex . ')';
        $totQty     = $this->utility->getNameFromNumber($offset + $numSizes + 1) . $currRowIndex;
        $totPrc     = $this->utility->getNameFromNumber($offset + $numSizes + 2) . $currRowIndex;
        $prdFormula = $this->utility->getNameFromNumber($offset + $numSizes) . $currRowIndex . '*' . $totQty;
      } else {
        $sumCells   = 'SUM(J' . ($currRowIndex + 2) . ':' . $this->utility->getNameFromNumber($offset + $numSizes - 1) . ($currRowIndex + 2) . ')';
        $prdFormula   = 'SUMPRODUCT(J' . ($currRowIndex + 1) . ':' . $this->utility->getNameFromNumber($offset + $numSizes - 1) . ($currRowIndex + 1) . ',' .
          'J' . ($currRowIndex + 2) . ':' . $this->utility->getNameFromNumber($offset + $numSizes - 1) . ($currRowIndex + 2) . ')';
        $totQty     = $this->utility->getNameFromNumber($offset + $numSizes) . $currRowIndex;
        $totPrc     = $this->utility->getNameFromNumber($offset + $numSizes + 1) . $currRowIndex;
        $activeSheet->getStyle($this->utility->getNameFromNumber($offset + $numSizes) . $currRowIndex)->applyFromArray($sideBordersStyle);
        $activeSheet->getStyle($this->utility->getNameFromNumber($offset + $numSizes) . ($currRowIndex + 1))->applyFromArray($sideBordersStyle);
        $activeSheet->getStyle($this->utility->getNameFromNumber($offset + $numSizes) . ($currRowIndex + 2))->applyFromArray($sideBordersStyle);
        $activeSheet->getStyle($this->utility->getNameFromNumber($offset + $numSizes + 1) . $currRowIndex)->applyFromArray($sideBordersStyle);
        $activeSheet->getStyle($this->utility->getNameFromNumber($offset + $numSizes + 1) . ($currRowIndex + 1))->applyFromArray($sideBordersStyle);
        $activeSheet->getStyle($this->utility->getNameFromNumber($offset + $numSizes + 1) . ($currRowIndex + 2))->applyFromArray($sideBordersStyle);
        $activeSheet->getStyle($this->utility->getNameFromNumber($offset + $numSizes + 2) . $currRowIndex)->applyFromArray($sideBordersStyle);
        $activeSheet->getStyle($this->utility->getNameFromNumber($offset + $numSizes + 2) . ($currRowIndex + 1))->applyFromArray($sideBordersStyle);
        $activeSheet->getStyle($this->utility->getNameFromNumber($offset + $numSizes + 2) . ($currRowIndex + 2))->applyFromArray($sideBordersStyle);
        $activeSheet->getStyle($this->utility->getNameFromNumber($offset + $numSizes + 3) . $currRowIndex)->applyFromArray($sideBordersStyle);
        $activeSheet->getStyle($this->utility->getNameFromNumber($offset + $numSizes + 3) . ($currRowIndex + 1))->applyFromArray($sideBordersStyle);
        $activeSheet->getStyle($this->utility->getNameFromNumber($offset + $numSizes + 3) . ($currRowIndex + 2))->applyFromArray($sideBordersStyle);
      }

      $sumFormula = '=' . $sumCells;
      $prdFormula = '=' . $prdFormula;
      $activeSheet->getCell($totQty)->setValue($sumFormula);
      $activeSheet->getCell($totPrc)->setValue($prdFormula);

      if ($xlsType != 2) {
        $qtamin     = $this->utility->getNameFromNumber($offset + $numSizes + ($xlsType == 0 ? 2 : 3)) . $currRowIndex;
        $qtamul     = $this->utility->getNameFromNumber($offset + $numSizes + ($xlsType == 0 ? 3 : 4)) . $currRowIndex;
        $activeSheet->getCell($qtamin)->setValue($rows[$i]->rm_qtamin);
        $activeSheet->getCell($qtamul)->setValue($rows[$i]->rm_qtamul);

        $conditional = new \PhpOffice\PhpSpreadsheet\Style\Conditional();
        $conditional->setConditionType(\PhpOffice\PhpSpreadsheet\Style\Conditional::CONDITION_EXPRESSION);
        $conditional->addCondition('AND(' . $totQty . '<>0,' . $totQty . '<' . $qtamin . ')');
        $conditional->getStyle()->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getEndColor()->setARGB("FFFF0000");
        $conditionalStyles = $activeSheet->getStyle($qtamin)->getConditionalStyles();
        $conditionalStyles[] = $conditional;
        $activeSheet->getStyle($qtamul)->setConditionalStyles($conditionalStyles);

        $conditional = new \PhpOffice\PhpSpreadsheet\Style\Conditional();
        $conditional->setConditionType(\PhpOffice\PhpSpreadsheet\Style\Conditional::CONDITION_EXPRESSION);
        $conditional->addCondition('AND(' . $totQty . '<>0,MOD(' . $totQty . '-' . $qtamin . ',' . $qtamul . ')<>0)');
        $conditional->getStyle()->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getEndColor()->setARGB("FFFF0000");

        $conditionalStyles = $activeSheet->getStyle($qtamul)->getConditionalStyles();
        $conditionalStyles[] = $conditional;

        $activeSheet->getStyle($qtamul)->setConditionalStyles($conditionalStyles);
      } else {
        $activeSheet->getCell($this->utility->getNameFromNumber($offset + $numSizes + 3) . $currRowIndex)->setValue($rows[$i]->nurorc);
        $activeSheet->getStyle($this->utility->getNameFromNumber($offset + $numSizes + 3) . $currRowIndex)->applyFromArray(array('font' => array('color' => array('rgb' => 'FFFFFF'))));
      }
    }

    $realNumRows = ($xlsType == 0 ? 3 : 1) * $numRows;

    if ($xlsType == 0) {
      $totPrcCol = $this->utility->getNameFromNumber($offset + $numSizes + 1);
      $activeSheet->getStyle($totPrcCol . '7:' . $totPrcCol . ($realNumRows + 7))->getNumberFormat()->setFormatCode('#,##0.00');
    } elseif ($xlsType != 2) {
      $uniPrcCol = $this->utility->getNameFromNumber($offset + $numSizes);
      $totPrcCol = $this->utility->getNameFromNumber($offset + $numSizes + 2);
      $activeSheet->getStyle($uniPrcCol . '7:' . $uniPrcCol . ($realNumRows + 7))->getNumberFormat()->setFormatCode('#,##0.00');
      $activeSheet->getStyle($totPrcCol . '7:' . $totPrcCol . ($realNumRows + 7))->getNumberFormat()->setFormatCode('#,##0.00');
    } else {
      $uniPrcCol = $this->utility->getNameFromNumber($offset + $numSizes);
      $totPrcCol = $this->utility->getNameFromNumber($offset + $numSizes + 2);
      $activeSheet->getStyle($uniPrcCol . '6:' . $uniPrcCol . ($realNumRows + 6))->getNumberFormat()->setFormatCode('#,##0.00');
      $activeSheet->getStyle($totPrcCol . '6:' . $totPrcCol . ($realNumRows + 6))->getNumberFormat()->setFormatCode('#,##0.00');
    }
  }
  //endregion

  //region Utility functions for budget Excel file
  private function setBudgetHeader($activeSheet, $budget, $numOfSeasons, $title, $hideBudget = true, $hideTarget = true) {
    $headerStyle = array(
      'borders' => array(
        'allBorders' => array(
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
          'color' => array('argb' => 'FF606060'),
        ),
      ),
      'font' => array(
        'bold' => true
      ),
      'alignment' => array(
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER
      ),
    );

    $activeSheet->getStyle('A1')->applyFromArray($headerStyle);
    $activeSheet->getCell('A1')->setValue($title);

    $index = 1;
    if (!$hideTarget) {
      $thisColumn = $this->utility->getNameFromNumber($index);
      $value = ($budget->dsstag != '' ? $budget->dsstag : $budget->cdstag) . ' - ' . $this->translate('cart.analysis.target.qty');
      $activeSheet->getStyle($thisColumn . '1')->applyFromArray($headerStyle);
      $activeSheet->getCell($thisColumn . '1')->setValue($value);
      $index++;
      $thisColumn = $this->utility->getNameFromNumber($index);
      $value = ($budget->dsstag != '' ? $budget->dsstag : $budget->cdstag) . ' - ' . $this->translate('cart.analysis.target.amt');
      $activeSheet->getStyle($thisColumn . '1')->applyFromArray($headerStyle);
      $activeSheet->getCell($thisColumn . '1')->setValue($value);
      $index++;
    }
    if (!$hideBudget) {
      $thisColumn = $this->utility->getNameFromNumber($index);
      $value = ($budget->dsstag != '' ? $budget->dsstag : $budget->cdstag) . ' - ' . $this->translate('cart.analysis.budget.qty');
      $activeSheet->getStyle($thisColumn . '1')->applyFromArray($headerStyle);
      $activeSheet->getCell($thisColumn . '1')->setValue($value);
      $index++;
      $thisColumn = $this->utility->getNameFromNumber($index);
      $value = ($budget->dsstag != '' ? $budget->dsstag : $budget->cdstag) . ' - ' . $this->translate('cart.analysis.budget.amt');
      $activeSheet->getStyle($thisColumn . '1')->applyFromArray($headerStyle);
      $activeSheet->getCell($thisColumn . '1')->setValue($value);
      $index++;
    }
    $thisColumn = $this->utility->getNameFromNumber($index);
    $value = ($budget->dsstag != '' ? $budget->dsstag : $budget->cdstag) . ' - ' . $this->translate('cart.analysis.current.qty');
    $activeSheet->getStyle($thisColumn . '1')->applyFromArray($headerStyle);
    $activeSheet->getCell($thisColumn . '1')->setValue($value);
    $index++;
    if (!$hideTarget) {
      $thisColumn = $this->utility->getNameFromNumber($index);
      $value = ($budget->dsstag != '' ? $budget->dsstag : $budget->cdstag) . ' - ' . $this->translate('cart.analysis.current.qty') . ' %';
      $activeSheet->getStyle($thisColumn . '1')->applyFromArray($headerStyle);
      $activeSheet->getCell($thisColumn . '1')->setValue($value);
      $index++;
    }
    $thisColumn = $this->utility->getNameFromNumber($index);
    $value = ($budget->dsstag != '' ? $budget->dsstag : $budget->cdstag) . ' - ' . $this->translate('cart.analysis.current.amt');
    $activeSheet->getStyle($thisColumn . '1')->applyFromArray($headerStyle);
    $activeSheet->getCell($thisColumn . '1')->setValue($value);
    $index++;
    if (!$hideTarget) {
      $thisColumn = $this->utility->getNameFromNumber($index);
      $value = ($budget->dsstag != '' ? $budget->dsstag : $budget->cdstag) . ' - ' . $this->translate('cart.analysis.current.amt') . ' %';
      $activeSheet->getStyle($thisColumn . '1')->applyFromArray($headerStyle);
      $activeSheet->getCell($thisColumn . '1')->setValue($value);
      $index++;
    }

    if ($numOfSeasons > 0) {
      $thisColumn = $this->utility->getNameFromNumber($index);
      $value = ($budget->dsstg1 != '' ? $budget->dsstg1 : $budget->cdstg1) . ' - ' . $this->translate('cart.analysis.tot.qty');
      $activeSheet->getStyle($thisColumn . '1')->applyFromArray($headerStyle);
      $activeSheet->getCell($thisColumn . '1')->setValue($value);
      $index++;
      $thisColumn = $this->utility->getNameFromNumber($index);
      $value = ($budget->dsstg1 != '' ? $budget->dsstg1 : $budget->cdstg1) . ' - ' . $this->translate('cart.analysis.tot.amt');
      $activeSheet->getStyle($thisColumn . '1')->applyFromArray($headerStyle);
      $activeSheet->getCell($thisColumn . '1')->setValue($value);
      $index++;

      if ($numOfSeasons > 1) {
        $thisColumn = $this->utility->getNameFromNumber($index);
        $value = ($budget->dsstg2 != '' ? $budget->dsstg2 : $budget->cdstg2) . ' - ' . $this->translate('cart.analysis.tot.qty');
        $activeSheet->getStyle($thisColumn . '1')->applyFromArray($headerStyle);
        $activeSheet->getCell($thisColumn . '1')->setValue($value);
        $index++;
        $thisColumn = $this->utility->getNameFromNumber($index);
        $value = ($budget->dsstg2 != '' ? $budget->dsstg2 : $budget->cdstg2) . ' - ' . $this->translate('cart.analysis.tot.amt');
        $activeSheet->getStyle($thisColumn . '1')->applyFromArray($headerStyle);
        $activeSheet->getCell($thisColumn . '1')->setValue($value);
        $index++;

        if ($numOfSeasons > 2) {
          $thisColumn = $this->utility->getNameFromNumber($index);
          $value = ($budget->dsstg3 != '' ? $budget->dsstg3 : $budget->cdstg3) . ' - ' . $this->translate('cart.analysis.tot.qty');
          $activeSheet->getStyle($thisColumn . '1')->applyFromArray($headerStyle);
          $activeSheet->getCell($thisColumn . '1')->setValue($value);
          $index++;
          $thisColumn = $this->utility->getNameFromNumber($index);
          $value = ($budget->dsstg3 != '' ? $budget->dsstg3 : $budget->cdstg3) . ' - ' . $this->translate('cart.analysis.tot.amt');
          $activeSheet->getStyle($thisColumn . '1')->applyFromArray($headerStyle);
          $activeSheet->getCell($thisColumn . '1')->setValue($value);
          $index++;

          if ($numOfSeasons > 3) {
            $thisColumn = $this->utility->getNameFromNumber($index);
            $value = ($budget->dsstg4 != '' ? $budget->dsstg4 : $budget->cdstg4) . ' - ' . $this->translate('cart.analysis.tot.qty');
            $activeSheet->getStyle($thisColumn . '1')->applyFromArray($headerStyle);
            $activeSheet->getCell($thisColumn . '1')->setValue($value);
            $index++;
            $thisColumn = $this->utility->getNameFromNumber($index);
            $value = ($budget->dsstg4 != '' ? $budget->dsstg4 : $budget->cdstg4) . ' - ' . $this->translate('cart.analysis.tot.amt');
            $activeSheet->getStyle($thisColumn . '1')->applyFromArray($headerStyle);
            $activeSheet->getCell($thisColumn . '1')->setValue($value);
            $index++;
          }
        }
      }
    }
  }
  private function getGlobalBudgetBody($activeSheet, $budget, $numOfSeasons, $hideBudget = true, $hideTarget = true) {
    $i = 2;
    foreach ($budget as $item) {
      if ($item->tpanag != '' && $item->cdanag != '') {
        $currency =  $this->utility->getCurrencySymbol($item->cdvalu);

        $title = $item->tpanag . ' - ' . $item->cdanag . ' - ' . $item->descri;
        $this->getBudgetBodyRow($activeSheet, $i, $title, $item, $numOfSeasons, $currency, $hideBudget, $hideTarget);

        $i++;
      }
    }
  }
  private function getBudgetForCustomerBody($activeSheet, $budget, $numOfSeasons, $addBrand, $currency,
    $isLineSorting = true, $hideBudget = true, $hideTarget = true) {

    $i = 2;
    foreach ($budget as $item) {
      if ($isLineSorting) {
        $title = ($addBrand ? $item->dstitl . ' - ' : '') . $item->dslinm;
        $title .= $item->dsserm != '' ? ' - ' . $item->dsserm : '';
        $title .= ' - ' . ($item->dsuscc != '' ? $item->dsuscc : $item->cduscc);
      } else {
        $title = ($item->dsuscc != '' ? $item->dsuscc : $item->cduscc) . ' - ' . ($addBrand ? $item->dstitl . ' - ' : '') . $item->dslinm;
        $title .= $item->dsserm != '' ? ' - ' . $item->dsserm : '';;
      }
      $this->getBudgetBodyRow($activeSheet, $i, $title, $item, $numOfSeasons, $currency, $hideBudget, $hideTarget);

      $i++;
    }
  }
  private function getBudgetBodyRow($activeSheet, $i, $title, $item, $numOfSeasons, $currency, $hideBudget = true, $hideTarget = true) {
    $evenStyle1 = array(
      'fill' => array(
        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
        'color' => array('rgb' => 'FAFAFA')
      ),
      'borders' => array(
        'allBorders' => array(
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
          'color' => array('argb' => 'FF606060'),
        ),
      ),
      'alignment' => array(
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT
      ),
    );
    $evenStyle2 = array(
      'fill' => array(
        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
        'color' => array('rgb' => 'FAFAFA')
      ),
      'borders' => array(
        'allBorders' => array(
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
          'color' => array('argb' => 'FF606060'),
        ),
      ),
      'alignment' => array(
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT
      ),
    );
    $oddStyle1 = array(
      'fill' => array(
        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
        'color' => array('rgb' => 'EAEAEA')
      ),
      'borders' => array(
        'allBorders' => array(
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
          'color' => array('argb' => 'FF606060'),
        ),
      ),
      'alignment' => array(
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT
      ),
    );
    $oddStyle2 = array(
      'fill' => array(
        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
        'color' => array('rgb' => 'EAEAEA')
      ),
      'borders' => array(
        'allBorders' => array(
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
          'color' => array('argb' => 'FF606060'),
        ),
      ),
      'alignment' => array(
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT
      ),
    );

    $index = 0;
    $thisColumn = $this->utility->getNameFromNumber($index);
    $activeSheet->getStyle($thisColumn . $i)->applyFromArray($i % 2 == 0 ? $evenStyle1 : $oddStyle1);
    $activeSheet->getCell($thisColumn . $i)->setValue($title);
    $index++;

    if (!$hideTarget) {
      $thisColumn = $this->utility->getNameFromNumber($index);
      $activeSheet->getStyle($thisColumn . $i)->applyFromArray($i % 2 == 0 ? $evenStyle2 : $oddStyle2);
      $activeSheet->getStyle($thisColumn . $i)->getNumberFormat()->setFormatCode('#');
      $activeSheet->getCell($thisColumn . $i)->setValue($item->qtatrg);
      $index++;
      $thisColumn = $this->utility->getNameFromNumber($index);
      $activeSheet->getStyle($thisColumn . $i)->applyFromArray($i % 2 == 0 ? $evenStyle2 : $oddStyle2);
      $activeSheet->getStyle($thisColumn . $i)->getNumberFormat()->setFormatCode('#,##0.00');
      $activeSheet->getCell($thisColumn . $i)->setValue(number_format(floatval($item->valtrg), 2, ',', '.') . ' ' . $currency);
      $index++;
    }

    if (!$hideBudget) {
      $thisColumn = $this->utility->getNameFromNumber($index);
      $activeSheet->getStyle($thisColumn . $i)->applyFromArray($i % 2 == 0 ? $evenStyle2 : $oddStyle2);
      $activeSheet->getStyle($thisColumn . $i)->getNumberFormat()->setFormatCode('#');
      $activeSheet->getCell($thisColumn . $i)->setValue($item->qtabdg);
      $index++;
      $thisColumn = $this->utility->getNameFromNumber($index);
      $activeSheet->getStyle($thisColumn . $i)->applyFromArray($i % 2 == 0 ? $evenStyle2 : $oddStyle2);
      $activeSheet->getStyle($thisColumn . $i)->getNumberFormat()->setFormatCode('#,##0.00');
      $activeSheet->getCell($thisColumn . $i)->setValue(number_format(floatval($item->valbdg), 2, ',', '.') . ' ' . $currency);
      $index++;
    }

    $thisColumn = $this->utility->getNameFromNumber($index);
    $activeSheet->getStyle($thisColumn . $i)->applyFromArray($i % 2 == 0 ? $evenStyle2 : $oddStyle2);
    $activeSheet->getStyle($thisColumn . $i)->getNumberFormat()->setFormatCode('#');
    $activeSheet->getCell($thisColumn . $i)->setValue($item->currentSituation['totQty']);
    $index++;

    if (!$hideTarget) {
      $thisColumn = $this->utility->getNameFromNumber($index);
      $activeSheet->getStyle($thisColumn . $i)->applyFromArray($i % 2 == 0 ? $evenStyle2 : $oddStyle2);
      $activeSheet->getStyle($thisColumn . $i)->getNumberFormat()->setFormatCode('#,##0.00');
      $perc = $this->utility->getPerc($item->currentSituation['totQty'], $item->qtatrg);
      $activeSheet->getCell($thisColumn . $i)->setValue($perc != -1 ? $perc : 0);
      $index++;
    }

    $thisColumn = $this->utility->getNameFromNumber($index);
    $activeSheet->getStyle($thisColumn . $i)->applyFromArray($i % 2 == 0 ? $evenStyle2 : $oddStyle2);
    $activeSheet->getStyle($thisColumn . $i)->getNumberFormat()->setFormatCode('#,##0.00');
    $activeSheet->getCell($thisColumn . $i)->setValue(number_format(floatval($item->currentSituation['totAmt']), 2, ',', '.') . ' ' . $currency);
    $index++;

    if (!$hideTarget) {
      $thisColumn = $this->utility->getNameFromNumber($index);
      $activeSheet->getStyle($thisColumn . $i)->applyFromArray($i % 2 == 0 ? $evenStyle2 : $oddStyle2);
      $activeSheet->getStyle($thisColumn . $i)->getNumberFormat()->setFormatCode('#,##0.00');
      $perc = $this->utility->getPerc($item->currentSituation['totAmt'], $item->valtrg);
      $activeSheet->getCell($thisColumn . $i)->setValue($perc != -1 ? $perc : 0);
      $index++;
    }

    if ($numOfSeasons > 0) {
      $thisColumn = $this->utility->getNameFromNumber($index);
      $activeSheet->getStyle($thisColumn . $i)->applyFromArray($i % 2 == 0 ? $evenStyle2 : $oddStyle2);
      $activeSheet->getStyle($thisColumn . $i)->getNumberFormat()->setFormatCode('#');
      $activeSheet->getCell($thisColumn . $i)->setValue($item->qtast1);
      $index++;
      $thisColumn = $this->utility->getNameFromNumber($index);
      $activeSheet->getStyle($thisColumn . $i)->applyFromArray($i % 2 == 0 ? $evenStyle2 : $oddStyle2);
      $activeSheet->getStyle($thisColumn . $i)->getNumberFormat()->setFormatCode('#,##0.00');
      $activeSheet->getCell($thisColumn . $i)->setValue(number_format(floatval($item->valst1), 2, ',', '.') . ' ' . $currency);
      $index++;

      if ($numOfSeasons > 1) {
        $thisColumn = $this->utility->getNameFromNumber($index);
        $activeSheet->getStyle($thisColumn . $i)->applyFromArray($i % 2 == 0 ? $evenStyle2 : $oddStyle2);
        $activeSheet->getStyle($thisColumn . $i)->getNumberFormat()->setFormatCode('#');
        $activeSheet->getCell($thisColumn . $i)->setValue($item->qtast2);
        $index++;
        $thisColumn = $this->utility->getNameFromNumber($index);
        $activeSheet->getStyle($thisColumn . $i)->applyFromArray($i % 2 == 0 ? $evenStyle2 : $oddStyle2);
        $activeSheet->getStyle($thisColumn . $i)->getNumberFormat()->setFormatCode('#,##0.00');
        $activeSheet->getCell($thisColumn . $i)->setValue(number_format(floatval($item->valst2), 2, ',', '.') . ' ' . $currency);
        $index++;

        if ($numOfSeasons > 2) {
          $thisColumn = $this->utility->getNameFromNumber($index);
          $activeSheet->getStyle($thisColumn . $i)->applyFromArray($i % 2 == 0 ? $evenStyle2 : $oddStyle2);
          $activeSheet->getStyle($thisColumn . $i)->getNumberFormat()->setFormatCode('#');
          $activeSheet->getCell($thisColumn . $i)->setValue($item->qtast3);
          $index++;
          $thisColumn = $this->utility->getNameFromNumber($index);
          $activeSheet->getStyle($thisColumn . $i)->applyFromArray($i % 2 == 0 ? $evenStyle2 : $oddStyle2);
          $activeSheet->getStyle($thisColumn . $i)->getNumberFormat()->setFormatCode('#,##0.00');
          $activeSheet->getCell($thisColumn . $i)->setValue(number_format(floatval($item->valst3), 2, ',', '.') . ' ' . $currency);
          $index++;

          if ($numOfSeasons > 3) {
            $thisColumn = $this->utility->getNameFromNumber($index);
            $activeSheet->getStyle($thisColumn . $i)->applyFromArray($i % 2 == 0 ? $evenStyle2 : $oddStyle2);
            $activeSheet->getStyle($thisColumn . $i)->getNumberFormat()->setFormatCode('#');
            $activeSheet->getCell($thisColumn . $i)->setValue($item->qtast4);
            $index++;
            $thisColumn = $this->utility->getNameFromNumber($index);
            $activeSheet->getStyle($thisColumn . $i)->applyFromArray($i % 2 == 0 ? $evenStyle2 : $oddStyle2);
            $activeSheet->getStyle($thisColumn . $i)->getNumberFormat()->setFormatCode('#,##0.00');
            $activeSheet->getCell($thisColumn . $i)->setValue(number_format(floatval($item->valst4), 2, ',', '.') . ' ' . $currency);
            $index++;
          }
        }
      }
    }
  }
  //endregion

  //region Other utility functions
  private function setStylesForNewOrderXls($activeSheet, $totColumnName, $offset, $columns, $numRows, $numSizes, $cdetic, $isDefault) {
    // We need gray background on A1:B4 or A1:B5 (if label present) and A6:<n>6
    $headerStyle = array(
      'fill' => array(
        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
        'color' => array('rgb' => 'EEEEEE')
      ),
      'borders' => array(
        'allBorders' => array(
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
          'color' => array('argb' => 'FF606060'),
        ),
      ),
      'font' => array(
        'bold' => true
      ),
    );

    $activeSheet->getStyle('A6:' . $totColumnName . '6')->applyFromArray($headerStyle);
    if ($cdetic == -1) {
      $activeSheet->getStyle('A1:B4')->applyFromArray($headerStyle);
    } else {
      $activeSheet->getStyle('A1:B5')->applyFromArray($headerStyle);
    }

    // Set all cells style
    $activeSheet->getStyle('A7:' . $totColumnName . ($numRows + 6))->applyFromArray(
      array(
        'borders' => array(
          'allBorders' => array(
            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
            'color' => array('argb' => 'FF606060'),
          ),
        ),
        'alignment' => array(
          'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
        )
      )
    );

    // Set quantity cells style
    $h_align  = array('alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER));
    $fromCell = $this->utility->getNameFromNumber($offset) . '6';
    $toCell   = $this->utility->getNameFromNumber($columns) . '6';
    $activeSheet->getStyle($fromCell . ':' . $toCell)->applyFromArray($h_align);
    $activeSheet->getStyle('A')->applyFromArray($h_align);

    $h_align  = array('alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT));
    $fromCell = $isDefault ? 'B7' : 'A7';
    $toCell   = $this->utility->getNameFromNumber($offset - 1) . ($numRows + 6);
    $activeSheet->getStyle($fromCell . ':' . $toCell)->applyFromArray($h_align);

    $h_align = array('alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT));
    $fromCell = $this->utility->getNameFromNumber($offset + $numSizes) . '7';
    $toCell   = $this->utility->getNameFromNumber($isDefault ? $offset + $numSizes + 2 : $offset + $numSizes + 1) . ($numRows + 6);
    $activeSheet->getStyle($fromCell . ':' . $toCell)->applyFromArray($h_align);

    // White color to hide octest codes
    $styleArray = array('font'  => array('color' => array('rgb' => 'FFFFFF')));
    $activeSheet->getStyle('C1:C5')->applyFromArray($styleArray);
    $activeSheet->getStyle('D2')->applyFromArray($styleArray);

    $h_align  = array('alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER));
    $fromCell = $this->utility->getNameFromNumber($offset) . '7';
    $toCell   = $this->utility->getNameFromNumber($offset + $numSizes - 1) . ($numRows + 6);
    $activeSheet->getStyle($fromCell . ':' . $toCell)->applyFromArray($h_align);
  }

  private function setColumnWidthsForNewOrderXls($activeSheet, $offset, $columns, $numSizes, $imgOnXls, $isDefault) {
    $activeSheet->calculateColumnWidths();
    if ($isDefault) {
      $activeSheet->getColumnDimension('A')->setWidth($imgOnXls == 0 ? 25 : 20);
      $startIndex = 1;
    } else {
      $startIndex = 0;
    }

    for ($i = $startIndex; $i <= $columns; $i++) {
      if ($i >= $offset && $i < ($offset + $numSizes)) {
        $activeSheet->getColumnDimension($this->utility->getNameFromNumber($i))->setWidth(10);
      } else {
        $activeSheet->getColumnDimension($this->utility->getNameFromNumber($i))->setAutoSize(true);
      }
    }
  }

  private function fillOrderHeaderInfoForNewOrderXls($activeSheet, $cttest, $anagra, $desmer, $anaeti, $dtmcli, $rev_dtmcli) {
    $activeSheet->getCell('A1')->setValue(ucwords($this->translate('_common.catalog')));
    $activeSheet->getCell('B1')->setValue($cttest->dscata);
    $activeSheet->getCell('C1')->setValue($cttest->cdcata);
    $activeSheet->getCell('A2')->setValue(ucwords($this->translate('_common.customer')));
    $activeSheet->getCell('B2')->setValue($anagra->descri);
    $activeSheet->getCell('C2')->setValue($anagra->tpanag);
    $activeSheet->getCell('D2')->setValue($anagra->cdanag);
    $activeSheet->getCell('A3')->setValue(ucwords($this->translate('cart.deliverydate')));
    $activeSheet->getCell('B3')->setValue($rev_dtmcli != '00/00/0000' ? $rev_dtmcli : '');
    $activeSheet->getCell('C3')->setValue($dtmcli != '0000-00-00' ? $dtmcli : '');
    $activeSheet->getCell('A4')->setValue(ucwords($this->translate('cart.shipping')));
    if (!empty($desmer)) {
      $activeSheet->getCell('B4')->setValue($desmer->indiri . ' ' . $desmer->ccitta . ' ' . $desmer->provin);
      $activeSheet->getCell('C4')->setValue($desmer->cddesm);
    } else {
      $activeSheet->getCell('B4')->setValue($anagra->indiri . ' ' . $anagra->ccitta . ' ' . $anagra->provin);
    }
    if (!empty($anaeti) && $anaeti->cdetic != -1) {
      $activeSheet->getCell('A5')->setValue(ucwords($this->translate('_common.label')));
      $activeSheet->getCell('B5')->setValue($anaeti->dsetic);
      $activeSheet->getCell('C5')->setValue($anaeti->cdetic);
    }
  }

  private function fillRowsHeaderForDefaultNewOrderXls($activeSheet, $offset, $sizes, $currency, $isPT) {
    $activeSheet->getCell('A6')->setValue(ucwords($this->translate('_common.image')));

    $activeSheet->getCell('B6')->setValue(ucwords($this->translate('_common.description.article')));
    $activeSheet->getCell('C6')->setValue(ucwords($this->translate('_common.code.article')));
    $activeSheet->getCell('D6')->setValue(ucwords($this->translate('_common.description.color')));
    $activeSheet->getCell('E6')->setValue(ucwords($this->translate('_common.code.color')));
    $activeSheet->getCell('F6')->setValue(!$isPT ? ucwords($this->translate('_common.details')) : ucwords($this->translate('_common.variant.code')));
    $activeSheet->getCell('G6')->setValue(!$isPT ? ucwords($this->translate('_common.brand')) : ucwords($this->translate('_common.variant.description')));
    $activeSheet->getCell('H6')->setValue(!$isPT ? ucwords($this->translate('_common.line')) : ucwords($this->translate('_common.details')));
    $activeSheet->getCell('I6')->setValue(!$isPT ? ucwords($this->translate('_common.series')) : ucwords($this->translate('_common.brand')));
    $activeSheet->getCell('J6')->setValue(!$isPT ? ucwords($this->translate('_common.sizes.scale')) : ucwords($this->translate('_common.line')));
    if ($isPT) {
      $activeSheet->getCell('K6')->setValue(ucwords($this->translate('_common.series')));
      $activeSheet->getCell('L6')->setValue(ucwords($this->translate('_common.sizes.scale')));
    }

    for ($i = 0; $i < count($sizes); $i++) {
      $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i) . '6')->setValue($sizes[$i]['taglia']);
    }

    $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i) . '6')->setValue(ucwords($this->translate('_common.price')) . ' (' . $currency . ')');
    $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i + 1) . '6')->setValue(ucwords($this->translate('_common.quantity')));
    $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i + 2) . '6')->setValue(ucwords($this->translate('_common.total')) . ' (' . $currency . ')');

    $activeSheet->getCell(!$isPT ? 'K3' : 'M3')->setValue($this->translate('excel.warning1'));
    $activeSheet->mergeCells(!$isPT ? 'K3:AN3' : 'M3:AP3');
  }

  private function fillRowsHeaderForSpecialNewOrderXls($activeSheet, $offset, $numSizes, $currency, $isPT) {
    $activeSheet->getCell('A6')->setValue(ucwords($this->translate('_common.code.article')));
    $activeSheet->getCell('B6')->setValue(ucwords($this->translate('_common.description.article')));
    $activeSheet->getCell('C6')->setValue(ucwords($this->translate('_common.description.color')));

    $activeSheet->getCell('D6')->setValue(ucwords($this->translate('_common.code.color')));
    $activeSheet->getCell('E6')->setValue(!$isPT ? ucwords($this->translate('_common.brand')) : ucwords($this->translate('_common.variant.description')));

    $activeSheet->getCell('F6')->setValue(!$isPT ? ucwords($this->translate('_common.line')) : ucwords($this->translate('_common.details')));
    $activeSheet->getCell('G6')->setValue(!$isPT ? ucwords($this->translate('_common.series')) : ucwords($this->translate('_common.brand')));
    $activeSheet->getCell('H6')->setValue(!$isPT ? ucwords($this->translate('_common.sizes.scale')) : ucwords($this->translate('_common.line')));
    if ($isPT) {
      $activeSheet->getCell('I6')->setValue(ucwords($this->translate('_common.series')));
      $activeSheet->getCell('L6')->setValue(ucwords($this->translate('_common.sizes.scale')));
    }

    $activeSheet->getCell($this->utility->getNameFromNumber($offset + $numSizes) . '6')->setValue(ucwords($this->translate('_common.quantity')));
    $activeSheet->getCell($this->utility->getNameFromNumber($offset + $numSizes + 1) . '6')->setValue(ucwords($this->translate('_common.total')) . ' (' . $currency . ')');

    $activeSheet->getCell(!$isPT ? 'I3' : 'K3')->setValue($this->translate('excel.warning1'));
    $activeSheet->mergeCells(!$isPT ? 'I3:AL3' : 'K3:AN3');
  }
  //endregion

  //region Data retrieve functions
  private function getDefaultXlsTemplateRows($cdcata, $nulist, $sizes, $isPT) {
    $idlang = $this->utility->getLanguage();
    $articles = Ctarti::getCatalogDetailForXlsTemplate($cdcata, $nulist, $isPT, $idlang);
    $rows   = [];
    foreach ($articles as $article) {
      $full_article = $this->getSizesForArticleInDefaultXls($article, $sizes);
      $rows[] = $full_article;
    }

    return $rows;
  }

  private function getSpecialXlsTemplateRows($cdcata, $nulist, $isPT) {
    $idlang = $this->utility->getLanguage();
    $articles = Ctarti::getCatalogDetailForXlsTemplate($cdcata, $nulist, $isPT, $idlang);

    $rows   = [];
    foreach ($articles as $article) {
      $currentArticle = $article;
      $currentArticle->sizes = Postgl::getSizesWithPriceForSpecialXls($article->cdtagl, $article->cdarti, $nulist);
      $rows[] = $currentArticle;
    }

    return $rows;
  }

  private function getSizesForArticleInDefaultXls($article, $sizes) {
    $tempTable = '';

    for ($i = 0; $i < count($sizes); $i++) {
      if ($i != 0) {
        $tempTable .= 'UNION ';
      }
      $tempTable .= 'SELECT "' . $sizes[$i]['taglia'] . '" AS size, ' . $i . ' AS sizePos ';
    }

    if (!empty($tempTable)) {
      $query = 'SELECT size, sizePos
        FROM ( ' . $tempTable . ' ) AS allSizes
        LEFT JOIN postgl pt ON pt.taglia = size
        AND pt.taglia NOT IN (SELECT rq.taglia FROM regqta rq WHERE rq.cdarti = :cdarti AND rq.flbloc = 1)
        WHERE pt.cdtagl = :cdtagl ';
      $params = array('cdtagl' => $article->cdtagl, 'cdarti' => $article->cdarti);
      $currSizes = $this->db->query($query, $params)->fetchAll();
      $article->sizes = $currSizes;
    }

    return $article;
  }

  private function getMaxYForCurrentModel($cells, $y) {
    foreach ($cells as $cell) {
      if ($cell->y > $y) {
        if ($cell->type == 'tot') {
          return $cell->y - 1;
        } else if ($cell->type == 'cod' || $cell->type == 'img') {
          return $y;
        }
      }
    }

    return 0;
  }
  //endregion
}
