<?php

namespace Go2B\Controllers;

use Go2B\Library\Filters;
use Phalcon\Logger\Adapter\File as FileAdapter;
use Phalcon\Mvc\Controller;

/**
 * @property-read Utility $utility
 * @property-read Filters $filters
 * @property-read FileAdapter $logger
 */
class ControllerBase extends Controller
{
    protected function _getTransPath()
    {
        $translationPath = '../app/messages/';
        $language = $this->session->get('language');

        if (!$language) {
            $this->session->set('language', 'it');
        }

        switch ($language) {
            case 'en':
            case 'de':
            case 'es':
            case 'fr':
                return $translationPath . $language;
            default:
                return $translationPath . 'it';
        }
    }

    /**
     * Loads a translation for the whole site
     */
    public function loadMainTrans()
    {
//    $translationPath = $this->_getTransPath();
//    require $translationPath . '/main.php';
//
//    //Return a translation object
//    $mainTranslate = new NativeArray(array(
//      'content' => $messages
//    ));

        //Set $mt as main translation object
        $this->view->setVar('mt', $this->di->get('i18n'));
    }

    public function translate($arg, $params = null)
    {
        return $this->view->mt->_($arg, $params);
    }

    protected function forward($uri)
    {
        $uriParts = explode('/', $uri);
        $params = array_slice($uriParts, 2);
        return $this->dispatcher->forward(
            array(
                'controller' => $uriParts[0],
                'action' => $uriParts[1],
                'params' => $params
            )
        );
    }

    public function getConfigToken()
    {
        if (function_exists('mcrypt_create_iv')) {
            $random = mcrypt_create_iv(32);
        } else if (function_exists('random_bytes')) {
            $random = random_bytes(32);
        }
        $tokenId = base64_encode($random);
        $issuedAt = time();
        //$notBefore  = $issuedAt + 1;             //Adding 1 seconds
        $notBefore = $issuedAt + 10;             //Adding 10 seconds
        //$expire     = $issuedAt + 10;            // Adding 10 seconds
        $expire = $issuedAt + 60;            // Adding 10 seconds
        $serverName = $_SERVER['SERVER_NAME'];

        $data = [
            'iat' => $issuedAt,         // Issued at: time when the token was generated
            'jti' => $tokenId,          // Json Token Id: an unique identifier for the token
            'iss' => $serverName,       // Issuer
            'nbf' => $notBefore,        // Not before
            'exp' => $expire            // Expire
        ];
        return $data;
    }

    public function initialize()
    {
        if ($this->dispatcher->getControllerName() != 'pdf') {
            $title = $this->utility->getAppUtils('custom_title');
            $this->view->sendmailnewrequestaccess = $this->utility->getAppSettings('sendMailNewRequestAccess') == 1 ? true : false;
            $this->tag->prependTitle($title . " | ");
        }
        $this->view->hasShipmentConditions = $this->hasShipmentConditions();
        $this->view->utility = $this->utility;
        $this->view->diskManager = $this->diskManager;
        $this->loadMainTrans();
    }

    public function getShipmentConditions($lang = null)
    {
        $lang = strtolower($lang ?: $this->utility->getLanguage());
        if (!in_array($lang, ['it', 'en', 'de', 'fr', 'es'])) {
            $lang = 'it';
        }
        return $this->utility->getAppUtils('shipment_cond_' . $lang);
    }

    public function hasShipmentConditions($lang = null)
    {
        return !empty($this->getShipmentConditions($lang));
    }
}
