<?php

namespace Go2B\Controllers;

use Go2B\Models\B2bSysusr;
use Phalcon\Http\Request;
use Phalcon\Mvc\Model\Resultset\Simple as Resultset;

class ChatController extends ControllerBase
{
  //region Initialize
  public function initialize() {
    $this->tag->setTitle('Chat');
    parent::initialize();
  }
  //endregion

  //region Ajax functions
  public function startchatAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $user = $this->session->get('auth')['username'];
      $html = '';
      $lines = 0;

      // Update current user activity
      B2bSysusr::updateActivity($this->session->get('auth')['id']);

      // If chat folder doesn't exist, create it
      if (!file_exists('./chat')) {
        mkdir('./chat', 0777, true);
      }

      // Get chat html
      $file = './chat/' . $user . '.txt';
      if (!file_exists($file)) {
        // If chat file doesn't exist, create a new one with a default message
        $defaultStartMsg = date("H:i d/m/Y") . ' i: ' . htmlentities($this->translate('chat.defaultstartmessage'));
        file_put_contents($file, $defaultStartMsg);

        $html .= $this->utility->getHtmlChat($defaultStartMsg);
      } else {
        $chat = file_get_contents($file);

        $all_chat = explode("\n",$chat);
        foreach ($all_chat as $msg) {
          $html .= $this->utility->getHtmlChat($msg);
        }
      }

      echo json_encode(array("chat" => $html, "lines" => count(file($file))));
    }
  }

  public function updatechatAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $lines = isset($_POST['lines']) ? $_POST['lines'] : 0;
      $user = $this->session->get('auth')['username'];

      $html = '';
      $count = 0;

      $path = './chat/' . $user . '.txt';
      if (file_exists($path)) {
        $file = file($path);
        $count = count($file);

        for ($i = $lines; $i < $count; $i++) {
          $html .= $this->utility->getHtmlChat($file[$i]);
        }
      }

      echo json_encode(array('new_msg' => $html, 'curr_lines' => count($file)));
    }
  }

  public function addmessageAction() {
    $this->view->disable();

    $request = new Request();
    if ($request->isPost() && $request->isAjax()) {
      $user    = $this->session->get('auth')['username'];
      $message = $_POST['message'];

      B2bSysusr::updateActivity($this->session->get('auth')['id']);

      $chat = date("H:i d/m/Y") . ' o: ' . htmlentities($message);

      if (!file_exists('./chat')) {
        mkdir('./chat', 0777, true);
      }

      $file = './chat/' . $user . '.txt';
      $html = '';
      if (!file_exists($file)) {
        file_put_contents($file, $chat);
      } else {
        file_put_contents($file, file_get_contents($file) . "\n" . $chat);
      }

      echo json_encode("OK");
    }
  }
  //endregion
}
