<?php

namespace Go2B\Controllers;

use Go2B\Models\Anaart;
use Go2B\Models\Anagra;
use Go2B\Models\Anaper;
use Go2B\Models\Artcla;
use Go2B\Models\Artcol;
use Go2B\Models\B2bAddinf;
use Go2B\Models\B2bBramod;
use Go2B\Models\B2bCatimg;
use Go2B\Models\B2bClassificazione;
use Go2B\Models\B2bDisbdy;
use Go2B\Models\B2bGlcorp;
use Go2B\Models\B2bGltest;
use Go2B\Models\B2bHpcorp;
use Go2B\Models\B2bHptest;
use Go2B\Models\B2bModevi;
use Go2B\Models\B2bModinf;
use Go2B\Models\Barcod;
use Go2B\Models\Ctarti;
use Go2B\Models\Cttest;
use Go2B\Models\Dscorp;
use Go2B\Models\Imgart;
use Go2B\Models\Linmod;
use Go2B\Models\Lkarti;
use Go2B\Models\Lkcorp;
use Go2B\Models\Lkmode;
use Go2B\Models\Lktest;
use Go2B\Models\Occorp;
use Go2B\Models\Octagl;
use Go2B\Models\Octest;
use Go2B\Models\Postgl;
use Go2B\Models\Pvtest;
use Go2B\Models\Scacon;
use Go2B\Models\Sermod;
use Go2B\Models\Tipolo;
use Go2B\Models\Titlin;
use Phalcon\Http\Request;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

/**
 * @property-read Utility $utility
 */
class CatalogController extends ControllerBase
{
    //region Initalize
    public function initialize()
    {
        parent::initialize();
        $this->tag->setTitle($this->translate('_common.title.catalog'));
    }
    //endregion

    //region Views functions
    public function indexAction()
    {
        // Redirect if there are not catalogs available
        $id_usr = $this->session->get('auth')['id'];
//        $this->logger->debug(json_encode(debug_backtrace(), JSON_PRETTY_PRINT));
        $common = $this->utility->getCommonData('catalog', $id_usr);
        if (count($common['catalogs']) == 0) {
            return $this->response->redirect('account/info/pro');
        }

        $this->filters->resetFilters();

        // Check if we need to show one catalog or catalogs presentation (if present)
        $cdcata = urldecode($this->dispatcher->getParam('cdcata'));
        if ($common['isOrder']) {
            $cdcata = $common['order_info']->cdcata;
        }

        if ($cdcata == '') {
            $b2bctim = B2bCatimg::getCatalogsPresentation($id_usr);
            $showpres = count($b2bctim) > 0;
            $hideNavbar = $showpres;
        } else {
            $b2bctim = '';
            $showpres = false;
            $hideNavbar = false;
            $this->changeCatalog($cdcata);
            $common['selected_catalog'] = Cttest::findFirstByCdcata($cdcata);
        }

        $idlang = $this->utility->getLanguage();
        $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($id_usr);

        $this->view->hideNavbar = $hideNavbar;
        $this->view->showpres = $showpres;
        $this->view->ctlgpres = $b2bctim;
        $this->view->homepage = $this->getHomePage($common['selected_catalog']->cdcata);
        $this->view->featured = $this->getFeaturedModels($common['selected_catalog']->cdcata, $nulist, $common, $idlang);
        $this->view->common = $common;

        $this->view->buttonPosition = $this->config->release->user != 'dln' ? '10%' : '50%';
    }

    public function collectionAction()
    {
        // Questo va fatto prima di recuperare $common
        $this->session->set('ctl_view_mode', 'collection');

        // Redirect if there are not catalogs available
        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        $idlang = $this->utility->getLanguage();

        if (count($common['catalogs']) == 0) {
            $this->response->redirect('account/info/pro')->send();
            exit();
        }

        if (isset($_GET['fl']) && isset($_GET['cd'])) {
            $this->filters->resetFilters();
            switch ($_GET['fl']) {
                case "GE":
                    $filters = array();
                    $filters['tpgene'] = array(
                        'name' => 'tpgene',
                        'context' => 'AN',
                        'type' => 0,
                        'custom' => 0,
                        'filter' => array($_GET['cd']),
                    );
                    $this->session->set('filters', $filters);
                    break;
                case "TM":
                    $filters = array();
                    $filters['tpmode'] = array(
                        'name' => 'tpmode',
                        'context' => 'AN',
                        'type' => 0,
                        'custom' => 0,
                        'filter' => array($_GET['cd']),
                    );
                    $this->session->set('filters', $filters);
                    break;
            }
        }

        // Handle selection with params (if present)
        $cdtitl = urldecode($this->dispatcher->getParam('cdtitl'));
        $cdlinm = urldecode($this->dispatcher->getParam('cdlinm'));
        $cdserm = urldecode($this->dispatcher->getParam('cdserm'));
        $cdcata = $common['selected_catalog']->cdcata;
        $current = array();
        $filters = array();
        $this->handleCurrentSelection($cdcata, $cdtitl, $cdlinm, $cdserm, $current, $filters);

        $this->view->cdtitl = $cdtitl;
        $this->view->cdlinm = $cdlinm;
        $this->view->apply = $this->filters->getApplyFilters();
        $this->view->current = $current;
        $this->view->filters = $filters;
        $this->view->common = $common;

        // Get Banner Samuele 22.11.2022
        $brandcode = $this->session->get('filterBrand');

        $banner = B2bBramod::findFirst([
            "conditions" => "cdlinm = :cdlinm: AND cdling = :cdling:",
            "bind" => [
                "cdlinm" => $brandcode,
                "cdling" => $idlang,
            ],
        ]);

        // $validBanner = $banner ? (empty($banner->dsbann)) || empty($banner->fimag)) : false;
        $this->view->isShowFilterLeftSide = ($this->utility->getAppSettings('ShowFilterLeftSide') == 1) ? true : false;
        $this->view->isBrandBanner = ($this->utility->getAppSettings('BrandBanner') == 1) ? true : false;
        $this->view->isBanner = empty($banner->dsbann) ? false : true;
        $this->view->banner = $banner;
        $this->view->lang = $this->di->get('session')->get('language');

    }

    public function fabricAction()
    {
        // Questo va fatto prima di recuperare $common
        $this->session->set('ctl_view_mode', 'collection');

        // Redirect if there are not catalogs available
        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        if (count($common['catalogs']) == 0) {
            return $this->response->redirect('account/info/pro');
        }

        // Handle selection with params (if present)
        $cdtitl = urldecode($this->dispatcher->getParam('cdtitl'));
        $cdlinm = urldecode($this->dispatcher->getParam('cdlinm'));
        $cdserm = urldecode($this->dispatcher->getParam('cdserm'));
        $cdcata = $common['selected_catalog']->cdcata;
        $current = array();
        $filters = array();
        $this->handleCurrentSelection($cdcata, $cdtitl, $cdlinm, $cdserm, $current, $filters);

        $this->view->cdtitl = $cdtitl;
        $this->view->cdlinm = $cdlinm;
        $this->view->apply = $this->filters->getApplyFilters();
        $this->view->current = $current;
        $this->view->filters = $filters;
        $this->view->common = $common;
    }

    public function fabricDetailAction()
    {
        // Questo va fatto prima di recuperare $common
        $this->session->set('ctl_view_mode', 'collection');

        // Redirect if there are not catalogs available
        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        if (count($common['catalogs']) == 0) {
            return $this->response->redirect('account/info/pro');
        }

        $cdpers = urldecode($this->dispatcher->getParam('cdpers'));

        $common = $this->utility->getCommonData('catalog', $id_usr);
        $idlang = $this->utility->getLanguage();
        $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($id_usr);
        $cdcata = $common['selected_catalog']->cdcata;

        $flt = $this->filters->getFilterSubQuery();
        $section = array('where' => '', 'code' => '');

        if ($common['modelDetailStyle'] == 3) {
            $isSpecialSorting = B2bAddinf::isSpecialAgent($id_usr);
            if ($common['isOrder']) {
                $rulist = $common['order_info']->rulist;
            } else {
                $rulist = Anagra::getRulist($id_usr);
            }
        } else {
            $isSpecialSorting = false;
            $rulist = '';
        }

        $items = array(
            'cdpers' => $cdpers,
            'cdcata' => $cdcata,
            'nulist' => $nulist,
            'numdis' => $this->utility->getCustomDiscount(),
            'idlang' => $idlang,
            'idUsr' => $id_usr,
            'isOrder' => $common['isOrder'],
            'isPT' => Tipolo::findFirstByTppers('PT') != null,
            'rulist' => $rulist,
            'filters' => $flt,
            'section' => $section,
            'isSpecialSorting' => $isSpecialSorting,
        );

        // Handle selection with params (if present)
        $cdcata = $common['selected_catalog']->cdcata;
        $current = array();
        $filters = array();
        $this->handleCurrentSelectionForFabric($cdcata, $cdpers, $current, $filters);

        $this->view->models = Tipolo::getAllModelsFromFabricForCatalog($items);
        $this->view->fabric = Anaper::getFullFabric($cdpers, $idlang);
        $this->view->apply = $this->filters->getApplyFilters();
        $this->view->colors = Artcol::getAllColorsFromFabric($cdpers, $cdcata);
        $this->view->current = $current;
        $this->view->filters = $filters;
        $this->view->common = $common;
    }

    public function salesAction()
    {
        // Questo va fatto prima di recuperare $common
        $this->session->set('ctl_view_mode', 'collection');

        // Redirect if there are not catalogs available
        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        if (count($common['catalogs']) == 0) {
            return $this->response->redirect('account/info/pro');
        }

        // Handle selection with params (if present)
        $cdcata = $common['selected_catalog']->cdcata;
        $current = array();
        $filters = array();
        $this->handleCurrentSelection($cdcata, '', '', '', $current, $filters);

        $this->view->apply = $this->filters->getApplyFilters();
        $this->view->current = $current;
        $this->view->filters = $filters;
        $this->view->common = $common;

    }

    public function selectionAction()
    {
        // Questo va fatto prima di recuperare $common
        $this->session->set('ctl_view_mode', 'collection');

        // Redirect if there are not catalogs available
        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        if (count($common['catalogs']) == 0) {
            return $this->response->redirect('account/info/pro');
        }

        $cdspsl = $this->dispatcher->getParam('cdspsl');

        // Handle selection with params (if present)
        $cdcata = $common['selected_catalog']->cdcata;
        $current = array();
        $filters = array();
        $this->handleCurrentSelection($cdcata, '', '', '', $current, $filters);

        $this->view->cdspsl = $cdspsl;
        $this->view->apply = $this->filters->getApplyFilters();
        $this->view->current = $current;
        $this->view->filters = $filters;
        $this->view->common = $common;
    }

    public function tagAction()
    {
        // Questo va fatto prima di recuperare $common
        $this->session->set('ctl_view_mode', 'collection');

        // Redirect if there are not catalogs available
        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        if (count($common['catalogs']) == 0) {
            return $this->response->redirect('account/info/pro');
        }

        $tag = $this->dispatcher->getParam('tag');

        // Handle selection with params (if present)
        $cdtitl = urldecode($this->dispatcher->getParam('cdtitl'));
        $cdlinm = urldecode($this->dispatcher->getParam('cdlinm'));
        $cdcata = $common['selected_catalog']->cdcata;
        $current = array();
        $filters = array();
        $this->handleCurrentSelection($cdcata, '', '', '', $current, $filters);

        $this->view->apply = $this->filters->getApplyFilters();
        $this->view->current = $current;
        $this->view->filters = $filters;
        $this->view->tag = $tag;
        $this->view->common = $common;
    }

    public function listAction()
    {
        // Questo va fatto prima di recuperare $common
        $this->session->set('ctl_view_mode', 'list');

        // Redirect if there are not catalogs available
        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        if (count($common['catalogs']) == 0) {
            return $this->response->redirect('account/info/pro');
        }

        $cdtitl = $this->dispatcher->getParam('cdtitl');
        $cdlinm = $this->dispatcher->getParam('cdlinm');
        $cdserm = $this->dispatcher->getParam('cdserm');
        // Workaround
        if (empty($cdserm)) {
            $this->session->remove('ctg_view_type');
        } else {
            $this->session->set('ctg_view_type', 'sermod');
        }
        $view = $this->session->get('ctg_view_type');

        $request = $this->request;
        $page = $request->getQuery('page', 'int!', 1);
        if (empty($page)) {
            $page = 1;
        }
        if ($request->hasPost('filters')) {
            $this->filters->setFilters($request->getPost('filters'));
        } else {
            // $this->filters->resetFilters();
        }

        // Handle selection with params (if present)
        $cdcata = $common['selected_catalog']->cdcata;
        $current = array();
        $filters = array();
        $this->handleCurrentSelection($cdcata, $cdtitl, $cdlinm, $cdserm, $current, $filters);

        $flt = $this->filters->getFilterSubQuery();

        $sermod = $this->session->get('ctg_seri');
        $linmod = $this->session->get('ctg_line');
        $titlin = $this->session->get('ctg_brnd');

        $section = array('where' => '', 'code' => '');
        if ($view != 'all') {
            switch ($view) {
                case 'sermod':
                    $section = array(
                        'where' => ' AND tp.cdlinm = :code1: AND tp.cdserm = :code2: ',
                        'code1' => $sermod->cdlinm,
                        'code2' => $sermod->cdserm,
                    );
                    break;
                case 'linmod':
                    $section = array(
                        'where' => ' AND tp.cdlinm = :code: ',
                        'code' => $linmod->cdlinm,
                    );
                    break;
                case 'titlin':
                    $section = array(
                        'where' => ' AND lm.cdtitl = :code: ',
                        'code' => $titlin->cdtitl,
                    );
                    break;
            }
        }

        $idlang = $this->utility->getLanguage();
        $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($id_usr);
        $cntModels = 0;
        $tipolo = $this->getAllTipoloList($cdcata, $nulist, $flt, $section, $page, $common, false, $cntModels, $idlang);

        $counters['tot_models'] = $cntModels;
        $counters['page'] = $page;

        $this->view->cdtitl = $cdtitl;
        $this->view->cdlinm = $cdlinm;
        $this->view->apply = $flt['apply'];
        $this->view->counters = $counters;
        $this->view->current = $current;
        $this->view->filters = $filters;
        $this->view->goto = $this->session->get('goto');
        $this->view->tipolo = $tipolo;
        $this->view->common = $common;
        $this->view->lang = $this->di->get('session')->get('language');
    }

    public function quickorderAction()
    {
        // Questo va fatto prima di recuperare $common
        $this->session->set('ctl_view_mode', 'quickorder');

        // Redirect if there are not catalogs available
        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        if (count($common['catalogs']) == 0) {
            return $this->response->redirect('account/info/pro');
        }

        $page = 1;
        $request = new Request();
        if ($request->getQuery() != null && array_key_exists('page', $request->getQuery())) {
            $page = $request->getQuery()['page'];
        }

        $this->view->common = $common;
    }

    public function promoAction()
    {
        // Questo va fatto prima di recuperare $common
        $this->session->set('ctl_view_mode', 'promo');

        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        if (count($common['catalogs']) == 0) {
            return $this->response->redirect('account/info/pro');
        }

        $cdprom = $this->dispatcher->getParam('cdprom');
        $pvtest = Pvtest::findFirstByCdprom($cdprom);

        $this->view->promo = $pvtest;
        $this->view->common = $common;
    }

    public function galleryAction()
    {
        // Redirect if there are not catalogs available
        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        if (count($common['catalogs']) == 0) {
            return $this->response->redirect('account/info/pro');
        }

        $idlang = $this->utility->getLanguage();

        $description = 'des_' . strtolower($idlang);
        $galleries = array();
        $gltest = B2bGltest::getGalleriesForCatalog($common['selected_catalog']->cdcata, $idlang);
        foreach ($gltest as $gallery) {
            $currentGallery = $gallery;
            $currentGallery->points = B2bGlcorp::findByNugall($gallery->nugall);
            $currentGallery->title = $gallery->$description;
            $galleries[] = $currentGallery;
        }

        $galleryType = $this->utility->getAppSettings('EnableCatalogGalleries');

        $this->view->galleries = $galleries;
        $this->view->galleryType = $galleryType;
        $this->view->common = $common;
    }

    public function setFilterFromHomepageAction()
    {
        // Check whether the request was made with method POST
        $tpbloc = urldecode($this->dispatcher->getParam("tpbloc"));
        $codice = urldecode($this->dispatcher->getParam("codice"));
        $cdtitl = urldecode($this->dispatcher->getParam("cdtitl"));
        $cdlinm = urldecode($this->dispatcher->getParam("cdlinm"));

        $this->filters->resetFilters();

        if (strlen($tpbloc) == 2) {
            switch ($tpbloc) {
                case "BR":
                    $this->filters->setFilterForBrand($codice);
                    break;
                case "LI":
                    $this->filters->setFilterForLine($codice);
                    // MARCO 23.11.2022
                    //$filters = array();
                    //$filters['linmod'] = $codice;
                    $this->session->set('filterBrand', $codice);

                    break;
                case "SE":
                    $codes = explode('___', $codice);
                    $this->filters->setFilterForSeries($codes[0], $codes[1]);
                    break;
                case "GE":
                    $filters = array();
                    $filters['tpgene'] = array(
                        'name' => 'tpgene',
                        'context' => 'AN',
                        'type' => 0,
                        'custom' => 0,
                        'filter' => array($codice),
                    );
                    $this->session->set('filters', $filters);
                    break;
                case "GL":
                    $filters = array();
                    $filters['tpgene'] = array(
                        'name' => 'tpgene',
                        'context' => 'AN',
                        'type' => 0,
                        'custom' => 0,
                        'filter' => array($codice),
                    );
                    $filters['titlin'] = array(
                        'name' => 'titlin',
                        'context' => 'AN',
                        'type' => 0,
                        'custom' => 0,
                        'filter' => array($cdtitl),
                    );
                    $filters['linmod'] = array(
                        'name' => 'linmod',
                        'context' => 'AN',
                        'type' => 0,
                        'custom' => 0,
                        'filter' => array($cdlinm),
                    );
                    $this->session->set('filters', $filters);
                    break;
                case "TM":
                    $filters = array();
                    $filters['tpmode'] = array(
                        'name' => 'tpmode',
                        'context' => 'AN',
                        'type' => 0,
                        'custom' => 0,
                        'filter' => array($codice),
                    );
                    $this->session->set('filters', $filters);
                    $this->session->set('filterBrand', "");
                    break;
            }
        } else {
            $tpinpu = substr($tpbloc, 0, 2);
            $tpcrar = substr($tpbloc, 2, 4);
            $filters = array();
            $filters[$tpcrar] = array(
                'name' => $tpcrar,
                'context' => $tpinpu,
                'type' => 1,
                'custom' => 0,
                'filter' => array($codice),
            );
            $this->session->set('filters', $filters);
        }

        if ($this->utility->getAppSettings('CatalogAccessType') == 0) {
            $this->response->redirect("catalog/collection");
        } else if ($this->utility->getAppSettings('CatalogAccessType') == 1) {
            $this->response->redirect("catalog/list");
        }
    }

    public function availabilitylistAction()
    {
        $this->view->common = $this->utility->getCommonData('catalog');
    }

    public function resultsAction()
    {
        // Redirect if there are not catalogs available
        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        if (count($common['catalogs']) == 0) {
            $this->response->redirect('account/info/pro')->send();
            exit();
        }

//        $this->filters->resetFilters();

        $search = "";
        $request = new Request();
        if ($request->getQuery() != null && array_key_exists('search', $request->getQuery())) {
            $search = $request->getQuery()['search'];
        }

        $idlang = $this->utility->getLanguage();
        $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($id_usr);
        $cdcata = $common['selected_catalog']->cdcata;
        $current = array();
        $filters = array();
        $this->handleCurrentSelection($cdcata, '', '', '', $current, $filters);

        $flt = $this->filters->getFilterSubQuery();


        $common['customer_discount'] = 0;
        if ($common['isOrder'] && $this->utility->getAppSettings('ShowBaseCustomerDiscount') == 1) {
            $customer = Anagra::findCustomerByKey($common['order_info']->tpanag, $common['order_info']->cdanag);
            if ($customer instanceof Anagra) {
                $common['customer_discount'] = $customer->scont1;
            }
        }

        $this->view->common = $common;
        $this->view->baseDiscount = $common['customer_discount'];
        $this->view->products = $this->getAllProductsFromSearch($cdcata, $search, $nulist, $flt, $common, $idlang);
        $this->view->apply = $this->filters->getApplyFilters();
        $this->view->current = $current;
        $this->view->filters = $filters;
    }

    public function resultsfabricAction()
    {
        // Redirect if there are not catalogs available
        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        if (count($common['catalogs']) == 0) {
            return $this->response->redirect('account/info/pro');
        }

        $this->filters->resetFilters();

        $search = "";
        $request = new Request();
        if ($request->getQuery() != null && array_key_exists('search', $request->getQuery())) {
            $search = $request->getQuery()['search'];
        }

        $cdcata = $common['selected_catalog']->cdcata;

        $this->view->common = $common;
        $this->view->fabrics = $this->getAllFabricsFromSearch($cdcata, $search);
    }

    public function resultslistAction()
    {
        // Redirect if there are not catalogs available
        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        if (count($common['catalogs']) == 0) {
            return $this->response->redirect('account/info/pro');
        }

        $this->filters->resetFilters();

        $search = "";
        if ($this->request->hasQuery('search')) {
            $search = $this->request->getQuery('search');
        }

        $idlang = $this->utility->getLanguage();
        $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($id_usr);
        $cdcata = $common['selected_catalog']->cdcata;

        $this->view->common = $common;
        $this->view->tipolo = $this->getAllTipoloFromSearchList($cdcata, $search, $nulist, $common, false, $idlang);
    }

    public function resultsquickorderAction()
    {
        // Redirect if there are not catalogs available
        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        if (count($common['catalogs']) == 0) {
            return $this->response->redirect('account/info/pro');
        }

        $this->filters->resetFilters();

        $search = "";
        $request = new Request();
        if ($request->getQuery() != null && array_key_exists('search', $request->getQuery())) {
            $search = $request->getQuery()['search'];
        }

        $idlang = $this->utility->getLanguage();
        $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($id_usr);
        $cdcata = $common['selected_catalog']->cdcata;

        $this->view->common = $common;
        $this->view->tipolo = $this->getAllTipoloFromSearchList($cdcata, $search, $nulist, $common, true, $idlang);
    }

    public function lookbookAction()
    {
        // Redirect if there are not catalogs available
        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        if (count($common['catalogs']) == 0) {
            return $this->response->redirect('account/info/pro');
        }

        $cdlkbk = $this->dispatcher->getParam('cdlkbk');
        $showDetails = $this->utility->getAppSettings('LookbookViewType') == 1;
        $lktest = $this->getLookbook($cdlkbk);
        if ($showDetails) {
            if (isset($lktest['lkcorp'])) {
                $newLkcorp = array();
                $idlang = $this->utility->getLanguage();
                $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($id_usr);
                $numdis = $this->utility->getCustomDiscount();

                foreach ($lktest['lkcorp'] as $lkcorp) {
                    $currentLkcorp = $lkcorp->toArray();
                    switch ($lktest['fltipo']) {
                        case 0:
                            $items = Lkmode::getModelsForLook($cdlkbk, $lkcorp['cdlook'], $nulist, $numdis, $idlang);
                            break;
                        case 1:
                            $items = Lkarti::getArticlesForLook($cdlkbk, $lkcorp['cdlook'], $nulist, $numdis, $idlang);
                            break;
                        case 2:
                            $items = Lkarti::getLardiniArticlesForLook($cdlkbk, $lkcorp['cdlook'], $nulist, $numdis, $idlang);
                            break;
                    }
                    $currentLkcorp['items'] = $items;

                    $newLkcorp[] = $currentLkcorp;
                }
                $lktest['lkcorp'] = $newLkcorp;
            }
        }

        $this->view->common = $common;
        $this->view->lktest = $lktest;
        $this->view->cdlkbk = $cdlkbk;
        $this->view->showDetails = $showDetails;
    }

    public function lookAction()
    {
        // Redirect if there are not catalogs available
        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        if (count($common['catalogs']) == 0) {
            return $this->response->redirect('account/info/pro');
        }

        $cdlkbk = $this->dispatcher->getParam('cdlkbk');
        $cdlook = $this->dispatcher->getParam('cdlook');
        $idlang = $this->utility->getLanguage();
        $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($id_usr);
        $lktest = $this->getLookbook($cdlkbk);
        $lkcorp = $this->getLook($cdlkbk, $cdlook, $lktest['fltipo'], $nulist, $common, $idlang);

        $this->view->cdlkbk = $cdlkbk;
        $this->view->cdlook = $cdlook;
        $this->view->lktest = $lktest;
        $this->view->lkcorp = $lkcorp;
        $this->view->common = $common;
    }

    public function exportAvailabilityAction()
    {
        $this->view->common = $this->utility->getCommonData('catalog', $this->session->get('auth')['id']);
    }

    public function exportBrandAction()
    {
        $this->view->common = $this->utility->getCommonData('catalog', $this->session->get('auth')['id']);
    }
    //endregion

    //region Ajax functions
    public function changecatalogAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $this->changeCatalog($_POST['cdcata']);
            echo json_encode('OK');
        }
    }

    public function searchAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $search = $_POST['search_term'];
            $cdcata = $_POST['catalog'];

            $results = $this->getNumOfResults($cdcata, $search, $this->utility->getAppSettings('ProductTypeOnCatalog'));

            echo json_encode($results);
        }
    }

    public function searchFabricAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $search = $_POST['search_term'];
            $cdcata = $_POST['catalog'];

            $results = $this->getNumOfResults($cdcata, $search, $this->utility->getAppSettings('ProductTypeOnCatalog'), true);

            echo json_encode($results);
        }
    }

    public function loadFiltersCollectionAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            try {
                $id_usr = $this->session->get('auth')['id'];
                $view = $this->session->get('ctg_view_type');
                $sermod = $this->session->get('ctg_seri');
                $linmod = $this->session->get('ctg_line');
                $titlin = $this->session->get('ctg_brnd');

                if (isset($_POST['filters'])) {
                    $this->filters->setFilters($_POST['filters']);
                } else {
                    $this->filters->resetFilters();
                }

                $common = $this->utility->getCommonData('catalog', $id_usr);
                $this->view->common = $common;
                $idlang = $this->utility->getLanguage();
                $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($id_usr);
                $cdcata = $common['selected_catalog']->cdcata;

                $flt = $this->filters->getFilterSubQuery();

                $section = array('where' => '', 'code' => '');
                if ($view != 'all') {
                    switch ($view) {
                        case 'sermod':
                            $section = array(
                                'where' => ' AND tp.cdlinm = :code1: AND tp.cdserm = :code2: ',
                                'code1' => $sermod->cdlinm,
                                'code2' => $sermod->cdserm,
                            );
                            break;
                        case 'linmod':
                            $section = array(
                                'where' => ' AND tp.cdlinm = :code: ',
                                'code' => $linmod->cdlinm,
                            );
                            break;
                        case 'titlin':
                            $section = array(
                                'where' => ' AND lm.cdtitl = :code: ',
                                'code' => $titlin->cdtitl,
                            );
                            break;
                    }
                }

                if ($this->session->get('filterBrand') != "") {
                    $section = array(
                        'where' => ' AND tp.cdlinm = :code: ',
                        'code' => $this->session->get('filterBrand'),
                    );
                }

                $products = $this->getAllProducts($cdcata, $nulist, $flt, $section, $common, $idlang);
                $block_index = 0;
                $html = '';

                $lazyBreakpoint = 12;

                if (count($products) > 0) {
                    $cdtitl = $products[0]->cdtitl;
                    $cdlinm = $products[0]->cdlinm;
                    $cdserm = $products[0]->cdserm;

                    $sectionTitleMode = $this->utility->getAppSettings('SectionTitle');

                    $block_index++;

                    $titlePieces = [];
                    if (strpos($sectionTitleMode, 'marchio') !== false && !empty($products[0]->dstitl)) {
                        $titlePieces[] = $products[0]->dstitl;
                    }
                    if (strpos($sectionTitleMode, 'linea') !== false && !empty($products[0]->dslinm)) {
                        $titlePieces[] = $products[0]->dslinm;
                    }
                    if (strpos($sectionTitleMode, 'serie') !== false && !empty($products[0]->dsserm)) {
                        $titlePieces[] = $products[0]->dsserm;
                    }

                    $title = htmlentities(implode(" - ", $titlePieces), ENT_COMPAT, 'UTF-8');

                    if ($cdserm != '') {
                        $banner = $products[0]->banner_serm;
                    } else {
                        $banner = $products[0]->banner_linm;
                    }

                    //$modello = $this->getFullProduct($cdcata, $products[0]->cdartn, $nulist, $common['catalogProductType'] == 0, $idlang);
                    $html .= $this->getHtmlCodeForContainer($block_index, $title, $banner);
//                    $html .= $this->elements->getColorVariantForProduct($modello);

                    // To modify product link
                    //$common['onlyTag'] = $this->showOnlyTag($flt);

                    foreach ($products as $product) {

                        $enableParamCollectionNoTitle = $this->utility->getAppSettings('ParamCollectionNoTitle');
                        if ($enableParamCollectionNoTitle == 0) {

                            if ($product->cdtitl != $cdtitl || $product->cdlinm != $cdlinm || $product->cdserm != $cdserm) {
                                $html .= $this->getHtmlCodeForContainerClosure();

                                // Update current section
                                $cdtitl = $product->cdtitl;
                                $cdlinm = $product->cdlinm;
                                $cdserm = $product->cdserm;
                                $block_index++;

                                $titlePieces = [];
                                if (strpos($sectionTitleMode, 'marchio') !== false && !empty($product->dstitl)) {
                                    $titlePieces[] = $product->dstitl;
                                }
                                if (strpos($sectionTitleMode, 'linea') !== false && !empty($product->dslinm)) {
                                    $titlePieces[] = $product->dslinm;
                                }
                                if (strpos($sectionTitleMode, 'serie') !== false && !empty($product->dsserm)) {
                                    $titlePieces[] = $product->dsserm;
                                }

                                $title = htmlentities(implode(" - ", $titlePieces), ENT_COMPAT, 'UTF-8');

                                if ($cdserm != '') {
                                    $banner = $product->banner_serm;
                                } else {
                                    $banner = $product->banner_linm;
                                }

                                $html .= $this->getHtmlCodeForContainer($block_index, $title, $banner);

                            }
                        }

                        $items = array(
                            'cdcata' => $cdcata,
                            'cdartn' => $product->cdartn,
                            'nulist' => $nulist,
                            'idlang' => $idlang,
                            'id_usr' => $this->session->get('auth')['id'],
                            'numdis' => 0,
                            'modelDetailStyle' => $this->utility->getAppSettings('ModelDetailStyle'),
                            'colorAssignmentSource' => $this->utility->getAppSettings('ColorAssignmentSource'),
                        );
                        $html .= $this->getHtmlCodeForProduct($product, $lazyBreakpoint-- < 0, $common, $items);

                        // Samuele
                        //$html .= '<div class="row pt-20x px-15x"> ';
                        //$html .= '</div>';

                    }
                }
                // Close last container
                $html .= $this->getHtmlCodeForContainerClosure();
            } catch (\Exception $ex) {
                var_dump($ex);
                die();
            }

            echo json_encode($html, JSON_UNESCAPED_UNICODE);
        } else {
            echo json_encode('ERROR');
        }
    }

    public function loadFiltersFabricAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $view = $this->session->get('ctg_view_type');
            $sermod = $this->session->get('ctg_seri');
            $linmod = $this->session->get('ctg_line');
            $titlin = $this->session->get('ctg_brnd');

            if (isset($_POST['filters'])) {
                $this->filters->setFilters($_POST['filters']);
            } else {
                $this->filters->resetFilters();
            }

            $id_usr = $this->session->get('auth')['id'];
            $catalogs = $this->utility->getAvailableCatalogs($id_usr);
            $isOrder = Octest::findOrderInProgress($id_usr) != null;
            $order_info = $isOrder ? Octest::getCurrentOrder($id_usr) : null;

            $cdcata = $this->utility->getSelectedCatalog($isOrder, $order_info, $catalogs)->cdcata;

            $flt = $this->filters->getFilterSubQuery();

            $section = array('where' => '', 'code' => '');
            if ($view != 'all') {
                switch ($view) {
                    case 'sermod':
                        $section = array(
                            'where' => ' AND tp.cdlinm = :code1: AND tp.cdserm = :code2: ',
                            'code1' => $sermod->cdlinm,
                            // TODO Questo mi sembra un typo altrove è $sermod->cdserm
                            'code2' => $linmod->cdserm,
                        );
                        break;
                    case 'linmod':
                        $section = array(
                            'where' => ' AND tp.cdlinm = :code: ',
                            'code' => $linmod->cdlinm,
                        );
                        break;
                    case 'titlin':
                        $section = array(
                            'where' => ' AND lm.cdtitl = :code: ',
                            'code' => $titlin->cdtitl,
                        );
                        break;
                }
            }

            $fabrics = $this->getAllFabrics($cdcata, $flt, $section);

            $html = '';

            $i = 12;

            if (count($fabrics) > 0) {
                if ($view == 'linmod' || $view == 'titlin') {
                    $title = ($view == 'linmod' ? $titlin->cdtitl . ' - ' : '') . $linmod->cdlinm;
                } else {
                    $title = '';
                }
                $html .= $this->getHtmlCodeForContainer(1, htmlentities($title, ENT_COMPAT, 'UTF-8'));

                foreach ($fabrics as $fabric) {
                    if ($i > 0) {
                        $html .= $this->getHtmlCodeForFabric($fabric, false);
                        $i--;
                    } else {
                        $html .= $this->getHtmlCodeForFabric($fabric, true);
                    }
                }

                // Close last container
                $html .= $this->getHtmlCodeForContainerClosure();
            }
            echo json_encode($html, JSON_UNESCAPED_UNICODE);
        }
    }

    public function loadFiltersSalesAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $id_usr = $this->session->get('auth')['id'];
            $view = $this->session->get('ctg_view_type');
            $sermod = $this->session->get('ctg_seri');
            $linmod = $this->session->get('ctg_line');
            $titlin = $this->session->get('ctg_brnd');

            $this->filters->setFilters($_POST['filters']);

            $common = $this->utility->getCommonData('catalog', $id_usr);
            $idlang = $this->utility->getLanguage();
            $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($id_usr);
            $cdcata = $common['selected_catalog']->cdcata;
            $this->view->common = $common;

            $flt = $this->filters->getFilterSubQuery();

            $section = array('where' => '', 'code' => '');
            if ($view != 'all') {
                switch ($view) {
                    case 'sermod':
                        $section = array(
                            'where' => ' AND tp.cdlinm = :code1: AND tp.cdserm = :code2: ',
                            'code1' => $sermod->cdlinm,
                            // TODO Questo mi sembra un typo altrove è $sermod->cdserm
                            'code2' => $linmod->cdserm,
                        );
                        break;
                    case 'linmod':
                        $section = array(
                            'where' => ' AND tp.cdlinm = :code: ',
                            'code' => $linmod->cdlinm,
                        );
                        break;
                    case 'titlin':
                        $section = array(
                            'where' => ' AND lm.cdtitl = :code: ',
                            'code' => $titlin->cdtitl,
                        );
                        break;
                }
            }
            $tipolo = $this->getAllProducts($cdcata, $nulist, $flt, $section, $common, $idlang, true);

            $block_index = 0;
            $html = '';

            $i = 12;

            if (count($tipolo) > 0) {
                $cdtitl = $tipolo[0]->cdtitl;
                $cdlinm = $tipolo[0]->cdlinm;
                $cdserm = $tipolo[0]->cdserm;

                $block_index++;
                if ($cdserm != '') {
                    $title = htmlentities($tipolo[0]->dstitl . " - " . $tipolo[0]->dslinm . " - " . $tipolo[0]->dsserm, ENT_COMPAT, 'UTF-8');
                    $banner = $tipolo[0]->banner_serm;
                } else {
                    $title = htmlentities($tipolo[0]->dstitl . " - " . $tipolo[0]->dslinm, ENT_COMPAT, 'UTF-8');
                    $banner = $tipolo[0]->banner_linm;
                }
                $html .= $this->getHtmlCodeForContainer($block_index, $title, $banner);

                foreach ($tipolo as $model) {

                    if ($model->cdtitl != $cdtitl || $model->cdlinm != $cdlinm || $model->cdserm != $cdserm) {
                        // Model is of different brand or line or series, so close container
                        $enableParamCollectionNoTitle = $this->utility->getAppSettings('ParamCollectionNoTitle');
                        if ($enableParamCollectionNoTitle == 0) {

                            $html .= $this->getHtmlCodeForContainerClosure();

                            // Update current section
                            $cdtitl = $model->cdtitl;
                            $cdlinm = $model->cdlinm;
                            $cdserm = $model->cdserm;
                            $block_index++;
                            if ($cdserm != '') {
                                $title = htmlentities($model->dstitl . " - " . $model->dslinm . " - " . $model->dsserm, ENT_COMPAT, 'UTF-8');
                                $banner = $model->banner_serm;
                            } else {
                                $title = htmlentities($model->dstitl . " - " . $model->dslinm, ENT_COMPAT, 'UTF-8');
                                $banner = $model->banner_linm;
                            }
                            $html .= $this->getHtmlCodeForContainer($block_index, $title, $banner);
                        }

                    }

                    if ($i > 0) {
                        $items = array(
                            'cdcata' => $cdcata,
                            'cdartn' => $model->cdartn,
                            'nulist' => $nulist,
                            'idlang' => $idlang,
                            'id_usr' => $this->session->get('auth')['id'],
                            'numdis' => 0,
                            'modelDetailStyle' => $this->utility->getAppSettings('ModelDetailStyle'),
                            'colorAssignmentSource' => $this->utility->getAppSettings('ColorAssignmentSource'),
                        );
                        $html .= $this->getHtmlCodeForProduct($model, false, $common, $items);
                        $i--;
                    } else {
                        $items = array(
                            'cdcata' => $cdcata,
                            'cdartn' => $model->cdartn,
                            'nulist' => $nulist,
                            'idlang' => $idlang,
                            'id_usr' => $this->session->get('auth')['id'],
                            'numdis' => 0,
                            'modelDetailStyle' => $this->utility->getAppSettings('ModelDetailStyle'),
                            'colorAssignmentSource' => $this->utility->getAppSettings('ColorAssignmentSource'),
                        );
                        $html .= $this->getHtmlCodeForProduct($model, true, $common, $items);
                    }
                }

                // Close last container
                $html .= $this->getHtmlCodeForContainerClosure();
            }

            echo json_encode($html, JSON_UNESCAPED_UNICODE);
        }
    }

    public function loadFiltersSelectionAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $id_usr = $this->session->get('auth')['id'];
            $view = $this->session->get('ctg_view_type');
            $sermod = $this->session->get('ctg_seri');
            $linmod = $this->session->get('ctg_line');
            $titlin = $this->session->get('ctg_brnd');

            if (isset($_POST['filters'])) {
                $this->filters->setFilters($_POST['filters']);
            }

            $cdspsl = $this->dispatcher->getParam('cdspsl');

            $common = $this->utility->getCommonData('catalog', $id_usr);
            $idlang = $this->utility->getLanguage();
            $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($id_usr);
            $cdcata = $common['selected_catalog']->cdcata;

            $flt = $this->filters->getFilterSubQuery();

            $section = array('where' => '', 'code' => '');
            if ($view != 'all') {
                switch ($view) {
                    case 'sermod':
                        $section = array(
                            'where' => ' AND tp.cdlinm = :code1: AND tp.cdserm = :code2: ',
                            'code1' => $sermod->cdlinm,
                            // TODO Questo mi sembra un typo altrove è $sermod->cdserm
                            'code2' => $linmod->cdserm,
                        );
                        break;
                    case 'linmod':
                        $section = array(
                            'where' => ' AND tp.cdlinm = :code: ',
                            'code' => $linmod->cdlinm,
                        );
                        break;
                    case 'titlin':
                        $section = array(
                            'where' => ' AND lm.cdtitl = :code: ',
                            'code' => $titlin->cdtitl,
                        );
                        break;
                }
            }
            $tipolo = $this->getAllProducts($cdcata, $nulist, $flt, $section, $common, $idlang, false, '', $cdspsl);

            $block_index = 0;
            $html = '';

            $i = 12;

            if (count($tipolo) > 0) {
                $cdtitl = $tipolo[0]->cdtitl;
                $cdlinm = $tipolo[0]->cdlinm;
                $cdserm = $tipolo[0]->cdserm;

                $block_index++;
                $html .= $this->getHtmlCodeForContainer($block_index, '');

                foreach ($tipolo as $model) {
                    if ($i > 0) {
                        $html .= $this->getHtmlCodeForProduct($model, false, $common);
                        $i--;
                    } else {
                        $html .= $this->getHtmlCodeForProduct($model, true, $common);
                    }
                }

                // Close last container
                $html .= $this->getHtmlCodeForContainerClosure();
            }

            echo json_encode($html, JSON_UNESCAPED_UNICODE);
        }
    }

    public function loadFiltersTagAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $id_usr = $this->session->get('auth')['id'];
            $view = $this->session->get('ctg_view_type');
            $sermod = $this->session->get('ctg_seri');
            $linmod = $this->session->get('ctg_line');
            $titlin = $this->session->get('ctg_brnd');

            $tag = isset($_POST['tag']) ? $_POST['tag'] : '';

            $this->filters->setFilters($_POST['filters']);

            $common = $this->utility->getCommonData('catalog', $id_usr);
            $idlang = $this->utility->getLanguage();
            $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($id_usr);
            $cdcata = $common['selected_catalog']->cdcata;

            $flt = $this->filters->getFilterSubQuery();

            $section = array('where' => '', 'code' => '');
            if ($view != 'all') {
                switch ($view) {
                    case 'sermod':
                        $section = array(
                            'where' => ' AND tp.cdlinm = :code1: AND tp.cdserm = :code2: ',
                            'code1' => $sermod->cdlinm,
                            // TODO Questo mi sembra un typo altrove è $sermod->cdserm
                            'code2' => $linmod->cdserm,
                        );
                        break;
                    case 'linmod':
                        $section = array(
                            'where' => ' AND tp.cdlinm = :code: ',
                            'code' => $linmod->cdlinm,
                        );
                        break;
                    case 'titlin':
                        $section = array(
                            'where' => ' AND lm.cdtitl = :code: ',
                            'code' => $titlin->cdtitl,
                        );
                        break;
                }
            }
            $tipolo = $this->getAllProducts($cdcata, $nulist, $flt, $section, $common, $idlang, false, $tag);

            $block_index = 0;
            $html = '';

            $i = 12;

            if (count($tipolo) > 0) {
                $cdtitl = $tipolo[0]->cdtitl;
                $cdlinm = $tipolo[0]->cdlinm;
                $cdserm = $tipolo[0]->cdserm;

                $block_index++;
                if ($cdserm != '') {
                    $title = htmlentities($tipolo[0]->dstitl . " - " . $tipolo[0]->dslinm . " - " . $tipolo[0]->dsserm, ENT_COMPAT, 'UTF-8');
                    $banner = $tipolo[0]->banner_serm;
                } else {
                    $title = htmlentities($tipolo[0]->dstitl . " - " . $tipolo[0]->dslinm, ENT_COMPAT, 'UTF-8');
                    $banner = $tipolo[0]->banner_linm;
                }
                $html .= $this->getHtmlCodeForContainer($block_index, $title, $banner);

                // To modify product link
                $common['onlyTag'] = true;

                foreach ($tipolo as $model) {
                    if ($model->cdtitl != $cdtitl || $model->cdlinm != $cdlinm || $model->cdserm != $cdserm) {
                        // Model is of different brand or line or series, so close container
                        $html .= $this->getHtmlCodeForContainerClosure();

                        // Update current section
                        $cdtitl = $model->cdtitl;
                        $cdlinm = $model->cdlinm;
                        $cdserm = $model->cdserm;
                        $block_index++;
                        if ($cdserm != '') {
                            $title = htmlentities($model->dstitl . " - " . $model->dslinm . " - " . $model->dsserm, ENT_COMPAT, 'UTF-8');
                            $banner = $model->banner_serm;
                        } else {
                            $title = htmlentities($model->dstitl . " - " . $model->dslinm, ENT_COMPAT, 'UTF-8');
                            $banner = $model->banner_linm;
                        }
                        $html .= $this->getHtmlCodeForContainer($block_index, $title, $banner);
                    }

                    $items = array(
                        'cdcata' => $cdcata,
                        'cdartn' => $model->cdartn,
                        'nulist' => $nulist,
                        'idlang' => $idlang,
                        'id_usr' => $this->session->get('auth')['id'],
                        'numdis' => 0,
                        'modelDetailStyle' => $this->utility->getAppSettings('ModelDetailStyle'),
                        'colorAssignmentSource' => $this->utility->getAppSettings('ColorAssignmentSource'),
                    );

                    if ($i > 0) {
                        $html .= $this->getHtmlCodeForProduct($model, false, $common, $items);
                        $i--;
                    } else {
                        $html .= $this->getHtmlCodeForProduct($model, true, $common, $items);
                    }
                }
            }

            echo json_encode($html, JSON_UNESCAPED_UNICODE);
        }
    }

    // TODO implementare bene questa funzione
    public function loadFiltersClassificationAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $id_usr = $this->session->get('auth')['id'];
            $view = $this->session->get('ctg_view_type');
            $sermod = $this->session->get('ctg_seri');
            $linmod = $this->session->get('ctg_line');
            $titlin = $this->session->get('ctg_brnd');

            $tag = isset($_POST['tag']) ? $_POST['tag'] : '';

            // Set current filters and store it in session
            $this->filters->setFilters($_POST['filters']);

            $common = $this->utility->getCommonData('catalog', $id_usr);
            $idlang = $this->utility->getLanguage();
            $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($id_usr);
            $cdcata = $common['selected_catalog']->cdcata;

            $flt = $this->filters->getFilterSubQuery();
            $classifications = [];

            $section = array('where' => '', 'code' => '');
            if ($view != 'all') {
                switch ($view) {
                    case 'sermod':
                        $section = array(
                            'where' => ' AND tp.cdlinm = :code1: AND tp.cdserm = :code2: ',
                            'code1' => $sermod->cdlinm,
                            // TODO Questo mi sembra un typo altrove è $sermod->cdserm
                            'code2' => $linmod->cdserm,
                        );
                        break;
                    case 'linmod':
                        $section = array(
                            'where' => ' AND tp.cdlinm = :code: ',
                            'code' => $linmod->cdlinm,
                        );
                        break;
                    case 'titlin':
                        $section = array(
                            'where' => ' AND lm.cdtitl = :code: ',
                            'code' => $titlin->cdtitl,
                        );
                        break;
                }
            }
            $tipolo = $this->getAllProducts($cdcata, $nulist, $flt, $section, $common, $idlang, false, $tag, null, $classifications);

            $block_index = 0;
            $html = '';

            $i = 12;

            if (count($tipolo) > 0) {
                $cdtitl = $tipolo[0]->cdtitl;
                $cdlinm = $tipolo[0]->cdlinm;
                $cdserm = $tipolo[0]->cdserm;

                $block_index++;
                if ($cdserm != '') {
                    $title = htmlentities($tipolo[0]->dstitl . " - " . $tipolo[0]->dslinm . " - " . $tipolo[0]->dsserm, ENT_COMPAT, 'UTF-8');
                    $banner = $tipolo[0]->banner_serm;
                } else {
                    $title = htmlentities($tipolo[0]->dstitl . " - " . $tipolo[0]->dslinm, ENT_COMPAT, 'UTF-8');
                    $banner = $tipolo[0]->banner_linm;
                }
                $html .= $this->getHtmlCodeForContainer($block_index, $title, $banner);

                // To modify product link
                $common['onlyTag'] = true;

                foreach ($tipolo as $model) {
                    if ($model->cdtitl != $cdtitl || $model->cdlinm != $cdlinm || $model->cdserm != $cdserm) {
                        // Model is of different brand or line or series, so close container
                        $html .= $this->getHtmlCodeForContainerClosure();

                        // Update current section
                        $cdtitl = $model->cdtitl;
                        $cdlinm = $model->cdlinm;
                        $cdserm = $model->cdserm;
                        $block_index++;
                        if ($cdserm != '') {
                            $title = htmlentities($model->dstitl . " - " . $model->dslinm . " - " . $model->dsserm, ENT_COMPAT, 'UTF-8');
                            $banner = $model->banner_serm;
                        } else {
                            $title = htmlentities($model->dstitl . " - " . $model->dslinm, ENT_COMPAT, 'UTF-8');
                            $banner = $model->banner_linm;
                        }
                        $html .= $this->getHtmlCodeForContainer($block_index, $title, $banner);
                    }

                    if ($i > 0) {
                        $html .= $this->getHtmlCodeForProduct($model, false, $common);
                        $i--;
                    } else {
                        $html .= $this->getHtmlCodeForProduct($model, true, $common);
                    }
                }
            }

            echo json_encode($html, JSON_UNESCAPED_UNICODE);
        }
    }

    public function setFiltersAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $this->filters->setFilters($_POST['filters']);

            echo json_encode('OK');
        }
    }

    public function execExportBrandAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            set_time_limit(0);

            $auth = $this->session->get('auth');
            $isOrder = Octest::findOrderInProgress($auth['id']) != null;
            $order_info = $isOrder ? Octest::getCurrentOrder($auth['id']) : '';

            $type_usr = $this->session->get('auth')['type']; // 4.customer

            if ($type_usr == 4) {

                $customer = B2bBramod::getUserPricelistCode($this->session->get('auth')['id']);
            } else {
                $customer = null;
            }

            // Get Banner Samuele 22.11.2022
            $brandcode = $this->session->get('filterBrand');
            $rows = B2bBramod::getExportBrand($brandcode, $isOrder, $order_info, $customer);

            $spreadsheet = new Spreadsheet();
            $spreadsheet->getProperties()->setCreator('Sinergiattiva')->setTitle($this->translate('_common.availability'));

            // Set password for readonly activesheet
            $spreadsheet->getSecurity()->setLockWindows(true);
            $spreadsheet->getSecurity()->setLockStructure(true);
            $spreadsheet->getSecurity()->setWorkbookPassword("oettam80");

            // Set password for readonly data
            $spreadsheet->getActiveSheet()->getProtection()->setSheet(true);
            $spreadsheet->getActiveSheet()->getProtection()->setPassword("oettam80");

            $spreadsheet->setActiveSheetIndex(0);
            $activeSheet = $spreadsheet->getActiveSheet();

            // Set Default style
            $spreadsheet->getDefaultStyle()->getFont()->setName('Calibri');
            $spreadsheet->getDefaultStyle()->getFont()->setSize(12);

            // Set header style

            $activeSheet->getStyle('A1:H1')->applyFromArray(
                array(
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => '008a87'),
                    ),
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => array('argb' => 'FF606060'),
                        ),
                    ),
                    'font' => array(
                        'size' => 13,
                        'bold' => true,
                        'color' => array('argb' => 'FFFFFF'),
                    ),
                )
            );

            //$spreadsheet->getActiveSheet()->getDefaultRowDimension()->setRowHeight(45, 'px');
            $spreadsheet->getActiveSheet()->getRowDimension(1)->setRowHeight(45, 'px');
            $spreadsheet->getActiveSheet()->getRowDimension(3)->setRowHeight(60, 'px');

            $spreadsheet->getActiveSheet()->getStyle('A1:G1')->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);

            // Header
            $activeSheet->getCell('A1')->setValue('LISTINO IDEA GIOCONDA / IDEA GIOCONDA PRICE LIST');
            $spreadsheet->getActiveSheet()->getStyle('A1')->getAlignment()->setWrapText(true);
            $spreadsheet->getActivesheet()->getStyle('A1')->getAlignment()->setHorizontal('center');

            $spreadsheet->getActiveSheet()->mergeCells('A1:C1');
            $spreadsheet->getActiveSheet()->mergeCells('F1:H1');
            $spreadsheet->getActiveSheet()->mergeCells('D1:E1');

            $activeSheet->getCell('D1')->setValue($brandcode);
            $spreadsheet->getActiveSheet()->getStyle('D1')->getAlignment()->setWrapText(true);
            $spreadsheet->getActivesheet()->getStyle('D1')->getAlignment()->setHorizontal('center');

            $activeSheet->getCell('F1')->setValue('DATA : ' . date("d-m-Y") . ' / DATE : ' . date("F jS Y"));
            $spreadsheet->getActiveSheet()->getStyle('F1')->getAlignment()->setWrapText(true);
            $spreadsheet->getActivesheet()->getStyle('F1')->getAlignment()->setHorizontal('center');

            $activeSheet->getStyle('A3:H3')->applyFromArray(
                array(
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => '008a87'),
                    ),
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => array('argb' => 'FF606060'),
                        ),
                    ),
                    'font' => array(
                        'size' => 10,
                        'bold' => true,
                        'color' => array('argb' => 'FFFFFF'),
                    ),
                )
            );

            $spreadsheet->getActiveSheet()->getStyle('A3:H3')->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
            $spreadsheet->getActiveSheet()->getStyle('E3:H3')->getAlignment()->setWrapText(true);
            $spreadsheet->getActivesheet()->getStyle('A3:H3')->getAlignment()->setHorizontal('center');

            $activeSheet->getCell('A3')->setValue('SKU');
            //$activeSheet->getCell('B3')->setValue('BARCODE');
            $activeSheet->getCell('B3')->setValue('TITOLO / TITLE');
            $activeSheet->getCell('C3')->setValue('FANTASIA / DESIGN');
            $activeSheet->getCell('D3')->setValue('TAGLIA / SIZE');
            $activeSheet->getCell('E3')->setValue('CODICE INDICE / INDEX CODE');
            $activeSheet->getCell('F3')->setValue('PREZZO EUR AL RIVENDITORE / BUYER EUR PRICE');
            $activeSheet->getCell('G3')->setValue('PREZZO EUR AL PUBBLICO MINIMO CONSIGLIATO / RRP EUR');
            $activeSheet->getCell('H3')->setValue('IMBALLO MINIMO / MINIMUM ORDER QUANTITY');

            $spreadsheet->getActiveSheet()->getColumnDimension('A')->setWidth(15, 'px');
            $spreadsheet->getActiveSheet()->getColumnDimension('B')->setWidth(40, 'px');
            $spreadsheet->getActiveSheet()->getColumnDimension('C')->setWidth(25, 'px');
            $spreadsheet->getActiveSheet()->getColumnDimension('D')->setWidth(20, 'px');
            $spreadsheet->getActiveSheet()->getColumnDimension('E')->setWidth(20, 'px');
            $spreadsheet->getActiveSheet()->getColumnDimension('F')->setWidth(20, 'px');
            $spreadsheet->getActiveSheet()->getColumnDimension('G')->setWidth(20, 'px');
            $spreadsheet->getActiveSheet()->getColumnDimension('H')->setWidth(20, 'px');

            $skipCounter = 0;
            $currRowIndex = 4;

            //$activeSheet->getStyle('F')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_EUR);
            //$activeSheet->getStyle('G')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_EUR);

            for ($i = 0; $i < count($rows); $i++) {

                if ($i % 2 == 0) {

                    $spreadsheet
                        ->getActiveSheet()
                        ->getStyle('A' . $currRowIndex . ':H' . $currRowIndex)
                        ->getFill()
                        ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                        ->getStartColor()
                        ->setARGB('B4D7C9');

                }

                $spreadsheet->getActiveSheet()->getRowDimension($currRowIndex)->setRowHeight(27, 'px');
                $spreadsheet->getActiveSheet()->getStyle('A' . $currRowIndex . ':I' . $currRowIndex)->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
                $spreadsheet->getActivesheet()->getStyle('A' . $currRowIndex . ':E' . $currRowIndex)->getAlignment()->setHorizontal('center');
                $spreadsheet->getActivesheet()->getStyle('H' . $currRowIndex . ':H' . $currRowIndex)->getAlignment()->setHorizontal('center');
                $activeSheet->getCell('A' . $currRowIndex)->setValue($rows[$i]->cdarti);
                //$activeSheet->getCell('B' . $currRowIndex)->setValue("");
                $activeSheet->getCell('B' . $currRowIndex)->setValue($rows[$i]->dsarti);
                $activeSheet->getCell('C' . $currRowIndex)->setValue($rows[$i]->dscolo);
                $activeSheet->getCell('D' . $currRowIndex)->setValue($rows[$i]->taglia);
                $activeSheet->getCell('E' . $currRowIndex)->setValue($rows[$i]->cdartn);
                $activeSheet->getCell('F' . $currRowIndex)->setValue($rows[$i]->prezzo);

                $activeSheet->getCell('G' . $currRowIndex)->setValue($rows[$i]->preven);
                $activeSheet->getCell('H' . $currRowIndex)->setValue($rows[$i]->qtamin); // IMBALLO

                $currRowIndex++;

            }

            $objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xlsx');
            $filename = 'brandpricelist_' . date('Ymd') . '_' . date('His');
            $objWriter->save(str_replace('CatalogController', $filename, str_replace('.php', '.xlsx', __FILE__)));
            chmod("../app/controllers/" . $filename . ".xlsx", 0777);
            if (!file_exists('../public/io/avail')) {
                mkdir('../public/io/avail', 0777, true);
            }
            rename("../app/controllers/" . $filename . ".xlsx", "../public/io/avail/" . $filename . ".xlsx");
            set_time_limit(30);
            echo json_encode($filename . ".xlsx");
        }
    }

    public function execExportAvailabilityAction()
    {


        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            set_time_limit(0);

            $isPT = Tipolo::findFirstByTppers('PT') != null;
            $fullPath_v = "";

            $auth = $this->session->get('auth');
            $catalogs = $this->utility->getAvailableCatalogs($auth['id']);

            $ctlg_ok = $catalogs != null && count($catalogs) > 0;
            $isOrder = Octest::findOrderInProgress($auth['id']) != null;
            $order_info = $isOrder ? Octest::getCurrentOrder($auth['id']) : '';
            $cdcata = $this->utility->getSelectedCatalog($isOrder, $order_info, $catalogs)->cdcata;
            //$sizes  = Ctarti::getAllSizesFromAvailableCatalogs();
            $sizes = Ctarti::getAllSizesFromCurrentCatalog($cdcata);
            //$rows   = $this->getRows($isPT);
            $rows = $this->getRows($isPT, $cdcata);

            $spreadsheet = new Spreadsheet();
            $spreadsheet->getProperties()->setCreator('Sinergiattiva')->setTitle($this->translate('_common.availability'));

            // Set password for readonly activesheet
            $spreadsheet->getSecurity()->setLockWindows(true);
            $spreadsheet->getSecurity()->setLockStructure(true);
            $spreadsheet->getSecurity()->setWorkbookPassword("oettam80");

            // Set password for readonly data
            $spreadsheet->getActiveSheet()->getProtection()->setSheet(true);
            $spreadsheet->getActiveSheet()->getProtection()->setPassword("oettam80");

            $offset = !$isPT ? 4 : 6;
            $columns = $offset + count($sizes) + 1;
            $col_tot = $this->utility->getNameFromNumber($columns - 1);

            $spreadsheet->setActiveSheetIndex(0);
            $activeSheet = $spreadsheet->getActiveSheet();

            // Freeze first row and first 4 or 6 columns
            $activeSheet->freezePane($this->utility->getNameFromNumber($offset) . '2');

            // Set header style
            $activeSheet->getStyle('A1:' . $col_tot . '1')->applyFromArray(
                array(
                    'fill' => array(
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'color' => array('rgb' => 'EEEEEE'),
                    ),
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => array('argb' => 'FF606060'),
                        ),
                    ),
                    'font' => array(
                        'bold' => true,
                    ),
                )
            );

            // Set column widths
            $spreadsheet->getActiveSheet()->calculateColumnWidths();
            $spreadsheet->getActiveSheet()->getColumnDimension('A')->setWidth(25);
            for ($i = 1; $i < $columns + 1; $i++) {
                $spreadsheet->getActiveSheet()->getColumnDimension($this->utility->getNameFromNumber($i))->setAutoSize(true);
            }

            $activeSheet->getCell('A1')->setValue($this->translate('_common.image'));
            $activeSheet->getCell('B1')->setValue($this->translate('_common.description.article'));
            $activeSheet->getCell('C1')->setValue($this->translate('_common.code.article'));
            $activeSheet->getCell('D1')->setValue(!$isPT ? $this->translate('_common.sizes.scale') : $this->translate('_common.code.color'));

            if ($isPT) {
                $activeSheet->getCell('E1')->setValue($this->translate('_common.variant'));
                $activeSheet->getCell('F1')->setValue($this->translate('_common.sizes.scale'));
            }

            for ($i = 0; $i < count($sizes); $i++) {
                $activeSheet->getCell($this->utility->getNameFromNumber($offset + $i) . '1')->setValue($sizes[$i]->taglia);
            }

            $activeSheet->getCell($col_tot . '1')->setValue($this->translate('_common.total'));

            $skipCounter = 0;
            for ($i = 0; $i < count($rows); $i++) {
                if ($this->utility->getAppSettings('ParamShowNotAvailableItems') == 1 ||
                    count($rows[$i]->availability) > 0) {
                    $currRowIndex = $i + 2 - $skipCounter;

                    $imgurl_arti = substr($this->utility->getImageModelLink($rows[$i]->flimag_i), 1);
                    $imgurl_artn = substr($this->utility->getImageModelLink($rows[$i]->flimag_n), 1);
                    $exist_i = $rows[$i]->flimag_i != '' && file_exists("img/model/" . $rows[$i]->flimag_i);
                    $exist_n = $rows[$i]->flimag_n != '' && file_exists("img/model/" . $rows[$i]->flimag_n);
                    if ($isPT) {
                        $imgurl_artv = substr($this->utility->getImageModelLink($rows[$i]->flimag_v), 1);
                        $exist_v = $rows[$i]->flimag_v != '' && file_exists("img/model/" . $rows[$i]->flimag_v);
                    }

                    if ($exist_i || $exist_n || ($isPT && $exist_v)) {
                        // Create temporary folder for resized images
                        if (!file_exists('img/temp/resize/model')) {
                            if (!file_exists('img/temp/resize')) {
                                if (!file_exists('img/temp')) {
                                    mkdir('./img/temp', 0777, true);
                                }
                                mkdir('./img/temp/resize', 0777, true);
                            }
                            mkdir('./img/temp/resize/model', 0777, true);
                        }

                        // Copy image to temporary folder
                        if ($exist_i) {
                            $fullPath_i = $this->utility->resizeImageForExcel($imgurl_arti, "img/temp/resize/model/" . $rows[$i]->flimag_i)
                                ? $imgurl_arti
                                : "img/temp/resize/model/" . $rows[$i]->flimag_i;
                        } else {
                            $fullPath_i = "assets/img/default_model.jpg";
                        }
                        if ($exist_n) {
                            $fullPath_n = $this->utility->resizeImageForExcel($imgurl_artn, "img/temp/resize/model/" . $rows[$i]->flimag_n)
                                ? $imgurl_artn
                                : "img/temp/resize/model/" . $rows[$i]->flimag_n;
                        } else {
                            $fullPath_n = "assets/img/default_model.jpg";
                        }

                        if ($isPT) {
                            if ($exist_v) {
                                $fullPath_v = $this->utility->resizeImageForExcel($imgurl_artv, "img/temp/resize/model/" . $rows[$i]->flimag_v)
                                    ? $imgurl_artv
                                    : "img/temp/resize/model/" . $rows[$i]->flimag_v;
                            } else {
                                $fullPath_v = "assets/img/default_model.jpg";
                            }
                        }

                        $activeSheet->getRowDimension($currRowIndex)->setRowHeight(95);

                        // flimag_n
                        if ($exist_n) {
                            if (file_exists($fullPath_n)) {
                                $objDrawing_n = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
                                $objDrawing_n->setPath($fullPath_n);
                                $objDrawing_n->setResizeProportional(true);
                                $objDrawing_n->setCoordinates('A' . $currRowIndex);
                                $objDrawing_n->setWidthAndHeight(200, 120);
                                $objDrawing_n->setOffsetY(2);
                                $objDrawing_n->setOffsetX(2);
                                $objDrawing_n->setWorksheet($activeSheet);
                            }


                        }

                        // flimag_i
                        if ($exist_i && !$exist_n) {
                            if (file_exists($fullPath_i)) {
                                $objDrawing_i = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
                                $objDrawing_i->setPath($fullPath_i);
                                $objDrawing_i->setResizeProportional(true);
                                $objDrawing_i->setCoordinates('A' . $currRowIndex);
                                $objDrawing_i->setWidthAndHeight(200, 120);
                                $objDrawing_i->setOffsetY(2);
                                $objDrawing_i->setOffsetX(2);
                                $objDrawing_i->setWorksheet($activeSheet);
                            }
                        } else {
                            if (file_exists($fullPath_i)) {
                                $objDrawing_i = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
                                $objDrawing_i->setPath($fullPath_i);
                                $objDrawing_i->setResizeProportional(true);
                                $objDrawing_i->setCoordinates('A' . $currRowIndex);
                                $objDrawing_i->setHeight(50);
                                $objDrawing_i->setOffsetY(4);
                                $objDrawing_i->setOffsetX(122);
                                $objDrawing_i->setWorksheet($activeSheet);
                            }
                        }

                        if ($isPT && $exist_v && !$exist_n) {
                            // flimag_v
                            if (file_exists($fullPath_v)) {
                                $objDrawing_v = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
                                $objDrawing_v->setPath($fullPath_v);
                                $objDrawing_v->setResizeProportional(true);
                                $objDrawing_v->setCoordinates('A' . $currRowIndex);
                                $objDrawing_v->setHeight(120);
                                $objDrawing_v->setOffsetY(2);
                                $objDrawing_v->setOffsetX(2);
                                $objDrawing_v->setWorksheet($activeSheet);
                            }
                        } else {
                            if (file_exists($fullPath_v)) {
                                $objDrawing_v = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
                                $objDrawing_v->setPath($fullPath_v);
                                $objDrawing_v->setResizeProportional(true);
                                $objDrawing_v->setCoordinates('A' . $currRowIndex);
                                $objDrawing_v->setHeight(50);
                                $objDrawing_v->setOffsetY(70);
                                $objDrawing_v->setOffsetX(122);
                                $objDrawing_v->setWorksheet($activeSheet);
                            }
                        }
                    }

                    $activeSheet->getCell('B' . $currRowIndex)->setValue($rows[$i]->dsarti);
                    $activeSheet->getCell('C' . $currRowIndex)->setValue($rows[$i]->cdarti);
                    $activeSheet->getCell('D' . $currRowIndex)->setValue(!$isPT ? $rows[$i]->cdtagl : $rows[$i]->cdcolo_v);

                    if ($isPT) {
                        $activeSheet->getCell('E' . $currRowIndex)->setValue($rows[$i]->cdvari);
                        $activeSheet->getCell('F' . $currRowIndex)->setValue($rows[$i]->cdtagl);
                    }


                    if (count($rows[$i]->availability) > 0) {
                        $row_disp = 0;
                        for ($j = 0; $j < count($sizes); $j++) {
                            foreach ($rows[$i]->availability[0]['alldsp']['size'] as $size => $disp) {
                                if ((string)$size == (string)$sizes[$j]->taglia && $disp > 0) {
                                    $activeSheet->getCell($this->utility->getNameFromNumber($offset + $j) . $currRowIndex)->setValue($disp);
                                    $row_disp += $disp;
                                }
                            }
                        }
                        $activeSheet->getCell($col_tot . $currRowIndex)->setValue($row_disp);
                    } else {
                        $activeSheet->getCell($col_tot . $currRowIndex)->setValue(0);
                    }
                } else {
                    $skipCounter++;
                }
            }


            // Apply some styles when everything is filled
            $h_align = array('alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER));
            $activeSheet->getStyle($this->utility->getNameFromNumber($offset) . '1:' . $col_tot . $activeSheet->getHighestDataRow())->applyFromArray($h_align);

            $h_align = array('alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT));
            $activeSheet->getStyle('A1:' . $this->utility->getNameFromNumber($offset - 1) . $activeSheet->getHighestDataRow())->applyFromArray($h_align);

            $activeSheet->getStyle('A1:' . $col_tot . $activeSheet->getHighestDataRow())->setQuotePrefix(true);

            // Set all cells style
            $activeSheet->getStyle('A2:' . $col_tot . $activeSheet->getHighestDataRow())->applyFromArray(
                array(
                    'borders' => array(
                        'allBorders' => array(
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => array('argb' => 'FF606060'),
                        ),
                    ),
                    'alignment' => array(
                        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                    ),
                )
            );


            $objWriter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xlsx');

            $filename = 'avail_' . date('Ymd') . '_' . date('His');
            $objWriter->save(str_replace('CatalogController', $filename, str_replace('.php', '.xlsx', __FILE__)));
            chmod("../app/controllers/" . $filename . ".xlsx", 0777);
            if (!file_exists('../public/io/avail')) {
                mkdir('../public/io/avail', 0777, true);
            }
            rename("../app/controllers/" . $filename . ".xlsx", "../public/io/avail/" . $filename . ".xlsx");

            set_time_limit(30);

            echo json_encode($filename . ".xlsx");

        }
    }

    public function findbarcodeAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $barcode = $_POST['barcode'];
            $index = $_POST['index'];

            $barcod = Barcod::findFirstByNubrcd($barcode);

            $result = array('response' => 'NF', 'html' => '');
            if ($barcod != null) {
                $html = $this->getBarcodeListRow($barcod, $index);
                if ($html != '') {
                    $result = array('response' => 'OK', 'html' => $html);
                }
            }

            echo json_encode($result);
        }
    }

    public function insertfrombarcodeAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $rows = $_POST['rows'];

            $id_usr = $this->session->get('auth')['id'];
            $order = Octest::findOrderInProgress($id_usr);
            $seqrap = Occorp::getMaxIndexForOrder($order->nuordc);

            foreach ($rows as $row) {
                // row['quanti'] not set means not available, so nothing to do
                if (isset($row['quanti'])) {
                    $occorp = Occorp::findFirst(array('nuordc = :nuordc: AND cdarti = :cdarti:',
                        'bind' => array('nuordc' => $order->nuordc, 'cdarti' => $row['cdarti'])));

                    if ($occorp == false) {
                        // New line both for occorp and octagl
                        $occorp = new Occorp();
                        $occorp->nuordc = $order->nuordc;
                        $occorp->seqdet = 1;
                        $occorp->seqrap = $seqrap + 1;
                        $occorp->cdarti = $row['cdarti'];
                        $occorp->quanti = $row['quanti'];
                        $occorp->cdcolo = $row['cdcolo'];
                        $occorp->cdvari = new \Phalcon\Db\RawValue('""');
                        $occorp->cdcata = $order->cdcata;
                        $occorp->dtmcli = $order->dtmcli;
                        $occorp->save();

                        // Insert all sizes to 0
                        $sizes = Postgl::getSizesFromCdarti($row['cdarti']);
                        foreach ($sizes as $size) {
                            $octagl = new Octagl();
                            $octagl->nurorc = $occorp->nurorc;
                            $octagl->dstagl = $size->taglia;
                            $octagl->quanti = $size->taglia != $row['taglia'] ? 0 : $row['quanti'];
                            $octagl->prezzo = $row['prc'];
                            $octagl->scont1 = $row['dis'];
                            $octagl->scont2 = 0;
                            $octagl->scont3 = 0;
                            $octagl->save();
                        }
                    } else {
                        // Occorp exists -> find related octagl
                        $octagl = Octagl::findFirst(array('nurorc = :nurorc: AND dstagl = :dstagl:',
                            'bind' => array('nurorc' => $occorp->nurorc, 'dstagl' => $row['taglia'])));

                        $diff = $row['quanti'] - $octagl->quanti;

                        $octagl->quanti = $row['quanti'];
                        $octagl->prezzo = $row['prc'];
                        $octagl->scont1 = $row['dis'];
                        $octagl->scont2 = 0;
                        $octagl->scont3 = 0;
                        $octagl->save();

                        // Octagl exists, so we must update it and modify occorp.quanti with new octagl.quanti
                        $occorp->quanti = $occorp->quanti + $diff;
                        $occorp->save();
                    }
                }
            }

            echo json_encode(array(
                'response' => 'OK',
                'tot' => Occorp::getOrderTotals($order->nuordc),
            ));
        }
    }

    public function getarticlefrombarcodeAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $barcode = $_POST['barcode'];

            $barcod = Barcod::findFirstByNubrcd($barcode);

            $result = array('response' => 'NF', 'cdartn' => '', 'cdpers' => '', 'cdcolo' => '');
            if ($barcod != null) {
                $anaart = Anaart::findFirstByCdarti($barcod->cdarti);
                $result = array('response' => 'OK', 'cdartn' => $anaart->cdartn, 'cdpers' => $anaart->cdpers, 'cdcolo' => $barcod->cdcolo);
            }

            echo json_encode($result);
        }
    }

    public function searchForQuickOrderAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdartn = $_POST['cdartn'];

            $id_usr = $this->session->get('auth')['id'];
            $common = $this->utility->getCommonData('catalog', $id_usr);

            $idlang = $this->utility->getLanguage();
            $nulist = $common['order_info']->nulist;
            $cdcata = $common['selected_catalog']->cdcata;

            $result = $this->getAllTipoloFromExactSearchList($cdcata, $cdartn, $nulist, $common, $idlang);

            if (count($result) == 1) {
                $html = $this->getHtmlCodeForExactSearch($result[0], $common);
                echo json_encode(array('response' => 'OK', 'html' => $html));
            } else {
                echo json_encode(array('response' => 'OK', 'html' => ''));
            }
        }
    }

    public function getModelPreviewAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdartn = $_POST['cdartn'];
            $tag = isset($_POST['tag']) ? $_POST['tag'] : '';

            $id_usr = $this->session->get('auth')['id'];

            $idlang = $this->utility->getLanguage();
            $isOrder = Octest::findOrderInProgress($id_usr) != null;
            if ($isOrder) {
                $currentOrder = Octest::getCurrentOrder($id_usr);
                $nulist = $currentOrder->nulist;
                $cdcata = $currentOrder->cdcata;
            } else {
                $nulist = $this->utility->getDefaultNulist($id_usr);
                $cdcata = $this->session->get('cdcata');
            }

            $tipolo = Tipolo::getCompletePreviewModel($cdartn, $idlang);

            if (count($tipolo) == 1) {
                $full_tipolo = $tipolo[0];
                $full_tipolo->anaart_n = Anaart::getCountArticlesForCdartn($cdartn, $cdcata);
                $full_tipolo->imgart = Imgart::getAllImagesFromModel($cdartn);
                $modinf = B2bModinf::findFirstByCdartn($cdartn);

                $html = $this->getHtmlCodeForModelPreview($full_tipolo, $modinf, $isOrder, $tag);

                echo json_encode(array('response' => 'OK', 'html' => $html));
            } else {
                echo json_encode(array('response' => 'OK', 'html' => ''));
            }
        }
    }

    public function getGalleryArticleModalAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdarti = $_POST['code'];

            $idlang = $this->utility->getLanguage();
            $article = Anaart::getArticleForGallery($cdarti, $idlang);
            $article->images = Imgart::getAllImagesFromArticle($cdarti);
            $article->colors = Artcol::getColorsFromArticle($cdarti);

            echo json_encode(array('response' => 'OK', 'html' => $this->ajaxHtmlBuilder->getHtmlCodeForGalleryProduct($article, true)));
        }
    }

    public function getGalleryModelModalAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdartn = $_POST['code'];

            $auth = $this->session->get('auth');
            $id_usr = $auth['id'];
            $order = Octest::getCurrentOrder($id_usr);

            $idlang = $this->utility->getLanguage();
            $model = Tipolo::getModelForGallery($cdartn, $idlang);
            $model->images = Imgart::getAllImagesFromModel($cdartn);
            $model->articles = Anaart::getArticlesFromModel($cdartn, $order->cdcata);

            echo json_encode(array('response' => 'OK', 'html' => $this->ajaxHtmlBuilder->getHtmlCodeForGalleryProduct($model, false)));
        }
    }

    public function getInsertQuantityForGalleryArticleAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdarti = $_POST['cdarti'];
            $cdcolo = $_POST['cdcolo'];

            $auth = $this->session->get('auth');
            $id_usr = $auth['id'];
            $order = Octest::getCurrentOrder($id_usr);

            $order_rows = $this->utility->getOrderRows($cdarti, $cdcolo, $order->nuordc);

            $tipolo = Tipolo::getModelFromCdarti($cdarti);

            $sizes = Postgl::getSizesWithPrices($tipolo->cdtagl, $cdarti, $order->nulist);
            $sizes = $this->utility->getRules($sizes, $tipolo->cdartn, $cdarti, $cdcolo);

            // General info
            $idlang = $this->utility->getLanguage();
            $numdis = $this->utility->getCustomDiscount();
            $discount = array();
            if ($numdis > 0) {
                $discount = B2bDisbdy::getCustomDiscountForCdarti($numdis, $cdarti);
            }

            // Availability, if needed
            if ($order->tpordc == 0) {
                if ($tipolo->tppers != 'PT') {
                    $ava_sizes = $this->utility->getArticleAvailability($cdarti);
                } else {
                    $ava_sizes = $this->utility->getColorVariantArticleAvailability($cdarti, $cdcolo, $tipolo->cdtagl);
                }
            }

            $dateTypeAvaOrder = $this->utility->getAppSettings('ParamDateManagementAvailability');
            $dateTypeResOrder = $this->utility->getAppSettings('ParamDateManagement');
            $dateOffset = $this->utility->getAppSettings('ParamAvailabilityDateManagement');
            $showNotes = $this->utility->getAppSettings('ParamQuantityNotesView') == 1;

            $canGoToCart = $order->dtmcli != null ||
                ($order->tpordc == 0 && ($dateTypeAvaOrder == 1 || $dateTypeAvaOrder == 3)) ||
                ($order->tpordc == 1 && ($dateTypeResOrder == 1 || $dateTypeResOrder == 3)) ||
                ($order->tpordc == 1 && $dateTypeResOrder == 4 && $order->dtmcoi != null && $order->dtmcof != null);

            $dateOffset = $order->tpordc == 0 && $dateTypeAvaOrder != 4 ? 0 : $dateOffset;

            $showInfo = array(
                'showDelivery' => false,
                'showIndicative' => false,
                'showNotes' => false,
                'showReference' => false,
            );

            $html = '';

            // Always PT
            if ($order->tpordc == 0) {
                $html .= $this->ajaxHtmlBuilder->getHtmlCodeForAvaTissue($sizes, $tipolo, $order_rows, $ava_sizes, array(), $dateOffset,
                    $showInfo, false, $canGoToCart, $discount, false, $showNotes);
                $showAddButton = !empty($ava_sizes);
            } else {
                $html .= $this->ajaxHtmlBuilder->getHtmlCodeForResTissue($sizes, $tipolo, $order_rows, array(), $order->dtmcli,
                    $showInfo, false, $canGoToCart, $discount, false, $showNotes);
                $showAddButton = true;
            }

            $html .= '<input type="hidden" id="selected-color-code" value="' . $cdcolo . '"/>';

            echo json_encode(array('response' => 'OK', 'showAddButton' => $showAddButton, 'html' => $html));
        }
    }

    public function getInsertQuantityForGalleryModelAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdartn = $_POST['cdartn'];
            $cdarti = $_POST['cdarti'];

            $auth = $this->session->get('auth');
            $id_usr = $auth['id'];
            $order = Octest::getCurrentOrder($id_usr);

            $order_rows = $this->utility->getOrderRows($cdarti, $cdcolo, $order->nuordc);

            $tipolo = Tipolo::getModelFromCdarti($cdarti);

            $sizes = Postgl::getSizesWithPrices($tipolo->cdtagl, $cdarti, $order->nulist);
            $sizes = $this->utility->getRules($sizes, $tipolo->cdartn, $cdarti, $cdcolo);

            // General info
            $idlang = $this->utility->getLanguage();
            $numdis = $this->utility->getCustomDiscount();
            $discount = array();
            if ($numdis > 0) {
                $discount = B2bDisbdy::getCustomDiscountForCdarti($numdis, $cdarti);
            }

            // Availability, if needed
            if ($order->tpordc == 0) {
                if ($tipolo->tppers != 'PT') {
                    $ava_sizes = $this->utility->getArticleAvailability($cdarti);
                } else {
                    $ava_sizes = $this->utility->getColorVariantArticleAvailability($cdarti, $cdcolo, $tipolo->cdtagl);
                }
            }

            $dateTypeAvaOrder = $this->utility->getAppSettings('ParamDateManagementAvailability');
            $dateTypeResOrder = $this->utility->getAppSettings('ParamDateManagement');
            $dateOffset = $this->utility->getAppSettings('ParamAvailabilityDateManagement');
            $showNotes = $this->utility->getAppSettings('ParamQuantityNotesView') == 1;

            $canGoToCart = $order->dtmcli != null ||
                ($order->tpordc == 0 && ($dateTypeAvaOrder == 1 || $dateTypeAvaOrder == 3)) ||
                ($order->tpordc == 1 && ($dateTypeResOrder == 1 || $dateTypeResOrder == 3)) ||
                ($order->tpordc == 1 && $dateTypeResOrder == 4 && $order->dtmcoi != null && $order->dtmcof != null);

            $dateOffset = $order->tpordc == 0 && $dateTypeAvaOrder != 4 ? 0 : $dateOffset;

            $showInfo = array(
                'showDelivery' => false,
                'showIndicative' => false,
                'showNotes' => false,
                'showReference' => false,
            );

            $html = '';
            if ($order->tpordc == 0) {
                // Always not PT
                $html .= $this->ajaxHtmlBuilder->getHtmlCodeForAvaColor($sizes, $tipolo, $order_rows, $ava_sizes, array(), $dateOffset,
                    $showInfo, false, $canGoToCart, $discount, false, $showNotes);
                $showAddButton = !empty($ava_sizes);
            } else {
                $catalogs = $this->utility->getAvailableCatalogs($id_usr);
                $selected_catalog = $this->utility->getSelectedCatalog(true, $order, $catalogs);
                $exist = isset($selected_catalog->cdcata) && Cttest::findFirstByCdcata($selected_catalog->cdcata) != null;
                $periods = $dateTypeAvaOrder < 3 || $dateTypeResOrder < 3 ? Scacon::getPeriodsForCatalog($exist ? $selected_catalog->cdcata : $order->cdcata) : '';

                $html .= $this->getHtmlCodeForResColor($sizes, array(), $tipolo, $order_rows, $dateTypeResOrder,
                    $periods, $this->utility->getAppSettings('ParamQuantityMultipleDeliveryView') == 1,
                    $showInfo, false, $canGoToCart, $discount, false, $showNotes);
                $showAddButton = true;
            }
            $html .= '<input type="hidden" id="selected-article-code" value="' . $cdarti . '"/>';

            echo json_encode(array('response' => 'OK', 'showAddButton' => $showAddButton, 'html' => $html));
        }
    }
    //endregion

    //region Html functions
    private function getHtmlCodeForProduct($product, $isLazy, $common, $variant = null)
    {

        $prefix = $this->config->application->baseUri;
        $common['customer_discount'] = !empty($common['customer_discount']) ? $common['customer_discount'] : 0;
        if ($common['isOrder'] && $this->utility->getAppSettings('ShowBaseCustomerDiscount') == 1) {
            $customer = Anagra::findCustomerByKey($common['order_info']->tpanag, $common['order_info']->cdanag);
            if ($customer instanceof Anagra) {
                $common['customer_discount'] = $customer->scont1;
            }
        }
//
        $prezzo_cust = 0;

        $variantItems = array();
        if ($variant != null) {
            $variantItems = Anaart::getAllArticlesForModelDetail($variant);
        }

//        $sconto = 0;
//        if ($variantItems && $variantItems->count() > 0) {
//            // CALCOLO MAX DISCOUNT
//
//            // Marco e Samuele 02.12.202
//
//            $numdis = $this->utility->getCustomDiscount();
//            foreach ($variantItems as $vari) {
//                var_dump($vari->toArray());
//
//                if ($numdis > 0) {
//                    $discount = B2bDisbdy::getCustomDiscountForCdarti($numdis, $vari->cdarti);
//                    if (count($discount) > 0) {
//                        if ($discount[1] > $sconto) {
//                            $sconto = $discount[1];
//                            // qua ci va il controllo per capire quello maggiore e scriverlo
//                            // e poi bisogna fare i conti
//                        }
//                    }
//                }
//                if ($vari->prezzo > $prezzo_cust) {
//                    $prezzo_cust = $vari->prezzo;
//                }
//            }
//        } else {
//            $numdis = $this->utility->getCustomDiscount();
//            if ($numdis > 0) {
//                $sconto = $numdis;
//            }
//        }

        // price
        $withDiscount = false;
        $cust_disc = 0;

        // MARCO e SAMUELE
        $maxDiscount = $this->utility->getAppSettings('MaxDiscountInCollection');
        if ($maxDiscount == 1 && $common['customer_discount'] > 0) {
            $cust_disc = $common['customer_discount'];
            $withDiscount = true;
        }

        if ($common['showCatalogPrice'] == 1 || ($common['showCatalogPrice'] == 2 && $common['isOrder'])) {

            if ($product->catalogPrice < 0) {
                $productPrice = $this->translate('quantity.priceforsize.short');
            } else if ($product->catalogPrice == '0') {
                $productPrice = !in_array($common['modelDetailStyle'], [3, 5]) ? '-' : '&nbsp;';
            } else {
                $priceRange = '';
                $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($this->session->get('auth')['id']);

                $cust_disc = $product->cust_disc > 0 ? $product->cust_disc : $cust_disc;
                $cust_disc = $product->art_cust_disc > 0 ? $product->art_cust_disc : $cust_disc;

//                if (($cust_disc < $sconto) && ($maxDiscount == 1)) {
//                    $cust_disc = $sconto;
//                }
                if (substr($product->catalogPrice, 0, 1) == '#') {
                    $priceArr = explode('*', substr($product->catalogPrice, 1));
                    $minPrc = $this->utility->getFormattedPrice($nulist, $priceArr[0]);
                    $maxPrc = $this->utility->getFormattedPrice($nulist, $priceArr[1]);
                    $priceRange = $minPrc['value'] . ' - ' . $maxPrc['value'];
                    $productPrice = $cust_disc > 0 ? $this->translate('quantity.priceforsize.short') : $priceRange;
                } else {
                    $price = $this->utility->getFormattedPrice($nulist, $product->catalogPrice);
                    // calcola lo sconto con la percentuale del listino
                    $disc_price = $this->utility->getFormattedPrice($nulist, $product->catalogPrice * (1 - $cust_disc / 100));
                    //mette il prezzo di Disc_price se è diverso da quello di listino
                    $withDiscount = $disc_price['value_raw'] != $product->catalogPrice;
                    $productPrice = $disc_price['value'];
                }
            }
        } else {
            $productPrice = '&nbsp;';
        }

        // images
        if (isset($product->custom_flimag) && $product->custom_flimag != '') {
            $imgurl1 = 'upload/' . $product->custom_flimag;
            $imgurl2 = '';
        } else {
            $imgurl1 = $this->utility->getImageModelLink($product->flimag, ["w" => "350"]);
            $imgurl2 = $this->utility->getImageModelLink($product->flimg2, ["w" => "350"]);
        }
        $exist1 = $product->flimag != ''; // && file_exists($imgurl1);
        $exist2 = $product->flimg2 != ''; // && file_exists($imgurl2);
        $imgurl = !$exist1 ? '/assets/img/default_model.jpg' : $imgurl1;
        $modelLink = 'model/' . $product->cdartn;

        switch ($this->utility->getAppSettings('ItemsPerRowOnVisualCatalog')) {
            case 1:
                $lg = 'col-lg-4';
                break;
            case 2:
                $lg = 'col-lg-6';
                break;
            default:
                $lg = 'col-lg-3';
                break;
        }

        switch ($common['modelDetailStyle']) {
            case 0:
                $isDefault = true;
                $isQuick = false;
                $modelLink = 'model/' . $product->cdartn;
                break;
            case 7:
            case 8:
            case 6:
            case 1:
                $isDefault = true;
                $isQuick = $common['showQuickOrder'] && $common['isOrder'] && $common['catalogProductType'] == 0;
                $modelLink = 'model/' . $product->cdartn;
                break;
            case 2:
                $isDefault = false;
                $isQuick = false;
                //$modelLink  = 'model/' . $product->cdartn;
                break;
            case 3:
                $isDefault = true;
                $isQuick = false;
                $modelLink = 'model/wizard/' . $product->cdartn;
                break;
            case 4:
                $isDefault = false;
                $isQuick = false;
                //$modelLink  = 'model/' . $product->cdartn;
                break;
            case 5:
                $isDefault = true;
                $isQuick = false;
                $modelLink = 'model/wizard/' . $product->cdartn;
                break;
            case 9:
                $isDefault = true;
                $isQuick = $common['showQuickOrder'] && $common['isOrder'] && $common['catalogProductType'] == 0;
                $modelLink = 'model/' . $product->cdartn;
                break;
        }

        if (($common['isOrder'] && $common['order_info']->tpordc == 0) ||
            ($this->utility->getAppSettings('QuickNavigation') == 1)) {
            $isDefault = true;
            $modelLink = 'model/' . $product->cdartn;
        }

        $hasAvailabilityFlag = false;
        $description = '';
        if ($common['catalogProductType'] == 0) {
            $code = $product->cdartn;
            $description = $product->dsartn;
            if ($common['showAvailabilityFlag'] == 1) {
                $hasAvailabilityFlag = Tipolo::hasAvailabilityFlag($product->cdartn);
                if ($hasAvailabilityFlag) {
                    if (isset($common['onlyTag']) && $common['onlyTag']) {
                        $modelLink .= '?flt=ava';
                    }
                }
            }
        } else if ($common['catalogProductType'] == 1) {
            $code = $product->cdarti;
            $description = $product->dsarti;
            // Leonardo 17/07/2023 non ho idea a cosa servisse questo '/' encodato in html ma alla fine c'erano 2 // iniziali e il browser lo percepisce come se volessi ripartire dal dopo il protocollo
//            $modelLink = "&#47;" . "model/" . $product->cdarti;
            $modelLink = 'model/' . $product->cdarti;
        } else if ($common['catalogProductType'] == 2) {
            $code = $product->cdarti . ' ' . $product->color;
            $description = $product->dsarti;
//            $modelLink = "&#47;" . 'model/' . $product->cdarti . '?COL=' . $product->color;
            $modelLink = 'model/' . $product->cdarti . '?COL=' . $product->color;
        }

        if ($common['productNameType'] == 1) {
//            $description .= ' ' . $product->cdtagl;

            $sizes = [];
            $tipolo = Tipolo::findFirstByCdartn($product->cdartn);
            if ($tipolo instanceof Tipolo) {
                $sizes = $tipolo->getAvailableSizes();
            }

            if (!empty($sizes)) {
                $description .= ' [' . $sizes[$tipolo->tglini] . '-' . $sizes[$tipolo->tglfin] . ']';
            }
        }

        if ($productPrice == "") {
            $price['value'] = 0;
        } else if ($prezzo_cust == 0) {
            $price['value'] = $product->catalogPrice;
        } else {
            $price['value'] = 0;
        }

        if ($common['isOrder'] && $common['order_info']->tpordc == 0) {
            $availability_text = !$product->is_available ? $this->translate('_common.notavailable') : "&nbsp;";
            // $html .= "<div class='availability-model-box text-center'>$availability_text</div>";
        } else {
            $availability_text = "";
        }

        $priceHtml = '';

        if ($common['modelDetailStyle'] != 3 || !$common['isOrder']) {

            if ($price['value'] == "") {
                $price['value'] = $prezzo_cust;
            }

            $classDiscountPrice = ($this->utility->getAppSettings('ColoredPriceBackground') == 1) ? 'price-model-box-discounted-btn' : 'price-model-box-discounted-btn-nobg';
            $classPrice = ($this->utility->getAppSettings('ColoredPriceBackground') == 1) ? 'price-model-box-btn' : 'price-model-box-btn-nobg';

            $priceHtml .= $withDiscount
                ? "<div class='" . $classDiscountPrice . " text-center'><div style='display: flex;'><span class='discounted'>" . $price['value'] . "</span><span>" . $productPrice . "</span></div><div class='availability-model-box text-center'>" . $availability_text . "</div><div class='d-flex w-100 mt-4'><div class='w-50 col px-2'><a href='/" . $modelLink . "'>" . $this->translate('listing.discover') . "</a></div><div class='w-50 col px-2'><button>" . $this->translate('listing.quickBuy') . "</button></div></div></div>"
                : "<div class='" . $classPrice . "'><div>" . $productPrice . "</div><div class='availability-model-box text-center'>" . $availability_text . "</div><div class='d-flex w-100 mt-4'><div class='w-50 col px-2'><a href='/" . $modelLink . "'>" . $this->translate('listing.discover') . "</a></div><div class='w-50 col px-2'><button @click=\"openModal('" . $product->cdartn . "')\">" . $this->translate('listing.quickBuy') . "</button></div></div></div>";
        } else {
            if ($common['order_info']->rulist != '' && $product->retailPrice != 0 && $productPrice != '&nbsp;' && $productPrice != '-' && $productPrice != '') {
                $price = $this->utility->getFormattedPrice($common['order_info']->rulist, $product->retailPrice);
                $retailPrice = $price['value'];
            } else {
                $retailPrice = '';
            }
            $priceHtml .= $withDiscount
                ? "<div class='price-model-box-discounted text-center'>WHS <span class='discounted'>" . $price['value'] . "</span> " . $productPrice . "</div>"
                : "<div class='price-model-box'>" . ($productPrice != '&nbsp;' && $productPrice != '-' && $productPrice != '' ? 'WHS ' . $productPrice : '') . "</div>";
            $priceHtml .= $retailPrice != '' ? "<div class='price-model-box'>RTL " . $retailPrice . "</div>" : '';
        }

        $infoOnImage = '';
        if ($common['showPriceOverImage']) {
            $infoOnImage = "<div class='over-info-model-box'>";
            $infoOnImage .= "<div>" . (is_numeric(substr($product->cdartn, 0, 4)) ? substr($product->cdartn, 4) : $product->cdartn) . '</div>';
            $infoOnImage .= $productPrice;
            $infoOnImage .= '</div>';
        }

        $html =
            "<div class='col-12 col-md-8 $lg model-box' id='" . htmlentities($code, ENT_COMPAT, 'UTF-8') . "' data-code='$code' data-price='$product->catalogPrice'
      data-descr='" . htmlentities($description, ENT_COMPAT, 'UTF-8') . "'>
        <div class='shop-item' " . (!$isDefault ? "style='cursor:pointer'" : '') . ">
          <div class='image-model-box shop-thumbnail'>" .

            ($isDefault
                ? "<a href='" . $this->url->get($modelLink) . "' class='no-deco'>" : '') .

            ($isLazy
                ? "<img class='lazy' src='" . $prefix . "assets/img/blank.gif' data-src='" . $imgurl . "'
                alt='" . htmlentities($description, ENT_COMPAT, 'UTF-8') . "' " .
                ($exist2 ? "onmouseover=\"this.src='" . $imgurl2 . "';\" onmouseout=\"this.src='" . $imgurl . "';\" " : '') . "/>
                <noscript>"
                : '') .
            "<img src='" . $imgurl . "' alt='" . htmlentities($description, ENT_COMPAT, 'UTF-8') . "' " .
            ($exist2 ? "onmouseover=\"this.src='" . $imgurl2 . "';\" onmouseout=\"this.src='" . $imgurl . "';\" " : '') . "/>" .
            ($isLazy ? '</noscript>' : '') .

            $infoOnImage .

            // agire qui per settare il parametro per limitare il bollo SALE alle sconto 2281 Vedere Domani
            ($isDefault
                ? "</a>" : '') .

            ($withDiscount ? "<span class='product-ribbon product-ribbon-right product-ribbon--style-1 text-uppercase'>" . $cust_disc . "% </span>" : '') .

            // ERA DENTRO ISDEFAULT
            //  <div class='shop-item-tools'>
            //     <div class='w-50 float-left text-right'>
            //  </div>

            ($isDefault && $common['modelDetailStyle'] != 3
                ? "
             <div style='display: none;' class='shop-item-tools'>
              <div class='w-50 float-left text-right'>
             </div>
          " .
                ($isQuick
                    ? "<div class='w-50 float-left text-left'>
                <a href='#' class='d-none d-md-block btn-quick-shop'>
                  <img src='" . $prefix . "assets/img/quick-shop.jpg' />
                  <span>" . $this->translate('_common.buy') . "</span>
                </a>
              </div>"
                    : '') .
                "</div>"
                : '') .
            "</div> " . $this->elements->getColorVariantForProduct($variantItems, $modelLink) . "
          <div class='descr-model-box'>" . htmlentities($description, ENT_COMPAT, 'UTF-8') . "</div>
          <div class='code-model-box'>" . ($hasAvailabilityFlag ? '<span class="model-code ' . $this->elements->getHighlightClass() . '">' . $code . '</span>' : $code) . "</div>" .
            $priceHtml;

        // if ($common['isOrder'] && $common['order_info']->tpordc == 0) {
        //   $availability_text = !$product->is_available ? $this->translate('_common.notavailable') : "&nbsp;";
        //   $html .= "<div class='availability-model-box text-center'>$availability_text</div>";
        // }

        $html .=
            '</div>
    </div>';
        if ($this->session->has('goto') && $this->session->get('goto') != "") {
            $goto = $this->session->get('goto');
            $html .= "<script>if (typeof $('#" . $goto . "').offset() !== 'undefined')$(document).scrollTop( $('#" . $goto . "').offset().top - 200);</script>";
            $this->session->remove('goto');
        }

        return $html;
    }

    private function getHtmlCodeForExactSearch($tipolo, $common)
    {
        if (!$this->utility->hasWizard($common['modelDetailStyle']) || ($common['isOrder'] && $common['order_info']->tpordc == 0)) {
            $detailUrl = $this->url->get('model/' . $tipolo->cdartn);
        } else {
            $detailUrl = $this->url->get('model/wizard/' . $tipolo->cdartn);
        }

        $html =
            '<div class="row model-list-row" id="row-' . $tipolo->cdartn . '" data-code="' . $tipolo->cdartn . '" data-descr="' . $tipolo->dsartn . '">

        <!-- First level: image column -->
        <div class="col-4 col-md-3 little-space-img">' .
            $this->elements->getModelImgOrDefaultHtml($tipolo->flimag, $tipolo->dsartn) .
            '</div>
        <div class="d-block d-md-none col-8 mt-20x">
          <a href="' . $detailUrl . '">
            <span class="font-weight-bold">' . $tipolo->cdartn . '</span><br/>' . $tipolo->dsartn . '
          </a>
        </div>

        <!-- First level: info column -->
        <div class="col-12 col-md-9">
          <!-- Second level: model description row -->
          <div class="row d-none d-md-block">
            <div class="col-5">
              <a href="' . $detailUrl . '">
                <span class="font-weight-bold">' . $tipolo->cdartn . '</span><br/>' . $tipolo->dsartn . '
              </a>
            </div>
          </div>';

        $onlyOne = false;

        $html .= '<div class="row">';

        $i = 0;
        foreach ($tipolo->anaart as $article) {
            $style = $i % 2 == 0 ? 'style="padding-right:5px;margin-right:5px;"' : '';
            $i++;

            $html .=
                '<!-- Second level: article row -->
          <div class="col-6 article-list-row row" ' . $style . ' id="row-arti-{{ urlencode(article.cdarti) }}"
            data-cdarti="' . $article->cdarti . '" data-cdcolo="' . $article->cdcolo . '"
            data-nurorc="' . $article->presence . '" data-cdtagl="' . $tipolo->cdtagl . '"
            data-tglini="' . $tipolo->tglini . '" data-tglfin="' . $tipolo->tglfin . '"
            data-tppers="' . $tipolo->tppers . '">

            <!-- Col Image + Description -->
            <div class="col-5 col-desc-container">
              <div class="row d-block d-md-none">
                <div class="col-12 font-weight-bold">' . $article->dscolo . '</div>
              </div>
              <div class="row col-desc">
                <div class="col-6 h-100">' .
                $this->elements->getModelImgOrDefaultHtml($article->flimag, $article->dsarti) .
                '</div>
                <div class="d-none d-md-block col-6">' . $article->dscolo . '</div>
              </div>
            </div>

            <!-- Col Sizes Desktop -->
            <div class="col-7 d-none d-md-block">';

            for ($i = 0; $i < count($article['qttagl']); $i++) {
                $size = $article['qttagl'][$i];

                $disabled = (($i + 1) < $tipolo->tglini && $tipolo->tglini != 0) || (($i + 1) > $tipolo->tglfin && $tipolo->tglfin != 0);
                $disc_price = 0;
                if ($common['showCatalogPrice'] == 1 || ($common['showCatalogPrice'] == 2 && $common['isOrder'])) {
                    $withDiscount = false;
                    $currentPrice = $size['prezzo'];
                    if ($currentPrice < 0) {
                        $currentPrice = $this->translate('quantity.priceforsize.short');
                    } else if ($currentPrice == 0) {
                        $currentPrice = in_array($common['modelDetailStyle'], [0, 1, 2, 6, 8, 9]) ? '-' : '';
                    } else {

                        $real_price = $currentPrice;
                        $cust_disc = $tipolo->cust_disc > 0 ? $tipolo->cust_disc : 0;
                        $cust_disc = $article->cust_disc > 0 ? $article->cust_disc : $cust_disc;
                        $disc_price = $real_price * (1 - $cust_disc / 100);
                        $withDiscount = $disc_price != $real_price;

                        $catalogPrice = $this->utility->getFormattedPrice($common['order_info']->nulist, $disc_price);
                        $currentPrice = $catalogPrice['value'];
                    }
                }

                $html .=
                    '<div class="quick-order-size-box ' . ($disabled ? 'size-disabled' : '') . '">
            <div class="qosb-size">' . $size['taglia'] . '</div>
            <div class="qosb-qty">
              <input type="number" class="size-qty"
                data-taglia="' . $size['taglia'] . '" data-prezzo="' . ($disc_price > 0 ? $disc_price : $size['prezzo']) . '"
                data-qtamin="' . $size['qtamin'] . '" data-qtamul="' . ($size['qtamul'] > 0 ? $size['qtamul'] : 1) . '"
                data-sconto="' . $cust_disc . '"
                name="quantity" min="0" step="' . ($size['quanti'] > $size['qtamin'] ? $size['qtamul'] : $size['qtamin']) . '"
                value="' . ($size['quanti'] > 0 ? $size['quanti'] : '') . '" ' . ($disabled ? 'disabled' : '') . '/>';

                if ($this->utility->getAppSettings('EnableMinMulLabel') > 0) {
                    $html .= "<div class='regqta-info'>";
                    $html .= $this->translate('_common.qty.min.short') . ': ' . $size['qtamin'] . ', ';
                    $html .= $this->translate('_common.qty.mul.short') . ': ' . $size['qtamul'];
                    if (isset($size['qtamax']) && $size['qtamax'] > 0) {
                        $html .= ', ' . $this->translate('_common.qty.max.short') . ': ' . $size['qtamax'];
                    }
                    $html .= "</div>";
                }

                $html .= '</div>';

                if ($common['showCatalogPrice'] == 1 || ($common['showCatalogPrice'] == 2 && $common['isOrder'])) {
                    $real_price = $this->utility->getFormattedPrice($common['order_info']->nulist, $real_price)['value'];
                    $html .=
                        '<div class="qosb-price">' .
                        ($withDiscount
                            ? "<span class='discounted'>" . $real_price . "</span> " . $currentPrice
                            : $currentPrice) .
                        '</div>';
                }

                $html .= '</div>';
            }

            $html .=
                '</div>
        </div>';
        }

        $html .= '</div>';

        $html .=
            '</div>
      </div>';

        return $html;
    }

    private function getHtmlCodeForContainer($block_index, $title, $banner = null)
    {

        $enableParamCollectionNoTitle = $this->utility->getAppSettings('ParamCollectionNoTitle');
        $html = "<div class='models-block' id='block-" . $block_index . "'>";

        if ($enableParamCollectionNoTitle == 0) {
            $html .= "<div class='row'>";
            $html .= "<div class='col-12 col-md-10 col-lg-4 " . ($title != '' ? 'title-model-block' : '') . "' style='background-color:" . (!empty($this->view->common['navbarBgColor']) ? $this->view->common['navbarBgColor'] : '#eee') . "'>" . ($title != '' ? $title : '&nbsp;') . "</div>";
            $html .= "</div>";
        }

        $html .= "<div class='row articles-container' id='articles-" . $block_index . "'>";

        if (!empty($banner)) {
            if (file_exists('upload/' . $banner)) {
                $html .= '<div class="col-12 mb-40x text-center"><img src="' . $this->config->application->baseUri . 'upload/' . $banner . '" style="margin:0 auto"/></div>';
            }
        }

        return $html;
    }

    private function getHtmlCodeForContainerClosure()
    {
        return '</div>
      </div>';
    }

    private function getHtmlCodeForModelPreview($tipolo, $modinf, $isOrder, $tag)
    {
        $prefix = $this->config->application->baseUri;

        $flimag = $tipolo->flimag != '' && file_exists('img/model/' . $tipolo->flimag)
            ? $this->utility->getImageModelLink($tipolo->flimag)
            : $this->config->application->baseUri . 'assets/img/default_model.jpg';

        $imgart = '';
        if (count($tipolo->imgart) > 0) {
            foreach ($tipolo->imgart as $img) {
                $file = file_exists('img/model/' . $img->flimag)
                    ? $this->utility->getImageModelLink($img->flimag)
                    : $this->config->application->baseUri . 'assets/img/default_model.jpg';
                $imgart .=
                    '<div class="col-1 p-0">
            <img src="' . $file . '" alt="' . $this->translate('_common.see') . '" class="preview-thumbnail"/>
          </div>';
            }
        }

        $html =
            '<div class="row mx-0 mb-30x">
      <div class="col-12 col-lg-6" id="images-section" style="margin-top:30px">
        <div class="row">
          <div class="col-12">
            <img src="' . $flimag . '" alt="' . $tipolo->dsartn . '"/>
          </div>
        </div>
      </div>
      <div class="col-12 col-lg-6" id="descr-section">
        <div class="model-description-box">
          <span class="model-description">' . $tipolo->dsartn . '</span><br/>
          <span class="model-code ' . $this->elements->getHighlightClass() . '">' . $tipolo->cdartn . '</span><br/>
          <span class="model-code" style="text-transform:uppercase">' .
            $tipolo->anaart_n . ' ' . ($tipolo->anaart_n > 1 ? $this->translate('model.availablevariants') : $this->translate('model.availablevariant')) .
            '</span>
        </div>
        <div class="modal-close" data-dismiss="modal" style="top:30px">
          <img src="' . $prefix . 'assets/img/times.png" class="m-0-auto pointer" alt="' . $this->translate('_common.close') . '"/>
        </div>
        <div class="row model-info">
          <div class="col-6">' . $this->translate('_common.brand') . ': ' . $tipolo->dstitl . '</div>
          <div class="col-6">' . $this->translate('_common.genre') . ': ' . $tipolo->dsgene . '</div>
          <div class="col-6">' . $this->translate('_common.line') . ': ' . $tipolo->dslinm . '</div>
          <div class="col-6">' . $this->translate('_common.modeltype') . ': ' . $tipolo->dstmod . '</div>' .
            ($tipolo->dsserm != ''
                ? '<div class="col-6">' . $this->translate('_common.series') . ': ' . $tipolo->dsserm . '</div>' : '') .
            (($modinf != null && $modinf->compos != '') || $tipolo->descmp != ''
                ? '<div class="col-6">' . $this->translate('_common.composition') . ': ' . ($modinf != null && $modinf->compos != '' ? $modinf->compos : $tipolo->descmp) . '</div>' : '') .
            (($modinf != null && $modinf->madein != '') || $tipolo->desmad != ''
                ? '<div class="col-6">' . $this->translate('_common.madein') . ' ' . ($modinf != null && $modinf->madein != '' ? $modinf->madein : $tipolo->desmad) . '</div>' : '') .
            '</div>

        <!-- Nav Tabs -->
        <div class="model-tabs">
          <ul class="nav nav-tabs nav-justified w-100 ml-0 d-sm-block" role="tablist" data-tabs="tabs">
            <li class="nav-item"><a class="active" href="#tab-info-not" role="tab" data-toggle="tab" aria-expanded="true">' . $this->translate('_common.notes') . '</a></li>
            <li class="nav-item"><a href="#tab-info-inf" role="tab" data-toggle="tab" aria-expanded="true">' . $this->translate('_common.details') . '</a></li>
            <li class="nav-item"><a href="#tab-info-dwn" role="tab" data-toggle="tab" aria-expanded="true">' . $this->translate('_common.downloadtechnicalfile') . '</a></li>
          </ul><!-- .nav-tabs -->

          <div class="tab-content account-info">
            <div id="tab-info-not" role="tabpanel" class="tab-pane fade show active">' .
            ($tipolo->descom == "" && ($modinf == null || $modinf->vestib == '')
                ? $this->translate('_common.notes.no')
                : ($tipolo->descom != "" ? $tipolo->descom . '<br/>' : '') .
                ($modinf != null && $modinf->vestib != '' ? $this->translate('_common.fit') . ': ' . $modinf->vestib : '')) .
            '</div>
            <div id="tab-info-inf" role="tabpanel" class="tab-pane fade">' .
            ($tipolo->destec == "" &&
            ($modinf == null ||
                ($this->session->get('language') == 'it' && $modinf->dettit == "") ||
                ($this->session->get('language') == 'en' && $modinf->detten == "") ||
                ($this->session->get('language') == 'es' && $modinf->dettes == "") ||
                ($this->session->get('language') == 'de' && $modinf->dettde == "") ||
                ($this->session->get('language') == 'fr' && $modinf->dettfr == ""))
                ? $this->translate('_common.descr.no')
                : ($tipolo->destec != '' ? $tipolo->destec . '<br/>' : '') .
                ($modinf != null && $this->session->get('language') == 'it' ? $modinf->dettit : '') .
                ($modinf != null && $this->session->get('language') == 'en' ? $modinf->detten : '') .
                ($modinf != null && $this->session->get('language') == 'es' ? $modinf->dettes : '') .
                ($modinf != null && $this->session->get('language') == 'de' ? $modinf->dettde : '') .
                ($modinf != null && $this->session->get('language') == 'fr' ? $modinf->dettfr : '')) .
            '</div>
            <div id="tab-info-dwn" role="tabpanel" class="tab-pane fade">' .
            (file_exists($prefix . 'techfiles/' . $tipolo->cdartn . '.pdf')
                ? '<a href="' . $prefix . 'techfiles/' . $tipolo->cdartn . '.pdf" class="btn btn-generic mr-0 mt-0" style="width:250px">DOWNLOAD</a>'
                : $this->translate('_common.downloadtechnicalfile.no')) .
            '</div>
          </div><!-- .tab-content -->' .
            ($tipolo->flvide != '' && file_exists($prefix . 'video/' . $tipolo->flvide)
                ? '<div class="model-video-btn-box">
              <a href="#" id="play-video" class="btn btn-generic w-100">' . $this->translate('model.watchvideo') . '</a>
              <a href="#" id="show-photos" class="btn btn-generic w-100" style="display:none">' . $this->translate('model.showphotos') . '</a>
            </div>'
                : '') .
            '</div>
      </div>
    </div>
    <div class="row mx-0 mb-20x" style="margin-top:20px">
      <div class="col-12 col-lg-6">
        <div class="row px-10x">
          <div class="col-1 p-0">
            <img src="' . $flimag . '" alt="' . $this->translate('_common.see') . '" class="preview-thumbnail preview-selected"/>
          </div>' .
            $imgart .
            '</div>
      </div>
      <div class="col-12 col-lg-6">
        <div class="quantity-model-box col-12">
          <a href="' . $this->url->get('model/wizard/' . $tipolo->cdartn) . ($tag != '' ? '?flt=' . $tag : '') . '" class="btn btn-main w-100 mb-0">' .
            ($isOrder
                ? $this->translate('_common.configureandbuy')
                : $this->translate('_common.seemore')) .
            '</a>
        </div>
      </div>
    </div>';

        return $html;
    }

    private function getHtmlCodeForFabric($fabric, $isLazy)
    {
        $prefix = $this->config->application->baseUri;

        // images

        $imgurl1 = $this->utility->getImageModelLink($fabric->flimag);
        $exist1 = $fabric->flimag != '' && file_exists('img/model/' . $fabric->flimag);
        $imgurl = !$exist1 ? $prefix . 'assets/img/default_model.jpg' : $imgurl1;

        switch ($this->utility->getAppSettings('ItemsPerRowOnVisualCatalog')) {
            case 1:
                $lg = 'col-lg-4';
                break;
            case 2:
                $lg = 'col-lg-6';
                break;
            default:
                $lg = 'col-lg-3';
                break;
        }

        $html =
            "<div class='col-6 col-md-4 $lg model-box' id='$fabric->cdpers'
      data-code='$fabric->cdpers' data-descr='" . htmlentities($fabric->dspers, ENT_COMPAT, 'UTF-8') . "'>
      <div class='shop-item'>
        <div class='image-model-box shop-thumbnail'>
          <a href='" . $this->url->get('catalog/fabricDetail/' . $fabric->cdpers) . "' class='no-deco'>" .

            ($isLazy
                ? "<img class='lazy' src='" . $prefix . "assets/img/blank.gif' data-src='" . $this->url->get($imgurl) . "'
                alt='" . htmlentities($fabric->dspers, ENT_COMPAT, 'UTF-8') . "' />
                <noscript>"
                : '') .
            "<img src='" . $this->url->get($imgurl) . "' alt='" . htmlentities($fabric->dspers, ENT_COMPAT, 'UTF-8') . "' />" .
            ($isLazy ? '</noscript>' : '') .

            "</a>
        </div>" .
            ($fabric->des_comm != '' ? '<div class="descr-fabric-commercial-box">' . $fabric->des_comm . '</div>' : '') .
            "<div class='descr-fabric-box'>" . htmlentities($fabric->dspers, ENT_COMPAT, 'UTF-8') . "</div>
        <div class='code-fabric-box'>$fabric->cdpers</div>
        <div class='descr-composition-box'>$fabric->compos</div>
      </div>
    </div>";

        if ($this->session->has('goto') && $this->session->get('goto') != "") {
            $goto = $this->session->get('goto');
            $html .= "<script>if (typeof $('#" . $goto . "').offset() !== 'undefined')$(document).scrollTop( $('#" . $goto . "').offset().top - 200);</script>";
            $this->session->remove('goto');
        }

        return $html;
    }
    //endregion

    //region List functions
    private function getAllTipoloList($cdcata, $nulist, $flt, $section, $page, $common, $isQuickOrder, &$cntModels, $idlang = 'IT')
    {
        $id_usr = $this->session->get('auth')['id'];
        if ($common['modelDetailStyle'] == 3) {
            $isSpecialSorting = B2bAddinf::isSpecialAgent($id_usr);
            if ($common['isOrder']) {
                $rulist = $common['order_info']->rulist;
            } else {
                $rulist = Anagra::getRulist($id_usr);
            }
        } else {
            $isSpecialSorting = false;
            $rulist = '';
        }

        $items = array(
            'cdcata' => $cdcata,
            'nulist' => $nulist,
            'numdis' => $this->utility->getCustomDiscount(),
            'idlang' => $idlang,
            'idUsr' => $id_usr,
            'isOrder' => $common['isOrder'],
            'isPT' => Tipolo::findFirstByTppers('PT') != null,
            'filters' => $flt,
            'section' => $section,
            'rulist' => $rulist,
            'isAvailability' => $common['isOrder'] && $common['order_info']->tpordc == 0,
            'showNotAvailable' => $common['shownotavailable'] == 1,
            'isSpecialSorting' => $isSpecialSorting,
            'hasCustomSorting' => B2bAddinf::hasCustomSortingForCatalog($cdcata),
        );
        $tipolo = Tipolo::getAllModelsForCatalogList($items);

        $paged_tipolo = [];
        $page_length = $isQuickOrder ? 25 : 50;
        $skipCounter = ($page - 1) * $page_length;
        $counter = 0;

        for ($i = 0; $i < count($tipolo); $i++) {
            if ($skipCounter == 0 && $counter < $page_length) {
                $paged_tipolo[] = $tipolo[$i];
                $counter++;
            } else {
                $skipCounter--;
            }
            $cntModels++;
        }

        // Adds all "anaart" (with availability if needed) to "tipolo"
        return $this->getFullTipoloListArray($paged_tipolo, $cdcata, $nulist, $common, $isQuickOrder, $idlang);
    }

    private function getAllTipoloFromSearchList($cdcata, $search, $nulist, $common, $isQuickOrder, $idlang = 'IT')
    {
        $id_usr = $this->session->get('auth')['id'];
        if ($common['modelDetailStyle'] == 3) {
            $isSpecialSorting = B2bAddinf::isSpecialAgent($id_usr);
            if ($common['isOrder']) {
                $rulist = $common['order_info']->rulist;
            } else {
                $rulist = Anagra::getRulist($id_usr);
            }
        } else {
            $isSpecialSorting = false;
            $rulist = '';
        }

        $items = array(
            'cdcata' => $cdcata,
            'nulist' => $nulist,
            'search' => '%' . $search . '%',
            'idlang' => $idlang,
            'idUsr' => $id_usr,
            'isOrder' => $common['isOrder'],
            'isPT' => Tipolo::findFirstByTppers('PT') != null,
            'numdis' => $this->utility->getCustomDiscount(),
            'rulist' => $rulist,
            'searchType' => $this->utility->getAppSettings('ModelSearchType'),
            'isAvailability' => $common['isOrder'] && $common['order_info']->tpordc == 0,
            'showNotAvailable' => $common['shownotavailable'] == 1,
            'isSpecialSorting' => $isSpecialSorting,
            'hasCustomSorting' => B2bAddinf::hasCustomSortingForCatalog($cdcata),
        );
        if ($this->utility->getAppSettings('EnableBarcode') > 0) {
            $items['barcode'] = $search;
        }

        $tipolo = Tipolo::getAllModelsForCatalogFromListSearch($items);

        // Adds all "anaart" (with availability if needed) to "tipolo"
        return $this->getFullTipoloListArray($tipolo, $cdcata, $nulist, $common, $isQuickOrder, $idlang);
    }

    private function getAllTipoloFromExactSearchList($cdcata, $search, $nulist, $common, $idlang = 'IT')
    {
        $id_usr = $this->session->get('auth')['id'];
        if ($common['modelDetailStyle'] == 3) {
            $isSpecialSorting = B2bAddinf::isSpecialAgent($id_usr);
            if ($common['isOrder']) {
                $rulist = $common['order_info']->rulist;
            } else {
                $rulist = Anagra::getRulist($id_usr);
            }
        } else {
            $isSpecialSorting = false;
            $rulist = '';
        }

        $items = array(
            'cdcata' => $cdcata,
            'nulist' => $nulist,
            'search' => $search,
            'idlang' => $idlang,
            'idUsr' => $id_usr,
            'isOrder' => $common['isOrder'],
            'isPT' => Tipolo::findFirstByTppers('PT') != null,
            'numdis' => $this->utility->getCustomDiscount(),
            'rulist' => $rulist,
            'isAvailability' => $common['isOrder'] && $common['order_info']->tpordc == 0,
            'showNotAvailable' => $common['shownotavailable'] == 1,
            'isSpecialSorting' => $isSpecialSorting,
            'hasCustomSorting' => B2bAddinf::hasCustomSortingForCatalog($cdcata),
        );
        $tipolo = Tipolo::getAllModelsForCatalogFromListSearch($items, false);

        // Adds all "anaart" (with availability if needed) to "tipolo"
        return $this->getFullTipoloListArray($tipolo, $cdcata, $nulist, $common, true, $idlang);
    }

    private function getFullTipoloListArray($tipolo, $cdcata, $nulist, $common, $isQuickOrder, $idlang = 'IT')
    {
        $full_tipolo = array();
        for ($i = 0; $i < count($tipolo); $i++) {
            $curr_tipolo = $tipolo[$i];
            $curr_tipolo->tags = Artcla::getTagsForModel($tipolo[$i]->cdartn);
            $curr_tipolo->anaart = '';

            $anaart = $this->getAllAnaartFromTipoloForList($tipolo[$i]->cdartn, $cdcata, $nulist, $common, $isQuickOrder, $tipolo[$i]->tppers, $idlang);

            if (count($anaart) > 0) {
                $curr_tipolo->writeAttribute('anaart', $anaart);
            }

            $full_tipolo[] = $curr_tipolo;
        }

        return $full_tipolo;
    }

    private function getAllAnaartFromTipoloForList($cdartn, $cdcata, $nulist, $common, $isQuickOrder, $tppers = '', $idlang = 'IT')
    {
        $items = array(
            'cdartn' => $cdartn,
            'cdcata' => $cdcata,
            'nulist' => $nulist,
            'id_usr' => $this->session->get('auth')['id'],
            'numdis' => $this->utility->getCustomDiscount(),
            'idlang' => $idlang,
            'isQuickOrder' => $isQuickOrder,
            'filterNotAvailable' => false,
            'showAvailabilityFlag' => $this->utility->getAppSettings('ShowAvailabilityFlag') == 1,
        );

        $anaart = Anaart::getAllArticlesFromModel($items);

        $auth = $this->session->get('auth');
        $isOrder = Octest::findOrderInProgress($auth['id']) != null;

        if ($isOrder) {
            $order = Octest::getCurrentOrder($auth['id']);
        }

        $full_anaart = array();
        for ($i = 0; $i < count($anaart); $i++) {
            $curr_anaart = $anaart[$i];
            $curr_anaart->colors = '';
            $curr_anaart->qtdisp = '';
            $curr_anaart->qttagl = '';

            if ($tppers == 'PT') {
                $items = array(
                    'modelDetailStyle' => $this->utility->getAppSettings('ModelDetailStyle'),
                    'colorAssignmentSource' => $this->utility->getAppSettings('ColorAssignmentSource'),
                    'nuordc' => $isOrder ? $order->nuordc : -1,
                    'cdarti' => $curr_anaart->cdarti,
                );
                if ($isOrder) {
                    $curr_anaart->writeAttribute('colors', Artcol::getColorsForOrderArticleDetail($items));
                } else {
                    $curr_anaart->writeAttribute('colors', Artcol::getColorsForArticleDetail($items));
                }
            } else if ($isOrder && $order->tpordc == 0 && $tppers != "PT") {
                $curr_anaart->writeAttribute('qtdisp', $this->getTotalAvailabilityForArticle($curr_anaart->cdarti));
            } else if ($isOrder && $order->tpordc != 0 && $tppers != "PT" && $isQuickOrder) {
                $curr_anaart->writeAttribute('qttagl', Postgl::getSizesWithQuantityForArticle($order->nuordc, $curr_anaart->cdartn, $curr_anaart->cdarti, $curr_anaart->cdcolo, $nulist));
            }

            $full_anaart[] = $curr_anaart;
        }

        return $full_anaart;
    }

    private function getTotalAvailabilityForArticle($cdarti)
    {
        $dscorp = Dscorp::getArticleAvailabilities($cdarti);

        $total = 0;
        foreach ($dscorp as $dsp) {
            if ($dsp->quanti > 0) {
                $total += $dsp->quanti;
            }
        }

        return $total;
    }
    //endregion

    //region Tipolo functions
    private function getAllProducts($cdcata, $nulist, $flt, $section, $common, $idlang = 'IT', $isSales = false, $tag = '', $cdspsl = '', $classifications = [])
    {
        $id_usr = $this->session->get('auth')['id'];
        if ($common['modelDetailStyle'] == 3) {
            $isSpecialSorting = B2bAddinf::isSpecialAgent($id_usr);
            if ($common['isOrder']) {
                $rulist = $common['order_info']->rulist;
            } else {
                $rulist = Anagra::getRulist($id_usr);
            }
        } else {
            $isSpecialSorting = false;
            $rulist = '';
        }

        $items = array(
            'cdcata' => $cdcata,
            'cdspsl' => $cdspsl,
            'nulist' => $nulist,
            'numdis' => $this->utility->getCustomDiscount(),
            'idlang' => $idlang,
            'idUsr' => $id_usr,
            'isOrder' => $common['isOrder'],
            'isSales' => $isSales,
            'isPT' => Tipolo::findFirstByTppers('PT') != null,
            'filters' => $flt,
            'section' => $section,
            'tag' => $tag,
            'tagType' => !empty($tag) ? (($artcla = Artcla::findFirstByValore($tag)) != null ? $artcla->tpinpu : 'AN') : '',
            'rulist' => $rulist,
            'isAvailability' => $common['isOrder'] && $common['order_info']->tpordc == 0,
            'showNotAvailable' => $common['shownotavailable'] == 1,
            'isSpecialSorting' => $isSpecialSorting,
            'hasCustomSorting' => B2bAddinf::hasCustomSortingForCatalog($cdcata),
        );

        $products = null;
        if ($cdspsl == '') {
            if ($common['catalogProductType'] == 0) {
                $products = Tipolo::getAllModelsForCatalog($items);
            } else if ($common['catalogProductType'] == 1) {
                $products = Anaart::getAllArticlesForCatalog($items);
            } else if ($common['catalogProductType'] == 2) {
                $products = Anaart::getAllArtColForCatalog($items);
            }
        } else {
            $specialSelections = $this->utility->getAppSettings('SpecialSelections');
            if ($specialSelections == 1) {
                $products = Tipolo::getAllModelsForSelection($items);
            } else if ($specialSelections == 2) {
                $products = Anaart::getAllArticlesForSelection($items);
            }
        }

        return $products;
    }

    private function getAllProductsFromSearch($cdcata, $search, $nulist, $flt, $common, $idlang = 'IT')
    {
        $id_usr = $this->session->get('auth')['id'];
        if ($common['modelDetailStyle'] == 3) {
            $isSpecialSorting = B2bAddinf::isSpecialAgent($id_usr);
            if ($common['isOrder']) {
                $rulist = $common['order_info']->rulist;
            } else {
                $rulist = Anagra::getRulist($id_usr);
            }
        } else {
            $isSpecialSorting = false;
            $rulist = '';
        }

        $items = array(
            'cdcata' => $cdcata,
            'nulist' => $nulist,
            'search' => '%' . $search . '%',
            'numdis' => $this->utility->getCustomDiscount(),
            'idlang' => $idlang,
            'idUsr' => $id_usr,
            'isOrder' => $common['isOrder'],
            'isPT' => Tipolo::findFirstByTppers('PT') != null,
            'filters' => $flt,
            'rulist' => $rulist,
            'searchType' => $this->utility->getAppSettings('ModelSearchType'),
            'isAvailability' => $common['isOrder'] && $common['order_info']->tpordc == 0,
            'showNotAvailable' => $common['shownotavailable'] == 1,
            'isSpecialSorting' => $isSpecialSorting,
            'customerDiscount' => $common['customer_discount'],
            'hasCustomSorting' => B2bAddinf::hasCustomSortingForCatalog($cdcata),
            'showAvailabilityFlag' => $common['showAvailabilityFlag'] == 1,
        );

        if ($this->utility->getAppSettings('EnableBarcode') > 0) {
            $items['barcode'] = $search;
        }

        if ($common['catalogProductType'] == 0) {
            $products = Tipolo::getAllModelsForCatalogFromSearch($items);
        } else if ($common['catalogProductType'] == 1) {
            $products = Anaart::getAllArticlesForCatalogFromSearch($items);
        } else if ($common['catalogProductType'] == 2) {
            $products = Anaart::getAllArtColForCatalogFromSearch($items);
        }

        return $products;
    }
    //endregion

    //region Fabric functions
    private function getAllFabrics($cdcata, $flt, $section)
    {
        $items = array(
            'cdcata' => $cdcata,
            'section' => $section,
            'filters' => $flt,
            'idlang' => $this->utility->getLanguage(),
        );

        $fabrics = Anaper::getAllFabricsForCatalog($items);

        return $fabrics;
    }

    private function getAllFabricsFromSearch($cdcata, $search)
    {
        $items = array(
            'cdcata' => $cdcata,
            'search' => '%' . $search . '%',
            'idlang' => $this->utility->getLanguage(),
        );

        $fabrics = Anaper::getAllFabricsForCatalogFromSearch($items);

        return $fabrics;
    }
    //endregion

    //region Counters functions
    private function getNumOfResults($cdcata, $search, $catalogProductType, $isFabric = false)
    {
        if (!$isFabric) {
            $id_usr = $this->session->get('auth')['id'];
            $isOrder = Octest::findOrderInProgress($id_usr) != null;
            $idlang = $this->utility->getLanguage();
            $order_info = $isOrder ? Octest::getCurrentOrder($id_usr) : '';

            $items = array(
                'cdcata' => $cdcata,
                'search' => '%' . $search . '%',
                'idlang' => $idlang,
                'isPT' => Tipolo::findFirstByTppers('PT') != null,
                'searchType' => $this->utility->getAppSettings('ModelSearchType'),
                'isAvailabilityOrder' => $isOrder && $order_info->tpordc == 0,
                'showNotAvailable' => $this->utility->getAppSettings('ParamShowNotAvailableItems') == 1,
            );

            if ($this->utility->getAppSettings('EnableBarcode') > 0) {
                $items['barcode'] = $search;
            }

            if ($catalogProductType == 0) {
                return Ctarti::getNumberOfModelsFromSearchForCurrentCatalog($items);
            } else if ($catalogProductType == 1) {
                return Ctarti::getNumberOfArticlesFromSearchForCurrentCatalog($items);
            } else if ($catalogProductType == 2) {
                return Ctarti::getNumberOfArtColFromSearchForCurrentCatalog($items);
            }
        } else {
            $items = array(
                'cdcata' => $cdcata,
                'search' => '%' . $search . '%',
            );
            return Ctarti::getNumberOfFabricsFromSearchForCurrentCatalog($items);
        }
    }
    //endregion

    //region Featured functions
    private function getFeaturedModels($cdcata, $nulist, $common, $idlang)
    {
        if ($cdcata != "") {
            $items = array(
                'cdcata' => $cdcata,
                'nulist' => $nulist,
                'idlang' => $idlang,
                'numdis' => $this->utility->getCustomDiscount(),
                'id_usr' => $this->session->get('auth')['id'],
                'isOrder' => $common['isOrder'],
                'isPT' => Tipolo::findFirstByTppers('PT') != null,
                'isAvailabilityOrder' => $common['isOrder'] && $common['order_info']->tpordc == 0,
                'showNotAvailable' => $common['shownotavailable'] == 1,
                'featuredSorting' => $common['FeaturedSorting'],
            );

            if ($common['catalogProductType'] == 0) {
                return B2bModevi::getFeaturedModels($items);
            } else if ($common['catalogProductType'] == 1) {
                return B2bModevi::getFeaturedArticles($items);
            } else if ($common['catalogProductType'] == 2) {
                return B2bModevi::getFeaturedArtCol($items);
            }
            $tipolo = $this->modelsManager->executeQuery($phql, $params);

            return $tipolo;
        } else {
            return array();
        }
    }
    //endregion

    //region Home page functions
    private function getHomePage($cdcata)
    {
        if ($cdcata != '') {
            $hpcorp = B2bHpcorp::find(array('cdcata = :cdcata:', 'bind' => array('cdcata' => $cdcata), 'order' => 'nubloc,seqrap'));
            $homepage = array(
                'hptest' => B2bHptest::findFirstByCdcata($cdcata),
                'blocks' => $this->utility->getBlocksArrayForHomepage($hpcorp),
            );
            if (!empty($homepage['hptest'])) {
                $homepage['hptest']->isImage = $homepage['hptest']->flimg1 != '' && substr($homepage['hptest']->flimg1, 0, -3) != 'mp4';
            }
            return $homepage;
        } else {
            return array();
        }
    }
    //endregion

    //region Lookbooks functions
    private function getLookbook($cdlkbk)
    {
        $lktest = Lktest::findFirstByCdlkbk($cdlkbk);
        return array(
            'fltipo' => $lktest->fltipo,
            'dslkbk' => $lktest->dslkbk,
            'lkcorp' => Lkcorp::getLooksFromLookbook($cdlkbk),
        );
    }

    private function getLook($cdlkbk, $cdlook, $fltipo, $nulist, $common, $idlang = 'IT')
    {
        $lkcorp = Lkcorp::getLook($cdlkbk, $cdlook);
        $numdis = $this->utility->getCustomDiscount();

        switch ($fltipo) {
            case 0:
                $items = Lkmode::getModelsForLook($cdlkbk, $cdlook, $nulist, $numdis, $idlang);
                break;
            case 1:
                $items = Lkarti::getArticlesForLook($cdlkbk, $cdlook, $nulist, $numdis, $idlang);
                break;
            case 2:
                $items = Lkarti::getLardiniArticlesForLook($cdlkbk, $cdlook, $nulist, $numdis, $idlang);
                break;
        }

        return array(
            'dslook' => $lkcorp->dslook,
            'filimg' => $lkcorp->filimg,
            'items' => $items,
        );
    }
    //endregion

    //region Rows functions
    private function getRows($isPT, $cdcata = '')
    {
        $idlang = $this->utility->getLanguage();

        $showNotAvailable = $this->utility->getAppSettings('ParamShowNotAvailableItems') == 1;

        $rows = [];
        if (!empty($cdcata)) {
            //$articles = Ctarti::getAllCatalogDetailsForCurrentCatalog($isPT, $cdcata, $idlang);
            $articles = Ctarti::getAllCatalogDetailsWithAvailabilityForCurrentCatalog($isPT, $cdcata, $showNotAvailable, $idlang);

            foreach ($articles as $article) {
                $article = (object)$article;
                if ($article->items != '') {
                    $items = explode(',', $article->items);
                    $availabilityDates = explode(',', $article->availabilityDates);
                    $availabilityQuantities = explode(',', $article->availabilityQuantities);
                    $isAsso = explode(',', $article->isAsso);

                    $curr_dtdisp = date("d/m/Y", strtotime($availabilityDates[0]));
                    $curr_isasso = $isAsso[0];
                    $full_availability = array();
                    $ass_availability = array();
                    $dsp_availability = array();
                    for ($i = 0; $i < count($availabilityDates); $i++) {
                        if ($curr_dtdisp != date("d/m/Y", strtotime($availabilityDates[$i]))) {
                            $label = $curr_isasso == 1 ? 'asso' : 'size';
                            $ass_availability[$label] = $dsp_availability;
                            $full_availability[] = array(
                                'dtdisp' => $curr_dtdisp,
                                'alldsp' => $ass_availability,
                            );
                            $ass_availability = array();
                            $dsp_availability = array();

                            $curr_dtdisp = date("d/m/Y", strtotime($availabilityDates[$i]));
                            $curr_isasso = $isAsso[$i];
                        } else if ($curr_isasso != $isAsso[$i]) {
                            $label = $curr_isasso == 1 ? 'asso' : 'size';
                            $ass_availability[$label] = $dsp_availability;

                            $dsp_availability = array();
                            $curr_isasso = $isAsso[$i];
                        }

                        $dsp_availability[$items[$i]] = $availabilityQuantities[$i];
                    }

                    $label = $curr_isasso == 1 ? 'asso' : 'size';
                    $ass_availability[$label] = $dsp_availability;

                    $full_availability[] = array(
                        'dtdisp' => $curr_dtdisp,
                        'alldsp' => $ass_availability,
                    );

                    $article->availability = $full_availability;
                } else {
                    $article->availability = array();
                }

                $rows[] = $article;
            }
        } else {
            $articles = Ctarti::getAllAvailableCatalogDetails($isPT, $idlang);

            foreach ($articles as $article) {
                $article = (object)$article;
                if ($isPT) {
                    $availability = Dscorp::getColorAvailabilityForArticle($article);
                } else {
                    $availability = Dscorp::getArticleAvailabilityForArticle($article);
                }
                $full_article = $this->getRowAvailability($availability, $article);
                $rows[] = $full_article;
            }
        }

        return $rows;
    }

    private function getRowAvailability($availability, $article)
    {
        $full_availability = array();
        if (count($availability) > 0) {
            $curr_dtdisp = date("d/m/Y", strtotime($availability[0]['dtdisp']));
            $curr_isasso = $availability[0]['isasso'];
            $ass_availability = array();
            $dsp_availability = array();
            for ($i = 0; $i < count($availability); $i++) {
                if ($curr_dtdisp != date("d/m/Y", strtotime($availability[$i]['dtdisp']))) {
                    $label = $curr_isasso == 1 ? 'asso' : 'size';
                    $ass_availability[$label] = $dsp_availability;
                    $full_availability[] = array(
                        'dtdisp' => $curr_dtdisp,
                        'alldsp' => $ass_availability,
                    );
                    $ass_availability = array();
                    $dsp_availability = array();

                    $curr_dtdisp = date("d/m/Y", strtotime($availability[$i]['dtdisp']));
                    $curr_isasso = $availability[$i]['isasso'];
                } else if ($curr_isasso != $availability[$i]['isasso']) {
                    $label = $curr_isasso == 1 ? 'asso' : 'size';
                    $ass_availability[$label] = $dsp_availability;

                    $dsp_availability = array();
                    $curr_isasso = $availability[$i]['isasso'];
                }

                $dsp_availability[$availability[$i]['item']] = $availability[$i]['quanti'];
            }

            $label = $curr_isasso == 1 ? 'asso' : 'size';
            $ass_availability[$label] = $dsp_availability;

            $full_availability[] = array(
                'dtdisp' => $curr_dtdisp,
                'alldsp' => $ass_availability,
            );
        }

        $article->availability = $full_availability;

        return $article;
    }
    //endregion

    //region Barcode functions
    private function getBarcodeListRow($barcod, $index)
    {
        $html = '';

        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        $numdis = $this->utility->getCustomDiscount();
        $idlang = $this->utility->getLanguage();

        $params = array(
            'cdarti' => $barcod->cdarti,
            'taglia' => $barcod->taglia,
            'cdcata' => $common['selected_catalog']->cdcata,
            'nulist' => $common['order_info']->nulist,
            'id_usr' => $id_usr,
        );

        $sumWhere = '';
        $avaWhere = '';
        $qtyWhere = '';
        $artcolJn = '';
        $cdcolo_fd = 'a.cdcolo AS cdcolo';
        $regqta_jn = '';
        $where = '';
        if ($barcod->cdcolo != '') {
            $params['cdcolo'] = $barcod->cdcolo;
            $sumWhere = " AND oc.cdcolo = dc.cdcolo AND oc.cdvari = '' ";
            $avaWhere = " AND dc.cdcolo = ac.cdcolo AND dc.cdvari = '' ";
            $qtyWhere = " AND oc.cdcolo = ac.cdcolo AND oc.cdvari = '' ";
            $artcolJn = ' INNER JOIN Go2B\Models\Artcol ac ON ac.cdarti = a.cdarti ';
            $cdcolo_fd = 'ac.cdcolo AS cdcolo';
            $regqta_jn = 'AND r.cdcolo = ac.cdcolo';
            $where = 'AND ac.cdcolo = :cdcolo:';
        }

        $dsarti_fd = 'a.dsarti AS dsarti';
        $sconto_fd = '0 AS cust_disc';
        $dsarti_jn = $sconto_jn = '';
        $prezzo_fd = "COALESCE(IF(l.taglia > '', '-1', MAX(l.prezzo)), 0) as prezzo, ";

        if ($idlang != 'IT') {
            $dsarti_fd = 'COALESCE(d1.descri,a.dsarti) AS dsarti';
            $dsarti_jn = "LEFT JOIN Go2B\Models\Deslin d1 ON d1.tpdato = 'dsarti' AND d1.codic1 = a.cdarti AND d1.idlang = :idlang: ";
            $params['idlang'] = $idlang;
        }
        if ($numdis > 0) {
            $sconto_fd = 'COALESCE(c6.sconto,0) AS cust_disc';
            $sconto_jn = 'LEFT JOIN Go2B\Models\B2bDisbdy c6 ON c6.cdarti = a.cdarti AND c6.numdis = :numdis: ';
            $params['numdis'] = $numdis;
        }

        $ava = '';
        if ($common['order_info']->tpordc == 0) {
            $sumQty = "COALESCE(
        (SELECT SUM(og.quanti)
        FROM Go2B\Models\Octagl og
        INNER JOIN Go2B\Models\Occorp oc ON oc.nurorc = og.nurorc
        INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
        WHERE oc.cdarti = dc.cdarti $sumWhere AND ot.flstat = 2 AND og.dstagl = dc.taglia),
        0)";

            $ava = ", MAX(
        COALESCE(
          (SELECT MAX(dc.quanti - ($sumQty)) AS quanti FROM Go2B\Models\Dscorp dc WHERE dc.cdarti = a.cdarti $avaWhere AND dc.taglia = p.taglia),
          0)
        ) AS availability ";
        }

        $phql = "SELECT p.taglia, a.cdartn, a.cdarti, $dsarti_fd, a.cdpers, $cdcolo_fd, a.dscolo, a.flimag, t.tppers,
      a.flbloc AS a_flbloc, t.flbloc AS t_flbloc, COALESCE(r.qtamin, 1) AS qtamin, COALESCE(r.qtamul, 1) AS qtamul,
      COALESCE(r.qtamax, 0) AS qtamax,
      (SELECT og.quanti
        FROM Go2B\Models\Octagl og
        INNER JOIN Go2B\Models\Occorp oc ON og.nurorc = oc.nurorc
        INNER JOIN Go2B\Models\Octest ot ON ot.nuordc = oc.nuordc
        WHERE a.cdarti = oc.cdarti $qtyWhere AND p.taglia = og.dstagl AND ot.id_usr = :id_usr: AND ot.flstat = 0) AS qty,
      $prezzo_fd $sconto_fd $ava
      FROM Go2B\Models\Anaart a
      $artcolJn
      INNER JOIN Go2B\Models\Ctarti c ON c.cdarti = a.cdarti
      INNER JOIN Go2B\Models\Tipolo t ON a.cdartn = t.cdartn
      INNER JOIN Go2B\Models\Postgl p ON t.cdtagl = p.cdtagl
      LEFT JOIN Go2B\Models\Regqta r ON r.cdarti = a.cdarti $regqta_jn AND r.taglia = p.taglia
      LEFT JOIN Go2B\Models\Lscorp l ON a.cdarti = l.cdarti AND l.nulist = :nulist:
      $sconto_jn
      $dsarti_jn
      WHERE p.taglia = :taglia: AND a.cdarti = :cdarti: $where AND c.cdcata = :cdcata: ";
        $row = $this->modelsManager->executeQuery($phql, $params);

        if ($row != null && $row[0]->taglia != null) {
            // Img

            $imgurl = $this->utility->getImageModelLink($row[0]->flimag);
            $exist = $row[0]->flimag != '' && file_exists('img/model/' . $row[0]->flimag);
            $imgurl = !$exist ? $this->config->application->baseUri . 'assets/img/default_model.jpg' : $imgurl;
            $ordCls = $common['order_info']->tpordc == 0 ? 'ava-' : 'rel-';

            // Prc, dsc, net
            $price = $this->utility->getFormattedPrice($common['order_info']->nulist, $row[0]->prezzo);
            $cust_disc = $row[0]->cust_disc != 0 ? $row[0]->cust_disc . ' %' : '';
            $real_price = $this->utility->getFormattedPrice($common['order_info']->nulist, $row[0]->prezzo * (1 - $row[0]->cust_disc / 100));

            // Qty
            $inp_cls = $common['order_info']->tpordc == 0 && $row[0]->qty > $row[0]->availability ? 'over-max' : '';
            if ($common['order_info']->tpordc == 0 && $row[0]->availability == 0) {
                $qty = "<span class='blocked'>" . $this->translate('_common.notavailable') . "</span>";
            } else if ($row[0]->a_flbloc > 0 || $row[0]->t_flbloc > 0) {
                $qty = "<span class='blocked'>" . $this->translate('quantity.blocked') . "</span>";
            } else {
                if ($row[0]->qty > 0) {
                    $minus_cls = 'enabled';
                } else {
                    $minus_cls = 'disabled';
                }

                if (!$common['order_info']->tpordc == 0 ||
                    ($row[0]->qty < $row[0]->availability &&
                        $row[0]->qtamin <= $row[0]->availability &&
                        $row[0]->qty + $row[0]->qtamul <= $row[0]->availability)
                ) {
                    $plus_cls = 'enabled';
                } else {
                    $plus_cls = 'disabled';
                }

                if ($minus_cls == 'disabled' && $plus_cls == 'disabled') {
                    $inp_cls .= ' disabled';
                }

                $qty =
                    "<div class='btn-number minus-qty $minus_cls ' data-type='minus'>
          <i class='fa fa-minus' aria-hidden='true'></i>
        </div>
        <div class='float-left w-40'>
          <input type='text' class='input-number $inp_cls '
            data-old_value='" . ($row[0]->qty > 0 ? $row[0]->qty : "") . "'
            value='" . ($row[0]->qty > 0 ? $row[0]->qty : '') . "'
            min='0' " .
                    ($common['order_info']->tpordc == 0 ? "max='" . $row[0]->availability . "'" : '') . ">
        </div>
        <div class='btn-number plus-qty $plus_cls ' data-type='plus'>
          <i class='fa fa-plus' aria-hidden='true'></i>
        </div>";
            }

            $html =
                '<div class="row row-barcode-list" id="brcd-' . $barcod->nubrcd . '"
        data-qty="' . $row[0]->qty . '" data-cdarti="' . $row[0]->cdarti . '" data-taglia="' . $row[0]->taglia . '"
        data-cdcolo="' . $row[0]->cdcolo . '" data-prc="' . $price['value_raw'] . '" data-dis="' . $row[0]->cust_disc . '">
        <div class="brcd-lst-' . $ordCls . 'img">
          <img src="' . $this->config->application->baseUri . $imgurl . '"/>
        </div>
        <div class="brcd-lst-' . $ordCls . 'num">' . $index . '</div>
        <div class="brcd-lst-' . $ordCls . 'cod">' . $row[0]->cdarti . '</div>
        <div class="brcd-lst-' . $ordCls . 'dsc">' . $row[0]->dsarti . '</div>
        <div class="brcd-lst-' . $ordCls . 'col">' . ($row[0]->tppers != 'PT' ? $row[0]->dscolo : $row[0]->cdcolo) . '</div>
        <div class="brcd-lst-' . $ordCls . 'siz">' . $row[0]->taglia . '</div>
        <div class="brcd-lst-' . $ordCls . 'ava">' . $row[0]->availability . '</div>
        <div class="brcd-lst-' . $ordCls . 'prc">' . $price['value'] . '</div>
        <div class="brcd-lst-' . $ordCls . 'dis">' . $cust_disc . '</div>
        <div class="brcd-lst-' . $ordCls . 'net">' . $real_price['value'] . '</div>
        <div class="brcd-lst-' . $ordCls . 'qty" data-qtamin="' . $row[0]->qtamin . '" data-qtamul="' . $row[0]->qtamul . '"
          data-disp="' . ($common['order_info']->tpordc == 0 ? $row[0]->availability : '-1') . '">' . $qty . '</div>
      </div>';
        }

        return $html;
    }
    //endregion

    //region Utility functions
    private function changeCatalog($cdcata)
    {
        $this->filters->resetFilters();
        $this->session->set('cdcata', $cdcata);
    }

    private function handleCurrentSelection($cdcata, $cdtitl, $cdlinm, $cdserm, &$current, &$filters)
    {
        if ($cdserm != '') {
            // Set current selection
            $current = array(
                'type' => 'sermod',
                'titlin' => Titlin::findFirstByCdtitl($cdtitl),
                'linmod' => Linmod::findFirstByCdlinm($cdlinm),
                'sermod' => Sermod::findFirst(array('cdlinm = :cdlinm: AND cdserm = :cdserm:', 'bind' => array('cdlinm' => $cdlinm, 'cdserm' => $cdserm))),
            );

            $this->session->set('ctg_view_type', 'sermod');
            $this->session->set('ctg_seri', $current['sermod']);
            $this->session->set('ctg_line', $current['linmod']);
            $this->session->set('ctg_brnd', $current['titlin']);

            // Get filters for selected cdlinm
            $filters = $this->filters->getFiltersFromSeries($cdcata, $cdlinm, $cdserm, $this->session->get('language'));
        } else if ($cdlinm != '') {
            // Set current selection
            $current = array(
                'type' => 'linmod',
                'titlin' => Titlin::findFirstByCdtitl($cdtitl),
                'linmod' => Linmod::findFirstByCdlinm($cdlinm),
            );

            $this->session->set('ctg_view_type', 'linmod');
            $this->session->set('ctg_seri', '');
            $this->session->set('ctg_line', $current['linmod']);
            $this->session->set('ctg_brnd', $current['titlin']);

            // Get filters for selected cdlinm
            $filters = $this->filters->getFiltersFromLine($cdcata, $cdlinm, $this->session->get('language'));
        } else if ($cdtitl != '') {
            // Set current selection
            $current = array(
                'type' => 'titlin',
                'titlin' => Titlin::findFirstByCdtitl($cdtitl),
            );

            $this->session->set('ctg_view_type', 'titlin');
            $this->session->set('ctg_seri', '');
            $this->session->set('ctg_line', '');
            $this->session->set('ctg_brnd', $current['titlin']);

            // Get filters for selected cdlinm + cdtitl
            $filters = $this->filters->getFiltersFromBrand($cdcata, $cdtitl, $this->session->get('language'));
        } else {
            // Set current selection
            $current = array('type' => 'all');

            $this->session->set('ctg_view_type', 'all');
            $this->session->set('ctg_seri', '');
            $this->session->set('ctg_line', '');
            $this->session->set('ctg_brnd', '');

            // Get all filters
            $filters = $this->filters->getFilters($cdcata, $this->session->get('language'));
        }
    }

    private function handleCurrentSelectionForFabric($cdcata, $cdpers, &$current, &$filters)
    {
        // Set current selection
        $current = array('type' => 'all');

        $this->session->set('ctg_view_type', 'all');
        $this->session->set('ctg_seri', '');
        $this->session->set('ctg_line', '');
        $this->session->set('ctg_brnd', '');

        // Get all filters
        $filters = $this->filters->getFiltersForFabric($cdcata, $cdpers, $this->session->get('language'));
    }

    private function showOnlyTag($flt)
    {
        if (isset($flt['apply'])) {
            foreach ($flt['apply'] as $key => $value) {
                if ($value['type'] == 1 && isset($value['filter']) && count($value['filter']) > 0) {
                    return true;
                }
            }
        }

        return false;
    }

    //endregion

    private function getFullProduct($cdcata, $code, $nulist, $isModel, $idlang = 'IT', $isCompact = false)
    {
        $numdis = $this->utility->getCustomDiscount();

        if ($isModel) {
            $product = Tipolo::getCompleteModel($code, $cdcata, $numdis, $idlang);

            if (count($product) == 1) {
                $fullProduct = $product[0];

                $auth = $this->session->get('auth');
                $isOrder = Octest::findOrderInProgress($auth['id']) != null;
                $order = $isOrder ? Octest::getCurrentOrder($auth['id']) : null;
                $articles = $this->getAllAnaartFromTipolo($fullProduct->cdartn, $cdcata, $idlang, $nulist, $numdis, $fullProduct->tppers, $order);

                //var_dump($articles);
                // die();

                /*
                $fullArticles = array();
                if (count($articles) > 0) {
                foreach ($articles as $article) {
                $currentArticle = $article;
                $currentArticle->imgart = Imgart::getAllImagesFromArticle($article->cdarti);
                $fullArticles[] = $currentArticle;
                }
                }
                $fullProduct->tags   = Artcla::getTagsForModel($fullProduct->cdartn);
                $fullProduct->anaart = $fullArticles;
                $fullProduct->imgart = Imgart::getAllImagesFromModel($fullProduct->cdartn); */

                return $articles;
            }
        } /* else {
    $product = Anaart::getCompleteArticle($code, $cdcata, $nulist, $numdis, $idlang, $isCompact);
    if (count($product) >= 1) {
    $auth    = $this->session->get('auth');
    $isOrder = Octest::findOrderInProgress($auth['id']) != null;
    if ($isOrder) {
    $order = Octest::getCurrentOrder($auth['id']);
    }

    $fullProduct = $product[0];
    $fullColors = array();
    $items = array(
    'modelDetailStyle' => $this->utility->getAppSettings('ModelDetailStyle'),
    'colorAssignmentSource' => $this->utility->getAppSettings('ColorAssignmentSource'),
    'nuordc' => $isOrder ? $order->nuordc : -1,
    'cdarti' => $fullProduct->cdarti,
    );
    if ($isOrder) {
    $colors = Artcol::getColorsForOrderArticleDetail($items);
    } else {
    $colors = Artcol::getColorsForArticleDetail($items);
    }
    if (count($colors) > 0) {
    foreach ($colors as $color) {
    $currentColor = $color;
    $currentColor['imgart'] = Imgart::getAllImagesFromColor($code, $color['cdcolo']);
    $fabricColorImage = Imgart::getFabricColorImage($fullProduct->cdpers, $color['cdcolo']);
    $fabricColorImage = count($fabricColorImage) > 0 ? $fabricColorImage[0]->flimag : '';
    $currentColor['fabricColorImage'] = $fabricColorImage;
    $fullColors[] = $currentColor;
    }
    }
    $fullProduct->colors = $fullColors;
    $fullProduct->imgart = Imgart::getAllImagesFromArticle($fullProduct->cdarti);
    return $fullProduct;
    }
    }

    return ''; */
    }

    private function getAllAnaartFromTipolo($cdartn, $cdcata, $idlang, $nulist, $numdis, $tppers = '', $order = null)
    {
        $items = array(
            'cdcata' => $cdcata,
            'cdartn' => $cdartn,
            'nulist' => $nulist,
            'idlang' => $idlang,
            'id_usr' => $this->session->get('auth')['id'],
            'numdis' => $numdis,
            'modelDetailStyle' => $this->utility->getAppSettings('ModelDetailStyle'),
            'colorAssignmentSource' => $this->utility->getAppSettings('ColorAssignmentSource'),
        );

        if ($items['modelDetailStyle'] != 2 || $order == null || $order->tpordc == 1) {
            $anaart = Anaart::getAllArticlesForModelDetail($items);
        } else {
            $anaart = Anaart::getAllAvailabileArticlesForModelDetailStyle2($items);
        }

        $showNotAvailable = $this->utility->getAppSettings('ParamShowNotAvailableItems') == 1;

        $full_anaart = array();
        for ($i = 0; $i < count($anaart); $i++) {
            $curr_anaart = $anaart[$i];

            // If tissue, check variants (backstitches)
            if ($tppers == 'PT') {
                $curr_anaart->colors = '';

                if ($order != null > 0) {
                    if ($order->tpordc == 0) {
                        $colors = Artcol::getAvailableColorsFromArticleAndOrder($curr_anaart->cdarti, $order->nuordc);
                    } else {
                        $colors = Artcol::getColorsFromArticleAndOrder($curr_anaart->cdarti, $order->nuordc);
                    }
                } else {
                    $colors = Artcol::getColorsFromArticle($curr_anaart->cdarti);
                }

                $curr_anaart->writeAttribute('colors', $colors);
            }

            // If order, check for availability
            if ($order != null && $order->tpordc == 0) {
                $curr_anaart->is_available = '';
                if ($tppers == 'PT') {
                    $curr_anaart->writeAttribute('is_available', 'false');
                    for ($j = 0; $j < count($curr_anaart->colors); $j++) {
                        if ($curr_anaart->colors[$j]['is_available'] > 0) {
                            $curr_anaart->writeAttribute('is_available', 'true');
                        } else if ($showNotAvailable) {
                            $curr_anaart->writeAttribute('is_available', $curr_anaart->colors[$j]['is_available'] > 0 ? 'true' : 'false');
                        } else {
                            unset($curr_anaart->colors[$j]);
                        }
                    }
                    $curr_anaart->colors = array_values($curr_anaart->colors);
                } else {
                    $curr_anaart->writeAttribute('is_available', $this->utility->isArticleAvailable($curr_anaart->cdarti));
                }

                if ($curr_anaart->is_available == 'true' || $showNotAvailable) {
                    $full_anaart[] = $curr_anaart;
                }
            } else {
                $full_anaart[] = $curr_anaart;
            }
        }

        return $full_anaart;
    }

    public function classificationAction()
    {
        // Questo va fatto prima di recuperare $common
        $this->session->set('ctl_view_mode', 'classification');

        // Redirect if there are not catalogs available
        $id_usr = $this->session->get('auth')['id'];
        $common = $this->utility->getCommonData('catalog', $id_usr);
        if (count($common['classifications']) == 0) {
            return $this->response->redirect('catalog/index');
        }

        $pathSlugs = $this->dispatcher->getParams();
        $idlang = $this->utility->getLanguage();

        $products = null;
        $subTree = [];
        $isRoot = false;
        $isLeaf = false;
        if (!empty($pathSlugs)) {
            $firstClassification = B2bClassificazione::findFirstBySlug(reset($pathSlugs));
            if (count($pathSlugs) > 0) {
                $lastClassification = B2bClassificazione::findFirstBySlug(end($pathSlugs));
            } else {
                $lastClassification = $firstClassification;
            }
        } else {
            $firstClassification = B2bClassificazione::fakeRootClassification();
            $lastClassification = $firstClassification;
            $isRoot = true;
        }

        if ($firstClassification instanceof B2bClassificazione && $lastClassification instanceof B2bClassificazione) {
            $cdcata = $common['selected_catalog']->cdcata;
            $nulist = $common['isOrder'] ? $common['order_info']->nulist : $this->utility->getDefaultNulist($id_usr);

            $subTree = B2bClassificazione::getAvailableTree($lastClassification->id);
            $isLeaf = empty($subTree);

//            if ($common['catalogProductType'] == 0) {
//                $products = $lastClassification->getModels($cdcata, $nulist, $idlang);
//            } else {
//                $products = $lastClassification->getArticles($cdcata, $nulist, $idlang);
//            }
        } else {
            // Errore
            $this->response->redirect('catalog/index')->send();
            exit();
        }

        // Handle selection with params (if present)
        $cdtitl = urldecode($this->dispatcher->getParam('cdtitl'));
        $cdlinm = urldecode($this->dispatcher->getParam('cdlinm'));
        $cdserm = urldecode($this->dispatcher->getParam('cdserm'));
        $cdcata = $common['selected_catalog']->cdcata;

        $baseFilters = $this->filters->getApplyFilters();

        if ($lastClassification instanceof B2bClassificazione) {
            $baseFilters['b2bcla'] = array(
                'name' => 'b2bcla',
                'context' => 'CF',
                'type' => 0,
                'custom' => 1,
                'filter' => [$lastClassification->id],
            );
            $this->session->set('filters', $baseFilters);
        }

        $filters = array();
        $current = array();
        $this->handleCurrentSelection($cdcata, $cdtitl, $cdlinm, $cdserm, $current, $filters);
        $flt = $this->filters->getFilterSubQuery();

        $common['customer_discount'] = 0;
        if ($common['isOrder'] && $this->utility->getAppSettings('ShowBaseCustomerDiscount') == 1) {
            $customer = Anagra::findCustomerByKey($common['order_info']->tpanag, $common['order_info']->cdanag);
            if ($customer instanceof Anagra) {
                $common['customer_discount'] = $customer->scont1;
            }
        }

        $products = $this->getAllProductsFromSearch($cdcata, '', $nulist, $flt, $common, $idlang);

        $this->view->cdtitl = $cdtitl;
        $this->view->cdlinm = $cdlinm;
        $this->view->apply = $baseFilters;
        $this->view->current = $current;
        $this->view->filters = $filters;

//        var_dump($this->view->apply, $this->view->filters);
//        exit();

        $this->view->baseDiscount = $common['customer_discount'];
        $this->view->isShowFilterLeftSide = ($this->utility->getAppSettings('ShowFilterLeftSide') == 1) ? true : false;
        $this->view->common = $common;
        $this->view->isRoot = $isRoot;
        $this->view->isLeaf = $isLeaf;
        $this->view->subTree = $subTree;
        $this->view->rootElm = $firstClassification;
        $this->view->currentElm = $lastClassification;
        $this->view->products = $products;
    }

}
