<?php

namespace Go2B\Controllers;

use Go2B\Models\Ageana;
use Go2B\Models\Anaage;
use Go2B\Models\Anaart;
use Go2B\Models\Anagra;
use Go2B\Models\Anareg;
use Go2B\Models\Ascorp;
use Go2B\Models\B2bAddinf;
use Go2B\Models\B2bCoupon;
use Go2B\Models\B2bCtlcpn;
use Go2B\Models\B2bCuspag;
use Go2B\Models\B2bCuspor;
use Go2B\Models\B2bOrdadd;
use Go2B\Models\B2bOrdema;
use Go2B\Models\B2bSysusr;
use Go2B\Models\B2bUsrana;
use Go2B\Models\B2bUsrcpn;
use Go2B\Models\Cttest;
use Go2B\Models\Desmer;
use Go2B\Models\Indorc;
use Go2B\Models\Lscorp;
use Go2B\Models\Lstest;
use Go2B\Models\Noccom;
use Go2B\Models\Ocasso;
use Go2B\Models\Occorp;
use Go2B\Models\Ocperc;
use Go2B\Models\Ocpert;
use Go2B\Models\Ocproc;
use Go2B\Models\Ocprot;
use Go2B\Models\Octagl;
use Go2B\Models\Octest;
use Go2B\Models\Postgl;
use Go2B\Models\Pvcorp;
use Go2B\Models\Pvtest;
use Go2B\Models\Regqta;
use Go2B\Models\Scacon;
use Go2B\Models\Smcorp;
use Go2B\Models\Sparti;
use Go2B\Models\Spmate;
use Go2B\Models\Tabvar;
use Go2B\Models\Tipolo;
use Go2B\Models\Tppaga;
use Go2B\Models\Tpport;
use PayPal\Api\Amount;
use PayPal\Api\Item;
use PayPal\Api\ItemList;
use PayPal\Api\Payee;
use PayPal\Api\Payer;
use PayPal\Api\Payment;
use PayPal\Api\PaymentExecution;
use PayPal\Api\RedirectUrls;
use PayPal\Api\Transaction;
use PayPal\Auth\OAuthTokenCredential;
use PayPal\Rest\ApiContext;
use Phalcon\Http\Request;

/**
 * @property-read Utility $utility
 */
class CartController extends ControllerBase
{
    //region Initialize
    public function initialize()
    {
        parent::initialize();
        $this->tag->setTitle($this->translate('_common.title.cart'));
    }
    //endregion

    //region Views functions
    public function indexAction()
    {
        $auth = $this->session->get('auth');
        $common = $this->utility->getCommonData('cart', $auth['id']);
        $nuordc = $this->dispatcher->getParam('nuordc', 'int', -1);
        $idlang = $this->utility->getLanguage();

        $showAssortmens = $this->utility->getAppUtils("showAssortments");

        if ($common['isOrder']) {
            $nulist = $common['order_info']->nulist;
            $reloadOrderInfo = false;

            // Get promo rows
            if ($common['coupon_promo'] == 2) {
                $this->utility->verifyPromos($common['order_info']->nuordc);
                $ocprot = Pvtest::getPromoFromOrder($common['order_info']->nuordc);
            }

            // Get Stripe propertiers
            //$publishable_key = $this->utility->getAppUtils("stripe_publishable_key");
            //$secret_key = $this->utility->getAppUtils("stripe_secret_key");

            $secret_key = $this->utility->getAppUtils('secret_key');
            if ($this->utility->getAppUtils('secret_key') == '') {
                $secret_key = "sk_test_cbpoap7MHEHg0XAw5XwBb9I6";
            }

            $publishable_key = $this->utility->getAppUtils('publishable_key');
            if ($this->utility->getAppUtils('publishable_key') == '') {
                $publishable_key = "pk_test_Ti7gpwcMLheGEnVbmOZ9r5CS";
            }

            $stripe_available = false;
            if ($common['paypal'] && $secret_key != '' && $publishable_key != '') {
                // connect
                //define("CLIENT_ID", $client_id); // Your client ID: https://dashboard.stripe.com/account/applications/settings
                //define("SECRET_KEY", $secret_key); // Your secret API KEY: https://dashboard.stripe.com/account/apikeys
                //define("REDIRECT_URL", "http://localhost/newb2b/cart/stripepay"); // https://dashboard.stripe.com/account/applications/settings
                //\Stripe\Stripe::setApiKey(SECRET_KEY);

                // checkout
                $stripe = array(
                    'secret_key' => $secret_key,
                    'publishable_key' => $publishable_key
                );

                \Stripe\Stripe::setApiKey($stripe['secret_key']);
                $stripe_available = true;
            }

            // Get custom payments
            $anagra = Anagra::findCustomerByKey($common['order_info']->tpanag, $common['order_info']->cdanag);
            $cdnazi = $anagra->cdnazi;

            if ($common['order_info']->cddesm != null) {
                $desmer = Desmer::findFirst(
                    array(
                        'tpanag = :tpanag: AND cddesm = :cddesm: AND cdanag = :cdanag:',
                        'bind' => array('tpanag' => $anagra->tpanag, 'cddesm' => $common['order_info']->cddesm, 'cdanag' => $anagra->cdanag)
                    )
                );

                if ($desmer) {
                    $cdnazi = $desmer->cdnazi;
                }
            }

            // Payments
            $payments = array();
            switch ($common['paymentCondition']) {
                case 0:
                    $payments = Tppaga::getPaymentsForCustomer($common['order_info']->tpanag, $common['order_info']->cdanag, $idlang);
                    break;
                case 1:
                    $payments = B2bCuspag::getCustomPaymentsForCountry($cdnazi);
                    if ($anagra instanceof Anagra && !empty($anagra->tppaga)) {
                        if (in_array($anagra->tppaga, array_unique(array_column($payments, 'tppaga')))) {
                            $payments = array_values(array_filter($payments, function ($p) use ($anagra) {
                                return $p["tppaga"] == $anagra->tppaga;
                            }));
                        }
                    }
                    break;
                case 2:
                case 4:
                    $payments = Tppaga::getAllPaymentsForCustomer($common['order_info']->tpanag, $common['order_info']->cdanag, $cdnazi, $idlang);
                    break;
                case 3:
                    $payments = Tppaga::getAllChoosablePaymentsForCustomer($common['order_info']->tpanag, $common['order_info']->cdanag, $idlang);
                    break;
            }

            $allAvailablePaymentsCode = array_unique(array_column($payments, 'tppaga'));

            if (
                count($allAvailablePaymentsCode) > 0 &&
                (
                    (count($allAvailablePaymentsCode) == 1 && empty($common['order_info']->tppaga)) ||
                    (!empty($common['order_info']->tppaga) && !in_array($common['order_info']->tppaga, $allAvailablePaymentsCode))
                )
            ) {
                $newTppaga = current($allAvailablePaymentsCode);
                Octest::updateTppaga($common['order_info']->nuordc, $newTppaga);
                $common['order_info']->tppaga = $newTppaga;
                //            $reloadOrderInfo = true;
            }

            // Shippings
            $shipments = array();
            switch ($common['shippingCondition']) {
                case 0:
                    $shipments = Tpport::getShipmentsForCustomer($common['order_info']->tpanag, $common['order_info']->cdanag, $idlang);
                    break;
                case 1:
                    $shipments = B2bCuspor::getCustomShipmentsForCountry($cdnazi);
                    if ($anagra instanceof Anagra && !empty($anagra->tpport)) {
                        if (in_array($anagra->tpport, array_unique(array_column($shipments, 'tpport')))) {
                            $shipments = array_values(array_filter($shipments, function ($s) use ($anagra) {
                                return $s["tpport"] == $anagra->tpport;
                            }));
                        }
                    }
                    break;
                case 2:
                case 4:
                    $shipments = Tpport::getAllShipmentsForCustomer($common['order_info']->tpanag, $common['order_info']->cdanag, $cdnazi, $idlang);
                    break;
                case 3:
                    $shipments = Tpport::getAllChoosableShipmentsForCustomer($common['order_info']->tpanag, $common['order_info']->cdanag, $idlang);
                    break;
            }

            $allAvailableShipmentsCode = array_unique(array_column($shipments, 'tpport'));
            if (
                count($allAvailableShipmentsCode) > 0 &&
                (
                    (count($allAvailableShipmentsCode) == 1 && empty($common['order_info']->tpport)) ||
                    (!empty($common['order_info']->tpport) && !in_array($common['order_info']->tpport, $allAvailableShipmentsCode))
                )
            ) {
                $newTpport = current($allAvailableShipmentsCode);
                Octest::updateTpport($common['order_info']->nuordc, $newTpport);
                $common['order_info']->tpport = $newTpport;
                //            $reloadOrderInfo = true;
            }

            //        if ($reloadOrderInfo) {
            //            $common['order_info'] = Octest::getCurrentOrder($auth['id']);
            //        }

            // We need to recalculate all row discounts if customer and/or at least one row have discounts
            $numdis = $this->utility->getCustomDiscount($common['order_info']);
            $hasdis = Octagl::hasCartSizeQuantityDiscount($auth['id']);

            if ($numdis > 0 && $hasdis) {
                $this->calculateRowDiscounts($auth['id'], $numdis);
            }

            // Get order rows
            $fullArticles = $this->getCartArticles($auth['id'], $common['order_info']->cdcata, $nulist, $common['order_info']->tpordc == 0, $common['order_info'], $idlang);

            if ($common['shippingsOnRows'] == 1) {
                $this->view->rowsShippings = Desmer::getShippingsAddressForCustomer($common['order_info']->tpanag, $common['order_info']->cdanag);
            }

            $isSendable = $common['checkOrderPrices'] == 1 ? Occorp::hasPriceForEveryRow($common['order_info']->nuordc) : true;
            $orderLimitMode = $common['cart_limit_mode'];

            // Send button
            if ($isSendable && $orderLimitMode > 0) {
                $orderLimitMinValue = $common['cart_limit_min_value'];
                if ($orderLimitMode == 1) {
                    $totArticoli = Octest::countArticlesInOrder($common['order_info']->nuordc);
                    if ($totArticoli < $orderLimitMinValue) {
                        $isSendable = false;
                    }
                } else if ($orderLimitMode == 2) {
                    $totSpesa = Octest::retriveSpendInOrder($common['order_info']->nuordc);
                    if ($totSpesa < $orderLimitMinValue) {
                        $isSendable = false;
                    }
                }
            }
            $this->view->isSendable = $isSendable;

            $this->view->stripe = $stripe_available;
            $this->view->pub_key = $publishable_key;
        } else if ($nuordc > 0) {

            $common['order_info'] = Octest::getOrderFromNuordc($nuordc);

            // Get promo rows
            if ($common['coupon_promo'] == 2) {
                $ocprot = Pvtest::getPromoFromOrder($nuordc);
            }

            // We need to recalculate all row discounts if customer and/or at least one row have discounts
            $numdis = $this->utility->getCustomDiscount();
            $hasdis = Octagl::hasSizeQuantityDiscount($nuordc);
            if ($numdis > 0 && $hasdis) {
                $this->utility->calculateRowDiscountsSummary($nuordc, $numdis);
            }

            // Payments
            $payments = Octest::getPaymentOrderInfo($nuordc, $idlang);

            // Shippings
            $shipments = Octest::getShipmentOrderInfo($nuordc, $idlang);

            // Get order rows
            $fullArticles = $this->getSummaryArticles($nuordc, $common['order_info']->cdcata, $common['order_info']->nulist, $common['order_info'], $idlang);

            $lstest = Lstest::findFirstByNulist($common['order_info']->nulist);
            $common['currency'] = $this->utility->getCurrencySymbol($lstest->cdvalu);
        } else {
            if ($this->utility->getAppSettings('StartingHomePage') == 0) {
                return $this->response->redirect('catalog/index');
            } else {
                return $this->response->redirect('catalog/collection');
            }
        }

        if ($common['cartMode'] == 1) {
            $this->view->summary = $this->utility->getLinesSummary($fullArticles);
        } else if ($common['cartMode'] == 2) {
            $this->view->summary = $this->utility->getModelTypesSummary($fullArticles);
        }

        $this->view->customPaymentMethod = $this->utility->getAppSettings('CustomPayment');
        $this->view->customShippingMethod = $this->utility->getAppSettings('CustomShipping');
        $this->view->common = $common;
        $this->view->nuordc = $nuordc;
        $this->view->articles = $fullArticles;
        $this->view->payments = $payments;
        $this->view->shipments = $shipments;
        $this->view->promos = $common['coupon_promo'] == 2 ? $ocprot : array();
        $this->view->showAssortments = $showAssortmens;
    }

    private function calculateRowDiscounts($id_usr, $numdis)
    {
        $octagl = Octagl::getSizeQuantityDiscounts($id_usr, $numdis);
        for ($i = 0; $i < count($octagl); $i++) {
            Octagl::updateSizeQuantityDiscount($octagl[$i]->nurorc, $octagl[$i]->dstagl, $octagl[$i]->cust_sconto);
        }
    }
    //endregion

    //region Ajax functions

    private function getCartArticles($id_usr, $cdcata, $nulist, $is_availability, $order_info, $idlang = 'IT')
    {
        $ordering = $this->utility->getAppSettings('ParamTypeOrdering');
        $dtsubt = $this->utility->getAppSettings('ParamAvailabilityDateManagement');
        $hasConfigurator = $this->utility->getAppSettings('ModelDetailStyle') == 5;

        $articles = Occorp::getCartOrderRows($id_usr, $ordering, $idlang);

        if ($hasConfigurator) {
            $customArticles = Occorp::getCustomCartOrderRows($id_usr, $ordering, $idlang);
            $articles = array_merge($articles, $customArticles);
        }

        $fullArticles = array();
        for ($i = 0; $i < count($articles); $i++) {
            $currArticle = $articles[$i];

            // Add quantity for size
            $dateToCheck = '';
            if ($is_availability) {
                // LEOBRA MOD del 11/20/2023 problema ordini con data 0000-00-00 su msk
                //        $today       = date('Y-m-d');
                //        //$orderDtdisp = date('Y-m-d', strtotime(str_replace("/","-",$currArticle['dtmcli_raw']) . ' -' . $dtsubt . ' days'));
                //        $orderDtdisp = date('Y-m-d', strtotime(str_replace("/","-",$currArticle['dtmcli_raw'])));
                //        //$dateToCheck = $orderDtdisp > $today ? $orderDtdisp : $today;
                //        $dateToCheck = $orderDtdisp;
                if ($currArticle['dtmcli_raw'] == '0000-00-00') {
                    $dateToCheck = date('Y-m-d');
                } else {
                    $dateToCheck = date('Y-m-d', strtotime(str_replace("/", "-", $currArticle['dtmcli_raw'])));
                }
                $octagl = Octagl::getSizeQuantitiesForAvailabilityCart($currArticle['nurorc'], $currArticle['cdtagl'], $dateToCheck, $currArticle['tppers'] == 'PT');
            } else {
                $octagl = !$hasConfigurator || $currArticle['cdcolo'] != 'CUSTOM'
                    ? Octagl::getSizeQuantitiesForCart($currArticle['nurorc'], $currArticle['tppers'] == 'PT')
                    : Octagl::getSizeQuantitiesForCustomArticlesCart($currArticle['nurorc']);
            }

            if ($this->utility->getAppSettings('CartMode') != 1) {
                $full_octagl = array();
                for ($j = 0; $j < count($octagl); $j++) {
                    $curr_octagl = $octagl[$j];
                    $curr_octagl->flprom = '';
                    // Add flprom for size
                    $flprom = $this->getFlprom($currArticle['cdartn'], $currArticle['cdarti'], $curr_octagl['cdcolo'], $curr_octagl['taglia']);
                    $curr_octagl->writeAttribute('flprom', $flprom);
                    $full_octagl[] = $curr_octagl;
                }
                $currArticle['octagl'] = $full_octagl;

                // Add assortments
                $ocasso = $this->getCartAssortmentQtyForArticle($currArticle['nurorc'], $is_availability, $dateToCheck, $currArticle['cdtagl']);
                $currArticle['ocasso'] = $ocasso;
            } else {
                $currArticle['octagl'] = $octagl;
            }

            // Add retail price
            $currArticle['preven'] = Lscorp::getArticlePrices($currArticle['cdarti'], $nulist);

            // Add variants (Lardini)
            if ($this->utility->getAppSettings('ModelDetailStyle') == 2 && $currArticle['cdvari'] != '') {
                $variants = str_split($currArticle['cdvari']);
                $dsvari = '';
                foreach ($variants as $cdvari) {
                    $tabvar = Tabvar::getCustomFromCdvariAndCdcata($cdvari, $cdcata);
                    $dsvari .= $cdvari . ' - ' . $tabvar->dsvari . '<br/>';
                }
                $currArticle['dsvari'] = substr($dsvari, 0, -5);
            }

            // Add features (Zanotti)
            if ($this->utility->getAppSettings('ModelDetailStyle') == 3) {
                $currArticle['features'] = Sparti::getAllFeatures($currArticle['cdarti']);
            }

            // Add components (Rossetti)
            if ($hasConfigurator) {
                if ($currArticle['cdcolo'] == 'CUSTOM') {
                    $currArticle['components'] = Ocperc::getAllComponents($currArticle['cdarti']);
                } else {
                    $currArticle['components'] = $currArticle['cdarti'] == $currArticle['cdartn']
                        ? Spmate::getDefaultMaterialTypes($currArticle['cdarti'])
                        : Smcorp::getAllComponents($currArticle['cdarti']);
                }
            }

            // Add shipping if needed
            $currArticle['shipping'] = $this->utility->getAppSettings('ShippingsOnOrderRows') == 1 && $currArticle['cddesm'] != ''
                ? Desmer::getShippingForPdf($order_info->tpanag, $order_info->cdanag, $order_info->cddesm)
                : null;

            $fullArticles[] = $currArticle;
        }

        return $fullArticles;
    }

    private function getFlprom($cdartn, $cdarti, $cdcolo, $taglia)
    {
        $regqta = Regqta::getPromoFlagFromModelArticleAndColorAndSize($cdartn, $cdarti, $cdcolo, $taglia);
        if (count($regqta) > 0) {
            return $regqta[0]->flprom;
        }

        $regqta = Regqta::getPromoFlagFromModelArticleAndSize($cdartn, $cdarti, $taglia);
        if (count($regqta) > 0) {
            return $regqta[0]->flprom;
        }

        $regqta = Regqta::getPromoFlagFromModelArticleAndColor($cdartn, $cdarti, $cdcolo);
        if (count($regqta) > 0) {
            return $regqta[0]->flprom;
        }

        $regqta = Regqta::getPromoFlagFromModelArticle($cdartn, $cdarti);
        if (count($regqta) > 0) {
            return $regqta[0]->flprom;
        }

        return 0;
    }

    private function getCartAssortmentQtyForArticle($nurorc, $isAvailability, $dtmcli, $cdtagl)
    {
        $ocasso = $isAvailability
            ? Ocasso::getAssortmentQuantityWithAvailability($nurorc, $dtmcli)
            : Ocasso::getAssortmentQuantity($nurorc, false);

        $full_ocasso = [];
        foreach ($ocasso as $item) {
            $curr_ocasso = $item;
            $curr_ocasso->ascorp = '';

            $ascorp = Ascorp::getAssortmentDetail($curr_ocasso->cdasso, $cdtagl);
            $curr_ocasso->writeAttribute('ascorp', $ascorp);

            $full_ocasso[] = $curr_ocasso;
        }

        return $full_ocasso;
    }

    private function getSummaryArticles($nuordc, $cdcata, $nulist, $order, $idlang = 'IT')
    {
        $items = array(
            'ordering' => $this->utility->getAppSettings('ParamTypeOrdering'),
            'idlang' => $idlang,
            'nuordc' => $nuordc
        );
        $hasConfigurator = $this->utility->getAppSettings('ModelDetailStyle') == 5;

        $articles = Occorp::getOrderRowsForSummary($items);

        if ($hasConfigurator) {
            $customArticles = Occorp::getCustomSummaryOrderRows($items);
            $articles = array_merge($articles, $customArticles);
        }

        $fullArticles = array();
        for ($i = 0; $i < count($articles); $i++) {
            $currArticle = $articles[$i];

            // Get quantity per size
            $octagl = !$hasConfigurator || $currArticle['cdcolo'] != 'CUSTOM'
                ? Octagl::getSizeQuantitiesForCart($currArticle['nurorc'], $currArticle['tppers'] == 'PT')
                : Octagl::getSizeQuantitiesForCustomArticlesCart($currArticle['nurorc']);
            $full_octagl = array();
            for ($j = 0; $j < count($octagl); $j++) {
                $curr_octagl = $octagl[$j];
                if ($hasConfigurator) {
                    $curr_octagl->writeAttribute('flprom', 0);
                } else {
                    $curr_octagl->flprom = '';
                    // Add flprom to size
                    $flprom = $this->getFlprom($currArticle['cdartn'], $currArticle['cdarti'], $curr_octagl['cdcolo'], $curr_octagl['taglia']);
                    $curr_octagl->writeAttribute('flprom', $flprom);
                }
                $full_octagl[] = $curr_octagl;
            }
            $currArticle['octagl'] = $full_octagl;

            // Get assortments
            $ocasso = $this->getCartAssortmentQtyForArticle($currArticle['nurorc'], false, '', $currArticle['cdtagl']);
            $currArticle['ocasso'] = $ocasso;

            // Get retail price
            $currArticle['preven'] = Lscorp::getArticlePrices($currArticle['cdarti'], $nulist);

            // Get variants (Lardini)
            if ($this->utility->getAppSettings('ModelDetailStyle') == 2 && $currArticle['cdvari'] != '') {
                $variants = str_split($currArticle['cdvari']);
                $dsvari = '';
                foreach ($variants as $cdvari) {
                    $tabvar = Tabvar::getCustomFromCdvariAndCdcata($cdvari, $cdcata);
                    $dsvari .= $cdvari . ' - ' . $tabvar->dsvari . '<br/>';
                }
                $currArticle['dsvari'] = substr($dsvari, 0, -5);
            }

            // Add features (Zanotti)
            if ($this->utility->getAppSettings('ModelDetailStyle') == 3) {
                $currArticle['features'] = Sparti::getAllFeatures($currArticle['cdarti']);
            }

            // Add components (Rossetti)
            if ($hasConfigurator) {
                if ($currArticle['cdcolo'] == 'CUSTOM') {
                    $currArticle['components'] = Ocperc::getAllComponents($currArticle['cdarti']);
                } else {
                    $currArticle['components'] = $currArticle['cdarti'] == $currArticle['cdartn']
                        ? Spmate::getDefaultMaterialTypes($currArticle['cdarti'])
                        : Smcorp::getAllComponents($currArticle['cdarti']);
                }
            }

            // Add shipping if needed
            $currArticle['shipping'] = $this->utility->getAppSettings('ShippingsOnOrderRows') == 1 && $currArticle['cddesm'] != ''
                ? Desmer::getShippingForPdf($order->tpanag, $order->cdanag, $order->cddesm)
                : null;

            $fullArticles[] = $currArticle;
        }

        return $fullArticles;
    }

    public function downloadxlstemplateAction()
    {
        $this->view->cdcata = $_POST['cdcata'];
        $this->view->cdetic = $_POST['cdetic'];
        $this->view->tpanag = $_POST['tpanag'];
        $this->view->cdanag = $_POST['cdanag'];
        $this->view->cddesm = $_POST['cddesm'];
        $this->view->dtmcli = $_POST['dtmcli'];
        $this->view->common = $this->utility->getCommonData('cart', $this->session->get('auth')['id']);
    }

    public function createOrderAction()
    {
        $this->view->disable();

        $request = $this->request;
        if ($request->isPost() && $request->isAjax()) {
            $type = $_POST['type'];
            $cdtipord = $_POST['cdtipord'];
            $nuordc = $_POST['nuordc'];
            $cdcata = isset($_POST['cdcata']) ? $_POST['cdcata'] : '';
            $cdetic = $_POST['cdetic'];
            $nulist = $_POST['nulist'];
            $tpindo = isset($_POST['tpindo']) && $_POST['tpindo'] != '' && $_POST['tpindo'] != 'unassigned' ? $_POST['tpindo'] : null;
            $tpanag = $_POST['tpanag'];
            $cdanag = $_POST['cdanag'];
            $cddesm = $_POST['cddesm'];
            $dtmcli = $_POST['dtmcli'];
            $dtmcoi = $_POST['dtmcoi'];
            $dtmcof = $_POST['dtmcof'];
            $fldbrw = isset($_POST['fldbrw']) ? $_POST['fldbrw'] : null;

            $auth = $this->session->get('auth');
            if ($auth['type'] == B2bSysusr::TYPE_AGENT) {
                // TODO controlliamo che sia un cliente permesso??
            } else if ($auth['type'] == B2bSysusr::TYPE_CUSTOMER) {
                $pieces = explode('-', $auth['code']);
                $tpanag = $pieces[0];
                $cdanag = $pieces[1];
            }

            //if ($this->utility->getAppSettings('ExportOrderType') == 2 && $cttest->cdstag == 'LAST') {
            //  $cdstag = Cttest::findFirstBySeqrap(1)->cdstag;
            //} else {
            //}

            $this->logger->info('createOrderAction');
            $this->logger->info('cdcata: ' . print_r($cdcata, true));

            if ($nuordc > 0) {
                // duplicate order - copy order header
                $o_octest = Octest::findFirstByNuordc($nuordc);

                $cttest = Cttest::findFirstByCdcata($o_octest->cdcata);
                $cdstag = $cttest->cdstag;

                $items = array(
                    'id_usr' => $auth['id'],
                    'tpanag' => $tpanag,
                    'cdanag' => $cdanag,
                    'cddesm' => $cddesm != -1 ? $cddesm : NULL,
                    'cdcata' => $o_octest->cdcata,
                    'nulist' => $o_octest->nulist,
                    'tpordc' => 1, // we can duplicate only reservation orders
                    'tpindo' => $tpindo,
                    //'tppaga' => $o_octest->tppaga,
                    //'tpport' => $o_octest->tpport,
                    'cdetic' => $cdetic != -1 ? $cdetic : NULL,
                    'dtcrea' => date('Y-m-d'),
                    'dtmcli' => $dtmcli != '0000-00-00' ? $dtmcli : null,
                    'dtmcoi' => $dtmcoi != '0000-00-00' ? $dtmcoi : null,
                    'dtmcof' => $dtmcof != '0000-00-00' ? $dtmcof : null,
                    //'cdvett' => $o_octest->cdvett,
                    //'cdcoup' => $o_octest->cdcoup,
                    'cdstag' => $cdstag,
                    'cdtipord' => $cdtipord,
                );

                // Check if there is an order in progress, before creating a new one
                if (Octest::findOrderInProgress($auth['id']) == null) {
                    $result = Octest::insertNewOrder($items);

                    if ($result == false) {
                        echo json_encode('DT');
                    } else {
                        $this->utility->destroyCookie('recent-products');
                        $octest = Octest::findOrderInProgress($auth['id']);

                        if ($fldbrw != null) {
                            B2bAddinf::insertDoubleRowsFlagForOrder($octest->nuordc, $fldbrw);
                        }

                        // copy order rows
                        $o_occorp = Occorp::findByNuordc($o_octest->nuordc);

                        $all_fine_corp = true;
                        foreach ($o_occorp as $order_row) {
                            $n_occorp = new Occorp();
                            $n_occorp->nuordc = $octest->nuordc;
                            $n_occorp->seqrap = $order_row->seqrap;
                            $n_occorp->cdarti = $order_row->cdarti;
                            $n_occorp->cdcolo = $order_row->cdcolo;
                            $n_occorp->cdvari = $order_row->cdvari;
                            $n_occorp->cdcata = $order_row->cdcata;
                            $n_occorp->quanti = $order_row->quanti;
                            $n_occorp->seqdet = $order_row->seqdet;
                            $n_occorp->dtmcli = $order_row->dtmcli;
                            $n_occorp->sgrifc = $order_row->sgrifc;
                            $n_occorp->tpindo = $order_row->tpindo;
                            $n_occorp->indorc = $order_row->indorc;
                            $n_occorp->tpnoco = $order_row->tpnoco;
                            $n_occorp->dsnoco = $order_row->dsnoco;

                            if ($n_occorp->save() === false) {
                                $all_fine_corp = false;
                                break;
                            } else {
                                // copy rows quantity
                                $o_octagl = Octagl::findByNurorc($order_row->nurorc);

                                $all_fine_tagl = true;
                                foreach ($o_octagl as $order_size) {
                                    $n_octagl = new Octagl();
                                    $n_octagl->nurorc = $n_occorp->nurorc;
                                    $n_octagl->dstagl = $order_size->dstagl;
                                    $n_octagl->quanti = $order_size->quanti;
                                    $n_octagl->prezzo = $order_size->prezzo;
                                    $n_octagl->scont1 = $order_size->scont1;
                                    $n_octagl->scont2 = $order_size->scont2;
                                    $n_octagl->scont3 = $order_size->scont3;

                                    if ($n_octagl->save() === false) {
                                        $all_fine_tagl &= false;
                                        break;
                                    }
                                }

                                // copy rows assortment
                                $o_ocasso = Ocasso::findByNurorc($order_row->nurorc);

                                $all_fine_asso = true;
                                foreach ($o_ocasso as $order_assortment) {
                                    $n_ocasso = new Ocasso();
                                    $n_ocasso->nurorc = $n_occorp->nurorc;
                                    $n_ocasso->cdasso = $order_assortment->cdasso;
                                    $n_ocasso->quanti = $order_assortment->quanti;

                                    if ($n_ocasso->save() === false) {
                                        $all_fine_asso &= false;
                                        break;
                                    }
                                }
                            }
                        }

                        if ($all_fine_corp && $all_fine_tagl && $all_fine_asso) {
                            $this->session->set('cdcata', $cdcata);
                            echo json_encode('OK');
                        } else {
                            if (!$all_fine_corp) {
                                echo json_encode('DR');
                            } else if (!$all_fine_tagl) {
                                echo json_encode('DG');
                            } else if (!$all_fine_asso) {
                                echo json_encode('DA');
                            }
                        }
                    }
                } else {
                    echo json_encode('OP');
                }
            } else {
                $cttest = Cttest::findFirstByCdcata($cdcata);
                $cdstag = $cttest->cdstag;

                if ($auth['type'] == 3) {
                    if (!$this->utility->getAppSettings('ChoosePriceListOnNewOrder')) {
                        $nulist = $this->utility->getDefaultNulistFromCustomer($tpanag, $cdanag);
                    }
                } else {
                    $nulist = $this->utility->getDefaultNulist($auth['id']);
                }

                $items = array(
                    'id_usr' => $auth['id'],
                    'tpanag' => $tpanag,
                    'cdanag' => $cdanag,
                    'cddesm' => $cddesm != -1 ? $cddesm : NULL,
                    'cdcata' => $cdcata,
                    'nulist' => $nulist,
                    'tpordc' => $type,
                    'tpindo' => $tpindo,
                    'cdetic' => $cdetic != -1 ? $cdetic : NULL,
                    'dtcrea' => date('Y-m-d'),
                    'dtmcli' => $dtmcli != '0000-00-00' && !empty($dtmcli) ? $dtmcli : null,
                    'dtmcoi' => $dtmcoi != '0000-00-00' && !empty($dtmcoi) ? $dtmcoi : null,
                    'dtmcof' => $dtmcof != '0000-00-00' && !empty($dtmcof) ? $dtmcof : null,
                    'cdstag' => $cdstag,
                    'cdtipord' => $cdtipord,
                );

                if (Octest::findOrderInProgress($auth['id']) == null) {
                    Octest::insertNewOrder($items);
                    $octest = Octest::findOrderInProgress($auth['id']);

                    if (!empty($fldbrw)) {
                        B2bAddinf::insertDoubleRowsFlagForOrder($octest->nuordc, $fldbrw);
                    }

                    $this->utility->destroyCookie('recent-products');
                    $this->session->set('cdcata', $cdcata);
                    echo json_encode('OK');
                } else {
                    echo json_encode('OP');
                }
            }
        }
    }

    public function setCurrentOrderDateAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $dtmcli = $_POST['dtmcli'];
            $nuordc = $_POST['nuordc'];

            $octest = Octest::findFirstByNuordc($nuordc);
            $octest->dtmcli = $dtmcli != '0000-00-00' ? $dtmcli : null;

            if ($octest->save() == false) {
                echo json_encode('ER');
            } else {
                echo json_encode('OK');
            }
        }
    }

    public function setCurrentOrderDatesAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $dtmcoi = $_POST['dtmcoi'];
            $dtmcof = $_POST['dtmcof'];
            $nuordc = $_POST['nuordc'];

            $octest = Octest::findFirstByNuordc($nuordc);
            $octest->dtmcoi = $dtmcoi != '0000-00-00' ? $dtmcoi : null;
            $octest->dtmcof = $dtmcof != '0000-00-00' ? $dtmcof : null;

            if ($octest->save() == false) {
                echo json_encode('ER');
            } else {
                echo json_encode('OK');
            }
        }
    }

    public function updateCurrentOrderInfoAction()
    {
        $this->view->disable();

        $request = $this->request;
        if ($request->isPost() && $request->isAjax()) {
            $userId = $this->session->get('auth')['id'];
            $paramName = $request->getPost('paramName', 'string', '');
            $value = $request->getPost('value');
            if (!empty($userId) && !empty($paramName) && ($octest = Octest::findOrderInProgress($userId))) {
                $order_info = Octest::getCurrentOrder($userId);
                $numdisPre = $this->utility->getCustomDiscount($order_info);

                if (property_exists($octest, $paramName)) {
                    if ($octest->{$paramName} != $value) {
                        $octest->{$paramName} = $value;

                        if ($octest->save() == false) {
                            echo json_encode('ER');
                        } else {
                            $numdisNow = $this->utility->getCustomDiscount();
                            if ($numdisPre != $numdisNow) {
                                echo json_encode('RELOAD');
                            } else {
                                echo json_encode('OK');
                            }
                        }
                    } else {
                        echo json_encode('OK');
                    }
                } else {
                    echo json_encode('ER');
                }
            } else {
                echo json_encode('ER');
            }
        }
    }

    public function deleteCurrentOrderAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nuordc = $_POST['nuordc'];

            $octest = Octest::findFirstByNuordc($nuordc);
            $ocprot = Ocprot::findByNuordc($nuordc);
            $ocproc = Ocproc::findByNuordc($nuordc);
            if (
                $octest == false || $octest->delete() === false ||
                ($ocprot && $ocprot->delete() === false) || ($ocproc && $ocproc->delete() === false)
            ) {
                echo json_encode('OT');
            } else {
                // Zanotti: delete all custom articles and their features (before sparti for inner join with anaart)
                if ($this->utility->getAppSettings('ModelDetailStyle') == 3) {
                    Sparti::deleteAllFeaturesOfCustomArticlesForOrder($nuordc);
                    Anaart::deleteAllCustomArticlesForOrder($nuordc);
                }

                // Rossetti: delete all custom articles and their features
                if ($this->utility->getAppSettings('ModelDetailStyle') == 5) {
                    Ocperc::deleteAllNewCustomFeaturesForOrder($nuordc);
                    Ocpert::deleteAllNewCustomsForOrder($nuordc);
                }

                $occorp = Occorp::findByNuordc($nuordc);

                foreach ($occorp as $order_row) {
                    $octagl = Octagl::findByNurorc($order_row->nurorc);
                    $ocasso = Ocasso::findByNurorc($order_row->nurorc);
                    if ($octagl->delete() == false || $ocasso->delete() == false) {
                        echo json_encode('TA');
                    }
                }

                if ($occorp == false || $occorp->delete() == false) {
                    echo json_encode('OC');
                } else {
                    $this->session->remove('cdcata');
                    echo json_encode('OK');
                }
            }
        }
    }

    public function deleteorderrowAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nurorc = $_POST['nurorc'];
            $nuordc = $_POST['nuordc'];

            $occorp = Occorp::findByNurorc($nurorc);
            $octagl = Octagl::findByNurorc($nurorc);

            if ($this->utility->getAppSettings('ParamCouponPromo') == 2) {
                $this->utility->verifyPromos($nuordc);
            }

            if ($occorp->delete() == false || $octagl->delete() == false) {
                echo json_encode('ER');
            } else {
                echo json_encode('OK');
            }
        }
    }

    public function emptyorderrowAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nurorc = $_POST['nurorc'];
            $nuordc = $_POST['nuordc'];

            Octagl::emptyOrderRow($nurorc);
            Ocasso::emptyOrderRow($nurorc);
            Occorp::emptyOrderRow($nurorc);

            if ($this->utility->getAppSettings('ParamCouponPromo') == 2) {
                $this->utility->verifyPromos($nuordc);
            }

            echo json_encode('OK');
        }
    }

    public function correctorderrowAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nurorc = $_POST['nurorc'];
            $octagl = $_POST['octagl'];
            $nuordc = $_POST['nuordc'];

            $diff = 0;
            for ($i = 0; $i < count($octagl); $i++) {
                $params = array('nurorc' => $nurorc, 'dstagl' => $octagl[$i][0]);
                $item = Octagl::findFirst(array('nurorc = :nurorc: AND dstagl = :dstagl:', 'bind' => $params));
                $diff += $octagl[$i][1] - $item->quanti;
                $item->quanti = $octagl[$i][1];
                $item->save();
            }

            $order_row = Occorp::findFirstByNurorc($nurorc);
            $order_row->quanti = $order_row->quanti + $diff;
            $order_row->save();

            if ($this->utility->getAppSettings('ParamCouponPromo') == 2) {
                $this->utility->verifyPromos($nuordc);
            }

            echo json_encode('OK');
        }
    }

    public function sendOrderAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($this->request->isPost() && $this->request->isAjax()) {
            if ($this->request->hasPost('nuordc')) {
                $octest = Octest::findFirstByNuordc($_POST['nuordc']);
                $response = $this->utility->sendOrder($octest, $this->utility->getAppSettings('OrderStateManagement') ? 6 : 2);
                echo json_encode($response);
            } else {
                echo json_encode('ER');
            }
        }
    }

    public function modifyOrderAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $octest = Octest::findFirstByNuordc($_POST['nuordc']);
            if ($octest && Octest::findOrderInProgress($this->session->get('auth')['id']) == null) {
                $octest->flstat = 0;
                echo json_encode($octest->save() === false ? 'OE' : 'OK');
            } else {
                echo json_encode('ER');
            }
        }
    }

    public function completeOrderAction()
    {
        $this->view->disable();
        if ($this->request->isPost() && $this->request->isAjax()) {
            $auth = $this->session->get('auth');
            $octest = Octest::findOrderInProgress($auth['id']);

            if ($octest instanceof Octest) {
                $indema = $_POST['indema'];
                $conrif = $_POST['conrif'];
                $flstat = $_POST['flstat'];
                $notcli = isset($_POST['notcli']) ? $_POST['notcli'] : new \Phalcon\Db\RawValue('""');
                $notazi = isset($_POST['notazi']) ? $_POST['notazi'] : new \Phalcon\Db\RawValue('""');

                B2bOrdema::saveNewOrderInfo($octest->nuordc, $indema, $conrif);

                $octest->notcli = $notcli;
                $octest->notazi = $notazi;

                // Pagamenti e Spedizioni custom
                $idCusPaga = null;
                $configPagaIdx = null;
                if (!empty($_POST['idcuspag'])) {
                    list($idCusPaga, $configPagaIdx) = explode('-', $_POST['idcuspag']);
                }
                $tppaga = isset($_POST['tppaga']) && $_POST['tppaga'] != 'NOCONDITION' ? $_POST['tppaga'] : new \Phalcon\Db\RawValue('""');

                $idCusPort = null;
                $configPortIdx = null;
                if (!empty($_POST['idcuspor'])) {
                    list($idCusPort, $configPortIdx) = explode('-', $_POST['idcuspor']);
                }
                $tpport = isset($_POST['tpport']) && $_POST['tpport'] != 'NOCONDITION' ? $_POST['tpport'] : new \Phalcon\Db\RawValue('""');

                // Custom Pagamenti e Spedizioni
                $additionalData = [];
                if (!empty($idCusPaga) && ($cusPaga = B2bCuspag::findFirstByNumpag($idCusPaga)) && $cusPaga instanceof B2bCuspag) {
                    $tppaga = isset($cusPaga->tppaga) ? $cusPaga->tppaga : 'NOCONDITION';
                    $customPagaConfigAll = json_decode($cusPaga->config ?: '[]') ?: [];
                    $customPagaConfig = $customPagaConfigAll[$configPagaIdx] ?: null;
                    $additionalData[B2bOrdadd::SPESA_AGGIUNTIVA_PAGAMENTO] = $customPagaConfig->preagg;
                }
                if (!empty($idCusPort) && ($cusPort = B2bCuspor::findFirstByNumpor($idCusPort)) && $cusPort instanceof B2bCuspor) {
                    $tpport = isset($cusPort->tpport) ? $cusPort->tpport : 'NOCONDITION';
                    $customPortConfigAll = json_decode($cusPort->config ?: '[]') ?: [];
                    $customPortConfig = $customPortConfigAll[$configPortIdx] ?: null;
                    $additionalData[B2bOrdadd::SPESA_AGGIUNTIVA_SPEDIZIONE] = isset($customPortConfig->preagg) ? $customPortConfig->preagg : null;
                    // Abbiamo deciso d'inserire sempre tutti i record così evitiamo problemi con ordini già confermati
                    // if (!empty($cusPort->contra)) {
                    $additionalData[B2bOrdadd::SPESA_AGGIUNTIVA_CONTRASSEGNO] = isset($customPortConfig->contra) ? $customPortConfig->contra : null;
                    // }
                }

                $octest->tppaga = $tppaga;
                $octest->tpport = $tpport;

                echo json_encode($this->utility->sendOrder($octest, $flstat, $additionalData));
            } else {
                echo json_encode('ER');
            }
        }
    }

    public function executePaymentAction()
    {
        $this->view->disable();

        $success = true;
        $nuordc = $_GET['nuordc'];

        if (isset($_GET['success']) && $_GET['success'] == 'true') {
            $apiContext = new ApiContext(
                new OAuthTokenCredential(
                //'AQnMQ0iEmEwD4VB0OpZF_uY0fz9Eqw4lL4q6oTpS83oNTlmzi1IT4ecAXY-zYXidzAMojFiH-nugpJG5', // clientId
                //'EDrJW09NK4z9lk_944z1siJKvuaUnEHwpy3DIROKaYJskO0-3pTF8V3uJSxGeCEp_TeXnvZ7LIhJC1k5' // clientSecret
                    'Aam55DaHV2y52gtO_gCO1MjKMDOJfzMhDCglysJUehEKeRC8jXEeDOttisJwC2VsvdMGEqLbfwJOXgRL', // clientId
                    'EOEn61Dsr3yLzwWsohFv68Q20MG0mpHnXRE4uK_NqYDIJykhGrbRrWojq8fjmycws9KFe0_p32XiBztY' // clientSecret
                )
            );

            $apiContext->setConfig(
                array(
                    'mode' => 'live',
                    'log.LogEnabled' => true,
                    'log.FileName' => 'PayPal.log',
                    'log.LogLevel' => 'INFO', // PLEASE USE `INFO` LEVEL FOR LOGGING IN LIVE ENVIRONMENTS
                    //'cache.enabled' => true,
                    // 'http.CURLOPT_CONNECTTIMEOUT' => 30
                    // 'http.headers.PayPal-Partner-Attribution-Id' => '123123123'
                    //'log.AdapterFactory' => '\PayPal\Log\DefaultLogFactory' // Factory class implementing \PayPal\Log\PayPalLogFactory
                )
            );

            // Get the payment Object by passing paymentId payment id was previously stored in session in
            $paymentId = $_GET['paymentId'];
            $payment = Payment::get($paymentId, $apiContext);

            // ### Payment Execute
            // PaymentExecution object includes information necessary to execute a PayPal account payment.
            // The payer_id is added to the request query parameters when the user is redirected from paypal back to your site
            $execution = new PaymentExecution();
            $execution->setPayerId($_GET['PayerID']);

            try {
                // Execute the payment
                $result = $payment->execute($execution, $apiContext);

                try {
                    $payment = Payment::get($paymentId, $apiContext);
                } catch (\Exception $ex) {
                    $this->logger->info("executePayment Payment::get ex getCode: " . $ex->getCode());
                    $this->logger->info("executePayment Payment::get ex getData: " . $ex->getData());
                    $success = false;
                }
            } catch (\Exception $ex) {
                $this->logger->info("executePayment payment->execute ex getCode: " . $ex->getCode());
                $this->logger->info("executePayment payment->execute ex getData: " . $ex->getData());
                $success = $ex->getCode() == 400; // If payment already done (400) set it to true. This can occurs when there are some problems and function is called twice
            }
        } else {
            $success = false;
        }

        $auth = $this->session->get('auth');
        $octest = Octest::findFirst(array('nuordc = :nuordc: AND (flstat = 0 OR flstat = 1)', 'bind' => array('nuordc' => $nuordc)));

        if ($octest) {
            $octest->flstat = $success ? 2 : 1;
            $octest->dtinvi = date('Y-m-d');

            if ($octest->tpordc == 0 && $this->utility->getAppSettings('ParamDateManagementAvailability') == 4) {
                $dateOffset = $this->utility->getAppSettings('ParamAvailabilityDateManagement');
                $dateOffset = !empty($dateOffset) && $dateOffset != 0 ? $dateOffset : 7;
                $octest->dtmcli = date('Y-m-d', strtotime('+' . $dateOffset . ' day'));
            }

            $anagra = Anagra::findCustomerByKey($octest->tpanag, $octest->cdanag);

            $octest->tppaga = 'payp';
            $octest->tpport = $anagra->tpport;
            $octest->cdvett = $anagra->cdvett;

            if ($success) {
                $this->utility->exportOrder($octest);
            }

            if ($octest->save()) {
                $this->response->redirect('account/info/ord');
            }
        }
    }

    public function loadPaypalAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $tax = $_POST['tax'];
            $add = $_POST['add'];

            $payer = new Payer();
            $payer->setPaymentMethod('paypal');

            $id_usr = $this->session->get('auth')['id'];
            $order_info = Octest::getCurrentOrder($id_usr);
            $articles = $this->getCartArticles($id_usr, $order_info->cdcata, $order_info->nulist, $order_info->tpordc == 0, $order_info);

            $total = 0;
            $ord_descr = $order_info->dtmcli != '' && $order_info->dtmcli != '00/00/0000'
                ? $this->translate('_common.order') . ": " . $order_info->nuordc . " " . $order_info->dtmcli . " - " . $order_info->dsanag
                : $this->translate('_common.order') . ": " . $order_info->nuordc . " " . $order_info->dtmcoi . "-" . $order_info->dtmcof . " - " . $order_info->dsanag;

            $items = [];
            foreach ($articles as $el) {
                $price = 0;
                $name = $el['cdarti'] . ($el['tppers'] == 'PT' ? ' - ' . $el['cdcolo'] : '');
                $qty = $el['quanti'];
                $descr = '';
                switch ($this->utility->getAppSettings('ParamTypeDescrSummary')) {
                    case 0:
                        $descr = $el['dsarti'];
                        break;
                    case 1:
                        $descr = $el['cdcolo'] . " - " . $el['dsartn'] . " - " . $el['dsarti'];
                        break;
                    case 2:
                        $descr = $el['dsartn'] . " - " . $el['dscolo'];
                        break;
                    case 3:
                        $descr = $el['dstitl'] . " - " . $el['dsarti'];
                        break;
                    case 4:
                        $descr = $el['dsarti'] . " - " . $el['dscolo'];
                        break;
                }

                foreach ($el['octagl'] as $size) {
                    if ($el['tppers'] != "PT" || $el['cdvari'] == null || $el['cdvari'] == '') {
                        $price += ($size->prezzo * $size->quanti);
                    } else {
                        $price += (($size->prezzo + $el['preagg']) * $size->quanti);
                    }
                }

                $total += $price;

                $item = new Item();
                $item->setName($name)
                    ->setDescription($descr)
                    ->setCurrency($order_info->cdvalu)
                    ->setQuantity($qty)
                    ->setPrice($price / $qty);
                $items[] = $item;
            }

            if ($tax > 0) {
                $item = new Item();
                $item->setName($this->translate('_common.tax'))
                    ->setDescription($this->translate('_common.tax') . ' (' . $order_info->dsaiva . ')')
                    ->setCurrency($order_info->cdvalu)
                    ->setQuantity(1)
                    ->setPrice($tax);
                $items[] = $item;

                $total += $tax;
            }

            if ($add > 0) {
                $item = new Item();
                $item->setName($this->translate('account.customer.shipment'))
                    ->setDescription($this->translate('account.customer.shipment'))
                    ->setCurrency($order_info->cdvalu)
                    ->setQuantity(1)
                    ->setPrice($add);
                $items[] = $item;

                $total += $add;
            }

            // Itemized information
            // (Optional) Lets you specify item wise information

            $itemList = new ItemList();
            $itemList->setItems($items);

            $amount = new Amount();
            $amount->setCurrency($order_info->cdvalu)
                ->setTotal($total);

            $email = $this->utility->getAppUtils("paypal_email");
            $merchant_id = $this->utility->getAppUtils("paypal_merchant_id");

            $payee = new Payee();
            if ($email != "") {
                $payee->setEmail($email);
            } else if ($merchant_id != "") {
                $payee->setMerchantId($merchant_id);
            }

            $transaction = new Transaction();
            $transaction->setAmount($amount)
                ->setItemList($itemList)
                ->setDescription($ord_descr)
                ->setPayee($payee)
                ->setInvoiceNumber(uniqid());

            // Redirect urls
            // Set the urls that the buyer must be redirected to after payment approval/ cancellation.
            $redirectUrls = new RedirectUrls();

            $redirectUrl = "http://" . $_SERVER['SERVER_NAME'] . $this->url->get('cart/executePayment') . "?nuordc=" . $order_info->nuordc . "&success=";

            //$url = "http://" . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
            //$url = str_replace("pay", "executePayment.php?nuordc=" . $nuordc . "&success=", $url);
            $redirectUrls->setReturnUrl($redirectUrl . "true")
                ->setCancelUrl($redirectUrl . "false");

            // Payment
            // A Payment Resource; create one using the above types and intent set to 'sale'
            $payment = new Payment();
            $payment->setIntent("sale")
                ->setPayer($payer)
                ->setRedirectUrls($redirectUrls)
                ->setTransactions(array($transaction));

            // ### Api context
            // Use an ApiContext object to authenticate API calls. The clientId and clientSecret for the OAuthTokenCredential class can be retrieved from developer.paypal.com
            $apiContext = new ApiContext(
                new OAuthTokenCredential(
                // LIVE
                    'Aam55DaHV2y52gtO_gCO1MjKMDOJfzMhDCglysJUehEKeRC8jXEeDOttisJwC2VsvdMGEqLbfwJOXgRL', // clientId
                    'EOEn61Dsr3yLzwWsohFv68Q20MG0mpHnXRE4uK_NqYDIJykhGrbRrWojq8fjmycws9KFe0_p32XiBztY' // clientSecret
                // SANDBOX
                //'AQnMQ0iEmEwD4VB0OpZF_uY0fz9Eqw4lL4q6oTpS83oNTlmzi1IT4ecAXY-zYXidzAMojFiH-nugpJG5', // clientId
                //'EDrJW09NK4z9lk_944z1siJKvuaUnEHwpy3DIROKaYJskO0-3pTF8V3uJSxGeCEp_TeXnvZ7LIhJC1k5' // clientSecret
                )
            );

            // Comment this line out and uncomment the PP_CONFIG_PATH 'define' block if you want to use static file based configuration
            $apiContext->setConfig(
                array(
                    'mode' => 'live', //'sandbox',
                    'log.FileName' => '../PayPal.log',
                    'log.LogEnabled' => true,
                    'log.LogLevel' => 'FINE', // PLEASE USE `INFO` LEVEL FOR LOGGING IN LIVE ENVIRONMENTS
                    'cache.enabled' => true,
                    'cache.FileName' => '../auth.cache',
                    // 'http.CURLOPT_CONNECTTIMEOUT' => 30
                    // 'http.headers.PayPal-Partner-Attribution-Id' => '123123123'
                    //'log.AdapterFactory' => '\PayPal\Log\DefaultLogFactory' // Factory class implementing \PayPal\Log\PayPalLogFactory
                )
            );

            // ### Create Payment
            // Create a payment by calling the 'create' method passing it a valid apiContext. (See bootstrap.php for more on `ApiContext`)
            // The return object contains the state and the url to which the buyer must be redirected to for payment approval
            try {
                $payment->create($apiContext);
            } catch (\PayPal\Exception\PayPalConnectionException $ex) {
                $this->logger->info(print_r($ex->getCode(), true)); // Prints the Error Code
                $this->logger->info(print_r($ex->getData(), true)); // Prints the detailed error message
                //echo json_encode($ex);
                exit(1);
            } catch (\Exception $ex) {
                // NOTE: PLEASE DO NOT USE RESULTPRINTER CLASS IN YOUR ORIGINAL CODE. FOR SAMPLE ONLY
                //ResultPrinter::printError("Created Payment Using PayPal. Please visit the URL to Approve.", "Payment", null, $request, $ex);
                $this->logger->info(print_r($ex, true));
                //echo json_encode($ex);
                exit(1);
            }

            // ### Get redirect url
            // The API response provides the url that you must redirect the buyer to. Retrieve the url from the $payment->getApprovalLink() method
            $approvalUrl = $payment->getApprovalLink();
            // NOTE: PLEASE DO NOT USE RESULTPRINTER CLASS IN YOUR ORIGINAL CODE. FOR SAMPLE ONLY
            //ResultPrinter::printResult("Created Payment Using PayPal. Please visit the URL to Approve.", "Payment", "<a href='$approvalUrl' >$approvalUrl</a>", $request, $payment);

            // return $payment;

            echo json_encode($approvalUrl);
            //echo json_encode("OK");
        }
    }

    public function payStripeAction()
    {
        $this->view->disable();

        $nuordc = $this->dispatcher->getParam("nuordc");
        $auth = $this->session->get('auth');
        $octest = Octest::findFirst(array("nuordc = :nuordc: AND (flstat = 0 OR flstat = 1)", 'bind' => array("nuordc" => $nuordc)));

        try {
            $secret_key = $this->utility->getAppUtils('secret_key');
            if ($this->utility->getAppUtils('secret_key') != '') {
                \Stripe\Stripe::setApiKey($secret_key);
            } else {
                \Stripe\Stripe::setApiKey("sk_test_cbpoap7MHEHg0XAw5XwBb9I6");
            }

            // Token is created using Stripe.js or Checkout!
            // Get the payment token ID submitted by the form:
            $token = $_POST['stripeToken'];
            $amount = $_POST['amount'];

            // Charge the user's card:
            $charge = \Stripe\Charge::create(array(
                "amount" => $amount,
                "currency" => "eur",
                "description" => "Order " . $nuordc,
                "capture" => true,
                "source" => $token,
            ));

            if ($octest) {
                $octest->flstat = 2;
                $octest->dtinvi = date('Y-m-d');

                if ($octest->tpordc == 0 && $this->utility->getAppSettings('ParamDateManagementAvailability') == 4) {
                    $dateOffset = $this->utility->getAppSettings('ParamAvailabilityDateManagement');
                    $dateOffset = !empty($dateOffset) && $dateOffset != 0 ? $dateOffset : 7;
                    $octest->dtmcli = date('Y-m-d', strtotime('+' . $dateOffset . ' day'));
                }

                $anagra = Anagra::findCustomerByKey($octest->tpanag, $octest->cdanag);

                $octest->tppaga = 'stri';
                $octest->tpport = $anagra->tpport;
                $octest->cdvett = $anagra->cdvett;

                $this->utility->exportOrder($octest);

                if ($octest->save()) {
                    $this->response->redirect('account/info/ord');
                }
            }
        } catch (\Exception $ex) {
            $this->logger->info(print_r($ex, true));
        }
    }

    public function getDeliveryPeriodsOptionsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($this->request->isPost() && $this->request->isAjax()) {
            $cdcata = $this->request->getPost('cdcata');

            $periods = Scacon::getPeriodsForCatalog($cdcata);

            /* Su ordine di Matteo (per BED) il 29/11/23 abbiamo spento questa opzione per fare in modo
               che il primo sia sempre selezionato al posto di quello vuoto */
            // $options = '<option value="0000-00-00"></option>';
            $options = '';
            foreach ($periods as $scacon) {
                $options .= '<option value="' . $scacon->dtmcli . '">' . $scacon->dsscad . '</option>';
            }

            echo json_encode(array(
                'response' => 'OK',
                'options' => $options
            ));
        }
    }

    public function getDestinationsOptionsAction()
    {
        $this->view->disable();

        if ($this->request->isPost() && $this->request->isAjax()) {
            $this->response->setHeader(
                'Content-Type',
                'application/json; charset=UTF-8'
            );

            $options = [];

            try {
                $auth = $this->session->get('auth');
                $customer = $tpanag = $cdanag = null;
                if ($auth['type'] == 4 && ($pivot = B2bUsrana::findFirstByIdUsr($auth['id'])) && $pivot instanceof B2bUsrana) {
                    $tpanag = $pivot->tpanag;
                    $cdanag = $pivot->cdanag;
                } else if ($this->request->hasPost('cdanag')) {
                    $tpanag = $this->request->getPost('tpanag');
                    $cdanag = $this->request->getPost('cdanag');
                }

                if (!empty($cdanag)) {
                    $customer = Anagra::findCustomerByKey($tpanag, $cdanag);
                }

                if (!$customer instanceof Anagra) {
                    throw new \Exception($this->i18n->_('_common.notfound'));
                }

                $options[] = [
                    'value' => -1,
                    'label' => $this->i18n->_('_common.address.main') . ' - '
                        . $this->i18n->_('account.customer.businessname'), // . $this->elements->getAddress(),
                ];

                $destinazioni = Desmer::getShippingsForCustomer($tpanag, $cdanag);

                $allowlist = null;
                if ($auth['type'] == 3 && !Anaage::isHeadquarterAgent($auth['id'])) {
                    $allowlist = [];
                    $pivotAna = Ageana::find([
                        "tipdat = 'D' AND tpanag = :tpanag: AND codice LIKE :cdanag: AND cdagen = :cdagen:",
                        'bind' => [
                            'tpanag' => $customer->tpanag,
                            'cdanag' => $customer->cdanag . '%',
                            'cdagen' => $auth['code'],
                        ]
                    ]);

                    /** @var Ageana $ageana */
                    foreach ($pivotAna as $ageana) {
                        $allowlist[] = $ageana->codice;
                    }
                }

                /** @var Desmer $destinazione */
                foreach ($destinazioni as $destinazione) {
                    if ($auth['type'] == 4 || $allowlist === null || in_array($destinazione->cddesm, $allowlist)) {
                        $options[] = [
                            'value' => $destinazione->cddesm,
                            'label' => trim($destinazione->desvid . ' - ' . $destinazione->getAddress()),
                        ];
                    }
                }

                $res = [
                    'success' => true,
                    'options' => $options,
                ];
            } catch (\Exception $ex) {
                $res = [
                    'error' => $ex->getCode(),
                    'message' => $ex->getMessage(),
                ];
            }

            //Set the content of the response
            $this->response->setContent(json_encode($res));
        }

        //Return the response
        return $this->response;
    }

    public function getAnaregOptionsRulesAction()
    {
        $this->view->disable();

        if ($this->request->isPost() && $this->request->isAjax()) {
            $this->response->setHeader(
                'Content-Type',
                'application/json; charset=UTF-8'
            );

            $optionsRules = [];

            try {
                $auth = $this->session->get('auth');
                $customer = $tpanag = $cdanag = $cdcata = null;
                if ($auth['type'] == 4 && ($pivot = B2bUsrana::findFirstByIdUsr($auth['id'])) && $pivot instanceof B2bUsrana) {
                    $tpanag = $pivot->tpanag;
                    $cdanag = $pivot->cdanag;
                } else if ($this->request->hasPost('cdanag')) {
                    $tpanag = $this->request->getPost('tpanag');
                    $cdanag = $this->request->getPost('cdanag');
                }

                if (!empty($cdanag)) {
                    $customer = Anagra::findCustomerByKey($tpanag, $cdanag);
                }

                if (!$customer instanceof Anagra) {
                    throw new \Exception($this->i18n->_('_common.notfound'));
                }

                if ($this->request->hasPost('cdcata')) {
                    $cdcata = $this->request->getPost('cdcata');
                }

                $params = [
                    'tpanag' => $tpanag,
                    'cdanag' => $cdanag,
                ];

                $additionalWhere = '';
                if (!empty($cdcata)) {
                    $additionalWhere = ' AND cdcata = :cdcata:';
                    $params['cdcata'] = $cdcata;
                }

                $rules = Anareg::find([
                    'tpanag = :tpanag: AND cdanag = :cdanag:' . $additionalWhere,
                    'bind' => $params
                ]);

                $now = time();
                /** @var Anareg $rule */
                foreach ($rules as $rule) {
                    $inizio = strtotime($rule->dtiniz);
                    $fine = strtotime($rule->dtfine);
                    $optionsRules[$rule->cdcata][] = [
                        'value' => $rule->tpordi,
                        'data' => [
                            'active' => $now > $inizio && $now < $fine,
                            'dtiniz' => $rule->dtiniz,
                            'dtfine' => $rule->dtfine,
                            'dtmcli' => $rule->dtmcli,
                            'dtmmax' => $rule->dtmmax,
                        ]
                    ];
                }

                $res = [
                    'success' => true,
                    'rules' => $optionsRules,
                ];
            } catch (\Exception $ex) {
                $res = [
                    'error' => $ex->getCode(),
                    'message' => $ex->getMessage(),
                ];
            }

            //Set the content of the response
            $this->response->setContent(json_encode($res));
        }

        //Return the response
        return $this->response;
    }

    public function getModifyQuantityContentAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nurorc = $_POST['nurorc'];
            $nulist = $_POST['nulist'];
            $cdartn = $_POST['cdartn'];

            $tipolo = Tipolo::findFirstByCdartn($cdartn);
            $octagl = Octagl::getSizeQuantitiesWithRulesForWizard($nurorc);

            $showCatalogPrice = $this->utility->getAppSettings('ParamShowPriceCatalog');
            $html = $this->getHtmlSizeContentForWizard($octagl, $tipolo, $nulist, $showCatalogPrice);

            echo json_encode(array('response' => 'OK', 'html' => $html));
        }
    }

    private function getHtmlSizeContentForWizard($octagl, $tipolo, $nulist, $showCatalogPrice)
    {
        $html =
            "<div class='col-12'>
        <div class='row wizard-header-row'>
          <div class='col'>" . $this->translate('_common.sizes.qty') . "</div>" .
            ($showCatalogPrice
                ? "<div class='col'>" . $this->translate('_common.price') . "</div>" : '') .
            "<div class='col'>" . $this->translate('_common.qty.art') . "</div>
        </div>
      </div>";

        $bg = '#fafafa';
        for ($i = 0; $i < count($octagl); $i++) {
            $bg = $bg == '#fafafa' ? '#fff' : '#fafafa';
            $size = $octagl[$i];

            $disabled = (($i + 1) < $tipolo->tglini && $tipolo->tglini != 0) || (($i + 1) > $tipolo->tglfin && $tipolo->tglfin != 0);
            $disc_price = 0;
            if ($showCatalogPrice == 1) {
                $withDiscount = false;
                $currentPrice = $size->prezzo;
            }

            $html .=
                '<div class="col-12">
          <div class="row wizard-list-row ' . ($disabled ? 'size-disabled' : '') . '" style="background-color:' . $bg . '">
            <div class="col">' . $size->dstagl . '</div>';

            if ($showCatalogPrice == 1) {
                $html .= '<div class="col">' . $this->utility->getFormattedPrice($nulist, $currentPrice)['value'] . '</div>';
            }

            $html .= '<div class="col insert-quantity-row" data-disp="-1" data-qtamin="' . $size->qtamin . '"
        data-qtamul="' . ($size->qtamul > 0 ? $size->qtamul : 1) . '">';
            if ($size['flbloc'] > 0) {
                $html .= "<span class='blocked'>" . $this->translate('quantity.blocked') . "</span>";
            } else {
                $html .=
                    "<div class='btn-number minus-qty " . ($size->quanti == 0 ? 'disabled' : 'enabled') . "' data-type='minus'>
            <i class='fa fa-minus' aria-hidden='true'></i>
          </div>
          <div class='float-left w-40'>
            <input type='text' class='input-number' data-old_value=''
              data-taglia='" . $size->dstagl . "' name='quantity' min='0' step='" . $size->qtamin . "'
              value='" . ($size->quanti > 0 ? $size->quanti : '') . "' " . ($disabled ? 'disabled' : '') . ">
          </div>
          <div class='btn-number plus-qty enabled' data-type='plus'>
            <i class='fa fa-plus' aria-hidden='true'></i>
          </div>";

                if ($this->utility->getAppSettings('EnableMinMulLabel') > 0) {
                    $html .= "<div class='regqta-info'>";
                    $html .= $this->translate('_common.qty.min.short') . ': ' . $size->qtamin . ', ';
                    $html .= $this->translate('_common.qty.mul.short') . ': ' . $size->qtamul;
                    if (isset($size->qtamax) && $size->qtamax > 0) {
                        $html .= ', ' . $this->translate('_common.qty.max.short') . ': ' . $size->qtamax;
                    }
                    $html .= "</div>";
                }
            }
            $html .= '</div>';

            $html .=
                '</div>
        </div>';
        }

        return $html;
    }

    public function getModifyVariantsContentAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nurorc = $_POST['nurorc'];
            $cdvari = $_POST['cdvari'];

            $variants = Tabvar::getAllCustomsForOrderRow($nurorc);

            $html = $this->getHtmlVariantsContentForWizard($variants, $cdvari);

            echo json_encode(array('response' => 'OK', 'html' => $html));
        }
    }

    private function getHtmlVariantsContentForWizard($variants, $cdvari)
    {
        $html = '';
        $currentVariantType = '';
        $needDivClosure = false;

        for ($i = 0; $i < count($variants); $i++) {
            $variant = $variants[$i];
            if ($currentVariantType != $variant['tpvari']) {
                $currentVariantType = $variant['tpvari'];
                $html .= $needDivClosure ? '</div>' : '';
                $html .= '<div class="font-weight-bold title w-100">' . $variant['dstvar'] . '</div>';
                $html .= '<div class="row m-0 w-100 mb-20x">';
                $needDivClosure = true;
            }
            $html .=
                '<div class="variant-box ' . (strpos($cdvari, $variant['cdvari']) !== false ? 'selected' : '') . '" data-cdvari="' . $variant['cdvari'] . '" data-tpvari="' . $variant['tpvari'] . '">
          <div class="check"><i class="fa fa-check"></i></div>
          <div>' . $this->elements->getVariantImgOrDefaultHtml($variant['flimag'], $variant['dsvari']) . '</div>
          <div class="cdvari">' . $variant['cdvari'] . '</div>
          <div class="description" title="' . $variant['dsvari'] . '">' . $variant['dsvari'] . '</div>
          <div>+ ' . $this->utility->getFormattedPriceCurrencyPresent($variant['prezzo'], '€', 'EUR')['value'] . '</div>
        </div>';
            if ($i == count($variants) - 1) {
                $html .= '</div>';
            }
        }

        return $html;
    }

    public function saveModifyQuantityAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nurorc = $_POST['nurorc'];
            $dtmcli = $_POST['dtmcli'];
            $dsnoco = $_POST['dsnoco'];
            $octagl = $_POST['octagl'];

            if ($dtmcli != '00/00/0000' && $dtmcli != '') {
                $tokens = explode('/', $dtmcli);
                $dtmcli = $tokens[2] . '-' . $tokens[1] . '-' . $tokens[0];
            } else {
                $dtmcli = '0000-00-00';
            }

            $quanti = 0;
            foreach ($octagl as $row) {
                Octagl::updateSizeQuantity($nurorc, $row[0], $row[1]);
                $quanti += $row[1];
            }

            Occorp::updateOrderRowInfo($nurorc, $dtmcli, $dsnoco, $quanti);

            echo json_encode('OK');
        }
    }

    public function saveModifyVariantsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nurorc = $_POST['nurorc'];
            $cdvari = $_POST['cdvari'];
            $oldcdvari = $_POST['oldcdvari'];

            $old_increase = 0;
            $new_increase = 0;

            if ($oldcdvari != '') {
                $variants = str_split($oldcdvari);
                foreach ($variants as $code) {
                    $old_increase += Tabvar::getCustomFromCdvariAndNurorc($code, $nurorc)->prezzo;
                }
            }

            if ($cdvari != '') {
                $variants = str_split($cdvari);
                foreach ($variants as $code) {
                    $new_increase += Tabvar::getCustomFromCdvariAndNurorc($code, $nurorc)->prezzo;
                }
            }

            Occorp::updateOrderRowCdvari($nurorc, $cdvari);
            Octagl::updateSizeQuantityPrice($nurorc, $new_increase - $old_increase);

            echo json_encode('OK');
        }
    }

    public function recalculateOrderPricesAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nulist = $_POST['nulist'];
            $nuordc = $_POST['nuordc'];

            Octagl::recalculatePrices($nuordc, $nulist);
            Octest::updatePriceList($nuordc, $nulist);

            echo json_encode('OK');
        }
    }

    public function applyDiscountsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $scont1 = isset($_POST['scont1']) && $_POST['scont1'] > 0 ? $_POST['scont1'] : 0;
            $scont2 = isset($_POST['scont2']) && $_POST['scont2'] > 0 ? $_POST['scont2'] : 0;
            $scont3 = isset($_POST['scont3']) && $_POST['scont3'] > 0 ? $_POST['scont3'] : 0;
            $nuordc = $_POST['nuordc'];

            Octagl::applyDiscounts($nuordc, $scont1, $scont2, $scont3);

            echo json_encode('OK');
        }
    }

    public function changeIndicativeAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $tpindo = isset($_POST['tpindo']) && $_POST['tpindo'] != 'unassigned' ? $_POST['tpindo'] : null;
            $nuordc = $_POST['nuordc'];

            Octest::updateIndicative($nuordc, $tpindo);

            echo json_encode('OK');
        }
    }
    //endregion

    //region Ajax functions: promo and coupon management

    public function deleteCartRowsWithNoQuantityAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $id_usr = $this->session->get('auth')['id'];
            Occorp::deleteCartRowsWithNoQuantity($id_usr);

            echo json_encode('OK');
        }
    }

    public function getOrderRowInfoAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nuordc = $_POST['nuordc'];
            $nurorc = $_POST['nurorc'];

            $showRowDelivery = $this->utility->getAppSettings('ParamQuantityDeliveryView');
            $showRowIndicative = $this->utility->getAppSettings('ParamQuantityIndicativeView');
            $showRowNotes = $this->utility->getAppSettings('ParamQuantityNotesView');
            $showRowReference = $this->utility->getAppSettings('ParamQuantityReferenceView');

            $info = Occorp::getOrderRowInfoFromNuordcAndNurorc($nuordc, $nurorc);
            $octest = Octest::findFirstByNuordc($nuordc);
            $defaultIndicative = Anagra::getDefaultTpindo($octest->tpanag, $octest->cdanag);

            $html = '';
            if ($showRowIndicative > 0) {
                $html .= $this->getHtmlContentForModalIndicative($showRowIndicative, $info['tpindo'], $info['indorc'], $defaultIndicative);
            }
            if ($showRowNotes > 0) {
                $html .= $this->getHtmlContentForModalNotes($showRowNotes, $info['tpnoco'], $info['dsnoco']);
            }
            if ($showRowReference > 0) {
                $html .= $this->getHtmlContentForModalReference($showRowReference, $info['sgrifc']);
            }
            if ($showRowDelivery > 0) {
                $html .= $this->getHtmlContentForModalDelivery($showRowDelivery, $octest->cdcata, $info['dtmcli'], $info['dtmcli_raw']);
            }

            echo json_encode(array('response' => 'OK', 'content' => $html));
        }
    }

    private function getHtmlContentForModalIndicative($showRowIndicative, $tpindo, $indorc, $defaultIndicative)
    {
        $html = '<div class="modal-section pb-20x">';
        $html .= '<div class="row m-0">';
        $html .= '<div class="col-3 cart-info-title text-right pr-20x" style="line-height:42px">' . $this->translate('_common.indicative') . '</div>';
        $html .= '<div class="col-9 cart-info-text text-left">';

        if ($showRowIndicative == 1) {
            $html .= '<input type="text" class="form-control m-0" id="modal-modify-row-info-dsnoco" value="' . $indorc . '"/>';
        } else if ($showRowIndicative == 2) {
            $indicatives = Indorc::find();
            $showAll = $this->session->get('auth')['type'] == 3;
            $html .= '<div class="form-element form-select m-0">';
            $html .= '<label class="form-custom-select m-0">';
            $html .= '<select id="modal-modify-row-info-tpindo">';
            if ($showAll && $defaultIndicative == '') {
                $html .= '<option value="none">&nbsp;</option>';
            }
            if (count($indicatives) > 0) {
                foreach ($indicatives as $indicative) {
                    $selected = $tpindo == $indicative->tpindo ? 'selected' : '';
                    if (($showAll && $defaultIndicative == '') || $selected != '') {
                        $html .= '<option value="' . $indicative->tpindo . '" ' . $selected . '>' . $indicative->dsindo . '</option>';
                    }
                }
            }
            $html .= '</select>';

            $html .= '</label>';
            $html .= '</div>';
            $html .= '</div>';
        }

        $html .= '</div>';
        $html .= '</div>';
        $html .= '</div>';

        return $html;
    }

    private function getHtmlContentForModalNotes($showRowNotes, $tpnoco, $dsnoco)
    {
        $html = '<div class="modal-section pb-20x">';
        $html .= '<div class="row m-0">';
        $html .= '<div class="col-3 cart-info-title text-right pr-20x" style="line-height:42px">' . $this->translate('_common.notes') . '</div>';
        $html .= '<div class="col-9 cart-info-text text-left">';

        if ($showRowNotes == 1) {
            $html .= '<input type="text" class="form-control m-0" id="modal-modify-row-info-dsnoco" value="' . $dsnoco . '"/>';
        } else if ($showRowNotes == 2) {
            $notes = Noccom::find();
            $html .= '<div class="form-element form-select m-0">';
            $html .= '<label class="form-custom-select m-0">';
            $html .= '<select id="modal-modify-row-info-tpnoco">';
            $html .= '<option value="none">&nbsp;</option>';
            if (count($notes) > 0) {
                foreach ($notes as $noccom) {
                    $selected = $tpnoco == $noccom->tpnoco ? 'selected' : '';
                    $html .= '<option value="' . $noccom->tpnoco . '" ' . $selected . '>' . $noccom->dsnoco . '</option>';
                }
            }
            $html .= '</select>';

            $html .= '</label>';
            $html .= '</div>';
            $html .= '</div>';
        }

        $html .= '</div>';
        $html .= '</div>';
        $html .= '</div>';

        return $html;
    }

    private function getHtmlContentForModalReference($showRowReference, $sgrifc)
    {
        $html = '<div class="modal-section pb-20x">';
        $html .= '<div class="row m-0">';
        $html .= '<div class="col-3 cart-info-title text-right pr-20x" style="line-height:42px">' . $this->translate('_common.reference') . '</div>';
        $html .= '<div class="col-9 cart-info-text text-left"><input type="text" class="form-control m-0" id="modal-modify-row-info-sgrifc" value="' . $sgrifc . '"/></div>';
        $html .= '</div>';
        $html .= '</div>';

        return $html;
    }

    private function getHtmlContentForModalDelivery($showRowDelivery, $cdcata, $dtmcli, $dtmcli_raw)
    {
        $html = '<div class="modal-section pb-20x">';
        $html .= '<div class="row m-0">';
        $html .= '<div class="col-3 cart-info-title text-right pr-20x" style="line-height:42px">' . $this->translate('_common.delivery') . '</div>';
        $html .= '<div class="col-9 cart-info-text text-left">';

        if ($showRowDelivery == 1) {
            $html .= '<input type="text" class="form-control m-0" id="modal-modify-row-info-dtmcli" value="' . ($dtmcli != '' && $dtmcli != '00/00/0000' ? $dtmcli : '') . '"/>';
        } else if ($showRowDelivery == 2) {
            $dates = Scacon::findByCdcata($cdcata);
            $html .= '<div class="form-element form-select m-0">';
            $html .= '<label class="form-custom-select m-0">';
            $html .= '<select id="modal-modify-row-info-dtmcli">';
            $html .= '<option value="none">&nbsp;</option>';
            if (count($dates) > 0) {
                foreach ($dates as $scacon) {
                    $selected = $dtmcli_raw == $scacon->dtmcli ? 'selected' : '';
                    $html .= '<option value="' . $scacon->dtmcli . '" ' . $selected . '>' . $scacon->dsscad . '</option>';
                }
            }
            $html .= '</select>';

            $html .= '</label>';
            $html .= '</div>';
            $html .= '</div>';
        }

        $html .= '</div>';
        $html .= '</div>';
        $html .= '</div>';

        return $html;
    }
    //endregion

    //region Utility functions

    public function updateOrderRowInfoAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nuordc = isset($_POST['nuordc']) ? $_POST['nuordc'] : '';
            $nurorc = isset($_POST['nurorc']) ? $_POST['nurorc'] : '';
            $dtmcli = isset($_POST['dtmcli']) ? $_POST['dtmcli'] : '';
            $tpindo = isset($_POST['tpindo']) ? $_POST['tpindo'] : '';
            $indorc = isset($_POST['indorc']) ? $_POST['indorc'] : '';
            $tpnoco = isset($_POST['tpnoco']) ? $_POST['tpnoco'] : '';
            $dsnoco = isset($_POST['dsnoco']) ? $_POST['dsnoco'] : '';
            $sgrifc = isset($_POST['sgrifc']) ? $_POST['sgrifc'] : '';

            Occorp::updateOrderRowFullInfo($nuordc, $nurorc, $dtmcli, $tpindo, $indorc, $tpnoco, $dsnoco, $sgrifc);

            $showRowDelivery = $this->utility->getAppSettings('ParamQuantityDeliveryView');
            $showRowIndicative = $this->utility->getAppSettings('ParamQuantityIndicativeView');
            $showRowNotes = $this->utility->getAppSettings('ParamQuantityNotesView');
            $showRowReference = $this->utility->getAppSettings('ParamQuantityReferenceView');

            $info = Occorp::getOrderRowInfoFromNuordcAndNurorc($nuordc, $nurorc);

            $text = '';
            if ($showRowDelivery > 0 && $info->dtmcli != '00/00/0000') {
                if ($showRowDelivery == 1) {
                    $text .= (!empty($text) ? ' - ' : '') . $this->translate('_common.delivery') . ': ' . $info->dtmcli;
                } else if ($showRowDelivery == 2 && !empty($info->dsscad)) {
                    $text .= (!empty($text) ? ' - ' : '') . $this->translate('_common.delivery') . ': ' . $info->dsscad;
                }
            }
            if ($showRowIndicative > 0) {
                if ($showRowIndicative == 1 && !empty($info->indorc)) {
                    $text .= (!empty($text) ? ' - ' : '') . $this->translate('_common.indicative') . ': ' . $info->indorc;
                } else if ($showRowIndicative == 2 && $info->dsindo != '') {
                    $text .= (!empty($text) ? ' - ' : '') . $this->translate('_common.indicative') . ': ' . $info->dsindo;
                }
            }
            if ($showRowNotes > 0) {
                if ($showRowNotes == 1 && !empty($info->dsnoco)) {
                    $text .= (!empty($text) ? ' - ' : '') . $this->translate('_common.notes') . ': ' . $info->dsnoco;
                } else if ($showRowNotes == 2 && $info->noccom_dsnoco != '') {
                    $text .= (!empty($text) ? ' - ' : '') . $this->translate('_common.notes') . ': ' . $info->noccom_dsnoco;
                }
            }
            if ($showRowReference > 0 && !empty($info->sgrifc)) {
                $text .= (!empty($text) ? ' - ' : '') . $this->translate('_common.reference') . ': ' . $info->sgrifc;
            }

            echo json_encode(array('response' => 'OK', 'text' => $text));
        }
    }

    public function getBulkInsertModalAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nurorcs = $_POST['nurorcs'];
            $tglini = $_POST['tglini'];
            $tglfin = $_POST['tglfin'];

            $sizes = Postgl::getSizesWithPricesFromNurorc($nurorcs[0]);


            $auth = $this->session->get('auth');
            $nulist = Octest::findOrderInProgress($auth['id'])->nulist;

            $showCatalogPrice = $this->utility->getAppSettings('ParamShowPriceCatalog');
            $html = $this->getHtmlBulkInsertContent($sizes, $tglini, $tglfin, $nulist, $showCatalogPrice);

            echo json_encode(array('response' => 'OK', 'html' => $html));
        }
    }

    private function getHtmlBulkInsertContent($sizes, $tglini, $tglfin, $nulist, $showCatalogPrice)
    {
        $html =
            "<div class='col-12'>
        <div class='row wizard-header-row'>
          <div class='col'>" . $this->translate('_common.sizes.qty') . "</div>" .
            ($showCatalogPrice ? "<div class='col'>" . $this->translate('_common.price') . "</div>" : '') .
            "<div class='col'>" . $this->translate('_common.qty.art') . "</div>
        </div>
      </div>";

        $bg = '#fafafa';
        for ($i = 0; $i < count($sizes); $i++) {
            $bg = $bg == '#fafafa' ? '#fff' : '#fafafa';
            $size = $sizes[$i];

            $disabled = (($i + 1) < $tglini && $tglini != 0) || (($i + 1) > $tglfin && $tglfin != 0);

            $html .=
                '<div class="col-12">
          <div class="row insert-quantity-row is-size ' . ($disabled ? 'size-disabled' : '') . '" style="background-color:' . $bg . '"
            data-disp="-1" data-qtamin="0" data-qtamul="1">
            <div class="col">' . $size->taglia . '</div>';

            if ($showCatalogPrice == 1) {
                $html .= '<div class="col">' . $this->utility->getFormattedPrice($nulist, $size->prezzo)['value'] . '</div>';
            }

            $html .=
                "<div class='col'>
          <div class='btn-number minus-qty disabled' data-type='minus'><i class='fa fa-minus' aria-hidden='true'></i></div>
          <div class='float-left w-40'>
            <input type='text' class='input-number' data-old_value='' data-taglia='" . $size->taglia . "' name='quantity' min='0' step='1'
            value='' " . ($disabled ? 'disabled' : '') . ">
          </div>
          <div class='btn-number plus-qty " . ($disabled ? 'disabled' : 'enabled') . "' data-type='plus'><i class='fa fa-plus' aria-hidden='true'></i></div>
        </div>";

            if ($this->utility->getAppSettings('EnableMinMulLabel') > 0) {
                $html .= "<div class='regqta-info'>";
                $html .= $this->translate('_common.qty.min.short') . ': 1, ';
                $html .= $this->translate('_common.qty.mul.short') . ': 1';
                $html .= "</div>";
            }

            $html .=
                '</div>
        </div>';
        }

        return $html;
    }

    public function saveBulkQuantityAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nurorcs = explode(',', $_POST['nurorcs']);
            $octagl = $_POST['octagl'];

            foreach ($octagl as $size) {
                Octagl::updateQuantitySizeMoreRows($size['taglia'], $size['quanti'] != '' ? $size['quanti'] : 0, $nurorcs);
            }

            Occorp::updateMultipleOrderRows($nurorcs);

            echo json_encode('OK');
        }
    }

    public function updateRowShippingAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cddesm = isset($_POST['cddesm']) ? $_POST['cddesm'] : '';
            $nurorc = $_POST['nurorc'];
            Occorp::updateRowShipping($nurorc, $cddesm);
            echo json_encode('OK');
        }
    }
    //endregion

    //region Promo functions

    public function toggleDiscountsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nuordc = $_POST['nuordc'];
            $flnosc = $_POST['flnosc'];
            Octest::toggleDiscounts($nuordc, $flnosc);
            echo json_encode('OK');
        }
    }

    public function applyCouponAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $dscoup = $_POST["dscoup"];
            $qtatot = $_POST["qtatot"];
            $cdcata = $_POST["cdcata"];
            $auth = $this->session->get('auth');
            $user = B2bSysusr::findFirstById($auth['id']);

            // search all existing coupons for that name (priority is tpuser, cdcoup)
            $coupon = B2bCoupon::getCoupon($dscoup, $qtatot);

            if ($coupon) {
                $coupon_ok = false;
                foreach ($coupon as $el) {
                    $usrcpn = false;
                    if ($el->tpuser >= 5 && $user->type == 5) {
                        // shippings
                        if ($el->tpuser == 6) {
                            $usrcpn = B2bUsrcpn::getUserCoupon($auth['id'], $el->cdcoup, $el->usrmax > 0);
                        }

                        // if exist check if it can be used for this catalog
                        if (($el->tpuser == 5 || $usrcpn) && ($el->tpcata == 0 || B2bCtlcpn::isCouponPresentInCatalog($cdcata, $el->cdcoup))) {
                            $coupon_ok = $el;
                            break; // we've done, no more operations
                        }
                    } else if ($el->tpuser >= 3 && $user->type == 4) {
                        // customers
                        if ($el->tpuser == 4) {
                            $usrcpn = B2bUsrcpn::getUserCoupon($auth['id'], $el->cdcoup, $el->usrmax > 0);
                        }

                        // if exist check if it can be used for this catalog
                        if (($el->tpuser == 3 || $usrcpn) && ($el->tpcata == 0 || B2bCtlcpn::isCouponPresentInCatalog($cdcata, $el->cdcoup))) {
                            $coupon_ok = $el;
                            break; // we've done, no more operations
                        }
                    } else if ($el->tpuser >= 1 && $user->type == 3) {
                        // agents
                        if ($el->tpuser == 2) {
                            $usrcpn = B2bUsrcpn::getUserCoupon($auth['id'], $el->cdcoup, $el->usrmax > 0);
                        }

                        // if exist check if it can be used for this catalog
                        if (($el->tpuser == 1 || $usrcpn) && ($el->tpcata == 0 || B2bCtlcpn::isCouponPresentInCatalog($cdcata, $el->cdcoup))) {
                            $coupon_ok = $el;
                            break; // we've done, no more operations
                        }
                    } else {
                        // if exist check if it can be used for this catalog
                        if ($el->tpcata == 0 || B2bCtlcpn::isCouponPresentInCatalog($cdcata, $el->cdcoup)) {
                            $coupon_ok = $el;
                            break; // we've done, no more operations
                        }
                    }
                }

                if ($coupon_ok) {
                    if ($coupon_ok->cpnmax > 0) {
                        // decrease counter if there is limit for coupon
                        $coupon_ok->cpncnt = $coupon_ok->cpncnt - 1;
                        $coupon_ok->save();
                    } else if ($coupon_ok->usrmax > 0) {
                        // decrease counter if there is limit for user
                        $usrcpn = B2bUsrcpn::getUserCoupon($auth['id'], $coupon_ok->cdcoup);
                        if ($usrcpn) {
                            $usrcpn->applcp = $usrcpn->applcp - 1;
                            $usrcpn->save();
                        }
                    }

                    $octest = Octest::findOrderInProgress($auth['id']);
                    $octest->cdcoup = $coupon_ok->cdcoup;
                    $octest->save();

                    echo json_encode("OK");
                } else {
                    echo json_encode("ER");
                }
            } else {
                echo json_encode("ER");
            }
        }
    }

    public function removeCouponAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $auth = $this->session->get('auth');
            Octest::removeCoupon($auth['id']);
            echo json_encode("OK");
        }
    }

    public function getPromoDetailAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdprom = $_POST['cdprom'];
            $nuordc = $_POST['nuordc'];
            $pvtest = Pvtest::findFirstByCdprom($cdprom);

            $response = array('response' => 'ER');
            $octest = Octest::findFirstByNuordc($nuordc);
            $nulist = $octest->nulist;
            $html = '';
            switch ($pvtest->tputil) {
                case 'OT':
                case 'SL':
                    // not implemented;
                    break;
                case 'CA':
                    $articles = $this->utility->getCAPromoDetail($cdprom, $octest->cdcata, $nuordc, $nulist, $octest->tpordc);
                    if (count($articles) > 0) {
                        $html = $this->getHtmlCAPromoContent($articles, $nulist, $octest->tpordc);
                        $response = array('response' => 'OK', 'type' => 'CA', 'html' => $html);
                    }
                    break;
                case 'OC':
                    $articles = array();
                    $steps = array();
                    $merged = array();
                    $this->utility->getOCPromoDetail($cdprom, $nuordc, $articles, $steps, $merged);
                    if (count($articles) > 0 && count($steps) > 0 && count($merged) > 0) {
                        $html = $this->getHtmlOCPromoModal($steps, $nulist);
                        $this->getHtmlOCPromoModalArticles($articles, $merged, $nulist, $html_art, $html_mrg);
                        $response = array('response' => 'OK', 'type' => 'OC', 'html' => $html, 'html_art' => $html_art, 'html_mrg' => $html_mrg);
                    }
                    break;
                case 'DN':
                    $promo = Pvcorp::getPromoDetailsForDNPromo($cdprom, $nuordc);
                    if (count($promo) > 0) {
                        $html = $this->getHtmlDNPromoModal($promo, $nulist);
                        $response = array('response' => 'OK', 'type' => 'DN', 'html' => $html);
                    }
                    break;
            }

            echo json_encode($response);
        }
    }
    //endregion

    //region Html for model wizard

    private function getHtmlCAPromoContent($articles, $nulist, $tpordc)
    {
        // Check number of steps
        $steps = count(explode(';', $articles[0]['scont1']));

        // Get fullfilled step
        $curr_steps = array();
        for ($i = 0; $i < count($articles); $i++) {
            $qty = explode(';', $articles[$i]['quanti']);
            $val = explode(';', $articles[$i]['valore']);
            // Create an array with every condition and fullfilled step
            $curr_steps[$i] = -1;
            for ($j = 0; $j < count($qty) && $j < count($val); $j++) {
                if ($articles[$i]['ord_quanti'] >= $qty[$j] && $articles[$i]['ord_valore'] >= $val[$j]) {
                    $curr_steps[$i] = $j;
                }
            }
        }

        // Get the minimum fullfilled step from the array
        $curr_step = $curr_steps[0];
        for ($i = 0; $i < count($curr_steps); $i++) {
            if ($curr_steps[$i] < $curr_step)
                $curr_step = $curr_steps[$i];
        }

        // Create header
        $html =
            '<div class="row model-list-row text-uppercase text-center" style="padding:0;margin:0 5%">
      <div class="col-2" style="line-height:60px">' . $this->translate('_common.article') . '</div>';

        for ($i = 0; $i < $steps; $i++) {
            $html .=
                '<div class="col">
        <div class="row m-0" style="line-height:' . ($steps > 1 ? '30' : '60') . 'px">' .
                ($steps > 1 ? '<div class="col-12 p-0">' . $this->translate('_common.step') . ' ' . ($i + 1) . '</div>' : '') .
                '<div class="col-3 p-0">' . $this->translate('_common.discounts') . '</div>
          <div class="col-3 p-0">' . $this->translate('_common.price') . '</div>
          <div class="col-3 p-0">' . $this->translate('_common.quantity') . '</div>
          <div class="col-3 p-0">' . $this->translate('_common.value') . '</div>
        </div>
      </div>';
        }
        $html .= '
      <div class="col-1 text-right" style="line-height:60px">' . $this->translate('_common.price') . '</div>' .
            ($tpordc == 0 ? '<div class="col-1" style="line-height:60px">' . $this->translate('_common.availability') . '</div>' : '') .
            '<div class="col-2" style="line-height:60px">' . $this->translate('_common.quantity') . '</div>
    </div>';

        // Create description of the detail
        $prefix = $this->config->application->baseUri;
        foreach ($articles as $article) {
            $scont1 = explode(';', $article['scont1']);
            $scont2 = explode(';', $article['scont2']);
            $scont3 = explode(';', $article['scont3']);
            $prezzo = explode(';', $article['prezzo']);
            $qty = explode(';', $article['quanti']);
            $val = explode(';', $article['valore']);

            // price
            $withDiscount = false;
            if ($this->utility->getAppSettings('ParamShowPriceCatalog') == 1) {
                if ($article['catalogPrice'] < 0) {
                    $model_price = $this->translate('quantity.priceforsize.short');
                } else if ($article['catalogPrice'] == 0) {
                    $model_price = '-';
                } else {
                    $price = $this->utility->getFormattedPrice($nulist, $article['catalogPrice']);
                    $model_price = $price['value'];
                }
            } else {
                $model_price = '&nbsp;';
            }

            // images

            $imgurl = $this->utility->getImageModelLink($article['flimag']);
            $exist = $article['flimag'] != '' && file_exists('img/model/' . $article['flimag']);
            $imgurl = !$exist ? $this->config->application->baseUri . 'assets/img/default_model.jpg' : $imgurl;

            $data = "
        data-cdarti='" . $article['cdarti'] . "' data-nurorc='" . $article['nurorc'] . "'
        data-cdcolo='" . $article['cdcolo'] . "'
        data-qtamin='" . $article['qtamin'] . "' data-qtamul='" . $article['qtamul'] . "'
        data-flbloc='" . $article['aa_flbloc'] . "' data-flprom='" . $article['flprom'] . "'
        data-taglia='" . $article['taglia'] . "' data-prezzo='" . $article['catalogPrice'] . "' data-sconto='0' " .
                "data-disp='" . ($tpordc == 0 ? $article['availability'] : "-1") . "' ";

            $html .=
                '<div class="row insert-quantity-row text-center is-size" ' . $data . ' style="margin:0 5%">
          <div class="col-2 text-left">
            <div class="col-4 p-0 float-left"><img src="' . $imgurl . '" /></div>
            <div class="col-8 p-0 float-left" style="height:100%;display:flex;align-items:center">' . $article['cdarti'] . ' - ' . $article['dsarti'] . '</div>
          </div>';

            for ($j = 0; $j < $steps; $j++) {
                $price = '-';
                if ($prezzo[$j] > 0) {
                    $value = $this->utility->getFormattedPrice($nulist, $prezzo[$j]);
                    $price = $value['value'];
                }
                $html .=
                    '<div class="col">
          <div class="row m-0" style="line-height:60px">
            <div class="col-3 p-0">' .
                    ($scont1[$j] > 0 ? $scont1[$j] . '%' : '') .
                    ($scont2[$j] > 0 ? '+' . $scont2[$j] . '%' : '') .
                    ($scont3[$j] > 0 ? '+' . $scont3[$j] . '%' : '') .
                    '</div>
            <div class="col-3 p-0">' . $price . '</div>
            <div class="col-3 p-0">' . ($qty[$j] > 0 ? $qty[$j] : ' - ') . '</div>
            <div class="col-3 p-0">' . ($val[$j] > 0 ? $val[$j] : ' - ') . '</div>
          </div>
        </div>';
            }

            $price = '-';
            if ($article['catalogPrice'] > 0) {
                $value = $this->utility->getFormattedPrice($nulist, $article['catalogPrice']);
                $price = $value['value'];
            }

            $html .= '
        <div class="col-1 text-right" style="line-height:60px">' . $price . '</div>' .
                ($tpordc == 0 ? '<div class="col-1" style="line-height:60px">' . ($article['availability'] > 0 ? $article['availability'] : ' - ') . '</div>' : '') .
                '<div class="col-2 mt-15x">';

            if ($tpordc == 0 && $article['availability'] == 0) {
                $html .= "<span class='blocked'>" . $this->translate('_common.notavailable') . "</span>";
            } else if ($article['aa_flbloc'] > 0 || $article['tp_flbloc'] > 0) {
                $html .= "<span class='blocked'>" . $this->translate('quantity.blocked') . "</span>";
            } else if ($article['ctlg_presence'] < 0) {
                $html .= "<span class='blocked'>" . $this->translate('quantity.notincatalog') . "</span>";
            } else {
                if ($article['ord_quanti'] > 0) {
                    $minus_cls = 'enabled';
                } else {
                    $minus_cls = 'disabled';
                }
                if (
                    $tpordc == 1 ||
                    ($article['ord_quanti'] < $article['availability'] && ($article['qtamin'] <= $article['availability'] && $article['ord_quanti'] + $article['qtamul'] <= $article['availability']))
                ) {
                    $plus_cls = 'enabled';
                } else {
                    $plus_cls = 'disabled';
                }
                $html .=
                    "<div class='btn-number minus-qty $minus_cls ' data-type='minus'><i class='fa fa-minus' aria-hidden='true'></i></div>
            <div class='float-left w-40'>
              <input type='text' class='input-number " . ($tpordc == 0 && $article['ord_quanti'] > $article['availability'] ? 'over-max ' : '') . "' " .
                    ($minus_cls == 'disabled' && $plus_cls == 'disabled' ? 'disabled ' : '') .
                    "data-old_value='" . ($article['ord_quanti'] > 0 ? $article['ord_quanti'] : "") . "'
                value='" . ($article['ord_quanti'] > 0 ? $article['ord_quanti'] : '') . "' min='0' " . ($tpordc == 0 ? "max='" . $article['availability'] . "'" : '') . ">
            </div>
            <div class='btn-number plus-qty $plus_cls ' data-type='plus'><i class='fa fa-plus' aria-hidden='true'></i></div>";

                if ($this->utility->getAppSettings('EnableMinMulLabel') > 0) {
                    $html .= "<div class='regqta-info'>";
                    $html .= $this->translate('_common.qty.min.short') . ': ' . $article['qtamin'] . ', ';
                    $html .= $this->translate('_common.qty.mul.short') . ': ' . $article['qtamul'];
                    if (isset($article['qtamax']) && $article['qtamax'] > 0) {
                        $html .= ', ' . $this->translate('_common.qty.max.short') . ': ' . $article['qtamax'];
                    }
                    $html .= "</div>";
                }
            }

            $html .= "</div>
                </div>
              </div>";
        }

        return $html;
    }

    private function getHtmlOCPromoModal($steps, $nulist)
    {
        // Create header
        $html =
            '<div class="row m-0">
        <div class="col-12 font-weight-bold pb-20x">' . $this->translate('promo.conditions') . '</div>
      </div>
      <div class="row font-weight-bold pb-10x fs12 m-0">
        <div class="list-prm-detail">' . $this->translate('_common.discount') . ' 1</div>
        <div class="list-prm-detail">' . $this->translate('_common.discount') . ' 2</div>
        <div class="list-prm-detail">' . $this->translate('_common.discount') . ' 3</div>
        <div class="list-prm-detail">' . $this->translate('promo.unitaryprice') . '</div>
        <div class="list-prm-detail">' . $this->translate('promo.commission') . '</div>
        <div class="list-prm-detail" style="margin-left:5%">' . $this->translate('promo.qty') . '</div>
        <div class="list-prm-detail">' . $this->translate('promo.value') . '</div>
      </div>';
        foreach ($steps as $step) {
            $preven = '-';
            $valore = '-';
            if ($step['preven'] > 0) {
                $value = $this->utility->getFormattedPrice($nulist, $step['preven']);
                $preven = $value['value'];
            }
            if ($step['valore'] > 0) {
                $value = $this->utility->getFormattedPrice($nulist, $step['valore']);
                $valore = $value['value'];
            }
            $html .=
                '<div class="row m-0">
        <div class="list-prm-detail">' . ($step['scont1'] > 0 ? $step['scont1'] . ' %' : '-') . '</div>
        <div class="list-prm-detail">' . ($step['scont2'] > 0 ? $step['scont2'] . ' %' : '-') . '</div>
        <div class="list-prm-detail">' . ($step['scont3'] > 0 ? $step['scont3'] . ' %' : '-') . '</div>
        <div class="list-prm-detail">' . $preven . '</div>
        <div class="list-prm-detail">' . ($step['provvi'] > 0 ? $step['provvi'] . ' %' : '-') . '</div>
        <div class="list-prm-detail" style="margin-left:5%">' . $step['quanti'] . '</div>
        <div class="list-prm-detail">' . $valore . '</div>';
            if ($step['fullfi']) {
                $html .= '<div class="tick-prm"><img src="' . $this->config->application->baseUri . '/assets/img/tick.png"/></div>';
            }
            $html .= '</div>';
        }

        return $html;
    }
    //endregion

    //region Html for bulk insert

    private function getHtmlOCPromoModalArticles($articles, $merged, $nulist, &$html_art, &$html_mrg)
    {
        $totAllQty = 0;
        $totAllVal = 0;
        $totOrdQty = 0;
        $totOrdVal = 0;
        $totMrgQty = 0;
        $totMrgVal = 0;

        $html = '';
        foreach ($articles as $article) {
            $valore = '-';
            if ($article['valore'] > 0) {
                $value = $this->utility->getFormattedPrice($nulist, $article['valore']);
                $valore = $value['value'];
            }
            $html .=
                '<div class="articles-row mb-5x ' . ($article['quanti'] == 0 ? 'art-not-ord' : '') . ' "
        data-code="' . $article['cdarti'] . '" data-quantity="' . $article['quanti'] . '" data-value="' . $article['valore'] . '">
        <div class="list-prm-article">' . $article['cdarti'] . ' ' . $article['dsarti'] . '</div>
        <div class="list-prm-detail" style="margin-left:5%">' . $article['quanti'] . '</div>
        <div class="list-prm-detail">' . $valore . '</div>
        </div>';
            $totAllQty += $article['quanti'];
            $totAllVal += $article['valore'];
            if ($article['quanti'] > 0) {
                $totOrdQty += $article['quanti'];
                $totOrdVal += $article['valore'];
            }
        }

        $valore = '-';
        if ($totAllVal > 0) {
            $value = $this->utility->getFormattedPrice($nulist, $totAllVal);
            $valore = $value['value'];
        }

        $header =
            '<div class="font-weight-bold mb-10x" id="tot-not-ord">
        <div class="list-prm-article">&nbsp;</div>
        <div class="list-prm-detail" style="margin-left:5%">' . $totAllQty . '</div>
        <div class="list-prm-detail">' . $valore . '</div>
      </div>';

        $valore = '-';
        if ($totOrdVal > 0) {
            $value = $this->utility->getFormattedPrice($nulist, $totOrdVal);
            $valore = $value['value'];
        }

        $header .=
            '<div class="font-weight-bold mb-10x" id="tot-ord" style="display:none">
        <div class="list-prm-article">&nbsp;</div>
        <div class="list-prm-detail" style="margin-left:5%">' . $totOrdQty . '</div>
        <div class="list-prm-detail">' . $valore . '</div>
      </div>';

        $html_art = $header . $html;

        $html = '';
        foreach ($merged as $mrg) {
            $html .= '<div class="merged-row mb-5x" data-code="' . $mrg['cdinpu'] . '" data-quantity="' . $mrg['quanti'] . '" data-value="' . $mrg['valore'] . '">';

            $text = '';
            switch ($mrg['tpinpu']) {
                case 'TL':
                    $text = $this->translate('_common.brand');
                    break;
                case 'LI':
                    $text = $this->translate('_common.line');
                    break;
                case 'SE':
                    $text = $this->translate('_common.series');
                    break;
                case 'TM':
                    $text = $this->translate('_common.modeltype');
                    break;
                case 'AN':
                    $text = $this->translate('_common.model');
                    break;
                case 'AR':
                    $text = $this->translate('_common.article');
                    break;
                case 'TV':
                    $text = $this->translate('_common.selltype');
                    break;
                case 'MI':
                    $text = $this->translate('_common.measurecode');
                    break;
                case 'CO':
                    $text = $this->translate('_common.colorcode');
                    break;
            }

            $valore = '-';
            if ($mrg['valore'] > 0) {
                $value = $this->utility->getFormattedPrice($nulist, $mrg['valore']);
                $valore = $value['value'];
            }

            $html .=
                '<div class="list-prm-article">' . $text . ' - ' . $mrg['cdinpu'] . '</div>
        <div class="list-prm-detail" style="margin-left:5%">' . $mrg['quanti'] . '</div>
        <div class="list-prm-detail">' . $valore . '</div>
      </div>';

            $totMrgQty += $mrg['quanti'];
            $totMrgVal += $mrg['valore'];
        }

        $valore = '-';
        if ($totMrgVal > 0) {
            $value = $this->utility->getFormattedPrice($nulist, $totMrgVal);
            $valore = $value['value'];
        }

        $header =
            '<div class="font-weight-bold mb-10x">
        <div class="list-prm-article">&nbsp;</div>
        <div class="list-prm-detail" style="margin-left:5%">' . $totMrgQty . '</div>
        <div class="list-prm-detail">' . $valore . '</div>
      </div>';

        $html_mrg = $header . $html;
    }
    //endregion

    //region Html for order row info modal

    private function getHtmlDNPromoModal($promo, $nulist)
    {
        // Check number of steps
        $steps = count(explode(';', $promo[0]['scont1']));

        // Get fullfilled step
        $curr_steps = array();
        for ($i = 0; $i < count($promo); $i++) {
            $qty = explode(';', $promo[$i]['quanti']);
            $val = explode(';', $promo[$i]['valore']);
            // Create an array with every condition and fullfilled step
            $curr_steps[$i] = -1;
            for ($j = 0; $j < count($qty) && $j < count($val); $j++) {
                if ($promo[$i]['ord_quanti'] >= $qty[$j] && $promo[$i]['ord_valore'] >= $val[$j]) {
                    $curr_steps[$i] = $j;
                }
            }
        }

        // Get the minimum fullfilled step from the array
        $curr_step = $curr_steps[0];
        for ($i = 0; $i < count($curr_steps); $i++) {
            if ($curr_steps[$i] < $curr_step)
                $curr_step = $curr_steps[$i];
        }

        // Create header
        $html =
            '<div class="row">
      <div class="col-12 font-weight-bold pb-20x">' . $this->translate('promo.conditions') . '</div>
    </div>
    <div class="row font-weight-bold">
      <div class="col-2 text-left" style="line-height:60px">' . $this->translate('_common.type') . '</div>
      <div class="col-2 text-left" style="line-height:60px">' . $this->translate('_common.description') . '</div>';

        for ($i = 0; $i < $steps; $i++) {
            $html .=
                '<div class="col">
        <div class="row m-0 ' . ($i == $curr_step ? 'prm-hl' : '') . '" style="line-height:' . ($steps > 1 ? '30' : '60') . 'px">' .
                ($steps > 1 ? '<div class="col-12 p-0">' . $this->translate('_common.step') . ' ' . ($i + 1) . '</div>' : '') .
                '<div class="col-3 p-0">' . $this->translate('_common.discounts') . '</div>
          <div class="col-3 p-0">' . $this->translate('_common.price') . '</div>
          <div class="col-3 p-0">' . $this->translate('_common.quantity') . '</div>
          <div class="col-3 p-0">' . $this->translate('_common.value') . '</div>
        </div>
      </div>';
        }
        $html .= '</div>';

        // Create description of the detail
        for ($i = 0; $i < count($promo); $i++) {
            $scont1 = explode(';', $promo[$i]['scont1']);
            $scont2 = explode(';', $promo[$i]['scont2']);
            $scont3 = explode(';', $promo[$i]['scont3']);
            $prezzo = explode(';', $promo[$i]['prezzo']);
            $qty = explode(';', $promo[$i]['quanti']);
            $val = explode(';', $promo[$i]['valore']);

            $html .=
                '<div class="row">
        <div class="col-2 text-left" style="line-height:60px">';

            switch ($promo[$i]['tpinpu']) {
                case 'TL':
                    $html .= $this->translate('_common.brand');
                    break;
                case 'LI':
                    $html .= $this->translate('_common.line');
                    break;
                case 'SE':
                    $html .= $this->translate('_common.series');
                    break;
                case 'TM':
                    $html .= $this->translate('_common.modeltype');
                    break;
                case 'AN':
                    $html .= $this->translate('_common.model');
                    break;
                case 'AR':
                    $html .= $this->translate('_common.article');
                    break;
            }

            $html .=
                '</div>
        <div class="col-2 text-left" style="line-height:60px">' . $promo[$i]['cdinpu'] . ' - ' . $promo[$i]['dsinpu'] . '</div>';

            for ($j = 0; $j < $steps; $j++) {
                $price = '-';
                if ($prezzo[$j] > 0) {
                    $value = $this->utility->getFormattedPrice($nulist, $prezzo[$j]);
                    $price = $value['value'];
                }
                $html .=
                    '<div class="col">
          <div class="row m-0 ' . ($j == $curr_step ? 'prm-hl' : '') . '" style="line-height:60px">
            <div class="col-3 p-0">' .
                    ($scont1[$j] > 0 ? $scont1[$j] . '%' : '') .
                    ($scont2[$j] > 0 ? '+' . $scont2[$j] . '%' : '') .
                    ($scont3[$j] > 0 ? '+' . $scont3[$j] . '%' : '') .
                    '</div>
            <div class="col-3 p-0">' . $price . '</div>
            <div class="col-3 p-0 ' . ($promo[$i]['ord_quanti'] >= $qty[$j] ? 'prm-ok' : 'prm-no') . '">' .
                    ($qty[$j] > 0 ? $promo[$i]['ord_quanti'] . '/' . $qty[$j] : ' - ') .
                    '</div>
            <div class="col-3 p-0 ' . ($promo[$i]['ord_valore'] >= $val[$j] ? 'prm-ok' : 'prm-no') . '">' .
                    ($val[$j] > 0 ? $promo[$i]['ord_valore'] . '/' . $val[$j] : ' - ') .
                    '</div>
          </div>
        </div>';
            }
            $html .= '</div>';
        }

        return $html;
    }

    public function updatePromoOrderAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdprom = $_POST['cdprom'];
            $nuordc = $_POST['nuordc'];
            $action = $_POST['action'];
            $method = $_POST['method'];

            if ($action == 'INSERT') {
                $ocprot = new Ocprot();
                $ocprot->nuordc = $nuordc;
                $ocprot->cdprom = $cdprom;

                if ($ocprot->save() === false) {
                    echo json_encode('IT');
                } else {
                    if ($this->utility->applyPromo($ocprot)) {
                        echo json_encode('OK');
                    } else {
                        echo json_encode('IC');
                    }
                }
            } else {
                $ocprot = Ocprot::find(array("nuordc = :nuordc: AND cdprom = :cdprom:", 'bind' => array('nuordc' => $nuordc, 'cdprom' => $cdprom)));
                if ($ocprot->delete() == false) {
                    echo json_encode('DT');
                } else {
                    $ocproc = Ocproc::findByNuordc($nuordc);

                    if ($ocproc->delete() == false) {
                        echo json_encode('DC');
                    } else {
                        echo json_encode('OK');
                    }
                }
            }
        }
    }

    public function refreshPromoAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $order_info = Octest::getCurrentOrder($this->session->get('auth')['id']);
            $promos = $this->utility->getPromos($order_info->nuordc, $order_info->tpanag, $order_info->cdanag);
            echo json_encode($promos);
        }
    }

    public function saverowsfrompromoAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $rows = $_POST['occorp'];

            $seqrap = 1 + Occorp::getMaxIndexForOrder($rows[0]['nuordc']);

            for ($i = 0; $i < count($rows); $i++) {
                $occorp = Occorp::findFirstByNurorc($rows[$i]['nurorc']);
                if ($occorp == false) {
                    $occorp = new Occorp();
                    $occorp->seqrap = $seqrap;
                    $seqrap++;
                }
                $occorp->nuordc = $rows[$i]['nuordc'];
                $occorp->cdarti = $rows[$i]['cdarti'];
                $occorp->cdcolo = $rows[$i]['cdcolo'];
                $occorp->cdvari = '';
                $occorp->cdcata = $rows[$i]['cdcata'];
                $occorp->quanti = $rows[$i]['quanti'];
                $occorp->seqdet = 1;
                $occorp->dtmcli = $rows[$i]['dtmcli'];
                $occorp->sgrifc = '';
                $occorp->tpindo = '';
                $occorp->indorc = '';
                $occorp->tpnoco = '';
                $occorp->dsnoco = '';
                $occorp->save();

                $octagl = Octagl::findByNurorc($occorp->nurorc);
                $octagl->delete();

                $octagl = new Octagl();
                $octagl->nurorc = $occorp->nurorc;
                $octagl->dstagl = $rows[$i]['octagl']['taglia'];
                $octagl->quanti = $rows[$i]['octagl']['quanti'];
                $octagl->prezzo = $rows[$i]['octagl']['prezzo'];
                $octagl->scont1 = 0;
                $octagl->scont2 = 0;
                $octagl->scont3 = 0;
                $octagl->save();
            }

            echo json_encode('OK');
        }
    }
    //endregion
}
