<?php

namespace Go2B\Controllers;

use Go2B\Library\SimpleCsv;
use Go2B\Library\Translator;
use Go2B\Models\Anaage;
use Go2B\Models\Anaart;
use Go2B\Models\Anagra;
use Go2B\Models\Ananaz;
use Go2B\Models\Anaper;
use Go2B\Models\Anazon;
use Go2B\Models\Artcla;
use Go2B\Models\Artcol;
use Go2B\Models\Artcrt;
use Go2B\Models\B2bAddinf;
use Go2B\Models\B2bAppset;
use Go2B\Models\B2bApputi;
use Go2B\Models\B2bBgcorp;
use Go2B\Models\B2bBgtest;
use Go2B\Models\B2bCatimg;
use Go2B\Models\B2bClassificazione;
use Go2B\Models\B2bColors;
use Go2B\Models\B2bCoupon;
use Go2B\Models\B2bCsmenu;
use Go2B\Models\B2bCtlcpn;
use Go2B\Models\B2bCtllog;
use Go2B\Models\B2bCuspag;
use Go2B\Models\B2bCuspor;
use Go2B\Models\B2bDisana;
use Go2B\Models\B2bDisbdy;
use Go2B\Models\B2bDisctl;
use Go2B\Models\B2bDishea;
use Go2B\Models\B2bDislst;
use Go2B\Models\B2bDispag;
use Go2B\Models\B2bDispor;
use Go2B\Models\B2bFlcorp;
use Go2B\Models\B2bFltest;
use Go2B\Models\B2bFlvisi;
use Go2B\Models\B2bGlcorp;
use Go2B\Models\B2bGltest;
use Go2B\Models\B2bHpcorp;
use Go2B\Models\B2bHptest;
use Go2B\Models\B2bMngpar;
use Go2B\Models\B2bModevi;
use Go2B\Models\B2bModinf;
use Go2B\Models\B2bReqacc;
use Go2B\Models\B2bSscorp;
use Go2B\Models\B2bSstest;
use Go2B\Models\B2bSysusr;
use Go2B\Models\B2bTipval;
use Go2B\Models\B2bUsrage;
use Go2B\Models\B2bUsrana;
use Go2B\Models\B2bUsrcpn;
use Go2B\Models\B2bUsrctl;
use Go2B\Models\B2bUsrdsm;
use Go2B\Models\B2bBramod;
use Go2B\Models\Ctarti;
use Go2B\Models\Cttest;
use Go2B\Models\Desart;
use Go2B\Models\Deslin;
use Go2B\Models\Desmer;
use Go2B\Models\Imgart;
use Go2B\Models\Indorc;
use Go2B\Models\Linmod;
use Go2B\Models\Lscorp;
use Go2B\Models\Lstest;
use Go2B\Models\Modvar;
use Go2B\Models\Ocasso;
use Go2B\Models\Occorp;
use Go2B\Models\Ocperc;
use Go2B\Models\Octagl;
use Go2B\Models\Octest;
use Go2B\Models\Postgl;
use Go2B\Models\Regqta;
use Go2B\Models\Regqtm;
use Go2B\Models\Regvar;
use Go2B\Models\Scacon;
use Go2B\Models\Sermod;
use Go2B\Models\Smcorp;
use Go2B\Models\Sparti;
use Go2B\Models\Spmate;
use Go2B\Models\Tabstg;
use Go2B\Models\Tabvar;
use Go2B\Models\Tipcla;
use Go2B\Models\Tipolo;
use Go2B\Models\Tipvar;
use Go2B\Models\Titlin;
use Go2B\Models\Tpcomp;
use Go2B\Models\Tpcrar;
use Go2B\Models\Tpgene;
use Go2B\Models\Tpmode;
use Go2B\Models\Tpmvar;
use Go2B\Models\Tppaga;
use Go2B\Models\Tpport;
use Phalcon\Db\RawValue;
use Phalcon\Http\Request;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use Phalcon\Di;

class AdminController extends AdminBase
{
    //region Views functions
    public function adminAction()
    {
        $this->view->admins = B2bSysusr::findByType(2);
        $this->view->canDelete = $this->session->get('auth')['type'] == 1;
        $this->view->setVars($this->getCommonVars());
    }
    public function syncronizeAction()
    {
        $this->view->admins = B2bSysusr::findByType(2);
        $this->view->canDelete = $this->session->get('auth')['type'] == 1;
        $this->view->setVars($this->getCommonVars());
    }

    //region Views functions
    public function usersAction()
    {
        //$isSuperadmin = $this->session->get('auth')['type'] == 1;

        if (!$this->getIsSuperAdmin()) {
            $this->response->redirect('admin/admin')->send();
            exit();
        }

        $this->view->users = B2bSysusr::find();
        $this->view->isSuperAdmin = $this->getIsSuperAdmin();
        $this->view->loggeduserType = $this->session->get('auth')['type'];
        $this->view->setVars($this->getCommonVars());
    }

    public function agentsAction()
    {
        $agents = Anaage::getAllStandardAgents();

        //$full_agents = array();
        //foreach ($agents as $key => $value) {
        //  $agents[$key]->catalogs = Cttest::getAllCatalogsForAgent($value->cdagen);
        //  $full_agents[] = $value;
        //}

        $headoffices = Anaage::getAllHeadOfficeAgents();

        //$full_headoffices = array();
        //foreach ($headoffices as $key => $value) {
        //  $headoffices[$key]->catalogs = Cttest::getAllCatalogsForAgent($value->cdagen);
        //  $full_headoffices[] = $value;
        //}

        //$catalogs = Cttest::find();
        $lstests = Lstest::find();

        $this->view->agents = $agents;
        $this->view->headoffices = $headoffices;
        //$this->view->catalogs     = $catalogs;
        $this->view->lstests = $lstests;
        $this->view->differentBehaviours = $this->utility->getAppSettings('EnableDifferentBehaviourForAgent') == 1;
        $this->view->selectablePriceLists = $this->utility->getAppSettings('PriceListsManagementForAgent') == 1;

        $this->view->setVars($this->getCommonVars());
    }

    public function agentsListAction()
    {
        $agents = Anaage::find();
        $lstest = Lstest::find();

        $this->view->setVars($this->getCommonVars());
        $this->view->agents = $agents;
        $this->view->lstest = $lstest;
    }

    public function analysisAction()
    {
        $elements = array(
            'agents' => Anaage::getAllAgents(),
            'brands' => Titlin::getAllBrands(),
            'catalogs' => Cttest::getAllMinimalCatalogs(),
            'countries' => Ananaz::getAllCountries(),
            'customers' => Anagra::getAllCustomers(),
            'genres' => Tpgene::getAllGenres(),
            'lines' => Linmod::getAllLines(),
            'modeltypes' => Tpmode::getAllModelTypes(),
            'ordertypes' => array(
                ['code' => 0, 'value' => $this->translate('order.availability')],
                ['code' => 1, 'value' => $this->translate('order.reservation')],
            ),
            'series' => Sermod::getAllSeries(),
        );

        $this->view->elements = $elements;

        $enableSpecialStats = $this->utility->getAppSettings('EnableSpecialStats');
        if ($enableSpecialStats == 1) {
            $this->view->spsCatalogs = $elements['catalogs'];
            $this->view->spsSeasons = Tabstg::getAllSeasons();
            $this->view->spsChannels = Anagra::getAllChannels();
            $this->view->spsDrops = Indorc::getAllDrops();
            $this->view->spsBrands = $elements['brands'];
            $this->view->spsLines = $elements['lines'];
            $this->view->spsSeries = $elements['series'];
            $this->view->spsModelTypes = $elements['modeltypes'];
        }
        $this->view->enableSpecialStats = $enableSpecialStats > 0;

        $this->view->setVars($this->getCommonVars());
    }

    public function bannereditorAction()
    {
        $this->view->banner = $this->utility->getAppUtils('banner');

        $this->view->setVars($this->getCommonVars());
    }

    public function blockedItemsAction()
    {
        $this->view->fabrics = Anaper::getAllFabrics();
        $this->view->colors = Artcol::getAllFabricColors();

        $this->view->setVars($this->getCommonVars());
    }

    public function budgetAction()
    {
        $this->view->customers = Anagra::find();
        $this->view->refSeasons = B2bBgtest::getReferenceSeasons();
        $this->view->cmpSeasons = B2bBgcorp::getComparingSeasons();
        $this->view->lines = Linmod::getAllLines();
        $this->view->drops = B2bBgtest::getAllDrops();

        $this->view->setVars($this->getCommonVars());
    }

    public function catalogspageAction()
    {
        $id_usr = $this->session->get('auth')['id'];
        $this->view->cttest = Cttest::getAllAvailableCatalogs();
        $this->view->b2bctim = B2bCatimg::getCatalogsPresentation($id_usr);

        $this->view->setVars($this->getCommonVars());
    }

    public function categoryBannerAction()
    {
        $category = $this->dispatcher->getParam('category') !== null ? $this->dispatcher->getParam('category') : '';

        $this->view->category = $category;

        $this->view->setVars($this->getCommonVars());
    }

    public function checkPricesAction()
    {
        $this->view->articles = Occorp::getAllArticlesWithNoPrice();
        $this->view->catalogs = Cttest::find();
        $this->view->seasons = Tabstg::find();

        $this->view->setVars($this->getCommonVars());
    }

    public function colorpickerAction()
    {
        switch ($this->utility->getAppSettings('ColorAssignmentSource')) {
            case 0:
                $this->view->colors = Anaart::getArticleColors('dscolo');
                break;
            case 1:
                $this->view->colors = Anaart::getArticleColors('cdcolo');
                break;
            case 2:
                $this->view->colors = Artcol::getAllColors();
                break;
        }

        $this->view->setVars($this->getCommonVars());
    }

    public function couponAction()
    {
        $agents = Anaage::getAllEnabledAgents();

        $full_agents = array();
        foreach ($agents as $key => $value) {
            $agents[$key]->catalogs = Cttest::getAllCatalogsForAgent($value->cdagen);
            $full_agents[] = $value;
        }

        // Customers
        $customers = Anagra::getAllEnabledCustomers();

        $full_customers = array();
        if (count($customers) > 0) {
            foreach ($customers as $key => $value) {
                $customers[$key]->catalogs = Cttest::getAllCatalogsForCustomer($value->tpanag, $value->cdanag);
                $full_customers[] = $value;
            }
        }

        // Shippings
        $shippings = Desmer::getAllEnabledShippings();

        $full_shippings = array();
        if (count($shippings) > 0) {
            foreach ($shippings as $key => $value) {
                $shippings[$key]->catalogs = Cttest::getAllCatalogsForShipping($value->cddesm);
                $full_shippings[] = $value;
            }
        }

        $this->view->coupons = B2bCoupon::find();
        $this->view->agents = $full_agents;
        $this->view->customers = $full_customers;
        $this->view->shippings = $full_shippings;
        $this->view->catalogs = Cttest::find(array("dtiniz <= :dtoggi: AND dtfine >= :dtoggi:", "bind" => array('dtoggi' => date('Y-m-d'))));

        $this->view->setVars($this->getCommonVars());
    }

    public function customdiscountlistAction()
    {
        $this->view->discounts = B2bDishea::getAllCustomDiscounts();

        $this->view->setVars($this->getCommonVars());
    }

    public function customersAction()
    {
        $this->view->setVars($this->getCommonVars());
        $this->view->prefix = $this->utility->getAppUtils('prefix');
        $this->view->seasons = Tabstg::find();
        $this->view->catalogs = Cttest::find();
    }

    public function customfamilyAction()
    {
        $cdregv = $this->dispatcher->getParam('cdregv') !== null ? $this->dispatcher->getParam('cdregv') : '';

        $this->view->group = Regvar::findFirstByCdregv($cdregv);
        $this->view->families = Tipvar::getAllFamiliesByCdregv($cdregv);

        $this->view->setVars($this->getCommonVars());
    }

    public function customfltAction()
    {
        $tpfilt = $this->dispatcher->getParam('tpfilt') !== null ? $this->dispatcher->getParam('tpfilt') : '';

        $this->view->tpfilt = $tpfilt;

        $this->view->setVars($this->getCommonVars());
    }

    public function customgroupAction()
    {
        $this->view->familyGroups = Regvar::find();

        $this->view->setVars($this->getCommonVars());
    }

    public function customMenuAction()
    {
        $this->view->brands = Titlin::getAllBrandsWithLanguageDescriptions();
        $this->view->lines = Linmod::getAllLinesWithLanguageDescriptions();
        $this->view->series = Sermod::getAllSeriesWithLanguageDescriptions();
        $this->view->genres = Tpgene::getAllGenresWithLanguageDescriptions();
        $this->view->modelTypes = Tpmode::getAllModelTypesWithLanguageDescriptions();
        $this->view->selections = $this->utility->getAppSettings('SpecialSelections') > 0
            ? B2bSstest::find()
            : array();
        $this->view->catalogs = Cttest::find();

        $this->view->setVars($this->getCommonVars());
    }

    public function customPaymentAction()
    {
        $cus_payments = B2bCuspag::getAllCustomPayments();
        $full_payments = [];
        foreach ($cus_payments as $item) {
            $countries = [];
            $codiciNazioni = explode(',', isset($item['codici_nazioni']) ? $item['codici_nazioni'] : '');

            foreach ($codiciNazioni as $codiceNazione) {
                $ananaz = Ananaz::findFirstByCdnazi($codiceNazione);
                if ($ananaz) {
                    $countries[] = $ananaz;
                }
            }
            if ($countries === false || empty($countries)) {
                $fake_ananaz = new Ananaz();
                $fake_ananaz->cdnazi = 'ALL';
                $countries[] = $fake_ananaz;
            }

            $full_payments[] = (object)[
                'numpag' => $item['numpag'],
                'tppaga' => $item['tppaga'],
                'dspaga' => $item['dspaga'],
                'config' => $item['config'],
                'configuration' => (!empty($item['config']) ? json_decode($item['config']) : []),
                'countries' => $countries
            ];
        }

        $this->view->cus_payments = $full_payments;
        $this->view->def_payments = Tppaga::find();
        $this->view->countries = Ananaz::find();

        $this->view->setVars($this->getCommonVars());
        // Samuele Custom Payment x Prezzo, Quantità Peso,
        $this->view->customPayment = $this->utility->getAppSettings('customPayment');
    }

    public function customShipmentAction()
    {
        $cus_shipments = B2bCuspor::getAllCustomShipments();
        $full_shipments = [];
        foreach ($cus_shipments as $item) {
            $countries = [];
            $codiciNazioni = explode(',', isset($item['codici_nazioni']) ? $item['codici_nazioni'] : '');

            foreach ($codiciNazioni as $codiceNazione) {
                $ananaz = Ananaz::findFirstByCdnazi($codiceNazione);
                if ($ananaz) {
                    $countries[] = $ananaz;
                }
            }
            if ($countries === false || empty($countries)) {
                $fake_ananaz = new Ananaz();
                $fake_ananaz->cdnazi = 'ALL';
                $countries[] = $fake_ananaz;
            }

            $full_shipments[] = (object)[
                'numpor' => $item['numpor'],
                'tpport' => $item['tpport'],
                'dstpor' => $item['dstpor'],
                'config' => $item['config'],
                'configuration' => (!empty($item['config']) ? json_decode($item['config']) : []),
                'countries' => $countries
            ];
        }

        $this->view->cus_shipments = $full_shipments;
        $this->view->def_shipments = Tpport::find();
        $this->view->countries = Ananaz::find();
        // Samuele Custom Shipping x Prezzo, Quantità Peso,
        $this->view->customShipping = $this->utility->getAppSettings('custommShipping');

        $this->view->setVars($this->getCommonVars());
    }

    public function customvarAction()
    {
        $cdregv = $this->dispatcher->getParam('cdregv') !== null ? $this->dispatcher->getParam('cdregv') : '';
        $tpvari = $this->dispatcher->getParam('tpvari') !== null ? $this->dispatcher->getParam('tpvari') : '';

        $this->view->family = Tipvar::getFamilyByCdregvAndTpvari($cdregv, $tpvari);
        $this->view->customs = Tabvar::getAllCustomsByCdregvAndTpvari($cdregv, $tpvari);

        $this->view->setVars($this->getCommonVars());
    }

    public function customVariantsAction()
    {
        $customs = Anaart::getAllCustomArticles();

        $fullCustoms = array();
        for ($i = 0; $i < count($customs); $i++) {
            $currCustom = $customs[$i];
            $currCustom->features = Sparti::getAllFeatures($currCustom->cdarti);
            $currCustom->orders = Occorp::getOrdersAndQuantityForCustomArticle($currCustom->cdarti);
            $fullCustoms[] = $currCustom;
        }

        $this->view->variants = $fullCustoms;
        $this->view->features = Tpcomp::find();

        $this->view->setVars($this->getCommonVars());
    }

    public function customVariantsBisAction()
    {
        $customs = Anaart::getAllCustomArticles(true);

        $fullCustoms = array();
        for ($i = 0; $i < count($customs); $i++) {
            $currCustom = $customs[$i];
            $currCustom->features = Sparti::getAllFeatures($currCustom->cdarti);
            $currCustom->orders = Occorp::getOrdersAndQuantityForCustomArticle($currCustom->cdarti);
            $fullCustoms[] = $currCustom;
        }

        $this->view->variants = $fullCustoms;
        $this->view->features = Tpcomp::find();

        $this->view->setVars($this->getCommonVars());
    }

    public function dashboardAction()
    {
        // First row
        $tot = array(
            'age' => Anaage::getCountActiveAgents(),
            'art' => Anaart::getCountArticles(),
            'cat' => count(Cttest::getAllAvailableCatalogs()),
            'cus' => Anagra::getCountActiveCustomers(),
            'mod' => Tipolo::getTotalAvailableModels()
        );

        // Second row: overall analysis - Default: latest 1 month
        $dtiniz = date('Y-m-d');
        $dtfine = date('Y-m-d');
        $dtiniz = (new \DateTime('-29 days'))->format('Y-m-d');
        $oldest_ord = (new \DateTime('-29 days'))->format('d/m/Y');

        $qty = Occorp::getTotalOrdersQuantity($dtiniz, $dtfine);
        $ord = Octest::getCountAllOrders($dtiniz, $dtfine);
        $val = Octagl::getTotalValue($dtiniz, $dtfine);
        $anl = array(
            'aqo' => $ord > 0 ? round($qty / $ord, 2) : '-',
            'avo' => $ord > 0 ? round($val / $ord, 2) : '-',
            'avp' => $qty > 0 ? round($val / $qty, 2) : '-',
            'ord' => $ord,
            'qty' => $qty,
            'val' => $val
        );

        // Third row: trends
        $str_dtiniz = strtotime($dtiniz);
        $str_dtfine = strtotime($dtfine);
        $datediff = $str_dtfine - $str_dtiniz;
        $daysdiff = round($datediff / (60 * 60 * 24));
        $num_step = $daysdiff >= 15 ? 15 : $daysdiff;
        $len_step = $num_step < 15 ? 1 : $daysdiff / 15;

        $dates = array();
        $period_dtiniz = $dtiniz;
        for ($i = 0; $i < $num_step + 1; $i++) {
            $period_dtfine = date('Y-m-d', strtotime($dtiniz . ' +' . round($i * $len_step, 0) . ' days'));
            $dates[] = array('dtiniz' => $period_dtiniz, 'dtfine' => $period_dtfine);
            $period_dtiniz = $period_dtfine;
        }

        $trends = $this->getTrends($dates);

        // Fourth row: latest 10 orders
        $orders = Octest::getLatest10Orders();

        // Fifth row: latest 10 open orders
        $openOrders = Octest::getLatest10OpenOrders();

        $this->view->orderStateMgmt = $this->utility->getAppSettings('OrderStateManagement');

        $this->view->anl = $anl;
        $this->view->tot = $tot;
        $this->view->trends = $trends;
        $this->view->orders = $orders;
        $this->view->seasons = Tabstg::find();
        $this->view->openOrders = $openOrders;
        $this->view->today = date('d/m/Y');
        $this->view->oldest_ord = $oldest_ord;

        $this->view->setVars($this->getCommonVars());
    }

    public function defaultConditionsAction()
    {
        $this->view->startDate = $this->utility->getAppUtils('zan_date_start');
        $this->view->endDate = $this->utility->getAppUtils('zan_date_end');
        $this->view->defaultInd = $this->utility->getAppUtils('zan_default_ind');
        $this->view->indicatives = Indorc::find();

        $this->view->setVars($this->getCommonVars());
    }

    public function downloadAllOrdersXlsAction()
    {
        $this->view->type = $_POST['type'];
        $this->view->dtiniz = $_POST['dtiniz'];
        $this->view->dtfine = $_POST['dtfine'];
        $this->view->whose = $_POST['whose'];
        $this->view->whoseSet = isset($_POST['whoseSet']) ? rtrim($_POST['whoseSet'], ',') : -1;
        $this->view->status = isset($_POST['status']) ? $_POST['status'] : array();
        $this->view->setVars($this->getCommonVars());
    }

    public function downloadAnalysisXlsAction()
    {
        $this->view->data = $_POST['data'];
        $this->view->isArticle = $_POST['isArticle'];
        $this->view->setVars($this->getCommonVars());
    }

    public function downloadBudgetXlsAction()
    {
        $this->view->data = $_POST['data'];
        $this->view->type = $_POST['type'];
        $this->view->setVars($this->getCommonVars());
    }

    public function downloadJoorXlsOrderAction()
    {
        $this->view->nuordc = $_POST['nuordc'];
        $this->view->setVars($this->getCommonVars());
    }

    public function downloadModinfXlsTemplateAction()
    {
        set_time_limit(0);

        $models = Tipolo::getModelsWithFullInfo();

        $spreadsheet = new Spreadsheet();
        $spreadsheet->getProperties()->setCreator('Sinergiattiva')->setTitle($this->translate('admin.menu.productinfo'));
        $spreadsheet->getActiveSheet()->getProtection()->setSheet(true);
        $spreadsheet->getActiveSheet()->getStyle('F2:AB' . (count($models) + 1))->getProtection()->setLocked(\PhpOffice\PhpSpreadsheet\Style\Protection::PROTECTION_UNPROTECTED);

        $spreadsheet->setActiveSheetIndex(0);
        $activeSheet = $spreadsheet->getActiveSheet();
        $activeSheet->setTitle($this->translate('_common.models'));

        $activeSheet->freezePane('B2');
        $headerStyle = array(
            'fill' => array(
                'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                'color' => array('rgb' => 'DDDDDD')
            ),
            'borders' => array(
                'allBorders' => array(
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => array('argb' => 'FF606060'),
                ),
            ),
            'font' => array(
                'bold' => true
            ),
        );

        $descriptionStyle = array(
            'fill' => array(
                'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                'color' => array('rgb' => 'EEEEEE')
            ),
            'borders' => array(
                'allBorders' => array(
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => array('argb' => 'FF606060'),
                ),
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT
            )
        );

        $bodyStyle = array(
            'borders' => array(
                'allBorders' => array(
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => array('argb' => 'FF606060'),
                ),
            ),
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                'wrapText' => true,
            )
        );

        $lastLine = count($models) + 1;
        $activeSheet->getStyle('A1:AB1')->applyFromArray($headerStyle);
        $activeSheet->getStyle('A2:E' . $lastLine)->applyFromArray($descriptionStyle);
        $activeSheet->getStyle('F2:AB' . $lastLine)->applyFromArray($bodyStyle);
        $activeSheet->getStyle('Z2:AA' . $lastLine)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_DDMMYYYY);

        $activeSheet->calculateColumnWidths();
        $activeSheet->getColumnDimension('A')->setAutoSize(true);
        $activeSheet->getColumnDimension('B')->setAutoSize(true);
        $activeSheet->getColumnDimension('C')->setAutoSize(true);
        $activeSheet->getColumnDimension('D')->setAutoSize(true);
        $activeSheet->getColumnDimension('E')->setAutoSize(true);
        $activeSheet->getColumnDimension('F')->setWidth(50);
        $activeSheet->getColumnDimension('G')->setWidth(50);
        $activeSheet->getColumnDimension('H')->setWidth(50);
        $activeSheet->getColumnDimension('I')->setWidth(50);
        $activeSheet->getColumnDimension('J')->setWidth(50);
        $activeSheet->getColumnDimension('K')->setWidth(50);
        $activeSheet->getColumnDimension('L')->setWidth(50);
        $activeSheet->getColumnDimension('M')->setWidth(50);
        $activeSheet->getColumnDimension('N')->setWidth(50);
        $activeSheet->getColumnDimension('O')->setWidth(50);
        $activeSheet->getColumnDimension('P')->setWidth(50);
        $activeSheet->getColumnDimension('Q')->setWidth(50);
        $activeSheet->getColumnDimension('R')->setWidth(50);
        $activeSheet->getColumnDimension('S')->setWidth(50);
        $activeSheet->getColumnDimension('T')->setWidth(50);
        $activeSheet->getColumnDimension('U')->setWidth(15);
        $activeSheet->getColumnDimension('V')->setWidth(25);
        $activeSheet->getColumnDimension('W')->setWidth(25);
        $activeSheet->getColumnDimension('X')->setWidth(25);
        $activeSheet->getColumnDimension('Y')->setWidth(25);
        $activeSheet->getColumnDimension('Z')->setWidth(15);
        $activeSheet->getColumnDimension('AA')->setWidth(15);
        $activeSheet->getColumnDimension('AB')->setWidth(15);

        $activeSheet->getCell('A1')->setValue(ucwords($this->translate('_common.code')));
        $activeSheet->getCell('B1')->setValue(ucwords($this->translate('_common.brand')));
        $activeSheet->getCell('C1')->setValue(ucwords($this->translate('_common.line')));
        $activeSheet->getCell('D1')->setValue(ucwords($this->translate('_common.series')));
        $activeSheet->getCell('E1')->setValue(ucwords($this->translate('_common.season')));
        $activeSheet->getCell('F1')->setValue(ucwords($this->translate('_common.description')) . ' IT');
        $activeSheet->getCell('G1')->setValue(ucwords($this->translate('_common.description')) . ' EN');
        $activeSheet->getCell('H1')->setValue(ucwords($this->translate('_common.description')) . ' ES');
        $activeSheet->getCell('I1')->setValue(ucwords($this->translate('_common.description')) . ' FR');
        $activeSheet->getCell('J1')->setValue(ucwords($this->translate('_common.description')) . ' DE');
        $activeSheet->getCell('K1')->setValue(ucwords($this->translate('_common.description.comm')) . ' IT');
        $activeSheet->getCell('L1')->setValue(ucwords($this->translate('_common.description.comm')) . ' EN');
        $activeSheet->getCell('M1')->setValue(ucwords($this->translate('_common.description.comm')) . ' ES');
        $activeSheet->getCell('N1')->setValue(ucwords($this->translate('_common.description.comm')) . ' FR');
        $activeSheet->getCell('O1')->setValue(ucwords($this->translate('_common.description.comm')) . ' DE');
        $activeSheet->getCell('P1')->setValue(ucwords($this->translate('_common.details')) . ' IT');
        $activeSheet->getCell('Q1')->setValue(ucwords($this->translate('_common.details')) . ' EN');
        $activeSheet->getCell('R1')->setValue(ucwords($this->translate('_common.details')) . ' ES');
        $activeSheet->getCell('S1')->setValue(ucwords($this->translate('_common.details')) . ' FR');
        $activeSheet->getCell('T1')->setValue(ucwords($this->translate('_common.details')) . ' DE');
        $activeSheet->getCell('U1')->setValue(ucwords($this->translate('_common.madein')));
        $activeSheet->getCell('V1')->setValue(ucwords($this->translate('_common.composition')));
        $activeSheet->getCell('W1')->setValue(ucwords($this->translate('_common.fit')));
        $activeSheet->getCell('X1')->setValue('Pdf');
        $activeSheet->getCell('Y1')->setValue('Video');
        $activeSheet->getCell('Z1')->setValue(ucwords($this->translate('admin.validfrom')));
        $activeSheet->getCell('AA1')->setValue(ucwords($this->translate('admin.validto')));
        $activeSheet->getCell('AB1')->setValue(ucwords($this->translate('admin.seqrap.short')));

        // Leonardo B.
        // avevo provato a convertire in RichText per far modificare le descrizioni nel file xlsx
        // ma manche una buona conversione iniziale se ci vogliamo perdere altro tempo dobbiamo creare noi un
        //convertitore che questo lascia il tempo che trova
//        $htmlConverter = new \PhpOffice\PhpSpreadsheet\Helper\Html();

        for ($i = 0; $i < count($models); $i++) {
            $rowid = (2 + $i);
            $dtiniz = $models[$i]->dtiniz != '' ? \PhpOffice\PhpSpreadsheet\Shared\Date::PHPToExcel($models[$i]->dtiniz) : '';
            $dtfine = $models[$i]->dtfine != '' ? \PhpOffice\PhpSpreadsheet\Shared\Date::PHPToExcel($models[$i]->dtfine) : '';
            $activeSheet->getRowDimension($rowid)->setRowHeight(-1);
            $activeSheet->getCell('A' . $rowid)->setValue($models[$i]->cdartn);
            $activeSheet->getCell('B' . $rowid)->setValue($models[$i]->dstitl);
            $activeSheet->getCell('C' . $rowid)->setValue($models[$i]->dslinm);
            $activeSheet->getCell('D' . $rowid)->setValue($models[$i]->dsserm);
            $activeSheet->getCell('E' . $rowid)->setValue($models[$i]->dsstag);
            $activeSheet->getCell('F' . $rowid)->setValue($models[$i]->dsarit);
            $activeSheet->getCell('G' . $rowid)->setValue($models[$i]->dsaren);
            $activeSheet->getCell('H' . $rowid)->setValue($models[$i]->dsares);
            $activeSheet->getCell('I' . $rowid)->setValue($models[$i]->dsarfr);
            $activeSheet->getCell('J' . $rowid)->setValue($models[$i]->dsarde);
//            $activeSheet->getCell('K' . $rowid)->setValue($htmlConverter->toRichTextObject($models[$i]->dscoit));
//            $activeSheet->getCell('L' . $rowid)->setValue($htmlConverter->toRichTextObject($models[$i]->dscoen));
//            $activeSheet->getCell('M' . $rowid)->setValue($htmlConverter->toRichTextObject($models[$i]->dscoes));
//            $activeSheet->getCell('N' . $rowid)->setValue($htmlConverter->toRichTextObject($models[$i]->dscofr));
//            $activeSheet->getCell('O' . $rowid)->setValue($htmlConverter->toRichTextObject($models[$i]->dscode));
//            $activeSheet->getCell('P' . $rowid)->setValue($htmlConverter->toRichTextObject($models[$i]->dettit));
//            $activeSheet->getCell('Q' . $rowid)->setValue($htmlConverter->toRichTextObject($models[$i]->detten));
//            $activeSheet->getCell('R' . $rowid)->setValue($htmlConverter->toRichTextObject($models[$i]->dettes));
//            $activeSheet->getCell('S' . $rowid)->setValue($htmlConverter->toRichTextObject($models[$i]->dettfr));
//            $activeSheet->getCell('T' . $rowid)->setValue($htmlConverter->toRichTextObject($models[$i]->dettde));
            $activeSheet->getCell('K' . $rowid)->setValue($models[$i]->dscoit);
            $activeSheet->getCell('L' . $rowid)->setValue($models[$i]->dscoen);
            $activeSheet->getCell('M' . $rowid)->setValue($models[$i]->dscoes);
            $activeSheet->getCell('N' . $rowid)->setValue($models[$i]->dscofr);
            $activeSheet->getCell('O' . $rowid)->setValue($models[$i]->dscode);
            $activeSheet->getCell('P' . $rowid)->setValue($models[$i]->dettit);
            $activeSheet->getCell('Q' . $rowid)->setValue($models[$i]->detten);
            $activeSheet->getCell('R' . $rowid)->setValue($models[$i]->dettes);
            $activeSheet->getCell('S' . $rowid)->setValue($models[$i]->dettfr);
            $activeSheet->getCell('T' . $rowid)->setValue($models[$i]->dettde);
            $activeSheet->getCell('U' . $rowid)->setValue($models[$i]->madein);
            $activeSheet->getCell('V' . $rowid)->setValue($models[$i]->compos);
            $activeSheet->getCell('W' . $rowid)->setValue($models[$i]->vestib);
            $activeSheet->getCell('X' . $rowid)->setValue($models[$i]->filpdf);
            $activeSheet->getCell('Y' . $rowid)->setValue($models[$i]->filvid);
            $activeSheet->getCell('Z' . $rowid)->setValue($dtiniz);
            $activeSheet->getCell('AA' . $rowid)->setValue($dtfine);
            $activeSheet->getCell('AB' . $rowid)->setValue($models[$i]->seqrap);
        }

        $objWriter = IOFactory::createWriter($spreadsheet, 'Xlsx');
        $filename = 'productinfo_' . date('Ymd') . '_' . date('His');
        $objWriter->save(str_replace('AdminController', $filename, str_replace('.php', '.xlsx', __FILE__)));
        chmod("../app/controllers/" . $filename . ".xlsx", 0777);
        if (!file_exists('../public/io/template')) {
            mkdir('../public/io/template', 0777, true);
        }
        rename("../app/controllers/" . $filename . ".xlsx", "../public/io/template/" . $filename . ".xlsx");

        set_time_limit(30);

        $fileToDownload = $filename . ".xlsx";

        $this->view->fileToDownload = $fileToDownload;

        $this->view->setVars($this->getCommonVars());
    }

    public function downloadOrderXlsTemplateAction()
    {
        $this->view->nuordc = $_POST['nuordc'];
        $this->view->permissions = $_POST['permissions'];
        $this->view->setVars($this->getCommonVars());
    }

    public function editCustomDiscountAction()
    {
        $numdis = $this->dispatcher->getParam('numdis');
        $rows_choose = [];

        if ($numdis) {
            $discount = B2bDishea::findFirstByNumdis($numdis);
            $in_el = explode('-', $discount->dtiniz);
            $fi_el = explode('-', $discount->dtfine);
            $discount->validity = $in_el[2] . '/' . $in_el[1] . '/' . $in_el[0] . ' - ' . $fi_el[2] . '/' . $fi_el[1] . '/' . $fi_el[0];
            $sel_anag = $discount->fltota != 1 ? B2bDisana::findByNumdis($numdis) : array();
            $sel_ctlg = B2bDisctl::findByNumdis($numdis);
            $sel_list = B2bDislst::findByNumdis($numdis);
            $sel_ports = B2bDispor::findByNumdis($numdis);
            $sel_payments = B2bDispag::findByNumdis($numdis);

            // Prepare common parameters
            $cttest_keys = '';
            $params = array('numdis' => $numdis);
            for ($i = 0; $i < count($sel_ctlg); $i++) {
                $cttest_keys .= ":cdcata" . $i . ":,";
                $params['cdcata' . $i] = $sel_ctlg[$i]->cdcata;
            }
            $cttest_keys = substr($cttest_keys, 0, -1);

            $rules['titlin'] = $this->getHtmlDiscount('titlin', $cttest_keys, $params);
            $rules['linmod'] = $this->getHtmlDiscount('linmod', $cttest_keys, $params);
            $rules['sermod'] = $this->getHtmlDiscount('sermod', $cttest_keys, $params);
            $rules['tpmode'] = $this->getHtmlDiscount('tpmode', $cttest_keys, $params);
            $rules['tipolo'] = $this->getHtmlDiscount('tipolo', $cttest_keys, $params);
            $rules['anaart'] = $this->getHtmlDiscount('anaart', $cttest_keys, $params);
        } else {
            $discount = null;
            $sel_anag = null;
            $sel_ctlg = null;
            $sel_list = null;
            $sel_ports = null;
            $sel_payments = null;
            $rules = null;
        }

        $this->view->catalogs = Cttest::getAllMinimalCatalogs();
        $this->view->customers = Anagra::getAllCustomers();
        $this->view->pricelists = Lstest::getAllPriceLists();
        $this->view->ports = Tpport::getAllShippingTypes();
        $this->view->payments = Tppaga::getAllPaymentTypes();

        $this->view->discount = $discount;
        $this->view->sel_anag = $sel_anag;
        $this->view->sel_ctlg = $sel_ctlg;
        $this->view->sel_list = $sel_list;
        $this->view->sel_ports = $sel_ports;
        $this->view->sel_payments = $sel_payments;
        $this->view->rules = $rules;

        $this->view->setVars($this->getCommonVars());
    }

    public function featuredAction()
    {
        $this->view->cttest = Cttest::getAllMinimalCatalogs();
        $this->view->tagIsPresent = Artcla::isTagAvailable();
        $this->view->default_ctlg = $this->utility->getAppUtils('default_catalog');
        $this->view->logo = $this->utility->getAppUtils('logo_image');
        $this->view->catalogProductType = $this->utility->getAppSettings('ProductTypeOnCatalog');

        $this->view->setVars($this->getCommonVars());
    }

    public function filterVisibilityAction()
    {
        $commonFilters = array_merge(B2bFlvisi::getCommonFilters(), Tipcla::getFilterTags());
        /** @var Translator $t */
        $t = $this->getDI()->get('translator');
        // Italian
//        $translationPath = '../app/messages/it/main.php';
//        require $translationPath;
//        $mainTranslate = new \Phalcon\Translate\Adapter\NativeArray(array(
//            'content' => $messages
//        ));
        $mainTranslate = new \Phalcon\Translate\Adapter\NativeArray(array(
            'content' => $t->getTranslatedStrings('it')
        ));
        $this->view->setVar('it', $mainTranslate);

        // English
//        $translationPath = '../app/messages/en/main.php';
//        require $translationPath;
//        $mainTranslate = new \Phalcon\Translate\Adapter\NativeArray(array(
//            'content' => $messages
//        ));
        $mainTranslate = new \Phalcon\Translate\Adapter\NativeArray(array(
            'content' => $t->getTranslatedStrings('en')
        ));
        $this->view->setVar('en', $mainTranslate);

        // Spanish
//        $translationPath = '../app/messages/es/main.php';
//        require $translationPath;
//        $mainTranslate = new \Phalcon\Translate\Adapter\NativeArray(array(
//            'content' => $messages
//        ));
        $mainTranslate = new \Phalcon\Translate\Adapter\NativeArray(array(
            'content' => $t->getTranslatedStrings('es')
        ));
        $this->view->setVar('es', $mainTranslate);

        // Deutsch
//        $translationPath = '../app/messages/de/main.php';
//        require $translationPath;
//        $mainTranslate = new \Phalcon\Translate\Adapter\NativeArray(array(
//            'content' => $messages
//        ));
        $mainTranslate = new \Phalcon\Translate\Adapter\NativeArray(array(
            'content' => $t->getTranslatedStrings('de')
        ));
        $this->view->setVar('de', $mainTranslate);

        // French
//        $translationPath = '../app/messages/fr/main.php';
//        require $translationPath;
//        $mainTranslate = new \Phalcon\Translate\Adapter\NativeArray(array(
//            'content' => $messages
//        ));
        $mainTranslate = new \Phalcon\Translate\Adapter\NativeArray(array(
            'content' => $t->getTranslatedStrings('fr')
        ));
        $this->view->setVar('fr', $mainTranslate);

        $this->view->commonFilters = $commonFilters;
        $this->view->additionalFilters = Tpcrar::getAdditionalFilters();
        $this->view->setVars($this->getCommonVars());
    }

    public function galleryAction()
    {
        $nugall = $this->dispatcher->getParam('nugall');

        $idlang = $this->utility->getLanguage();
        $gallery = B2bGltest::findFirstByNugall($nugall);
        $points = B2bGlcorp::findByNugall($nugall);
        $description = 'des_' . strtolower($idlang);

        $galleryType = $this->utility->getAppSettings('EnableCatalogGalleries');

        $this->view->products = $galleryType == 1
            ? Ctarti::getAllModelsFromCatalog($gallery->cdcata, $idlang)
            : Ctarti::getAllArticlesFromCatalog($gallery->cdcata, $idlang);

        $this->view->gallery = $gallery;
        $this->view->title = $gallery->$description;
        $this->view->points = $points;
        $this->view->galleryType = $galleryType;

        $this->view->setVars($this->getCommonVars());
    }

    public function galleriesAction()
    {
        $this->view->catalogs = Cttest::find();

        $this->view->setVars($this->getCommonVars());
    }

    public function imageManagerAction()
    {
        $this->view->setVars($this->getCommonVars());
    }

    public function importExportAction()
    {
        $request = new Request();

        if ($request->isPost() && $request->isAjax()) {
            $this->view->disable();

            foreach ($_FILES as $file) {
                $tempFile = $file['tmp_name'];

                if (!file_exists('./io/import')) {
                    mkdir('./io/template/compiled', 0777, true);
                }

                $targetPath = "./io/import/";
                if (!is_dir($targetPath) && !mkdir($targetPath)) {
                    die("Error creating folder $targetPath");
                }
                $targetFile = $targetPath . $file['name'];

                move_uploaded_file($tempFile, $targetFile);
            }
            echo($this->translate('_common.generic.db.success'));
            return;
        }

        $this->view->setVars($this->getCommonVars());
    }

    public function linkcatalogsAction()
    {
        // Agents
        $agents = Anaage::getAllAvailableStandardAgents();

        $full_agents = array();
        if ($agents != null) {
            foreach ($agents as $key => $value) {
                $agents[$key]->catalogs = Cttest::getAllCatalogsForUser($value->id_usr);
                $full_agents[] = $value;
            }
        }

        // Head Offices
        $headoffices = Anaage::getAllAvailableHeadOfficeAgents();

        $full_headoffices = array();
        if ($headoffices != null) {
            foreach ($headoffices as $key => $value) {
                $headoffices[$key]->catalogs = Cttest::getAllCatalogsForUser($value->id_usr);
                $full_headoffices[] = $value;
            }
        }

        // Customers
        $customers = Anagra::getAllAvailableCustomers();

        $full_customers = array();
        if ($customers != null) {
            foreach ($customers as $key => $value) {
                $customers[$key]->catalogs = Cttest::getAllCatalogsForUser($value->id_usr);
                $full_customers[] = $value;
            }
        }

        // Shippings
        $shippings = Desmer::getAllShippings();

        $full_shippings = array();
        if ($shippings != null) {
            foreach ($shippings as $key => $value) {
                $shippings[$key]->catalogs = Cttest::getAllCatalogsForUser($value->id_usr);
                $full_shippings[] = $value;
            }
        }

        $catalogs = Cttest::find();

        $this->view->catalogs = $catalogs;
        $this->view->headoffices = $full_headoffices;
        $this->view->agents = $full_agents;
        $this->view->customers = $full_customers;
        $this->view->shippings = $full_shippings;

        $this->view->setVars($this->getCommonVars());
    }

    public function localizationAction()
    {
        $table = $this->dispatcher->getParam('table') !== null ? $this->dispatcher->getParam('table') : '';

        $this->view->table = $table;

        $this->view->setVars($this->getCommonVars());
    }

    public function managementParamsAction()
    {
        $auth = $this->session->get('auth');

        if ($auth['type'] != "1") {
            return $this->forward('settings');
        }

        $rawParams = $this->utility->getManagementParamsList();

        $params = array();
        foreach ($rawParams as $param) {
            $params[$param->type][] = $param;
        }
        $this->view->params = $params;

        $this->view->setVars($this->getCommonVars());
    }

    public function mediaAction()
    {
        $s = isset($_GET["s"]) ? $_GET["s"] : 0;

        $directoryArray = $this->utility->getMediaFiles();

        $this->view->success = $s;
        $this->view->files = $directoryArray;

        $this->view->setVars($this->getCommonVars());
    }

    public function modifyModelInfoAction()
    {
        $cdartn = urldecode($this->dispatcher->getParam('cdartn'));
        $success = isset($_GET['s']) ? $_GET['s'] : -1;

        $this->view->model = Tipolo::getModel($cdartn);
        $this->view->classifications = B2bClassificazione::getAvailableTree();
        $this->view->success = $success;

        $this->view->setVars($this->getCommonVars());
    }

    public function newCustomersAction()
    {
        $this->view->newCustomers = Anagra::getNewCustomers();

        $this->view->setVars($this->getCommonVars());
    }

    public function noteseditorAction()
    {
        $apputils = [];

        $availableLocales = ['it', 'en', 'es', 'fr', 'de'];
        foreach ($availableLocales as $locale) {
            $apputils['descr_' . $locale] = [
                'code' => $locale,
                'label' => $this->translate('_common.lang.' . $locale),
                'value' => $this->utility->getAppUtils('descr_' . $locale),
            ];
        }
        $this->view->apputils = $apputils;
        $this->view->setVars($this->getCommonVars());
    }

    public function shipmentnoteseditorAction()
    {
        $apputils = [];

        $availableLocales = ['it', 'en', 'es', 'fr', 'de'];
        foreach ($availableLocales as $locale) {
            $apputils['shipment_cond_' . $locale] = [
                'code' => $locale,
                'label' => $this->translate('_common.lang.' . $locale),
                'value' => $this->utility->getAppUtils('shipment_cond_' . $locale),
            ];
        }

        $this->view->apputils = $apputils;
        $this->view->setVars($this->getCommonVars());
    }

    public function openordersAction()
    {
        $this->view->orders = Octest::getAllOpenOrders();

        $this->view->setVars($this->getCommonVars());
    }

    public function orderAction()
    {
        $mode = $this->dispatcher->getParam('mode');
        $nuordc = $this->dispatcher->getParam('nuordc');
        $tab = $this->dispatcher->getParam('tab');

        $orderStateMgmt = $this->utility->getAppSettings('OrderStateManagement');

        if ($mode == 'w' && !$orderStateMgmt) {
            return $this->response->redirect('admin/order/r/' . $nuordc);
        }

        $ordering = $this->utility->getAppSettings('ParamTypeOrdering');
        $idlang = $this->utility->getLanguage();

        $hasConfigurator = $this->utility->getAppSettings('ModelDetailStyle') == 5;

        $articles = Occorp::getOrderDetailRows($nuordc, $ordering, $idlang);

        if ($hasConfigurator) {
            $customArticles = Occorp::getCustomOrderDetailRows($nuordc, $ordering, $idlang);
            $articles = array_merge($articles, $customArticles);
        }

        $octest = Octest::findFirstByNuordc($nuordc);
        $anagra = Anagra::findCustomerByKey($octest->tpanag, $octest->cdanag);

        $useAnagraDiscount = false;

        $fullArticles = array();
        if (count($articles) > 0) {
            foreach ($articles as $article) {
                $currArticle = $article;
                $currArticle['octagl'] = !$hasConfigurator || $currArticle['cdcolo'] != 'CUSTOM'
                    ? Octagl::getSizeQuantitiesForOrderDetail($currArticle['nurorc'])
                    : Octagl::getSizeQuantitiesForOrderDetailConfigurator($currArticle['nurorc']);

                $currArticle['prezzo'] = 0;
                $currArticle['scont1'] = 0;
                $currArticle['scont2'] = 0;
                $currArticle['scont3'] = 0;
                $currArticle['totale'] = 0;

                if (count($currArticle['octagl']) > 0) {
                    $currArticle['prezzo'] = $currArticle['octagl'][0]->prezzo;
                    if ($currArticle['octagl'][0]->scont1 != 0 || $currArticle['octagl'][0]->scont2 != 0 || $currArticle['octagl'][0]->scont3 != 0) {
                        $currArticle['scont1'] = $currArticle['octagl'][0]->scont1;
                        $currArticle['scont2'] = $currArticle['octagl'][0]->scont2;
                        $currArticle['scont3'] = $currArticle['octagl'][0]->scont3;
                    } else {
                        $currArticle['scont1'] = $anagra->scont1;
                        $currArticle['scont2'] = $anagra->scont2;
                        $currArticle['scont3'] = $anagra->scont3;
                        $useAnagraDiscount = true;
                    }
                    $currArticle['totale'] = $currArticle['quanti'] * ($currArticle['octagl'][0]->prezzo *
                            (1 - ($currArticle['scont1'] / 100)) *
                            (1 - ($currArticle['scont2'] / 100)) *
                            (1 - ($currArticle['scont3'] / 100)));
                }

                // Add components (Rossetti)
                if ($hasConfigurator) {
                    if ($currArticle['cdcolo'] == 'CUSTOM') {
                        $currArticle['components'] = Ocperc::getAllComponents($currArticle['cdarti']);
                    } else {
                        $currArticle['components'] = $currArticle['cdarti'] == $currArticle['cdartn']
                            ? Spmate::getDefaultMaterialTypes($currArticle['cdarti'])
                            : Smcorp::getAllComponents($currArticle['cdarti']);
                    }
                }

                $fullArticles[] = $currArticle;
            }
        }

        $showVariants = $this->utility->getAppSettings('ModelDetailStyle') == 2;

        $order = Octest::getOrderForDetailFromNuordc($nuordc);

        if ($mode == 'w') {
            $dateMgmt = $this->utility->getAppSettings('ParamDateManagement');
            if ($dateMgmt < 2) {
                // period
                $this->view->periods = Scacon::getPeriodsForCatalog($order->cdcata);
            } else {
                // calendar
            }

            if ($showVariants) {
                $this->view->selectableArticles = Ctarti::findByCdcata($order->cdcata);
            }

            $this->view->dateMgmt = $dateMgmt;
            $this->view->addresses = Desmer::getShippingsAddressForCustomer($order->tpanag, $order->cdanag);
            $this->view->payments = Tppaga::getAllPaymentTypes();
            $this->view->shippings = Tpport::getAllShippingTypes();
        }

        $this->view->orderStateMgmt = $orderStateMgmt;
        $this->view->showVariants = $showVariants;
        $this->view->hasConfigurator = $hasConfigurator;
        $this->view->useAnagraDiscount = $useAnagraDiscount;

        $this->view->currency = $this->utility->getCurrencySymbol($order->cdvalu);
        $this->view->order = $order;
        $this->view->rows = $fullArticles;
        $this->view->mode = $mode;
        $this->view->nuordc = $nuordc;
        $this->view->tab = $tab;

        $this->view->setVars($this->getCommonVars());
    }

    public function ordersAction()
    {
        $this->view->orderStateMgmt = $this->utility->getAppSettings('OrderStateManagement');

        $agentCanEditXls = $this->utility->getAppSettings('EnableOrderXmlAgent');
        $customerCanEditXls = $this->utility->getAppSettings('EnableOrderXmlCustomer');
        $this->view->canEditXls = $agentCanEditXls == 2 || $agentCanEditXls == 3 || $customerCanEditXls == 2 || $customerCanEditXls == 3;

        $this->view->seasons = Tabstg::getAllSeasons();
        $enableDuplicate = $this->utility->getAppSettings('DuplicateOrderFromBackEnd') == 1;
        if ($enableDuplicate) {
            $this->view->customers = Anagra::getAllCustomers();
        }

        $cookieDtinizRaw = $this->cookies->has('admin-orders-dtiniz') ? $this->cookies->get('admin-orders-dtiniz')->getValue() : '';
        $cookieDtfineRaw = $this->cookies->has('admin-orders-dtfine') ? $this->cookies->get('admin-orders-dtfine')->getValue() : '';
        $cookieDtiniz = $cookieDtinizRaw != '' ? explode('-', $cookieDtinizRaw) : '';
        $cookieDtfine = $cookieDtfineRaw != '' ? explode('-', $cookieDtfineRaw) : '';

        $cookieStatus = $this->cookies->has('admin-orders-status') ? $this->cookies->get('admin-orders-status')->getValue() : '';
        $cookieTypes = $this->cookies->has('admin-orders-types') ? $this->cookies->get('admin-orders-types')->getValue() : '';

        $this->view->cookieType = $this->cookies->has('admin-orders-type') ? $this->cookies->get('admin-orders-type')->getValue() : '';
        $this->view->cookieDtiniz = $cookieDtiniz != '' ? $cookieDtiniz[2] . '/' . $cookieDtiniz[1] . '/' . $cookieDtiniz[0] : '';
        $this->view->cookieDtinizRaw = $cookieDtinizRaw != '' ? $cookieDtinizRaw : '';
        $this->view->cookieDtfine = $cookieDtfine != '' ? $cookieDtfine[2] . '/' . $cookieDtfine[1] . '/' . $cookieDtfine[0] : '';
        $this->view->cookieDtfineRaw = $cookieDtfineRaw != '' ? $cookieDtfineRaw : '';
        $this->view->cookieWhose = $this->cookies->has('admin-orders-whose') ? $this->cookies->get('admin-orders-whose')->getValue() : '';
        $this->view->cookieWhoseSet = $this->cookies->has('admin-orders-whose-set') ? $this->cookies->get('admin-orders-whose-set')->getValue() : '';
        $this->view->cookieWhoseSetCount = $this->view->cookieWhoseSet == -1 || empty($this->view->cookieWhoseSet) ? 0 : count(explode(',', $this->view->cookieWhoseSet));
        $this->view->cookieWhichSeason = $this->cookies->has('admin-orders-which-season') ? $this->cookies->get('admin-orders-which-season')->getValue() : '';
        $this->view->cookieWhichSeasonCount = $this->view->cookieWhichSeason == -1 || empty($this->view->cookieWhichSeason) ? 0 : count(explode(',', $this->view->cookieWhichSeason));
        $this->view->cookieStatus = explode(',', $cookieStatus);
        $this->view->cookieTypes = explode(',', $cookieTypes);

        if ($this->utility->getAppSettings('PreventOrderToBeSentWithoutPrices') == 1) {
            $this->view->checkOrderPrices = true;
            $cookiePrices = $this->cookies->has('admin-orders-prices') ? $this->cookies->get('admin-orders-prices')->getValue() : '';
            $this->view->cookiePrices = explode(',', $cookiePrices);
        } else {
            $this->view->checkOrderPrices = false;
        }

        $this->view->hasConfigurator = $this->utility->getAppSettings('ModelDetailStyle') == 5;
        $this->view->enableJoorExport = $this->utility->getAppSettings('EnableExportOrderJoor') != 0;
        $this->view->enableDuplicate = $enableDuplicate;
        $this->view->enableExport = $this->utility->getAppUtils('enable_export_all_orders') == 1;

        $this->view->setVars($this->getCommonVars());
    }

    public function paramsAction()
    {
        $auth = $this->session->get('auth');

        if ($auth['type'] != "1") {
            return $this->forward('settings');
        }

        $this->view->utils = $this->utility->getAppUtilsList();

        $this->view->setVars($this->getCommonVars());
    }

    public function pdfConditionsAction()
    {
        $this->view->catalogs = Cttest::find();

        $this->view->setVars($this->getCommonVars());
    }

    public function proceduresAction()
    {

        $this->view->setVars($this->getCommonVars());
    }

    public function productinfoAction()
    {
        $success = isset($_GET['s']) ? $_GET['s'] : -1;
        $models = Tipolo::getModels();

        $this->view->models = Tipolo::getModels();
        $this->view->success = $success;

        $this->view->enableDescriptionLoading = $this->utility->getAppSettings('EnableDescriptionLoadingOnProductInfo') > 0;

        $this->view->setVars($this->getCommonVars());
    }

    public function quantityrulesAction()
    {
        $this->view->catalogs = Cttest::getAllMinimalCatalogs();
        $this->view->lines = Linmod::getAllMinimalLinesWithBrand();

        $this->view->setVars($this->getCommonVars());
    }

    public function reqaccessAction()
    {
        $this->view->reqaccess = B2bReqacc::find(array('order' => 'dtcrea DESC'));

        $this->view->setVars($this->getCommonVars());
    }

    public function settingsAction()
    {
        $this->view->settings = $this->utility->getAppSettingsList();
        $this->view->loginBg = B2bApputi::findFirstByParam('login_bg') ?: (object)(B2bApputi::getCurrentAppUtils()['login_bg']);
        $this->view->logoImg = B2bApputi::findFirstByParam('logo_image') ?: (object)(B2bApputi::getCurrentAppUtils()['logo_image']);

        $this->view->setVars($this->getCommonVars());
    }

    public function shippingsAction()
    {
        $shippings = Desmer::getShippings();

        $full_shippings = array();
        foreach ($shippings as $key => $value) {
            $value['catalogs'] = Cttest::getAllCatalogsForShipping($value['cddesm'])->toArray();
            $full_shippings[] = $value;
        }

        $catalogs = Cttest::find();

        $this->view->prefix = $this->utility->getAppUtils('prefix');
        $this->view->shippings = $full_shippings;
        $this->view->catalogs = $catalogs;

        $this->view->setVars($this->getCommonVars());
    }

    public function specialSelectionDetailAction()
    {
        $cdspsl = $this->dispatcher->getParam('cdspsl');

        $sstest = B2bSstest::findFirstByCdspsl($cdspsl);
        $idlang = $this->utility->getLanguage();
        $descri = strtolower('des_' . $idlang);

        $this->view->code = $cdspsl;
        $this->view->description = $sstest->$descri;
        $this->view->selection = $sstest;
        if ($this->utility->getAppSettings('SpecialSelections') == 1) {
            $this->view->products = B2bSscorp::getAllModelsForSpecialSelection($cdspsl, $idlang);
            $this->view->availableProducts = Ctarti::getModelsNotInSpecialSelection($cdspsl, $sstest->cdcata, $idlang);
        } else {
            $this->view->products = B2bSscorp::getAllArticlesForSpecialSelection($cdspsl, $idlang);
            $this->view->availableProducts = Ctarti::getArticlesNotInSpecialSelection($cdspsl, $sstest->cdcata, $idlang);
        }

        switch ($this->utility->getAppSettings('ItemsPerRowOnVisualCatalog')) {
            case 1:
                $this->view->colspan = 'col-md-4 col-sm-4 col-xs-12';
                break;
            case 2:
                $this->view->colspan = 'col-md-6 col-sm-6 col-xs-12';
                break;
            default:
                $this->view->colspan = 'col-md-3 col-sm-3 col-xs-12';
                break;
        }

        $this->view->setVars($this->getCommonVars());
    }

    public function specialSelectionsAction()
    {
        $this->view->catalogs = Cttest::find();

        $this->view->setVars($this->getCommonVars());
    }

    public function uploadProductDescriptionsAction()
    {
        try {
            if (!empty($_FILES) && isset($_FILES['descriptions'])) {
                set_time_limit(0);

                $tempFile = $_FILES['descriptions']['tmp_name'];          //3
                $targetPath = "./io/descriptions/";  //4
                if (!is_dir($targetPath) && !mkdir($targetPath, 0777, true)) {
                    die("Error creating folder $targetPath");
                }
                $targetFile = $targetPath . $_FILES['descriptions']['name'];  //5
                move_uploaded_file($tempFile, $targetFile); //6
                chmod($targetFile, 0777);

                $spreadsheet = IOFactory::load($targetPath . $_FILES['descriptions']['name']);
                $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

                $first = true;
                foreach ($sheetData as $model_info) {
                    if ($first) {
                        $first = false;
                    } else {
                        if ($model_info['A'] != '') {
                            if ($model_info['B'] != '') {
                                Desart::insertOrReplaceDescription('AN', $model_info['A'], 'COMM', 'IT', $model_info['B']);
                            } else {
                                Desart::deleteDescription('AN', $model_info['A'], 'COMM', 'IT');
                            }
                            if ($model_info['C'] != '') {
                                Desart::insertOrReplaceDescription('AN', $model_info['A'], 'TECN', 'IT', $model_info['C']);
                            } else {
                                Desart::deleteDescription('AN', $model_info['A'], 'TECN', 'IT');
                            }
                        }
                    }
                }
                return $this->response->redirect('admin/productinfo?s=1');
            } else {
                return $this->response->redirect('admin/productinfo?s=0');
            }
        } catch (\Exception $ex) {
            return $this->response->redirect('admin/productinfo?s=0');
        } finally {
            set_time_limit(30);
        }
    }

    public function uploadTemplateAction()
    {
        try {
            if (!empty($_FILES) && isset($_FILES['template'])) {
                set_time_limit(0);

                $tempFile = $_FILES['template']['tmp_name'];          //3
                $targetPath = "./io/template/";  //4
                if (!is_dir($targetPath) && !mkdir($targetPath, 0777, true)) {
                    die("Error creating folder $targetPath");
                }
                $targetFile = $targetPath . $_FILES['template']['name'];  //5
                move_uploaded_file($tempFile, $targetFile); //6
                chmod($targetFile, 0777);

                $spreadsheet = IOFactory::load($targetPath . $_FILES['template']['name']);
                $activesheet = $spreadsheet->getActiveSheet();
                $sheetData = $activesheet->toArray(null, true, true, true);

                B2bModinf::deleteAllModelInfo();
                B2bTipval::deleteAllModelLimits();

                $first = true;
                $i = 1;
                foreach ($sheetData as $rowid => $model_info) {
                    if ($first) {
                        $first = false;
                    } else {
                        if ($model_info['F'] != '') {
                            Tipolo::updateModelDescription($model_info['A'], $model_info['F']);
                        }

                        if (
                            $model_info['G'] != '' || $model_info['H'] != '' ||
                            $model_info['I'] != '' || $model_info['J'] != ''
                        ) {
                            $descri = array(
                                'EN' => $model_info['G'],
                                'ES' => $model_info['H'],
                                'FR' => $model_info['I'],
                                'DE' => $model_info['J']);
                            Deslin::importDescriTipolo($model_info['A'], $descri);
                        }

//            if (
//              $model_info['K'] != '' || $model_info['L'] != '' ||
//              $model_info['M'] != '' || $model_info['N'] != '' ||
//              $model_info['O'] != ''
//            ){
//              $descri = array(
//                'IT' => $model_info['K'],
//                'EN' => $model_info['L'],
//                'ES' => $model_info['M'],
//                'FR' => $model_info['N'],
//                'DE' => $model_info['O'] );
//              Desart::importDescriTipolo($model_info['A'], $descri);
//            }

                        if (
                            $model_info['K'] != '' || $model_info['L'] != '' || $model_info['M'] != '' || $model_info['N'] != '' ||
                            $model_info['O'] != '' || $model_info['P'] != '' || $model_info['Q'] != '' || $model_info['R'] != '' ||
                            $model_info['S'] != '' || $model_info['T'] != '' || $model_info['U'] != '' ||
                            $model_info['V'] != '' || $model_info['W'] != '' || $model_info['X'] != '' ||
                            $model_info['Y'] != ''
                        ) {

//                            foreach (['K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T'] as $cellToConvert) {
//                                if (!empty($model_info[$cellToConvert])) {
//                                    $model_info[$cellToConvert] = $this->utility->convertSpeadsheetRichTextToHtml(new \PhpOffice\PhpSpreadsheet\RichText\RichText($activesheet->getCell('K' . $rowid)));
//                                }
//                            }

                            // TODO fixare $listaClassificazioni sia in import che in export

                            B2bModinf::insertNewModelInfo(
                                $model_info['A'],
                                $model_info['K'],
                                $model_info['L'],
                                $model_info['M'],
                                $model_info['N'],
                                $model_info['O'],
                                $model_info['P'],
                                $model_info['Q'],
                                $model_info['R'],
                                $model_info['S'],
                                $model_info['T'],
                                $model_info['U'],
                                $model_info['V'],
                                $model_info['W'],
                                $listaClassificazioni,
                                $model_info['X'],
                                $model_info['Y']
                            );
                        }

                        if ($model_info['Z'] != '' || $model_info['AA'] != '') {
                            $b2bardt = B2bTipval::findFirstByCdartn($model_info['A']);
                            if (!$b2bardt) {
                                $b2bardt = new B2bTipval();
                                $b2bardt->cdartn = $model_info['A'];
                            }

                            $dtiniz = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($spreadsheet->getActiveSheet()->getCell('Z' . $i)->getValue());
                            $dtfine = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($spreadsheet->getActiveSheet()->getCell('AA' . $i)->getValue());

                            $b2bardt->dtiniz = $model_info['Z'] != '' ? $dtiniz->format('Y-m-d') : null;
                            $b2bardt->dtfine = $model_info['AA'] != '' ? $dtfine->format('Y-m-d') : null;
                            $b2bardt->save();
                        }
                    }
                    Tipolo::updateModelIndex($model_info['A'], $model_info['S']);
                    $i++;
                }
                return $this->response->redirect('admin/productinfo?s=1');
            } else {
                return $this->response->redirect('admin/productinfo?s=0');
            }
        } catch (\Exception $ex) {
            $this->logger->info(print_r($ex, true));
            return $this->response->redirect('admin/productinfo?s=0');
        } finally {
            set_time_limit(30);
        }
    }

    public function customersTableExportAction()
    {
        $this->view->disable();
        $selected = $this->request->getQuery('sel');
        $withPriceList = $this->config->param->custnonulist ? true : false;
        $customers = Anagra::getCustomersWithPagination(1, null, null, $withPriceList, '' , '', $selected);

        $mappaColonneExport = [
            'cdanag' => $this->i18n->_('admin.customers.customercode'),
            'descri' => $this->i18n->_('admin.customers.name'),
            'cdblco' => $this->i18n->_('admin.status'),
            'catalogs' => $this->i18n->_('admin.catalogs'),
//            'shippings' => $this->i18n->_('_common.shippings'),
            'username' => $this->i18n->_('admin.username'),
            'password' => $this->i18n->_('account.initialpassword'),
            'enabled' => $this->i18n->_('admin.customer.canlogin'),
            'orders_enabled' => $this->i18n->_('admin.customer.canorder'),
        ];

        $csv = new SimpleCsv('customer-export');
        $csv->useHeaderRow(false);
        $data = [];
        $data[] = array_values($mappaColonneExport);
        foreach ($customers as $customer) {
            $row = [];
            foreach ($mappaColonneExport as $colname => $item) {
                $value = isset($customer[$colname]) ? $customer[$colname] : '';
                if ($colname == 'cdblco') {
                    $hiddenTransaltor = $this->i18n;
                    if (empty($value)) {
                        $value = $hiddenTransaltor->_('account.customer.ban.0');
                    } else {
                        $value = $hiddenTransaltor->_('account.customer.ban.' . $value);
                    }
                } else if ($colname == 'enabled' || $colname == 'orders_enabled') {
                    $value = ($value == 1 ? $this->i18n->_('admin.enabled') : $this->i18n->_('admin.disabled'));
                } else if ($colname == 'password') {
                    $username = isset($customer['username']) ? $customer['username'] : '';
                    $value = B2bSysusr::generateUserPasswordString($username, true);
                }
                $row[] = $value;
            }
            $data[] = $row;
        }

        $csv->send($data, $this->response);
    }
    //endregion

    //region Ajax functions: User management
    public function customersTableContentAction()
    {
        $this->view->disable();
        // N.B.
        // Usare questa tecnica genera molti errori tra cui il caricamento dei filtri sul sanitize del metodo getPost
        // $request = new Request();
        // TODO ANDREBBE RIMOSSO OVUNQUE
        $request = $this->request;
        if ($request->isAjax()) {
            $q = $request->getQuery('q', ['string', 'trim'], '');
            $draw = $request->getQuery('draw', 'absint', 1);
            $page = $request->getQuery('page', 'absint', 1);
            $page_length = $request->getQuery('size', 'absint', 500);
            $start = $request->getQuery('start', 'absint', 0);
            $orderBy = '';
            if ($request->isPost()) {
                $draw = $request->getPost('draw', 'absint', $draw);
                $page_length = $request->getPost('length', 'absint', $page_length);
                $start = $request->getPost('start', 'absint', $start);
                $page = ($start / $page_length) + 1;
                if ($request->hasPost('search')) {
                    $q = (!empty($request->getPost('search')['value']) ? $request->getPost('search')['value'] : $q);
                }
                // Ordering
                $orders = $request->getPost('order');
                if (!empty($orders)) {
                    $columns = $request->getPost('columns');
                    foreach ($orders as $order) {
                        if (!empty($columns[$order['column']])) {
                            $orderBy .= (empty($orderBy) ? '' : ', ') . $columns[$order['column']]['name'] . ' ' . $order['dir'];
                        }
                    }
                }

            }

            $withPriceList = $this->config->param->custnonulist ? true : false;
            $tot_filtered_customers = intval(Anagra::getCountCustomers($withPriceList, $q));
            $tot_customers = !empty($q)
                ? intval(Anagra::getCountCustomers($withPriceList, ''))
                : $tot_filtered_customers;
            $customers = Anagra::getCustomersWithPagination($page, $tot_filtered_customers, $page_length, $withPriceList, $q, $orderBy);
//            foreach ($customers as $key => $value) {
//                $customers[$key]['catalogs'] = Cttest::getAllCatalogsForCustomer($value['tpanag'], $value['cdanag']);
//            }

            echo json_encode([
                'draw' => "$draw",
                'recordsTotal' => $tot_customers,
                'recordsFiltered' => $tot_filtered_customers,
                'data' => $customers,
            ]);
        }
    }

    public function createCustomerUserAction()
    {
        $this->view->disable();

        $request = $this->request;
        if ($request->isPost() && $request->isAjax()) {
            $tpanag = $request->getPost("tpanag");
            $cdanag = $request->getPost("cdanag");
            $username = $request->getPost("username");
            $password = $request->getPost("password");
            $cdblco = $request->getPost("cdblco");
            $enabled = $request->getPost("enabled");
            $orders_enabled = $request->getPost("orders_enabled");
            $catalogs = $request->getPost("catalogs");

            $licenses = $this->getLicenses();

            if ($enabled == 0 || $licenses["licenses"] < $licenses["total_licenses"]) {
                $customer = Anagra::findCustomerByKey($tpanag, $cdanag);

                $customer->cdblco = $cdblco;
                $customer->notdes = empty($customer->notdes) ? ' ' : $customer->notdes;

                if ($customer->save() == false) {
                    echo json_encode(array("AN", $customer->getMessages()));
                } else {
                    $userGenerated = $customer->generateSysusr($enabled, $orders_enabled, $catalogs, $username, $password);
                    if ($userGenerated) {
                        echo json_encode("OK");
                    } else {
                        echo json_encode("UC");
                    }
                }
            } else {
                echo json_encode("LT");
            }
        }
    }

    public function createCustomerUsersAction()
    {
        $this->view->disable();

        $request = $this->request;
        if ($request->isPost() && $request->isAjax()) {
            $customers = $request->getPost('customers');
            $enabled = $request->getPost('enabled', 'int!', 0);
            $orders_enabled = $request->getPost('orders_enabled', 'int!', 0);
            $prefix = $this->utility->getAppUtils('prefix');
            $index = $this->utility->getAppUtils('index');

            $everythingOk = true;
            foreach ($customers as $anagra) {
                $customer = Anagra::findCustomerByKey($anagra['tpanag'], $anagra['cdanag']);
                if (!empty($anagra['enabled'])) {
                    $enabled = $anagra['enabled'];
                }
                if (!empty($anagra['orders_enabled'])) {
                    $orders_enabled = $anagra['orders_enabled'];
                }

                $username = $prefix . sprintf('%05d', $index);
                $password = B2bSysusr::generateUserPasswordString($username);

                $userGenerated = $customer->generateSysusr($enabled, $orders_enabled, null, $username, $password);
                if (!$userGenerated) {
                    $everythingOk &= false;
                }
                $index++;
            }

            $this->utility->setAppUtils('index', $index);

            if ($everythingOk) {
                echo json_encode('OK');
            } else {
                echo json_encode('UC');
            }
        }
    }

    public function updateCustomersBanStatusAction()
    {
        $this->view->disable();

        $request = $this->request;
        if ($request->isPost() && $request->isAjax()) {
            // Ogni identificativo è composto da tpanag + cdanag
            $customers = $_POST['customers'];
            $cdblco = $_POST['cdblco'];

            $everythingOk = false;
            if (!empty($customers)) {
                $db = Di::getDefault()->get('db');
                foreach ($customers as $idx => $customer) {
                    $customers[$idx] = $db->escapeString($customer);
                }
                $dtblco = $cdblco != 0 ? date('Y-m-d') : '0000-00-00';

                $query = "UPDATE anagra SET cdblco = :cdblco, dtblco = :dtblco WHERE CONCAT(tpanag, cdanag) IN (" . implode(',', $customers) . ")";
                $everythingOk = $db->query($query, ['cdblco' => $cdblco, 'dtblco' => $dtblco]);
            }


            if ($everythingOk) {
                echo json_encode('OK');
            } else {
                echo json_encode('UC');
            }
        }
    }

    public function updateCustomersLoginStatusAction()
    {
        $this->view->disable();

        $request = $this->request;
        if ($request->isPost() && $request->isAjax()) {
            $users = $_POST['users'];
            $setters = [];
            $params = [];
            $mustChangeEnabled = $request->hasPost('enabled') && $_POST['enabled'] != '-1';
            if ($mustChangeEnabled) {
                $setters[] = 'enabled = :enabled';
                $params['enabled'] = $_POST['enabled'];
            }
            $mustChangeOrderEnabled = $request->hasPost('orders_enabled') && $_POST['orders_enabled'] != '-1';
            if ($mustChangeOrderEnabled) {
                $setters[] = 'orders_enabled = :orders_enabled';
                $params['orders_enabled'] = $_POST['orders_enabled'];
            }

            $everythingOk = false;
            if (!empty($users) && !empty($setters)) {
                $db = Di::getDefault()->get('db');
                foreach ($users as $idx => $user) {
                    $user[$idx] = $db->escapeString($user);
                }

                $query = "UPDATE b2b_sysusr SET " . implode(', ', $setters) . " WHERE id IN (" . implode(',', $users) . ")";
                $everythingOk = $db->query($query, $params);
            }

            if ($everythingOk) {
                echo json_encode('OK');
            } else {
                echo json_encode('UC');
            }
        }
    }

    public function getShippingsForCustomerAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $tpanag = $request->getPost('tpanag');
            $cdanag = $request->getPost('cdanag');

            $shippings = Desmer::getAllShippingsForCustomer($tpanag, $cdanag);
            $ananaz = Ananaz::find(array('order' => 'dsnazi'));
            $anazon = Anazon::find(array('order' => 'dszona'));

            $html = $this->getModalContentForCustomerShippingsManagement($shippings, $ananaz, $anazon);

            echo json_encode($html);
        }
    }

    public function getNewShippingFormForCustomerAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $ananaz = Ananaz::find(array('order' => 'dsnazi'));
            $anazon = Anazon::find(array('order' => 'dszona'));

            $html = $this->getModalContentForNewCustomerShipping($ananaz, $anazon);

            echo json_encode($html);
        }
    }

    public function getCustomersSearchCountAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $searchText = $request->getPost('search_term');

            $totCustomers = Anagra::getCountCustomers($this->config->param->custnonulist, $searchText);

            echo json_encode($totCustomers);
        }
    }

    public function editCustomerShippingAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cddesm = $_POST['cddesm'];
            $tpanag = $_POST['tpanag'];
            $cdanag = $_POST['cdanag'];
            $descri = isset($_POST['descri']) ? $_POST['descri'] : '';
            $indiri = isset($_POST['indiri']) ? $_POST['indiri'] : '';
            $codcap = isset($_POST['codcap']) ? $_POST['codcap'] : '';
            $ccitta = isset($_POST['ccitta']) ? $_POST['ccitta'] : '';
            $provin = isset($_POST['provin']) ? $_POST['provin'] : '';
            $cdnazi = isset($_POST['cdnazi']) ? $_POST['cdnazi'] : '';
            $cdzona = isset($_POST['cdzona']) ? $_POST['cdzona'] : '';
            $cdblco = isset($_POST['cdblco']) ? $_POST['cdblco'] : '';
            $numtel = isset($_POST['numtel']) ? $_POST['numtel'] : '';
            $numcel = isset($_POST['numcel']) ? $_POST['numcel'] : '';
            $numfax = isset($_POST['numfax']) ? $_POST['numfax'] : '';

            if ($cddesm != -1) {
                Desmer::updateShipping($cddesm, $tpanag, $cdanag, $descri, $indiri, $codcap, $ccitta, $provin, $cdnazi, $cdzona, $cdblco, $numtel, $numcel, $numfax);
            } else {
                Desmer::insertShipping($tpanag, $cdanag, $descri, $indiri, $codcap, $ccitta, $provin, $cdnazi, $cdzona, $cdblco, $numtel, $numcel, $numfax);
            }

            echo json_encode('OK');
        }
    }

    public function createuserdsmAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cddesm = $request->getPost('cddesm');
            $username = $request->getPost('username');
            $password = $request->getPost('password');
            $enabled = $request->getPost('enabled');
            $catalogs = $request->getPost('catalogs');

            $licenses = $this->getLicenses();
            if ($enabled == 0 || $licenses['licenses'] < $licenses['total_licenses']) {
                $user = new B2bSysusr();
                $user->username = $username;
                $user->password = sha1($password);
                $user->created_at = new \Phalcon\Db\RawValue('now()');
                $user->enabled = $enabled;
                $user->type = 5; // 1 - super admin; 2 - admin; 3 - agent; 4 - customer; 5 - goods destination
                $user->locale = "it";

                if ($user->save() == false) {
                    echo json_encode("US");
                } else {
                    $id_usr = $user->id;

                    $usrdsm = new B2bUsrdsm();
                    $usrdsm->id_usr = $id_usr;
                    $usrdsm->cddesm = $cddesm;

                    if ($usrdsm->save() == false) {
                        echo json_encode("UA");
                    } else {
                        $everythingOk = true;
                        if ($catalogs != null) {
                            foreach ($catalogs as $cdcata) {
                                $usrctl = new B2bUsrctl();
                                $usrctl->id_usr = $id_usr;
                                $usrctl->cdcata = $cdcata;

                                if ($usrctl->save() == false) {
                                    $everythingOk &= false;
                                }
                            }
                        }

                        if ($everythingOk) {
                            echo json_encode("OK");
                        } else {
                            echo json_encode("UC");
                        }
                    }
                }
            } else {
                echo json_encode("LT");
            }
        }
    }

    public function createusersdsmAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $shippings = $_POST['shippings'];
            $prefix = $this->utility->getAppUtils('prefix');
            $index = $this->utility->getAppUtils('index');

            $everythingOk = true;
            foreach ($shippings as $cddesm) {
                $username = $prefix . sprintf('%05d', $index);
                $password = B2bSysusr::generateUserPasswordString($username);
                $enabled = 0;

                $user = new B2bSysusr();
                $user->username = $username;
                $user->password = sha1($password);
                $user->created_at = new \Phalcon\Db\RawValue('now()');
                $user->enabled = $enabled;
                $user->type = 5; // 1 - super admin; 2 - admin; 3 - agent; 4 - customer; 5 - goods destination
                $user->locale = "it";

                if ($user->save() == false) {
                    $everythingOk &= false;
                } else {
                    $id_usr = $user->id;

                    $usrdsm = new B2bUsrdsm();
                    $usrdsm->id_usr = $id_usr;
                    $usrdsm->cddesm = $cddesm;

                    if ($usrdsm->save() == false) {
                        $everythingOk &= false;
                    }
                }

                $index++;
            }

            $this->utility->setAppUtils('index', $index);

            if ($everythingOk) {
                echo json_encode("OK");
            } else {
                echo json_encode("UC");
            }
        }
    }

    public function editAgentAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdagen = null !== $request->getPost('cdagen') ? $request->getPost('cdagen') : 0;
            $nulist = null !== $request->getPost('nulist') ? $request->getPost('nulist') : 0;
            $indema = $request->getPost('indema');
            $fldfbh = $request->getPost('fldfbh');
            $nulist_s = $request->getPost('nulist_s');

            Anaage::updatePriceListForAgent($cdagen, $nulist);

            if ($indema == '') {
                B2bAddinf::deleteAgentEmail($cdagen);
            } else {
                $addinf = B2bAddinf::getAgentEmail($cdagen);
                if ($addinf == null) {
                    B2bAddinf::insertAgentEmail($cdagen, $indema);
                } else {
                    B2bAddinf::updateAgentEmail($cdagen, $indema);
                }
            }

            if ($fldfbh == '') {
                B2bAddinf::deleteAgentDifferentBehaviourFlag($cdagen);
            } else {
                $addinf = B2bAddinf::getAgentDifferentBehaviourFlag($cdagen);
                if ($addinf == null) {
                    B2bAddinf::insertAgentDifferentBehaviourFlag($cdagen, $fldfbh);
                } else {
                    B2bAddinf::updateAgentDifferentBehaviourFlag($cdagen, $fldfbh);
                }
            }

            B2bAddinf::deleteSelectablePriceListsForAgent($cdagen);
            if (!empty($nulist_s)) {
                for ($i = 0; $i < count($nulist_s); $i++) {
                    B2bAddinf::insertSelectablePriceListsForAgent($cdagen, $nulist_s[$i], $i + 1);
                }
            }

            echo json_encode('OK');
        }
    }

    public function getUsersForAgentAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdagen = $request->getPost('cdagen');

            $users = B2bSysusr::getUsersForAgent($cdagen);
            $full_users = array();
            foreach ($users as $user) {
                $currentUser = $user;
                $currentUser->catalogs = Cttest::getAllCatalogsForUser($currentUser->id);
                $full_users[] = $currentUser;
            }

            $catalogs = Cttest::find();

            $html = $this->getModalContentForAgentUsersManagement($full_users, $catalogs);

            echo json_encode($html);
        }
    }

    public function getNewUserFormForAgentAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $catalogs = Cttest::find();

            $html = $this->getModalContentForNewAgentUser($catalogs);

            echo json_encode($html);
        }
    }

    public function deleteUserAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $id_usr = $request->getPost('idusr');
            B2bSysusr::deleteUser($id_usr);
            B2bUsrage::deleteUser($id_usr);
            B2bUsrcpn::deleteAllRecordsForIdUsr($id_usr);
            B2bUsrctl::deleteAllCatalogsForUser($id_usr);
            echo json_encode('OK');
        }
    }

    public function editUserAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $id_usr = $request->getPost('idusr');
            $cdagen = $request->getPost('cdagen');
            $cdblco = $request->getPost('cdblco');
            $username = $request->getPost('username');
            $editpassword = $request->getPost('editpassword');
            $password = $request->getPost('password');
            $enabled = $request->getPost('enabled');
            $catalogs = $request->getPost('catalogs');

            if (isset($_POST['orders_enabled'])) {
                $ordersEnabled = intval($_POST['orders_enabled']);
            } else {
                $ordersEnabled = 1;
            }

            $user = B2bSysusr::findFirstByUsername($username);
            if ($user != null && $user->id != $id_usr) {
                // Username already in use
                echo json_encode("IU");
                return;
            }

            $primaEraAttivo = false;
            $insertUsrage = false;
            if ($id_usr != -1) {
                $user = B2bSysusr::findFirstById($id_usr);
                if ($editpassword == 'true') {
                    $user->password = sha1($password);
                }
                $primaEraAttivo = $user->enabled == 1;
            } else {
                $user = new B2bSysusr();
                $user->password = sha1($password);
                $user->created_at = new \Phalcon\Db\RawValue('now()');
                $user->type = 3; // 1 - super admin; 2 - admin; 3 - agent; 4 - customer; 5 - goods destination
                $user->locale = "it";
                $insertUsrage = true;
            }

            $user->username = $username;
            $user->enabled = $enabled;
            $user->orders_enabled = $ordersEnabled;

            $oraAttivo = $user->enabled == 1;
            if ($user->type == B2bSysusr::TYPE_CUSTOMER && $cdblco !== null && ($userCustomer = B2bUsrana::findFirstByIdUsr($user->id))) {
                $customer = Anagra::findCustomerByKey($userCustomer->tpanag, $userCustomer->cdanag);
                if ($customer) {
                    $primaEraAttivo = $primaEraAttivo && $customer->cdblco == 0;

                    $customer->cdblco = $cdblco;
                    $customer->dtblco = $cdblco != 0 ? date('Y-m-d') : '0000-00-00';
                    $customer->notdes = $customer->notdes ?: new \Phalcon\Db\RawValue('""');

                    $oraAttivo = $oraAttivo && $customer->cdblco == 0;

                    if ($customer->save() == false) {
                        echo json_encode('US');
                        return;
                    }
                }
            }

            $licenses = $this->getLicenses();
            if (!$primaEraAttivo && $oraAttivo) {
                $licenses["licenses"]++;
                if ($licenses["licenses"] > $licenses["total_licenses"]) {
                    echo json_encode("LT");
                    return;
                }
            }

            if ($user->save() == false) {
                echo json_encode('US');
                return;
            }

            $id_usr = $user->id;

            if ($insertUsrage) {
                $usrage = new B2bUsrage();
                $usrage->id_usr = $id_usr;
                $usrage->cdagen = $cdagen;

                if ($usrage->save() == false) {
                    echo json_encode("UA");
                    return;
                }
            }

            B2bUsrctl::deleteAllCatalogsForUser($id_usr);

            if (count($catalogs) > 0) {
                B2bUsrctl::insertCatalogsForUser($id_usr, $catalogs);
            }

            echo json_encode($licenses);
        }
    }

    public function modifyStatusAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdanag = $request->getPost('cdanag');
            $banLevel = $request->getPost('value');
            Anagra::changeBlockStatus($cdanag, $banLevel);

            echo json_encode($this->getLicenses());
        }
    }

    public function modifyLoginStatusAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $id_usr = $request->getPost('idusr');
            $type = $request->getPost('type');
            $enabled = $request->getPost('enabled');

            B2bSysusr::changeStatus($id_usr, $type, $enabled);

            $user = B2bSysusr::findFirstById($id_usr);

            // If we are enabling user, and we didn't already mail him/her, and he/she is customer or goods destination
            if ($enabled == 1 && $user->email_sent == 0 && ($user->type == 4 || $user->type == 5)) {
                $this->utility->sendNewAccessEmailToUser($user);
            }

            echo json_encode($this->getLicenses());
        }
    }

    public function bulkstatusAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $idusrs = $request->getPost('idusrs');
            $enable = $request->getPost('enable');

            $users = "";

            if (count($idusrs) > 0) {
                $users = B2bSysusr::find('id IN (' . implode(',', $idusrs) . ')');

                foreach ($users as $user) {
                    $user->enabled = $enable;

                    // If we are enabling user, and we didn't already mail him/her, and he/she is customer or goods destination
                    if ($enable == 1 && $user->email_sent == 0 && ($user->type == 4 || $user->type == 5)) {
                        $this->utility->sendNewAccessEmailToUser($user);
                    }

                    if ($user->save() === false) {
                        echo json_encode('US');
                    }
                }
            }

            echo json_encode('OK');
        }
    }

    public function resetUsersPasswordAction()
    {
        $this->view->disable();

        $request = $this->request;
        if ($request->isPost() && $request->isAjax()) {

            $userIds = $request->getPost('userIds');
            $sendMail = $request->hasPost('sendMail') && $request->getPost('sendMail', 'int!', 0);

            if (!empty($userIds)) {
                $users = B2bSysusr::find('id IN (' . implode(',', $userIds) . ')');
                /** @var B2bSysusr $user */
                foreach ($users as $user) {
                    try {
                        $newPassword = $user->resetPassword();
                        if (!empty($newPassword)) {
                            if ($sendMail && $user->enabled == 1 && ($user->type == 4 || $user->type == 5)) {
                                if (empty($user->last_login)) { // || $user->email_sent == 0
                                    $this->utility->sendNewAccessEmailToUser($user, $newPassword);
                                } else {
                                    $this->utility->sendPasswordResetEmailToUser($user, $newPassword);
                                }
                            }
                        }
                    } catch (\Exception $ex) {
                        $this->logger->error("Password Reset of user {$user->username} [{$user->id}] - {$ex->getMessage()}");
                    }
                }
            }

            echo json_encode('OK');
            return;
        }

        echo json_encode('ER');
    }

    public function deleteNewCustomerAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdanag = $request->getPost('cdanag');

            Anagra::deleteNewCustomer($cdanag);
            Octest::deleteOrdersForNewCustomer($cdanag);

            echo json_encode('OK');
        }
    }

    public function setManagedAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $descri = $_POST['descri'];
            $dtcrea = $_POST['dtcrea'];

            B2bReqacc::elaborateRequest($descri, $dtcrea);

            echo json_encode("OK");
        }
    }

    public function deleteReqAccessAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $descri = $_POST['descri'];
            $dtcrea = $_POST['dtcrea'];

            B2bReqacc::deleteRequest($descri, $dtcrea);

            echo json_encode('OK');
        }
    }

    public function dolinkcatalogsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $idusrs = $_POST['idusrs'];
            $cdcatas = $_POST['cdcatas'];
            $mode = $_POST['mode'];

            if ($mode == 1) {
                // Replacement
                B2bUsrctl::deleteAllCatalogsForUsers($idusrs);
            }

            B2bUsrctl::insertCatalogsForUsers($idusrs, $cdcatas);

            echo json_encode("OK");
        }
    }

    public function getCustomerDetailAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $tpanag = $_POST['tpanag'];
            $cdanag = $_POST['cdanag'];

            $anagra = Anagra::getCustomer($tpanag, $cdanag);

            echo json_encode($anagra);
        }
    }

    public function sendNewCustomersEmailAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $this->utility->sendNewCustomersEmail($this->session->get('language'));

            echo json_encode('OK');
        }
    }

    public function saveNewAdminAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $username = $this->request->getPost('username', 'alphanum');
            $password = $this->request->getPost('password');
            $password2 = $this->request->getPost('password2');

            if ($username != '' && $password != '' && $password == $password2) {
                $user = new B2bSysusr();
                $user->username = $username;
                $user->password = sha1($password);
                $user->created_at = new \Phalcon\Db\RawValue('now()');
                $user->enabled = 1;
                $user->type = 2;
                $user->locale = 'it';
                $user->save();
            }

            echo json_encode('OK');
        }
    }

    public function updateUserAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $idUser = $this->request->getPost('id');
            $username = $this->request->getPost('username', 'alphanum');
            $password = $this->request->getPost('password');
            $editpassword = $this->request->getPost('editpassword');

            if ($username != '') {
                $user = B2bSysusr::findFirstById($idUser);
                $user->username = $username;
                if ($editpassword == 'true') {
                    $user->password = sha1($password);
                }
                $user->save();
            }

            // Update admin username in logs
            $logs = B2bCtllog::findByIdAdm($idUser);
            if (count($logs) > 0) {
                foreach ($logs as $log) {
                    $log->respon = $username;
                    $log->save();
                }
            }

            echo json_encode('OK');
        }
    }
    //endregion

    //region Ajax functions: Parameters, notes, banner and category banner management
    public function updateSettingsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $settings = $request->getPost('settings');
            $login = $request->getPost('login');
            $logo = $request->getPost('logo');

            B2bApputi::updateRow('login_bg', $login);
            B2bApputi::updateRow('logo_image', $logo);

            if (count($settings) > 0) {
                foreach ($settings as $key => $value) {
                    if (B2bAppset::updateRow($value['setting'], $value['value']) === false) {
                        echo json_encode("UT");
                    }
                }
            }
            echo json_encode("OK");
        }
    }

    public function updateUtilsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $utils = $request->getPost('utils');

            $allDone = true;
            if (count($utils) > 0) {
                foreach ($utils as $key => $value) {
                    if (B2bApputi::updateRow($value['param'], $value['value']) === false) {
                        $allDone = false;
                        break;
                    }
                }
            }
            if ($allDone) {
                echo json_encode('OK');
            } else {
                echo json_encode('UT');
            }
        }
    }

    public function updateParamsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $params = $request->getPost('params');

            if (count($params) > 0) {
                foreach ($params as $key => $value) {
                    if (B2bMngpar::updateRow($value['param'], $value['value']) === false) {
                        echo json_encode("UT");
                    }
                }
            }
            echo json_encode("OK");
        }
    }

    public function updateBannerAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            if (B2bApputi::updateRow('banner', $_POST['banner']) === false) {
                echo json_encode('UT');
            } else {
                echo json_encode('OK');
            }
        }
    }

    public function getCategoryBannersAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $data = $request->getPost('data');

            switch ($data) {
                case 'linmod':
                    $elements = Linmod::getAllLinesWithBanner();
                    break;
                case 'sermod':
                    $elements = Sermod::getAllSeriesWithBanner();
                    break;
                case 'bramod':
                    $elements = B2bBramod::getAllBrandWithBanner();
            }

            switch ($data) {
                case 'bramod':
                    $html = '<div class="row text-center">';
                    $html .= '
    
                  <div class="input-group" style="display:flex;">
                  <select name="cdling" id="cdling" class="form-control" style="margin-left:13px; margin-bottom:15px; width:350px">
                      <option value="it" class="enable" selected>Italiano</option>
                      <option value="en" class="enable">Inglese</option>
                      <option value="de" class="enable">Tedesco</option>
                      <option value="fr" class="enable">Francese</option>
                      <option value="es" class="enable">Spagnolo</option>
                  </select>
                  <div class="input-group-append">
                    <button class="btn btn-primary" style="margin-left:30px;" type="button" id="loadBannerBrand">Carica</button>  
                    <button class="btn btn-primary  saveBannerBrand" type="button">Salva</button>
                  </div>
                  </div>   ';

                    foreach ($elements as $element) {
                        $html .= '<div class="col-md-4 col-sm-4 col-xs-4 mb-40x">';
                        $html .= '<b>' . $element->description . '</b>';
                        $html .= '<br>';
                        $html .= '<input id="dwlist-' . $element->code1 . '" type="checkbox" name="brand" value=""> Scarica Listino </input>';
                        $html .= ' <textarea  rows="2" style="margin-top:5px" id="dsbann-' . $element->code1 . '" class="form-control jqte-banner" placeholder="Inserisci Testo"  ></textarea>';
                        $html .= '<form id="fimag-' . $element->code1 . '" action="' . $this->url->get('admin/uploadImageBrand') . '" class="dropzone dropzone-slide-brand" style="margin:0 auto" ';
                        $html .= ' data-code1="' . $element->code1 . '" data-code2="' . $element->code2 . '" data-image="' . $element->banner . '"> ';
                        $html .= '</form>';
                        $html .= '</div>';
                    }
                    $html .= '</div>';
                    $html .= '<div class="row text-right"><button class="btn btn-primary w-20 saveBannerBrand" type="button">Salva</button></div>"';
                    $html .= '<div class="row mt-20x">';
                    $html .= '  <div class="col-md-12 col-sm-12 col-xs-12">';
                    $html .= '    <div class="msg-error">' . $this->translate('_common.generic.db.error') . ' </div>';
                    $html .= '    <div class="msg-success">' . $this->translate('_common.generic.db.success') . '</div>';
                    $html .= '  </div>';
                    $html .= '</div>';
                    break;
                default:

                    $html = '<div class="row text-center">';
                    foreach ($elements as $element) {
                        $html .= '<div class="col-md-4 col-sm-4 col-xs-4 mb-40x">';
                        $html .= $element->description;
                        $html .= '<form action="' . $this->url->get('admin/uploadImage') . '" class="dropzone dropzone-slide" style="margin:0 auto" ';
                        $html .= ' data-code1="' . $element->code1 . '" data-code2="' . $element->code2 . '" data-image="' . $element->banner . '"> ';
                        $html .= '</form>';
                        $html .= '</div>';
                    }
                    $html .= '</div>';
                    break;
            }

            echo json_encode(array(
                'response' => 'OK',
                'html' => $html,
            ));

        }
    }

    // #banner brand region MARCO & SAMUELE 24.11.2022

    public function saveBannerBrandAction()
    {
        // salvataggio dei dati del Brand
        $this->view->disable();


        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $brand = $request->getPost('b2bbrand');
            $cdling = $request->getPost('cdling');

            B2BBramod::deleteBannerBrand($cdling);
            B2bBramod::insertBannerBrand(json_decode($brand));
            echo json_encode('OK');
        }

    }


    public function loadBannerBrandAction()
    {
        // salvataggio dei dati del Brand
        $this->view->disable();
        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdling = $request->getPost('cdling');

            $results = B2bBramod::find([
                "conditions" => "cdling = :cdling:",
                "bind" => [
                    "cdling" => $cdling
                ]
            ]);

            echo json_encode($results);
        }

    }


    public function updateBrandBannerAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdling = $request->getPost('cdling');
            $code1 = $request->getPost('code1');
            $code2 = $request->getPost('code2');
            $image = $request->getPost('image');


            if ($image != '') {
                B2bBramod::updateImageBrand($cdling, $code1, $code2, $image);
            } else {
                B2bBramod::deleteImageBrand($cdling, $code1, $code2);
            }

            echo json_encode('OK');
        }
    }

    public function updateCategoryBannerAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $category = $request->getPost('category');
            $code1 = $request->getPost('code1');
            $code2 = $request->getPost('code2');
            $image = $request->getPost('image');

            if ($image != '') {
                B2bAddinf::insertCategoryBanner($category, $code1, $code2, $image);
            } else {
                B2bAddinf::deleteCategoryBanner($category, $code1, $code2);
            }

            echo json_encode('OK');
        }
    }
    //endregion

    //region Ajax functions: Coupon management
    public function createCouponAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $dscoup = $_POST['dscoup'];
            $tpcoup = $_POST['tpcoup'];
            $impsco = $_POST['impsco'];
            $dtiniz = date('Y-m-d', strtotime(str_replace('/', '-', $_POST['dtiniz'])));
            $dtfine = date('Y-m-d', strtotime(str_replace('/', '-', $_POST['dtfine'])));
            $qtamin = $_POST['qtamin'];
            $qtamax = $_POST['qtamax'];
            $cpnmax = $_POST['cpnmax'];
            $usrmax = $_POST['usrmax'];
            $tpcata = $_POST['tpcata'];
            $tpuser = $_POST['tpuser'];
            $catalogs = $_POST['catalogs'];
            $agents = $_POST['agents'];
            $customers = $_POST['customers'];
            $shippings = $_POST['shippings'];

            $coupon = new B2bCoupon();
            $coupon->dscoup = $dscoup;
            $coupon->tpcoup = $tpcoup;
            $coupon->impsco = $impsco;
            $coupon->dtiniz = $dtiniz;
            $coupon->dtfine = $dtfine;
            $coupon->qtamin = $qtamin;
            $coupon->qtamax = $qtamax;
            $coupon->cpnmax = $cpnmax;
            $coupon->cpncnt = $cpnmax;
            $coupon->usrmax = $usrmax;
            $coupon->tpcata = $tpcata;
            $coupon->tpuser = $tpuser;

            if ($coupon->save() === false) {
                echo json_encode("CP");
            } else {
                if ($coupon->tpcata == 1) {
                    B2bCtlcpn::insertCatalogsForCoupon($coupon->cdcoup, $catalogs);
                }

                if ($coupon->tpuser == 2) {
                    B2bUsrcpn::insertCouponForUsers($coupon->cdcoup, $coupon->usrmax, $agents);
                } else if ($coupon->tpuser == 4) {
                    B2bUsrcpn::insertCouponForUsers($coupon->cdcoup, $coupon->usrmax, $customers);
                } else if ($coupon->tpuser == 6) {
                    B2bUsrcpn::insertCouponForUsers($coupon->cdcoup, $coupon->usrmax, $shippings);
                }

                $this->utility->sendCouponEmailToUser($coupon, $customers, $shippings);

                echo json_encode("OK");
            }
        }
    }

    public function getCouponAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdcoup = $_POST['cdcoup'];
            $coupon = B2bCoupon::findFirstByCdcoup($cdcoup);

            if ($coupon != null) {
                $catalogs = B2bCtlcpn::findByCdcoup($cdcoup);
                $users = B2bUsrcpn::findByCdcoup($cdcoup);
                echo json_encode(array('coupon' => $coupon, 'catalogs' => $catalogs, 'users' => $users));
            } else {
                echo json_encode('CP');
            }
        }
    }

    public function modifyCouponAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdcoup = $_POST['cdcoup'];
            $dscoup = $_POST['dscoup'];
            $tpcoup = $_POST['tpcoup'];
            $impsco = $_POST['impsco'];
            $dtiniz = date('Y-m-d', strtotime(str_replace('/', '-', $_POST['dtiniz'])));
            $dtfine = date('Y-m-d', strtotime(str_replace('/', '-', $_POST['dtfine'])));
            $qtamin = $_POST['qtamin'];
            $qtamax = $_POST['qtamax'];
            $cpnmax = $_POST['cpnmax'];
            $usrmax = $_POST['usrmax'];
            $tpcata = $_POST['tpcata'];
            $tpuser = $_POST['tpuser'];
            $catalogs = $_POST['catalogs'];
            $agents = $_POST['agents'];
            $customers = $_POST['customers'];
            $shippings = $_POST['shippings'];

            $coupon = B2bCoupon::findFirstByCdcoup($cdcoup);
            $coupon->dscoup = $dscoup;
            $coupon->tpcoup = $tpcoup;
            $coupon->impsco = $impsco;
            $coupon->dtiniz = $dtiniz;
            $coupon->dtfine = $dtfine;
            $coupon->qtamin = $qtamin;
            $coupon->qtamax = $qtamax;
            $coupon->cpnmax = $cpnmax;
            $coupon->cpncnt = $cpnmax;
            $coupon->usrmax = $usrmax;
            $coupon->tpcata = $tpcata;
            $coupon->tpuser = $tpuser;

            if ($coupon->save() === false) {
                echo json_encode("CP");
            } else {
                // Delete old rows
                B2bCtlcpn::deleteAllRecordsForCdcoup($coupon->cdcoup);
                B2bUsrcpn::deleteAllRecordsForCdcoup($coupon->cdcoup);

                if ($coupon->tpcata == 1) {
                    B2bCtlcpn::insertCatalogsForCoupon($coupon->cdcoup, $catalogs);
                }

                if ($coupon->tpuser == 2) {
                    B2bUsrcpn::insertCouponForUsers($coupon->cdcoup, $coupon->usrmax, $agents);
                } else if ($coupon->tpuser == 4) {
                    B2bUsrcpn::insertCouponForUsers($coupon->cdcoup, $coupon->usrmax, $customers);
                } else if ($coupon->tpuser == 6) {
                    B2bUsrcpn::insertCouponForUsers($coupon->cdcoup, $coupon->usrmax, $shippings);
                }

                echo json_encode("OK");
            }
        }
    }

    public function deleteCouponsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $coupons = $_POST['coupons'];

            B2bCoupon::deleteAllRecordsForCoupons($coupons);
            B2bCtlcpn::deleteAllRecordsForCoupons($coupons);
            B2bUsrcpn::deleteAllRecordsForCoupons($coupons);

            echo json_encode("OK");
        }
    }
    //endregion

    //region Ajax functions: Custom conditions
    public function saveCustomPaymentAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $tppaga = $request->getPost('tppaga');
            $initialConfig = $request->getPost('initial_config', null, '');
            // Eliminiamo tutte le righe che coincidono con questa configurazione
            if (!empty($initialConfig)) {
                B2bCuspag::find(array(
                    "tppaga = :tppaga: AND config = :config:",
                    'bind' => array('tppaga' => $tppaga, 'config' => $initialConfig)))->delete();
            }
            $config = $request->getPost('config');
            $dspaga = $request->getPost('dspaga');

            $codiciNazioni = $request->getPost('codici_nazioni');
            if (!is_array($codiciNazioni)) {
                $codiciNazioni = empty($codiciNazioni) ? [] : [$codiciNazioni];
            }

            foreach ($codiciNazioni as $codiceNazione) {
                B2bCuspag::insertNewCustomPayment([
                    'tppaga' => $tppaga,
                    'dspaga' => $dspaga,
                    'config' => $config,
                    'cdnazi' => $codiceNazione
                ]);
            }

            echo json_encode("OK");
        }


    }

    public function deleteCustomPaymentAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $numpag = $request->getPost('numpag');
            $multi_numpag = $request->getPost('multi_numpag');

            $to_delete = array();
            if ($numpag != '') {
                $to_delete[] = $numpag;
            } else {
                $to_delete = explode(',', $multi_numpag);
            }

            foreach ($to_delete as $el) {
                // Delete all old cuspag with same info of cuspag.numpag = numpag
                $template = B2bCuspag::findFirstByNumpag($el);
                if ($template) {
                    // Eliminiamo tutte le righe che coincidono con questa configurazione
                    B2bCuspag::find([
                        'tppaga = :tppaga: AND config = :config:',
                        'bind' => ['tppaga' => $template->tppaga, 'config' => $template->config]
                    ])->delete();
                }
            }

            echo json_encode("OK");
        }
    }

    public function getCustomShipmentByTpportAction()
    {
        $this->view->disable();
        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $tpor = $request->getPost('tpport');
            $shippingTpport = B2bCuspor::getCustomShipmentsByTpport($tpor);

            echo json_encode($shippingTpport);
        }
    }

    public function saveCustomShipmentAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $tpport = $request->getPost('tpport');
            $initialConfig = $request->getPost('initial_config', null, '');

            if (!empty($initialConfig)) {
                // Eliminiamo tutte le righe che coincidono con questa configurazione
                B2bCuspor::find([
                    "tpport = :tpport: AND config = :config:",
                    'bind' => ['tpport' => $tpport, 'config' => $initialConfig]
                ])->delete();
            }

            $config = $request->getPost('config');
            $dstpor = $request->getPost('dstpor');

            $codiciNazioni = $request->getPost('codici_nazioni');
            if (!is_array($codiciNazioni)) {
                $codiciNazioni = empty($codiciNazioni) ? [] : [$codiciNazioni];
            }

            foreach ($codiciNazioni as $codiceNazione) {
                B2bCuspor::insertNewCustomShipment([
                    'tpport' => $tpport,
                    'dstpor' => $dstpor,
                    'config' => $config,
                    'cdnazi' => $codiceNazione
                ]);
            }

            echo json_encode("OK");
        }
    }

    public function deleteCustomShipmentAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $numpor = $request->getPost('numpor');
            $multi_numpor = $request->getPost('multi_numpor');

            $to_delete = array();
            if ($numpor != '') {
                $to_delete[] = $numpor;
            } else {
                $to_delete = explode(',', $multi_numpor);
            }

            foreach ($to_delete as $el) {
                // Delete all old cuspor with same info of cuspor.numpor = numpor
                $template = B2bCuspor::findFirstByNumpor($el);
                // Eliminiamo tutte le righe che coincidono con questa configurazione
                if ($template) {
                    B2bCuspor::find([
                        'tpport = :tpport: AND config = :config:',
                        'bind' => ['tpport' => $template->tpport, 'config' => $template->config]
                    ])->delete();
                }
            }

            echo json_encode("OK");
        }
    }

    public function setDefaultConditionsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $startDate = isset($_POST['startDate']) ? $_POST['startDate'] : '2021-01-01';
            $endDate = isset($_POST['endDate']) ? $_POST['endDate'] : '2021-01-31';
            $tpindo = isset($_POST['tpindo']) ? $_POST['tpindo'] : 'MAIN';

            B2bApputi::updateRow('zan_date_start', $startDate);
            B2bApputi::updateRow('zan_date_end', $endDate);
            B2bApputi::updateRow('zan_default_ind', $tpindo);

            echo json_encode('OK');
        }
    }
    //endregion

    //region Ajax functions: Custom discounts
    public function changecustomdiscountstatusAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            B2bDishea::updateBlockFlag(
                $request->getPost('numdis'),
                $request->getPost('flbloc')
            );

            echo json_encode('OK');
        }
    }

    public function deleteCustomDiscountAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $numdis = $request->getPost('numdis');

            B2bDishea::deleteAllRecordsForNumdis($numdis);
            B2bDisbdy::deleteAllRecordsForNumdis($numdis);
            B2bDisana::deleteAllRecordsForNumdis($numdis);
            B2bDislst::deleteAllRecordsForNumdis($numdis);
            B2bDisctl::deleteAllRecordsForNumdis($numdis);

            echo json_encode('OK');
        }
    }

    public function saveCustomDiscountHeaderAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $data = json_decode($request->getPost('data'));

            $cddisc = $data->cddisc;
            $dsdisc = $data->dsdisc;
            $dtiniz = $data->dtiniz;
            $dtfine = $data->dtfine;
            $tpdisc = $data->tpdisc;
            $fltota = $data->fltota;
            $cttest = $data->cttest;
            $lstest = $data->lstest;
            $anagra = $data->anagra;
            $flpora = $data->flpora;
            $tpport = $data->tpport;
            $flpaga = $data->flpaga;
            $tppaga = $data->tppaga;

            $isAllowed = B2bDishea::isCurrentCustomDiscountAllowed($cttest, $anagra, $lstest, $flpora, $tpport, $flpaga, $tppaga, $fltota, $dtiniz, $dtfine);

            if (!$isAllowed) {
                echo json_encode(array('response' => 'NO'));
            } else {
                $cdhead = B2bDishea::insertCustomDiscount($cddisc, $dsdisc, $tpdisc, $dtiniz, $dtfine, $fltota, $flpora, $flpaga);

                B2bDisctl::insertCustomDiscountForCatalogs($cdhead->numdis, $cttest);

                if (!$fltota) {
                    // Save discount - customers
                    B2bDisana::insertCustomDiscountForCustomers($cdhead->numdis, $anagra);
                }

                // Save discount - price lists
                B2bDislst::insertCustomDiscountForPriceLists($cdhead->numdis, $lstest);

                // Save discount - ports
                B2bDispor::insertCustomDiscountForPorts($cdhead->numdis, $tpport);

                // Save discount - payment methods
                B2bDispag::insertCustomDiscountForPaymentMethods($cdhead->numdis, $tppaga);

                $response = array(
                    'response' => 'OK', 'numdis' => $cdhead->numdis, 'titlin' => '',
                    'linmod' => '', 'sermod' => '', 'tpmode' => '', 'tipolo' => '', 'anaart' => ''
                );

                $cttest_keys = '';
                $params = array('numdis' => -1);
                for ($i = 0; $i < count($cttest); $i++) {
                    $cttest_keys .= ":cdcata" . $i . ":,";
                    $params['cdcata' . $i] = $cttest[$i];
                }
                $cttest_keys = substr($cttest_keys, 0, -1);

                // check for type = brand
                if ($tpdisc > 31) {
                    $response['titlin'] = $this->getHtmlDiscount('titlin', $cttest_keys, $params);
                    $tpdisc -= 32;
                }
                // check for type = line
                if ($tpdisc > 15) {
                    $response['linmod'] = $this->getHtmlDiscount('linmod', $cttest_keys, $params);
                    $tpdisc -= 16;
                }
                // check for type = series
                if ($tpdisc > 7) {
                    $response['sermod'] = $this->getHtmlDiscount('sermod', $cttest_keys, $params);
                    $tpdisc -= 8;
                }
                // check for type = type models
                if ($tpdisc > 3) {
                    $response['tpmode'] = $this->getHtmlDiscount('tpmode', $cttest_keys, $params);
                    $tpdisc -= 4;
                }
                // check for type = models
                if ($tpdisc > 1) {
                    $response['tipolo'] = $this->getHtmlDiscount('tipolo', $cttest_keys, $params);
                    $tpdisc -= 2;
                }
                // check for type = articles
                if ($tpdisc > 0) {
                    $response['anaart'] = $this->getHtmlDiscount('anaart', $cttest_keys, $params);
                    $tpdisc -= 1;
                }
                echo json_encode($response);
            }
        }
    }

    public function saveCustomDiscountBodyAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdbody = $request->getPost('cdbody');
            $numdis = $request->getPost('numdis');

            B2bDisbdy::insertCustomDiscountBody($numdis, $cdbody);

            echo json_encode('OK');
        }
    }

    public function updateCustomDiscountAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdbody = $request->getPost('cdbody');
            $numdis = $request->getPost('numdis');
            $tpdisc = $request->getPost('tpdisc');
            $cdhead = B2bDishea::findFirstByNumdis($numdis);
            $cdhead->tpdisc = $tpdisc;
            $cdhead->save();
            $old_cdbody = B2bDisbdy::findByNumdis($numdis);
            $old_cdbody->delete();

            foreach ($cdbody as $el) {
                $cdbody = new B2bDisbdy();
                $cdbody->numdis = $numdis;
                $cdbody->sconto = $el['sconto'];
                $cdbody->cdtitl = (isset($el['cdtitl']) && $el['cdtitl'] != '') ? $el['cdtitl'] : new RawValue("''") ;
                $cdbody->cdlinm = (isset($el['cdlinm']) && $el['cdlinm'] != '') ? $el['cdlinm'] : new RawValue("''") ;
                $cdbody->cdserm = (isset($el['cdserm']) && $el['cdserm'] != '') ? $el['cdserm'] : new RawValue("''") ;
                $cdbody->tpmode = (isset($el['tpmode']) && $el['tpmode'] != '') ? $el['tpmode'] : new RawValue("''") ;
                $cdbody->cdartn = (isset($el['cdartn']) && $el['cdartn'] != '') ? $el['cdartn'] : new RawValue("''") ;
                $cdbody->cdarti = (isset($el['cdarti']) && $el['cdarti'] != '') ? $el['cdarti'] : new RawValue("''") ;
                $cdbody->save();
            }

            echo json_encode('OK');
        }
    }
    //endregion

    //region Ajax functions: Stats and dashboard
    public function getOrderDetailAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nuordc = $_POST['nuordc'];

            $order_info = Octest::getOrderDetail($nuordc);
            $order_rows = Occorp::getOrderRowsWithTotals($nuordc);

            $response = array(
                'order_info' => $order_info,
                'order_rows' => $order_rows,
            );

            echo json_encode($response);
        }
    }

    public function updateDashboardAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdstag = $_POST['cdstag'];
            $dtiniz = date('Y-m-d', strtotime(str_replace('/', '-', $_POST['dtiniz'])));
            $dtfine = date('Y-m-d', strtotime(str_replace('/', '-', $_POST['dtfine'])));

            // second row - overall analysis
            $qty = Occorp::getTotalOrdersQuantity($dtiniz, $dtfine, $cdstag);
            $ord = Octest::getCountAllOrders($dtiniz, $dtfine, $cdstag);
            $val = Octagl::getTotalValue($dtiniz, $dtfine, $cdstag);
            $anl = array(
                'aqo' => $ord > 0 ? round($qty / $ord, 2) : '-',
                'avo' => $ord > 0 ? round($val / $ord, 2) : '-',
                'avp' => $qty > 0 ? round($val / $qty, 2) : '-',
                'ord' => $ord,
                'qty' => $qty,
                'val' => $val
            );

            // third row - trends
            $str_dtiniz = strtotime($dtiniz);
            $str_dtfine = strtotime($dtfine);
            $datediff = $str_dtfine - $str_dtiniz;
            $daysdiff = round($datediff / (60 * 60 * 24));
            $num_step = $daysdiff >= 15 ? 15 : $daysdiff;
            $len_step = $num_step < 15 ? 1 : $daysdiff / 15;

            $dates = array();
            $period_dtiniz = $dtiniz;
            for ($i = 0; $i < $num_step + 1; $i++) {
                $period_dtfine = date('Y-m-d', strtotime($dtiniz . ' +' . round($i * $len_step, 0) . ' days'));
                $dates[] = array('dtiniz' => $period_dtiniz, 'dtfine' => $period_dtfine);
                $period_dtiniz = $period_dtfine;
            }

            $trends = $this->getTrends($dates, $cdstag);

            $this->view->orderStateMgmt = $this->utility->getAppSettings('OrderStateManagement');

            echo json_encode(array('anl' => $anl, 'trends' => $trends));
        }
    }

    public function getAnalysisForAgentAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $catalogs = isset($_POST['catalogs']) ? $_POST['catalogs'] : '';
            $agents = isset($_POST['agents']) ? $_POST['agents'] : '';
            $dtiniz = $_POST['dtiniz'] != '' ? date('Y-m-d', strtotime(str_replace('/', '-', $_POST['dtiniz']))) : date('Y-m-d', strtotime("-29 days"));
            $dtfine = $_POST['dtfine'] != '' ? date('Y-m-d', strtotime(str_replace('/', '-', $_POST['dtfine']))) : date('Y-m-d');

            $cat_where = '';
            $age_where = '';
            $params = array('dtiniz' => $dtiniz, 'dtfine' => $dtfine);

            $this->getParamsForSqlAgents($catalogs, $agents, $cat_where, $age_where, $params);

            // overall analysis
            $qty = Occorp::getTotalQuantityAgents($cat_where, $age_where, $params);
            $ord = Octest::getCountOrdersAgents($cat_where, $age_where, $params);
            $val = Octagl::getTotalValueAgents($cat_where, $age_where, $params);
            $anl = array(
                'aqo' => $ord > 0 ? round($qty / $ord, 2) : '-',
                'avo' => $ord > 0 ? round($val / $ord, 2) : '-',
                'avp' => $qty > 0 ? round($val / $qty, 2) : '-',
                'ord' => $ord,
                'qty' => $qty,
                'val' => $val
            );

            // donuts
            $gr1 = Octagl::getRevenueForBrandAgents($cat_where, $age_where, $params);
            $gr2 = Octagl::getRevenueForLineAgents($cat_where, $age_where, $params);
            $gr3 = Octagl::getRevenueForSeriesAgents($cat_where, $age_where, $params);
            $tip = Octagl::getRevenueForModelTypeAgents($cat_where, $age_where, $params);
            $gen = Octagl::getRevenueForGenreAgents($cat_where, $age_where, $params);

            $donuts = array(
                'gr1' => $gr1,
                'gr2' => $gr2,
                'gr3' => $gr3,
                'tip' => $tip,
                'gen' => $gen,
            );

            // Agents
            $age = Octagl::getTotalQuantityAndValueAgents($cat_where, $age_where, $params);

            // Top 20
            $top20Qty = Anaage::getTop20QuantityAgents($cat_where, $age_where, $params);
            $top20Val = Anaage::getTop20ValueAgents($cat_where, $age_where, $params);
            $top20 = array('qty' => $top20Qty, 'val' => $top20Val);

            // map
            $naz = Octagl::getCountriesRevenueAgents($cat_where, $age_where, $params);
            $map = array();
            for ($i = 0; $i < count($naz); $i++) {
                $map[$naz[$i]->cdnazi] = $naz[$i]->value;
            }

            // trends
            $str_dtiniz = strtotime($dtiniz);
            $str_dtfine = strtotime($dtfine);
            $datediff = $str_dtfine - $str_dtiniz;
            $daysdiff = round($datediff / (60 * 60 * 24));
            $num_step = $daysdiff >= 15 ? 15 : $daysdiff;
            $len_step = $num_step < 15 ? 1 : $daysdiff / 15;

            $dates = array();
            $period_dtiniz = $dtiniz;
            for ($i = 0; $i < $num_step + 1; $i++) {
                $period_dtfine = date('Y-m-d', strtotime($dtiniz . ' +' . round($i * $len_step, 0) . ' days'));
                $dates[] = array('dtiniz' => $period_dtiniz, 'dtfine' => $period_dtfine);
                $period_dtiniz = $period_dtfine;
            }
            $trends = $this->getTrendsAgents($dates, $cat_where, $age_where, $params);

            echo json_encode(array('anl' => $anl, 'don' => $donuts, 'naz' => $naz, 'map' => $map, 'trn' => $trends, 't20' => $top20, 'age' => $age));
        }
    }

    public function getAnalysisForCustomerAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $catalogs = isset($_POST['catalogs']) ? $_POST['catalogs'] : '';
            $customers = isset($_POST['customers']) ? $_POST['customers'] : '';
            $dtiniz = $_POST['dtiniz'] != '' ? date('Y-m-d', strtotime(str_replace('/', '-', $_POST['dtiniz']))) : date('Y-m-d', strtotime("-29 days"));
            $dtfine = $_POST['dtfine'] != '' ? date('Y-m-d', strtotime(str_replace('/', '-', $_POST['dtfine']))) : date('Y-m-d');

            $cat_where = '';
            $cus_where = '';
            $params = array('dtiniz' => $dtiniz, 'dtfine' => $dtfine);

            $this->getParamsForSqlCustomers($catalogs, $customers, $cat_where, $cus_where, $params);

            // overall analysis
            $qty = Occorp::getTotalQuantityCustomers($cat_where, $cus_where, $params);
            $ord = Octest::getCountOrdersCustomers($cat_where, $cus_where, $params);
            $val = Octagl::getTotalValueCustomers($cat_where, $cus_where, $params);
            $anl = array(
                'aqo' => $ord > 0 ? round($qty / $ord, 2) : '-',
                'avo' => $ord > 0 ? round($val / $ord, 2) : '-',
                'avp' => $qty > 0 ? round($val / $qty, 2) : '-',
                'ord' => $ord,
                'qty' => $qty,
                'val' => $val
            );

            // donuts
            $gr1 = Octagl::getRevenueForBrandCustomers($cat_where, $cus_where, $params);
            $gr2 = Octagl::getRevenueForLineCustomers($cat_where, $cus_where, $params);
            $gr3 = Octagl::getRevenueForSeriesCustomers($cat_where, $cus_where, $params);
            $tip = Octagl::getRevenueForModelTypeCustomers($cat_where, $cus_where, $params);
            $gen = Octagl::getRevenueForGenreCustomers($cat_where, $cus_where, $params);

            $donuts = array(
                'gr1' => $gr1,
                'gr2' => $gr2,
                'gr3' => $gr3,
                'tip' => $tip,
                'gen' => $gen,
            );

            // Top 20
            $top20Qty = Anagra::getTop20QuantityCustomers($cat_where, $cus_where, $params);
            $top20Val = Anagra::getTop20ValueCustomers($cat_where, $cus_where, $params);
            $top20 = array('qty' => $top20Qty, 'val' => $top20Val);

            // map
            $naz = Octagl::getCountriesRevenueCustomers($cat_where, $cus_where, $params);
            $map = array();
            for ($i = 0; $i < count($naz); $i++) {
                $map[$naz[$i]->cdnazi] = $naz[$i]->value;
            }

            // trends
            $str_dtiniz = strtotime($dtiniz);
            $str_dtfine = strtotime($dtfine);
            $datediff = $str_dtfine - $str_dtiniz;
            $daysdiff = round($datediff / (60 * 60 * 24));
            $num_step = $daysdiff >= 15 ? 15 : $daysdiff;
            $len_step = $num_step < 15 ? 1 : $daysdiff / 15;

            $dates = array();
            $period_dtiniz = $dtiniz;
            for ($i = 0; $i < $num_step + 1; $i++) {
                $period_dtfine = date('Y-m-d', strtotime($dtiniz . ' +' . round($i * $len_step, 0) . ' days'));
                $dates[] = array('dtiniz' => $period_dtiniz, 'dtfine' => $period_dtfine);
                $period_dtiniz = $period_dtfine;
            }
            $trends = $this->getTrendsCustomers($dates, $cat_where, $cus_where, $params);

            echo json_encode(array('anl' => $anl, 'don' => $donuts, 'naz' => $naz, 'map' => $map, 'trn' => $trends, 't20' => $top20));
        }
    }

    public function elaborateAnalysisAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $type = isset($_POST['type']) ? $_POST['type'] : 1;
            $period1 = isset($_POST['per1']) ? $_POST['per1'] : '';
            $period2 = isset($_POST['per2']) ? $_POST['per2'] : '';
            $period3 = isset($_POST['per3']) ? $_POST['per3'] : '';

            $agents = isset($_POST['age']) ? $_POST['age'] : 'all';
            $brands = isset($_POST['brn']) ? $_POST['brn'] : 'all';
            $catalogs = isset($_POST['cat']) ? $_POST['cat'] : 'all';
            $customers = isset($_POST['cus']) ? $_POST['cus'] : 'all';
            $countries = isset($_POST['cou']) ? $_POST['cou'] : 'all';
            $genres = isset($_POST['gen']) ? $_POST['gen'] : 'all';
            $lines = isset($_POST['lin']) ? $_POST['lin'] : 'all';
            $modeltypes = isset($_POST['mot']) ? $_POST['mot'] : 'all';
            $ordertypes = isset($_POST['ort']) ? $_POST['ort'] : 'all';
            $series = isset($_POST['ser']) ? $_POST['ser'] : 'all';

            $this->session->set('anl-stat-type', $type);
            $this->session->set('anl-stat-per1', $period1);
            $this->session->set('anl-stat-per2', $period2);
            $this->session->set('anl-stat-per3', $period3);

            $this->session->set('anl-stat-age', $agents);
            $this->session->set('anl-stat-brn', $brands);
            $this->session->set('anl-stat-cat', $catalogs);
            $this->session->set('anl-stat-cou', $countries);
            $this->session->set('anl-stat-cus', $customers);
            $this->session->set('anl-stat-gen', $genres);
            $this->session->set('anl-stat-lin', $lines);
            $this->session->set('anl-stat-mot', $modeltypes);
            $this->session->set('anl-stat-ort', $ordertypes);
            $this->session->set('anl-stat-ser', $series);

            $stats = $this->getStats();

            $qty1_tot = 0;
            $val1_tot = 0;
            $qty2_tot = 0;
            $val2_tot = 0;
            $qty3_tot = 0;
            $val3_tot = 0;
            for ($i = 0; $i < count($stats); $i++) {
                $qty1_tot += $stats[$i]['qty1'];
                $val1_tot += $stats[$i]['val1'];
                $qty2_tot += isset($stats[$i]['qty2']) ? $stats[$i]['qty2'] : 0;
                $val2_tot += isset($stats[$i]['val2']) ? $stats[$i]['val2'] : 0;
                $qty3_tot += isset($stats[$i]['qty3']) ? $stats[$i]['qty3'] : 0;
                $val3_tot += isset($stats[$i]['val3']) ? $stats[$i]['val3'] : 0;
            }
            $tot = array('qty1' => $qty1_tot, 'val1' => $val1_tot, 'qty2' => $qty2_tot, 'val2' => $val2_tot, 'qty3' => $qty3_tot, 'val3' => $val3_tot);

            $html_content = '';
            if ($period2 != '' || $period3 != '') {
                $html_content .= '
        <ul id="myTabAnalysis" class="nav nav-tabs w-50 anl-multistats" role="tablist" style="margin-left:25%">
          <li role="presentation" class="w-50 active">
            <a href="#tab_syn" data-anchor="tab_syn" role="tab" data-toggle="tab" aria-expanded="true">' . $this->translate('statistics.tab.synthesis') . '</a>
          </li>
          <li role="presentation" class="w-50">
            <a href="#tab_det" data-anchor="tab_det" role="tab" data-toggle="tab" aria-expanded="true">' . $this->translate('statistics.tab.detail') . '</a>
          </li>
        </ul>';
            }

            if ($period2 != '' || $period3 != '') {
                $html_content .= '<div id="myTabAnalysisContent" class="tab-content pb-40x">';
                $html_content .= '<div role="tabpanel" class="tab-pane transition fade w-100 mx-0 in active" id="tab_syn">';
                $html_content .= $this->getHtmlTabSynthesis($tot, $period1, $period2, $period3);
                $html_content .= '</div>';
                $html_content .= '<div role="tabpanel" class="tab-pane transition fade w-100 mx-0" id="tab_det">';
            } else {
                $html_content .= '<div class="pb-40x">';
                $html_content .= '<div class="w-100 mx-0" id="tab_det">';
            }
            $html_content .= $this->getHtmlTabDetail($stats, $type, $tot, $period1, $period2, $period3);
            $html_content .= '</div>';
            $html_content .= '</div>';

            $html_modal = $this->getHtmlModalInfo($type, $period1, $period2, $period3);

            echo json_encode(array('content' => $html_content, 'modal' => $html_modal));
        }
    }

    public function createXlsForStatsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $info = $_POST['info'];

            $stats = $this->getStats();
            $type = intval($this->session->get('anl-stat-type'));

            $spreadsheet = new Spreadsheet();
            $spreadsheet->getProperties()->setCreator('Sinergiattiva')->setTitle($this->translate('_common.statistics'));

            $columns = count($stats) > 0 ? count(get_object_vars((object)$stats[0])) : 0;

            $spreadsheet->setActiveSheetIndex(0);

            $activeSheet = $spreadsheet->getActiveSheet();
            $activeSheet->getColumnDimension('A')->setAutoSize(true);
            $activeSheet->getColumnDimension('B')->setAutoSize(true);
            $activeSheet->getColumnDimension('C')->setAutoSize(true);
            $activeSheet->getColumnDimension('D')->setAutoSize(true);
            $activeSheet->getColumnDimension('E')->setAutoSize(true);
            $activeSheet->getColumnDimension('F')->setAutoSize(true);
            $activeSheet->getColumnDimension('G')->setAutoSize(true);
            $activeSheet->getColumnDimension('I')->setAutoSize(true);
            $activeSheet->getColumnDimension('J')->setAutoSize(true);

            $styleThinBlackBorderOutline = array(
                'borders' => array(
                    'outline' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        'color' => array('argb' => 'FF000000'),
                    ),
                ),
            );

            $txtColTot1 = $info['period2'] == '' && $info['period3'] == ''
                ? strtoupper($this->translate('_common.quantity'))
                : strtoupper($this->translate('_common.quantity')) . " " . $info['period1'];
            $txtColTot2 = $info['period2'] == '' && $info['period3'] == ''
                ? strtoupper($this->translate('_common.amount.net'))
                : strtoupper($this->translate('_common.quantity')) . " " . ($info['period2'] != '' ? $info['period2'] : $info['period3']);
            if ($info['period2'] != '' || $info['period3'] != '') {
                $txtColTot3 = $info['period2'] != '' && $info['period3'] != ''
                    ? strtoupper($this->translate('_common.quantity')) . " " . $info['period3']
                    : strtoupper($this->translate('_common.amount.net')) . " " . $info['period1'];
                $txtColTot4 = $info['period2'] != '' && $info['period3'] != ''
                    ? strtoupper($this->translate('_common.amount.net')) . " " . $info['period1']
                    : strtoupper($this->translate('_common.amount.net')) . " " . ($info['period2'] != '' ? $info['period2'] : $info['period3']);
            }

            switch ($type) {
                case 2:
                    $activeSheet->getCell('A1')->setValue(strtoupper($this->translate('_common.modeltype')));
                    $activeSheet->getCell('B1')->setValue(strtoupper($this->translate('_common.brand')));
                    $activeSheet->getCell('C1')->setValue(strtoupper($this->translate('_common.line')));
                    $activeSheet->getCell('D1')->setValue($txtColTot1);
                    $activeSheet->getCell('E1')->setValue($txtColTot2);
                    $activeSheet->getStyle('A1:E1')->applyFromArray($styleThinBlackBorderOutline);
                    $activeSheet->getStyle('A1:E1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

                    if ($info['period2'] != '' || $info['period3'] != '') {
                        $activeSheet->getStyle('F1:G1')->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('F1:G1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        $activeSheet->getCell('F1')->setValue($txtColTot3);
                        $activeSheet->getCell('G1')->setValue($txtColTot4);

                        if ($info['period2'] != '' && $info['period3'] != '') {
                            $activeSheet->getCell('H1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period2']);
                            $activeSheet->getCell('I1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period3']);
                            $activeSheet->getStyle('H1:I1')->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('H1:I1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        }
                    }
                    break;
                case 3:
                    $activeSheet->getCell('A1')->setValue(strtoupper($this->translate('_common.brand')));
                    $activeSheet->getCell('B1')->setValue(strtoupper($this->translate('_common.line')));
                    $activeSheet->getCell('C1')->setValue($txtColTot1);
                    $activeSheet->getCell('D1')->setValue($txtColTot2);
                    $activeSheet->getStyle('A1:D1')->applyFromArray($styleThinBlackBorderOutline);
                    $activeSheet->getStyle('A1:D1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

                    if ($info['period2'] != '' || $info['period3'] != '') {
                        $activeSheet->getStyle('E1:F1')->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('E1:F1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        $activeSheet->getCell('E1')->setValue($txtColTot3);
                        $activeSheet->getCell('F1')->setValue($txtColTot4);

                        if ($info['period2'] != '' && $info['period3'] != '') {
                            $activeSheet->getCell('G1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period2']);
                            $activeSheet->getCell('H1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period3']);
                            $activeSheet->getStyle('G1:H1')->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('G1:H1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        }
                    }
                    break;
                case 4:
                    $activeSheet->getCell('A1')->setValue(strtoupper($this->translate('_common.brand')));
                    $activeSheet->getCell('B1')->setValue(strtoupper($this->translate('_common.line')));
                    $activeSheet->getCell('C1')->setValue(strtoupper($this->translate('_common.series')));
                    $activeSheet->getCell('D1')->setValue($txtColTot1);
                    $activeSheet->getCell('E1')->setValue($txtColTot2);
                    $activeSheet->getStyle('A1:E1')->applyFromArray($styleThinBlackBorderOutline);
                    $activeSheet->getStyle('A1:E1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

                    if ($info['period2'] != '' || $info['period3'] != '') {
                        $activeSheet->getStyle('F1:G1')->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('F1:G1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        $activeSheet->getCell('F1')->setValue($txtColTot3);
                        $activeSheet->getCell('G1')->setValue($txtColTot4);

                        if ($info['period2'] != '' && $info['period3'] != '') {
                            $activeSheet->getCell('H1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period2']);
                            $activeSheet->getCell('I1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period3']);
                            $activeSheet->getStyle('H1:I1')->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('H1:I1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        }
                    }
                    break;
                case 5:
                    $activeSheet->getCell('A1')->setValue(strtoupper($this->translate('_common.brand')));
                    $activeSheet->getCell('B1')->setValue(strtoupper($this->translate('_common.line')));
                    $activeSheet->getCell('C1')->setValue(strtoupper($this->translate('_common.model')));
                    $activeSheet->getCell('D1')->setValue($txtColTot1);
                    $activeSheet->getCell('E1')->setValue($txtColTot2);
                    $activeSheet->getStyle('A1:E1')->applyFromArray($styleThinBlackBorderOutline);
                    $activeSheet->getStyle('A1:E1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

                    if ($info['period2'] != '' || $info['period3'] != '') {
                        $activeSheet->getStyle('F1:G1')->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('F1:G1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        $activeSheet->getCell('F1')->setValue($txtColTot3);
                        $activeSheet->getCell('G1')->setValue($txtColTot4);

                        if ($info['period2'] != '' && $info['period3'] != '') {
                            $activeSheet->getCell('H1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period2']);
                            $activeSheet->getCell('I1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period3']);
                            $activeSheet->getStyle('H1:I1')->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('H1:I1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        }
                    }
                    break;
                case 6:
                    $activeSheet->getCell('A1')->setValue(strtoupper($this->translate('_common.brand')));
                    $activeSheet->getCell('B1')->setValue(strtoupper($this->translate('_common.line')));
                    $activeSheet->getCell('C1')->setValue(strtoupper($this->translate('_common.article')));
                    $activeSheet->getCell('D1')->setValue($txtColTot1);
                    $activeSheet->getCell('E1')->setValue($txtColTot2);
                    $activeSheet->getStyle('A1:E1')->applyFromArray($styleThinBlackBorderOutline);
                    $activeSheet->getStyle('A1:E1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

                    if ($info['period2'] != '' || $info['period3'] != '') {
                        $activeSheet->getStyle('F1:G1')->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('F1:G1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        $activeSheet->getCell('F1')->setValue($txtColTot3);
                        $activeSheet->getCell('G1')->setValue($txtColTot4);

                        if ($info['period2'] != '' && $info['period3'] != '') {
                            $activeSheet->getCell('H1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period2']);
                            $activeSheet->getCell('I1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period3']);
                            $activeSheet->getStyle('H1:I1')->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('H1:I1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        }
                    }
                    break;
                case 7:
                    $activeSheet->getCell('A1')->setValue(strtoupper($this->translate('_common.brand')));
                    $activeSheet->getCell('B1')->setValue(strtoupper($this->translate('_common.line')));
                    $activeSheet->getCell('C1')->setValue(strtoupper($this->translate('_common.modeltype')));
                    $activeSheet->getCell('D1')->setValue($txtColTot1);
                    $activeSheet->getCell('E1')->setValue($txtColTot2);
                    $activeSheet->getStyle('A1:E1')->applyFromArray($styleThinBlackBorderOutline);
                    $activeSheet->getStyle('A1:E1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

                    if ($info['period2'] != '' || $info['period3'] != '') {
                        $activeSheet->getStyle('F1:G1')->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('F1:G1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        $activeSheet->getCell('F1')->setValue($txtColTot3);
                        $activeSheet->getCell('G1')->setValue($txtColTot4);

                        if ($info['period2'] != '' && $info['period3'] != '') {
                            $activeSheet->getCell('H1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period2']);
                            $activeSheet->getCell('I1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period3']);
                            $activeSheet->getStyle('H1:I1')->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('H1:I1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        }
                    }
                    break;
                case 8:
                    $activeSheet->getCell('A1')->setValue(strtoupper($this->translate('_common.customer')));
                    $activeSheet->getCell('B1')->setValue($txtColTot1);
                    $activeSheet->getCell('C1')->setValue($txtColTot2);
                    $activeSheet->getStyle('A1:C1')->applyFromArray($styleThinBlackBorderOutline);
                    $activeSheet->getStyle('A1:C1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

                    if ($info['period2'] != '' || $info['period3'] != '') {
                        $activeSheet->getStyle('D1:E1')->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('D1:E1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        $activeSheet->getCell('D1')->setValue($txtColTot3);
                        $activeSheet->getCell('E1')->setValue($txtColTot4);

                        if ($info['period2'] != '' && $info['period3'] != '') {
                            $activeSheet->getCell('F1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period2']);
                            $activeSheet->getCell('G1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period3']);
                            $activeSheet->getStyle('F1:G1')->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('F1:G1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        }
                    }
                    break;
                case 9:
                    $activeSheet->getCell('A1')->setValue(strtoupper($this->translate('_common.customer')));
                    $activeSheet->getCell('B1')->setValue(strtoupper($this->translate('_common.modeltype')));
                    $activeSheet->getCell('C1')->setValue($txtColTot1);
                    $activeSheet->getCell('D1')->setValue($txtColTot2);
                    $activeSheet->getStyle('A1:D1')->applyFromArray($styleThinBlackBorderOutline);
                    $activeSheet->getStyle('A1:D1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

                    if ($info['period2'] != '' || $info['period3'] != '') {
                        $activeSheet->getStyle('E1:F1')->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('E1:F1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        $activeSheet->getCell('E1')->setValue($txtColTot3);
                        $activeSheet->getCell('F1')->setValue($txtColTot4);

                        if ($info['period2'] != '' && $info['period3'] != '') {
                            $activeSheet->getCell('G1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period2']);
                            $activeSheet->getCell('H1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period3']);
                            $activeSheet->getStyle('G1:H1')->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('G1:H1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        }
                    }
                    break;
                case 10:
                    $activeSheet->getCell('A1')->setValue(strtoupper($this->translate('_common.customer')));
                    $activeSheet->getCell('B1')->setValue(strtoupper($this->translate('_common.brand')));
                    $activeSheet->getCell('C1')->setValue(strtoupper($this->translate('_common.line')));
                    $activeSheet->getCell('D1')->setValue($txtColTot1);
                    $activeSheet->getCell('E1')->setValue($txtColTot2);
                    $activeSheet->getStyle('A1:E1')->applyFromArray($styleThinBlackBorderOutline);
                    $activeSheet->getStyle('A1:E1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

                    if ($info['period2'] != '' || $info['period3'] != '') {
                        $activeSheet->getStyle('F1:G1')->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('F1:G1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        $activeSheet->getCell('F1')->setValue($txtColTot3);
                        $activeSheet->getCell('G1')->setValue($txtColTot4);

                        if ($info['period2'] != '' && $info['period3'] != '') {
                            $activeSheet->getCell('H1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period2']);
                            $activeSheet->getCell('I1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period3']);
                            $activeSheet->getStyle('H1:I1')->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('H1:I1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        }
                    }
                    break;
                case 11:
                    $activeSheet->getCell('A1')->setValue(strtoupper($this->translate('_common.customer')));
                    $activeSheet->getCell('B1')->setValue(strtoupper($this->translate('_common.brand')));
                    $activeSheet->getCell('C1')->setValue(strtoupper($this->translate('_common.line')));
                    $activeSheet->getCell('D1')->setValue(strtoupper($this->translate('_common.model')));
                    $activeSheet->getCell('E1')->setValue($txtColTot1);
                    $activeSheet->getCell('F1')->setValue($txtColTot2);
                    $activeSheet->getStyle('A1:F1')->applyFromArray($styleThinBlackBorderOutline);
                    $activeSheet->getStyle('A1:F1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

                    if ($info['period2'] != '' || $info['period3'] != '') {
                        $activeSheet->getStyle('G1:H1')->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('G1:H1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        $activeSheet->getCell('G1')->setValue($txtColTot3);
                        $activeSheet->getCell('H1')->setValue($txtColTot4);

                        if ($info['period2'] != '' && $info['period3'] != '') {
                            $activeSheet->getCell('I1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period2']);
                            $activeSheet->getCell('J1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period3']);
                            $activeSheet->getStyle('I1:J1')->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('I1:J1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        }
                    }
                    break;
                case 12:
                    $activeSheet->getCell('A1')->setValue(strtoupper($this->translate('_common.customer')));
                    $activeSheet->getCell('B1')->setValue(strtoupper($this->translate('_common.brand')));
                    $activeSheet->getCell('C1')->setValue(strtoupper($this->translate('_common.line')));
                    $activeSheet->getCell('D1')->setValue(strtoupper($this->translate('_common.article')));
                    $activeSheet->getCell('E1')->setValue($txtColTot1);
                    $activeSheet->getCell('F1')->setValue($txtColTot2);
                    $activeSheet->getStyle('A1:F1')->applyFromArray($styleThinBlackBorderOutline);
                    $activeSheet->getStyle('A1:F1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

                    if ($info['period2'] != '' || $info['period3'] != '') {
                        $activeSheet->getStyle('G1:H1')->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('G1:H1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        $activeSheet->getCell('G1')->setValue($txtColTot3);
                        $activeSheet->getCell('H1')->setValue($txtColTot4);

                        if ($info['period2'] != '' && $info['period3'] != '') {
                            $activeSheet->getCell('I1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period2']);
                            $activeSheet->getCell('J1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period3']);
                            $activeSheet->getStyle('I1:J1')->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('I1:J1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        }
                    }
                    break;
                case 13:
                    $activeSheet->getCell('A1')->setValue(strtoupper($this->translate('_common.agent')));
                    $activeSheet->getCell('B1')->setValue(strtoupper($this->translate('_common.customer')));
                    $activeSheet->getCell('C1')->setValue($txtColTot1);
                    $activeSheet->getCell('D1')->setValue($txtColTot2);
                    $activeSheet->getStyle('A1:D1')->applyFromArray($styleThinBlackBorderOutline);
                    $activeSheet->getStyle('A1:D1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

                    if ($info['period2'] != '' || $info['period3'] != '') {
                        $activeSheet->getStyle('E1:F1')->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('E1:F1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        $activeSheet->getCell('E1')->setValue($txtColTot3);
                        $activeSheet->getCell('F1')->setValue($txtColTot4);

                        if ($info['period2'] != '' && $info['period3'] != '') {
                            $activeSheet->getCell('G1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period2']);
                            $activeSheet->getCell('H1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period3']);
                            $activeSheet->getStyle('G1:H1')->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('G1:H1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        }
                    }
                    break;
                case 14:
                    $activeSheet->getCell('A1')->setValue(strtoupper($this->translate('_common.agent')));
                    $activeSheet->getCell('B1')->setValue(strtoupper($this->translate('_common.customer')));
                    $activeSheet->getCell('C1')->setValue(strtoupper($this->translate('_common.modeltype')));
                    $activeSheet->getCell('D1')->setValue($txtColTot1);
                    $activeSheet->getCell('E1')->setValue($txtColTot2);
                    $activeSheet->getStyle('A1:E1')->applyFromArray($styleThinBlackBorderOutline);
                    $activeSheet->getStyle('A1:E1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

                    if ($info['period2'] != '' || $info['period3'] != '') {
                        $activeSheet->getStyle('F1:G1')->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('F1:G1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        $activeSheet->getCell('F1')->setValue($txtColTot3);
                        $activeSheet->getCell('G1')->setValue($txtColTot4);

                        if ($info['period2'] != '' && $info['period3'] != '') {
                            $activeSheet->getCell('H1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period2']);
                            $activeSheet->getCell('I1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period3']);
                            $activeSheet->getStyle('H1:I1')->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('H1:I1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        }
                    }
                    break;
                case 15:
                    $activeSheet->getCell('A1')->setValue(strtoupper($this->translate('_common.agent')));
                    $activeSheet->getCell('B1')->setValue(strtoupper($this->translate('_common.customer')));
                    $activeSheet->getCell('C1')->setValue(strtoupper($this->translate('_common.brand')));
                    $activeSheet->getCell('D1')->setValue(strtoupper($this->translate('_common.line')));
                    $activeSheet->getCell('E1')->setValue($txtColTot1);
                    $activeSheet->getCell('F1')->setValue($txtColTot2);
                    $activeSheet->getStyle('A1:F1')->applyFromArray($styleThinBlackBorderOutline);
                    $activeSheet->getStyle('A1:F1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

                    if ($info['period2'] != '' || $info['period3'] != '') {
                        $activeSheet->getStyle('G1:H1')->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('G1:H1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        $activeSheet->getCell('G1')->setValue($txtColTot3);
                        $activeSheet->getCell('H1')->setValue($txtColTot4);

                        if ($info['period2'] != '' && $info['period3'] != '') {
                            $activeSheet->getCell('I1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period2']);
                            $activeSheet->getCell('J1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period3']);
                            $activeSheet->getStyle('I1:J1')->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('I1:J1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        }
                    }
                    break;
                case 16:
                    $activeSheet->getCell('A1')->setValue(strtoupper($this->translate('_common.agent')));
                    $activeSheet->getCell('B1')->setValue(strtoupper($this->translate('_common.modeltype')));
                    $activeSheet->getCell('C1')->setValue($txtColTot1);
                    $activeSheet->getCell('D1')->setValue($txtColTot2);
                    $activeSheet->getStyle('A1:C1')->applyFromArray($styleThinBlackBorderOutline);
                    $activeSheet->getStyle('A1:D1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

                    if ($info['period2'] != '' || $info['period3'] != '') {
                        $activeSheet->getStyle('E1:F1')->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('E1:F1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        $activeSheet->getCell('E1')->setValue($txtColTot3);
                        $activeSheet->getCell('F1')->setValue($txtColTot4);

                        if ($info['period2'] != '' && $info['period3'] != '') {
                            $activeSheet->getCell('G1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period2']);
                            $activeSheet->getCell('H1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period3']);
                            $activeSheet->getStyle('G1:H1')->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('G1:H1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        }
                    }
                    break;
                case 17:
                    $activeSheet->getCell('A1')->setValue(strtoupper($this->translate('_common.agent')));
                    $activeSheet->getCell('B1')->setValue(strtoupper($this->translate('_common.brand')));
                    $activeSheet->getCell('C1')->setValue(strtoupper($this->translate('_common.line')));
                    $activeSheet->getCell('D1')->setValue($txtColTot1);
                    $activeSheet->getCell('E1')->setValue($txtColTot2);
                    $activeSheet->getStyle('A1:E1')->applyFromArray($styleThinBlackBorderOutline);
                    $activeSheet->getStyle('A1:E1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

                    if ($info['period2'] != '' || $info['period3'] != '') {
                        $activeSheet->getStyle('F1:G1')->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('F1:G1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        $activeSheet->getCell('F1')->setValue($txtColTot3);
                        $activeSheet->getCell('G1')->setValue($txtColTot4);

                        if ($info['period2'] != '' && $info['period3'] != '') {
                            $activeSheet->getCell('H1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period2']);
                            $activeSheet->getCell('I1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period3']);
                            $activeSheet->getStyle('H1:I1')->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('H1:I1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        }
                    }
                    break;
                case 1:
                default:
                    $activeSheet->getCell('A1')->setValue(strtoupper($this->translate('statistics.group.modtype')));
                    $activeSheet->getCell('B1')->setValue($txtColTot1);
                    $activeSheet->getCell('C1')->setValue($txtColTot2);
                    $activeSheet->getStyle('A1:C1')->applyFromArray($styleThinBlackBorderOutline);
                    $activeSheet->getStyle('A1:C1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

                    if ($info['period2'] != '' || $info['period3'] != '') {
                        $activeSheet->getStyle('D1:E1')->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('D1:E1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        $activeSheet->getCell('D1')->setValue($txtColTot3);
                        $activeSheet->getCell('E1')->setValue($txtColTot4);

                        if ($info['period2'] != '' && $info['period3'] != '') {
                            $activeSheet->getCell('F1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period2']);
                            $activeSheet->getCell('G1')->setValue(strtoupper($this->translate('_common.amount.net')) . " " . $info['period3']);
                            $activeSheet->getStyle('F1:G1')->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('F1:G1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                        }
                    }
                    break;
            }

            for ($i = 0; $i < count($stats); $i++) {
                $num = 2 + $i;

                $txtColTot1 = $stats[$i]['qty1'];
                $txtColTot2 = $info['period2'] == '' && $info['period3'] == ''
                    ? $stats[$i]['val1']
                    : ($info['period2'] != '' ? $stats[$i]['qty2'] : $stats[$i]['qty3']);
                if ($info['period2'] != '' || $info['period3'] != '') {
                    $txtColTot3 = $info['period2'] != '' && $info['period3'] != ''
                        ? $stats[$i]['qty3']
                        : $stats[$i]['val1'];
                    $txtColTot4 = $info['period2'] != '' && $info['period3'] != ''
                        ? $stats[$i]['val1']
                        : ($info['period2'] != '' ? $stats[$i]['val2'] : $stats[$i]['val3']);
                }

                switch ($type) {
                    case 1:
                    case 8:
                    default:
                        $activeSheet->getCell('A' . $num)->setValue($stats[$i]['col1']);
                        $activeSheet->getCell('B' . $num)->setValue($txtColTot1);
                        $activeSheet->getCell('C' . $num)->setValue($txtColTot2);
                        $activeSheet->getStyle('A' . $num . ':C' . $num)->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('B' . $num . ':C' . $num)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                        if ($info['period2'] != '' || $info['period3'] != '') {
                            $activeSheet->getCell('D' . $num)->setValue($txtColTot3);
                            $activeSheet->getCell('E' . $num)->setValue($txtColTot4);
                            $activeSheet->getStyle('D' . $num . ':E' . $num)->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('D' . $num . ':E' . $num)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            if ($info['period2'] != '' && $info['period3'] != '') {
                                $activeSheet->getCell('F' . $num)->setValue($stats[$i]['val2']);
                                $activeSheet->getCell('G' . $num)->setValue($stats[$i]['val3']);
                                $activeSheet->getStyle('F' . $num . ':G' . $num)->applyFromArray($styleThinBlackBorderOutline);
                                $activeSheet->getStyle('F' . $num . ':G' . $num)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                            }
                        }
                        break;
                    case 9:
                    case 3:
                    case 13:
                    case 16:
                        $activeSheet->getCell('A' . $num)->setValue($stats[$i]['col1']);
                        $activeSheet->getCell('B' . $num)->setValue($stats[$i]['col2']);
                        $activeSheet->getCell('C' . $num)->setValue($txtColTot1);
                        $activeSheet->getCell('D' . $num)->setValue($txtColTot2);
                        $activeSheet->getStyle('A' . $num . ':D' . $num)->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('C' . $num . ':D' . $num)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                        if ($info['period2'] != '' || $info['period3'] != '') {
                            $activeSheet->getCell('E' . $num)->setValue($txtColTot3);
                            $activeSheet->getCell('F' . $num)->setValue($txtColTot4);
                            $activeSheet->getStyle('E' . $num . ':F' . $num)->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('E' . $num . ':F' . $num)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            if ($info['period2'] != '' && $info['period3'] != '') {
                                $activeSheet->getCell('G' . $num)->setValue($stats[$i]['val2']);
                                $activeSheet->getCell('H' . $num)->setValue($stats[$i]['val3']);
                                $activeSheet->getStyle('G' . $num . ':H' . $num)->applyFromArray($styleThinBlackBorderOutline);
                                $activeSheet->getStyle('G' . $num . ':H' . $num)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                            }
                        }
                        break;
                    case 2:
                    case 4:
                    case 5:
                    case 6:
                    case 7:
                    case 10:
                    case 14:
                    case 17:
                        $activeSheet->getCell('A' . $num)->setValue($stats[$i]['col1']);
                        $activeSheet->getCell('B' . $num)->setValue($stats[$i]['col2']);
                        $activeSheet->getCell('C' . $num)->setValue($stats[$i]['col3']);
                        $activeSheet->getCell('D' . $num)->setValue($txtColTot1);
                        $activeSheet->getCell('E' . $num)->setValue($txtColTot2);
                        $activeSheet->getStyle('A' . $num . ':E' . $num)->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('D' . $num . ':E' . $num)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                        if ($info['period2'] != '' || $info['period3'] != '') {
                            $activeSheet->getCell('F' . $num)->setValue($txtColTot3);
                            $activeSheet->getCell('G' . $num)->setValue($txtColTot4);
                            $activeSheet->getStyle('F' . $num . ':G' . $num)->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('F' . $num . ':G' . $num)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            if ($info['period2'] != '' && $info['period3'] != '') {
                                $activeSheet->getCell('H' . $num)->setValue($stats[$i]['val2']);
                                $activeSheet->getCell('I' . $num)->setValue($stats[$i]['val3']);
                                $activeSheet->getStyle('H' . $num . ':I' . $num)->applyFromArray($styleThinBlackBorderOutline);
                                $activeSheet->getStyle('H' . $num . ':I' . $num)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                            }
                        }
                        break;
                    case 11:
                    case 12:
                    case 15:
                        $activeSheet->getCell('A' . $num)->setValue($stats[$i]['col1']);
                        $activeSheet->getCell('B' . $num)->setValue($stats[$i]['col2']);
                        $activeSheet->getCell('C' . $num)->setValue($stats[$i]['col3']);
                        $activeSheet->getCell('D' . $num)->setValue($stats[$i]['col4']);
                        $activeSheet->getCell('E' . $num)->setValue($txtColTot1);
                        $activeSheet->getCell('F' . $num)->setValue($txtColTot2);
                        $activeSheet->getStyle('A' . $num . ':F' . $num)->applyFromArray($styleThinBlackBorderOutline);
                        $activeSheet->getStyle('D' . $num . ':F' . $num)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                        if ($info['period2'] != '' || $info['period3'] != '') {
                            $activeSheet->getCell('G' . $num)->setValue($txtColTot3);
                            $activeSheet->getCell('H' . $num)->setValue($txtColTot4);
                            $activeSheet->getStyle('G' . $num . ':H' . $num)->applyFromArray($styleThinBlackBorderOutline);
                            $activeSheet->getStyle('G' . $num . ':H' . $num)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);

                            if ($info['period2'] != '' && $info['period3'] != '') {
                                $activeSheet->getCell('I' . $num)->setValue($stats[$i]['val2']);
                                $activeSheet->getCell('J' . $num)->setValue($stats[$i]['val3']);
                                $activeSheet->getStyle('I' . $num . ':J' . $num)->applyFromArray($styleThinBlackBorderOutline);
                                $activeSheet->getStyle('I' . $num . ':J' . $num)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
                            }
                        }
                        break;
                }
            }

            $objWriter = IOFactory::createWriter($spreadsheet, 'Xlsx');
            $filename = 'stats_admin_' . date('Ymd') . '_' . date('His');
            $objWriter->save(str_replace('AdminController', $filename, str_replace('.php', '.xlsx', __FILE__)));
            chmod("../app/controllers/" . $filename . ".xlsx", 0777);
            if (!file_exists('../public/io/stats')) {
                mkdir('../public/io/stats', 0777, true);
            }
            rename("../app/controllers/" . $filename . ".xlsx", "../public/io/stats/" . $filename . ".xlsx");

            echo json_encode($filename . ".xlsx");
        }
    }

    public function getSalesAnalysisAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $data = json_decode($_POST['data']);
            $idlang = $this->utility->getLanguage();

            if (count($data->filters->channels) == 0) {
                $channels = Anagra::getAllChannels();
            } else {
                foreach ($data->filters->channels as $channel) {
                    $channels[] = array('code' => $channel, 'description' => $channel);
                }
            }

            $items = Anaart::getZanottiArticlesForSalesAnalysis($data, $channels, $idlang);
            $title = ucfirst($this->translate('_common.searchresults'));

            $html = $this->getSalesAnalysis($items, $channels, $title, $data->viewType == 0);

            echo json_encode(array('html' => $html));
        }
    }
    //endregion

    //region Ajax functions: Catalog presentation, homepage, default and model info
    public function saveDefaultCatalogAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdcata = $request->getPost("cdcata");
            $appUtil = $this->utility->setAppUtils("default_catalog", $cdcata);
            echo json_encode("OK");
        }
    }

    public function getBlockElementsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdcata = $request->getPost('cdcata');
            $tpbloc = $request->getPost('tpbloc');

            if ($tpbloc != 'NO' && $tpbloc != 'SL' && $tpbloc != '') {
                if (strlen($tpbloc) == 2) {
                    switch ($tpbloc) {
                        case 'BR':
                            $elements = Titlin::getBrandsFromCatalog($cdcata);
                            break;
                        case 'LI':
                            $elements = Linmod::getLinesFromCatalog($cdcata);
                            break;
                        case 'SE':
                            $elements = Sermod::getSeriesFromCatalog($cdcata);
                            break;
                        case 'GE':
                            $elements = Tpgene::getGenresFromCatalog($cdcata);
                            break;
                        case 'TM':
                            $elements = Tpmode::getModelTypesFromCatalog($cdcata);
                            break;
                        case 'TG':
                            $modelTags = Artcla::getTags($cdcata);
                            $articleTags = Artcla::getTagsForArticles($cdcata);
                            if (count($modelTags) > 0) {
                                $elements = $modelTags;
                            } else if (count($articleTags) > 0) {
                                $elements = $articleTags;
                            } else {
                                $elements = array();
                            }
                            break;
                        case 'DL':
                        case 'VD':
                            $elements = $this->utility->getMediaFiles();
                            break;
                    }
                    $html = $this->getHtmlOptionsForHomePageWizard($tpbloc, $elements);
                } else {
                    $items = array('from' => 'all');
                    $tpinpu = substr($tpbloc, 0, 2);
                    $tpcrar = substr($tpbloc, 2, 4);
                    $elements = Artcrt::getAllAdditionalTypeFromCatalog($cdcata, $items, $tpinpu, $tpcrar);
                    $html = $this->getHtmlAdditionalOptionsForHomePageWizard($elements);
                }
            } else {
                $html = '';
            }

            echo json_encode(array('html' => $html));
        }
    }

    public function saveCatalogHomepageAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $modevi = $request->getPost('modevi');
            $hptest = $request->getPost('hptest');
            $hpcorp = $request->getPost('hpcorp');
            $flimag = $request->getPost('flimag');

            // Delete current logo for catalog and save flimag as catalog logo
            B2bAddinf::deleteCustomLogoForCatalog($modevi['cdcata']);
            if ($flimag != '') {
                B2bAddinf::insertCustomLogoForCatalog($modevi['cdcata'], $flimag);
            }

            // Save featured models, if needed
            B2bModevi::deleteFeaturedModelsForCatalog($modevi['cdcata']);
            if (isset($modevi['cdartn'])) {
                $i = 0;
                foreach ($modevi['cdartn'] as $cdartn) {
                    B2bModevi::insertNewFeaturedModel($modevi['cdcata'], $cdartn, $i);
                    $i++;
                }
            }

            // Save homepage header images and homepage blocks
            if ($hptest != null || $hpcorp != null) {
                try {
                    if (isset($hptest['flimg1']) || isset($hptest['flimg2']) || isset($hptest['flimg3'])) {
                        $flimg1 = array_key_exists('flimg1', $hptest) ? $hptest['flimg1'] : '';
                        $flimg2 = array_key_exists('flimg2', $hptest) ? $hptest['flimg2'] : '';
                        $flimg3 = array_key_exists('flimg3', $hptest) ? $hptest['flimg3'] : '';
                        B2bHptest::insertOrReplaceHomePageHeaderImagesForCatalog($hptest['cdcata'], $flimg1, $flimg2, $flimg3);
                    } else {
                        B2bHptest::deleteHomePageHeaderForCatalog($hptest['cdcata']);
                    }

                    B2bHpcorp::deleteHomePageBlocksForCatalog($hptest['cdcata']);

                    if (!empty($hpcorp)) {
                        for ($i = 0; $i < count($hpcorp); $i++) {
                            $items = array(
                                'cdcata' => $hpcorp[$i]['cdcata'],
                                'nubloc' => $hpcorp[$i]['nubloc'],
                                'blsize' => $hpcorp[$i]['blsize'],
                                'seqrap' => $hpcorp[$i]['seqrap'],
                                'des_it' => $hpcorp[$i]['des_it'],
                                'des_en' => $hpcorp[$i]['des_en'],
                                'des_es' => $hpcorp[$i]['des_es'],
                                'des_de' => $hpcorp[$i]['des_de'],
                                'des_fr' => $hpcorp[$i]['des_fr'],
                                'tpbloc' => $hpcorp[$i]['tpbloc'],
                                'codice' => $hpcorp[$i]['codice'],
                                'flimag' => $hpcorp[$i]['flimag'],
                            );
                            B2bHpcorp::insertNewBlock($items);
                        }
                    }

                    echo json_encode('OK');
                } catch (\Exception $e) {
                    echo json_encode('EX');
                }
            } else {
                echo json_encode('NN');
            }
        }
    }

    public function loadHomepageCatalogAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdcata = $request->getPost('cdcata');

            $hpcorp = B2bHpcorp::find(array('cdcata = :cdcata:', 'bind' => array('cdcata' => $cdcata), 'order' => 'nubloc,seqrap'));

            $customLogo = B2bAddinf::getCustomLogoForCatalog($cdcata);

            echo json_encode(array(
                'hptest' => B2bHptest::findFirstByCdcata($cdcata),
                'hpcorp' => $this->getHomePageBodyContent($hpcorp),
                'customLogo' => $customLogo,
            ));
        }
    }

    public function getNewBlockForHomepageAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $index = $request->getPost('index');
            $html = $this->getBlock($index);

            echo json_encode($this->getBlock($index));
        }
    }

    public function newCatalogPresentationBoxAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cttest = Cttest::getAllAvailableCatalogs();

            $html = '<div class="form-group col-md-6 px-30x mb-40x catalog-box">';

            $html .= '<div class="row mb-20x">';

            $html .= '<label class="control-label col-md-3 col-sm-3 col-xs-12 text-right" style="margin-top:11px">';
            $html .= $this->translate('order.selectcatalog');
            $html .= '</label>';

            $html .= '<div class="col-md-6 col-sm-6 col-xs-12">';
            $html .= '<select class="select2_single form-control catalog-pres" tabindex="-1">';
            foreach ($cttest as $el) {
                $html .= '<option value="' . $el->cdcata . '">' . $el->cdcata . ' - ' . $el->dscata . '</option>';
            }
            $html .= '</select>';
            $html .= '</div>';

            $html .= '<div class="col-md-1 col-sm-1 col-xs-12">';
            $html .= '<button href="#" class="btn btn-default delete-catalog-box capitalize">' . $this->translate('_common.delete') . '</button>';
            $html .= '</div>';

            $html .= '</div>';

            $html .= '<div class="row">';
            $html .= '<div class="col-md-10 col-sm-10 col-xs-12">';
            $html .= '<form action="' . $this->url->get('admin/uploadImage') . '" class="dropzone dropzone-slide" style="max-width:158px;margin:0 auto"></form>';
            $html .= '</div>';
            $html .= '</div>';

            $html .= '</div>';

            echo json_encode($html);
        }
    }

    public function saveCatalogPresentationBoxAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $b2bctim = $_POST['b2bctim'];

            $old_b2bctim = B2bCatimg::find();
            $old_b2bctim->delete();

            foreach ($b2bctim as $el) {
                $new_b2bctim = new B2bCatimg();
                $new_b2bctim->cdcata = $el["cdcata"];
                $new_b2bctim->seqrap = $el["seqrap"];
                $new_b2bctim->flimag = $el["flimag"];
                $new_b2bctim->save();
            }

            echo json_encode("OK");
        }
    }

    public function updateModelInfoAction()
    {
        $this->view->disable();

        $post = $this->request->getPost();

        $modinf = B2bModinf::findFirstByCdartn($post['cdartn']);
        if ($modinf) {
            $modinf->delete();
        }

        if ($post['dtiniz'] != '' || $post['dtfine'] != '') {
            $b2bardt = B2bTipval::findFirstByCdartn($post['cdartn']);
            if (!$b2bardt) {
                $b2bardt = new B2bTipval();
                $b2bardt->cdartn = $post['cdartn'];
            }

            $b2bardt->dtiniz = $post['dtiniz'] != '' ? date('Y-m-d', strtotime(str_replace('/', '-', $post['dtiniz']))) : null;
            $b2bardt->dtfine = $post['dtfine'] != '' ? date('Y-m-d', strtotime(str_replace('/', '-', $post['dtfine']))) : null;

            $b2bardt->save();
        }

        $seqrap = $post['seqrap'];
        Tipolo::updateModelIndex($post['cdartn'], $seqrap);

        $filpdf = $filvid = '';
        try {
            if (!empty($_FILES)) {
                if ($_FILES['filpdf']['type'] == 'application/pdf') {
                    $tempFile = $_FILES['filpdf']['tmp_name'];          //3
                    $targetPath = "./upload/products/";  //4
                    if (!is_dir($targetPath) && !mkdir($targetPath, 0777, true)) {
                        die("Error creating folder $targetPath");
                    }
                    $targetFile = $targetPath . $post['cdartn'] . '.pdf';  //5
                    move_uploaded_file($tempFile, $targetFile); //6
                    chmod($targetFile, 0755);

                    $filpdf = $post['cdartn'] . '.pdf';
                }

                if (substr($_FILES['filvid']['type'], 0, 5) == 'video') {
                    $tempFile = $_FILES['filvid']['tmp_name'];          //3
                    $targetPath = "./upload/products/";  //4
                    if (!is_dir($targetPath) && !mkdir($targetPath, 0777, true)) {
                        die("Error creating folder $targetPath");
                    }
                    $targetFile = $targetPath . $_FILES['filvid']['name'];  //5
                    move_uploaded_file($tempFile, $targetFile); //6
                    chmod($targetFile, 0755);

                    $filvid = $_FILES['filvid']['name'];
                }
            }
            B2bModinf::insertNewModelInfo(
                $post['cdartn'],
                $post['descit'],
                $post['descen'],
                $post['desces'],
                $post['descfr'],
                $post['descde'],
                $post['dettit'],
                $post['detten'],
                $post['dettes'],
                $post['dettfr'],
                $post['dettde'],
                $post['madein'],
                $post['compos'],
                $post['vestib'],
                $post['clsfz'],
                $filpdf,
                $filvid
            );
        } catch (\Exception $ex) {
            return $this->response->redirect('admin/modifyModelInfo/' . $post['cdartn'] . '?s=0');
        }

        return $this->response->redirect('admin/modifyModelInfo/' . $post['cdartn'] . '?s=1');
    }

    public function getPdfConditionsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdcata = $request->getPost('cdcata');

            $pdfs = B2bAddinf::getPdfConditionsForCatalog($cdcata);
            $catalog = Cttest::findFirstByCdcata($cdcata);

            echo json_encode($this->getHtmlContentForPdfConditions($catalog, $pdfs));
        }
    }

    public function deletePdfConditionsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdcata = $_POST['cdcata'];
            $idlang = $_POST['idlang'];

            B2bAddinf::deletePdfConditionCatalog($cdcata, $idlang);

            echo json_encode('OK');
        }
    }

    public function savePdfConditionsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $file = $_FILES['file'];
            $cdcata = $_POST['cdcata'];
            $idlang = $_POST['idlang'];

            $tempFile = $file['tmp_name'];
            $targetPath = "./upload/pdf/";
            if (!is_dir($targetPath) && !mkdir($targetPath, 0777, true)) {
                die("Error creating folder $targetPath");
            }
            $targetFile = $targetPath . $file['name'];
            move_uploaded_file($tempFile, $targetFile);
            chmod($targetFile, 0755);

            B2bAddinf::insertPdfConditionCatalog($cdcata, $idlang, $file['name']);

            echo json_encode(array('success' => 'OK', 'link' => $this->config->application->baseUri . 'public/upload/pdf/' . $file['name']));
        }
    }
    //endregion

    //region Ajax functions: Special selections
    public function getSpecialSelectionForCatalogAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdcata = $request->getPost('cdcata');
            $idlang = $this->utility->getLanguage();
            $selections = B2bSstest::getSpecialSelectionForCatalog($cdcata, $idlang);
            echo json_encode(array('response' => 'OK', 'selections' => $selections));
        }
    }

    public function saveSpecialSelectionAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdcata = $request->getPost('cdcata');
            $des_it = $request->getPost('des_it');
            $des_en = $request->getPost('des_en');
            $des_es = $request->getPost('des_es');
            $des_fr = $request->getPost('des_fr');
            $des_de = $request->getPost('des_de');
            $sstest = B2bSstest::insertNewSpecialSelection($cdcata, $des_it, $des_en, $des_es, $des_fr, $des_de);
            $idlang = $this->utility->getLanguage();
            $descri = strtolower('des_' . $idlang);
            echo json_encode(array('response' => 'OK', 'code' => $sstest->cdspsl, 'description' => $sstest->$descri));
        }
    }

    public function deleteSpecialSelectionAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdspsl = $request->getPost('cdspsl');
            B2bSstest::deleteSpecialSelection($cdspsl);
            echo json_encode(array('OK'));
        }
    }

    public function editSpecialSelectionAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdspsl = $request->getPost('cdspsl');
            $des_it = $request->getPost('des_it');
            $des_en = $request->getPost('des_en');
            $des_es = $request->getPost('des_es');
            $des_fr = $request->getPost('des_fr');
            $des_de = $request->getPost('des_de');
            $flbloc = $request->getPost('flbloc');
            $sscorp = $request->getPost('sscorp');

            B2bSstest::editSpecialSelection($cdspsl, $des_it, $des_en, $des_es, $des_fr, $des_de, $flbloc);

            B2bSscorp::deleteAllProductsForSpecialSelection($cdspsl);

            foreach ($sscorp as $item) {
                if ($item['flimag'] != '') {
                    $image = explode('/', $item['flimag']);
                    $flimag = end($image);
                } else {
                    $flimag = '';
                }
                B2bSscorp::insertNewProductForSpecialSelection($cdspsl, $item['codice'], $item['seqrap'], $flimag);
            }

            echo json_encode(array('OK'));
        }
    }
    //endregion

    //region Ajax functions: Galleries
    public function getGalleriesAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdcata = $request->getPost('cdcata');
            $idlang = $this->utility->getLanguage();
            $galleries = B2bGltest::getGalleriesForCatalog($cdcata, $idlang);
            $html = '';
            foreach ($galleries as $gallery) {
                $html .= $this->getGalleryBox($gallery);
            }
            echo json_encode(array('response' => 'OK', 'html' => $html));
        }
    }

    public function saveGalleryAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdcata = $request->getPost('cdcata');
            $des_it = $request->getPost('des_it');
            $des_de = $request->getPost('des_de');
            $des_fr = $request->getPost('des_fr');
            $des_en = $request->getPost('des_en');
            $des_es = $request->getPost('des_es');
            $flimag = $request->getPost('flimag');
            $seqrap = B2bGltest::getNextSeqrapForCatalog($cdcata);

            B2bGltest::saveGallery($cdcata, $des_it, $des_en, $des_es, $des_fr, $des_de, $flimag, $seqrap);

            $idlang = $this->utility->getLanguage();
            $gallery = B2bGltest::getGalleryForCatalog($cdcata, $seqrap, $idlang);
            $html = count($gallery) == 1 ? $this->getGalleryBox($gallery[0]) : '';
            echo json_encode(array('response' => 'OK', 'html' => $html));
        }
    }

    public function deleteGalleryAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nugall = $request->getPost('nugall');

            B2bGlcorp::deleteAllPointsForGallery($nugall);
            B2bGltest::deleteGallery($nugall);

            echo json_encode('OK');
        }
    }

    public function updateGalleryOrderAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $galleries = $request->getPost('gltest');

            foreach ($galleries as $gltest) {
                B2bGltest::updateGalleryOrder($gltest['nugall'], $gltest['seqrap']);
            }

            echo json_encode('ok');
        }
    }

    public function updateGalleryImageAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nugall = $request->getPost('nugall');
            $flimag = $request->getPost('flimag');

            B2bGltest::updateGalleryImage($nugall, $flimag);
            B2bGlcorp::deleteAllPointsForGallery($nugall);

            echo json_encode('ok');
        }
    }

    public function updateGalleryDescriptionAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nugall = $request->getPost('nugall');
            $des_it = $request->getPost('des_it');
            $des_en = $request->getPost('des_en');
            $des_es = $request->getPost('des_es');
            $des_fr = $request->getPost('des_fr');
            $des_de = $request->getPost('des_de');

            $descri = strtolower('des_' . $this->utility->getLanguage());
            B2bGltest::updateGalleryDescription($nugall, $des_it, $des_en, $des_fr, $des_de, $des_es);

            echo json_encode(array('descri' => $$descri));
        }
    }

    public function saveGalleryPointsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nugall = $request->getPost('nugall');
            $points = $request->getPost('glcorp');

            B2bGlcorp::deleteAllPointsForGallery($nugall);

            foreach ($points as $glcorp) {
                B2bGlcorp::saveNewPointForGallery($glcorp, $nugall);
            }

            echo json_encode('OK');
        }
    }
    //endregion

    //region Ajax functions: Custom filters
    public function getCustomFiltersAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $data = $request->getPost('data');

            $fltest = B2bFltest::findByTpfilt($data);

            $idlang = $this->utility->getLanguage();
            $flcorp = B2bFlcorp::getCustomFilterBody($data, $idlang);

            $tb_fltest = '';
            $tb_flcorp = '';

            foreach ($fltest as $el) {
                $tb_fltest .=
                    "<tr data-nutpfl='" . $el->nutpfl . "' data-tpfilt='" . $el->tpfilt . "'>
            <td>
              <span class='txt_des_it'>" . $el->des_it . "</span>
              <input value='" . $el->des_it . "' type='text' class='form-control w-100 des_it' maxlength='80' style='display:none'/>
            </td>
            <td>
              <span class='txt_des_en'>" . $el->des_en . "</span>
              <input value='" . $el->des_en . "' type='text' class='form-control w-100 des_en' maxlength='80' style='display:none'/>
            </td>
            <td>
              <span class='txt_des_es'>" . $el->des_es . "</span>
              <input value='" . $el->des_es . "' type='text' class='form-control w-100 des_es' maxlength='80' style='display:none'/>
            </td>
            <td>
              <span class='txt_des_de'>" . $el->des_de . "</span>
              <input value='" . $el->des_de . "' type='text' class='form-control w-100 des_de' maxlength='80' style='display:none'/>
            </td>
            <td>
              <span class='txt_des_fr'>" . $el->des_fr . "</span>
              <input value='" . $el->des_fr . "' type='text' class='form-control w-100 des_fr' maxlength='80' style='display:none'/>
            </td>
            <td>
              <button type='button' class='btn btn-primary w-45 edit-fltest'>" . $this->translate('_common.modify') . "</button>
              <button type='button' class='btn btn-primary w-45 delete-fltest'>" . $this->translate('_common.delete') . "</button>
              <button type='button' class='btn btn-primary w-45 save-fltest' style='display:none'>" . $this->translate('_common.save') . "</button>
              <button type='button' class='btn btn-primary w-45 cancel-fltest' style='display:none'>" . $this->translate('_common.cancel') . "</button>
              <div class='row'>
                <div class='col-md-12 col-sm-12 col-xs-12'>
                  <div class='msg-error' style='text-align:left;float:left'>" . $this->translate('admin.featured.homepage.error') . "</div>
                </div>
              </div>
            </td>
          </tr>";
            }
            $tb_fltest_foot =
                "<tr class='no-sort'>
          <td><input type='text' class='form-control w-100' maxlength='80' id='des_it'/></td>
          <td><input type='text' class='form-control w-100' maxlength='80' id='des_en'/></td>
          <td><input type='text' class='form-control w-100' maxlength='80' id='des_es'/></td>
          <td><input type='text' class='form-control w-100' maxlength='80' id='des_de'/></td>
          <td><input type='text' class='form-control w-100' maxlength='80' id='des_fr'/></td>
          <td>
            <button type='button' class='btn btn-primary save-new-fltest'>" . $this->translate('_common.save') . "</button>
            <div class='row'>
              <div class='col-md-12 col-sm-12 col-xs-12'>
                <div class='msg-error' style='text-align:left;float:left'>" . $this->translate('admin.featured.homepage.error') . "</div>
              </div>
            </div>
          </td>
        </tr>";

            $idlang = $this->utility->getLanguage();
            $dsfilt = strtolower("des_" . $idlang);
            foreach ($flcorp as $elC) {
                if ($elC->codice != '') {
                    $tb_flcorp .=
                        "<tr data-numfil='" . $elC->numfil . "' data-codice='" . $elC->codice . "'>
              <td><span>" . $elC->descri . "</span></td>
              <td>
                <select class='select2_single form-control fltest w-100' tabindex='-1'>
                  <option value='-1'></option>";
                    foreach ($fltest as $elT) {
                        $tb_flcorp .= "<option value='" . $elT->nutpfl . "' " . ($elC->nutpfl == $elT->nutpfl ? 'selected' : '') . ">";
                        $tb_flcorp .= $elT->$dsfilt;
                        $tb_flcorp .= "</option>";
                    }
                    $tb_flcorp .=
                        "</select>
              </td>
            </tr>";
                }
            }

            echo json_encode(array(
                'response' => 'OK',
                'fltest' => $tb_fltest,
                'fltest_foot' => $tb_fltest_foot,
                'flcorp' => $tb_flcorp
            ));
        }
    }

    public function saveCustomFilterAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            B2bFltest::saveCustomFilter(
                $request->getPost('tpfilt'),
                $request->getPost('des_it'),
                $request->getPost('des_en'),
                $request->getPost('des_es'),
                $request->getPost('des_de'),
                $request->getPost('des_fr')
            );

            echo json_encode('OK');
        }
    }

    public function modifyCustomFilterAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            B2bFltest::updateCustomFilter(
                $request->getPost('nutpfl'),
                $request->getPost('tpfilt'),
                $request->getPost('des_it'),
                $request->getPost('des_en'),
                $request->getPost('des_es'),
                $request->getPost('des_de'),
                $request->getPost('des_fr')
            );

            echo json_encode('OK');
        }
    }

    public function deleteCustomFilterAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            B2bFltest::deleteCustomFilter(
                $request->getPost('nutpfl')
            );

            echo json_encode('OK');
        }
    }

    public function saveCustomFilterBodyAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $numfil = $request->getPost('numfil');
            $nutpfl = $request->getPost('nutpfl');
            $codice = $request->getPost('codice');

            if ($nutpfl != -1) {
                $flcorp = $numfil != -1 ? B2bFlcorp::findFirstByNumfil($numfil) : new B2bFlcorp();
                $flcorp->nutpfl = $nutpfl;
                $flcorp->codice = $codice;
                $flcorp->save();
                $numfil = $flcorp->numfil;
            } else {
                $flcorp = B2bFlcorp::findFirstByNumfil($numfil);
                $flcorp->delete();
                $numfil = -1;
            }

            echo json_encode(array('response' => 'OK', 'numfil' => $numfil));
        }
    }

    public function saveFilterVisibilityAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $flvisi = $request->getPost('flvisi');

            B2bFlvisi::deleteAllFilterVisibilities();

            foreach ($flvisi as $flt) {
                B2bFlvisi::saveFilterVisibility($flt);
            }

            echo json_encode('OK');
        }
    }
    //endregion

    //region Ajax functions: Custom families
    public function editCustomVarAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $mode = $request->getPost('mode');
            $cdregv = $request->getPost('cdregv');
            $tpvari = $request->getPost('tpvari');
            $cdvari = $request->getPost('cdvari');
            $dsvari = $request->getPost('dsvari');
            $seqrap = $request->getPost('seqrap');
            $prezzo = $request->getPost('prezzo');
            $flgene = $request->getPost('flgene');
            $flbloc = $request->getPost('flbloc');
            $ntvari = $request->getPost('ntvari');
            $flimag = $request->getPost('flimag');

            if ($mode == 'i') {
                Tabvar::insertNewCustom($cdregv, $tpvari, $cdvari, $dsvari, $seqrap, $prezzo, $flgene, $flbloc, $ntvari, $flimag);
            } else {
                Tabvar::updateCustom($cdregv, $tpvari, $cdvari, $dsvari, $seqrap, $prezzo, $flgene, $flbloc, $ntvari, $flimag);
            }

            echo json_encode('OK');
        }
    }

    public function editCustomVarFamilyAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $mode = $request->getPost('mode');
            $cdregv = $request->getPost('cdregv');
            $tpvari = $request->getPost('tpvari');
            $dstvar = $request->getPost('dstvar');
            $seqrap = $request->getPost('seqrap');
            $flobbl = $request->getPost('flobbl');
            $flbloc = $request->getPost('flbloc');

            if ($mode == 'i') {
                Tipvar::insertNewFamily($cdregv, $tpvari, $dstvar, $seqrap, $flobbl, $flbloc);
            } else {
                Tipvar::updateFamily($cdregv, $tpvari, $dstvar, $seqrap, $flobbl, $flbloc);
            }

            echo json_encode('OK');
        }
    }

    public function editCustomVarGroupAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $code = $request->getPost('code');
            $desc = $request->getPost('desc');

            if ($code < 0) {
                Regvar::insertNewGroup($desc);
            } else {
                Regvar::updateGroup($code, $desc);
            }

            echo json_encode('OK');
        }
    }

    public function deleteCustomVarAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdregv = $request->getPost('cdregv');
            $tpvari = $request->getPost('tpvari');
            $cdvari = $request->getPost('cdvari');

            Tabvar::deleteAllRecordsForCdregvTpvariCdvari($cdregv, $tpvari, $cdvari);
            Modvar::deleteAllRecordsForCdregvAndcdvari($cdregv, $cdvari);
            Tpmvar::deleteAllRecordsForCdregvAndcdvari($cdregv, $cdvari);

            echo json_encode('OK');
        }
    }

    public function deleteCustomVarFamilyAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdregv = $request->getPost('cdregv');
            $tpvari = $request->getPost('tpvari');

            Tipvar::deleteAllRecordsForCdregvAndTpvari($cdregv, $tpvari);
            Tabvar::deleteAllRecordsForCdregvAndTpvari($cdregv, $tpvari);
            Modvar::deleteAllRecordsForCdregvAndTpvari($cdregv, $tpvari);
            Tpmvar::deleteAllRecordsForCdregvAndTpvari($cdregv, $tpvari);

            echo json_encode('OK');
        }
    }

    public function deleteCustomVarGroupAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdregv = $request->getPost('cdregv');

            Regvar::deleteAllRecordsForCdregv($cdregv);
            Tipvar::deleteAllRecordsForCdregv($cdregv);
            Tabvar::deleteAllRecordsForCdregv($cdregv);
            Modvar::deleteAllRecordsForCdregv($cdregv);
            Tpmvar::deleteAllRecordsForCdregv($cdregv);

            echo json_encode('OK');
        }
    }

    public function loadCustomDetailAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdregv = $request->getPost('cdregv');
            $cdvari = $request->getPost('cdvari');

            $idlang = $this->utility->getLanguage();

            $tpmode = Tpmode::getAllModelTypesForCustomVar($cdregv, $cdvari);
            $cdartn = Tipolo::getAllModelsForCustomVar($cdregv, $cdvari, $idlang);

            echo json_encode(array(
                'tpmode' => $tpmode,
                'cdartn' => $cdartn,
            ));
        }
    }

    public function saveCustomDetailAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdregv = $request->getPost('cdregv');
            $cdvari = $request->getPost('cdvari');
            $cdartn = $request->getPost('cdartn');
            $tpmode = $request->getPost('tpmode');

            Modvar::deleteAllRecordsForCdregvAndCdvari($cdregv, $cdvari);
            Tpmvar::deleteAllRecordsForCdregvAndCdvari($cdregv, $cdvari);

            if (count($cdartn) > 0) {
                foreach ($cdartn as $code) {
                    Modvar::insertNewRecord($cdregv, $cdvari, $code);
                }
            }

            if (count($tpmode) > 0) {
                foreach ($tpmode as $code) {
                    Tpmvar::insertNewRecord($cdregv, $cdvari, $code);
                }
            }

            echo json_encode('OK');
        }
    }
    //endregion

    //region Ajax functions: Custom menu
    public function loadCustomMenuForCatalogAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdcata = $request->getPost('cdcata');

            $customMenuRows = B2bCsmenu::getCustomMenuForCatalog($cdcata);

            $html = $this->getCustomMenuWizard($customMenuRows);

            echo json_encode(array('html' => $html));
        }
    }

    public function saveCustomMenuForCatalogAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdcata = $request->getPost('cdcata');
            $rows = $request->getPost('rows');

            B2bCsmenu::deleteCustomMenuForCatalog($cdcata);

            foreach ($rows as $row) {
                B2bCsmenu::insertCustomMenuRow($row);
            }

            echo json_encode('OK');
        }
    }
    //endregion

    //region Ajax functions: Products management
    public function toggleProductBlockFlagAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdpers = $request->getPost('cdpers');
            $cdcolo = $request->getPost('cdcolo');
            $isFabric = $request->getPost('isFabric');
            $mustBlock = $request->getPost('mustBlock');

            if ($isFabric == 'true') {
                Anaart::updateBlockFlagForFabric($cdpers, $mustBlock === 'true' ? 1 : 0);
            } else {
                Artcol::updateBlockFlagForFabricAndColor($cdpers, $cdcolo, $mustBlock === 'true' ? 1 : 0);
            }

            echo json_encode('OK');
        }
    }
    //endregion

    //region Ajax functions: Catalog management
    public function loadModelsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdcata = $request->getPost("cdcata");
            $idlang = $this->utility->getLanguage();

            $catalogProductType = $this->utility->getAppSettings('ProductTypeOnCatalog');

            switch ($catalogProductType) {
                case 0:
                    $products = Ctarti::getAllModelsFromCatalog($cdcata, $idlang);
                    break;
                case 1:
                    $products = Ctarti::getAllArticlesFromCatalog($cdcata, $idlang);
                    break;
                case 2:
                    $products = Ctarti::getAllArtColFromCatalog($cdcata, $idlang);
                    break;
                default:
                    $products = '';
            }

            echo json_encode($products);
        }
    }

    public function saveCategoryImageAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $mode = $request->getPost("mode");
            $codice = $request->getPost("codice");
            $flimag = $request->getPost("filimg");

            switch ($mode) {
                case 'titl':
                    $titlin = Titlin::findFirstByCdtitl($codice);
                    $titlin->flimag = $flimag != "" ? $flimag : new \Phalcon\Db\RawValue('""');
                    $titlin->save();
                    break;
                case 'linm':
                    $linmod = Linmod::findFirstByCdlinm($codice);
                    $linmod->flimag = $flimag != "" ? $flimag : new \Phalcon\Db\RawValue('""');
                    $linmod->titlin = $linmod->titlin != "" ? $linmod->titlin : new \Phalcon\Db\RawValue('""');
                    $linmod->cdlmat = $linmod->cdlmat != "" ? $linmod->cdlmat : new \Phalcon\Db\RawValue('""');
                    $linmod->save();
                    break;
                case 'serm':
                    $codic2 = $request->getPost("codic2");
                    $sermod = Sermod::findFirst(
                        array(
                            "cdlinm = :codic2: AND cdserm = :codice:",
                            "bind" => array('codice' => $codice, 'codic2' => $codic2)
                        )
                    );
                    $sermod->flimag = $flimag != "" ? $flimag : new \Phalcon\Db\RawValue('""');
                    $sermod->save();
                    break;
            }

            echo json_encode("OK");
        }
    }

    public function getRowSizesAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdtagl = $request->getPost('cdtagl');
            $postgl = Postgl::getAllSizesFromCdtagl($cdtagl);
            $result = json_encode($postgl);

            echo json_encode(array(
                'response' => 'OK',
                'result' => $result
            ));
        }
    }
    //endregion

    //region Ajax functions: Custom variants (Zanotti)
    public function deleteCustomVariantAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdarti = $request->getPost('cdarti');
            Sparti::deleteFeaturesForCustomVariant($cdarti);
            Anaart::deleteCustomVariant($cdarti);
            echo json_encode('OK');
        }
    }

    public function sendCustomVariantsEmailAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $manageOnlySpecial = isset($_POST['manageOnlySpecial']) ? $_POST['manageOnlySpecial'] == 'true' : false;
            $this->utility->getCustomVariantsCsv(true, $this->session->get('language'), $manageOnlySpecial);
            echo json_encode('OK');
        }
    }

    public function downloadCustomVariantsCsvAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $manageOnlySpecial = isset($_POST['manageOnlySpecial']) ? $_POST['manageOnlySpecial'] == 'true' : false;
            $file = $this->utility->getCustomVariantsCsv(false, $this->session->get('language'), $manageOnlySpecial);
            echo json_encode($file);
        }
    }
    //endregion

    //region Ajax functions: Check prices articles
    public function downloadCheckPricesCsvAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            //$articles = $_POST['articles'];
            $catalogs = isset($_POST['catalogs']) ? $_POST['catalogs'] : array();
            $seasons = isset($_POST['seasons']) ? $_POST['seasons'] : array();
            $dates = isset($_POST['dates']) ? $_POST['dates'] : '';

            $articles = Occorp::getAllArticlesWithNoPrice($catalogs, $seasons, $dates);

            // Create file dir
            $fileName = date('Y_m_d') . '_articles_no_price.csv';
            $filePath = '../public/io/csv/email/';
            if (!file_exists('../public/io/csv/email/')) {
                if (!file_exists('../public/io/csv/')) {
                    mkdir('../public/io/csv/', 0777, true);
                }
                mkdir('../public/io/csv/email/', 0777, true);
            }

            // Get email content and csv file
            $csvContent = '';
            $csvContent .= ucfirst($this->translate('_common.code')) . ';';
            $csvContent .= ucfirst($this->translate('_common.quantity')) . ';';
            $csvContent .= ucfirst($this->translate('_common.ordernumber')) . ';';
            $csvContent .= ucfirst($this->translate('_common.catalog')) . ';';
            $csvContent .= ucfirst($this->translate('_common.season')) . ';';
            $csvContent .= ucfirst($this->translate('_common.date')) . ';';
            $csvContent .= "\n";

            if (count($articles) > 0) {
                foreach ($articles as $article) {
                    $csvContent .= $article['cdarti'] . ';';
                    $csvContent .= $article['quanti'] . ';';
                    $csvContent .= $article['nuordc'] . ';';
                    $csvContent .= $article['cdcata'] . ';';
                    $csvContent .= $article['cdstag'] . ';';
                    $csvContent .= $article['dtcrea'] . ';';
                    $csvContent .= "\n";
                }
            }

            // Load file
            file_put_contents($filePath . $fileName, $csvContent);

            echo json_encode(array('fullPath' => $filePath . $fileName, 'filename' => $fileName));
        }
    }
    //endregion

    //region Ajax functions: Procedures
    public function emptyPricesAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            Lscorp::emptyTable();
            echo json_encode("OK");
        }
    }

    public function emptyCustomvarAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $custom = Anaart::getAllCustomArticles();
            foreach ($custom as $item) {
                Anaart::findByCdarti($item->cdarti)->delete();
                Sparti::findByCdarti($item->cdarti)->delete();
                Occorp::findByCdarti($item->cdarti)->delete();
            }
            echo json_encode("OK");
        }
    }
    //endregion

    //region Ajax functions: Media management
    public function deleteFileAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $file = htmlspecialchars_decode($request->getPost("file"));
            unlink(getcwd() . "/upload/media/" . $file);
            echo json_encode("OK");
        }
    }

    public function assignAllImagesAction()
    {
        $this->view->disable();


        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $index = $_POST['index'];
            $reassi = isset($_POST['reassi']) ? $_POST['reassi'] : 1;
            $syncType = $this->utility->getAppSettings('SyncType');

            ini_set('max_execution_time', 0);

            header('Content-Type: text/event-stream');
            header('Cache-Control: no-cache');

            $catalogs = Cttest::find();
            $totCatalogs = count($catalogs);
            for ($i = 0; $i < $totCatalogs; $i++) {
                $catalog = $catalogs[$i];
                $currentIndex = $i + 1;
                $text = $this->translate('_common.catalog') . ': ' . $catalog->cdcata . ' (' . $currentIndex . '/' . $totCatalogs . ')';
                $this->assignImagesSpecial($catalog->cdcata, $syncType, $reassi == 1, $text, $index, true);
            }

            ini_set('max_execution_time', 300);

            echo json_encode("OK");
        }
    }

    public function emptyAdditionalImagesAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            Imgart::emptyTable();
            echo json_encode("OK");
        }
    }
    //endregion

    //region Ajax functions: Color management
    public function saveColorsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $colors = $request->getPost("colors");

            B2bColors::deleteAllColors();

            foreach ($colors as $color) {
                $b2bColors = new B2bColors();
                $b2bColors->codice = $color['codice'];
                $b2bColors->rgbcd1 = $color['rgbcd1'];
                $b2bColors->rgbcd2 = $color['rgbcd2'];
                $b2bColors->rgbcd3 = $color['rgbcd3'];
                $b2bColors->flimag = $color['flimag'];
                $b2bColors->flmult = $color['flmult'];
                $b2bColors->save();
            }

            echo json_encode("OK");
        }
    }
    //endregion

    //region Ajax functions: Order management
    public function getWhoseForOrdersAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $whose = $_POST['whose'];

            $html = $this->translate('table.zeroRecords');
            if ($whose == 'agents') {
                $agents = Anaage::getAllAgents(false);
                if (count($agents) > 0) {
                    $html =
                        '<div class="row text-capitalize">
              <div class="col-md-1"></div>
              <div class="col-md-3">' . $this->translate('_common.code') . '</div>
              <div class="col-md-8">' . $this->translate('_common.name') . '</div>
            </div>';
                    foreach ($agents as $agent) {
                        $html .=
                            '<div class="row whose-row" style="line-height:25px">
                <div class="col-md-1">
                  <label class="checkbox-whose checkbox-container">
                    <input type="checkbox" name="whose-checkbox[]" value="' . $agent->cdagen . '"/>
                    <span class="checkbox-checkmark"></span>
                  </label>
                </div>
                <div class="col-md-3 code">' . $agent->cdagen . '</div>
                <div class="col-md-8 desc">' . $agent->dsagen . '</div>
              </div>';
                    }
                }
            } else if ($whose == 'customers') {
                $customers = Anagra::getAllCustomers();
                if (count($customers) > 0) {
                    $html =
                        '<div class="row text-capitalize">
              <div class="col-md-1"></div>
              <div class="col-md-3">' . $this->translate('_common.code') . '</div>
              <div class="col-md-8">' . $this->translate('account.customer.businessname') . '</div>
            </div>';
                    foreach ($customers as $customer) {
                        $html .=
                            '<div class="row whose-row" style="line-height:25px">
                <div class="col-md-1">
                  <label class="checkbox-whose checkbox-container">
                    <input type="checkbox" name="whose-checkbox[]" value="' . $customer->cdanag . '"/>
                    <span class="checkbox-checkmark"></span>
                  </label>
                </div>
                <div class="col-md-3 code">' . $customer->cdanag . '</div>
                <div class="col-md-8 desc">' . $customer->descri . '</div>
              </div>';
                    }
                }
            }

            echo json_encode($html);
        }
    }

    public function getFilteredOrdersAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $type = $_POST['type'];
            $dtiniz = $_POST['dtiniz'];
            $dtfine = $_POST['dtfine'];
            $whose = $_POST['whose'];
            $whoseSet = !empty($_POST['whoseSet']) ? rtrim($_POST['whoseSet'], ',') : -1;
            $whichSeason = !empty($_POST['whichSeason']) ? rtrim($_POST['whichSeason'], ',') : -1;
            $status = !empty($_POST['status']) ? $_POST['status'] : array();
            $types = !empty($_POST['types']) ? $_POST['types'] : array();
            $prices = !empty($_POST['prices']) ? $_POST['prices'] : array();

            $withBlocks = $this->utility->getAppSettings('ModelDetailStyle') == 3;
            $orders = Octest::getFilteredOrders($type == 'periodagent', $dtiniz, $dtfine, $whose == 'agents', $whoseSet, $whichSeason, $status, $types, $prices, $withBlocks);

            $this->cookies->set('admin-orders-type', $type, time() + 7200);
            $this->cookies->set('admin-orders-dtiniz', $dtiniz, time() + 7200);
            $this->cookies->set('admin-orders-dtfine', $dtfine, time() + 7200);
            $this->cookies->set('admin-orders-whose', $whose, time() + 7200);
            $this->cookies->set('admin-orders-whose-set', $whoseSet, time() + 7200);
            $this->cookies->set('admin-orders-which-season', $whichSeason, time() + 7200);
            $this->cookies->set('admin-orders-status', implode(',', $status), time() + 7200);
            $this->cookies->set('admin-orders-types', implode(',', $types), time() + 7200);
            $this->cookies->set('admin-orders-prices', implode(',', $prices), time() + 7200);

            $rows_num = array();
            if (count($orders) > 0) {
                $orderStateMgmt = $this->utility->getAppSettings('OrderStateManagement');
                $prefix = $this->config->application->baseUri . 'public';

                $agentCanEditXls = $this->utility->getAppSettings('EnableOrderXmlAgent');
                $customerCanEditXls = $this->utility->getAppSettings('EnableOrderXmlCustomer');
                $canEditXls = $agentCanEditXls == 2 || $agentCanEditXls == 3 || $customerCanEditXls == 2 || $customerCanEditXls == 3;
                $enableJoorExport = $this->utility->getAppSettings('EnableExportOrderJoor') != 0;
                $enableDuplicate = $this->utility->getAppSettings('DuplicateOrderFromBackEnd') == 1;
                $hasConfigurator = $this->utility->getAppSettings('ModelDetailStyle') == 5;
                $checkPrices = $this->utility->getAppSettings('PreventOrderToBeSentWithoutPrices') == 1;

                foreach ($orders as $order) {
                    $isEditable = $order->flstat == 1 || $order->flstat == 5 || $order->flstat == 6;
                    $isSendable = ($order->flstat == 1 || $order->flstat == 6) && $order->tpanag != 'CN' && $order->variant_block == 0 && (!$checkPrices || !$order->noprice);
                    $isDeletable = !$hasConfigurator ? true : $order->flstat != 2;

                    $flstat = '<div class="status bold">';
                    switch ($order->flstat) {
                        case 1:
                            $flstat .= "<span class='status-dot sts1'>&#9679; </span> ";
                            $flstat .= "<span class='status-descr'>" . $this->translate('account.order.provisional') . "</span>";
                            break;
                        case 2:
                            $flstat .= "<span class='status-dot sts2'>&#9679; </span> ";
                            $flstat .= "<span class='status-descr'>" . ($orderStateMgmt ? $this->translate('account.order.processed') : $this->translate('account.order.sent')) . "</span>";
                            break;
                        case 3:
                            $flstat .= "<span class='status-dot sts3'>&#9679; </span> ";
                            $flstat .= "<span class='status-descr'>" . $this->translate('account.order.accepted') . "</span>";
                            break;
                        case 4:
                            $flstat .= "<span class='status-dot sts4'>&#9679; </span> ";
                            $flstat .= "<span class='status-descr'>" . $this->translate('account.order.rejected') . "</span>";
                            break;
                        case 5:
                            $flstat .= "<span class='status-dot sts5'>&#9679; </span> ";
                            $flstat .= "<span class='status-descr'>" . $this->translate('account.order.waitingquantity') . "</span>";
                            break;
                        case 6:
                            $flstat .= "<span class='status-dot sts6'>&#9679; </span> ";
                            $flstat .= "<span class='status-descr'>" . $this->translate('account.order.customerconfirmed') . "</span>";
                            break;
                    }
                    $flstat .= "</div>";

                    $buttons = '<div class="row-tool-box" data-nuordc="' . $order->nuordc . '">';

                    if ($checkPrices && $order->noprice) {
                        $occorp = Occorp::getArticlesWithNoPrice($order->nuordc);
                        $title = '';
                        foreach ($occorp as $row) {
                            $title .= $row->cdarti . ' (' . $row->quanti . '), ';
                        }
                        $title = substr($title, 0, -2);
                        $buttons .= '<div class="red-mark" title="' . $title . '">!</div>';
                    }
                    $buttons .= '<div class="order-tool-box-title">' . $this->translate('_common.actions') . '</div>';

                    // See button
                    $buttons .= '<div class="order-list-btn text-center">';
                    $buttons .= '<a href="' . $this->url->get('admin/order/r') . '/' . $order->nuordc . '" class="no-deco">';
                    $buttons .= '<div class="order-tool-box-img"><img src="' . $prefix . '/assets/img/eye.jpg" title="' . $this->translate("_common.seeorder") . '"/></div>';
                    $buttons .= '</a>';
                    $buttons .= '</div>';

                    if ($orderStateMgmt) {
                        // Edit button
                        $buttons .= '<div class="order-list-btn edit-btn text-center ' . (!$isEditable ? 'disabled' : '') . '">';
                        $buttons .= '<a href="' . ($isEditable ? $this->url->get('admin/order/w') . '/' . $order->nuordc : '#') . '" class="no-deco">';
                        $buttons .= '<img src="' . $prefix . '/assets/img/edit.jpg" title="' . $this->translate("_common.modifyorder") . '"/>';
                        $buttons .= '</a>';
                        $buttons .= '</div>';
                    }

                    $orderLimitMode = $this->utility->getAppSettings('OrderLimit');

                    // Send button
                    if ($isSendable && $orderLimitMode > 0) {
                        $orderLimitMinValue = $this->utility->getAppSettings('OrderLimitMinValue');
                        if ($orderLimitMode == 1) {
                            $totArticoli = Octest::countArticlesInOrder($order->nuordc);
                            if ($totArticoli < $orderLimitMinValue) {
                                $isSendable = false;
                            }
                        } else if ($orderLimitMode == 2) {
                            $totSpesa = Octest::retriveSpendInOrder($order->nuordc);
                            if ($totSpesa < $orderLimitMinValue) {
                                $isSendable = false;
                            }
                        }
                    }
                    $buttons .= '<div class="order-list-btn text-center ' . (!$isSendable ? 'disabled' : '') . '">';
                    $buttons .= '<a href="#" class="no-deco send-order" ' . ($isSendable ? 'data-toggle="modal" data-target=".modal-send-order"' : '') . '>';
                    $buttons .= '<img src="' . $prefix . '/assets/img/send.jpg" title="' . $this->translate("_common.sendorder") . '"/>';
                    $buttons .= '</a>';
                    $buttons .= '</div>';

                    if ($canEditXls) {
                        // Xls button - always visible for admin
                        $buttons .= '<div class="order-list-btn ' . ($isEditable ? 'xls-btn' : 'download-xls-btn') . ' text-center">';
                        $buttons .= '<a href="#" class="no-deco">';
                        $buttons .= '<img src="' . $prefix . '/assets/img/xls.jpg" title="xls"/>';
                        $buttons .= '</a>';
                        $buttons .= '</div>';
                    }

                    if ($enableJoorExport) {
                        // Joor button
                        $buttons .= '<div class="order-list-btn joor-btn text-center">';
                        $buttons .= '<a href="#" class="no-deco">';
                        $buttons .= '<img src="' . $prefix . '/assets/img/joor.jpg" title="Joor"/>';
                        $buttons .= '</a>';
                        $buttons .= '</div>';
                    }

                    if ($enableDuplicate) {
                        // Duplicate order button
                        $buttons .= '<div class="order-list-btn duplicate-btn text-center">';
                        $buttons .= '<a href="#" class="no-deco">';
                        $buttons .= '<img src="' . $prefix . '/assets/img/duplicate.jpg" title="' . $this->translate("order.duplicate") . '"/>';
                        $buttons .= '</a>';
                        $buttons .= '</div>';
                    }

                    // Pdf button
                    $order_date = explode('/', $order->dtcrea);
                    $pdf_name = "order-" . $order->nuordc . "-" . $order_date[2] . $order_date[1] . $order_date[0] . ".pdf";
                    $pdfUrl = $prefix . "/pdf/" . $pdf_name;
                    $buttons .= '<div class="order-list-btn text-center">';
                    $buttons .= '<a href="' . $prefix . "/pdf/" . $pdf_name . '" class="no-deco link-pdf" target="_blank"></a>';
                    $buttons .= '<img src="' . $prefix . '/assets/img/pdf.jpg" title="pdf" class="see-pdf" style="cursor:pointer"/>';
                    $buttons .= '</div>';

                    $buttons .= '</div>';

                    /*
          $buttons = '<div class="row-tool-box" data-nuordc="' . $order->nuordc . '">';

          // See button
          $buttons .= '<div class="order-list-btn text-center">';
          $buttons .= '<a href="' . $this->url->get('admin/order/r') . '/' . $order->nuordc . '" class="no-deco">';
          $buttons .= '<img src="' . $prefix . '/assets/img/eye.jpg" title="' . $this->translate("_common.seeorder") . '"/>';
          $buttons .= '</a>';
          $buttons .= '</div>';

          if ($orderStateMgmt) {
            // Edit button
            $buttons .= '<div class="order-list-btn edit-btn text-center ' . (!$isEditable ? 'disabled' : '') . '">';
            $buttons .= '<a href="' . ($isEditable ? $this->url->get('admin/order/w') . '/' . $order->nuordc : '#') . '" class="no-deco">';
            $buttons .= '<img src="' . $prefix . '/assets/img/edit.jpg" title="'. $this->translate("_common.modifyorder") . '"/>';
            $buttons .= '</a>';
            $buttons .= '</div>';
          }

          // Send button
          $buttons .= '<div class="order-list-btn text-center ' . (!$isSendable ? 'disabled' : '') . '">';
          $buttons .= '<a href="#" class="no-deco send-order" ' . ($isSendable ? 'data-toggle="modal" data-target=".modal-send-order"' : '') . '>';
          $buttons .= '<img src="' . $prefix . '/assets/img/send.jpg" title="'. $this->translate("_common.sendorder") . '"/>';
          $buttons .= '</a>';
          $buttons .= '</div>';

          if ($canEditXls) {
            // Xls button - always visible for admin
            $buttons .= '<div class="order-list-btn ' . ($isEditable ? 'xls-btn' : 'download-xls-btn') . ' text-center">';
            $buttons .= '<a href="#" class="no-deco">';
            $buttons .= '<img src="' . $prefix . '/assets/img/xls.jpg" title="xls"/>';
            $buttons .= '</a>';
            $buttons .= '</div>';
          }

          if ($enableJoorExport) {
            // Joor button
            $buttons .= '<div class="order-list-btn joor-btn text-center">';
            $buttons .= '<a href="#" class="no-deco">';
            $buttons .= '<img src="' . $prefix . '/assets/img/joor.jpg" title="Joor"/>';
            $buttons .= '</a>';
            $buttons .= '</div>';
          }

          if ($enableDuplicate) {
            // Duplicate order button
            $buttons .= '<div class="order-list-btn duplicate-btn text-center">';
            $buttons .= '<a href="#" class="no-deco">';
            $buttons .= '<img src="' . $prefix . '/assets/img/duplicate.jpg" title="' . $this->translate("order.duplicate") . '"/>';
            $buttons .= '</a>';
            $buttons .= '</div>';
          }

          // Pdf button
          $order_date = explode('/', $order->dtcrea);
          $pdf_name = "order-" . $order->nuordc . "-" . $order_date[2] . $order_date[1] . $order_date[0] . ".pdf";
          $pdfUrl = $prefix . "/pdf/" . $pdf_name;
          $buttons .= '<div class="order-list-btn text-center">';
          $buttons .= '<a href="' . $prefix . "/pdf/" . $pdf_name . '" class="no-deco link-pdf" target="_blank"></a>';
          $buttons .= '<img src="' . $prefix . '/assets/img/pdf.jpg" title="pdf" class="see-pdf" style="cursor:pointer"/>';
          $buttons .= '</div>';

          $buttons .= '</div>';
          */

                    if ($isDeletable) {
                        $deleteButton = '<div class="order-list-btn text-center">';
                        $deleteButton .= '<a href="#" class="no-deco" data-toggle="modal" data-target=".modal-delete-order">';
                        $deleteButton .= '<img src="' . $prefix . '/assets/img/delete.jpg" title="' . $this->translate('_common.delete') . '" class="delete-order" style="cursor:pointer"/>';
                        $deleteButton .= '</a>';
                        $deleteButton .= '</div>';
                    } else {
                        $deleteButton = '';
                    }

                    $currency = $this->utility->getCurrencySymbol($order->cdvalu);

                    $rows_num[] = array(
                        $order->nuordc,
                        $order->descri,
                        $order->username,
                        $order->dsagen,
                        $order->dtcrea,
                        $order->dtmcoi != '00/00/000' && $order->dtmcoi != null && $order->dtmcof != '00/00/0000' && $order->dtmcof != null
                            ? $order->dtmcoi . " - " . $order->dtmcof
                            : $order->dtmcli,
                        $order->cdcata,
                        $order->quanti,
                        $this->utility->getFormattedPriceCurrencyPresent($order->valore, $currency, $order->cdvalu)['value'],
                        $flstat,
                        $buttons,
                        $deleteButton
                    );
                }
            }

            //$html = $this->getHtmlFilteredOrdersContent($orders);
            if (count($orders) > 0) {
                echo json_encode(array(
                    'response' => 'OK',
                    'rows_num' => $rows_num
                ));
            } else {
                echo json_encode(array('response' => 'NO'));
            }
        }
    }

    public function updateOrderRowNotesAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nurorc = $request->getPost('nurorc');
            $dsnoco = $request->getPost('dsnoco');

            Occorp::updateOrderRowNotes($nurorc, $dsnoco);

            echo json_encode('OK');
        }
    }

    public function getOrderRowAvailableVariantsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdvari = $request->getPost('cdvari');
            $cdartn = $request->getPost('cdartn');
            $tpmode = $request->getPost('tpmode');
            $cdcata = $request->getPost('cdcata');

            $variants = Tabvar::getAllCustomsForModel($cdartn, $tpmode, $cdcata);

            echo json_encode(array(
                'response' => 'OK',
                'html' => $this->getModalContentForChangeVariants($cdvari, $variants)
            ));
        }
    }

    public function updateOrderRowVariantsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdvari = $request->getPost('cdvari');
            $delta = $request->getPost('delta');
            $nurorc = $request->getPost('nurorc');

            Occorp::updateOrderRowCdvari($nurorc, $cdvari);
            Octagl::updateSizeQuantityPrice($nurorc, $delta);

            echo json_encode('OK');
        }
    }

    public function updateOrderRowDateAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nurorc = $request->getPost('nurorc');
            $dtmcli = isset($_POST['dtmcli']) ? $_POST['dtmcli'] : '00/00/0000';

            $items = explode('/', $dtmcli);
            $dtmcli = $items[2] . '-' . $items[1] . '-' . $items[0];

            Occorp::updateOrderRowDate($nurorc, $dtmcli);

            echo json_encode('OK');
        }
    }

    public function updateOrderRowDiscountAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nurorc = $request->getPost('nurorc');
            $field = $request->getPost('field');
            $value = $request->getPost('value');

            Octagl::updateSizeQuantityDiscountForNurorc($nurorc, $field, $value);

            echo json_encode('OK');
        }
    }

    public function updateOrderRowSizeAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nurorc = $request->getPost('nurorc');
            $dstagl = $request->getPost('dstagl');
            $value = $request->getPost('value');

            Octagl::updateSizeQuantity($nurorc, $dstagl, $value);
            Occorp::updateOrderRowQuantity($nurorc);

            echo json_encode('OK');
        }
    }

    public function getOrderRowSizesAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdtagl = $request->getPost('cdtagl');

            $postgl = Postgl::getAllSizesFromCdtagl($cdtagl);

            echo json_encode(array(
                'response' => 'OK',
                'html' => $this->getHtmlContentForMultipleEdit($postgl)
            ));
        }
    }

    public function updateMultipleOrderRowsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nurorc = $request->getPost('nurorc');
            $octagl = $request->getPost('octagl');
            $scont1 = $request->getPost('scont1');
            $scont2 = $request->getPost('scont2');
            $scont3 = $request->getPost('scont3');
            $dtmcli = isset($_POST['dtmcli']) ? $_POST['dtmcli'] : '00/00/0000';
            $dsnoco = $request->getPost('dsnoco');

            for ($i = 0; $i < count($octagl); $i++) {
                $dstagl = $octagl[$i][0];
                $quanti = $octagl[$i][1];
                Octagl::updateMultipleSizeQuantities($nurorc, $dstagl, $quanti, $scont1, $scont2, $scont3);
            }

            $items = explode('/', $dtmcli);
            $dtmcli = $items[2] . '-' . $items[1] . '-' . $items[0];

            Occorp::updateMultipleOrderRows($nurorc, $dtmcli, $dsnoco);

            echo json_encode('OK');
        }
    }

    public function deleteMultipleOrderRowsAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nurorc = $request->getPost('nurorc');

            Occorp::deleteMultipleOrderRows($nurorc);

            echo json_encode('OK');
        }
    }

    public function deleteOrderRowsWithNoQuantityAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nuordc = $request->getPost('nuordc');

            Occorp::deleteOrderRowsWithNoQuantity($nuordc);
            Octest::updateOrderState($nuordc, 1);

            echo json_encode('OK');
        }
    }

    public function updateOrderStateAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nuordc = $request->getPost('nuordc');
            $flstat = $request->getPost('flstat');

            Octest::updateOrderState($nuordc, $flstat);

            echo json_encode('OK');
        }
    }

    public function updateOrderHeaderAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nuordc = $request->getPost('nuordc');
            $cddesm = $request->getPost('cddesm');
            $tppaga = $request->getPost('tppaga');
            $tpport = $request->getPost('tpport');
            $notcli = $request->getPost('notcli');
            $notazi = $request->getPost('notazi');

            Octest::updateOrderHeader($nuordc, $cddesm, $tppaga, $tpport, $notcli, $notazi);

            echo json_encode('OK');
        }
    }

    public function getShippingsForDuplicateOrderAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $tpanag = $request->getPost('tpanag');
            $cdanag = $request->getPost('cdanag');

            $shippings = Desmer::getShippingsForCustomer($tpanag, $cdanag);

            $html = '';
            if (count($shippings) > 0) {
                $html .= '<option class="destination_selector" value="">' . $this->translate('_common.address.main') . '</option>';
                foreach ($shippings as $desmer) {
                    $html .= '<option class="destination_selector" title="' . $desmer->desvid . ' - ' . $this->elements->getAddress($desmer);
                    $html .= '" value="' . $desmer->cddesm . '">';
                    $html .= $desmer->desvid . ' - ' . $this->elements->getAddress($desmer);
                    $html .= '</option>';
                }
            }
            echo json_encode($html);
        }
    }

    public function duplicateOrderAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $tpanag = $request->getPost('tpanag');
            $cdanag = $request->getPost('cdanag');
            $cddesm = $request->getPost('cddesm');
            $nuordc = $request->getPost('nuordc');

            $auth = $this->session->get('auth');

            $o_octest = Octest::findFirstByNuordc($nuordc);
            $n_nuordc = Octest::insertNewOrderFromAdminDuplicate($o_octest, $auth['id'], $tpanag, $cdanag, $cddesm);

            $o_occorp = Occorp::findByNuordc($o_octest->nuordc);
            foreach ($o_occorp as $order_row) {
                $n_nurorc = Occorp::insertNewOrderRowFromAdminDuplicate($order_row, $n_nuordc);
                Octagl::duplicateOrderRowQuantities($order_row->nurorc, $n_nurorc);
                Ocasso::duplicateOrderRowAssortments($order_row->nurorc, $n_nurorc);
            }

            echo json_encode('OK');
        }
    }

    public function sendOrderAction()
    {
        $this->view->disable();

        $request = $this->request;
        if ($request->isPost() && $request->isAjax() && $request->hasPost('nuordc')) {
            $octest = Octest::findFirstByNuordc($request->getPost('nuordc'));
            $response = $this->utility->sendOrder($octest, 2, null, true);
            echo json_encode($response);
        }
    }

    public function deleteOrderAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nuordc = $_POST['nuordc'];
            $octest = Octest::findFirstByNuordc($nuordc);
            if ($octest) {
                $octest->flstat = 4;

                // Zanotti: delete all custom articles and their features (before sparti for inner join with anaart)
                if ($this->utility->getAppSettings('ModelDetailStyle') == 3) {
                    Sparti::deleteAllFeaturesOfCustomArticlesForOrder($nuordc);
                    Anaart::deleteAllCustomArticlesForOrder($nuordc);
                    // Block new customer
                    if ($octest->tpanag == 'CN') {
                        Anagra::blockNewCustomer($octest->cdanag);
                    }
                }

                if ($octest->save() === false) {
                    echo json_encode('OE');
                } else {
                    echo json_encode('OK');
                }
            } else {
                echo json_encode('ER');
            }
        }
    }

    public function getColorsForCurrentArticleAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdarti = $_POST['cdarti'];
            $colors = Artcol::getColorsFromArticle($cdarti);
            echo json_encode(array('colors' => $colors));
        }
    }

    public function getVariantsForCurrentArticleAndColorAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdcata = $_POST['cdcata'];
            $cdarti = $_POST['cdarti'];
            $cdcolo = $_POST['cdcolo'];
            $article = Anaart::findFirstByCdarti($cdarti);
            $model = Tipolo::findFirstByCdartn($article->cdartn);
            $variants = Tabvar::getAllCustomsForModel($model->cdartn, $model->tpmode, $cdcata);

            $html = $this->getModalContentForVariants($variants);

            $html .= $this->getModalContentForInserQuantityVariants(Postgl::getSizesFromCdarti($cdarti));

            echo json_encode(array('html' => $html, 'error' => count(Artcol::getColor($cdcolo, $cdarti)) == 0));
        }
    }

    public function addRowToOrderAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $nuordc = $_POST['nuordc'];
            $cdcata = $_POST['cdcata'];
            $cdarti = $_POST['cdarti'];
            $cdcolo = $_POST['cdcolo'];
            $cdvari = $_POST['cdvari'];
            $octagl = $_POST['octagl'];
            $variants = str_split($cdvari);

            $addPrice = 0;
            foreach ($variants as $variant) {
                if ($variant != '') {
                    $addPrice += Tabvar::getCustomFromCdvariAndCdcata($variant, $cdcata)->prezzo;
                }
            }

            $quanti = 0;
            foreach ($octagl as $size) {
                $quanti += intval($size[1]);
            }

            // Save row
            $seqrap = Occorp::getMaxIndexForOrder($nuordc) + 1;
            $nurorc = Occorp::insertOrderRow($nuordc, $seqrap, $cdarti, $cdcolo, $cdcata, $quanti, $cdvari);

            // Save sizes
            foreach ($octagl as $size) {
                Octagl::insertSizeQuantityForVariant($nuordc, $nurorc, $size[0], $size[1] != '' ? $size[1] : 0, $addPrice);
            }

            echo json_encode('OK');
        }
    }
    //endregion

    //region Ajax functions: Budget management
    public function loadBudgetForCustomerAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $tpanag = $_POST['tpanag'];
            $cdanag = $_POST['cdanag'];
            $cdstag = $_POST['cdstag'];
            $cmpSeasons = $_POST['cmpSeasons'];
            $columns = $_POST['columns'];
            $type = $_POST['type'];

            $budget = B2bBgtest::getBudgetInfoFromCustomerAndSeason($tpanag, $cdanag, $cdstag, $cmpSeasons, $columns, $type == 0);

            $fullBudgets = array();
            for ($i = 0; $i < count($budget); $i++) {
                $currentBudget = $budget[$i];
                $currentBudget->currentSituation = Octagl::getCurrentSituationForBudget(
                    $tpanag,
                    $cdanag,
                    $currentBudget->cdstag,
                    $currentBudget->cduscc,
                    $currentBudget->cdtitl,
                    $currentBudget->cdlinm,
                    $currentBudget->cdserm
                );
                $fullBudgets[] = $currentBudget;
            }

            if (count($fullBudgets) > 0) {
                // Check if brand is to add;
                $addBrand = false;
                $currentBrandCode = $budget[0]->cdtitl;
                foreach ($fullBudgets as $item) {
                    if ($item->cdtitl != $currentBrandCode) {
                        $addBrand = true;
                        break;
                    }
                }

                // Get number of season 0 columns
                $hideBudget = !isset($fullBudgets[0]->valbdg) || !isset($fullBudgets[0]->qtabdg);
                $hideTarget = !isset($fullBudgets[0]->valtrg) || !isset($fullBudgets[0]->qtatrg);

                $nulist = $this->utility->getDefaultNulistFromCustomer($tpanag, $cdanag);
                $lstest = Lstest::findFirstByNulist($nulist);
                $currency = $this->utility->getCurrencySymbol($lstest->cdvalu);

                if ($type == 0) {
                    $isLineSorting = true;
                    $title = $this->translate('_common.line') . ' - ' . $this->translate('_common.drop');
                } else {
                    $isLineSorting = false;
                    $title = $this->translate('_common.drop') . ' - ' . $this->translate('_common.line');
                }

                $lineColumnWidth = 350;
                $otherColumnWidth = 150;
                $html = $this->elements->getBudgetHeaderHtml($lineColumnWidth, $otherColumnWidth, 'px',
                    $fullBudgets[0], $title, $hideBudget, $hideTarget);
                $html .= $this->elements->getBudgetForCustomerBodyHtml($lineColumnWidth, $otherColumnWidth, 'px',
                    $fullBudgets, $addBrand, $currency, $isLineSorting, $hideBudget, $hideTarget);
            } else {
                $html = $this->translate('account.budget.no');
            }

            echo json_encode(array('html' => $html));
        }
    }

    public function loadGlobalBudgetAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $cdstag = $_POST['cdstag'];
            $cmpSeasons = $_POST['cmpSeasons'];
            $columns = $_POST['columns'];
            $line = $_POST['line'];
            $drop = $_POST['drop'];

            $budget = B2bBgtest::getGlobalBudgetInfoFromSeason($cdstag, $cmpSeasons, $columns, $line, $drop);

            $fullBudgets = array();
            for ($i = 0; $i < count($budget); $i++) {
                $currentBudget = $budget[$i];
                $currentBudget->currentSituation = Octagl::getCurrentGlobalSituationForBudget(
                    $currentBudget->tpanag,
                    $currentBudget->cdanag,
                    $cdstag,
                    $line,
                    $drop
                );
                $fullBudgets[] = $currentBudget;
            }

            if (count($fullBudgets) > 0) {
                // Get number of season 0 columns
                $hideBudget = !isset($fullBudgets[0]->valbdg) || !isset($fullBudgets[0]->qtabdg);
                $hideTarget = !isset($fullBudgets[0]->valtrg) || !isset($fullBudgets[0]->qtatrg);

                $title = $this->translate('_common.customer');

                $lineColumnWidth = 500;
                $otherColumnWidth = 150;
                $html = $this->elements->getBudgetHeaderHtml($lineColumnWidth, $otherColumnWidth, 'px',
                    $fullBudgets[0], $title, $hideBudget, $hideTarget);
                $html .= $this->elements->getGlobalBudgetBodyHtml($lineColumnWidth, $otherColumnWidth, 'px',
                    $fullBudgets, $hideBudget, $hideTarget);
            } else {
                $html = $this->translate('account.budget.no2');
            }

            echo json_encode(array('html' => $html));
        }
    }
    //endregion

    //region Ajax functions: Rules management
    public function getItemsForRulesAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $linmod = $request->getPost('lines');
            $cttest = $request->getPost('catalogs');

            $cttest_keys = '';
            $linmod_keys = '';
            $params = array();
            if ($cttest != '') {
                for ($i = 0; $i < count($cttest); $i++) {
                    $cttest_keys .= ":cdcata" . $i . ":,";
                    $params['cdcata' . $i . ''] = $cttest[$i];
                }
                $cttest_keys = substr($cttest_keys, 0, -1);
            }
            if ($linmod != '') {
                for ($i = 0; $i < count($linmod); $i++) {
                    $linmod_keys .= ":cdlinm" . $i . ":,";
                    $params['cdlinm' . $i . ''] = $linmod[$i];
                }
                $linmod_keys = substr($linmod_keys, 0, -1);
            }

            $tipolo = Tipolo::getModelsAndRules($cttest_keys, $linmod_keys, $params);
            //$anaart = Anaart::getArticlesAndRules($cttest_keys, $linmod_keys, $params);

            $response = array('response' => 'OK', 'tipolo' => '', 'anaart' => '');
            $response['tipolo'] = $this->getHtmlRules($tipolo);
            //$response['anaart'] = $this->getHtmlRules($anaart);

            echo json_encode($response);
        }
    }

    public function saveRulesAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $items = $request->getPost('items');
            $linmod = $request->getPost('lines');
            $cttest = $request->getPost('catalogs');

            $cttest_keys = '';
            $linmod_keys = '';
            $params = array();
            if ($cttest != '') {
                for ($i = 0; $i < count($cttest); $i++) {
                    $cttest_keys .= ":cdcata" . $i . ",";
                    $params['cdcata' . $i] = $cttest[$i];
                }
                $cttest_keys = substr($cttest_keys, 0, -1);
            }
            if ($linmod != '') {
                for ($i = 0; $i < count($linmod); $i++) {
                    $linmod_keys .= ":cdlinm" . $i . ",";
                    $params['cdlinm' . $i] = $linmod[$i];
                }
                $linmod_keys = substr($linmod_keys, 0, -1);
            }

            Regqta::deleteAllRules($cttest_keys, $linmod_keys, $params);
            Regqtm::deleteAllRules($cttest_keys, $linmod_keys, $params);

            if ($items != '') {
                foreach ($items as $item) {
                    if ($item['ra_qtamin'] > 0 || $item['ra_qtamul'] > 0) {
                        Regqta::createNewModelRule($item['cdartn'], $item['ra_qtamin'], $item['ra_qtamul']);
                    }
                    if ($item['rm_qtamin'] > 0 || $item['rm_qtamul'] > 0) {
                        Regqtm::createNewModelRule($item['cdartn'], $item['rm_qtamin'], $item['rm_qtamul']);
                    }
                }
            }

            echo json_encode('OK');
        }
    }
    //endregion

    //region Ajax functions: Localization
    public function getLocalizationAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $data = $request->getPost('data');

            switch ($data) {
                case 'linmod':
                    $elements = Linmod::getLinesForLocalization();
                    break;
                case 'sermod':
                    $elements = Sermod::getSeriesForLocalization();
                    break;
                case 'tpmode':
                    $elements = Tpmode::getModelTypesForLocalization();
                    break;
                case 'tpgene':
                    $elements = Tpgene::getGenresForLocalization();
                    break;
            }

            $table = '';
            foreach ($elements as $el) {
                $table .=
                    "<tr data-codic1='" . $el->code . "' " . ($data == 'sermod' ? "data-codic2='" . $el->cdlinm . "'" : '') . ">
            <td>" .
                    $el->code . ($el->description != '' && $el->description != $el->code ? ' - ' . $el->description : '') .
                    ($data == 'sermod' ? '(' . $el->cdlinm . ($el->dslinm != '' && $el->cdlinm != $el->dslinm ? ' - ' . $el->dslinm : '') . ')' : '') .
                    "</td>
            <td>
              <input value='" . $el->des_it . "' type='text' class='form-control w-100 des_it' maxlength='80'/>
            </td>
            <td>
              <input value='" . $el->des_en . "' type='text' class='form-control w-100 des_en' maxlength='80'/>
            </td>
            <td>
              <input value='" . $el->des_es . "' type='text' class='form-control w-100 des_es' maxlength='80'/>
            </td>
            <td>
              <input value='" . $el->des_de . "' type='text' class='form-control w-100 des_de' maxlength='80'/>
            </td>
            <td>
              <input value='" . $el->des_fr . "' type='text' class='form-control w-100 des_fr' maxlength='80'/>
            </td>
          </tr>";
            }

            echo json_encode(array(
                'response' => 'OK',
                'rows' => $table
            ));
        }
    }

    public function saveLocalizationAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
            $table = $request->getPost('table');
            $rows = $request->getPost('rows');

            B2bAddinf::deleteAllLocalizedDescriptions($table);

            foreach ($rows as $row) {
                $code2 = $table == 'sermod' ? $row[1] : '';
                if ($row[2] != '') {
                    B2bAddinf::insertLocalizedDescription($table, $row[0], $code2, 'des_it', $row[2]);
                }
                if ($row[3] != '') {
                    B2bAddinf::insertLocalizedDescription($table, $row[0], $code2, 'des_en', $row[3]);
                }
                if ($row[4] != '') {
                    B2bAddinf::insertLocalizedDescription($table, $row[0], $code2, 'des_es', $row[4]);
                }
                if ($row[5] != '') {
                    B2bAddinf::insertLocalizedDescription($table, $row[0], $code2, 'des_fr', $row[5]);
                }
                if ($row[6] != '') {
                    B2bAddinf::insertLocalizedDescription($table, $row[0], $code2, 'des_de', $row[6]);
                }
            }

            echo json_encode('OK');
        }
    }
    //endregion

    //region Period analysis
    private function getStats()
    {
        $agents = $this->session->get('anl-stat-age');
        $brands = $this->session->get('anl-stat-brn');
        $catalogs = $this->session->get('anl-stat-cat');
        $countries = $this->session->get('anl-stat-cou');
        $customers = $this->session->get('anl-stat-cus');
        $genres = $this->session->get('anl-stat-gen');
        $lines = $this->session->get('anl-stat-lin');
        $modeltypes = $this->session->get('anl-stat-mot');
        $ordertypes = $this->session->get('anl-stat-ort');
        $series = $this->session->get('anl-stat-ser');

        $type = intval($this->session->get('anl-stat-type'));
        $period1 = $this->session->get('anl-stat-per1');
        $period2 = $this->session->get('anl-stat-per2');
        $period3 = $this->session->get('anl-stat-per3');

        $dtiniz1 = '';
        $dtfine1 = '';
        $dtiniz2 = '';
        $dtfine2 = '';
        $dtiniz3 = '';
        $dtfine3 = '';

        $dates1 = explode(" - ", $period1);
        $items1_0 = explode("/", $dates1[0]);
        $items1_1 = explode("/", $dates1[1]);
        $dtiniz1 = $items1_0[2] . "-" . $items1_0[1] . "-" . $items1_0[0];
        $dtfine1 = $items1_1[2] . "-" . $items1_1[1] . "-" . $items1_1[0];

        if ($period2 != '') {
            $dates2 = explode(" - ", $period2);
            $items2_0 = explode("/", $dates2[0]);
            $items2_1 = explode("/", $dates2[1]);
            $dtiniz2 = $items2_0[2] . "-" . $items2_0[1] . "-" . $items2_0[0];
            $dtfine2 = $items2_1[2] . "-" . $items2_1[1] . "-" . $items2_1[0];
        }

        if ($period3 != '') {
            $dates3 = explode(" - ", $period3);
            $items3_0 = explode("/", $dates3[0]);
            $items3_1 = explode("/", $dates3[1]);
            $dtiniz3 = $items3_0[2] . "-" . $items3_0[1] . "-" . $items3_0[0];
            $dtfine3 = $items3_1[2] . "-" . $items3_1[1] . "-" . $items3_1[0];
        }

        $sel = '';
        switch ($type) {
            case 2:
                $sel = 'tm.dstmod AS inCol1, tl.dstitl AS inCol2, lm.dslinm AS inCol3';
                $grp = 'inCol1, inCol2, inCol3';
                $selExt = 'r.inCol1 AS col1, r.inCol2 AS col2, r.inCol3 AS col3';
                $grpExt = 'col1, col2, col3';
                break;
            case 3:
                $sel = 'tl.dstitl AS inCol1, lm.dslinm AS inCol2';
                $grp = 'inCol1, inCol2';
                $selExt = 'r.inCol1 AS col1, r.inCol2 AS col2';
                $grpExt = 'col1, col2';
                break;
            case 4:
                $sel = "tl.dstitl AS inCol1, lm.dslinm AS inCol2, COALESCE(sm.dsserm,'') AS inCol3";
                $grp = 'inCol1, inCol2, inCol3';
                $selExt = 'r.inCol1 AS col1, r.inCol2 AS col2, r.inCol3 AS col3';
                $grpExt = 'col1, col2, col3';
                break;
            case 5:
                $sel = 'tl.dstitl AS inCol1, lm.dslinm AS inCol2, tp.cdartn AS inCol3';
                $grp = 'inCol1, inCol2, inCol3';
                $selExt = 'r.inCol1 AS col1, r.inCol2 AS col2, r.inCol3 AS col3';
                $grpExt = 'col1, col2, col3';
                break;
            case 6:
                $sel = 'tl.dstitl AS inCol1, lm.dslinm AS inCol2, aa.cdarti AS inCol3';
                $grp = 'inCol1, inCol2, inCol3';
                $selExt = 'r.inCol1 AS col1, r.inCol2 AS col2, r.inCol3 AS col3';
                $grpExt = 'col1, col2, col3';
                break;
            case 7:
                $sel = 'tl.dstitl AS inCol1, lm.dslinm AS inCol2, tm.dstmod AS inCol3';
                $grp = 'inCol1, inCol2, inCol3';
                $selExt = 'r.inCol1 AS col1, r.inCol2 AS col2, r.inCol3 AS col3';
                $grpExt = 'col1, col2, col3';
                break;
            case 8:
                $sel = 'ag.descri AS inCol1';
                $grp = 'inCol1';
                $selExt = 'r.inCol1 AS col1';
                $grpExt = 'col1';
                break;
            case 9:
                $sel = 'ag.descri AS inCol1, tm.dstmod AS inCol2';
                $grp = 'inCol1, inCol2';
                $selExt = 'r.inCol1 AS col1, r.inCol2 AS col2';
                $grpExt = 'col1, col2';
                break;
            case 10:
                $sel = 'ag.descri AS inCol1, tl.dstitl AS inCol2, lm.dslinm AS inCol3';
                $grp = 'inCol1, inCol2, inCol3';
                $selExt = 'r.inCol1 AS col1, r.inCol2 AS col2, r.inCol3 AS col3';
                $grpExt = 'col1, col2, col3';
                break;
            case 11:
                $sel = 'ag.descri AS inCol1, tl.dstitl AS inCol2, lm.dslinm AS inCol3, tp.cdartn AS inCol4';
                $grp = 'inCol1, inCol2, inCol3, inCol4';
                $selExt = 'r.inCol1 AS col1, r.inCol2 AS col2, r.inCol3 AS col3, r.inCol4 AS col4';
                $grpExt = 'col1, col2, col3, col4';
                break;
            case 12:
                $sel = 'ag.descri AS inCol1, tl.dstitl AS inCol2, lm.dslinm AS inCol3, aa.cdarti AS inCol4';
                $grp = 'inCol1, inCol2, inCol3, inCol4';
                $selExt = 'r.inCol1 AS col1, r.inCol2 AS col2, r.inCol3 AS col3, r.inCol4 AS col4';
                $grpExt = 'col1, col2, col3, col4';
                break;
            case 13:
                $sel = 'an.dsagen AS inCol1, ag.descri AS inCol2';
                $grp = 'inCol1, inCol2';
                $selExt = 'r.inCol1 AS col1, r.inCol2 AS col2';
                $grpExt = 'col1, col2';
                break;
            case 14:
                $sel = 'an.dsagen AS inCol1, ag.descri AS inCol2, tm.dstmod AS inCol3';
                $grp = 'inCol1, inCol2, inCol3';
                $selExt = 'r.inCol1 AS col1, r.inCol2 AS col2, r.inCol3 AS col3';
                $grpExt = 'col1, col2, col3';
                break;
            case 15:
                $sel = 'an.dsagen AS inCol1, ag.descri AS inCol2, tl.dstitl AS inCol3, lm.dslinm AS inCol4';
                $grp = 'inCol1, inCol2, inCol3, inCol4';
                $selExt = 'r.inCol1 AS col1, r.inCol2 AS col2, r.inCol3 AS col3, r.inCol4 AS col4';
                $grpExt = 'col1, col2, col3, col4';
                break;
            case 16:
                $sel = 'an.dsagen AS inCol1, tm.dstmod AS inCol2';
                $grp = 'inCol1, inCol2';
                $selExt = 'r.inCol1 AS col1, r.inCol2 AS col2';
                $grpExt = 'col1, col2';
                break;
            case 17:
                $sel = 'an.dsagen AS inCol1, tl.dstitl AS inCol2, lm.dslinm AS inCol3';
                $grp = 'inCol1, inCol2, inCol3';
                $selExt = 'r.inCol1 AS col1, r.inCol2 AS col2, r.inCol3 AS col3';
                $grpExt = 'col1, col2, col3';
                break;
            case 1:
            default:
                $sel = 'tm.dstmod AS inCol1';
                $grp = 'inCol1';
                $selExt = 'r.inCol1 AS col1';
                $grpExt = 'col1';
                break;
        }

        $fltAge = $this->getFilterWhere('age', $agents);
        $fltBrn = $this->getFilterWhere('brn', $brands);
        $fltCat = $this->getFilterWhere('cat', $catalogs);
        $fltCou = $this->getFilterWhere('cou', $countries);
        $fltCus = $this->getFilterWhere('cus', $customers);
        $fltGen = $this->getFilterWhere('gen', $genres);
        $fltLin = $this->getFilterWhere('lin', $lines);
        $fltMot = $this->getFilterWhere('mot', $modeltypes);
        $fltOrt = $this->getFilterWhere('ort', $ordertypes);
        $fltSer = $this->getFilterWhere('ser', $series);

        $join = '';
        if (($type >= 13 && $type <= 17) || $fltAge != '') {
            $join .= 'INNER JOIN b2b_usrage ua ON ua.id_usr = ot.id_usr ';
        }
        if ($type >= 13 && $type <= 17) {
            $join .= 'INNER JOIN anaage an ON an.cdagen = ua.cdagen ';
        }
        if ($type >= 8 && $type <= 15) {
            $join .= 'INNER JOIN anagra ag ON ag.tpanag = ot.tpanag AND ag.cdanag = ot.cdanag ';
        }
        if (($type != 8 && $type != 13) || $fltBrn != '' || $fltCat != '' || $fltGen != '' || $fltLin != '' || $fltMot != '' || $fltSer != '') {
            $join .= 'INNER JOIN anaart aa ON oc.cdarti = aa.cdarti ';
        }
        if ($fltCat != '') {
            $join .= 'INNER JOIN ctarti ct ON ct.cdarti = oc.cdarti ';
        }
        if (($type != 8 && $type != 13) || $fltBrn != '' || $fltGen != '' || $fltLin != '' || $fltMot != '' || $fltSer != '') {
            $join .= 'INNER JOIN tipolo tp ON tp.cdartn = aa.cdartn ';
        }
        if (($type != 1 && $type != 8 && $type != 9 && $type != 13 && $type != 14 && $type != 16) || $fltBrn != '') {
            $join .= 'INNER JOIN linmod lm ON lm.cdlinm = tp.cdlinm ';
        }
        if ($type == 1 || $type == 2 || $type == 7 || $type == 9 || $type == 14 || $type == 16) {
            $join .= 'INNER JOIN tpmode tm ON tm.tpmode = tp.tpmode ';
        }
        if ($type != 1 && $type != 8 && $type != 9 && $type != 13 && $type != 14 && $type != 16) {
            $join .= 'INNER JOIN titlin tl ON tl.cdtitl = lm.cdtitl ';
        }
        if ($type == 4) {
            $join .= 'LEFT JOIN sermod sm ON sm.cdlinm = tp.cdlinm AND sm.cdserm = tp.cdserm ';
        }

        $sql_start = "SELECT $sel, ";
        $sql_end = "FROM octagl og
      INNER JOIN occorp oc ON oc.nurorc = og.nurorc
      INNER JOIN octest ot ON ot.nuordc = oc.nuordc
      $join
      WHERE ot.flstat != 0 AND ot.flstat != 4
      $fltAge $fltBrn $fltCat $fltCou $fltCus $fltGen $fltLin $fltMot $fltOrt $fltSer ";

        $sql = $sql_start .
            "SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS val1, SUM(og.quanti) AS qty1, 0 AS val2, 0 AS qty2, 0 AS val3, 0 AS qty3 " .
            $sql_end .
            "AND ot.dtcrea >= :dtiniz1 AND ot.dtcrea <= :dtfine1
      GROUP BY $grp ";

        $params = array();
        $params['dtiniz1'] = $dtiniz1;
        $params['dtfine1'] = $dtfine1;

        $selExt2 = '';
        if ($period2 != '') {
            $sql .= " UNION " . $sql_start .
                "0 AS qty1, 0 AS val1, SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS val2, SUM(og.quanti) AS qty2, 0 AS val3, 0 AS qty3 " .
                $sql_end .
                "AND ot.dtcrea >= :dtiniz2 AND ot.dtcrea <= :dtfine2
        GROUP BY $grp ";
            $params['dtiniz2'] = $dtiniz2;
            $params['dtfine2'] = $dtfine2;
            $selExt2 .= ", SUM(r.qty2) AS qty2, SUM(r.val2) AS val2";
        }

        $selExt3 = '';
        if ($period3 != '') {
            $sql .= " UNION " . $sql_start .
                "0 AS qty1, 0 AS val1, 0 AS qty2, 0 AS val2, SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)) AS val3, SUM(og.quanti) AS qty3 " .
                $sql_end .
                "AND ot.dtcrea >= :dtiniz3 AND ot.dtcrea <= :dtfine3
        GROUP BY $grp ";
            $params['dtiniz3'] = $dtiniz3;
            $params['dtfine3'] = $dtfine3;
            $selExt3 .= ", SUM(r.qtatot3) AS qty3, SUM(r.impnet3) AS imp3";
        }

        $sql .= "ORDER BY $grp DESC";

        $sqlComplete = "SELECT $selExt, SUM(r.qty1) AS qty1, SUM(r.val1) AS val1 $selExt2 $selExt3 FROM ($sql) AS r GROUP BY $grpExt";

        $stats = $this->db->query($sqlComplete, $params)->fetchAll();

        return $stats;
    }

    private function getFilterWhere($type, $elements)
    {
        $flt = '';
        if ($elements != "all") {
            if ($type == 'cus') {
                for ($i = 0; $i < count($elements); $i++) {
                    $flt .= "(ot.tpanag = '" . $elements[$i]['tpanag'] . "' AND ot.cdanag = '" . $elements[$i]['cdanag'] . "') OR ";
                }
            } else if ($type == 'ser') {
                for ($i = 0; $i < count($elements); $i++) {
                    $flt .= "(tp.cdlinm = '" . $elements[$i]['cdlinm'] . "' AND tp.cdserm = '" . $elements[$i]['cdserm'] . "') OR ";
                }
            } else {
                switch ($type) {
                    case 'brn':
                        $field = 'lm.cdtitl';
                        break;
                    case 'cat':
                        $field = 'ct.cdcata';
                        break;
                    case 'cou':
                        $field = 'ag.cdnazi';
                        break;
                    case 'gen':
                        $field = 'tp.tpgene';
                        break;
                    case 'lin':
                        $field = 'tp.cdlinm';
                        break;
                    case 'mot':
                        $field = 'tp.tpmode';
                        break;
                    case 'ort':
                        $field = 'ot.tpordc';
                        break;
                    case 'age':
                    default:
                        $field = 'an.cdagen';
                        break;
                }

                for ($i = 0; $i < count($elements); $i++) {
                    $flt .= $field . " = '" . $elements[$i] . "' OR ";
                }
            }
            $flt = $flt != '' ? 'AND (' . substr($flt, 0, -4) . ') ' : '';
        }

        return $flt;
    }

    private function getHtmlTabSynthesis($tot, $period1, $period2, $period3)
    {
        $max_qty = $tot['qty1'];
        $max_val = $tot['val1'] / 1000;
        $max_rat = $tot['qty1'] > 0 ? $tot['val1'] / $tot['qty1'] : 0;

        $colWidth = $period2 != '' && $period3 != '' ? '33.3333' : '50';

        if ($period2 != '') {
            $max_qty = $tot['qty2'] > $max_qty ? $tot['qty2'] : $max_qty;
            $max_val = $tot['val2'] / 1000 > $max_val ? $tot['val2'] / 1000 : $max_val;
            $max_rat = $tot['qty2'] > 0 && $tot['val2'] / $tot['qty2'] > $max_rat ? $tot['val2'] / $tot['qty2'] : $max_rat;
        }

        if ($period2 != '') {
            $max_qty = $tot['qty3'] > $max_qty ? $tot['qty3'] : $max_qty;
            $max_val = $tot['val3'] / 1000 > $max_val ? $tot['val3'] / 1000 : $max_val;
            $max_rat = $tot['qty3'] > 0 && $tot['val3'] / $tot['qty3'] > $max_rat ? $tot['val3'] / $tot['qty3'] : $max_rat;
        }

        // Column quantity
        $html =
            '<div class="row mt-40x">
      <div class="col-md-4 mb-30x">
        <div class="title-column-stats">' . $this->translate('statistics.graph.qtyperseason') . '</div>
        <div class="mt-10x">
          <div class="fl" style="width:' . $colWidth . '%">
            <div class="graph-value-stats">' . $tot['qty1'] . '</div>
            <div class="header-column-stats">&nbsp;</div>
            <div class="header-column-stats">&nbsp;</div>
            <div class="column-graph-stats grad-time1"
              style="height:' . ($max_qty > 0 ? 400 * ($tot['qty1'] / $max_qty) : 400) . 'px;
              margin-top:' . ($max_qty > 0 ? 400 - (400 * ($tot['qty1'] / $max_qty)) : 0) . 'px"></div>
            <div class="footer-column-stats">' . $period1 . '</div>
          </div>';

        if ($period2 != '') {
            $qty2_diff = $tot['qty1'] - $tot['qty2'];
            $diff = ($qty2_diff > 0 ? '+' : '') . $qty2_diff;
            $perc = ($qty2_diff > 0 ? '+' : '') . ($tot['qty2'] > 0 ? number_format(floatval(($qty2_diff * 100) / $tot['qty2']), 2, ',', '.') . ' %' : '');
            $html .= '
          <div class="fl" style="width:' . $colWidth . '%">
            <div class="graph-value-stats">' . $tot['qty2'] . '</div>
            <div class="header-column-stats">' . (!empty($diff) ? $diff : '&nbsp;') . '</div>
            <div class="header-column-stats">' . (!empty($perc) ? $perc : '&nbsp;') . '</div>
            <div class="column-graph-stats grad-time2"
              style="height:' . ($max_qty > 0 ? 400 * ($tot['qty2'] / $max_qty) : 400) . 'px;
              margin-top:' . ($max_qty > 0 ? 400 - (400 * ($tot['qty2'] / $max_qty)) : 0) . 'px"></div>
            <div class="footer-column-stats">' . $period2 . '</div>
          </div>';
        }

        if ($period3 != '') {
            $qty3_diff = $tot['qty1'] - $tot['qty3'];
            $diff = ($qty3_diff > 0 ? '+' : '') . $qty3_diff;
            $perc = ($qty3_diff > 0 ? '+' : '') . ($tot['qty3'] > 0 ? number_format(floatval(($qty3_diff * 100) / $tot['qty3']), 2, ',', '.') . ' %' : '');
            $html .= '
          <div class="fl" style="width:' . $colWidth . '%">
            <div class="graph-value-stats">' . $tot['qty3'] . '</div>
            <div class="header-column-stats">' . (!empty($diff) ? $diff : '&nbsp;') . '</div>
            <div class="header-column-stats">' . (!empty($perc) ? $perc : '&nbsp;') . '</div>
            <div class="column-graph-stats grad-time2"
              style="height:' . ($max_qty > 0 ? 400 * ($tot['qty3'] / $max_qty) : 400) . 'px;
              margin-top:' . ($max_qty > 0 ? 400 - (400 * ($tot['qty3'] / $max_qty)) : 0) . 'px"></div>
            <div class="footer-column-stats">' . $period3 . '</div>
          </div>';
        }

        $html .= '
        </div>
      </div>';

        // Column value
        $html .= '
      <div class="col-md-4 mb-30x">
        <div class="title-column-stats">' . $this->translate('statistics.graph.valperseason', array('currency' => '€')) . '</div>
        <div class="mt-10x">
          <div class="fl" style="width:' . $colWidth . '%">
            <div class="graph-value-stats">' . number_format(floatval($tot['val1'] / 1000), 2, ',', '.') . '</div>
            <div class="header-column-stats">&nbsp;</div>
            <div class="header-column-stats">&nbsp;</div>
            <div class="column-graph-stats grad-time1"
              style="height:' . ($max_val > 0 ? 400 * ($tot['val1'] / (1000 * $max_val)) : 400) . 'px;
              margin-top:' . ($max_val > 0 ? 400 - (400 * ($tot['val1'] / (1000 * $max_val))) : 0) . 'px"></div>
            <div class="footer-column-stats">' . $period1 . '</div>
          </div>';

        if ($period2 != '') {
            $val2_diff = ($tot['val1'] - $tot['val2']) / 1000;
            $diff = ($val2_diff > 0 ? '+' : '') . number_format(floatval($val2_diff), 2, ',', '.');
            $perc = ($val2_diff > 0 ? '+' : '') . ($tot['val2'] > 0 ? number_format(floatval(($val2_diff * 100) / ($tot['val2'] / 1000)), 2, ',', '.') . ' %' : '');
            $html .= '
          <div class="fl" style="width:' . $colWidth . '%">
            <div class="graph-value-stats">' . number_format(floatval($tot['val2'] / 1000), 2, ',', '.') . '</div>
            <div class="header-column-stats">' . (!empty($diff) ? $diff : '&nbsp;') . '</div>
            <div class="header-column-stats">' . (!empty($perc) ? $perc : '&nbsp;') . '</div>
            <div class="column-graph-stats grad-time2"
              style="height:' . ($max_val > 0 ? 400 * ($tot['val2'] / (1000 * $max_val)) : 400) . 'px;
              margin-top:' . ($max_val > 0 ? 400 - (400 * ($tot['val2'] / (1000 * $max_val))) : 0) . 'px"></div>
            <div class="footer-column-stats">' . $period2 . '</div>
          </div>';
        }

        if ($period3 != '') {
            $val3_diff = $tot['val1'] - ($tot['val3'] / 1000);
            $diff = ($val3_diff > 0 ? '+' : '') . number_format(floatval($val3_diff), 2, ',', '.');
            $perc = ($val3_diff > 0 ? '+' : '') . ($tot['val3'] > 0 ? number_format(floatval(($val3_diff * 100) / ($tot['val3'] / 1000)), 2, ',', '.') . ' %' : '');
            $html .= '
          <div class="fl" style="width:' . $colWidth . '%">
            <div class="graph-value-stats">' . number_format(floatval($tot['val3'] / 1000), 2, ',', '.') . '</div>
            <div class="header-column-stats">' . (!empty($diff) ? $diff : '&nbsp;') . '</div>
            <div class="header-column-stats">' . (!empty($perc) ? $perc : '&nbsp;') . '</div>
            <div class="column-graph-stats grad-time2"
              style="height:' . ($max_val > 0 ? 400 * ($tot['val3'] / (1000 * $max_val)) : 400) . 'px;
              margin-top:' . ($max_val > 0 ? 400 - (400 * ($tot['val3'] / (1000 * $max_val))) : 0) . 'px"></div>
            <div class="footer-column-stats">' . $period3 . '</div>
          </div>';
        }

        $html .= '
        </div>
      </div>';

        // Column ratio
        $rat1 = $tot['qty1'] > 0 ? $tot['val1'] / $tot['qty1'] : 0;
        $html .= '
      <div class="col-md-4 mb-30x">
        <div class="title-column-stats">' . $this->translate('statistics.graph.avgartval', array('currency' => '€')) . '</div>
        <div class="mt-10x">
          <div class="fl" style="width:' . $colWidth . '%">
            <div class="graph-value-stats">' . number_format(floatval($rat1), 2, ',', '.') . '</div>
            <div class="header-column-stats">&nbsp;</div>
            <div class="header-column-stats">&nbsp;</div>
            <div class="column-graph-stats grad-time1"
              style="height:' . ($max_rat > 0 ? 400 * ($rat1 / $max_rat) : 400) . 'px;
              margin-top:' . ($max_rat > 0 ? 400 - (400 * ($rat1 / $max_rat)) : 0) . 'px"></div>
            <div class="footer-column-stats">' . $period1 . '</div>
          </div>';

        if ($period2 != '') {
            $rat2 = $tot['qty2'] > 0 ? $tot['val2'] / $tot['qty2'] : 0;
            $rat2_diff = $rat1 - $rat2;
            $diff = ($rat2_diff > 0 ? '+' : '') . number_format(floatval($rat2_diff), 2, ',', '.');
            $perc = ($rat2_diff > 0 ? '+' : '') . ($rat2 > 0 ? number_format(floatval(($rat2_diff * 100) / $rat2), 2, ',', '.') . ' %' : '');
            $html .= '
          <div class="fl" style="width:' . $colWidth . '%">
            <div class="graph-value-stats">' . number_format(floatval($rat2), 2, ',', '.') . '</div>
            <div class="header-column-stats">' . (!empty($diff) ? $diff : '&nbsp;') . '</div>
            <div class="header-column-stats">' . (!empty($perc) ? $perc : '&nbsp;') . '</div>
            <div class="column-graph-stats grad-time2"
              style="height:' . ($max_rat > 0 ? 400 * ($rat2 / $max_rat) : 400) . 'px;
              margin-top:' . ($max_rat > 0 ? 400 - (400 * ($rat2 / $max_rat)) : 0) . 'px"></div>
            <div class="footer-column-stats">' . $period2 . '</div>
          </div>';
        }

        if ($period3 != '') {
            $rat3 = $tot['qty3'] > 0 ? $tot['val3'] / $tot['qty3'] : 0;
            $rat3_diff = $rat1 - $rat3;
            $diff = ($rat3_diff > 0 ? '+' : '') . number_format(floatval($rat3_diff), 2, ',', '.');
            $perc = ($rat3_diff > 0 ? '+' : '') . ($rat3 > 0 ? number_format(floatval(($rat3_diff * 100) / $rat3), 2, ',', '.') . ' %' : '');
            $html .= '
          <div class="fl" style="width:' . $colWidth . '%">
            <div class="graph-value-stats">' . number_format(floatval($rat3), 2, ',', '.') . '</div>
            <div class="header-column-stats">' . (!empty($diff) ? $diff : '&nbsp;') . '</div>
            <div class="header-column-stats">' . (!empty($perc) ? $perc : '&nbsp;') . '</div>
            <div class="column-graph-stats grad-time2"
              style="height:' . ($max_rat > 0 ? 400 * ($rat3 / $max_rat) : 400) . 'px;
              margin-top:' . ($max_rat > 0 ? 400 - (400 * ($rat3 / $max_rat)) : 0) . 'px"></div>
            <div class="footer-column-stats">' . $period3 . '</div>
          </div>';
        }

        $html .= '
        </div>
      </div>';
        $html .= '
    </div>
    <div class="row" style="border-top:1px black solid;margin-top:-57px"></div>';

        return $html;
    }

    private function getHtmlTabDetail($stats, $type, $tot, $period1, $period2, $period3)
    {
        // header info
        $html = '
    <div class="row mt-40x">
      <div class="col-md-12"><a id="pdf-stats" href="#" class="btn btn-default">' . $this->translate('_common.export') . '</a></div>
    </div>
    <div class="px-20x bold" style="line-height:50px;background-color:#eee;height:50px;overflow:hidden;white-space:nowrap">
      <div class="w-20 fl">' . $this->translate('_common.totrows') . ': ' . count($stats) . '</div>
      <div class="w-50 fl">
        <a href="#" style="color:#606060" class="capitalize" data-toggle="modal" data-target=".modal-info">' .
            $this->translate('statistics.info') . '<i class="fa fa-info-circle pl-10x" aria-hidden="true"></i>
        </a>
      </div>';

        if ($period2 == '' && $period3 == '') {
            $html .= '
      <div class="w-10 fl right">' . $tot['qty1'] . '</div>
      <div class="w-20 fl right">' . number_format(floatval($tot['val1']), 2, ',', '.') . ' €</div>';
        } else if ($period2 != '' && $period3 != '') {
            $qty2_diff = $tot['qty1'] - $tot['qty2'];
            $val2_diff = $tot['val1'] - $tot['val2'];
            $qty3_diff = $tot['qty1'] - $tot['qty3'];
            $val3_diff = $tot['val1'] - $tot['val3'];

            $html .= '
      <div class="w-3 fl right pr-10x" style="border-left:1px solid #bbb">
        <div style="line-height:20px;height:20px">' . $tot['qty1'] . '</div>
        <div class="stats-diff"></div>
        <div class="stats-diff"></div>
      </div>
      <div class="w-3 fl right pr-10x">
        <div style="line-height:20px;height:20px;color:' . ($qty2_diff > 0 ? '#00A8CC' : '#8C0000') . '">' . $tot['qty2'] . '</div>
        <div class="stats-diff">' . ($qty2_diff > 0 ? '+' : '') . $qty2_diff . '</div>
        <div class="stats-diff">' .
                ($qty2_diff > 0 ? '+' : '') . ($tot['qty2'] > 0 ? number_format(floatval((($qty2_diff * 100) / $tot['qty2'])), 2, ',', '.') . ' %' : '') .
                '</div>
      </div>
      <div class="w-3 fl right pr-10x">
        <div style="line-height:20px;height:20px;color:' . ($qty2_diff > 0 ? '#00A8CC' : '#8C0000') . '">' . $tot['qty3'] . '</div>
        <div class="stats-diff">' . ($qty3_diff > 0 ? '+' : '') . $qty3_diff . '</div>
        <div class="stats-diff">' .
                ($qty3_diff > 0 ? '+' : '') . ($tot['qty3'] > 0 ? number_format(floatval((($qty3_diff * 100) / $tot['qty3'])), 2, ',', '.') . ' %' : '') .
                '</div>
      </div>
      <div class="w-6 fl right pr-10x" style="border-left:1px solid #bbb">
        <div style="line-height:20px;height:20px">' . number_format(floatval($tot['val1']), 2, ',', '.') . '</div>
        <div class="stats-diff"></div>
        <div class="stats-diff"></div>
      </div>
      <div class="w-6 fl right pr-10x">
        <div style="line-height:20px;height:20px;color:' . ($val2_diff > 0 ? '#00A8CC' : '#8C0000') . '">' .
                number_format(floatval($tot['val2']), 2, ',', '.') .
                '</div>
        <div class="stats-diff">' . ($val2_diff > 0 ? '+' : '') . number_format(floatval($val2_diff), 2, ',', '.') . '</div>
        <div class="stats-diff">' .
                ($val2_diff > 0 ? '+' : '') . ($tot['val2'] > 0 ? number_format(floatval(($val2_diff * 100) / $tot['val2']), 2, ',', '.') . ' %' : '') .
                '</div>
      </div>
      <div class="w-6 fl right pr-10x">
        <div style="line-height:20px;height:20px;color:' . ($val3_diff > 0 ? '#00A8CC' : '#8C0000') . '">' .
                number_format(floatval($tot['val3']), 2, ',', '.') .
                '</div>
        <div class="stats-diff">' . ($val3_diff > 0 ? '+' : '') . number_format(floatval($val3_diff), 2, ',', '.') . '</div>
        <div class="stats-diff">' .
                ($val3_diff > 0 ? '+' : '') . ($tot['val3'] > 0 ? number_format(floatval(($val3_diff * 100) / $tot['val3']), 2, ',', '.') . ' %' : '') .
                '</div>
      </div>';
        } else {
            $qty2_diff = $period2 != '' ? $tot['qty1'] - $tot['qty2'] : $tot['qty1'] - $tot['qty3'];
            $val2_diff = $period2 != '' ? $tot['val1'] - $tot['val2'] : $tot['val1'] - $tot['val3'];

            $html .= '
      <div class="w-5 fl right pr-10x" style="border-left:1px solid #bbb">
        <div style="line-height:20px;height:20px">' . $tot['qty1'] . '</div>
        <div class="stats-diff"></div>
        <div class="stats-diff"></div>
      </div>
      <div class="w-5 fl right pr-10x">
        <div style="line-height:20px;height:20px;color:' . ($qty2_diff > 0 ? '#00A8CC' : '#8C0000') . '">' . $tot['qty2'] . '</div>
        <div class="stats-diff">' . ($qty2_diff > 0 ? '+' : '') . $qty2_diff . '</div>
        <div class="stats-diff">' .
                ($qty2_diff > 0 ? '+' : '') . ($tot['qty2'] > 0 ? number_format(floatval((($qty2_diff * 100) / $tot['qty2'])), 2, ',', '.') . ' %' : '') .
                '</div>
      </div>
      <div class="w-10 fl right pr-10x" style="border-left:1px solid #bbb">
        <div style="line-height:20px;height:20px">' . number_format(floatval($tot['val1']), 2, ',', '.') . '</div>
        <div class="stats-diff"></div>
        <div class="stats-diff"></div>
      </div>
      <div class="w-10 fl right pr-10x">
        <div style="line-height:20px;height:20px;color:' . ($val2_diff > 0 ? '#00A8CC' : '#8C0000') . '">' .
                number_format(floatval($tot['val2']), 2, ',', '.') .
                '</div>
        <div class="stats-diff">' . ($val2_diff > 0 ? '+' : '') . number_format(floatval($val2_diff), 2, ',', '.') . '</div>
        <div class="stats-diff">' .
                ($val2_diff > 0 ? '+' : '') . ($tot['val2'] > 0 ? number_format(floatval(($val2_diff * 100) / $tot['val2']), 2, ',', '.') . ' %' : '') .
                '</div>
      </div>';
        }
        $html .= '
    </div>';

        // header columns
        $height = $period2 != '' || $period3 != '' ? 50 : 20;
        $html .= '<div class="px-20x bold capitalize" style="background-color:#bbb;color:white;height:' . $height . 'px;line-height:' . $height . 'px">';

        $col1Sorter = '<span style="cursor:pointer" class="sortable" data-type="col1" data-verse="up"><i class="fa fa-caret-up pl-10x" aria-hidden="true"></i></span>
                   <span style="cursor:pointer" class="sortable" data-type="col1" data-verse="down"><i class="fa fa-caret-down pl-10x" aria-hidden="true"></i></span>';

        $col2Sorter = '<span style="cursor:pointer" class="sortable" data-type="col2" data-verse="up"><i class="fa fa-caret-up pl-10x" aria-hidden="true"></i></span>
                   <span style="cursor:pointer" class="sortable" data-type="col2" data-verse="down"><i class="fa fa-caret-down pl-10x" aria-hidden="true"></i></span>';

        $col3Sorter = '<span style="cursor:pointer" class="sortable" data-type="col3" data-verse="up"><i class="fa fa-caret-up pl-10x" aria-hidden="true"></i></span>
                   <span style="cursor:pointer" class="sortable" data-type="col3" data-verse="down"><i class="fa fa-caret-down pl-10x" aria-hidden="true"></i></span>';

        $col4Sorter = '<span style="cursor:pointer" class="sortable" data-type="col4" data-verse="up"><i class="fa fa-caret-up pl-10x" aria-hidden="true"></i></span>
                   <span style="cursor:pointer" class="sortable" data-type="col4" data-verse="down"><i class="fa fa-caret-down pl-10x" aria-hidden="true"></i></span>';

        $colQSorter = '<span style="cursor:pointer" class="sortable" data-type="colq" data-verse="up"><i class="fa fa-caret-up pl-10x" aria-hidden="true"></i></span>
                   <span style="cursor:pointer" class="sortable" data-type="colq" data-verse="down"><i class="fa fa-caret-down pl-10x" aria-hidden="true"></i></span>';

        $colVSorter = '<span style="cursor:pointer" class="sortable" data-type="colv" data-verse="up"><i class="fa fa-caret-up pl-10x" aria-hidden="true"></i></span>
                   <span style="cursor:pointer" class="sortable" data-type="colv" data-verse="down"><i class="fa fa-caret-down pl-10x" aria-hidden="true"></i></span>';

        switch ($type) {
            case 1:
                $html .= '<div class="w-70 fl">' . $this->translate('_common.modeltype') . ' ' . $col1Sorter . '</div>';
                break;
            case 2:
                $html .= '<div class="w-20 fl">' . $this->translate('_common.modeltype') . ' ' . $col1Sorter . '</div>';
                $html .= '<div class="w-20 fl">' . $this->translate('_common.brand') . ' ' . $col1Sorter . '</div>';
                $html .= '<div class="w-30 fl">' . $this->translate('_common.line') . ' ' . $col3Sorter . '</div>';
                break;
            case 3:
                $html .= '<div class="w-20 fl">' . $this->translate('_common.brand') . ' ' . $col1Sorter . '</div>';
                $html .= '<div class="w-50 fl">' . $this->translate('_common.line') . ' ' . $col2Sorter . '</div>';
                break;
            case 4:
                $html .= '<div class="w-20 fl">' . $this->translate('_common.brand') . ' ' . $col1Sorter . '</div>';
                $html .= '<div class="w-20 fl">' . $this->translate('_common.line') . ' ' . $col2Sorter . '</div>';
                $html .= '<div class="w-30 fl">' . $this->translate('_common.series') . ' ' . $col3Sorter . '</div>';
                break;
            case 5:
                $html .= '<div class="w-20 fl">' . $this->translate('_common.brand') . ' ' . $col1Sorter . '</div>';
                $html .= '<div class="w-20 fl">' . $this->translate('_common.line') . ' ' . $col2Sorter . '</div>';
                $html .= '<div class="w-30 fl">' . $this->translate('_common.model') . ' ' . $col3Sorter . '</div>';
                break;
            case 6:
                $html .= '<div class="w-20 fl">' . $this->translate('_common.brand') . ' ' . $col1Sorter . '</div>';
                $html .= '<div class="w-20 fl">' . $this->translate('_common.line') . ' ' . $col2Sorter . '</div>';
                $html .= '<div class="w-30 fl">' . $this->translate('_common.article') . ' ' . $col3Sorter . '</div>';
                break;
            case 7:
                $html .= '<div class="w-20 fl">' . $this->translate('_common.brand') . ' ' . $col1Sorter . '</div>';
                $html .= '<div class="w-20 fl">' . $this->translate('_common.line') . ' ' . $col2Sorter . '</div>';
                $html .= '<div class="w-30 fl">' . $this->translate('_common.modeltype') . ' ' . $col3Sorter . '</div>';
                break;
            case 8:
                $html .= '<div class="w-70 fl">' . $this->translate('_common.customer') . ' ' . $col1Sorter . '</div>';
                break;
            case 9:
                $html .= '<div class="w-45 fl">' . $this->translate('_common.customer') . ' ' . $col1Sorter . '</div>';
                $html .= '<div class="w-25 fl">' . $this->translate('_common.modeltype') . ' ' . $col2Sorter . '</div>';
                break;
            case 10:
                $html .= '<div class="w-25 fl">' . $this->translate('_common.customer') . ' ' . $col1Sorter . '</div>';
                $html .= '<div class="w-20 fl">' . $this->translate('_common.brand') . ' ' . $col2Sorter . '</div>';
                $html .= '<div class="w-25 fl">' . $this->translate('_common.line') . ' ' . $col3Sorter . '</div>';
                break;
            case 11:
                $html .= '<div class="w-25 fl">' . $this->translate('_common.customer') . ' ' . $col1Sorter . '</div>';
                $html .= '<div class="w-15 fl">' . $this->translate('_common.brand') . ' ' . $col2Sorter . '</div>';
                $html .= '<div class="w-15 fl">' . $this->translate('_common.line') . ' ' . $col3Sorter . '</div>';
                $html .= '<div class="w-15 fl">' . $this->translate('_common.model') . ' ' . $col4Sorter . '</div>';
                break;
            case 12:
                $html .= '<div class="w-25 fl">' . $this->translate('_common.customer') . ' ' . $col1Sorter . '</div>';
                $html .= '<div class="w-15 fl">' . $this->translate('_common.brand') . ' ' . $col2Sorter . '</div>';
                $html .= '<div class="w-15 fl">' . $this->translate('_common.line') . ' ' . $col3Sorter . '</div>';
                $html .= '<div class="w-15 fl">' . $this->translate('_common.article') . ' ' . $col4Sorter . '</div>';
                break;
            case 13:
                $html .= '<div class="w-30 fl">' . $this->translate('_common.agent') . ' ' . $col1Sorter . '</div>';
                $html .= '<div class="w-40 fl">' . $this->translate('_common.customer') . ' ' . $col2Sorter . '</div>';
                break;
            case 14:
                $html .= '<div class="w-20 fl">' . $this->translate('_common.agent') . ' ' . $col1Sorter . '</div>';
                $html .= '<div class="w-30 fl">' . $this->translate('_common.customer') . ' ' . $col2Sorter . '</div>';
                $html .= '<div class="w-20 fl">' . $this->translate('_common.modeltype') . ' ' . $col3Sorter . '</div>';
                break;
            case 15:
                $html .= '<div class="w-18 fl">' . $this->translate('_common.agent') . ' ' . $col1Sorter . '</div>';
                $html .= '<div class="w-22 fl">' . $this->translate('_common.customer') . ' ' . $col2Sorter . '</div>';
                $html .= '<div class="w-15 fl">' . $this->translate('_common.brand') . ' ' . $col3Sorter . '</div>';
                $html .= '<div class="w-15 fl">' . $this->translate('_common.line') . ' ' . $col4Sorter . '</div>';
                break;
            case 16:
                $html .= '<div class="w-25 fl">' . $this->translate('_common.agent') . ' ' . $col1Sorter . '</div>';
                $html .= '<div class="w-45 fl">' . $this->translate('_common.modeltype') . ' ' . $col2Sorter . '</div>';
                break;
            case 17:
                $html .= '<div class="w-15 fl">' . $this->translate('_common.agent') . ' ' . $col1Sorter . '</div>';
                $html .= '<div class="w-15 fl">' . $this->translate('_common.brand') . ' ' . $col2Sorter . '</div>';
                $html .= '<div class="w-40 fl">' . $this->translate('_common.line') . ' ' . $col3Sorter . '</div>';
                break;
        }

        if ($period2 == '' && $period3 == '') {
            $html .= '<div class="w-10 fl right">' . $this->translate('_common.quantity') . ' ' . $colQSorter . '</div>';
            $html .= '<div class="w-20 fl right">' . $this->translate('_common.amount.net') . ' (€) ' . $colVSorter . '</div>';
        } else if ($period2 != '' && $period3 != '') {
            $html .= '<div class="w-10 fl center pr-10x" style="border-left:1px solid #eee">';
            $html .= '<div class="w-100" style="line-height:25px;height:25px">' . $this->translate('_common.quantity') . ' ' . $colQSorter . '</div>';
            $html .= '<div class="stats-time w-33 pr-5x" title="' . $period1 . '">' . $this->translate('_common.period') . ' 1</div>';
            $html .= '<div class="stats-time w-33 pr-5x" title="' . $period2 . '">' . $this->translate('_common.period') . ' 2</div>';
            $html .= '<div class="stats-time w-33" title="' . $period3 . '">' . $this->translate('_common.period') . '3</div>';
            $html .= '</div>';
            $html .= '<div class="w-20 fl center pr-10x" style="border-left:1px solid #eee">';
            $html .= '<div class="w-100" style="line-height:25px;height:25px">' . $this->translate('_common.amount.net') . ' (€) ' . $colVSorter . '</div>';
            $html .= '<div class="stats-time w-33 pr-5x" title="' . $period1 . '">' . $this->translate('_common.period') . ' 1</div>';
            $html .= '<div class="stats-time w-33 pr-5x" title="' . $period2 . '">' . $this->translate('_common.period') . ' 2</div>';
            $html .= '<div class="stats-time w-33" title="' . $period3 . '">' . $this->translate('_common.period') . ' 3</div>';
            $html .= '</div>';
        } else {
            $html .= '<div class="w-10 fl center pr-10x" style="border-left:1px solid #eee">';
            $html .= '<div class="w-100" style="line-height:25px;height:25px">' . $this->translate('_common.quantity') . ' ' . $colQSorter . '</div>';
            $html .= '<div class="stats-time w-50 pr-5x" title="' . $period1 . '">' . $this->translate('_common.period') . ' 1</div>';
            $html .= '<div class="stats-time w-50" title="' . ($period2 != '' ? $period2 : $period3) . '">' . $this->translate('_common.period') . ' 2</div>';
            $html .= '</div>';
            $html .= '<div class="w-20 fl center pr-10x" style="border-left:1px solid #eee">';
            $html .= '<div class="w-100" style="line-height:25px;height:25px">' . $this->translate('_common.amount.net') . ' (€) ' . $colVSorter . '</div>';
            $html .= '<div class="stats-time w-50 pr-5x" title="' . $period1 . '">' . $this->translate('_common.period') . ' 1</div>';
            $html .= '<div class="stats-time w-50" title="' . ($period2 != '' ? $period2 : $period3) . '">' . $this->translate('_common.period') . ' 2</div>';
            $html .= '</div>';
        }
        $html .= "</div>";

        // rows
        $html .= '<div id="stat-rows" data-ordering="default" data-direction="default" style="overflow:hidden;white-space:nowrap">';
        foreach ($stats as $stat) {
            $height = $period2 != '' || $period3 != '' ? 50 : 20;
            $html .= '<div class="stat-row px-20x bold capitalize" style="border-bottom:1px #bbb solid;font-size:11px;height:' . $height . 'px;line-height:' . $height . 'px">';

            switch ($type) {
                case 1:
                    $html .= '<div class="w-70 fl col1">' . $stat['col1'] . '</div>';
                    break;
                case 2:
                    $html .= '<div class="w-20 fl col1">' . $stat['col1'] . '</div>';
                    $html .= '<div class="w-20 fl col2">' . $stat['col2'] . '</div>';
                    $html .= '<div class="w-30 fl col3">' . $stat['col3'] . '</div>';
                    break;
                case 3:
                    $html .= '<div class="w-20 fl col1">' . $stat['col1'] . '</div>';
                    $html .= '<div class="w-50 fl col2">' . $stat['col2'] . '</div>';
                    break;
                case 4:
                    $html .= '<div class="w-20 fl col1">' . $stat['col1'] . '</div>';
                    $html .= '<div class="w-20 fl col2">' . $stat['col2'] . '</div>';
                    $html .= '<div class="w-30 fl col3">' . $stat['col3'] . '</div>';
                    break;
                case 5:
                    $html .= '<div class="w-20 fl col1">' . $stat['col1'] . '</div>';
                    $html .= '<div class="w-20 fl col2">' . $stat['col2'] . '</div>';
                    $html .= '<div class="w-30 fl col3">' . $stat['col3'] . '</div>';
                    break;
                case 6:
                    $html .= '<div class="w-20 fl col1">' . $stat['col1'] . '</div>';
                    $html .= '<div class="w-20 fl col2">' . $stat['col2'] . '</div>';
                    $html .= '<div class="w-30 fl col3">' . $stat['col3'] . '</div>';
                    break;
                case 7:
                    $html .= '<div class="w-20 fl col1">' . $stat['col1'] . '</div>';
                    $html .= '<div class="w-20 fl col2">' . $stat['col2'] . '</div>';
                    $html .= '<div class="w-30 fl col3">' . $stat['col3'] . '</div>';
                    break;
                case 8:
                    $html .= '<div class="w-70 fl col1">' . $stat['col1'] . '</div>';
                    break;
                case 9:
                    $html .= '<div class="w-45 fl col1">' . $stat['col1'] . '</div>';
                    $html .= '<div class="w-25 fl col2">' . $stat['col2'] . '</div>';
                    break;
                case 10:
                    $html .= '<div class="w-25 fl col1">' . $stat['col1'] . '</div>';
                    $html .= '<div class="w-20 fl col2">' . $stat['col2'] . '</div>';
                    $html .= '<div class="w-25 fl col3">' . $stat['col3'] . '</div>';
                    break;
                case 11:
                    $html .= '<div class="w-25 fl col1">' . $stat['col1'] . '</div>';
                    $html .= '<div class="w-15 fl col2">' . $stat['col2'] . '</div>';
                    $html .= '<div class="w-15 fl col3">' . $stat['col3'] . '</div>';
                    $html .= '<div class="w-15 fl col4">' . $stat['col4'] . '</div>';
                    break;
                case 12:
                    $html .= '<div class="w-25 fl col1">' . $stat['col1'] . '</div>';
                    $html .= '<div class="w-15 fl col2">' . $stat['col2'] . '</div>';
                    $html .= '<div class="w-15 fl col3">' . $stat['col3'] . '</div>';
                    $html .= '<div class="w-15 fl col4">' . $stat['col4'] . '</div>';
                    break;
                case 13:
                    $html .= '<div class="w-30 fl col1">' . $stat['col1'] . '</div>';
                    $html .= '<div class="w-40 fl col2">' . $stat['col2'] . '</div>';
                    break;
                case 14:
                    $html .= '<div class="w-20 fl col1">' . $stat['col1'] . '</div>';
                    $html .= '<div class="w-30 fl col2">' . $stat['col2'] . '</div>';
                    $html .= '<div class="w-20 fl col3">' . $stat['col3'] . '</div>';
                    break;
                case 15:
                    $html .= '<div class="w-18 fl col1">' . $stat['col1'] . '</div>';
                    $html .= '<div class="w-22 fl col2">' . $stat['col2'] . '</div>';
                    $html .= '<div class="w-15 fl col3">' . $stat['col3'] . '</div>';
                    $html .= '<div class="w-15 fl col4">' . $stat['col4'] . '</div>';
                    break;
                case 16:
                    $html .= '<div class="w-25 fl col1">' . $stat['col1'] . '</div>';
                    $html .= '<div class="w-45 fl col2">' . $stat['col2'] . '</div>';
                    break;
                case 17:
                    $html .= '<div class="w-15 fl col1">' . $stat['col1'] . '</div>';
                    $html .= '<div class="w-15 fl col2">' . $stat['col2'] . '</div>';
                    $html .= '<div class="w-40 fl col3">' . $stat['col3'] . '</div>';
                    break;
            }

            if ($period2 == '' && $period3 == '') {
                $html .= '<div class="w-10 fl colq stats-field right">' . $stat['qty1'] . '</div>';
                $html .= '<div class="w-20 fl colv stats-field right">' . number_format(floatval($stat['val1']), 2, ',', '.') . '</div>';
            } else if ($period2 != '' && $period3 != '') {
                $row_qty_diff2 = $stat['qty1'] - $stat['qty2'];
                $row_qty_diff3 = $stat['qty1'] - $stat['qty3'];
                $row_val_diff2 = $stat['val1'] - $stat['val2'];
                $row_val_diff3 = $stat['val1'] - $stat['val3'];
                if ($row_qty_diff2 > 0) {
                    $colorQty2 = '#00A8CC';
                } else if ($row_qty_diff2 < 0) {
                    $colorQty2 = '#8C0000';
                } else {
                    $colorQty2 = '#606060';
                }
                $qty2 = '';
                if ($stat['qty2'] > 0 && $stat['qty1'] != 0) {
                    $qty2 .= $row_qty_diff2 > 0 ? '+' : '';
                    $qty2 .= number_format(floatval((($row_qty_diff2 * 100) / $stat["qty2"])), 2, ',', '.') . '%';
                }
                if ($row_qty_diff3 > 0) {
                    $colorQty3 = '#00A8CC';
                } else if ($row_qty_diff3 < 0) {
                    $colorQty3 = '#8C0000';
                } else {
                    $colorQty3 = '#606060';
                }
                $qty3 = '';
                if ($stat['qty3'] > 0 && $stat['qty1'] != 0) {
                    $qty3 .= $row_qty_diff3 > 0 ? '+' : '';
                    $qty3 .= number_format(floatval((($row_qty_diff3 * 100) / $stat["qty3"])), 2, ',', '.') . '%';
                }
                if ($row_val_diff2 > 0) {
                    $colorVal2 = '#00A8CC';
                } else if ($row_val_diff2 < 0) {
                    $colorVal2 = '#8C0000';
                } else {
                    $colorVal2 = '#606060';
                }
                $val2 = '';
                if ($stat['val2'] > 0 && $stat['val1'] != 0) {
                    $val2 .= $row_val_diff2 > 0 ? '+' : '';
                    $val2 .= number_format(floatval((($row_val_diff2 * 100) / $stat["val2"])), 2, ',', '.') . '%';
                }
                if ($row_val_diff3 > 0) {
                    $colorVal3 = '#00A8CC';
                } else if ($row_val_diff3 < 0) {
                    $colorVal3 = '#8C0000';
                } else {
                    $colorVal3 = '#606060';
                }
                $val3 = '';
                if ($stat['val3'] > 0 && $stat['val1'] != 0) {
                    $val3 .= $row_val_diff3 > 0 ? '+' : '';
                    $val3 .= number_format(floatval((($row_val_diff3 * 100) / $stat["val3"])), 2, ',', '.') . '%';
                }
                $html .= '<div class="w-3 fl right pr-10x" style="border-left:1px solid #bbb">';
                $html .= '<div class="stats-val colq1 stats-field">' . $stat["qty1"] . '</div>';
                $html .= '<div class="stats-diff"></div>';
                $html .= '<div class="stats-diff"></div>';
                $html .= '</div>';
                $html .= '<div class="w-3 fl right pr-10x">';
                $html .= '<div class="stats-val colq2" style="color:' . $colorQty2 . '">' . $stat["qty2"] . '</div>';
                $html .= '<div class="stats-diff">' . ($row_qty_diff2 > 0 ? '+' : '') . $row_qty_diff2 . '</div>';
                $html .= '<div class="stats-diff">' . $qty2 . '</div>';
                $html .= '</div>';
                $html .= '<div class="w-3 fl right pr-10x">';
                $html .= '<div class="stats-val colq3" style="color:' . $colorQty3 . '">' . $stat["qty3"] . '</div>';
                $html .= '<div class="stats-diff">' . ($row_qty_diff3 > 0 ? '+' : '') . $row_qty_diff3 . '</div>';
                $html .= '<div class="stats-diff">' . $qty3 . '</div>';
                $html .= '</div>';
                $html .= '<div class="w-6 fl right pr-10x" style="border-left:1px solid #bbb">';
                $html .= '<div class="stats-val colv1 stats-field">' . number_format(floatval($stat["val1"]), 2, ',', '.') . '</div>';
                $html .= '<div class="stats-diff"></div>';
                $html .= '<div class="stats-diff"></div>';
                $html .= '</div>';
                $html .= '<div class="w-6 fl right pr-10x">';
                $html .= '<div class="stats-val colv2" style="color:' . $colorVal2 . '">' . number_format(floatval($stat["val2"]), 2, ',', '.') . '</div>';
                $html .= '<div class="stats-diff">' . ($row_val_diff2 > 0 ? '+' : '') . number_format(floatval($row_val_diff2), 2, ',', '.') . '</div>';
                $html .= '<div class="stats-diff">' . $val2 . '</div>';
                $html .= '</div>';
                $html .= '<div class="w-6 fl right pr-10x">';
                $html .= '<div class="stats-val colv3" style="color:' . $colorVal3 . '">' . number_format(floatval($stat["val3"]), 2, ',', '.') . '</div>';
                $html .= '<div class="stats-diff">' . ($row_val_diff3 > 0 ? '+' : '') . number_format(floatval($row_val_diff3), 2, ',', '.') . '</div>';
                $html .= '<div class="stats-diff">' . $val3 . '</div>';
                $html .= '</div>';
            } else {
                $row_qty_diff = isset($stat['qty2']) ? $stat['qty1'] - $stat['qty2'] : $stat['qty1'] - $stat['qty3'];
                $row_val_diff = isset($stat['val2']) ? $stat['val1'] - $stat['val2'] : $stat['val1'] - $stat['val3'];
                if ($row_qty_diff > 0) {
                    $colorQty = '#00A8CC';
                } else if ($row_qty_diff < 0) {
                    $colorQty = '#8C0000';
                } else {
                    $colorQty = '#606060';
                }
                $qty = '';
                if ((isset($stat['qty2']) && $stat['qty2'] > 0 && $stat['qty1'] != 0) ||
                    (isset($stat['qty3']) && $stat['qty3'] > 0 && $stat['qty1'] != 0)
                ) {
                    $qty .= $row_qty_diff > 0 ? '+' : '';
                    $qty .= isset($stat['qty2'])
                        ? number_format(floatval((($row_qty_diff * 100) / $stat["qty2"])), 2, ',', '.') . '%'
                        : number_format(floatval((($row_qty_diff * 100) / $stat["qty3"])), 2, ',', '.') . '%';
                }
                if ($row_val_diff > 0) {
                    $colorVal = '#00A8CC';
                } else if ($row_val_diff < 0) {
                    $colorVal = '#8C0000';
                } else {
                    $colorVal = '#606060';
                }
                $val = '';
                if ((isset($stat['val2']) && $stat['val2'] > 0 && $stat['val1'] != 0) ||
                    (isset($stat['val3']) && $stat['val3'] > 0 && $stat['val1'] != 0)
                ) {
                    $val .= $row_val_diff > 0 ? '+' : '';
                    $val .= isset($stat['val2'])
                        ? number_format(floatval((($row_val_diff * 100) / $stat["val2"])), 2, ',', '.') . '%'
                        : number_format(floatval((($row_val_diff * 100) / $stat["val3"])), 2, ',', '.') . '%';
                }

                $html .= '<div class="w-5 fl right pr-10x" style="border-left:1px solid #bbb">';
                $html .= '<div class="stats-val colq1 stats-field">' . $stat["qty1"] . '</div>';
                $html .= '<div class="stats-diff"></div>';
                $html .= '<div class="stats-diff"></div>';
                $html .= '</div>';
                $html .= '<div class="w-5 fl right pr-10x">';
                $html .= '<div class="stats-val colq2" style="color:' . $colorQty . '">' . (isset($stat["qty2"]) ? $stat["qty2"] : $stat["qty3"]) . '</div>';
                $html .= '<div class="stats-diff">' . ($row_qty_diff > 0 ? '+' : '') . $row_qty_diff . '</div>';
                $html .= '<div class="stats-diff">' . $qty . '</div>';
                $html .= '</div>';
                $html .= '<div class="w-10 fl right pr-10x" style="border-left:1px solid #bbb">';
                $html .= '<div class="stats-val colv1 stats-field">' . number_format(floatval($stat["val1"]), 2, ',', '.') . '</div>';
                $html .= '<div class="stats-diff"></div>';
                $html .= '<div class="stats-diff"></div>';
                $html .= '</div>';
                $html .= '<div class="w-10 fl right pr-10x">';
                $html .= '<div class="stats-val colv2" style="color:' . $colorVal . '">' . number_format(floatval(isset($stat["val2"]) ? $stat["val2"] : $stat["val3"]), 2, ',', '.') . '</div>';
                $html .= '<div class="stats-diff">' . ($row_val_diff > 0 ? '+' : '') . number_format(floatval($row_val_diff), 2, ',', '.') . '</div>';
                $html .= '<div class="stats-diff">' . $val . '</div>';
                $html .= '</div>';
            }
            $html .= '</div>';
        }
        $html .= '</div>';
        return $html;
    }

    private function getHtmlModalInfo($type, $period1, $period2, $period3)
    {
        $html = '<div class="row pb-10x pl-20x pr-15x bold" style="color:#bbb" id="info-type">';
        switch ($type) {
            case 1:
                $html .= $this->translate('statistics.group.modtype');
                break;
            case 2:
                $html .= $this->translate('statistics.group.modtypebrandline');
                break;
            case 3:
                $html .= $this->translate('statistics.group.brandline');
                break;
            case 4:
                $html .= $this->translate('statistics.group.brandlineserie');
                break;
            case 5:
                $html .= $this->translate('statistics.group.brandlinemodel');
                break;
            case 6:
                $html .= $this->translate('statistics.group.brandlinearticle');
                break;
            case 7:
                $html .= $this->translate('statistics.group.brandlinemodtype');
                break;
            case 8:
                $html .= $this->translate('statistics.group.cust');
                break;
            case 9:
                $html .= $this->translate('statistics.group.custmodtype');
                break;
            case 10:
                $html .= $this->translate('statistics.group.custbrandline');
                break;
            case 11:
                $html .= $this->translate('statistics.group.custbrandlinemod');
                break;
            case 12:
                $html .= $this->translate('statistics.group.custbrandlineart');
                break;
            case 13:
                $html .= $this->translate('statistics.group.agecust');
                break;
            case 14:
                $html .= $this->translate('statistics.group.agecustmodtype');
                break;
            case 15:
                $html .= $this->translate('statistics.group.agecustbrandline');
                break;
            case 16:
                $html .= $this->translate('statistics.group.agemodtype');
                break;
            case 17:
                $html .= $this->translate('statistics.group.agebrandline');
                break;
        }
        $html .= '</div>';

        $agents = $this->session->get('anl-stat-age');
        $brands = $this->session->get('anl-stat-brn');
        $catalogs = $this->session->get('anl-stat-cat');
        $countries = $this->session->get('anl-stat-cou');
        $customers = $this->session->get('anl-stat-cus');
        $genres = $this->session->get('anl-stat-gen');
        $lines = $this->session->get('anl-stat-lin');
        $modeltypes = $this->session->get('anl-stat-mot');
        $ordertypes = $this->session->get('anl-stat-ort');
        $series = $this->session->get('anl-stat-ser');

        $html .= '<div class="row pb-10x pl-20x pr-15x bold"
      style="color:#bbb" id="info-time" data-period1="' . $period1 . '"
      data-period2="' . $period2 . '" data-period3="' . $period3 . '">';
        $html .= '<span class="capitalize">' . $this->translate('_common.period') . '</span>: ' .
            $period1 . ($period2 != '' ? ', ' . $period2 : '') . ($period3 != '' ? ', ' . $period3 : '');
        $html .= '</div>';
        $html .= '<div class="row pb-10x pl-20x pr-15x" id="info-filter">';

        $html .= $this->translate('_common.catalogs') . ': ';
        if ($catalogs == 'all') {
            $html .= $this->translate('_common.allp');
        } else {
            for ($i = 0; $i < count($catalogs); $i++) {
                $html .= $catalogs[$i] . ($i != count($catalogs) - 1 ? ', ' : '');
            }
        }

        $html .= ' - ' . $this->translate('_common.agents') . ': ';
        if ($agents == 'all') {
            $html .= $this->translate('_common.allp');
        } else {
            for ($i = 0; $i < count($agents); $i++) {
                $html .= $agents[$i] . ($i != count($agents) - 1 ? ', ' : '');
            }
        }

        $html .= ' - ' . $this->translate('_common.customers') . ': ';
        if ($customers == 'all') {
            $html .= $this->translate('_common.allp');
        } else {
            for ($i = 0; $i < count($customers); $i++) {
                $html .= $customers[$i]['cdanag'] . ($i != count($customers) - 1 ? ', ' : '');
            }
        }

        $html .= ' - ' . $this->translate('_common.countries') . ': ';
        if ($countries == 'all') {
            $html .= $this->translate('_common.allf');
        } else {
            for ($i = 0; $i < count($countries); $i++) {
                $html .= $countries[$i] . ($i != count($countries) - 1 ? ', ' : '');
            }
        }

        $html .= ' - ' . $this->translate('_common.brands') . ': ';
        if ($brands == 'all') {
            $html .= $this->translate('_common.allp');
        } else {
            for ($i = 0; $i < count($brands); $i++) {
                $html .= $brands[$i] . ($i != count($brands) - 1 ? ', ' : '');
            }
        }

        $html .= ' - ' . $this->translate('_common.lines') . ': ';
        if ($lines == 'all') {
            $html .= $this->translate('_common.allf');
        } else {
            for ($i = 0; $i < count($lines); $i++) {
                $html .= $lines[$i] . ($i != count($lines) - 1 ? ', ' : '');
            }
        }

        $html .= ' - ' . $this->translate('_common.series') . ': ';
        if ($series == 'all') {
            $html .= $this->translate('_common.allf');
        } else {
            for ($i = 0; $i < count($series); $i++) {
                $html .= $series[$i]['cdlinm'] . '/' . $series[$i]['cdserm'] . ($i != count($series) - 1 ? ', ' : '');
            }
        }

        $html .= ' - ' . $this->translate('_common.modeltypes') . ': ';
        if ($modeltypes == 'all') {
            $html .= $this->translate('_common.allp');
        } else {
            for ($i = 0; $i < count($modeltypes); $i++) {
                $html .= $modeltypes[$i] . ($i != count($modeltypes) - 1 ? ', ' : '');
            }
        }

        $html .= ' - ' . $this->translate('_common.ordertypes') . ': ';
        if ($ordertypes == 'all') {
            $html .= $this->translate('_common.allp');
        } else {
            for ($i = 0; $i < count($ordertypes); $i++) {
                $html .= $ordertypes[$i] . ($i != count($ordertypes) - 1 ? ', ' : '');
            }
        }

        $html .= ' - ' . $this->translate('_common.genres') . ': ';
        if ($genres == 'all') {
            $html .= $this->translate('_common.allp');
        } else {
            for ($i = 0; $i < count($genres); $i++) {
                $html .= $genres[$i] . ($i != count($genres) - 1 ? ', ' : '');
            }
        }

        $html .= '</div>';

        return $html;
    }
    //endregion

    //region Html functions
    private function getHtmlOptionsForHomePageWizard($type, $data)
    {
        $options = '';
        switch ($type) {
            case 'BR':
                foreach ($data as $item) {
                    $options .= '<option value="' . $item->cdtitl . '">' . $item->dstitl . '</option>';
                }
                break;
            case 'LI':
                foreach ($data as $item) {
                    $options .= '<option value="' . $item->cdlinm . '">' . $item->dstitl . ' > ' . $item->dslinm . '</option>';
                }
                break;
            case 'SE':
                foreach ($data as $item) {
                    $options .= '<option value="' . $item->cdlinm . '___' . $item->cdserm . '">' . $item->dstitl . ' > ' . $item->dslinm . ' > ' . $item->dsserm . '</option>';
                }
                break;
            case 'GE':
                foreach ($data as $item) {
                    $options .= '<option value="' . $item->tpgene . '">' . $item->dsgene . '</option>';
                }
                break;
            case 'TM':
                foreach ($data as $item) {
                    $options .= '<option value="' . $item->tpmode . '">' . $item->dstmod . '</option>';
                }
                break;
            case 'TG':
                foreach ($data as $item) {
                    $options .= '<option value="' . $item->valore . '">' . $item->valore . '</option>';
                }
                break;
            case 'DL':
                foreach ($data as $item) {
                    $options .= '<option value="' . $item['file'] . '">' . $item['file'] . '</option>';
                }
                break;
            case 'VD':
                foreach ($data as $item) {
                    if ($item['icon_class'] == 'fa-youtube-play') {
                        $options .= '<option value="' . $item['file'] . '">' . $item['file'] . '</option>';
                    }
                }
                break;
        }
        return $options;
    }

    private function getHtmlAdditionalOptionsForHomePageWizard($data)
    {
        $options = '';
        foreach ($data as $item) {
            $options .= '<option value="' . $item->codice . '">' . $item->codice . '</option>';
        }
        return $options;
    }

    private function getHomePageBodyContent($hpcorp)
    {
        $html = '';
        if (count($hpcorp) > 0) {
            $blocks = $this->utility->getBlocksArrayForHomepage($hpcorp);

            foreach ($blocks as $key => $block) {
                $html .= $this->getBlock($key, $block);
            }
        } else {
            $index = 1;
            $html .= $this->getBlock($index);
        }
        return $html;
    }

    private function getBlock($index, $block = null)
    {
        $tagIsPresent = Artcla::isTagAvailable();
        $additionalFilters = Tpcrar::getAdditionalFilters();

        $html =
            '<div class="homepage-block-container fl" data-index="' . $index . '" data-new="' . ($block != null ? '0' : '1') . '">
        <div class="x_title">
          <h2>' . $this->translate('admin.featured.block') . ' <span class="title-index">' . $index . '</span></h2>
          <div class="delete-block" data-toggle="modal" data-target=".modal-delete-block">
            <img src="../assets/img/times.png" class="m-0-auto pointer" alt="' . $this->translate('_common.close') . '"/>
          </div>
          <div class="clearfix"></div>
        </div>
        <div class="x_content">
          <div class="row">
            <div class="col-md-3 col-sm-3 col-xs-6">
              <select class="select2_single form-control block-select" tabindex="-1">
                <option value="0" ' . ($block != null && $block['size'] == 0 ? 'selected' : '') . '>1/1</option>
                <option value="1" ' . ($block == null || $block['size'] == 1 ? 'selected' : '') . '>1/2 + 1/2</option>
                <option value="2" ' . ($block != null && $block['size'] == 2 ? 'selected' : '') . '>1/3 + 1/3 + 1/3</option>
                <option value="3" ' . ($block != null && $block['size'] == 3 ? 'selected' : '') . '>1/3 + 2/3</option>
                <option value="4" ' . ($block != null && $block['size'] == 4 ? 'selected' : '') . '>2/3 + 1/3</option>
                <option value="5" ' . ($block != null && $block['size'] == 5 ? 'selected' : '') . '>1/4 + 1/4 + 1/4 + 1/4</option>
                <option value="6" ' . ($block != null && $block['size'] == 6 ? 'selected' : '') . '>1/4 + 3/4</option>
                <option value="7" ' . ($block != null && $block['size'] == 7 ? 'selected' : '') . '>3/4 + 1/4</option>
              </select>
            </div>
          </div>
          <div class="row mt-20x">';

        for ($i = 1; $i <= 4; $i++) {
            if ($block != null && isset($block['boxes'][$i])) {
                $des_it = $block['boxes'][$i]->des_it;
                $des_en = $block['boxes'][$i]->des_en;
                $des_es = $block['boxes'][$i]->des_es;
                $des_de = $block['boxes'][$i]->des_de;
                $des_fr = $block['boxes'][$i]->des_fr;
                $tpbloc = $block['boxes'][$i]->tpbloc;
            } else {
                $des_it = '';
                $des_en = '';
                $des_es = '';
                $des_de = '';
                $des_fr = '';
                $tpbloc = '';
            }
            $html .=
                '<div class="col-md-6 col-sm-6 col-xs-6 blockbox box-' . $i . '" ' . ($i >= 3 ? 'style="display:none"' : '') . ' data-index="' . $i . '"
          data-flimag="' . ($block != null && isset($block['boxes'][$i]) ? $block['boxes'][$i]->flimag : '') . '">
          <!-- Dropzone -->
          <div class="col-md-6 col-sm-6 col-xs-6 opacity">
            <div class="hp-img-title">' .
                $this->translate('admin.featured.img') . $this->getHomePageBodyImageTitle($i) .
                '</div>
            <div class="fake-dropzone" style="height:150px;width:156px;border:2px solid rgba(0,0,0,0.3);cursor:not-allowed;display:none"></div>
            <form action="' . $this->url->get('admin/uploadImage') . '" class="dropzone dropzone-box" style="width:156px"></form>
          </div>
          <!-- Descriptions -->
          <div class="col-md-6 col-sm-6 col-xs-6">
            <div class="col-md-12 col-sm-12 col-xs-12 opacity hp-img-title">' . $this->translate('admin.featured.descr.it') . '</div>
            <div class="col-md-12 col-sm-12 col-xs-12 opacity">
              <input type="text" class="descr-it form-control" maxlength="60" size="60" value="' . $des_it . '"/>
            </div>
            <div class="col-md-12 col-sm-12 col-xs-12 opacity hp-img-title mt-10x">' . $this->translate('admin.featured.descr.en') . '</div>
            <div class="col-md-12 col-sm-12 col-xs-12 opacity">
              <input type="text" class="descr-en form-control" maxlength="60" size="60" value="' . $des_en . '"/>
            </div>
            <div class="col-md-12 col-sm-12 col-xs-12 opacity hp-img-title mt-10x">' . $this->translate('admin.featured.descr.es') . '</div>
            <div class="col-md-12 col-sm-12 col-xs-12 opacity">
              <input type="text" class="descr-es form-control" maxlength="60" size="60" value="' . $des_es . '"/>
            </div>
            <div class="col-md-12 col-sm-12 col-xs-12 opacity hp-img-title mt-10x">' . $this->translate('admin.featured.descr.de') . '</div>
            <div class="col-md-12 col-sm-12 col-xs-12 opacity">
              <input type="text" class="descr-de form-control" maxlength="60" size="60" value="' . $des_de . '"/>
            </div>
            <div class="col-md-12 col-sm-12 col-xs-12 opacity hp-img-title mt-10x">' . $this->translate('admin.featured.descr.fr') . '</div>
            <div class="col-md-12 col-sm-12 col-xs-12 opacity">
              <input type="text" class="descr-fr form-control" maxlength="60" size="60" value="' . $des_fr . '"/>
            </div>
            <div class="col-md-12 col-sm-12 col-xs-12 hiddendiv mt-25x">
              <label class="checkbox-container">
                <input type="checkbox" class="form-control hiddenbox" ' .
                ($tpbloc == 'NO' ? 'checked' : '') . '/> ' . $this->translate('_common.hidden') .
                '<span class="checkbox-checkmark"></span>
              </label>
            </div>
          </div>
          <!-- Link elements -->
          <div class="col-md-12 col-sm-12 col-xs-12 opacity hp-img-title mt-20x">' . $this->translate('admin.featured.linkelement') . '</div>
          <div class="col-md-12 col-sm-12 col-xs-12 opacity">
            <select class="select2_single form-control element-select text-capitalize" tabindex="-1">
              <option value="NO" data-type="0" ' . ($tpbloc == 'NO' ? 'selected' : '') . '></option>
              <option value="BR" data-type="0" ' . ($tpbloc == 'BR' ? 'selected' : '') . '>' . $this->translate('_common.brand') . '</option>
              <option value="LI" data-type="0" ' . ($tpbloc == 'LI' ? 'selected' : '') . '>' . $this->translate('_common.line') . '</option>
              <option value="GE" data-type="0" ' . ($tpbloc == 'GE' ? 'selected' : '') . '>' . $this->translate('_common.genre') . '</option>
              <option value="SE" data-type="0" ' . ($tpbloc == 'SE' ? 'selected' : '') . '>' . $this->translate('_common.series') . '</option>
              <option value="TM" data-type="0" ' . ($tpbloc == 'TM' ? 'selected' : '') . '>' . $this->translate('_common.modeltype') . '</option>
              <option value="SL" data-type="0" ' . ($tpbloc == 'SL' ? 'selected' : '') . '>' . $this->translate('_common.onsale') . '</option>' .
                ($tagIsPresent ? '<option value="TG" data-type="0" ' . ($tpbloc == 'TG' ? 'selected' : '') . '>' . $this->translate('_common.tag') . '</option>' : '') .
                '<option value="DL" data-type="0" ' . ($tpbloc == 'DL' ? 'selected' : '') . '>' . $this->translate('_common.downloadtechnicalfile') . '</option>
              <option value="VD" data-type="0" ' . ($tpbloc == 'VD' ? 'selected' : '') . '>' . $this->translate('_common.video') . '</option>
              <option value="UR" data-type="0" ' . ($tpbloc == 'UR' ? 'selected' : '') . '>URL</option>';

            foreach ($additionalFilters as $filter) {
                $value = $filter->tpinpu . $filter->tpcrar;
                $html .= '<option value="' . $value . '" data-type="1" ' . ($tpbloc == $value ? 'selected' : '') . '>' . $filter->dscrar . '</option>';
            }

            $selectCode = '';
            $selectStyle = '';
            $inputCode = '';
            $inputStyle = '';
            if ($block != null && isset($block['boxes'][$i])) {
                if ($block['boxes'][$i]->tpbloc != 'UR') {
                    $selectCode = ' data-codice="' . $block['boxes'][$i]->codice . '" ';
                    $inputStyle = ' style="display:none" ';
                } else {
                    $selectStyle = ' style="display:none" ';
                    $inputCode = ' value="' . $block['boxes'][$i]->codice . '" ';
                }
            }

            $html .=
                '</select>
          </div>
          <!-- Code to select -->
          <div class="col-md-12 col-sm-12 col-xs-12 opacity mt-20x">
            <input type="text" class="url-input form-control" ' . $inputCode . $inputStyle . ' />
            <select class="select2_single form-control code-select" tabindex="-1" ' . $selectCode . $selectStyle . '>
            </select>
          </div>
        </div>';
        }

        $html .=
            '</div><!-- close .row.mt-20x -->
        </div><!-- close .x_content -->
      </div>';

        return $html;
    }

    private function getHomePageBodyImageTitle($index)
    {
        switch ($index) {
            case 1:
                return '
                    <span class="sizeimg sizeimg0">1980x800</span>
                    <span class="sizeimg sizeimg1">720x720</span>
                    <span class="sizeimg sizeimg2">500x500</span>
                    <span class="sizeimg sizeimg3">500x500</span>
                    <span class="sizeimg sizeimg4">1020x500</span>
                    <span class="sizeimg sizeimg5">400x400</span>
                    <span class="sizeimg sizeimg6">400x400</span>
                    <span class="sizeimg sizeimg7">1200x400</span>';
            case 2:
                return '
                    <span class="sizeimg sizeimg0"></span>
                    <span class="sizeimg sizeimg1">720x720</span>
                    <span class="sizeimg sizeimg2">500x500</span>
                    <span class="sizeimg sizeimg3">1020x500</span>
                    <span class="sizeimg sizeimg4">500x500</span>
                    <span class="sizeimg sizeimg5">400x400</span>
                    <span class="sizeimg sizeimg6">1200x400</span>
                    <span class="sizeimg sizeimg7">400x400</span>';
            case 3:
                return '
                    <span class="sizeimg sizeimg0"></span>
                    <span class="sizeimg sizeimg1"></span>
                    <span class="sizeimg sizeimg2">500x500</span>
                    <span class="sizeimg sizeimg3"></span>
                    <span class="sizeimg sizeimg4"></span>
                    <span class="sizeimg sizeimg5">400x400</span>
                    <span class="sizeimg sizeimg6"></span>
                    <span class="sizeimg sizeimg7"></span>';
            case 4:
                return '
                    <span class="sizeimg sizeimg0"></span>
                    <span class="sizeimg sizeimg1"></span>
                    <span class="sizeimg sizeimg2"></span>
                    <span class="sizeimg sizeimg3"></span>
                    <span class="sizeimg sizeimg4"></span>
                    <span class="sizeimg sizeimg5">400x400</span>
                    <span class="sizeimg sizeimg6"></span>
                    <span class="sizeimg sizeimg7"></span>';
        }
    }

    private function getHtmlFilteredOrdersContent($orders)
    {
        $html = '';

        if (count($orders) > 0) {
            foreach ($orders as $order) {
                $flstat = '';
                switch ($order->flstat) {
                    case 1:
                        $flstat = "<div class='bold'><span class='sts1'>&#9679; </span>" . $this->translate('account.order.provisional') . "</div>";
                        break;
                    case 2:
                        $flstat = "<div class='bold'><span class='sts2'>&#9679; </span>" .
                            ($this->utility->getAppSettings('OrderStateManagement')
                                ? $this->translate('account.order.processed')
                                : $this->translate('account.order.sent')) .
                            "</div>";
                        break;
                    case 3:
                        $flstat = "<div class='bold'><span class='sts3'>&#9679; </span>" . $this->translate('account.order.accepted') . "</div>";
                        break;
                    case 4:
                        $flstat = "<div class='bold'><span class='sts4'>&#9679; </span>" . $this->translate('account.order.rejected') . "</div>";
                        break;
                    case 5:
                        $flstat = "<div class='bold'><span class='sts5'>&#9679; </span>" . $this->translate('account.order.waitingquantity') . "</div>";
                        break;
                    case 5:
                        $flstat = "<div class='bold'><span class='sts6'>&#9679; </span>" . $this->translate('account.order.customerconfirmed') . "</div>";
                        break;
                }

                $html .=
                    '<tr>
            <td>' . $order->nuordc . '</td>
            <td>' . $order->descri . '</td>
            <td>' . $order->dsagen . '</td>
            <td>' . $order->dtcrea . '</td>
            <td>' . $order->dtmcli . '</td>
            <td>' . $order->dscata . '</td>
            <td>' . $order->quanti . '</td>
            <td>' . $order->valore . '</td>
            <td>' . $flstat . '</td>
            <td></td>
          </tr>';
            }
        }

        return $html;
    }

    private function getModalContentForChangeVariants($cdvari, $variants)
    {
        $html = '';

        $selectedVariants = str_split($cdvari);

        $options = array();
        foreach ($variants as $variant) {
            if (!isset($options[$variant['tpvari']])) {
                $options[$variant['tpvari']] = array(
                    'dstvar' => $variant['dstvar'],
                    'html' => '<option value="-1" data-prezzo="0"></option>',
                );
            }
            $options[$variant['tpvari']]['html'] .=
                '<option value="' . $variant['cdvari'] . '" ' . (in_array($variant['cdvari'], $selectedVariants) ? 'selected' : '') . '
          data-prezzo="' . $variant['prezzo'] . '">' .
                $variant['cdvari'] . ' - ' . $variant['dsvari'] .
                '</option>';
        }

        if (count($options) > 0) {
            foreach ($options as $key => $value) {
                $html .=
                    '<div class="row pb-10x" style="line-height:34px">
            <div class="col-md-3 bold">' . $value['dstvar'] . '</div>
            <div class="col-md-9">
              <select class="form-control cdvari-selector" data-cdvari="' . $key . '">' .
                    $value['html'] .
                    '</select>
            </div>
          </div>';
            }
        }

        return $html;
    }

    private function getHtmlContentForMultipleEdit($postgl)
    {
        $html = '';

        if (count($postgl) > 0) {
            $width = 100 / count($postgl);

            foreach ($postgl as $tgl) {
                $html .=
                    '<div style="float:left;width:' . $width . '%;padding-left:2px;padding-right:2px">
            <div class="bold">' . $tgl->taglia . '</div>
            <div class="multiple-quanti"><input type="number" class="w-100" data-dstagl="' . $tgl->taglia . '" value="" min="0" step="1"/></div>
          </div>';
            }
        }

        return $html;
    }

    private function getHtmlDiscount($type, $cttest_keys, $params)
    {
        $html = '';
        switch ($type) {
            case 'titlin':
                $array = Titlin::getBrandsWithDiscountFromCatalogs($cttest_keys, $params);
                foreach ($array as $el) {
                    $html .=
                        '<tr>
               <td class="disc-col-cod">' . $el->cdtitl . '</td>
               <td class="disc-col-3">' . $el->dstitl . '</td>
               <td class="disc-col-rul"><input type="number" class="disc-input" min="0" max="100" step="0.1"
                 data-type="titlin" data-cdtitl="' . $el->cdtitl . '" value="' . ($el->sconto > 0 ? $el->sconto : '') . '"/>&nbsp;%</td>
             </tr>';
                }
                break;
            case 'linmod':
                $array = Linmod::getLinesWithDiscountFromCatalogs($cttest_keys, $params);
                foreach ($array as $el) {
                    $html .=
                        '<tr>
               <td class="disc-col-cod">' . $el->cdlinm . '</td>
               <td class="disc-col-3">' . $el->dslinm . '</td>
               <td class="disc-col-rul"><input type="number" class="disc-input" min="0" max="100" step="0.1"
                 data-type="linmod" data-cdlinm="' . $el->cdlinm . '" value="' . ($el->sconto > 0 ? $el->sconto : '') . '"/>&nbsp;%</td>
             </tr>';
                }
                break;
            case 'sermod':
                $array = Sermod::getSeriesWithDiscountFromCatalogs($cttest_keys, $params);
                foreach ($array as $el) {
                    $html .=
                        '<tr>
               <td class="disc-col-cod">' . $el->cdserm . '</td>
               <td class="disc-col-4">' . $el->dsserm . '</td>
               <td class="disc-col-4">' . $el->dslinm . '</td>
               <td class="disc-col-rul"><input type="number" class="disc-input" min="0" max="100" step="0.1"
                 data-type="sermod" data-cdlinm="' . $el->cdlinm . '" data-cdserm="' . $el->cdserm . '" value="' . ($el->sconto > 0 ? $el->sconto : '') . '"/>&nbsp;%</td>
             </tr>';
                }
                break;
            case 'tpmode':
                $array = Tpmode::getModelTypesWithDiscountFromCatalogs($cttest_keys, $params);
                foreach ($array as $el) {
                    $html .=
                        '<tr>
               <td class="disc-col-cod">' . $el->tpmode . '</td>
               <td class="disc-col-3">' . $el->dstmod . '</td>
               <td class="disc-col-rul"><input type="number" class="disc-input" min="0" max="100" step="0.1"
                 data-type="tpmode" data-tpmode="' . $el->tpmode . '"  value="' . ($el->sconto > 0 ? $el->sconto : '') . '"/>&nbsp;%</td>
             </tr>';
                }
                break;
            case 'tipolo':
                $array = Tipolo::getModelsWithDiscountFromCatalogs($cttest_keys, $params);
                foreach ($array as $el) {
                    $html .=
                        '<tr>
              <td class="disc-col-cod">' . $el->cdartn . '</td>
              <td class="disc-col-3">' . $el->dsartn . '</td>
              <td class="disc-col-rul"><input type="number" class="disc-input" min="0" max="100" step="0.1"
                data-type="tipolo" data-cdartn="' . $el->cdartn . '"  value="' . ($el->sconto > 0 ? $el->sconto : '') . '"/>&nbsp;%</td>
            </tr>';
                }
                break;
            case 'anaart':
                $array = Anaart::getArticlesWithDiscountFromCatalogs($cttest_keys, $params);
                foreach ($array as $el) {
                    $html .=
                        '<tr>
               <td class="disc-col-cod">' . $el->cdarti . '</td>
               <td class="disc-col-4">' . $el->dsarti . '</td>
               <td class="disc-col-4">' . $el->dsartn . '</td>
               <td class="disc-col-rul"><input type="number" class="disc-input" min="0" max="100" step="0.1"
                 data-type="anaart" data-cdarti="' . $el->cdarti . '"  value="' . ($el->sconto > 0 ? $el->sconto : '') . '"/>&nbsp;%</td>
             </tr>';
                }
                break;
        }

        return $html;
    }

    private function getHtmlRules($items)
    {
        $html = '';

        foreach ($items as $el) {
            $html .=
                '<tr data-code="' . $el->code . '">
        <td>' . $el->code . '</td>
        <td>' . $el->description . '</td>
        <td><input type="number" class="regqta-qtamin" min="0" step="1" value="' . ($el->ra_qtamin > 0 ? $el->ra_qtamin : '') . '"/></td>
        <td><input type="number" class="regqta-qtamul" min="0" step="1" value="' . ($el->ra_qtamul > 0 ? $el->ra_qtamul : '') . '"/></td>
        <td><input type="number" class="regqtm-qtamin" min="0" step="1" value="' . ($el->rm_qtamin > 0 ? $el->rm_qtamin : '') . '"/></td>
        <td><input type="number" class="regqtm-qtamul" min="0" step="1" value="' . ($el->rm_qtamul > 0 ? $el->rm_qtamul : '') . '"/></td>
      </tr>';
        }

        return $html;
    }

    private function getModalContentForAgentUsersManagement($users, $catalogs)
    {
        $html = '';

        foreach ($users as $user) {
            $catalogsSection = '';
            foreach ($catalogs as $catalog) {
                $checked = false;
                foreach ($user->catalogs as $checkedCatalog) {
                    if ($checkedCatalog->cdcata == $catalog->cdcata) {
                        $checked = true;
                        break;
                    }
                }
                $catalogsSection .=
                    '<div class="col-md-6 col-sm-12 col-xs-12 pt-8x pb-0 px-10x">
            <label class="checkbox-container">
              <input type="checkbox" class="catalog-checkbox"
                name="catalog-checkbox[]" id="checkbox-' . $catalog->cdcata . '" value="' . $catalog->cdcata . '"
                ' . ($checked ? 'checked' : '') . '/> ' . $catalog->dscata .
                    '<span class="checkbox-checkmark"></span>
            </label>
          </div>';
            }

            $html .=
                "<div class='modal-section'>
          <input type='hidden' name='id' value='" . $user->id . "'/>
          <div class='row'>
            <h4 class='center'>" . $this->translate('_common.user') . ": " . $user->username . "</h4>
          </div>
          <div class='row py-10x'>
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>" . $this->translate('session.register.username') . "</div>
            <div class='col-md-4 col-sm-4 col-xs-4'><input type='text' class='form-control' value='" . $user->username . "' name='username' style='width:250px'/></div>
            <div class='col-md-4 col-sm-4 col-xs-4 fs11 modal-edit-password-box'>
              <label class='checkbox-container' style='margin-top:5px'>
                <input type='checkbox' name='edit-password' checked /> " . $this->translate('admin.dontmodifypassword') .
                "<span class='checkbox-checkmark'></span>
              </label>
            </div>
          </div>
          <div class='row pb-10x modal-password-box' style='display:none'>
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>" . $this->translate('session.register.password') . "</div>
            <div class='col-md-8 col-sm-8 col-xs-8'><input type='password' class='form-control' value='' name='password' style='width:250px'/></div>
          </div>
          <div class='row pb-10x modal-repeatpassword-box' style='display:none'>
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>" . $this->translate('session.register.confirmpassword') . "</div>
            <div class='col-md-8 col-sm-8 col-xs-8'><input type='password' class='form-control' value='' name='repeatpassword' style='width:250px'/></div>
          </div>
          <div class='row py-10x'>
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>" . $this->translate('admin.status') . "</div>
            <div class='col-md-8 col-sm-8 col-xs-8'>
              <select name='status' class='form-control " . ($user->enabled ? 'enabled' : 'disabled') . "' style='width:250px'>
                <option value='0' class='disabled' " . ($user->enabled ? '' : 'selected') . ">" . $this->translate('admin.disabled') . "</option>
                <option value='1' class='enabled' " . ($user->enabled ? 'selected' : '') . ">" . $this->translate('admin.enabled') . "</option>
              </select>
            </div>
          </div>
          <div class='row py-10x'>
            <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right' style='margin-top:12px'>" . $this->translate('admin.catalogs') . "</div>
            <div class='col-md-8 col-sm-8 col-xs-8' style='min-height:70px;max-height:135px;overflow-y:auto'>
              <div class='row'>" .
                $catalogsSection .
                "</div>
            </div>
          </div>
          <div class='row pt-10x'>
            <div class='col-md-6 col-sm-6 col-xs-6 right' style='text-transform:capitalize'>
              <button type='button' class='btn btn-primary save-user m-0'>" . $this->translate('_common.save') . "</button>
            </div>
            <div class='col-md-6 col-sm-6 col-xs-6 left'>
              <button type='button' class='btn btn-default delete-user m-0 " . ($user->tot_orders > 0 ? 'disabled' : '') . "' " . ($user->tot_orders > 0 ? 'disabled title="' . $this->translate('admin.agents.warning.delete') . '"' : '') . " style='text-transform:capitalize!important'>" .
                $this->translate('_common.delete') .
                "</button>
            </div>
          </div>
          <div class='row pb-10x'>
            <div class='col-md-12 col-sm-12 col-xs-12 center'>
              <div class='msg-form-error center' style='float:none'></div>
              <div class='msg-error center' style='float:none'>" . $this->translate('_common.generic.db.error') . "</div>
              <div class='msg-success center' style='float:none'>" . $this->translate('_common.generic.db.success') . "</div>
            </div>
          </div>
        </div>";
        }

        return $html;
    }

    private function getModalContentForNewAgentUser($catalogs)
    {
        $html = '';

        $catalogsSection = '';
        foreach ($catalogs as $catalog) {
            $catalogsSection .=
                '<div class="col-md-6 col-sm-12 col-xs-12 pt-8x pb-0 px-10x">
          <label class="checkbox-container">
            <input type="checkbox" class="catalog-checkbox" name="catalog-checkbox[]" id="checkbox-' . $catalog->cdcata . '" value="' . $catalog->cdcata . '"/> ' . $catalog->dscata .
                '<span class="checkbox-checkmark"></span>
          </label>
        </div>';
        }

        $html .=
            "<div class='modal-section'>
        <input type='hidden' name='id' value='-1'/>
        <div class='row'>
          <h4 class='center'>" . $this->translate('admin.agents.newuser') . "</h4>
        </div>
        <div class='row py-10x'>
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>" . $this->translate('session.register.username') . "</div>
          <div class='col-md-8 col-sm-8 col-xs-8'><input type='text' class='form-control' value='' name='username' style='width:250px'/></div>
          <input type='checkbox' name='edit-password' style='display:none'/>
        </div>
        <div class='row pb-10x modal-password-box'>
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>" . $this->translate('session.register.password') . "</div>
          <div class='col-md-8 col-sm-8 col-xs-8'><input type='password' class='form-control' value='' name='password' style='width:250px'/></div>
        </div>
        <div class='row pb-10x modal-repeatpassword-box'>
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>" . $this->translate('session.register.confirmpassword') . "</div>
          <div class='col-md-8 col-sm-8 col-xs-8'><input type='password' class='form-control' value='' name='repeatpassword' style='width:250px'/></div>
        </div>
        <div class='row py-10x'>
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right mt-10x'>" . $this->translate('admin.status') . "</div>
          <div class='col-md-8 col-sm-8 col-xs-8'>
            <select name='status' class='form-control disabled' style='width:250px'>
              <option value='0' class='disabled' selected>" . $this->translate('admin.disabled') . "</option>
              <option value='1' class='enabled'>" . $this->translate('admin.enabled') . "</option>
            </select>
          </div>
        </div>
        <div class='row py-10x'>
          <div class='col-md-4 col-sm-4 col-xs-4 modal-section-title right' style='margin-top:12px'>" . $this->translate('admin.catalogs') . "</div>
          <div class='col-md-8 col-sm-8 col-xs-8' style='min-height:70px;max-height:135px;overflow-y:auto'>
            <div class='row'>" .
            $catalogsSection .
            "</div>
          </div>
        </div>
        <div class='row pt-10x'>
          <div class='col-md-12 col-sm-12 col-xs-12 center'>
            <button type='button' class='btn btn-primary save-user m-0'>" . $this->translate('_common.save') . "</button>
          </div>
        </div>
        <div class='row pb-10x'>
          <div class='col-md-12 col-sm-12 col-xs-12 center'>
            <div class='msg-form-error center' style='float:none'></div>
            <div class='msg-error center' style='float:none'>" . $this->translate('_common.generic.db.error') . "</div>
            <div class='msg-success center' style='float:none'>" . $this->translate('_common.generic.db.success') . "</div>
          </div>
        </div>
      </div>";

        return $html;
    }

    private function getModalContentForCustomerShippingsManagement($shippings, $ananaz, $anazon)
    {
        $html = '';

        foreach ($shippings as $shipping) {
            $countryOptions = '';
            foreach ($ananaz as $country) {
                $countryOptions .= '<option value="' . $country->cdnazi . '" ' . ($country->cdnazi == $shipping->cdnazi ? 'selected' : '') . '>' . $country->dsnazi . '</option>';
            }

            $zoneOptions = '';
            foreach ($anazon as $zone) {
                $zoneOptions .= '<option value="' . $zone->cdzona . '" ' . ($zone->cdzona == $shipping->cdzona ? 'selected' : '') . '>' . $zone->dszona . '</option>';
            }

            $html .=
                "<div class='modal-section'>
          <input type='hidden' name='cddesm' value='$shipping->cddesm'/>
          <div class='row'>
            <h4 class='center'>" . $this->translate('_common.shipping') . ": " . $shipping->descri . "</h4>
          </div>
          <div class='row py-10x'>
            <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('_common.description') . " <span style='color:red'>*</span></div>
            <div class='fl w-90'><input type='text' class='form-control' value='$shipping->descri' name='descri' style='width:350px'/></div>
          </div>
          <div class='row py-10x'>
            <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.address') . " <span style='color:red'>*</span></div>
            <div class='fl w-25'><input type='text' class='form-control' value='$shipping->indiri' name='indiri' style='width:250px'/></div>
            <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.capzip') . "</div>
            <div class='fl w-10'><input type='text' class='form-control' value='$shipping->codcap' name='codcap' style='width:250px'/></div>
            <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.city') . " <span style='color:red'>*</span></div>
            <div class='fl w-20'><input type='text' class='form-control' value='$shipping->ccitta' name='ccitta' style='width:250px'/></div>
            <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.province') . "</div>
            <div class='fl w-5'><input type='text' class='form-control' value='$shipping->provin' name='provin' style='width:250px'/></div>
          </div>
          <div class='row py-10x'>
            <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.country') . "</div>
            <div class='fl w-25'>
              <select class='select2_singel form-control' name='cdnazi' style='width:250px'>
                <option value=''></option>
                $countryOptions
              </select>
            </div>
            <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.zone') . "</div>
            <div class='fl w-25'>
              <select class='select2_singel form-control' name='cdzona' style='width:250px'>
                <option value=''></option>
                $zoneOptions
              </select>
            </div>
            <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('admin.status') . "</div>
            <div class='fl w-20'>
              <select class='select2_singel form-control' name='cdblco' style='width:250px'>
                <option value='0' " . ($shipping->cdblco == 0 ? 'selected' : '') . ">" . $this->translate('admin.enabled') . "</option>
                <option value='1' " . ($shipping->cdblco == 1 ? 'selected' : '') . ">" . $this->translate('admin.disabled') . "</option>
              </select>
            </div>
          </div>
          <div class='row py-10x'>
            <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.telephone') . "</div>
            <div class='fl w-25'><input type='text' class='form-control' value='$shipping->numtel' name='numtel' style='width:250px'/></div>
            <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.mobilephone') . "</div>
            <div class='fl w-25'><input type='text' class='form-control' value='$shipping->numcel' name='numcel' style='width:250px'/></div>
            <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.fax') . "</div>
            <div class='fl w-20'><input type='text' class='form-control' value='$shipping->numfax' name='numfax' style='width:250px'/></div>
          </div>
          <div class='row pt-10x'>
            <div class='col-md-12 col-sm-12 col-xs-12 center'>
              <button type='button' class='btn btn-primary save-shipping m-0'>" . $this->translate('_common.save') . "</button>
            </div>
          </div>
          <div class='row pb-10x'>
            <div class='col-md-12 col-sm-12 col-xs-12 center'>
              <div class='msg-form-error center' style='float:none'></div>
              <div class='msg-error center' style='float:none'>" . $this->translate('_common.generic.db.error') . "</div>
              <div class='msg-success center' style='float:none'>" . $this->translate('_common.generic.db.success') . "</div>
            </div>
          </div>
        </div>";
        }

        return $html;
    }

    private function getModalContentForNewCustomerShipping($ananaz, $anazon)
    {
        $html = '';

        $countryOptions = '';
        foreach ($ananaz as $country) {
            $countryOptions .= '<option value="' . $country->cdnazi . '">' . $country->dsnazi . '</option>';
        }

        $zoneOptions = '';
        foreach ($anazon as $zone) {
            $zoneOptions .= '<option value="' . $zone->cdzona . '">' . $zone->dszona . '</option>';
        }

        $html .=
            "<div class='modal-section'>
        <input type='hidden' name='cddesm' value='-1'/>
        <div class='row'>
          <h4 class='center'>" . $this->translate('admin.customers.newshipping') . "</h4>
        </div>
        <div class='row py-10x'>
          <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('_common.description') . " <span style='color:red'>*</span></div>
          <div class='fl w-90'><input type='text' class='form-control' value='' name='descri' style='width:350px'/></div>
        </div>
        <div class='row py-10x'>
          <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.address') . " <span style='color:red'>*</span></div>
          <div class='fl w-25'><input type='text' class='form-control' value='' name='indiri' style='width:250px'/></div>
          <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.capzip') . "</div>
          <div class='fl w-10'><input type='text' class='form-control' value='' name='codcap' style='width:250px'/></div>
          <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.city') . " <span style='color:red'>*</span></div>
          <div class='fl w-20'><input type='text' class='form-control' value='' name='ccitta' style='width:250px'/></div>
          <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.province') . "</div>
          <div class='fl w-5'><input type='text' class='form-control' value='' name='provin' style='width:250px'/></div>
        </div>
        <div class='row py-10x'>
          <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.country') . "</div>
          <div class='fl w-25'>
            <select class='select2_singel form-control' name='cdnazi' style='width:250px'>
              <option value=''></option>
              $countryOptions
            </select>
          </div>
          <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.zone') . "</div>
          <div class='fl w-25'>
            <select class='select2_singel form-control' name='cdzona' style='width:250px'>
              <option value=''></option>
              $zoneOptions
            </select>
          </div>
          <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('admin.status') . "</div>
          <div class='fl w-20'>
            <select class='select2_singel form-control' name='cdblco' style='width:250px'>
              <option value='0'>" . $this->translate('admin.enabled') . "</option>
              <option value='1'>" . $this->translate('admin.disabled') . "</option>
            </select>
          </div>
        </div>
        <div class='row py-10x'>
          <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.telephone') . "</div>
          <div class='fl w-25'><input type='text' class='form-control' value='' name='numtel' style='width:250px'/></div>
          <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.mobilephone') . "</div>
          <div class='fl w-25'><input type='text' class='form-control' value='' name='numcel' style='width:250px'/></div>
          <div class='fl w-10 pr-20x modal-section-title right mt-10x'>" . $this->translate('account.customer.fax') . "</div>
          <div class='fl w-20'><input type='text' class='form-control' value='' name='numfax' style='width:250px'/></div>
        </div>
        <div class='row pt-10x'>
          <div class='col-md-12 col-sm-12 col-xs-12 center'>
            <button type='button' class='btn btn-primary save-shipping m-0'>" . $this->translate('_common.save') . "</button>
          </div>
        </div>
        <div class='row pb-10x'>
          <div class='col-md-12 col-sm-12 col-xs-12 center'>
            <div class='msg-form-error center' style='float:none'></div>
            <div class='msg-error center' style='float:none'>" . $this->translate('_common.generic.db.error') . "</div>
            <div class='msg-success center' style='float:none'>" . $this->translate('_common.generic.db.success') . "</div>
          </div>
        </div>
      </div>";

        return $html;
    }

    private function getModalContentForVariants($variants)
    {
        $html = '';

        if (count($variants) > 0) {
            $html .= '<div class="col-md-12 bold">' . $this->translate('admin.order.selectvariant') . ':</div>';

            $currentTpvari = '';
            $needClosure = false;
            for ($i = 0; $i < count($variants); $i++) {
                if ($currentTpvari != $variants[$i]['tpvari']) {
                    if ($needClosure) {
                        $html .= '</select>';
                        $html .= '</div>';
                    }
                    $currentTpvari = $variants[$i]['tpvari'];
                    $html .= '<div class="col-md-4 pb-10x text-right" style="line-height:34px">' . $variants[$i]['dstvar'] . '</div>';
                    $html .= '<div class="col-md-6 pb-10x">';
                    $html .= '<select class="select2_single form-control variant-selector" data-tpvari="' . $variants[$i]['tpvari'] . '">';
                    $html .= '<option value=""></option>';
                    $needClosure = true;
                }

                $html .= '<option value="' . $variants[$i]['cdvari'] . '">' . $variants[$i]['cdvari'] . ' - ' . $variants[$i]['dsvari'] . '</option>';
            }
        }

        if ($needClosure) {
            $html .= '</select>';
            $html .= '</div>';
        }

        return $html;
    }

    private function getModalContentForInserQuantityVariants($sizes)
    {
        $html = '';

        if (count($sizes) > 0) {
            $html .= '<div class="col-md-12 bold py-10x">' . $this->translate('admin.order.insertquantity') . ':</div>';
            $width = 100 / count($sizes);
            foreach ($sizes as $size) {
                $html .= '<div class="px-10x" style="float:left;width:' . $width . '%">';
                $html .= '<div style="float:left;width:100%;text-align:center">' . $size->taglia . '</div>';
                $html .= '<div style="float:left;width:100%"><input type="number" style="width:100%" data-dstagl="' . $size->taglia . '" value="" min="0" step="1"/></div>';
                $html .= '</div>';
            }
        }

        return $html;
    }

    private function getCustomMenuWizard($customMenuRows)
    {
        $html = '';

        $html .= '<hr/>';

        $html .= '<div class="row mb-20x">';
        $html .= '<div class="col-md-6">';
        $html .= '<button class="btn btn-primary waves-effect waves-light left-btn" id="add-menu-item">' . $this->translate('admin.custommenu.add') . '</button>';
        $html .= '</div>';
        $html .= '<div class="col-md-6">';
        $html .= '<button class="btn btn-primary waves-effect waves-light right-btn" id="save-custom-menu">' . $this->translate('_common.save') . '</button>';
        $html .= '</div>';
        $html .= '<div class="col-md-12 col-sm-12 col-xs-12">';
        $html .= '<div class="msg-error">' . $this->translate('_common.generic.db.error') . '</div>';
        $html .= '<div class="msg-success">' . $this->translate('_common.generic.db.success') . '</div>';
        $html .= '</div>';
        $html .= '</div>';

        $html .= '<div id="draggable-items-container">';

        foreach ($customMenuRows as $item) {
            switch ($item->tpdato) {
                case 'BR':
                    $fullDescription = $this->translate('_common.brand') . ': ' . $item->br_fulldescr;
                    break;
                case 'LM':
                    $fullDescription = $this->translate('_common.line') . ': ' . $item->lm_fulldescr;
                    break;
                case 'SM':
                    $fullDescription = $this->translate('_common.serie') . ': ' . $item->sm_fulldescr;
                    break;
                case 'TG':
                    $fullDescription = $this->translate('_common.genre') . ': ' . $item->tg_fulldescr;
                    break;
                case 'TM':
                    $fullDescription = $this->translate('_common.modeltype') . ': ' . $item->tm_fulldescr;
                    break;
                case 'SS':
                    $fullDescription = $this->translate('admin.menu.specialselections') . ': ' . $item->ss_fulldescr;
                    break;
            }
            $html .= '<div class="card draggable-card" draggable="true" ';
            $html .= 'data-tpdato="' . $item->tpdato . '" ';
            $html .= 'data-codic1="' . $item->codic1 . '" ';
            $html .= 'data-codic2="' . $item->codic2 . '" ';
            $html .= 'data-des-it="' . $item->des_it . '" ';
            $html .= 'data-des-en="' . $item->des_en . '" ';
            $html .= 'data-des-es="' . $item->des_es . '" ';
            $html .= 'data-des-fr="' . $item->des_fr . '" ';
            $html .= 'data-des-de="' . $item->des_de . '">';
            $html .= '<div class="card-content">';
            $html .= '<button type="button" class="close" title="' . $this->translate('_common.delete') . '"><span aria-hidden="true">×</span></button>';
            $html .= '<p class="column-title" title="' . $fullDescription . '">' . $item->des_it . '</p>';
            $html .= '<div class="checkbox-row">';
            $html .= '<div class="checkbox-container">';
            $html .= '<div class="checkbox-wrapper">';
            $html .= '<input type="checkbox" class="enable-sublevel" ';
            $html .= $item->flsblv == 1 ? 'checked' : '';
            $html .= '><span class="checkbox-checkmark"></span>';
            $html .= '</div>'; // end checkbox-wrapper
            $html .= '<div class="checkbox-text">' . $this->translate('admin.custommenu.enablesublevels') . '</div>';
            $html .= '</div>'; // end checkbox-container
            $html .= '</div>'; // end checkbox-row
            $html .= '<div class="modify-text">' . $this->translate('admin.custommenu.edittext') . '</div>';
            $html .= '</div>';
            $html .= '</div>';
        }

        $html .= '</div>';

        return $html;
    }

    private function getSalesAnalysisCell($class, $width, $x, $y, $type, $content, $inner, $orderable = '', $data = '', $style = '')
    {
        $html = '<div class="fl ' . $class . '" style="width:' . $width . '%;' . $style . '" ' . $data . ' ';
        $html .= 'data-x="' . $x . '" data-y="' . $y . '" ';
        $html .= 'data-type="' . $type . '" data-content="' . $content . '">';

        if ($orderable != '') {
            $html .= '<div class="fl sps-channel" title="' . $inner . '">';
        }
        $html .= $inner;
        if ($orderable != '') {
            $html .= '</div>';
            $html .= '<div class="fr pt-5x">';
            $html .= '<div class="pointer" style="line-height:15px;font-size:15px">';
            $html .= '<i class="fa fa-caret-up" data-field="' . $orderable . '" data-up="1"></i>';
            $html .= '</div>';
            $html .= '<div class="pointer" style="line-height:15px;font-size:15px">';
            $html .= '<i class="fa fa-caret-down" data-field="' . $orderable . '" data-up="0"></i>';
            $html .= '</div>';
            $html .= '</div>';
        }

        $html .= '</div>';
        return $html;
    }

    private function getSalesAnalysis($items, $channels, $title, $isModel)
    {
        $html = '<div class="col-md-6 col-sm-6 col-xs-6 mt-20x bold">' . $title . '</div>';
        $html .= '<div class="col-md-6 col-sm-6 col-xs-6 mt-20x right">';
        $html .= '<button type="button" class="btn btn-default" id="export-xls">' . $this->translate('admin.exportxls') . '</button>';
        $html .= '</div>';
        $totItems = count($items);

        if ($totItems > 0) {
            $imgWidth = 10;
            if ($isModel) {
                $cd1Width = 8;
                $cd2Width = 8;
                $desWidth = 12;
            } else {
                $cd1Width = 12;
                $desWidth = 16;
            }
            $bolWidth = 9;
            $chnWidth = 53 / (count($channels) + 1);
            $totWidth = $chnWidth;

            $html .= '<div class="col-md-12 col-sm-12 col-xs-12 mt-20x">';

            // Header
            $html .= '<div class="row sps-header m-0">';

            $html .= $this->getSalesAnalysisCell('sps-header-cell', $imgWidth, 1, 1, 'hdr', $this->translate('_common.image'), $this->translate('_common.image'));

            $text = $isModel ? $this->translate('_common.model') : $this->translate('_common.article');
            $html .= $this->getSalesAnalysisCell('sps-header-cell', $cd1Width, 2, 1, 'hdr', $text, $text, 'code');

            if ($isModel) {
                $html .= $this->getSalesAnalysisCell('sps-header-cell', $cd2Width, 3, 1, 'hdr', $this->translate('_common.article'), $this->translate('_common.article'), 'arti');
            }

            $html .= $this->getSalesAnalysisCell('sps-header-cell', $desWidth, ($isModel ? 4 : 3), 1, 'hdr', $this->translate('_common.description'), $this->translate('_common.description'));
            $html .= $this->getSalesAnalysisCell('sps-header-cell', $bolWidth, ($isModel ? 5 : 4), 1, 'hdr', 'Bolla', 'Bolla');

            $totals = array();
            for ($i = 0; $i < count($channels); $i++) {
                $channelCode = str_replace(array('-', ' ', '<', '>', '.'), '', $channels[$i]['code']);
                $totals['tot_' . $channelCode] = 0;

                $html .= $this->getSalesAnalysisCell(
                    'sps-header-cell', $chnWidth,
                    (($isModel ? 6 : 5) + $i), 1, 'hdr',
                    $channels[$i]['description'], ($channels[$i]['description'] != '' ? $channels[$i]['description'] : '&nbsp;'),
                    'tot_' . $channelCode
                );
            }

            $totals['tot_ALL'] = 0;
            $html .= $this->getSalesAnalysisCell('sps-header-cell', $totWidth, (($isModel ? 6 : 5) + count($channels)), 1, 'hdr', $this->translate('_common.total'), $this->translate('_common.total'), 'tot_ALL');

            $html .= '</div>';

            $itemsCount = array();
            foreach ($items as $item) {
                if (isset($itemsCount[$item['cdartn']])) {
                    $itemsCount[$item['cdartn']] = $itemsCount[$item['cdartn']] + 1;
                } else {
                    $itemsCount[$item['cdartn']] = 1;
                }
            }

            $globals = array();
            for ($j = 0; $j < count($channels); $j++) {
                $channelCode = str_replace(array('-', ' ', '<', '>', '.'), '', $channels[$j]['code']);
                $globals['tot_' . $channelCode] = 0;
            }
            $globals['tot_ALL'] = 0;

            $html .= '<div id="all-rows-content">';

            // Rows
            if ($isModel) {
                $currentCdartn = '';
                $mustClose = false;
                $firstArticle = false;
                $rowIndex = 2;
                for ($i = 0; $i < $totItems; $i++) {
                    if ($currentCdartn != $items[$i]['cdartn']) {
                        if ($mustClose) {
                            $html .= '</div>'; // Close .sps-all-articles-container

                            // totals cells
                            $html .= $this->getSalesAnalysisCell('sps-tot-cell', $cd1Width, 2, $rowIndex, 'tot', $this->translate('_common.total') . ' ' . $currentCdartn, $this->translate('_common.total'));
                            $html .= $this->getSalesAnalysisCell('sps-tot-cell', $cd2Width, 3, $rowIndex, 'tot', '', '&nbsp;');
                            $html .= $this->getSalesAnalysisCell('sps-tot-cell', $desWidth, 4, $rowIndex, 'tot', '', '&nbsp;');
                            $html .= $this->getSalesAnalysisCell('sps-tot-cell', $bolWidth, 5, $rowIndex, 'tot', '', '&nbsp;');

                            // tot_<channel> totals cells
                            for ($j = 0; $j < count($channels); $j++) {
                                $channelCode = str_replace(array('-', ' ', '<', '>', '.'), '', $channels[$j]['code']);
                                $html .= $this->getSalesAnalysisCell(
                                    'sps-tot-cell sps-tot-value-cell', $chnWidth,
                                    (6 + $j), $rowIndex, 'tot',
                                    $totals['tot_' . $channelCode], $totals['tot_' . $channelCode],
                                    '', 'data-field="tot_' . $channelCode . '" data-value="' . $totals['tot_' . $channelCode] . '" '
                                );
                                $globals['tot_' . $channelCode] += $totals['tot_' . $channelCode];
                                $totals['tot_' . $channelCode] = 0;
                            }

                            // tot_ALL totals cell
                            $html .= $this->getSalesAnalysisCell(
                                'sps-tot-cell sps-tot-value-cell', $chnWidth,
                                (6 + count($channels)), $rowIndex, 'tot',
                                $totals['tot_ALL'], $totals['tot_ALL'],
                                '', 'data-field="tot_ALL" data-value="' . $totals['tot_ALL'] . '" '
                            );
                            $globals['tot_ALL'] += $totals['tot_ALL'];
                            $totals['tot_ALL'] = 0;

                            $html .= '</div>';

                            $mustClose = false;
                            $rowIndex++;
                        }

                        $html .= '<div class="row sps-row m-0" data-code="' . $items[$i]['cdartn'] . '">';

                        $height = max(120, ($itemsCount[$items[$i]['cdartn']] + 1) * 40);

                        // image cell
                        $html .= $this->getSalesAnalysisCell(
                            'sps-row-cell center', $imgWidth,
                            1, $rowIndex, 'img',
                            $this->elements->getModelImageUrl($items[$i]['modelImage']), $this->elements->getModelImgOrDefaultHtml($items[$i]['modelImage'], $items[$i]['dsartn']),
                            '', '', 'height:' . $height . 'px'
                        );

                        $currentCdartn = $items[$i]['cdartn'];
                        $mustClose = true;
                        $firstArticle = true;
                    }

                    // cdartn cell (if needed)
                    if ($firstArticle) {
                        $height = max(80, ($itemsCount[$items[$i]['cdartn']]) * 40);
                        $html .= $this->getSalesAnalysisCell(
                            'sps-row-cell sps-row-inside-cell', $cd1Width,
                            2, $rowIndex, 'cod',
                            $isModel ? $items[$i]['cdartn'] : $items[$i]['cdarti'], '<span>' . ($isModel ? $items[$i]['cdartn'] : $items[$i]['cdarti']) . '</span>',
                            '', '', 'height:' . $height . 'px'
                        );

                        $html .= '<div class="sps-all-articles-container">';
                    }

                    $html .= '<div class="sps-article-row-container" data-code="' . $items[$i]['cdarti'] . '">';

                    // cdarti cell
                    $height = $firstArticle && $itemsCount[$items[$i]['cdartn']] == 1 ? 'height:80px' : 'height:auto';
                    $html .= $this->getSalesAnalysisCell(
                        'sps-row-cell sps-row-inside-cell', $cd2Width,
                        3, $rowIndex, 'txt',
                        $items[$i]['cdarti'], '<span>' . $items[$i]['cdarti'] . '</span>',
                        '', '', $height
                    );
                    // description cell
                    $html .= $this->getSalesAnalysisCell(
                        'sps-row-cell sps-row-inside-cell', $desWidth,
                        4, $rowIndex, 'txt',
                        $items[$i]['dsarti'] != '' ? $items[$i]['dsarti'] : $items[$i]['dsartn'],
                        '<span>' . ($items[$i]['dsarti'] != '' ? $items[$i]['dsarti'] : $items[$i]['dsartn']) . '&nbsp;</span>',
                        '', '', $height
                    );
                    // bolla cell
                    $html .= $this->getSalesAnalysisCell(
                        'sps-row-cell sps-row-inside-cell', $bolWidth,
                        5, $rowIndex, 'txt',
                        $items[$i]['bolla'], '<span>' . $items[$i]['bolla'] . '&nbsp;</span>',
                        '', '', $height
                    );

                    // tot_<channel> cells
                    for ($j = 0; $j < count($channels); $j++) {
                        $channelCode = str_replace(array('-', ' ', '<', '>', '.'), '', $channels[$j]['code']);
                        $totals['tot_' . $channelCode] += $items[$i]['tot_' . $channelCode];
                        $html .= $this->getSalesAnalysisCell(
                            'sps-row-cell sps-row-inside-cell sps-row-value-cell', $chnWidth,
                            (6 + $j), $rowIndex, 'chn',
                            $items[$i]['tot_' . $channelCode], '<span>' . $items[$i]['tot_' . $channelCode] . '</span>',
                            '', 'data-field="tot_' . $channelCode . '" data-value="' . $items[$i]['tot_' . $channelCode] . '" ', $height
                        );
                    }

                    // tot_ALL cell
                    $html .= $this->getSalesAnalysisCell(
                        'sps-row-cell sps-row-inside-cell sps-row-value-cell', $totWidth,
                        (6 + $j), $rowIndex, 'chn',
                        $items[$i]['tot_ALL'], '<span>' . $items[$i]['tot_ALL'] . '</span>',
                        '', 'data-field="tot_ALL" data-value="' . $items[$i]['tot_ALL'] . '" ', $height . ';border-right:0'
                    );
                    $totals['tot_ALL'] += $items[$i]['tot_ALL'];

                    $html .= '</div>'; // close .sps-article-row-container

                    $firstArticle = false;
                    $rowIndex++;
                }

                $html .= '</div>'; // Close last .sps-all-articles-container

                // LAST totals cells
                $html .= $this->getSalesAnalysisCell('sps-tot-cell', $cd1Width, 2, $rowIndex, 'tot', $this->translate('_common.total') . ' ' . $currentCdartn, $this->translate('_common.total'));
                $html .= $this->getSalesAnalysisCell('sps-tot-cell', $cd2Width, 3, $rowIndex, 'tot', '', '&nbsp;');
                $html .= $this->getSalesAnalysisCell('sps-tot-cell', $desWidth, 4, $rowIndex, 'tot', '', '&nbsp;');
                $html .= $this->getSalesAnalysisCell('sps-tot-cell', $bolWidth, 5, $rowIndex, 'tot', '', '&nbsp;');

                // LAST tot_<channel> totals cell
                for ($j = 0; $j < count($channels); $j++) {
                    $channelCode = str_replace(array('-', ' ', '<', '>', '.'), '', $channels[$j]['code']);
                    $globals['tot_' . $channelCode] += $totals['tot_' . $channelCode];
                    $html .= $this->getSalesAnalysisCell(
                        'sps-tot-cell sps-tot-value-cell', $chnWidth,
                        (6 + $j), $rowIndex, 'tot',
                        $totals['tot_' . $channelCode], $totals['tot_' . $channelCode],
                        '', 'data-field="tot_' . $channelCode . '" data-value="' . $totals['tot_' . $channelCode] . '" '
                    );
                }

                // LAST tot_ALL totals cell
                $globals['tot_ALL'] += $totals['tot_ALL'];
                $html .= $this->getSalesAnalysisCell(
                    'sps-tot-cell sps-tot-value-cell', $totWidth,
                    (6 + $j), $rowIndex, 'tot',
                    $totals['tot_ALL'], '<span>' . $totals['tot_ALL'] . '</span>',
                    '', 'data-field="tot_ALL" data-value="' . $totals['tot_ALL'] . '"', 'border-right:0'
                );

                // Close last row
                $html .= '</div>';
            } else {
                $rowIndex = $totItems;
                for ($i = 0; $i < $totItems; $i++) {
                    $html .= '<div class="row sps-row m-0" data-code="' . $items[$i]['cdarti'] . '">';

                    // image cell
                    $html .= $this->getSalesAnalysisCell(
                        'sps-row-cell center', $imgWidth,
                        1, ($i + 2), 'img',
                        $this->elements->getModelImageUrl($items[$i]['articleImage']), $this->elements->getModelImgOrDefaultHtml($items[$i]['articleImage'], $items[$i]['dsarti'])
                    );
                    // cdarti cell
                    $html .= $this->getSalesAnalysisCell(
                        'sps-row-cell sps-row-article-cell', $cd1Width,
                        2, ($i + 2), 'txt',
                        $items[$i]['cdarti'], '<span>' . $items[$i]['cdarti'] . '</span>'
                    );
                    // description cell
                    $html .= $this->getSalesAnalysisCell(
                        'sps-row-cell sps-row-article-cell', $desWidth,
                        3, ($i + 2), 'txt',
                        $items[$i]['dsarti'] != '' ? $items[$i]['dsarti'] : $items[$i]['dsartn'],
                        '<span>' . ($items[$i]['dsarti'] != '' ? $items[$i]['dsarti'] : $items[$i]['dsartn']) . '&nbsp;</span>'
                    );
                    // bolla cell
                    $html .= $this->getSalesAnalysisCell(
                        'sps-row-cell sps-row-article-cell', $bolWidth,
                        4, ($i + 2), 'txt',
                        $items[$i]['bolla'], '<span>' . $items[$i]['bolla'] . '&nbsp;</span>'
                    );

                    // channel cell
                    for ($j = 0; $j < count($channels); $j++) {
                        $channelCode = str_replace(array('-', ' ', '<', '>', '.'), '', $channels[$j]['code']);
                        $globals['tot_' . $channelCode] += $items[$i]['tot_' . $channelCode];
                        $html .= $this->getSalesAnalysisCell(
                            'sps-row-cell sps-row-article-cell sps-row-value-cell', $chnWidth,
                            (5 + $j), ($i + 2), 'chn',
                            $items[$i]['tot_' . $channelCode], '<span>' . $items[$i]['tot_' . $channelCode] . '</span>',
                            '', 'data-field="tot_' . $channelCode . '" data-value="' . $items[$i]['tot_' . $channelCode] . '" '
                        );
                    }
                    // total cell
                    $globals['tot_ALL'] += $items[$i]['tot_ALL'];
                    $html .= $this->getSalesAnalysisCell(
                        'sps-row-cell sps-row-article-cell sps-row-value-cell', $totWidth,
                        (5 + count($channels)), ($i + 2), 'chn',
                        $items[$i]['tot_ALL'], '<span>' . $items[$i]['tot_ALL'] . '</span>',
                        '', 'data-field="tot_ALL' . '" data-value="' . $items[$i]['tot_ALL'] . '" '
                    );

                    $html .= '</div>';
                }
            }

            $html .= '</div>'; // Close #all-rows-content

            // Global total
            $html .= '<div class="row sps-global-tot-row mx-0 mt-20x" style="font-size:14px;color:white">';
            $html .= $this->getSalesAnalysisCell('sps-tot-cell', ($imgWidth + $cd1Width + ($isModel ? $cd2Width : 0) + $desWidth + $bolWidth), 1, $rowIndex + 2, 'tot', $this->translate('_common.total.global'), $this->translate('_common.total.global'), '', '', 'background-color:#606060;');
            for ($j = 0; $j < count($channels); $j++) {
                $channelCode = str_replace(array('-', ' ', '<', '>', '.'), '', $channels[$j]['code']);
                $html .= $this->getSalesAnalysisCell('sps-tot-cell sps-tot-value-cell', $chnWidth, 6 + $j, $rowIndex + 2, 'tot', $globals['tot_' . $channelCode], $globals['tot_' . $channelCode], '', '', 'background-color:#606060;');
            }
            $html .= $this->getSalesAnalysisCell('sps-tot-cell sps-tot-value-cell', $totWidth, 6 + $j, $rowIndex + 2, 'tot', $globals['tot_ALL'], '<span>' . $globals['tot_ALL'] . '</span>', '', '', 'background-color:#606060;');
            $html .= '</div>';
        }

        return $html;
    }

    private function getGalleryBox($gallery)
    {
        $prefix = $this->config->application->baseUri . 'public/upload/galleries/';

        $html = '<div class="col-md-4 col-sm-4 col-xs-12 gallery-box card draggable-card ui-sortable-handle" draggable="true" ';
        $html .= 'id="gallery-' . $gallery->nugall . '" data-code="' . $gallery->nugall . '" ';
        $html .= 'data-des-it="' . $gallery->des_it . '" data-des-en="' . $gallery->des_en . '" ';
        $html .= 'data-des-es="' . $gallery->des_es . '" data-des-de="' . $gallery->des_de . '"  data-des-fr="' . $gallery->des_fr . '">';
        $html .= '<div class="inner-container">';
        $html .= '<button type="button" class="close" title="' . $this->translate('_common.delete') . '" data-toggle="modal" data-target=".modal-delete-gallery">';
        $html .= '<span aria-hidden="true">×</span>';
        $html .= '</button>';
        $html .= '<input type="hidden" class="default-image-path" value="' . $prefix . $gallery->flimag . '">';
        $html .= '<div class="descri" style="font-weight:bold">' . $gallery->descri . '</div>';
        $html .= '<div>';
        $html .= '<img src="' . $prefix . $gallery->flimag . '" style="width:100%;margin-bottom:10px" title="' . $gallery->descri . '">';
        $html .= '</div>';
        $html .= '<div style="margin-bottom:5px">';
        $html .= '<a href="#" class="change-image" data-toggle="modal" data-target=".modal-change-image">' . $this->translate('_common.image.change') . '</a>';
        $html .= '</div>';
        $html .= '<div style="margin-bottom:5px">';
        $html .= '<a href="#" class="change-description" data-toggle="modal" data-target=".modal-change-description">' . $this->translate('_common.description.change') . '</a>';
        $html .= '</div>';
        $html .= '<div>';
        $html .= '<a href="' . $this->url->get('catalog/notablepoints/' . $gallery->nugall) . '">' . $this->translate('admin.galleries.managepoints') . '</a>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '</div>';
        return $html;
    }

    private function getHtmlContentForPdfConditions($catalog, $pdfs)
    {
        $prefix = $this->config->application->baseUri . 'public/upload/pdf/';

        $languages = array(
            array('code' => 'IT', 'description' => $this->translate('_common.lang.it')),
            array('code' => 'EN', 'description' => $this->translate('_common.lang.en')),
            array('code' => 'ES', 'description' => $this->translate('_common.lang.es')),
            array('code' => 'FR', 'description' => $this->translate('_common.lang.fr')),
            array('code' => 'DE', 'description' => $this->translate('_common.lang.de'))
        );
        $languagePdfs = array();

        // Init all language condition pdf to empty string
        foreach ($languages as $language) {
            $languagePdfs[$language['code']] = '';
        }

        // Assign every pdf file path
        foreach ($pdfs as $pdf) {
            $languagePdfs[$pdf->idlang] = $pdf->valore;
        }

        $html = '<div class="x_panel">';

        $html .= '<div class="x_title"><h2>' . $catalog->cdcata . ' - ' . $catalog->dscata . '</h2><div class="clearfix"></div></div>';

        $html .= '<div class="x_content">';

        foreach ($languages as $language) {
            $html .= '<div class="row mb-20x" style="line-height:20px">';

            $html .= '<div class="col-md-4 text-right text-capitalize">';
            $html .= $language['description'];
            $html .= '</div>';

            $html .= '<div class="col-md-8">';
            $html .= '<input type="file" class="pdf-condition fl" ';
            $html .= 'name="' . $language['code'] . '" id="' . $language['code'] . '" data-language="' . $language['code'] . '" accept=".pdf">';
            $html .= '<span id="current-file-' . $language['code'] . '">';
            $html .= $languagePdfs[$language['code']] != '' ? $languagePdfs[$language['code']] : '';
            $html .= '</span>';
            $html .= '<a href="#" class="delete-pdf-condition ml-20x" id="delete-' . $language['code'] . '" ';
            $html .= $languagePdfs[$language['code']] != '' ? '' : ' style="display:none" ';
            $html .= 'data-language="' . $language['code'] . '">';
            $html .= $this->translate('_common.delete');
            $html .= '</a>';

            $html .= '<a class="download-pdf-condition ml-20x" id="download-' . $language['code'] . '" download ';
            if ($languagePdfs[$language['code']] != '') {
                $pdfs = B2bAddinf::getPdfConditionsForCatalog($catalog->cdcata, $language['code']);
                $pdf = count($pdfs) > 0 ? $pdfs[0]->valore : '';
                $html .= ' href="' . $prefix . $pdf . '" ';
            } else {
                $html .= ' href="#" style="display:none" ';
            }
            $html .= '>';
            $html .= $this->translate('_common.downloadtechnicalfile');
            $html .= '</a>';

            $html .= '</div>';

            $html .= '</div>';
        }

        $html .= '</div>';

        $html .= '</div>';

        return $html;
    }
    //endregion

    //region Utility functions
    private function getTrends($dates, $cdstag = -1)
    {
        $phql = '';
        $params = array();
        if ($cdstag != -1) {
            $params['cdstag'] = $cdstag;
            $andWhere = ' AND ot.cdstag = :cdstag ';
        } else {
            $andWhere = '';
        }

        for ($i = 0; $i < count($dates); $i++) {
            if ($i == 0) {
                $phql .= "SELECT COALESCE(SUM(og.quanti), 0) AS qty,
          COALESCE(SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)), 0) AS val,
          DATE_FORMAT(:dtini0, '%d/%m/%Y') AS step
          FROM octagl og
          INNER JOIN occorp oc ON oc.nurorc = og.nurorc
          INNER JOIN octest ot ON ot.nuordc = oc.nuordc
          WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea = :dtini0
          $andWhere";
                $params['dtini0'] = $dates[$i]['dtiniz'];
            } else {
                $phql .= "UNION
          SELECT COALESCE(SUM(og.quanti), 0) AS qty,
          COALESCE(SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)), 0) AS val,
          DATE_FORMAT(:dtfin" . $i . ", '%d/%m/%Y') AS step
          FROM octagl og
          INNER JOIN occorp oc ON oc.nurorc = og.nurorc
          INNER JOIN octest ot ON ot.nuordc = oc.nuordc
          WHERE ot.flstat != 0 AND ot.flstat != 4
          AND ot.dtcrea > :dtini" . $i . " AND ot.dtcrea <= :dtfin" . $i . "
          $andWhere";
                $params['dtini' . $i] = $dates[$i]['dtiniz'];
                $params['dtfin' . $i] = $dates[$i]['dtfine'];
            }
        }
        $result = $this->db->query($phql, $params)->fetchAll();

        return $result;
    }

    private function getTrendsAgents($dates, $cat_where, $age_where, $params)
    {
        $phql = '';
        $cat_where = str_replace(": ", " ", $cat_where);
        $age_where = str_replace(": ", " ", $age_where);

        for ($i = 0; $i < count($dates); $i++) {
            if ($i == 0) {
                $phql .= "SELECT COALESCE(SUM(oc.quanti), 0) AS qty,
          COALESCE(SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)), 0) AS val,
          DATE_FORMAT(:dtini0, '%d/%m/%Y') AS step
          FROM octagl og
          INNER JOIN occorp oc ON oc.nurorc = og.nurorc
          INNER JOIN octest ot ON ot.nuordc = oc.nuordc
          INNER JOIN b2b_usrage ua ON ot.id_usr = ua.id_usr
          WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea = :dtini0
          $cat_where
          $age_where ";
                $params['dtini0'] = $dates[$i]['dtiniz'];
            } else {
                $phql .= "UNION
          SELECT COALESCE(SUM(oc.quanti), 0) AS qty,
          COALESCE(SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)), 0) AS val,
          DATE_FORMAT(:dtfin" . $i . ", '%d/%m/%Y') AS step
          FROM octagl og
          INNER JOIN occorp oc ON oc.nurorc = og.nurorc
          INNER JOIN octest ot ON ot.nuordc = oc.nuordc
          INNER JOIN b2b_usrage ua ON ot.id_usr = ua.id_usr
          WHERE ot.flstat != 0 AND ot.flstat != 4
          AND ot.dtcrea > :dtini" . $i . " AND ot.dtcrea <= :dtfin" . $i . "
          $cat_where
          $age_where ";
                $params['dtini' . $i] = $dates[$i]['dtiniz'];
                $params['dtfin' . $i] = $dates[$i]['dtfine'];
            }
        }
        $result = $this->db->query($phql, $params)->fetchAll();

        return $result;
    }

    private function getTrendsCustomers($dates, $cat_where, $cus_where, $params)
    {
        $phql = '';
        $cat_where = str_replace(": ", " ", $cat_where);
        $cus_where = str_replace(": ", " ", $cus_where);

        for ($i = 0; $i < count($dates); $i++) {
            if ($i == 0) {
                $phql .= "SELECT COALESCE(SUM(oc.quanti), 0) AS qty,
          COALESCE(SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)), 0) AS val,
          DATE_FORMAT(:dtini0, '%d/%m/%Y') AS step
          FROM octagl og
          INNER JOIN occorp oc ON oc.nurorc = og.nurorc
          INNER JOIN octest ot ON ot.nuordc = oc.nuordc
          WHERE ot.flstat != 0 AND ot.flstat != 4 AND ot.dtcrea = :dtini0
          $cat_where
          $cus_where ";
                $params['dtini0'] = $dates[$i]['dtiniz'];
            } else {
                $phql .= "UNION
          SELECT COALESCE(SUM(oc.quanti), 0) AS qty,
          COALESCE(SUM(og.quanti * og.prezzo * (1 - og.scont1 / 100)), 0) AS val,
          DATE_FORMAT(:dtfin" . $i . ", '%d/%m/%Y') AS step
          FROM octagl og
          INNER JOIN occorp oc ON oc.nurorc = og.nurorc
          INNER JOIN octest ot ON ot.nuordc = oc.nuordc
          WHERE ot.flstat != 0 AND ot.flstat != 4
          AND ot.dtcrea > :dtini" . $i . " AND ot.dtcrea <= :dtfin" . $i . "
          $cat_where
          $cus_where ";
                $params['dtini' . $i] = $dates[$i]['dtiniz'];
                $params['dtfin' . $i] = $dates[$i]['dtfine'];
            }
        }
        $result = $this->db->query($phql, $params)->fetchAll();

        return $result;
    }

    private function getParamsForSqlAgents($catalogs, $agents, &$cat_where, &$age_where, &$params)
    {
        if ($catalogs != '') {
            for ($i = 0; $i < count($catalogs); $i++) {
                if ($i != 0) {
                    $cat_where .= ' OR ';
                }
                $cat_where .= 'ot.cdcata = :cdcata' . $i . ': ';
                $params['cdcata' . $i] = $catalogs[$i];
            }
            $cat_where = "AND ($cat_where)";
        }

        if ($agents != '') {
            for ($i = 0; $i < count($agents); $i++) {
                if ($i != 0) {
                    $age_where .= ' OR ';
                }
                $age_where .= 'ua.cdagen = :cdagen' . $i . ': ';
                $params['cdagen' . $i] = $agents[$i];
            }
            $age_where = "AND ($age_where)";
        }
    }

    private function getParamsForSqlCustomers($catalogs, $customers, &$cat_where, &$cus_where, &$params)
    {
        if ($catalogs != '') {
            for ($i = 0; $i < count($catalogs); $i++) {
                if ($i != 0) {
                    $cat_where .= ' OR ';
                }
                $cat_where .= 'ot.cdcata = :cdcata' . $i . ': ';
                $params['cdcata' . $i] = $catalogs[$i];
            }
            $cat_where = "AND ($cat_where)";
        }

        if ($customers != '') {
            for ($i = 0; $i < count($customers); $i++) {
                if ($i != 0) {
                    $cus_where .= ' OR ';
                }
                $cus_where .= 'ot.cdanag = :cdanag' . $i . ': ';
                $params['cdanag' . $i] = $customers[$i];
            }
            $cus_where = "AND ($cus_where)";
        }
    }
    //endregion

    //region Classifications
    public function classificationsAction($currentPath = 'root')
    {
        $success = isset($_GET['s']) ? $_GET['s'] : -1;

        $breadcrumbs = [];

        if (empty($currentPath) || $currentPath == 'root') {
            $currentPath = null;
            $parentId = null;
        } else {
            $path = explode('-', $currentPath);
            $parentId = end($path);

            foreach ($path as $pathElement) {
                $bc = B2bClassificazione::findFirstById($pathElement);
                if ($bc instanceof B2bClassificazione) {
                    $breadcrumbs[] = [
                        'url' => $this->url->get('admin/classifications/' . $bc->id),
                        'label' => $bc->getLabel($this->session->get('language')),
                    ];
                }
            }
        }

        $request = new Request();
        if ($request->isPost() && $request->hasPost('classifications')) {
            $saved = 0;
            $data = $request->getPost('classifications');
            foreach ($data as $id => $datum) {
                if (!empty($datum['slug'])) {
                    $datum['slug'] = preg_replace('/\s/i', '_', trim($datum['slug']));

                    $c = new B2bClassificazione($datum);
                    if (is_numeric($id)) {
                        $c->id = $id;
                    }
                    if (!empty($parentId)) {
                        $c->parent_id = $parentId;
                    }
                    $c->enabled = isset($datum['enabled']) ? 1 : 0;
                    if ($c->save() == false) {
                        $saved++;
                    }
                }
            }

            $success = intval($saved != count($data));
        }

        if ($parentId == null) {
            $classifications = B2bClassificazione::find('parent_id IS NULL');
        } else {
            $classifications = B2bClassificazione::find(['parent_id = :parentId:', 'bind' => ['parentId' => $parentId]]);
        }

        $this->view->setVars($this->getCommonVars());
        $this->view->success = $success;
        $this->view->currentPath = $currentPath;
        $this->view->parentId = $parentId;
        $this->view->breadcrumbs = $breadcrumbs;
        $this->view->classifications = $classifications;
    }

    public function updateClassificationAction()
    {
        $this->view->disable();

        $request = new Request();
        if ($request->isPost() && $request->isAjax()) {
//            $tpanag = $request->getPost('tpanag');

            echo json_encode('OK');
        }
    }
    //endregion

    //region Translation
    public function translateStringsAction($lang = 'it')
    {
        $mainLanguageCode = 'it';
        $lang = strtolower($lang);
        $mainLangTranslationStrings = [];
        if ($lang !== $mainLanguageCode) {
            $mainLangTranslationStrings = $this->getDI()->get('translator')->getTranslatedStrings($mainLanguageCode);
        }

        $translations = [];
        foreach ($this->getDI()->get('translator')->getTranslatedStrings($lang) as $key => $translation) {
            $translations[] = (object)[
                'id' => "$lang-$key",
                'key' => $key,
                'value' => $translation,
                'ml' => $mainLanguageCode,
                'mlv' => $mainLangTranslationStrings[$key] ?: '',
            ];
        }

        $this->view->setVars($this->getCommonVars());
        $this->view->currentLanguage = $lang;
        $this->view->translationStrings = $translations;
    }

    public function searchTranslationStringsAction()
    {
        $this->view->disable();
        $success = $this->getDI()->get('translator')->searchTranslationStrings('both');
        echo json_encode(['success' => $success, 'messages' => ($success ? $this->getDI()->get('i18n')->_('_common.update.success') : $this->getDI()->get('i18n')->_('_common.update.error'))]);
    }

    public function updateTranslationStringAction()
    {
        $this->view->disable();
        $success = false;
        $id = $this->request->getPost('id');
        if (preg_match('/(\w{2})-(.*)/i', $id, $matches)) {
            list($_, $language, $key) = $matches;
            $value = $this->request->getPost('value');
            $success = $this->getDI()->get('translator')->updateTranslatedString($language, $key, $value);
        }
        echo json_encode(['success' => $success, 'messages' => ($success ? $this->getDI()->get('i18n')->_('_common.update.success') : $this->getDI()->get('i18n')->_('_common.update.error'))]);
    }
    //endregion

}
