<?php

use Phalcon\Di\FactoryDefault\Cli as CliDI;
use Phalcon\Cli\Console as ConsoleApp;
use Phalcon\Config\Adapter\Ini as ConfigIni;
use Phalcon\Loader;
use Phalcon\Logger\Adapter\File as FileAdapter;
use Go2B\Tasks\AgingTask;
use Go2B\Tasks\MainTask;
use Go2B\Tasks\OrdersTask;
use Go2B\Tasks\QueueTask;
use Go2B\Tasks\ToolsTask;

//use PHPMailer\PHPMailer\PHPMailer;
//use PHPMailer\PHPMailer\Exception;

error_reporting(E_ALL);

require_once(__DIR__ . '/vendor/autoload.php');

define('APP_PATH', realpath('..') . '/');

/**
 * Read the configuration
 */
$config = new ConfigIni(APP_PATH . 'app/config/config.base.ini');
if (is_readable(APP_PATH . 'app/config/config.ini')) {
    $override = new ConfigIni(APP_PATH . 'app/config/config.ini');
    $config->merge($override);
}
if (is_readable(APP_PATH . 'app/config/config.dev.ini')) {
    $override = new ConfigIni(APP_PATH . 'app/config/config.dev.ini');
    $config->merge($override);
}

$dbupdate = new ConfigIni(APP_PATH . 'app/config/dbupdate.ini');
$config->merge($dbupdate);

$loader = new \Phalcon\Loader();

$loader->registerNamespaces([
    'Go2B\Controllers' => __DIR__ . '/controllers/',
    'Go2B\Models' => __DIR__ . '/models/',
    'Go2B\Library' => __DIR__ . '/library/',
    'Go2B\Tasks' => __DIR__ . '/tasks/',
    'Go2B\Tasks\Sync' => __DIR__ . '/tasks/Sync/',
    'Go2B\Plugins\Nav' =>  __DIR__ . '/plugins/Nav/',
    'Go2B\Plugins' =>  __DIR__ . '/plugins/',

])->register();

function dd(...$data)
{
    var_dump(...$data);
    die();
}

$console = new ConsoleApp();
$di = new CliDI();

$di->get('dispatcher')->setDefaultNamespace('Go2B\Tasks');
$di->get('dispatcher')->setNamespaceName('Go2B\Tasks');

$console->setDI($di);

$di->set('db', function () use ($config) {
    return new \Phalcon\Db\Adapter\Pdo\Mysql(array(
        'host' => $config->database->host,
        'username' => $config->database->username,
        'password' => $config->database->password,
        'dbname' => $config->database->dbname,
        'charset' => 'utf8', // important field
        'options' => array(
            PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8',
            PDO::MYSQL_ATTR_LOCAL_INFILE => true,
            PDO::ATTR_PERSISTENT => 1
        )
    ));
});

$di->set('utility', function () use ($config) {
    return new \Go2B\Controllers\Utility();
});

// Register logger
$di->set('logger', function () use ($config) {
    $targetPath = "./logs/";
    if (!is_dir($targetPath) && !mkdir($targetPath, 0777, true)) {
        die("Error creating folder $targetPath");
    }

    // Trova tutti i file di log presenti nella directory
    $logFiles = glob($targetPath . '*.log');

    // Ordina i file per data di modifica
    usort($logFiles, function ($a, $b) {
        return filemtime($a) < filemtime($b);
    });

    // Rimuovi i file di log che superano il limite massimo
    while (count($logFiles) >= 12) {
        $fileToRemove = array_pop($logFiles);
        unlink($fileToRemove);
    }

    // Crea un nuovo file di log per il mese corrente
    $currentMonthLog = $targetPath . date('Y-m') . '.log';
    if (!file_exists($currentMonthLog)) {
        file_put_contents($currentMonthLog, '');
        chmod($currentMonthLog, 0777);
    }

    $logger = new FileAdapter($currentMonthLog);
    return $logger;
});

$di->set('modelsMetadata', function () use ($config) {
    if (isset($config->models->metadata)) {
        $metaDataConfig = $config->models->metadata;
        $metadataAdapter = '\Phalcon\Mvc\Model\Metadata\\' . $metaDataConfig->adapter;
        return new $metadataAdapter();
    } else {
        return new \Phalcon\Mvc\Model\Metadata\Memory();
    }
});

$di->set('mail', function () use ($config) {
    $mail = new \PHPMailer(true);
    var_dump($mail);
    return $mail; // Passing `true` enables exceptions
});

/*
$di->set('logger', function () use ($config) {
  $targetPath = "../public/logs/";
  if (!is_dir($targetPath) && !mkdir($targetPath, 0777, true)){
    die("Error creating folder $targetPath");
  }
  if (!file_exists('../public/logs/test.log')) {
    file_put_contents('../public/logs/test.log', '');
  }
  $logger = new FileAdapter('../public/logs/test.log');
  return $logger;
});
*/
$di->setShared('config', function () use ($config) {
    return $config;
});

// pass command-line arguments to handle
//$console->handle($_SERVER['argv']);

/**
 * Process the console arguments
 */
$arguments = [];

foreach ($argv as $k => $arg) {
    if ($k === 1) {
        $arguments['task'] = $arg;
    } elseif ($k === 2) {
        $arguments['action'] = $arg;
    } elseif ($k >= 3) {
        $arguments['params'][] = $arg;
    }
}

try {
    echo "CWD: " . getcwd() . "\n";
    // Handle incoming arguments
    $console->handle($arguments);
} catch (\Phalcon\Exception $e) {
    echo $e->getMessage() . "\n";

    exit(255);
}
